/*
 * Decompiled with CFR 0.152.
 */
package com.sas.entities.edit.visuals.servlet;

import com.sas.entities.AttributeDescriptorInterface;
import com.sas.entities.AttributeTypeUtility;
import com.sas.entities.RemoteEntityInterface;
import com.sas.entities.edit.visuals.AttributeValueEditorInterface;
import com.sas.entities.edit.visuals.ComboValueEditorInterface;
import com.sas.entities.edit.visuals.LabelTextInterface;
import com.sas.entities.edit.visuals.ListLabelsInterface;
import com.sas.entities.edit.visuals.ObjectDataMethodInterface;
import com.sas.entities.edit.visuals.servlet.RB;
import com.sas.entities.persist.ConfigurationXMLPersistenceUtility;
import com.sas.entities.persist.ParsedConfigurationXMLObject;
import com.sas.servlet.tbeans.models.Item;
import com.sas.servlet.tbeans.tableview.html.CellContentsChoiceBoxEditor;
import com.sas.servlet.tbeans.tableview.html.DefaultTableCellRenderer;
import com.sas.servlet.tbeans.util.validators.JavaScriptValidationInterface;
import com.sas.util.log.CommonLoggerInterface;
import com.sas.util.log.LoggerRepository2;
import java.lang.reflect.Constructor;
import java.rmi.RemoteException;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.swing.DefaultComboBoxModel;

public class ComboValueEditor
extends CellContentsChoiceBoxEditor
implements AttributeValueEditorInterface,
LabelTextInterface,
ObjectDataMethodInterface,
ComboValueEditorInterface,
ListLabelsInterface {
    public static final String RB_KEY = "ComboValueEditor.";
    protected DefaultComboBoxModel model;
    protected String attributeName;
    protected String noDefaultValueSetString;
    protected String labelText;
    protected Locale locale;
    protected ParsedConfigurationXMLObject xmlObject;
    protected Map valueLabelMap;
    private AttributeDescriptorInterface adi;
    private CommonLoggerInterface log = LoggerRepository2.getLogger((String)ComboValueEditor.class.getPackage().getName(), null);

    public ComboValueEditor() {
        this(null);
    }

    public ComboValueEditor(Locale locale) {
        this.setLocale(locale);
        this.model = new DefaultComboBoxModel();
        this.setModel(this.model);
        this.noDefaultValueSetString = "&ltattribute not set&gt";
        this.noDefaultValueSetString = RB.getStringResource(RB_KEY, "attributeNotSet.pd.txt", this.getLocale());
    }

    public void setEditInfo(RemoteEntityInterface entity, String attributeName) {
        try {
            this.adi = entity.getAttributeGroup().getAttributeDescriptor(attributeName, true);
            Object defaultValue = this.adi.getDefault();
            if (this.adi != null) {
                String configurationXML = this.adi.getConfigurationXML();
                this.labelText = this.adi.getLabel(this.getLocale());
                if (configurationXML != null) {
                    this.xmlObject = ConfigurationXMLPersistenceUtility.createParsedConfigurationXMLObject((String)configurationXML);
                    this.valueLabelMap = this.xmlObject.getEnumerationValuesLabelsMap(this.getLocale());
                    List values = this.xmlObject.getEnumerationValues();
                    int listSize = values.size();
                    Object value = null;
                    for (int i = 0; i < listSize; ++i) {
                        value = values.get(i);
                        if (value == null) {
                            this.model.addElement(new Item(this.getLabelForValue(value, this.getLocale())));
                            continue;
                        }
                        this.model.addElement(new Item(this.getLabelForValue(value, this.getLocale()), value.toString()));
                    }
                    if (defaultValue == null && entity.containsAttributeNamed(this.adi.getName()) && entity.getAttribute(this.adi.getName()) == null) {
                        this.model.insertElementAt(this.noDefaultValueSetString, 0);
                        this.valueLabelMap.put(this.noDefaultValueSetString, this.noDefaultValueSetString);
                    }
                } else if (defaultValue != null) {
                    this.model.addElement(defaultValue);
                }
                List validators = this.adi.getValidators("Servlet");
                if (validators != null && validators.size() > 0) {
                    super.setValidator((JavaScriptValidationInterface)validators.get(0));
                }
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    public Object getEditGUI() {
        return this;
    }

    public Object getRendererGUI() {
        return new DefaultTableCellRenderer();
    }

    public String getNoDefaultValueSetString() {
        return this.noDefaultValueSetString;
    }

    public void setNoDefaultValueSetString(String noDefaultValueSetString) {
        if (noDefaultValueSetString != null) {
            this.noDefaultValueSetString = noDefaultValueSetString;
        }
    }

    public Object getItemSelected() {
        return this.getSelectedItem();
    }

    public Object getValueForLabel(String label) {
        String returnValue = label;
        if (this.valueLabelMap.containsValue(label)) {
            Set entrySet = this.valueLabelMap.entrySet();
            String valueName = null;
            String labelName = null;
            for (Map.Entry entry : entrySet) {
                valueName = (String)entry.getKey();
                labelName = (String)entry.getValue();
                if (!label.equals(labelName)) continue;
                returnValue = valueName;
                break;
            }
        }
        return returnValue;
    }

    public String getLabelForValue(Object value, Locale locale) {
        Object returnValue = this.valueLabelMap.get(value);
        if (returnValue == null) {
            if (value != null) {
                int sqlType = this.adi.getType().getSQLType();
                if (AttributeTypeUtility.wrapperTypeHasStringArgConstructor((int)sqlType)) {
                    try {
                        Class[] stringArgsClass = new Class[]{String.class};
                        Class c = AttributeTypeUtility.getJavaClassToConstruct((int)sqlType, null);
                        Constructor stringArgsConstructor = c.getConstructor(stringArgsClass);
                        Object[] stringArgs = null;
                        Object o = null;
                        List labelValues = this.xmlObject.getEnumerationTextLabels(this.getLocale());
                        int listSize = labelValues.size();
                        for (int i = 0; i < listSize; ++i) {
                            stringArgs = new Object[]{labelValues.get(i).toString()};
                            o = stringArgsConstructor.newInstance(stringArgs);
                            if (!o.toString().equals(value.toString())) continue;
                            return labelValues.get(i).toString();
                        }
                        return value.toString();
                    }
                    catch (Exception e) {
                        return value.toString();
                    }
                }
                return value.toString();
            }
            return null;
        }
        return this.valueLabelMap.get(value).toString();
    }

    public String getLabelText() {
        return this.labelText;
    }

    public void setObjectDataMethod(String[] data) {
        try {
            this.setSelectedItem(data[0]);
        }
        catch (Exception e) {
            this.log.error("", (Throwable)e);
        }
    }
}

