/*
 * Decompiled with CFR 0.152.
 */
package com.sas.actionprovider.util.olap;

import com.sas.actionprovider.ActionSupportFilter;
import com.sas.actionprovider.BaseAction;
import com.sas.actionprovider.HttpAction;
import com.sas.actionprovider.strategies.olap.RB;
import com.sas.actionprovider.util.olap.AxisAreaInterface;
import com.sas.actionprovider.util.olap.HeaderAreaInterface;
import com.sas.actionprovider.util.olap.OLAPActionUtil;
import com.sas.actionprovider.util.olap.TitleAreaInterface;
import com.sas.codepolicy.SASScope;
import com.sas.commands.olap.OLAPCommandUtil;
import com.sas.iquery.metadata.business.DataItem;
import com.sas.iquery.metadata.business.step.StepFilterInterface;
import com.sas.iquery.metadata.business.step.StepInterface;
import com.sas.iquery.metadata.business.step.olap.DataItemNavigationFilter;
import com.sas.servlet.tbeans.ImmutableStyleInfo;
import com.sas.servlet.tbeans.tableview.TableViewActionSupportFilter;
import com.sas.storage.olap.AxisInterface;
import com.sas.storage.olap.OLAPException;
import com.sas.storage.olap.TupleElementInterface;
import com.sas.storage.olap.TupleElementType;
import com.sas.storage.olap.TupleInterface;
import com.sas.text.Message;
import com.sas.util.log.LoggerRepository2;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

@SASScope(value="ALL")
public class HttpOLAPActionUtil
extends OLAPActionUtil {
    static final String RB_KEY = "OLAPStrategy.";
    static final String BLANK_KEY = "Blank";
    private static final HashMap totalsStyleMap = new HashMap();
    private static final HashMap subtotalsStyleMap = new HashMap();

    public Map getNewStyleMap(String areaType, Class strategyClass) {
        return null;
    }

    public String getStringRowIndex(ActionSupportFilter filter) {
        return String.valueOf(((TableViewActionSupportFilter)filter).getRow());
    }

    public String getStringColumnIndex(ActionSupportFilter filter) {
        return String.valueOf(((TableViewActionSupportFilter)filter).getColumn());
    }

    public void initializeMoveMeasureLabelAction(BaseAction action, String areaType, Locale locale) {
        ((HttpAction)action).setLink(false);
    }

    public static int validateDataCellArea(ActionSupportFilter filter) {
        return 0;
    }

    public static int validateTitleArea(ActionSupportFilter filter) {
        if (!filter.getAreaType().equals("COLUMN_TITLE_AREA") && !filter.getAreaType().equals("ROW_TITLE_AREA")) {
            return 64;
        }
        List validValues = filter.getValidAreaValues();
        if (validValues == null || validValues.isEmpty()) {
            return 0;
        }
        return HttpOLAPActionUtil.validateTitle(filter, validValues);
    }

    private static int validateTitle(ActionSupportFilter filter, List validValues) {
        AxisInterface axis = (AxisInterface)filter.getAttribute("axis");
        if (axis == null) {
            return 64;
        }
        String uniqueLevelName = (String)filter.getAttribute("uniqueLevelName");
        if (uniqueLevelName == null) {
            return 64;
        }
        int axisIndex = -1;
        try {
            axisIndex = axis.getAxisNumber();
        }
        catch (OLAPException oe) {
            return 64;
        }
        int num = validValues.size();
        for (int i = 0; i < num; ++i) {
            Object value = validValues.get(i);
            if (!HttpOLAPActionUtil.isValidTitleAreaObject(value) || !HttpOLAPActionUtil.isAxisMatch(axisIndex, (AxisAreaInterface)value) || !HttpOLAPActionUtil.isUniqueLevelNameMatch(uniqueLevelName, (TitleAreaInterface)value)) continue;
            return 0;
        }
        return 64;
    }

    private static boolean isUniqueLevelNameMatch(String currentUniqueLevelName, TitleAreaInterface areaObject) {
        if (currentUniqueLevelName == null) {
            return false;
        }
        String dim = areaObject.getDimension();
        String level = areaObject.getLevel();
        if (dim == null || level == null) {
            return false;
        }
        return currentUniqueLevelName.equalsIgnoreCase("[" + dim + "].[" + level + "]");
    }

    public static int validateHeaderArea(ActionSupportFilter filter) {
        if (!filter.getAreaType().equals("COLUMN_HEADER_AREA") && !filter.getAreaType().equals("ROW_HEADER_AREA")) {
            return 64;
        }
        List validValues = filter.getValidAreaValues();
        if (validValues == null || validValues.isEmpty()) {
            return 0;
        }
        return HttpOLAPActionUtil.validateHeader((TableViewActionSupportFilter)filter, validValues);
    }

    private static int validateHeader(TableViewActionSupportFilter filter, List validValues) {
        AxisInterface axis = (AxisInterface)filter.getAttribute("axis");
        if (axis == null) {
            return 64;
        }
        TupleElementInterface tupleElement = (TupleElementInterface)filter.getAttribute("tupleElement");
        if (tupleElement == null) {
            return 64;
        }
        int axisIndex = -1;
        try {
            axisIndex = axis.getAxisNumber();
        }
        catch (OLAPException oe) {
            return 64;
        }
        int num = validValues.size();
        for (int i = 0; i < num; ++i) {
            Object value = validValues.get(i);
            if (!HttpOLAPActionUtil.isValidHeaderAreaObject(value) || !HttpOLAPActionUtil.isAxisMatch(axisIndex, (AxisAreaInterface)value) || !HttpOLAPActionUtil.isTupleElementMatch(tupleElement, (HeaderAreaInterface)value)) continue;
            return 0;
        }
        return 64;
    }

    private static boolean isTupleElementMatch(TupleElementInterface tupleElement, HeaderAreaInterface areaObject) {
        String dim = areaObject.getDimension();
        String level = areaObject.getLevel();
        if (dim == null) {
            return false;
        }
        try {
            if (level == null) {
                if (HttpOLAPActionUtil.isDimensionMatch(tupleElement, dim)) {
                    return true;
                }
            } else if (tupleElement.getUniqueLevelName().equalsIgnoreCase("[" + dim + "].[" + level + "]")) {
                String member = areaObject.getMember();
                if (member == null) {
                    return true;
                }
                if (member.equals(tupleElement.getLabel())) {
                    return true;
                }
            }
            return false;
        }
        catch (OLAPException e) {
            LoggerRepository2.getLogger((String)HttpOLAPActionUtil.class.getPackage().getName(), null).error(e.getMessage(), (Throwable)e);
            return false;
        }
    }

    private static boolean isDimensionMatch(TupleElementInterface tupleElement, String dimension) {
        return dimension.equals(HttpOLAPActionUtil.getDimension(tupleElement));
    }

    private static String getDimension(TupleElementInterface tupleElement) {
        try {
            String uniqueLevelName = tupleElement.getUniqueLevelName();
            String[] uniqueLevelNames = tupleElement.getTuple().getAxis().getUniqueLevelNames();
            int position = -1;
            for (int i = 0; i < uniqueLevelNames.length; ++i) {
                if (!uniqueLevelName.equals(uniqueLevelNames[i])) continue;
                position = i;
                break;
            }
            if (position >= 0) {
                return tupleElement.getTuple().getAxis().getDimensionNames()[position];
            }
        }
        catch (OLAPException e) {
            LoggerRepository2.getLogger((String)HttpOLAPActionUtil.class.getPackage().getName(), null).error(e.getMessage(), (Throwable)e);
        }
        return null;
    }

    private static boolean isAxisMatch(int currentAxisIndex, AxisAreaInterface areaObject) {
        return currentAxisIndex == areaObject.getAxisNumber();
    }

    private static boolean isValidHeaderAreaObject(Object areaObject) {
        if (areaObject == null) {
            return false;
        }
        return areaObject instanceof HeaderAreaInterface;
    }

    private static boolean isValidTitleAreaObject(Object areaObject) {
        if (areaObject == null) {
            return false;
        }
        return areaObject instanceof TitleAreaInterface;
    }

    private static synchronized void setupDefaultStyleMap() {
        if (totalsStyleMap.size() == 0) {
            totalsStyleMap.put("MENUBAR", new ImmutableStyleInfo("MenubarContainer OLAPTableTotalsHeader"));
            totalsStyleMap.put("MENU", new ImmutableStyleInfo("menu OLAPTableTotalsHeader"));
        }
        if (subtotalsStyleMap.size() == 0) {
            subtotalsStyleMap.put("MENUBAR", new ImmutableStyleInfo("MenubarContainer OLAPTableSubtotalsHeader"));
            subtotalsStyleMap.put("MENU", new ImmutableStyleInfo("menu OLAPTableSubtotalsHeader"));
        }
    }

    public Map getTotalsStyleMap(ActionSupportFilter filter) {
        TupleElementInterface tupleElement = (TupleElementInterface)filter.getAttribute("tupleElement");
        try {
            if (tupleElement.getType() == TupleElementType.TOTAL || tupleElement.getType() == TupleElementType.SUBTOTAL) {
                HttpOLAPActionUtil.setupDefaultStyleMap();
                if (tupleElement.getType() == TupleElementType.TOTAL) {
                    return totalsStyleMap;
                }
                return subtotalsStyleMap;
            }
        }
        catch (OLAPException e) {
            LoggerRepository2.getLogger((String)HttpOLAPActionUtil.class.getPackage().getName(), null).error(e.getMessage(), (Throwable)e);
        }
        return null;
    }

    public String getExpandMemberText(ActionSupportFilter filter) throws OLAPException {
        TupleElementInterface tupleElement = (TupleElementInterface)filter.getAttribute("tupleElement");
        try {
            TupleInterface[] tpls = (TupleInterface[])filter.getAttribute("rowTuples");
            boolean hasChildren = false;
            int parentIndex = tupleElement.getTupleElementIndex() - 1;
            AxisInterface axis = tupleElement.getTuple().getAxis();
            if (axis.getAxisNumber() == 1) {
                tpls = (TupleInterface[])filter.getAttribute("rowTuples");
            } else if (axis.getAxisNumber() == 0) {
                tpls = (TupleInterface[])filter.getAttribute("columnTuples");
            }
            if (parentIndex != -1) {
                for (int i = 0; i < tpls.length && !hasChildren; ++i) {
                    TupleInterface tpl = tpls[i];
                    for (int n = 0; n < tpl.getTupleDepth(); ++n) {
                        DataItem di;
                        List steps;
                        TupleElementInterface te = tpl.getElement(n);
                        if (te.getTupleElementIndex() != tupleElement.getTupleElementIndex() || te.getLevelDepth() != tupleElement.getLevelDepth() || te.getUniqueLevelName() == tupleElement.getUniqueLevelName() || te.getChildCount() <= 0) continue;
                        if (tupleElement.getChildCount() <= 0) {
                            hasChildren = true;
                            return "";
                        }
                        if (tupleElement.getLevelDepth() == 0 && tupleElement.getTuple().getAxis().getTupleCount() > 1) {
                            hasChildren = true;
                            return "";
                        }
                        if (tupleElement.isContextual() && this.isExpandPresent(steps = (di = (DataItem)filter.getAttribute("dataItem")).getSteps(), tupleElement.getName()) < 0) {
                            hasChildren = true;
                            return "";
                        }
                        if (this.isPreSummarizedTotal(tupleElement)) {
                            hasChildren = true;
                            return "";
                        }
                        if (OLAPCommandUtil.hasMoreElements((TupleElementInterface)tupleElement)) continue;
                        hasChildren = true;
                        return "";
                    }
                }
            } else {
                for (int i = 0; i < tpls.length && !hasChildren; ++i) {
                    TupleInterface tpl = tpls[i];
                    for (int n = 0; n < tpl.getTupleDepth(); ++n) {
                        DataItem di;
                        List steps;
                        TupleElementInterface te = tpl.getElement(n);
                        if (te.getChildCount() <= 0) continue;
                        if (tupleElement.getChildCount() <= 0) {
                            hasChildren = true;
                            return "";
                        }
                        if (tupleElement.getLevelDepth() == 0 && tupleElement.getTuple().getAxis().getTupleCount() > 1) {
                            hasChildren = true;
                            return "";
                        }
                        if (tupleElement.isContextual() && this.isExpandPresent(steps = (di = (DataItem)filter.getAttribute("dataItem")).getSteps(), tupleElement.getName()) < 0) {
                            hasChildren = true;
                            return "";
                        }
                        if (this.isPreSummarizedTotal(tupleElement)) {
                            hasChildren = true;
                            return "";
                        }
                        if (OLAPCommandUtil.hasMoreElements((TupleElementInterface)tupleElement)) continue;
                        hasChildren = true;
                        return "";
                    }
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return Message.format((String)RB.getStringResource((String)RB_KEY, (String)"expandMember2.txt", (Locale)filter.getLocale()), (Object)tupleElement.getLabel());
    }

    public String getExpandImageKey(ActionSupportFilter filter) {
        TupleElementInterface tupleElement = (TupleElementInterface)filter.getAttribute("tupleElement");
        try {
            TupleInterface[] tpls = (TupleInterface[])filter.getAttribute("rowTuples");
            boolean hasChildren = false;
            int parentIndex = tupleElement.getTupleElementIndex() - 1;
            AxisInterface axis = tupleElement.getTuple().getAxis();
            if (axis.getAxisNumber() == 1) {
                tpls = (TupleInterface[])filter.getAttribute("rowTuples");
            } else if (axis.getAxisNumber() == 0) {
                tpls = (TupleInterface[])filter.getAttribute("columnTuples");
            }
            if (parentIndex != -1) {
                for (int i = 0; i < tpls.length && !hasChildren; ++i) {
                    TupleInterface tpl = tpls[i];
                    for (int n = 0; n < tpl.getTupleDepth(); ++n) {
                        TupleElementInterface te = tpl.getElement(n);
                        if (te.getTupleElementIndex() != tupleElement.getTupleElementIndex() || te.getLevelDepth() != tupleElement.getLevelDepth() || te.getUniqueLevelName() == tupleElement.getUniqueLevelName() || te.getChildCount() <= 0 || tupleElement.getChildCount() > 0 || tupleElement.getType() == TupleElementType.TOTAL || tupleElement.getType() == TupleElementType.SUBTOTAL) continue;
                        hasChildren = true;
                        return "Blank_12";
                    }
                }
            } else {
                for (int i = 0; i < tpls.length && !hasChildren; ++i) {
                    TupleInterface tpl = tpls[i];
                    for (int n = 0; n < tpl.getTupleDepth(); ++n) {
                        TupleElementInterface te = tpl.getElement(n);
                        if (te.getTupleElementIndex() != tupleElement.getTupleElementIndex() || te.getLevelDepth() != tupleElement.getLevelDepth() || te.getUniqueLevelName() == tupleElement.getUniqueLevelName() || te.getChildCount() <= 0 || tupleElement.getChildCount() > 0 || tupleElement.getType() == TupleElementType.TOTAL || tupleElement.getType() == TupleElementType.SUBTOTAL) continue;
                        hasChildren = true;
                        return "Blank_12";
                    }
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return "Plus_Header_Default";
    }

    public String getExpandRolloverImageKey(ActionSupportFilter filter) {
        TupleElementInterface tupleElement = (TupleElementInterface)filter.getAttribute("tupleElement");
        try {
            TupleInterface[] tpls = (TupleInterface[])filter.getAttribute("rowTuples");
            boolean hasChildren = false;
            int parentIndex = tupleElement.getTupleElementIndex() - 1;
            AxisInterface axis = tupleElement.getTuple().getAxis();
            if (axis.getAxisNumber() == 1) {
                tpls = (TupleInterface[])filter.getAttribute("rowTuples");
            } else if (axis.getAxisNumber() == 0) {
                tpls = (TupleInterface[])filter.getAttribute("columnTuples");
            }
            if (parentIndex != -1) {
                for (int i = 0; i < tpls.length && !hasChildren; ++i) {
                    TupleInterface tpl = tpls[i];
                    for (int n = 0; n < tpl.getTupleDepth(); ++n) {
                        TupleElementInterface te = tpl.getElement(n);
                        if (te.getTupleElementIndex() != tupleElement.getTupleElementIndex() || te.getLevelDepth() != tupleElement.getLevelDepth() || te.getUniqueLevelName() == tupleElement.getUniqueLevelName() || te.getChildCount() <= 0 || tupleElement.getChildCount() > 0 || tupleElement.getType() == TupleElementType.TOTAL || tupleElement.getType() == TupleElementType.SUBTOTAL) continue;
                        hasChildren = true;
                        return "Blank_12";
                    }
                }
            } else {
                for (int i = 0; i < tpls.length && !hasChildren; ++i) {
                    TupleInterface tpl = tpls[i];
                    for (int n = 0; n < tpl.getTupleDepth(); ++n) {
                        TupleElementInterface te = tpl.getElement(n);
                        if (te.getTupleElementIndex() != tupleElement.getTupleElementIndex() || te.getLevelDepth() != tupleElement.getLevelDepth() || te.getUniqueLevelName() == tupleElement.getUniqueLevelName() || te.getChildCount() <= 0 || tupleElement.getChildCount() > 0 || tupleElement.getType() == TupleElementType.TOTAL || tupleElement.getType() == TupleElementType.SUBTOTAL) continue;
                        hasChildren = true;
                        return "Blank_12";
                    }
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return "Plus_Header_Rollover";
    }

    public String getExpandDisabledImageKey(ActionSupportFilter filter) {
        TupleElementInterface tupleElement = (TupleElementInterface)filter.getAttribute("tupleElement");
        try {
            TupleInterface[] tpls = (TupleInterface[])filter.getAttribute("rowTuples");
            boolean hasChildren = false;
            int parentIndex = tupleElement.getTupleElementIndex() - 1;
            AxisInterface axis = tupleElement.getTuple().getAxis();
            if (axis.getAxisNumber() == 1) {
                tpls = (TupleInterface[])filter.getAttribute("rowTuples");
            } else if (axis.getAxisNumber() == 0) {
                tpls = (TupleInterface[])filter.getAttribute("columnTuples");
            }
            if (parentIndex != -1) {
                for (int i = 0; i < tpls.length && !hasChildren; ++i) {
                    TupleInterface tpl = tpls[i];
                    for (int n = 0; n < tpl.getTupleDepth(); ++n) {
                        DataItem di;
                        List steps;
                        TupleElementInterface te = tpl.getElement(n);
                        if (te.getTupleElementIndex() != tupleElement.getTupleElementIndex() || te.getLevelDepth() != tupleElement.getLevelDepth() || te.getUniqueLevelName() == tupleElement.getUniqueLevelName() || te.getChildCount() <= 0) continue;
                        if (tupleElement.getChildCount() <= 0 && tupleElement.getType() != TupleElementType.TOTAL && tupleElement.getType() != TupleElementType.SUBTOTAL) {
                            hasChildren = true;
                            return "Blank_12";
                        }
                        if (tupleElement.getLevelDepth() == 0 && tupleElement.getTuple().getAxis().getTupleCount() > 1 && tupleElement.getType() != TupleElementType.TOTAL && tupleElement.getType() != TupleElementType.SUBTOTAL) {
                            hasChildren = true;
                            return "Blank_12";
                        }
                        if (tupleElement.isContextual() && this.isExpandPresent(steps = (di = (DataItem)filter.getAttribute("dataItem")).getSteps(), tupleElement.getName()) < 0 && tupleElement.getType() != TupleElementType.TOTAL && tupleElement.getType() != TupleElementType.SUBTOTAL) {
                            hasChildren = true;
                            return "Blank_12";
                        }
                        if (this.isPreSummarizedTotal(tupleElement) && tupleElement.getType() != TupleElementType.TOTAL && tupleElement.getType() != TupleElementType.SUBTOTAL) {
                            hasChildren = true;
                            return "Blank_12";
                        }
                        if (OLAPCommandUtil.hasMoreElements((TupleElementInterface)tupleElement) || tupleElement.getType() == TupleElementType.TOTAL || tupleElement.getType() == TupleElementType.SUBTOTAL) continue;
                        hasChildren = true;
                        return "Blank_12";
                    }
                }
            } else {
                for (int i = 0; i < tpls.length && !hasChildren; ++i) {
                    TupleInterface tpl = tpls[i];
                    for (int n = 0; n < tpl.getTupleDepth(); ++n) {
                        DataItem di;
                        List steps;
                        TupleElementInterface te = tpl.getElement(n);
                        if (te.getTupleElementIndex() != tupleElement.getTupleElementIndex() || te.getLevelDepth() != tupleElement.getLevelDepth() || te.getUniqueLevelName() == tupleElement.getUniqueLevelName() || te.getChildCount() <= 0) continue;
                        if (tupleElement.getChildCount() <= 0 && tupleElement.getType() != TupleElementType.TOTAL && tupleElement.getType() != TupleElementType.SUBTOTAL) {
                            hasChildren = true;
                            return "Blank_12";
                        }
                        if (tupleElement.getLevelDepth() == 0 && tupleElement.getTuple().getAxis().getTupleCount() > 1 && tupleElement.getType() != TupleElementType.TOTAL && tupleElement.getType() != TupleElementType.SUBTOTAL) {
                            hasChildren = true;
                            return "Blank_12";
                        }
                        if (tupleElement.isContextual() && this.isExpandPresent(steps = (di = (DataItem)filter.getAttribute("dataItem")).getSteps(), tupleElement.getName()) < 0 && tupleElement.getType() != TupleElementType.TOTAL && tupleElement.getType() != TupleElementType.SUBTOTAL) {
                            hasChildren = true;
                            return "Blank_12";
                        }
                        if (this.isPreSummarizedTotal(tupleElement) && tupleElement.getType() != TupleElementType.TOTAL && tupleElement.getType() != TupleElementType.SUBTOTAL) {
                            hasChildren = true;
                            return "Blank_12";
                        }
                        if (OLAPCommandUtil.hasMoreElements((TupleElementInterface)tupleElement) || tupleElement.getType() == TupleElementType.TOTAL || tupleElement.getType() == TupleElementType.SUBTOTAL) continue;
                        hasChildren = true;
                        return "Blank_12";
                    }
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return "Plus_Header_Inactive";
    }

    public String getDrillDownMemberText(ActionSupportFilter filter) throws OLAPException {
        TupleElementInterface tupleElement = (TupleElementInterface)filter.getAttribute("tupleElement");
        try {
            TupleInterface[] tpls = (TupleInterface[])filter.getAttribute("rowTuples");
            boolean hasChildren = false;
            int parentIndex = tupleElement.getTupleElementIndex() - 1;
            AxisInterface axis = tupleElement.getTuple().getAxis();
            if (axis.getAxisNumber() == 1) {
                tpls = (TupleInterface[])filter.getAttribute("rowTuples");
            } else if (axis.getAxisNumber() == 0) {
                tpls = (TupleInterface[])filter.getAttribute("columnTuples");
            }
            if (parentIndex != -1) {
                for (int i = 0; i < tpls.length && !hasChildren; ++i) {
                    TupleInterface tpl = tpls[i];
                    for (int n = 0; n < tpl.getTupleDepth(); ++n) {
                        DataItem di;
                        List steps;
                        TupleElementInterface te = tpl.getElement(n);
                        if (te.getTupleElementIndex() != tupleElement.getTupleElementIndex() || te.getLevelDepth() != tupleElement.getLevelDepth() || te.getUniqueLevelName() == tupleElement.getUniqueLevelName() || te.getChildCount() <= 0) continue;
                        if (tupleElement.getChildCount() <= 0 || tupleElement.getType() == TupleElementType.TOTAL || tupleElement.getType() == TupleElementType.SUBTOTAL) {
                            hasChildren = true;
                            return "";
                        }
                        if (this.isPreSummarizedTotal(tupleElement)) {
                            hasChildren = true;
                            return "";
                        }
                        if (!tupleElement.isContextual() || this.isExpandPresent(steps = (di = (DataItem)filter.getAttribute("dataItem")).getSteps(), tupleElement.getName()) >= 0) continue;
                        hasChildren = true;
                        return "";
                    }
                }
            } else {
                for (int i = 0; i < tpls.length && !hasChildren; ++i) {
                    TupleInterface tpl = tpls[i];
                    for (int n = 0; n < tpl.getTupleDepth(); ++n) {
                        DataItem di;
                        List steps;
                        TupleElementInterface te = tpl.getElement(n);
                        if (te.getTupleElementIndex() != tupleElement.getTupleElementIndex() || te.getLevelDepth() != tupleElement.getLevelDepth() || te.getUniqueLevelName() == tupleElement.getUniqueLevelName() || te.getChildCount() <= 0) continue;
                        if (tupleElement.getChildCount() <= 0 || tupleElement.getType() == TupleElementType.TOTAL || tupleElement.getType() == TupleElementType.SUBTOTAL) {
                            hasChildren = true;
                            return "";
                        }
                        if (this.isPreSummarizedTotal(tupleElement)) {
                            hasChildren = true;
                            return "";
                        }
                        if (!tupleElement.isContextual() || this.isExpandPresent(steps = (di = (DataItem)filter.getAttribute("dataItem")).getSteps(), tupleElement.getName()) >= 0) continue;
                        hasChildren = true;
                        return "";
                    }
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return Message.format((String)RB.getStringResource((String)RB_KEY, (String)"drillDownMember2.txt", (Locale)filter.getLocale()), (Object)tupleElement.getLabel());
    }

    public String getDrillDownImageKey(ActionSupportFilter filter) {
        TupleElementInterface tupleElement = (TupleElementInterface)filter.getAttribute("tupleElement");
        try {
            TupleInterface[] tpls = (TupleInterface[])filter.getAttribute("rowTuples");
            boolean hasChildren = false;
            int parentIndex = tupleElement.getTupleElementIndex() - 1;
            AxisInterface axis = tupleElement.getTuple().getAxis();
            if (axis.getAxisNumber() == 1) {
                tpls = (TupleInterface[])filter.getAttribute("rowTuples");
            } else if (axis.getAxisNumber() == 0) {
                tpls = (TupleInterface[])filter.getAttribute("columnTuples");
            }
            if (parentIndex != -1) {
                for (int i = 0; i < tpls.length && !hasChildren; ++i) {
                    TupleInterface tpl = tpls[i];
                    for (int n = 0; n < tpl.getTupleDepth(); ++n) {
                        TupleElementInterface te = tpl.getElement(n);
                        if (te.getTupleElementIndex() != tupleElement.getTupleElementIndex() || te.getLevelDepth() != tupleElement.getLevelDepth() || te.getUniqueLevelName() == tupleElement.getUniqueLevelName() || te.getChildCount() <= 0) continue;
                        if (tupleElement.getChildCount() <= 0 || tupleElement.getType() == TupleElementType.TOTAL || tupleElement.getType() == TupleElementType.SUBTOTAL) {
                            if (tupleElement.getType() == TupleElementType.TOTAL || tupleElement.getType() == TupleElementType.SUBTOTAL) continue;
                            hasChildren = true;
                            return "Blank_12";
                        }
                        if (!this.isPreSummarizedTotal(tupleElement) || tupleElement.getType() == TupleElementType.TOTAL || tupleElement.getType() == TupleElementType.SUBTOTAL) continue;
                        hasChildren = true;
                        return "Blank_12";
                    }
                }
            } else {
                for (int i = 0; i < tpls.length && !hasChildren; ++i) {
                    TupleInterface tpl = tpls[i];
                    for (int n = 0; n < tpl.getTupleDepth(); ++n) {
                        TupleElementInterface te = tpl.getElement(n);
                        if (te.getTupleElementIndex() != tupleElement.getTupleElementIndex() || te.getLevelDepth() != tupleElement.getLevelDepth() || te.getUniqueLevelName() == tupleElement.getUniqueLevelName() || te.getChildCount() <= 0) continue;
                        if (tupleElement.getChildCount() <= 0 || tupleElement.getType() == TupleElementType.TOTAL || tupleElement.getType() == TupleElementType.SUBTOTAL) {
                            if (tupleElement.getType() == TupleElementType.TOTAL || tupleElement.getType() == TupleElementType.SUBTOTAL) continue;
                            hasChildren = true;
                            return "Blank_12";
                        }
                        if (!this.isPreSummarizedTotal(tupleElement) || tupleElement.getType() == TupleElementType.TOTAL || tupleElement.getType() == TupleElementType.SUBTOTAL) continue;
                        hasChildren = true;
                        return "Blank_12";
                    }
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return "Drill_Down_Default";
    }

    public String getDrillDownRolloverImageKey(ActionSupportFilter filter) {
        TupleElementInterface tupleElement = (TupleElementInterface)filter.getAttribute("tupleElement");
        try {
            TupleInterface[] tpls = (TupleInterface[])filter.getAttribute("rowTuples");
            boolean hasChildren = false;
            int parentIndex = tupleElement.getTupleElementIndex() - 1;
            AxisInterface axis = tupleElement.getTuple().getAxis();
            if (axis.getAxisNumber() == 1) {
                tpls = (TupleInterface[])filter.getAttribute("rowTuples");
            } else if (axis.getAxisNumber() == 0) {
                tpls = (TupleInterface[])filter.getAttribute("columnTuples");
            }
            if (parentIndex != -1) {
                for (int i = 0; i < tpls.length && !hasChildren; ++i) {
                    TupleInterface tpl = tpls[i];
                    for (int n = 0; n < tpl.getTupleDepth(); ++n) {
                        TupleElementInterface te = tpl.getElement(n);
                        if (te.getTupleElementIndex() != tupleElement.getTupleElementIndex() || te.getLevelDepth() != tupleElement.getLevelDepth() || te.getUniqueLevelName() == tupleElement.getUniqueLevelName() || te.getChildCount() <= 0) continue;
                        if (tupleElement.getChildCount() <= 0 || tupleElement.getType() == TupleElementType.TOTAL || tupleElement.getType() == TupleElementType.SUBTOTAL) {
                            if (tupleElement.getType() == TupleElementType.TOTAL || tupleElement.getType() == TupleElementType.SUBTOTAL) continue;
                            hasChildren = true;
                            return "Blank_12";
                        }
                        if (!this.isPreSummarizedTotal(tupleElement) || tupleElement.getType() == TupleElementType.TOTAL || tupleElement.getType() == TupleElementType.SUBTOTAL) continue;
                        hasChildren = true;
                        return "Blank_12";
                    }
                }
            } else {
                for (int i = 0; i < tpls.length && !hasChildren; ++i) {
                    TupleInterface tpl = tpls[i];
                    for (int n = 0; n < tpl.getTupleDepth(); ++n) {
                        TupleElementInterface te = tpl.getElement(n);
                        if (te.getTupleElementIndex() != tupleElement.getTupleElementIndex() || te.getLevelDepth() != tupleElement.getLevelDepth() || te.getUniqueLevelName() == tupleElement.getUniqueLevelName() || te.getChildCount() <= 0) continue;
                        if (tupleElement.getChildCount() <= 0 || tupleElement.getType() == TupleElementType.TOTAL || tupleElement.getType() == TupleElementType.SUBTOTAL) {
                            if (tupleElement.getType() == TupleElementType.TOTAL || tupleElement.getType() == TupleElementType.SUBTOTAL) continue;
                            hasChildren = true;
                            return "Blank_12";
                        }
                        if (!this.isPreSummarizedTotal(tupleElement) || tupleElement.getType() == TupleElementType.TOTAL || tupleElement.getType() == TupleElementType.SUBTOTAL) continue;
                        hasChildren = true;
                        return "Blank_12";
                    }
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return "Drill_Down_Rollover";
    }

    public String getDrillDownDisabledImageKey(ActionSupportFilter filter) {
        TupleElementInterface tupleElement = (TupleElementInterface)filter.getAttribute("tupleElement");
        try {
            TupleInterface[] tpls = (TupleInterface[])filter.getAttribute("rowTuples");
            boolean hasChildren = false;
            int parentIndex = tupleElement.getTupleElementIndex() - 1;
            AxisInterface axis = tupleElement.getTuple().getAxis();
            if (axis.getAxisNumber() == 1) {
                tpls = (TupleInterface[])filter.getAttribute("rowTuples");
            } else if (axis.getAxisNumber() == 0) {
                tpls = (TupleInterface[])filter.getAttribute("columnTuples");
            }
            if (parentIndex != -1) {
                for (int i = 0; i < tpls.length && !hasChildren; ++i) {
                    TupleInterface tpl = tpls[i];
                    for (int n = 0; n < tpl.getTupleDepth(); ++n) {
                        DataItem di;
                        List steps;
                        TupleElementInterface te = tpl.getElement(n);
                        if (te.getTupleElementIndex() != tupleElement.getTupleElementIndex() || te.getLevelDepth() != tupleElement.getLevelDepth() || te.getUniqueLevelName() == tupleElement.getUniqueLevelName() || te.getChildCount() <= 0) continue;
                        if (tupleElement.getChildCount() <= 0 || tupleElement.getType() == TupleElementType.TOTAL || tupleElement.getType() == TupleElementType.SUBTOTAL) {
                            if (tupleElement.getType() == TupleElementType.TOTAL || tupleElement.getType() == TupleElementType.SUBTOTAL) continue;
                            hasChildren = true;
                            return "Blank_12";
                        }
                        if (this.isPreSummarizedTotal(tupleElement) && tupleElement.getType() != TupleElementType.TOTAL && tupleElement.getType() != TupleElementType.SUBTOTAL) {
                            hasChildren = true;
                            return "Blank_12";
                        }
                        if (!tupleElement.isContextual() || this.isExpandPresent(steps = (di = (DataItem)filter.getAttribute("dataItem")).getSteps(), tupleElement.getName()) >= 0 || tupleElement.getType() == TupleElementType.TOTAL || tupleElement.getType() == TupleElementType.SUBTOTAL) continue;
                        hasChildren = true;
                        return "Blank_12";
                    }
                }
            } else {
                for (int i = 0; i < tpls.length && !hasChildren; ++i) {
                    TupleInterface tpl = tpls[i];
                    for (int n = 0; n < tpl.getTupleDepth(); ++n) {
                        DataItem di;
                        List steps;
                        TupleElementInterface te = tpl.getElement(n);
                        if (te.getTupleElementIndex() != tupleElement.getTupleElementIndex() || te.getLevelDepth() != tupleElement.getLevelDepth() || te.getUniqueLevelName() == tupleElement.getUniqueLevelName() || te.getChildCount() <= 0) continue;
                        if (tupleElement.getChildCount() <= 0 || tupleElement.getType() == TupleElementType.TOTAL || tupleElement.getType() == TupleElementType.SUBTOTAL) {
                            if (tupleElement.getType() == TupleElementType.TOTAL || tupleElement.getType() == TupleElementType.SUBTOTAL) continue;
                            hasChildren = true;
                            return "Blank_12";
                        }
                        if (this.isPreSummarizedTotal(tupleElement) && tupleElement.getType() != TupleElementType.TOTAL && tupleElement.getType() != TupleElementType.SUBTOTAL) {
                            hasChildren = true;
                            return "Blank_12";
                        }
                        if (!tupleElement.isContextual() || this.isExpandPresent(steps = (di = (DataItem)filter.getAttribute("dataItem")).getSteps(), tupleElement.getName()) >= 0 || tupleElement.getType() == TupleElementType.TOTAL || tupleElement.getType() == TupleElementType.SUBTOTAL) continue;
                        hasChildren = true;
                        return "Blank_12";
                    }
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return "Drill_Down_Inactive";
    }

    private boolean isSameElement(TupleElementInterface tupleElement, TupleInterface prevTuple) throws OLAPException {
        AxisInterface axis;
        int cnt;
        int maxCoordinate;
        int i = 0;
        boolean goToNext = true;
        if (prevTuple != null) {
            int depth = prevTuple.getTupleDepth();
            while (i < depth) {
                TupleElementInterface nextElement;
                if (!(nextElement = prevTuple.getElement(i++)).getName().equals(tupleElement.getName())) continue;
                if (nextElement.isContextual() && !tupleElement.isContextual()) {
                    return true;
                }
                if (!nextElement.isContextual() && !tupleElement.isContextual() && tupleElement.getLevelDepth() == 0) {
                    return true;
                }
                goToNext = false;
            }
        }
        if (goToNext && (maxCoordinate = tupleElement.getMaximumCoordinate()) < (cnt = (axis = tupleElement.getTuple().getAxis()).getTupleCount()) - 1 && maxCoordinate >= 0) {
            TupleInterface nextTuple = axis.getTuple(maxCoordinate + 1);
            int depth = nextTuple.getTupleDepth();
            i = 0;
            while (i < depth) {
                TupleElementInterface nextElement;
                if (!(nextElement = nextTuple.getElement(i++)).getName().equals(tupleElement.getName())) continue;
                if (nextElement.isContextual() && !tupleElement.isContextual()) {
                    return true;
                }
                if (nextElement.isContextual() || tupleElement.isContextual() || tupleElement.getLevelDepth() != 0) continue;
                return true;
            }
        }
        return false;
    }

    protected boolean isPreSummarizedTotal(TupleElementInterface tupleElement) throws OLAPException {
        int minCoordinate = tupleElement.getMinimumCoordinate();
        AxisInterface axis = tupleElement.getTuple().getAxis();
        int cnt = axis.getTupleCount();
        if (minCoordinate >= 0 && minCoordinate < cnt) {
            TupleInterface prevTuple = null;
            if (minCoordinate > 0) {
                prevTuple = axis.getTuple(minCoordinate - 1);
            }
            return this.isSameElement(tupleElement, prevTuple);
        }
        return false;
    }

    protected int isExpandPresent(List steps, String elementName) {
        if (steps != null && steps.size() > 0) {
            int lastStepIndex;
            for (int i = lastStepIndex = steps.size() - 1; i >= 0; --i) {
                StepInterface lastStep = (StepInterface)steps.get(i);
                if (!(lastStep instanceof DataItemNavigationFilter)) continue;
                int actionType = ((StepFilterInterface)lastStep).getActionType();
                if (((DataItemNavigationFilter)lastStep).getNavigationFilterType() == 4 && actionType == 6 && elementName.equals(((DataItemNavigationFilter)lastStep).getNavigationName())) {
                    return i;
                }
                if (actionType == 0) break;
            }
        }
        return -1;
    }
}

