/*
 * Decompiled with CFR 0.152.
 */
package com.sas.actionprovider.support.tableview;

import com.sas.actionprovider.ActionList;
import com.sas.actionprovider.ActionOrderList;
import com.sas.actionprovider.ActionProviderMapPool;
import com.sas.actionprovider.ActionSupportFilter;
import com.sas.actionprovider.Area;
import com.sas.actionprovider.BaseAction;
import com.sas.actionprovider.SelectorAction;
import com.sas.actionprovider.strategies.ActionStrategyInterface;
import com.sas.actionprovider.strategies.relational.HttpRelationalActionStrategyFactory;
import com.sas.actionprovider.support.dataselectors.HttpMenuBarActionFactory;
import com.sas.actionprovider.support.tableview.BaseTableViewSupport;
import com.sas.actionprovider.support.tableview.HttpRelationalActionTypeKeysInterface;
import com.sas.actionprovider.support.tableview.RB;
import com.sas.actionprovider.util.relational.HttpRelationalActionUtil;
import com.sas.servlet.tbeans.tableview.BaseTableView;
import com.sas.servlet.tbeans.tableview.TableColumn;
import com.sas.servlet.tbeans.tableview.TableViewActionSupportFilter;
import com.sas.servlet.tbeans.tableview.html.HtmlTableViewUtil;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.swing.table.TableModel;

public class HttpTableViewSupport
extends BaseTableViewSupport
implements HttpRelationalActionTypeKeysInterface {
    private static HttpRelationalActionUtil util = null;
    private static HashSet selectorActionTypes;

    public HttpTableViewSupport(Class actionClass) {
        super(actionClass);
    }

    protected void registerDynamicValueInfo() {
        super.registerDynamicValueInfo();
        this.addDynamicValueInfo("COLUMN_HEADER_AREA", "areaValue", "getAreaValue", (Object)util, null, false);
        this.addDynamicValueInfo("COLUMN_HEADER_AREA", "column", null, null, "modelColumn", false);
        this.addDynamicValueInfo("COLUMN_HEADER_AREA", "viewerColumn", null, null, "column", false);
        this.addDynamicValueInfo("COLUMN_HEADER_AREA", "modelColumn", null, null, null, false);
        this.addDynamicValueInfo("COLUMN_HEADER_AREA", "columnName", null, null, null, false);
        this.addDynamicValueInfo("COLUMN_HEADER_AREA", "moveColumnInterface", null, null, null, false);
        this.addDynamicValueInfo("COLUMN_HEADER_AREA", "moveColumn", null, null, null, false);
        this.addDynamicValueInfo("DATA_CELL_AREA", "row", null, null, "modelRow", false);
        this.addDynamicValueInfo("DATA_CELL_AREA", "viewerRow", null, null, "row", false);
        this.addDynamicValueInfo("DATA_CELL_AREA", "column", null, null, "modelColumn", false);
        this.addDynamicValueInfo("DATA_CELL_AREA", "viewerColumn", null, null, "column", false);
        this.addDynamicValueInfo("DATA_CELL_AREA", "areaValue", "getAreaValue", (Object)util, null, false);
        this.addDynamicValueInfo("EDIT_COLUMN_AREA", "row", null, null, null, false);
        this.addDynamicValueInfo("EDIT_ROW_AREA", "row", null, null, null, false);
    }

    protected void createDefaultActions() {
        super.createDefaultActions();
        this.registerColumnHeaderActions("COLUMN_HEADER_AREA");
        this.setActionOrderList(this.getColumnHeaderOrderList(), null, "COLUMN_HEADER_AREA");
        this.registerEditColumnActions("EDIT_COLUMN_AREA");
        this.setActionOrderList(this.getEditColumnOrderList(), null, "EDIT_COLUMN_AREA");
        this.registerEditRowActions("EDIT_ROW_AREA");
        this.setActionOrderList(this.getEditRowOrderList(), null, "EDIT_ROW_AREA");
    }

    protected void registerColumnHeaderActions(String areaType) {
        this.createAndRegisterAction(areaType, "COLUMN_HEADER_ACTION");
        this.createAndRegisterAction(areaType, "SORT_COLUMN_ASCENDING_ACTION");
        this.createAndRegisterAction(areaType, "SORT_COLUMN_DESCENDING_ACTION");
        this.createAndRegisterAction(areaType, "CLEAR_SORT_ACTION");
        this.createAndRegisterAction(areaType, "MOVE_COLUMN_LEFT_ACTION");
        this.createAndRegisterAction(areaType, "MOVE_COLUMN_RIGHT_ACTION");
        this.createAndRegisterAction(areaType, "SORT_COLUMN_ASCENDING_EDIT_ENABLED_ACTION");
        this.createAndRegisterAction(areaType, "SORT_COLUMN_DESCENDING_EDIT_ENABLED_ACTION");
        this.createAndRegisterAction(areaType, "CLEAR_SORT_EDIT_ENABLED_ACTION");
        this.createAndRegisterAction(areaType, "MOVE_COLUMN_LEFT_EDIT_ENABLED_ACTION");
        this.createAndRegisterAction(areaType, "MOVE_COLUMN_RIGHT_EDIT_ENABLED_ACTION");
        this.createAndRegisterAction(areaType, "RESIZE_COLUMN_ACTION");
        this.createAndRegisterAction(areaType, "SIMPLE_CALCULATED_ITEM_SELECTOR_ACTION");
        this.createAndRegisterAction(areaType, "ADVANCED_FILTER_SELECTOR_ACTION");
        this.createAndRegisterAction(areaType, "RANKING_ACTION");
        this.createAndRegisterAction(areaType, "TOTALS_ACTION");
        this.createAndRegisterAction(areaType, "PERCENT_CALCULATIONS_SELECTOR_ACTION");
        this.createAndRegisterAction(areaType, "DATAITEM_SELECTOR_ACTION");
        this.createAndRegisterAction(areaType, "EXCEPTION_HIGHLIGHTING_SELECTOR_ACTION");
        this.createAndRegisterAction(areaType, "FORMAT_ACTION");
        this.createAndRegisterAction(areaType, "EXPORT_TO_ACTION");
    }

    protected ActionOrderList getColumnHeaderOrderList() {
        ActionOrderList sortAOL = new ActionOrderList(RB.getStringResource((String)"BaseTableViewSupport.", (String)"sortLabel.txt", (Locale)this.getLocale()), 3);
        sortAOL.setEnabledIfEmpty(false);
        sortAOL.add((Object)"SORT_COLUMN_ASCENDING_ACTION");
        sortAOL.add((Object)"SORT_COLUMN_DESCENDING_ACTION");
        sortAOL.add((Object)"CLEAR_SORT_ACTION");
        sortAOL.add((Object)"SORT_COLUMN_ASCENDING_EDIT_ENABLED_ACTION");
        sortAOL.add((Object)"SORT_COLUMN_DESCENDING_EDIT_ENABLED_ACTION");
        sortAOL.add((Object)"CLEAR_SORT_EDIT_ENABLED_ACTION");
        ActionOrderList moveColumnAOL = new ActionOrderList(RB.getStringResource((String)"BaseTableViewSupport.", (String)"moveColumnLabel.txt", (Locale)this.getLocale()), 2);
        moveColumnAOL.setEnabledIfEmpty(false);
        moveColumnAOL.add((Object)"MOVE_COLUMN_LEFT_ACTION");
        moveColumnAOL.add((Object)"MOVE_COLUMN_RIGHT_ACTION");
        moveColumnAOL.add((Object)"MOVE_COLUMN_LEFT_EDIT_ENABLED_ACTION");
        moveColumnAOL.add((Object)"MOVE_COLUMN_RIGHT_EDIT_ENABLED_ACTION");
        ActionOrderList columnHeaderAOL = new ActionOrderList(RB.getStringResource((String)"BaseTableViewSupport.", (String)"columnHeaderLabel.txt", (Locale)this.getLocale()), 3);
        columnHeaderAOL.setActionType("COLUMN_HEADER_ACTION");
        columnHeaderAOL.setEnabledIfEmpty(false);
        columnHeaderAOL.add((Object)sortAOL);
        columnHeaderAOL.add((Object)moveColumnAOL);
        columnHeaderAOL.add(ActionList.SEPARATOR);
        columnHeaderAOL.add((Object)"SIMPLE_CALCULATED_ITEM_SELECTOR_ACTION");
        columnHeaderAOL.add((Object)"EXCEPTION_HIGHLIGHTING_SELECTOR_ACTION");
        columnHeaderAOL.add((Object)"ADVANCED_FILTER_SELECTOR_ACTION");
        columnHeaderAOL.add((Object)"RANKING_ACTION");
        columnHeaderAOL.add((Object)"TOTALS_ACTION");
        columnHeaderAOL.add((Object)"PERCENT_CALCULATIONS_SELECTOR_ACTION");
        columnHeaderAOL.add((Object)"DATAITEM_SELECTOR_ACTION");
        columnHeaderAOL.add((Object)"FORMAT_ACTION");
        columnHeaderAOL.add(ActionList.SEPARATOR);
        columnHeaderAOL.add((Object)"EXPORT_TO_ACTION");
        ActionOrderList columnHeaderRootAOL = new ActionOrderList("ROOT_NAME", 3);
        columnHeaderRootAOL.add((Object)columnHeaderAOL);
        return columnHeaderRootAOL;
    }

    protected void registerEditColumnActions(String areaType) {
        this.createAndRegisterAction(areaType, "INSERT_ACTION");
        this.createAndRegisterAction(areaType, "DELETE_ACTION");
        this.createAndRegisterAction(areaType, "COMMIT_ACTION");
        this.createAndRegisterAction(areaType, "CANCEL_ACTION");
        this.createAndRegisterAction(areaType, "UPDATE_ACTION");
    }

    protected ActionOrderList getEditColumnOrderList() {
        ActionOrderList editColumnAOL = new ActionOrderList("ROOT_NAME", 5);
        editColumnAOL.add((Object)"UPDATE_ACTION");
        editColumnAOL.add((Object)"COMMIT_ACTION");
        editColumnAOL.add((Object)"CANCEL_ACTION");
        editColumnAOL.add((Object)"INSERT_ACTION");
        editColumnAOL.add((Object)"DELETE_ACTION");
        return editColumnAOL;
    }

    protected void registerEditRowActions(String areaType) {
        this.createAndRegisterAction(areaType, "INSERT_ACTION");
        this.createAndRegisterAction(areaType, "COMMIT_DELETE_ACTION");
        this.createAndRegisterAction(areaType, "COMMIT_ACTION");
        this.createAndRegisterAction(areaType, "DELETE_ACTION");
        this.createAndRegisterAction(areaType, "CANCEL_ACTION");
    }

    protected ActionOrderList getEditRowOrderList() {
        ActionOrderList editRowAOL = new ActionOrderList("ROOT_NAME", 5);
        editRowAOL.add((Object)"COMMIT_DELETE_ACTION");
        editRowAOL.add((Object)"CANCEL_ACTION");
        editRowAOL.add((Object)"INSERT_ACTION");
        return editRowAOL;
    }

    public BaseAction newActionInstance(String areaType, String actionType) {
        BaseAction action = null;
        Class _actionClass = this.getActionClass();
        if (_actionClass != null) {
            try {
                if (actionType == "SIMPLE_CALCULATED_ITEM_SELECTOR_ACTION" || actionType == "EXCEPTION_HIGHLIGHTING_SELECTOR_ACTION" || actionType == "ADVANCED_FILTER_SELECTOR_ACTION" || actionType == "RANKING_ACTION" || actionType == "TOTALS_ACTION" || actionType == "DATAITEM_SELECTOR_ACTION" || actionType == "EXPORT_TO_ACTION" || actionType == "PERCENT_CALCULATIONS_SELECTOR_ACTION") {
                    action = HttpMenuBarActionFactory.newSelectorActionInstance(actionType, false, this.getLocale());
                    if (actionType.equals("EXPORT_TO_ACTION")) {
                        action.putValue("Name", (Object)RB.getStringResource((String)"BaseTableViewSupport.", (String)"exportToExcelLabel.txt", (Locale)this.getLocale()));
                        action.putValue("SmallIconName", null);
                    }
                    return action;
                }
                action = actionType == "FORMAT_ACTION" ? new SelectorAction() : (BaseAction)_actionClass.newInstance();
            }
            catch (InstantiationException ie) {
                return null;
            }
            catch (IllegalAccessException ie) {
                return null;
            }
            ActionStrategyInterface asi = HttpRelationalActionStrategyFactory.getActionStrategy(areaType, actionType, true);
            if (asi != null) {
                action.setActionStrategy(asi);
                asi.initializeAction(action, areaType, this.getLocale());
            }
            action.setActionType(actionType);
        }
        return action;
    }

    protected Map getActionScopeAttributeMap(String actionType, ActionSupportFilter filter) {
        HashMap actionScopeAttributeMap = ActionProviderMapPool.getMap();
        if (actionType == "SIMPLE_CALCULATED_ITEM_SELECTOR_ACTION" || actionType == "EXCEPTION_HIGHLIGHTING_SELECTOR_ACTION" || actionType == "ADVANCED_FILTER_SELECTOR_ACTION" || actionType == "RANKING_ACTION" || actionType == "TOTALS_ACTION" || actionType == "FORMAT_ACTION" || actionType == "DATAITEM_SELECTOR_ACTION" || actionType == "EXPORT_TO_ACTION" || actionType == "PERCENT_CALCULATIONS_SELECTOR_ACTION") {
            HttpMenuBarActionFactory.getDynamicSelectorAttributes(filter, actionScopeAttributeMap);
        }
        return actionScopeAttributeMap;
    }

    protected Map getAreaScopeAttributeMap(ActionSupportFilter filter) {
        HashMap areaScopeAttributeMap = ActionProviderMapPool.getMap();
        return areaScopeAttributeMap;
    }

    protected Object getActionScopeAttribute(String actionType, String attributeName, ActionSupportFilter filter, Object currentValue) {
        if (selectorActionTypes.contains(actionType) && attributeName != null && attributeName.equals("URLBase")) {
            return HttpMenuBarActionFactory.getDynamicURLBase(actionType, filter, currentValue);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean validArea(Area area, ActionSupportFilter filter) {
        String type = null;
        if (area != null && (type = area.getType()) != null) {
            List values = null;
            if (!type.equals(filter.getAreaType())) {
                return false;
            }
            values = area.getValues();
            if (values == null || values.size() <= 0) {
                return true;
            }
            if (type.equals("COLUMN_HEADER_AREA")) {
                Object c;
                TableModel model = (TableModel)filter.getAttribute("model");
                Integer modelColumnNumber = (Integer)filter.getAttribute("modelColumn");
                String columnName = null;
                if (model != null && modelColumnNumber != null && modelColumnNumber >= 0) {
                    columnName = HtmlTableViewUtil.getColumnName((TableModel)model, (int)modelColumnNumber);
                }
                BaseTableView table = (BaseTableView)filter.getAttribute("table");
                Integer viewerColumnNumber = (Integer)filter.getAttribute("column");
                String columnIdentifier = null;
                String columnHeaderValue = null;
                if (table != null && viewerColumnNumber != null) {
                    c = table.getColumnModel().getColumn(viewerColumnNumber - 1);
                    columnIdentifier = ((TableColumn)c).getIdentifier().toString();
                    columnHeaderValue = ((TableColumn)c).getHeaderValue();
                }
                if (columnName != null || columnIdentifier != null || columnHeaderValue != null) {
                    c = values;
                    synchronized (c) {
                        for (String areaValue : values) {
                            if (areaValue == null || !areaValue.equals(columnName) && !areaValue.equals(columnIdentifier) && !areaValue.equals(columnHeaderValue)) continue;
                            return true;
                        }
                    }
                }
                return false;
            }
            if (type.equals("DATA_CELL_AREA")) {
                TableModel model = (TableModel)filter.getAttribute("model");
                int modelColumnNumber = ((TableViewActionSupportFilter)filter).getModelColumn();
                String columnName = null;
                if (model != null && modelColumnNumber >= 0) {
                    columnName = HtmlTableViewUtil.getColumnName((TableModel)model, (int)modelColumnNumber);
                }
                BaseTableView table = (BaseTableView)filter.getAttribute("table");
                int viewerColumnNumber = ((TableViewActionSupportFilter)filter).getColumn();
                String columnIdentifier = null;
                String columnHeaderValue = null;
                if (table != null) {
                    TableColumn c = table.getColumnModel().getColumn(viewerColumnNumber - 1);
                    columnIdentifier = c.getIdentifier().toString();
                    columnHeaderValue = c.getHeaderValue();
                }
                if (columnName != null || columnIdentifier != null || columnHeaderValue != null) {
                    List list = values;
                    synchronized (list) {
                        for (String areaValue : values) {
                            if (areaValue == null || !areaValue.equals(columnName) && !areaValue.equals(columnIdentifier) && !areaValue.equals(columnHeaderValue)) continue;
                            return true;
                        }
                    }
                }
                return false;
            }
            if (type == "TITLE_AREA") {
                return true;
            }
            return type == "ROW_HEADER_AREA";
        }
        return true;
    }

    protected Map initializeShortActionTypeMap() {
        Map shortActionTypeMap = super.initializeShortActionTypeMap();
        shortActionTypeMap.put("COLUMN_HEADER_ACTION", "_CH");
        shortActionTypeMap.put("CLEAR_SORT_ACTION", "_CS");
        shortActionTypeMap.put("SORT_COLUMN_ASCENDING_ACTION", "_SCA");
        shortActionTypeMap.put("SORT_COLUMN_DESCENDING_ACTION", "_SCD");
        shortActionTypeMap.put("SORT_SELECTOR_ACTION", "_SSEL");
        shortActionTypeMap.put("ADVANCED_FILTER_SELECTOR_ACTION", "_FLSEL");
        shortActionTypeMap.put("EXCEPTION_HIGHLIGHTING_SELECTOR_ACTION", "_EHSEL");
        shortActionTypeMap.put("RANKING_ACTION", "_RSEL");
        shortActionTypeMap.put("TOTALS_ACTION", "_TSEL");
        shortActionTypeMap.put("FORMAT_ACTION", "_FOSEL");
        shortActionTypeMap.put("DATAITEM_SELECTOR_ACTION", "_QSEL");
        shortActionTypeMap.put("SIMPLE_CALCULATED_ITEM_SELECTOR_ACTION", "_CISEL");
        shortActionTypeMap.put("EXPORT_TO_EXCEL_ACTION", "_ETE");
        shortActionTypeMap.put("EXPORT_TO_ACTION", "_ET");
        shortActionTypeMap.put("MOVE_COLUMN_LEFT_ACTION", "_MCL");
        shortActionTypeMap.put("MOVE_COLUMN_RIGHT_ACTION", "_MCR");
        shortActionTypeMap.put("SORT_COLUMN_ASCENDING_EDIT_ENABLED_ACTION", "_SCAEE");
        shortActionTypeMap.put("SORT_COLUMN_DESCENDING_EDIT_ENABLED_ACTION", "_SCDEE");
        shortActionTypeMap.put("CLEAR_SORT_EDIT_ENABLED_ACTION", "_CSEE");
        shortActionTypeMap.put("MOVE_COLUMN_LEFT_EDIT_ENABLED_ACTION", "_MCLEE");
        shortActionTypeMap.put("MOVE_COLUMN_RIGHT_EDIT_ENABLED_ACTION", "_MCREE");
        shortActionTypeMap.put("INSERT_ACTION", "_INS");
        shortActionTypeMap.put("DELETE_ACTION", "_DEL");
        shortActionTypeMap.put("COMMIT_ACTION", "_COM");
        shortActionTypeMap.put("CANCEL_ACTION", "_CAN");
        shortActionTypeMap.put("UPDATE_ACTION", "_UPD");
        shortActionTypeMap.put("COMMIT_DELETE_ACTION", "_COMDEL");
        shortActionTypeMap.put("PERCENT_CALCULATIONS_SELECTOR_ACTION", "_PCSEL");
        return shortActionTypeMap;
    }

    static {
        util = new HttpRelationalActionUtil();
        selectorActionTypes = new HashSet(12, 1.0f);
        selectorActionTypes.add("SIMPLE_CALCULATED_ITEM_SELECTOR_ACTION");
        selectorActionTypes.add("ADVANCED_FILTER_SELECTOR_ACTION");
        selectorActionTypes.add("RANKING_ACTION");
        selectorActionTypes.add("TOTALS_ACTION");
        selectorActionTypes.add("PERCENT_CALCULATIONS_SELECTOR_ACTION");
        selectorActionTypes.add("DATAITEM_SELECTOR_ACTION");
        selectorActionTypes.add("EXCEPTION_HIGHLIGHTING_SELECTOR_ACTION");
        selectorActionTypes.add("FORMAT_ACTION");
        selectorActionTypes.add("EXPORT_TO_ACTION");
    }
}

