/*
 * Decompiled with CFR 0.152.
 */
package com.sas.actionprovider.support.olaptableview;

import com.sas.actionprovider.ActionProviderMapPool;
import com.sas.actionprovider.ActionSupportFilter;
import com.sas.actionprovider.Area;
import com.sas.actionprovider.BaseAction;
import com.sas.actionprovider.HttpAction;
import com.sas.actionprovider.support.olaptableview.BaseOLAPDrillStateSupport;
import com.sas.actionprovider.support.olaptableview.RB;
import com.sas.codepolicy.SASScope;
import com.sas.commands.DynamicAttributeCommandInterface;
import com.sas.commands.olap.DrillDownLevelCommand;
import com.sas.commands.olap.DrillDownMemberNameCommand;
import com.sas.entities.AttributeDescriptorInterface;
import com.sas.entities.AttributeType;
import com.sas.entities.AttributeTypeInterface;
import com.sas.storage.olap.AxisInterface;
import com.sas.storage.olap.OLAPException;
import com.sas.storage.olap.TupleElementInterface;
import com.sas.storage.olap.TupleInterface;
import com.sas.text.Message;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

@SASScope(value="ALL")
public class HttpOLAPDrillStateSupport
extends BaseOLAPDrillStateSupport {
    public HttpOLAPDrillStateSupport(Class actionClass) {
        super(actionClass);
        if (this.debug) {
            System.out.println("HttpOLAPDrillStateSupport(): in constructor");
        }
    }

    public BaseAction newActionInstance(String actionType) {
        return this.newActionInstance(null, actionType);
    }

    public BaseAction newActionInstance(String areaType, String actionType) {
        HttpAction action = null;
        Class _actionClass = this.getActionClass();
        if (this.debug) {
            System.out.println("Class for " + actionType + " is " + _actionClass.getName());
        }
        if (_actionClass != null) {
            try {
                action = (HttpAction)((Object)_actionClass.newInstance());
            }
            catch (InstantiationException ie) {
                return null;
            }
            catch (IllegalAccessException ie) {
                return null;
            }
            if (this.debug) {
                System.out.println("instantiated the action");
            }
            if (actionType == "DRILL_DOWN_MEMBER_ACTION") {
                action.setCommand((DynamicAttributeCommandInterface)new DrillDownMemberNameCommand("Drill down member", false));
            } else if (actionType == "DRILL_TO_LEVEL_ACTION") {
                action.setCommand((DynamicAttributeCommandInterface)new DrillDownLevelCommand("Drill down to level", false));
            } else {
                return null;
            }
            action.setActionType(actionType);
            action.putValue("TextAlignment", "SwingConstants.CENTER");
            this.defineActionAttributes(action, actionType);
        }
        return action;
    }

    protected BaseAction defineActionAttributes(BaseAction action, String actionType) {
        if (action != null) {
            action.setActionType(actionType);
            try {
                if (actionType == "DRILL_DOWN_MEMBER_ACTION" || actionType == "DRILL_TO_LEVEL_ACTION") {
                    action.setAttribute("model", null);
                    AttributeDescriptorInterface descriptor = action.getAttributeDescriptor("model");
                    descriptor.setType((AttributeTypeInterface)new AttributeType("DRILLSTATE_MODEL_INTERFACE", "com.sas.storage.olap.OLAPDataSetInterface"));
                    descriptor.setVisible(false);
                    String uniqueNameAttribute = actionType == "DRILL_DOWN_MEMBER_ACTION" ? "uniqueMemberName" : "uniqueLevelName";
                    action.setAttribute(uniqueNameAttribute, null);
                    descriptor = action.getAttributeDescriptor(uniqueNameAttribute);
                    descriptor.setVisible(true);
                    action.setAttribute("tupleElementIndex", null);
                    descriptor = action.getAttributeDescriptor("tupleElementIndex");
                    descriptor.setVisible(true);
                    descriptor.setModifiable(true);
                    descriptor.setSupplementalProperty("ENCODE", (Object)Boolean.FALSE);
                    action.setAttribute("dataItem", null);
                    descriptor = action.getAttributeDescriptor("dataItem");
                    descriptor.setVisible(false);
                    descriptor.setSupplementalProperty("ENCODE", (Object)Boolean.FALSE);
                    action.setAttribute("tupleIndex", null);
                    descriptor = action.getAttributeDescriptor("tupleIndex");
                    descriptor.setVisible(true);
                    descriptor.setSupplementalProperty("ENCODE", (Object)Boolean.FALSE);
                    action.setAttribute("axisIndex", null);
                    descriptor = action.getAttributeDescriptor("axisIndex");
                    descriptor.setVisible(true);
                    descriptor.setSupplementalProperty("ENCODE", (Object)Boolean.FALSE);
                    action.setAttribute("Name", null);
                    action.setAttribute("ShortDescription", null);
                    descriptor = action.getAttributeDescriptor("link");
                    descriptor.setSupplementalProperty("DYNAMIC", (Object)Boolean.TRUE);
                    descriptor.setSupplementalProperty("ENCODE", (Object)Boolean.FALSE);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return action;
    }

    protected Map getAreaScopeAttributeMap(ActionSupportFilter actionFilter) {
        HashMap areaScopeAttributeMap = ActionProviderMapPool.getMap();
        String areaType = actionFilter.getAreaType();
        if (areaType.equals("DRILL_STATE_AREA")) {
            try {
                areaScopeAttributeMap.put("model", actionFilter.getAttribute("model"));
                TupleElementInterface tupleElement = (TupleElementInterface)actionFilter.getAttribute("tupleElement");
                int tupleElementIndex = tupleElement.getTupleElementIndex();
                areaScopeAttributeMap.put("tupleElementIndex", String.valueOf(tupleElementIndex));
                areaScopeAttributeMap.put("dataItem", actionFilter.getAttribute("dataItem"));
                TupleInterface tuple = tupleElement.getTuple();
                int tupleIndex = tuple.getTupleIndex();
                areaScopeAttributeMap.put("tupleIndex", String.valueOf(tupleIndex));
                AxisInterface axis = tuple.getAxis();
                int axisIndex = axis.getAxisNumber();
                areaScopeAttributeMap.put("axisIndex", String.valueOf(axisIndex));
                boolean isNavigatable = this.isNavigatable(actionFilter.getAttribute("model"), tupleElement);
                if (!isNavigatable) {
                    areaScopeAttributeMap.put("link", Boolean.FALSE);
                }
            }
            catch (OLAPException oLAPException) {
                // empty catch block
            }
        }
        return areaScopeAttributeMap;
    }

    protected Map getActionScopeAttributeMap(String actionType, ActionSupportFilter actionFilter) {
        HashMap actionScopeAttributeMap = ActionProviderMapPool.getMap();
        try {
            if (actionType == "DRILL_DOWN_MEMBER_ACTION" || actionType == "DRILL_TO_LEVEL_ACTION") {
                int currentDrillActionIndex = actionFilter.getActionIndex();
                List drillStateUniqueNames = (List)actionFilter.getAttribute("drillStateUniqueNames");
                List drillStateLabels = (List)actionFilter.getAttribute("drillStateLabels");
                boolean isAllLevelCase = (Boolean)actionFilter.getAttribute("isAllLevel");
                boolean showAllLevelCase = (Boolean)actionFilter.getAttribute("includeAllLevel");
                String label = null;
                if (actionType == "DRILL_DOWN_MEMBER_ACTION") {
                    int memberIndex = -1;
                    memberIndex = isAllLevelCase ? currentDrillActionIndex + 1 : currentDrillActionIndex;
                    label = (String)drillStateLabels.get(memberIndex);
                    actionScopeAttributeMap.put("uniqueMemberName", (String)drillStateUniqueNames.get(memberIndex));
                    int drillMemberCount = -1;
                    drillMemberCount = isAllLevelCase && showAllLevelCase ? drillStateLabels.size() - 2 : drillStateLabels.size() - 1;
                    if (drillMemberCount == currentDrillActionIndex) {
                        actionScopeAttributeMap.put("link", Boolean.FALSE);
                    }
                } else {
                    label = (String)drillStateLabels.get(currentDrillActionIndex - 1);
                    actionScopeAttributeMap.put("uniqueLevelName", (String)drillStateUniqueNames.get(currentDrillActionIndex - 1));
                    if (isAllLevelCase && currentDrillActionIndex == 2 && drillStateLabels.size() == 2) {
                        actionScopeAttributeMap.put("link", Boolean.FALSE);
                    }
                }
                actionScopeAttributeMap.put("Name", label);
                if (!actionScopeAttributeMap.containsKey("link")) {
                    String description = Message.format((String)RB.getStringResource((String)"BaseOLAPDrillStateSupport.", (String)"upToToolTip.txt", (Locale)this.getLocale()), (Object)label);
                    actionScopeAttributeMap.put("ShortDescription", description);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return actionScopeAttributeMap;
    }

    protected boolean validArea(Area area, ActionSupportFilter filter) {
        return true;
    }

    protected Map initializeShortActionTypeMap() {
        Map shortActionTypeMap = super.initializeShortActionTypeMap();
        shortActionTypeMap.put("DRILL_DOWN_MEMBER_ACTION", "_DDM");
        shortActionTypeMap.put("DRILL_TO_LEVEL_ACTION", "_DTL");
        return shortActionTypeMap;
    }
}

