/*
 * Decompiled with CFR 0.152.
 */
package com.sas.actionprovider.support.olapgraphics;

import com.sas.actionprovider.support.graphics.GraphValueResolver;
import com.sas.codepolicy.SASScope;
import com.sas.graphics.components.ChartImageMapInfo;
import com.sas.graphics.components.ChartValueZone;
import com.sas.graphics.components.LabelZoneList;
import com.sas.graphics.components.PlotImageMapInfo;
import com.sas.graphics.components.PlotValueZone;
import com.sas.graphics.components.ValueList;
import com.sas.graphics.components.VariableList;
import com.sas.storage.olap.OLAPException;
import com.sas.storage.olap.TupleElementInterface;
import com.sas.storage.olap.TupleInterface;

@SASScope
public class DefaultOlapGraphValueResolver
implements GraphValueResolver {
    @Override
    public Object getValueAt(Object imageMapInfo, Integer row, String columnName) {
        ChartValueZone[] cvz = null;
        PlotValueZone[] pvz = null;
        ChartImageMapInfo bcimi = null;
        PlotImageMapInfo pimi = null;
        if (row == null || imageMapInfo == null) {
            return null;
        }
        if (imageMapInfo instanceof ChartImageMapInfo) {
            bcimi = (ChartImageMapInfo)imageMapInfo;
        } else if (imageMapInfo instanceof PlotImageMapInfo) {
            pimi = (PlotImageMapInfo)imageMapInfo;
        } else {
            return null;
        }
        if (bcimi != null) {
            cvz = bcimi.getDataElementValueZones();
            int index = 0;
            if (cvz != null && cvz.length > row) {
                index = this.getLabelListIndex(bcimi.getCategoryLabelZoneList(), columnName);
                if (index != -1) {
                    return this.getValueListValue(cvz[row].getCategoryValue(), index, columnName);
                }
                index = this.getLabelListIndex(bcimi.getSubgroupLabelZoneList(), columnName);
                if (index != -1) {
                    return this.getValueListValue(cvz[row].getSubgroupValue(), index, columnName);
                }
                index = this.getLabelListIndex(bcimi.getColumnLabelZoneList(), columnName);
                if (index != -1) {
                    return this.getValueListValue(cvz[row].getColumnValue(), index, columnName);
                }
                index = this.getLabelListIndex(bcimi.getRowLabelZoneList(), columnName);
                if (index != -1) {
                    return this.getValueListValue(cvz[row].getRowValue(), index, columnName);
                }
                if (bcimi.getSubgroupLabelZoneList() == null && bcimi.getSubgroupVariableList() != null && this.isDimensionInVariableList(bcimi.getSubgroupVariableList(), columnName)) {
                    return this.getValueListValue(cvz[row].getSubgroupValue(), -1, columnName);
                }
                if (bcimi.getCategoryLabelZoneList() == null && bcimi.getCategoryVariableList() != null && this.isDimensionInVariableList(bcimi.getCategoryVariableList(), columnName)) {
                    return this.getValueListValue(cvz[row].getCategoryValue(), -1, columnName);
                }
            }
        } else {
            pvz = pimi.getDataElementValueZones();
            int index = 0;
            if (pvz != null && pvz.length > row) {
                index = this.getLabelListIndex(pimi.getXLabelZoneList(), columnName);
                if (index != -1) {
                    return this.getValueListValue(pvz[row].getXValue(), index, columnName);
                }
                index = this.getLabelListIndex(pimi.getYLabelZoneList(), columnName);
                if (index != -1) {
                    return this.getValueListValue(pvz[row].getYValue(), index, columnName);
                }
                index = this.getLabelListIndex(pimi.getY2LabelZoneList(), columnName);
                if (index != -1) {
                    return this.getValueListValue(pvz[row].getY2Value(), index, columnName);
                }
                index = this.getLabelListIndex(pimi.getGroupLabelZoneList(), columnName);
                if (index != -1) {
                    return this.getValueListValue(pvz[row].getGroupValue(), index, columnName);
                }
                index = this.getLabelListIndex(pimi.getColumnLabelZoneList(), columnName);
                if (index != -1) {
                    return this.getValueListValue(pvz[row].getColumnValue(), index, columnName);
                }
                index = this.getLabelListIndex(pimi.getRowLabelZoneList(), columnName);
                if (index != -1) {
                    return this.getValueListValue(pvz[row].getRowValue(), index, columnName);
                }
                if (pimi.getGroupLabelZoneList() == null && pimi.getGroupVariableList() != null && this.isDimensionInVariableList(pimi.getGroupVariableList(), columnName)) {
                    return this.getValueListValue(pvz[row].getGroupValue(), -1, columnName);
                }
            }
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String getValueListValue(ValueList valueList, int index, String columnName) {
        if (valueList == null) {
            return null;
        }
        if (valueList.getUnformattedValue() instanceof TupleElementInterface) {
            try {
                TupleInterface tuple = ((TupleElementInterface)valueList.getUnformattedValue()).getTuple();
                TupleElementInterface tupleElement = null;
                if (tuple == null) return null;
                TupleElementInterface[] tupleElements = tuple.getElements(0, -1);
                for (int i = 0; i < tupleElements.length; ++i) {
                    tupleElement = tupleElements[i];
                    if (!tupleElement.getUniqueLevelName().equalsIgnoreCase(columnName)) continue;
                    return tupleElement.getLabel().trim();
                }
                return null;
            }
            catch (OLAPException tuple) {
                return null;
            }
        } else {
            if (!(valueList.getUnformattedValue() instanceof String)) return null;
            for (int i = 0; i < index && valueList != null; valueList = valueList.getNext(), ++i) {
            }
            if (valueList == null) return null;
            return valueList.getFormattedValue().trim();
        }
    }

    private int getLabelListIndex(LabelZoneList labelList, String columnName) {
        int index = 0;
        while (labelList != null) {
            if (labelList.getName().equals(columnName)) {
                return index;
            }
            labelList = labelList.getNext();
            ++index;
        }
        return -1;
    }

    private boolean isDimensionInVariableList(VariableList variableList, String uniqueLevelName) {
        boolean result = false;
        while (variableList != null) {
            String variableListColumnName = variableList.getColumnName();
            if (this.doDimensionsMatch(variableListColumnName, uniqueLevelName)) {
                result = true;
            }
            variableList = variableList.getNext();
        }
        return result;
    }

    private boolean doDimensionsMatch(String firstUniqueLevelName, String secondUniqueLevelName) {
        boolean result = false;
        String dimensionOnFirst = this.getTopLevelOfDimension(firstUniqueLevelName);
        String dimensionOnSecond = this.getTopLevelOfDimension(secondUniqueLevelName);
        if (dimensionOnFirst != null && dimensionOnSecond != null && dimensionOnFirst.length() > 1 && dimensionOnFirst.equals(dimensionOnSecond)) {
            result = true;
        }
        return result;
    }

    private String getTopLevelOfDimension(String uniqueLevelName) {
        int positionOfSeparator;
        String result = null;
        if (uniqueLevelName != null && (positionOfSeparator = uniqueLevelName.indexOf("].[", 0)) > 0) {
            result = uniqueLevelName.substring(0, positionOfSeparator + 1);
        }
        return result;
    }
}

