/*
 * Decompiled with CFR 0.152.
 */
package com.sas.actionprovider.support.graphics;

import com.sas.actionprovider.ActionSupportFilter;
import com.sas.actionprovider.CommandStatusInterface;
import com.sas.codepolicy.SASScope;
import com.sas.commands.BaseCommand;
import com.sas.servlet.tbeans.graphics.BaseGraphics;
import com.sas.util.log.LoggerRepository2;

@SASScope
public class ResizeCommand
extends BaseCommand
implements CommandStatusInterface {
    private String _id = null;
    private String _width = null;
    private String _height = null;
    private BaseGraphics _resizedColumns = null;
    private String _URL = null;

    public void execute(Object o) {
        try {
            int width = this.parseInt(this.getWidth());
            if (width > 0) {
                this._resizedColumns.setWidth(width);
            }
        }
        catch (RuntimeException e) {
            LoggerRepository2.getLogger((String)ResizeCommand.class.getPackage().getName(), null).error(e.getMessage(), (Throwable)e);
        }
        try {
            int height = this.parseInt(this.getHeight());
            if (height > 0) {
                this._resizedColumns.setHeight(height);
            }
        }
        catch (RuntimeException e) {
            LoggerRepository2.getLogger((String)ResizeCommand.class.getPackage().getName(), null).error(e.getMessage(), (Throwable)e);
        }
    }

    private int parseInt(String str) {
        if (str == null) {
            return -1;
        }
        if (str.endsWith("px")) {
            str = str.substring(0, str.length() - 2);
        }
        return Integer.parseInt(str);
    }

    public BaseGraphics getResizedColumns() {
        return this._resizedColumns;
    }

    public void setResizedColumns(BaseGraphics resizedColumns) {
        this._resizedColumns = resizedColumns;
    }

    public String getURL() {
        return this._URL;
    }

    public void setURL(String url) {
        this._URL = url;
    }

    public int getCommandStatus(ActionSupportFilter filter) {
        Object obj = filter.getAttribute("resizedColumns");
        if (obj == null) {
            return 16;
        }
        if (this.getURL() == null) {
            this.setURL(((BaseGraphics)obj).getActionProvider().getControllerURL());
        }
        return 0;
    }

    public String getHeight() {
        return this._height;
    }

    public void setHeight(String height) {
        this._height = height;
    }

    public String getId() {
        return this._id;
    }

    public void setId(String id) {
        this._id = id;
    }

    public String getWidth() {
        return this._width;
    }

    public void setWidth(String width) {
        this._width = width;
    }
}

