/*
 * Decompiled with CFR 0.152.
 */
package com.sas.actionprovider.support.graphics;

import com.sas.actionprovider.support.graphics.GraphValueResolver;
import com.sas.codepolicy.SASScope;
import com.sas.graphics.components.ChartImageMapInfo;
import com.sas.graphics.components.ChartValueZone;
import com.sas.graphics.components.PlotImageMapInfo;
import com.sas.graphics.components.PlotValueZone;
import com.sas.graphics.components.ValueList;
import com.sas.graphics.components.VariableList;
import com.sas.text.SASDateTimeFormat;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;

@SASScope
public class DefaultGraphValueResolver
implements GraphValueResolver {
    public Object getUnformattedValueAt(Object imageMapInfo, Integer row, String columnName, int expressionType) {
        Object value = this.getValueAt(imageMapInfo, row, columnName, false);
        if (expressionType == 4) {
            long javaDateValue = SASDateTimeFormat.SASDateToJavaDate((double)((Double)value));
            value = new Date(javaDateValue);
        } else if (expressionType == 5) {
            long javaDateValue = SASDateTimeFormat.SASTimeToJavaDate((double)((Double)value));
            value = new Time(javaDateValue);
        } else if (expressionType == 6) {
            long javaDateValue = SASDateTimeFormat.SASDateTimeToJavaDate((double)((Double)value));
            value = new Timestamp(javaDateValue);
        }
        return value;
    }

    public Object getUnformattedValueAt(Object imageMapInfo, Integer row, String columnName) {
        return this.getValueAt(imageMapInfo, row, columnName, false);
    }

    @Override
    public Object getValueAt(Object imageMapInfo, Integer row, String columnName) {
        return this.getValueAt(imageMapInfo, row, columnName, true);
    }

    private Object getValueAt(Object imageMapInfo, Integer row, String columnName, boolean formatted) {
        ChartImageMapInfo bcimi = null;
        PlotImageMapInfo pimi = null;
        if (row == null || imageMapInfo == null) {
            return null;
        }
        if (imageMapInfo instanceof ChartImageMapInfo) {
            bcimi = (ChartImageMapInfo)imageMapInfo;
        } else if (imageMapInfo instanceof PlotImageMapInfo) {
            pimi = (PlotImageMapInfo)imageMapInfo;
        } else {
            return null;
        }
        if (bcimi != null) {
            ChartValueZone[] cvz = bcimi.getDataElementValueZones();
            int index = 0;
            index = this.getVariableListIndex(bcimi.getCategoryVariableList(), columnName);
            if (index != -1) {
                return this.getValueListValue(cvz[row].getCategoryValue(), index, formatted);
            }
            index = this.getVariableListIndex(bcimi.getResponseVariableList(), columnName);
            if (index != -1) {
                return this.getValueListValue(cvz[row].getResponseValue(), index, formatted);
            }
            index = this.getVariableListIndex(bcimi.getResponse2VariableList(), columnName);
            if (index != -1) {
                return this.getValueListValue(cvz[row].getResponse2Value(), index, formatted);
            }
            index = this.getVariableListIndex(bcimi.getSubgroupVariableList(), columnName);
            if (index != -1) {
                return this.getValueListValue(cvz[row].getSubgroupValue(), index, formatted);
            }
            index = this.getVariableListIndex(bcimi.getColumnVariableList(), columnName);
            if (index != -1) {
                return this.getValueListValue(cvz[row].getColumnValue(), index, formatted);
            }
            index = this.getVariableListIndex(bcimi.getRowVariableList(), columnName);
            if (index != -1) {
                return this.getValueListValue(cvz[row].getRowValue(), index, formatted);
            }
            index = this.getVariableListIndex(bcimi.getAuxiliaryVariableList(), columnName);
            if (index != -1) {
                return this.getValueListValue(cvz[row].getAuxiliaryValue(), index, formatted);
            }
            index = this.getVariableListIndex(bcimi.getDataTipVariableList(), columnName);
            if (index != -1) {
                return this.getValueListValue(cvz[row].getDataTipValue(), index, formatted);
            }
        } else {
            PlotValueZone[] pvz = pimi.getDataElementValueZones();
            int index = 0;
            index = this.getVariableListIndex(pimi.getXVariableList(), columnName);
            if (index != -1) {
                return this.getValueListValue(pvz[row].getXValue(), index, formatted);
            }
            index = this.getVariableListIndex(pimi.getYVariableList(), columnName);
            if (index != -1) {
                return this.getValueListValue(pvz[row].getYValue(), index, formatted);
            }
            index = this.getVariableListIndex(pimi.getY2VariableList(), columnName);
            if (index != -1) {
                return this.getValueListValue(pvz[row].getY2Value(), index, formatted);
            }
            index = this.getVariableListIndex(pimi.getGroupVariableList(), columnName);
            if (index != -1) {
                return this.getValueListValue(pvz[row].getGroupValue(), index, formatted);
            }
            index = this.getVariableListIndex(pimi.getColumnVariableList(), columnName);
            if (index != -1) {
                return this.getValueListValue(pvz[row].getColumnValue(), index, formatted);
            }
            index = this.getVariableListIndex(pimi.getRowVariableList(), columnName);
            if (index != -1) {
                return this.getValueListValue(pvz[row].getRowValue(), index, formatted);
            }
            index = this.getVariableListIndex(pimi.getSizeVariableList(), columnName);
            if (index != -1) {
                return this.getValueListValue(pvz[row].getSizeValue(), index, formatted);
            }
            index = this.getVariableListIndex(pimi.getAuxiliaryVariableList(), columnName);
            if (index != -1) {
                return this.getValueListValue(pvz[row].getAuxiliaryValue(), index, formatted);
            }
            index = this.getVariableListIndex(pimi.getDataTipVariableList(), columnName);
            if (index != -1) {
                return this.getValueListValue(pvz[row].getDataTipValue(), index, formatted);
            }
        }
        return null;
    }

    private int getVariableListIndex(VariableList variableList, String columnName) {
        int index = 0;
        while (variableList != null) {
            if (variableList.getColumnName() == null ? columnName == null : variableList.getColumnName().equals(columnName)) {
                return index;
            }
            variableList = variableList.getNext();
            ++index;
        }
        return -1;
    }

    private Object getValueListValue(ValueList valueList, int index, boolean formatted) {
        for (int i = 0; i < index; ++i) {
            valueList = valueList.getNext();
        }
        if (!formatted) {
            return valueList.getUnformattedValue();
        }
        return valueList.getFormattedValue().trim();
    }
}

