/*
 * Decompiled with CFR 0.152.
 */
package com.sas.actionprovider.strategies.dataselector;

import com.sas.actionprovider.strategies.ActionStrategyInterface;
import com.sas.actionprovider.strategies.dataselector.FilterAndRankStrategy;
import com.sas.actionprovider.strategies.dataselector.FormatStrategy;
import com.sas.actionprovider.support.dataselectors.MenuBarActionTypesInterface;
import com.sas.actionprovider.support.dataselectors.MenuBarAreaInterface;
import com.sas.actionprovider.util.dataselector.SelectorActionUtil;
import com.sas.codepolicy.SASScope;
import com.sas.util.log.LoggerRepository2;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;

@SASScope(value="ALL")
public class HttpSelectorActionStrategyFactory
implements MenuBarAreaInterface,
MenuBarActionTypesInterface {
    private static Map areaStrategyMaps;
    private static Map selectorAreaStrategies;
    private static Map rowHeaderAreaStrategies;
    private static Map columnHeaderAreaStrategies;
    private static Object[] constructorArgs;
    private static Class[] constructorArgTypes;
    private static Map areaStrategyInstanceMaps;
    public static final String FAR_SELECTOR_ACTION = "FILTER_AND_RANK_SELECTOR_ACTION";
    public static final String FORMAT_SELECTOR_ACTION = "FORMAT_ACTION";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ActionStrategyInterface getActionStrategy(String areaType, String actionType, boolean fromCache) {
        ActionStrategyInterface asi = null;
        if (fromCache) {
            Map strategyInstancesMap;
            Map map = strategyInstancesMap = (Map)areaStrategyInstanceMaps.get(areaType);
            synchronized (map) {
                asi = (ActionStrategyInterface)strategyInstancesMap.get(actionType);
                if (asi == null) {
                    asi = HttpSelectorActionStrategyFactory.getNewStrategy(areaType, actionType);
                    strategyInstancesMap.put(actionType, asi);
                }
            }
        } else {
            asi = HttpSelectorActionStrategyFactory.getNewStrategy(areaType, actionType);
        }
        return asi;
    }

    private static ActionStrategyInterface getNewStrategy(String areaType, String actionType) {
        ActionStrategyInterface asi;
        block5: {
            asi = null;
            Class actionStrategyClass = (Class)((Map)areaStrategyMaps.get(areaType)).get(actionType);
            if (actionStrategyClass == null) {
                return null;
            }
            try {
                Constructor constructor = actionStrategyClass.getConstructor(constructorArgTypes);
                asi = (ActionStrategyInterface)constructor.newInstance(constructorArgs);
            }
            catch (InstantiationException constructor) {
            }
            catch (IllegalAccessException constructor) {
            }
            catch (Exception e) {
                if (!(e instanceof InvocationTargetException)) break block5;
                InvocationTargetException e2 = (InvocationTargetException)e;
                Throwable t = e2.getTargetException();
                LoggerRepository2.getLogger((String)HttpSelectorActionStrategyFactory.class.getPackage().getName(), null).error(e.getMessage(), (Throwable)e);
            }
        }
        return asi;
    }

    static {
        constructorArgs = new Object[2];
        HttpSelectorActionStrategyFactory.constructorArgs[0] = Boolean.FALSE;
        HttpSelectorActionStrategyFactory.constructorArgs[1] = new SelectorActionUtil();
        constructorArgTypes = new Class[2];
        HttpSelectorActionStrategyFactory.constructorArgTypes[0] = Boolean.TYPE;
        HttpSelectorActionStrategyFactory.constructorArgTypes[1] = SelectorActionUtil.class;
        selectorAreaStrategies = new HashMap(32, 1.0f);
        selectorAreaStrategies.put(FAR_SELECTOR_ACTION, FilterAndRankStrategy.class);
        selectorAreaStrategies.put(FORMAT_SELECTOR_ACTION, FormatStrategy.class);
        rowHeaderAreaStrategies = new HashMap(32, 1.0f);
        rowHeaderAreaStrategies.put(FAR_SELECTOR_ACTION, FilterAndRankStrategy.class);
        rowHeaderAreaStrategies.put(FORMAT_SELECTOR_ACTION, FormatStrategy.class);
        columnHeaderAreaStrategies = new HashMap(32, 1.0f);
        columnHeaderAreaStrategies.put(FAR_SELECTOR_ACTION, FilterAndRankStrategy.class);
        columnHeaderAreaStrategies.put(FORMAT_SELECTOR_ACTION, FormatStrategy.class);
        areaStrategyMaps = new HashMap(8, 1.0f);
        areaStrategyMaps.put("SELECTOR_AREA", selectorAreaStrategies);
        areaStrategyMaps.put("ROW_HEADER_AREA", rowHeaderAreaStrategies);
        areaStrategyMaps.put("COLUMN_HEADER_AREA", columnHeaderAreaStrategies);
        areaStrategyInstanceMaps = new HashMap(8, 1.0f);
        areaStrategyInstanceMaps.put("SELECTOR_AREA", new HashMap());
        areaStrategyInstanceMaps.put("ROW_HEADER_AREA", new HashMap());
        areaStrategyInstanceMaps.put("COLUMN_HEADER_AREA", new HashMap());
    }
}

