/*
 * Decompiled with CFR 0.152.
 */
package com.sas.actionprovider;

import com.sas.actionprovider.ActionList;
import com.sas.actionprovider.ActionProviderEvent;
import com.sas.actionprovider.ActionProviderHttpActionPool;
import com.sas.actionprovider.ActionProviderMapPool;
import com.sas.actionprovider.ActionProviderReference;
import com.sas.actionprovider.ActionProviderSelectorActionPool;
import com.sas.actionprovider.ActionProviderStoredPropertiesPool;
import com.sas.actionprovider.ActionProviderViewInterface;
import com.sas.actionprovider.ActionSupportFilter;
import com.sas.actionprovider.Area;
import com.sas.actionprovider.BaseAction;
import com.sas.actionprovider.BaseActionProvider;
import com.sas.actionprovider.BaseUtil;
import com.sas.actionprovider.CommandEntry;
import com.sas.actionprovider.HttpAction;
import com.sas.actionprovider.HttpActionProviderViewInterface;
import com.sas.actionprovider.RB;
import com.sas.actionprovider.SelectorAction;
import com.sas.actionprovider.StoredProperties;
import com.sas.actionprovider.Util;
import com.sas.actionprovider.support.BaseActionProviderSupport;
import com.sas.codepolicy.SASScope;
import com.sas.collection.ContentsChangedEvent;
import com.sas.collection.ContentsChangedListener;
import com.sas.collection.ContentsChangedListenerList;
import com.sas.collection.ContentsChangedSource;
import com.sas.commands.CompositeDynamicAttributeCommandInterface;
import com.sas.commands.ContentsChangedInterface;
import com.sas.commands.DynamicAttributeCommandInterface;
import com.sas.commands.PendingCommandInterface;
import com.sas.commands.dataselectors.BaseSelectorCommand;
import com.sas.dataselectors.DataSelectorInterface;
import com.sas.entities.AttributeDescriptorInterface;
import com.sas.entities.AttributeSetException;
import com.sas.servlet.tbeans.BaseCompositeTransformation;
import com.sas.servlet.tbeans.dataselectors.BaseDataSelector;
import com.sas.servlet.util.ComponentPropertyManager;
import com.sas.util.ApplyInterface;
import com.sas.util.Classes;
import com.sas.util.log.CommonLoggerInterface;
import com.sas.util.log.LoggerRepository2;
import com.sas.util.transforms.TransformException;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.ReferenceQueue;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.Set;
import java.util.Vector;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

@SASScope(value="ALL")
public class HttpActionProvider
extends BaseActionProvider
implements ContentsChangedSource {
    static final String RB_KEY = "HttpActionProvider.";
    public static final String ALL_VIEWERS = "ALL_VIEWERS";
    public static final String CMDID = "CMDID";
    public static final String APNAME = "APNAME";
    public static final String DYNAMICATTRS = "DYNAMICATTRS";
    public static final String PARMPREFIX = "PARMPREFIX";
    public static final String BASEURL = "BASEURL";
    public static final String AJAX_CONTROLLER_URL = "AJAX_CONTROLLER_URL";
    public static final String VIEWERID = "VIEWERID";
    public static final String REFRESHVIEWERID = "REFRESHVIEWERID";
    public static final String REFERRINGURI = "REFERRINGURI";
    public static final String QUERYSTRING = "QUERYSTRING";
    public static final String CONTEXTPATH = "CONTEXTPATH";
    public static final String REFERRING_URI_PARAMETER = "_referringURI";
    public static final String VIEWER_ID_PARAMETER = "viewerId";
    public static final String REFRESH_VIEWER_ID_PARAMETER = "refreshViewerId";
    private String parameterPrefix;
    private Map commandRetrievalMap;
    private Map cmdLookUpMap;
    private Map viewerExternalParameters;
    private Map externalParameters;
    private Map encodedValueViewersMap;
    private List pendingStoredCommandList;
    private List pendingExecutableCommandList;
    private List actionProviderReferencesList;
    private ReferenceQueue referenceQueue;
    private static CommonLoggerInterface _log = null;
    private static final String STORED_PROPERTIES = "STORED_PROPERTIES";
    private static final String VIEWER = "VIEWER";
    private static final String COMMAND = "COMMAND";
    private String imageLocation;
    private String controllerURL;
    private boolean useReferringURIParameter;

    public HttpActionProvider() {
        this.setActionClass(HttpAction.class);
        this.initDefaultSupportClassNames();
        this.commandRetrievalMap = Collections.synchronizedMap(new HashMap(63));
        this.cmdLookUpMap = Collections.synchronizedMap(new HashMap(63));
        this.viewerExternalParameters = Collections.synchronizedMap(new HashMap(6));
        this.externalParameters = Collections.synchronizedMap(new HashMap(6));
        this.encodedValueViewersMap = Collections.synchronizedMap(new HashMap(24));
        this.pendingStoredCommandList = Collections.synchronizedList(new ArrayList());
        this.pendingExecutableCommandList = Collections.synchronizedList(new ArrayList());
        this.actionProviderReferencesList = Collections.synchronizedList(new ArrayList());
        this.referenceQueue = new ReferenceQueue();
    }

    @SASScope
    public void addSupportClass(String supportTypeKey, String className) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        if (supportTypeKey == null) {
            throw new IllegalArgumentException(RB.getStringResource((String)RB_KEY, (String)"nullSupportType.txt"));
        }
        if (className == null) {
            throw new IllegalArgumentException(RB.getStringResource((String)RB_KEY, (String)"nullClassName.txt"));
        }
        Class supportClass = Classes.loadClass((String)className, null, (Object)((Object)this));
        BaseActionProviderSupport support = null;
        if (supportClass == null) {
            throw new IllegalStateException(RB.getStringResource((String)RB_KEY, (String)"supportClassNotLoaded.txt"));
        }
        support = (BaseActionProviderSupport)supportClass.newInstance();
        if (support == null || !(support instanceof BaseActionProviderSupport)) {
            throw new IllegalStateException(RB.getStringResource((String)RB_KEY, (String)"supportClassNotLoaded.txt"));
        }
        this.getAllSupportClassNamesMap().put(supportTypeKey, className);
    }

    private void initDefaultSupportClassNames() {
        Properties properties = new Properties();
        InputStream is = ((Object)((Object)this)).getClass().getResourceAsStream("HttpSupportClasses.properties");
        try {
            properties.load(is);
        }
        catch (IOException e) {
            throw new IllegalStateException(RB.getStringResource((String)RB_KEY, (String)"httpSupportClassesNotLoaded.txt"));
        }
        finally {
            try {
                is.close();
            }
            catch (IOException ioe) {
                HttpActionProvider.getLog().error(ioe.getMessage(), (Throwable)ioe);
            }
        }
        this.getDefaultSupportClassNamesMap().putAll(properties);
        this.getAllSupportClassNamesMap().putAll(properties);
    }

    public String getParameterPrefix() {
        if (this.parameterPrefix == null) {
            this.setParameterPrefix(this.getName() + "_");
        }
        return this.parameterPrefix;
    }

    public void setParameterPrefix(String parameterPrefix) {
        this.parameterPrefix = parameterPrefix;
    }

    @SASScope
    protected Class getSupportClass(String supportType) {
        if (supportType == null) {
            throw new IllegalArgumentException(RB.getStringResource((String)RB_KEY, (String)"nullSupportType.txt"));
        }
        Map supportClassesMap = this.getSupportClassesMap();
        Class supportClass = (Class)supportClassesMap.get(supportType);
        if (supportClass == null) {
            String supportClassName = (String)this.getAllSupportClassNamesMap().get(supportType);
            if (supportClassName != null) {
                try {
                    supportClass = Classes.loadClass((String)supportClassName, null, (Object)((Object)this));
                    supportClassesMap.put(supportType, supportClass);
                }
                catch (ClassNotFoundException cnfex) {
                    throw new IllegalStateException(RB.getStringResource((String)RB_KEY, (String)"supportNotFound.txt"));
                }
            } else {
                throw new IllegalArgumentException(RB.getStringResource((String)RB_KEY, (String)"invalidSupportKey.txt", (Locale)this.getLocale()));
            }
        }
        return supportClass;
    }

    public void setControllerURL(String controllerURL) {
        this.controllerURL = controllerURL;
    }

    public String getControllerURL() {
        return this.controllerURL;
    }

    public void setUseReferringURIParameter(boolean useReferringURIParameter) {
        this.useReferringURIParameter = useReferringURIParameter;
    }

    public boolean getUseReferringURIParameter() {
        return this.useReferringURIParameter;
    }

    @SASScope
    public void flushViewerReferencesFromSupportClass(HttpActionProviderViewInterface viewer) {
        if (viewer == null) {
            throw new IllegalArgumentException(RB.getStringResource((String)RB_KEY, (String)"nullViewer.txt"));
        }
        String actionSupportType = viewer.getActionSupportType();
        if (actionSupportType == null) {
            throw new IllegalStateException(RB.getStringResource((String)RB_KEY, (String)"nullSupportType.txt"));
        }
        BaseActionProviderSupport support = this.getSupport(actionSupportType);
        if (support == null) {
            throw new IllegalStateException(RB.getStringResource((String)RB_KEY, (String)"invalidSupportKey.txt"));
        }
        support.flushViewerReferencesFromSupportClass((ActionProviderViewInterface)viewer);
    }

    @SASScope
    public void flushAdditionalViewerAttributes(HttpActionProviderViewInterface viewer) {
        if (viewer == null) {
            throw new IllegalArgumentException(RB.getStringResource((String)RB_KEY, (String)"nullViewer.txt"));
        }
        this.viewerExternalParameters.remove(viewer.getUniqueId());
    }

    public void addExternalRequestParameter(HttpActionProviderViewInterface viewer, String parameterName, String parameterValue) {
        if (viewer == null) {
            this.externalParameters.put(parameterName, parameterValue);
        } else {
            Object uniqueId = viewer.getUniqueId();
            Map<String, String> addParameters = null;
            if (this.viewerExternalParameters.containsKey(uniqueId)) {
                addParameters = (Map<String, String>)this.viewerExternalParameters.get(uniqueId);
            } else {
                addParameters = Collections.synchronizedMap(new HashMap(6));
                this.viewerExternalParameters.put(uniqueId, addParameters);
            }
            if (addParameters != null) {
                addParameters.put(parameterName, parameterValue);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addExternalRequestParameters(HttpActionProviderViewInterface viewer, Map externalParameters) {
        if (externalParameters != null && externalParameters.size() > 0) {
            Map addParameters = null;
            if (viewer == null) {
                addParameters = this.externalParameters;
            } else {
                Object uniqueId = viewer.getUniqueId();
                if (this.viewerExternalParameters.containsKey(uniqueId)) {
                    addParameters = (Map)this.viewerExternalParameters.get(uniqueId);
                } else {
                    addParameters = Collections.synchronizedMap(new HashMap(6));
                    this.viewerExternalParameters.put(uniqueId, addParameters);
                }
            }
            if (addParameters != null) {
                Set keySet;
                Set set = keySet = externalParameters.keySet();
                synchronized (set) {
                    for (String currentKey : keySet) {
                        addParameters.put(currentKey, externalParameters.get(currentKey));
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map getExternalRequestParameters(HttpActionProviderViewInterface viewer) {
        Map viewerParameters;
        Object uniqueId;
        HashMap addParameters = new HashMap(this.externalParameters);
        if (viewer != null && this.viewerExternalParameters.containsKey(uniqueId = viewer.getUniqueId()) && (viewerParameters = (Map)this.viewerExternalParameters.get(uniqueId)) != null && viewerParameters.size() > 0) {
            Set keySet;
            Set set = keySet = viewerParameters.keySet();
            synchronized (set) {
                for (String currentKey : keySet) {
                    addParameters.put(currentKey, viewerParameters.get(currentKey));
                }
            }
        }
        return addParameters;
    }

    public Map getExternalRequestParameters() {
        return this.externalParameters;
    }

    @SASScope
    public String getImageLocation() {
        return this.imageLocation;
    }

    @SASScope
    public void setImageLocation(String imageLocation) {
        this.imageLocation = imageLocation;
    }

    @SASScope
    public DynamicAttributeCommandInterface getStoredCommand(HttpServletRequest request) {
        if (request == null) {
            throw new IllegalArgumentException(RB.getStringResource((String)RB_KEY, (String)"nullRequest.txt"));
        }
        String cmdID = request.getParameter(CMDID);
        if (cmdID == null) {
            return null;
        }
        CommandEntry commandEntry = (CommandEntry)this.commandRetrievalMap.get(cmdID);
        if (commandEntry == null) {
            return null;
        }
        return commandEntry.getCommand();
    }

    public DynamicAttributeCommandInterface getExecutableCommand(HttpServletRequest request) {
        if (request == null) {
            throw new IllegalArgumentException(RB.getStringResource((String)RB_KEY, (String)"nullRequest.txt"));
        }
        String cmdID = request.getParameter(CMDID);
        if (cmdID == null) {
            return null;
        }
        CommandEntry commandEntry = (CommandEntry)this.commandRetrievalMap.get(cmdID);
        if (commandEntry == null) {
            return null;
        }
        DynamicAttributeCommandInterface command = commandEntry.getCommand();
        if (command == null) {
            return null;
        }
        DynamicAttributeCommandInterface executableCommand = null;
        PendingCommandInterface pendingExecutableCommand = null;
        PendingCommandInterface pendingStoredCommand = null;
        if (!this.pendingExecutableCommandList.isEmpty()) {
            pendingExecutableCommand = (PendingCommandInterface)this.pendingExecutableCommandList.get(this.pendingExecutableCommandList.size() - 1);
        }
        if (!this.pendingStoredCommandList.isEmpty()) {
            pendingStoredCommand = (PendingCommandInterface)this.pendingStoredCommandList.get(this.pendingStoredCommandList.size() - 1);
        }
        if (pendingExecutableCommand != null && pendingStoredCommand != null && pendingStoredCommand == command) {
            String mode = request.getParameter(this.getParameterPrefix() + "mode");
            if (mode != null && mode.equals("SHOW")) {
                try {
                    executableCommand = (DynamicAttributeCommandInterface)command.clone();
                    pendingExecutableCommand.cancel();
                    this.pendingExecutableCommandList.remove(pendingExecutableCommand);
                    this.pendingStoredCommandList.remove(pendingStoredCommand);
                }
                catch (CloneNotSupportedException cnse) {
                    throw new IllegalStateException(RB.getStringResource((String)RB_KEY, (String)"commandNotCloneable.txt"));
                }
            } else {
                executableCommand = (DynamicAttributeCommandInterface)pendingExecutableCommand;
            }
        } else {
            try {
                executableCommand = (DynamicAttributeCommandInterface)command.clone();
            }
            catch (CloneNotSupportedException cnse) {
                throw new IllegalStateException(RB.getStringResource((String)RB_KEY, (String)"commandNotCloneable.txt"));
            }
        }
        this.applyCommandAttributes(request, executableCommand);
        return executableCommand;
    }

    public void applyCommandAttributes(HttpServletRequest request, DynamicAttributeCommandInterface command) {
        if (request == null) {
            throw new IllegalArgumentException(RB.getStringResource((String)RB_KEY, (String)"nullRequest.txt"));
        }
        if (command == null) {
            throw new IllegalArgumentException(RB.getStringResource((String)RB_KEY, (String)"nullCMD.txt"));
        }
        if (command instanceof CompositeDynamicAttributeCommandInterface) {
            this.applyCompositeCommandAttributes(request, (CompositeDynamicAttributeCommandInterface)command);
        } else {
            this.applySingleCommandAttributes(request, command);
        }
    }

    @SASScope
    public CommandEntry getCommandEntry(HttpServletRequest request) {
        if (request == null) {
            return null;
        }
        String cmdID = request.getParameter(CMDID);
        if (cmdID == null) {
            return null;
        }
        return (CommandEntry)this.commandRetrievalMap.get(cmdID);
    }

    private Class getAttributeTypeFromDescriptors(PropertyDescriptor[] pd, String attributeName) {
        if (pd == null || attributeName == null) {
            return null;
        }
        int length = Array.getLength(pd);
        for (int i = 0; i < length; ++i) {
            if (!attributeName.equals(pd[i].getName())) continue;
            return pd[i].getPropertyType();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void applyCompositeCommandAttributes(HttpServletRequest request, CompositeDynamicAttributeCommandInterface command) {
        Map storedAttributes;
        CommandEntry commandEntry = this.getCommandEntry(request);
        if (commandEntry == null || !(command instanceof DynamicAttributeCommandInterface)) {
            return;
        }
        Collection commandAttributeNames = command.getCommandAttributeNames();
        PropertyDescriptor[] pd = com.sas.servlet.util.BaseUtil.getPropertyDescriptors(command);
        if (commandAttributeNames != null) {
            Collection collection = commandAttributeNames;
            synchronized (collection) {
                for (String attributeName : commandAttributeNames) {
                    String[] stringParameterValues;
                    if (attributeName == null || (stringParameterValues = request.getParameterValues(this.parameterPrefix + attributeName)) == null || stringParameterValues.length <= 0) continue;
                    Class attributeType = this.getAttributeTypeFromDescriptors(pd, attributeName);
                    if (attributeType != null) {
                        Object objectAttributeValue = com.sas.servlet.util.BaseUtil.getObjectAttributeValue(stringParameterValues, attributeType);
                        if (objectAttributeValue == null) continue;
                        try {
                            ((DynamicAttributeCommandInterface)command).setAttribute(attributeName, objectAttributeValue);
                        }
                        catch (AttributeSetException attributeSetException) {}
                        continue;
                    }
                    int numberOfParameters = stringParameterValues.length;
                    try {
                        if (numberOfParameters == 1) {
                            String objectAttributeValue = stringParameterValues[0];
                            if (objectAttributeValue == null) continue;
                            ((DynamicAttributeCommandInterface)command).setAttribute(attributeName, (Object)objectAttributeValue);
                            continue;
                        }
                        if (numberOfParameters <= 1) continue;
                        ((DynamicAttributeCommandInterface)command).setAttribute(attributeName, (Object)stringParameterValues);
                    }
                    catch (AttributeSetException attributeSetException) {}
                }
            }
        }
        if ((storedAttributes = commandEntry.getStoredProperties()) != null && !storedAttributes.isEmpty()) {
            Set keySet;
            Set set = keySet = storedAttributes.keySet();
            synchronized (set) {
                for (String attributeName : keySet) {
                    Object attributeValue;
                    if (attributeName == null || (attributeValue = storedAttributes.get(attributeName)) == null) continue;
                    try {
                        if (!(command instanceof DynamicAttributeCommandInterface)) continue;
                        ((DynamicAttributeCommandInterface)command).setAttribute(attributeName, storedAttributes.get(attributeName));
                    }
                    catch (AttributeSetException attributeSetException) {}
                }
            }
        }
    }

    private void applySingleCommandAttributes(HttpServletRequest request, DynamicAttributeCommandInterface command) {
        PropertyDescriptor[] pd;
        CommandEntry commandEntry = this.getCommandEntry(request);
        if (commandEntry == null) {
            return;
        }
        HashMap storedAttributesCopy = ActionProviderMapPool.getMap();
        Map storedAttributes = commandEntry.getStoredProperties();
        if (storedAttributes != null) {
            storedAttributesCopy.putAll(storedAttributes);
        }
        if ((pd = com.sas.servlet.util.BaseUtil.getPropertyDescriptors(command)) == null) {
            com.sas.servlet.util.BaseUtil.applyCommandAttributesFromMap(command, storedAttributesCopy);
            ActionProviderMapPool.returnMap((Map)storedAttributesCopy);
            return;
        }
        int length = Array.getLength(pd);
        for (int i = 0; i < length; ++i) {
            String attributeName = pd[i].getName();
            if (attributeName == null) continue;
            Class<?> attributeTypeClass = pd[i].getPropertyType();
            Object objectAttributeValue = null;
            String[] stringParameterValues = request.getParameterValues(this.parameterPrefix + attributeName);
            if (stringParameterValues != null && stringParameterValues.length > 0) {
                objectAttributeValue = com.sas.servlet.util.BaseUtil.getObjectAttributeValue(stringParameterValues, attributeTypeClass);
            } else {
                objectAttributeValue = storedAttributesCopy.get(attributeName);
                if (attributeTypeClass != null && objectAttributeValue != null && objectAttributeValue instanceof String) {
                    try {
                        objectAttributeValue = BaseUtil.getStringToTransforms().transform(objectAttributeValue, attributeTypeClass);
                    }
                    catch (TransformException te) {
                        continue;
                    }
                    catch (NumberFormatException nfe) {
                        continue;
                    }
                }
            }
            if (objectAttributeValue == null) continue;
            storedAttributesCopy.remove(attributeName);
            com.sas.servlet.util.BaseUtil.setAttribute(command, pd[i], attributeName, objectAttributeValue);
        }
        com.sas.servlet.util.BaseUtil.applyCommandAttributesFromMap(command, storedAttributesCopy);
        ActionProviderMapPool.returnMap((Map)storedAttributesCopy);
    }

    public Map getStoredCommandAttributes(HttpServletRequest request) {
        if (request == null) {
            throw new IllegalArgumentException(RB.getStringResource((String)RB_KEY, (String)"nullRequest.txt"));
        }
        String cmdID = request.getParameter(CMDID);
        if (cmdID == null) {
            return null;
        }
        CommandEntry commandEntry = (CommandEntry)this.commandRetrievalMap.get(cmdID);
        if (commandEntry == null) {
            return null;
        }
        Map storedProperties = commandEntry.getStoredProperties();
        if (storedProperties == null) {
            return null;
        }
        HashMap copy = new HashMap(storedProperties);
        for (Object key : storedProperties.keySet()) {
            Object value = storedProperties.get(key);
            if (!(value instanceof ActionProviderReference)) continue;
            copy.put(key, ((ActionProviderReference)value).get());
        }
        return copy;
    }

    @SASScope
    public Map getDynamicCommandAttributes(HttpServletRequest request) {
        if (request == null) {
            throw new IllegalArgumentException(RB.getStringResource((String)RB_KEY, (String)"nullRequest.txt"));
        }
        Map storedProperties = this.getStoredCommandAttributes(request);
        Map commandProperties = this.getRequestCommandAttributes(request);
        if (storedProperties == null && commandProperties == null) {
            return null;
        }
        if (storedProperties == null) {
            return commandProperties;
        }
        commandProperties.putAll(storedProperties);
        return commandProperties;
    }

    public Map getRequestCommandAttributes(HttpServletRequest request) {
        HashMap<String, Object> propertyMap = new HashMap<String, Object>();
        DynamicAttributeCommandInterface command = this.getStoredCommand(request);
        if (command != null) {
            Class<?> commandClass = command.getClass();
            BeanInfo beanInfo = null;
            try {
                beanInfo = Introspector.getBeanInfo(commandClass);
            }
            catch (IntrospectionException e) {
                return propertyMap;
            }
            PropertyDescriptor[] pd = beanInfo.getPropertyDescriptors();
            int length = Array.getLength(pd);
            for (int i = 0; i < length; ++i) {
                Class<?> propertyTypeClass;
                String propertyName = pd[i].getName();
                if (propertyName == null) continue;
                int numberOfProperties = 0;
                String[] stringPropertyValues = request.getParameterValues(this.parameterPrefix + propertyName);
                if (stringPropertyValues == null || (numberOfProperties = stringPropertyValues.length) <= 0 || (propertyTypeClass = pd[i].getPropertyType()) == null) continue;
                Object objectPropertyValue = null;
                try {
                    if (numberOfProperties == 1) {
                        String propertyValue = stringPropertyValues[0];
                        if (propertyValue != null) {
                            objectPropertyValue = BaseUtil.getStringToTransforms().transform((Object)stringPropertyValues[0], propertyTypeClass);
                        }
                    } else {
                        objectPropertyValue = BaseUtil.getStringArrayToTransforms().transform((Object)stringPropertyValues, propertyTypeClass);
                    }
                }
                catch (TransformException transformException) {
                    // empty catch block
                }
                if (objectPropertyValue != null) {
                    propertyMap.put(propertyName, objectPropertyValue);
                    continue;
                }
                if (numberOfProperties == 1) {
                    propertyMap.put(propertyName, stringPropertyValues[0]);
                    continue;
                }
                propertyMap.put(propertyName, stringPropertyValues);
            }
        }
        return propertyMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reset() {
        HttpActionProvider httpActionProvider = this;
        synchronized (httpActionProvider) {
            ContentsChangedListener[] listeners;
            this.cmdLookUpMap.clear();
            this.commandRetrievalMap.clear();
            this.pendingStoredCommandList.clear();
            this.pendingExecutableCommandList.clear();
            this.encodedValueViewersMap.clear();
            this.viewerExternalParameters.clear();
            Map supportClassInstances = this.getSupportClassIntancesMap();
            if (supportClassInstances != null) {
                for (Object support : supportClassInstances.values()) {
                    if (support == null || !(support instanceof BaseActionProviderSupport)) continue;
                    ((BaseActionProviderSupport)support).reset();
                }
            }
            if (this.allContentsChangedListeners != null && (listeners = this.allContentsChangedListeners.getListeners()) != null) {
                for (int i = 0; i < listeners.length; ++i) {
                    this.allContentsChangedListeners.remove(listeners[i]);
                }
            }
        }
    }

    public void flush(Object viewer) {
        if (viewer == null) {
            throw new IllegalArgumentException(RB.getStringResource((String)RB_KEY, (String)"nullViewer.txt"));
        }
        if (viewer == ALL_VIEWERS) {
            this.reset();
            return;
        }
        this.flushViewerCommands(viewer);
        this.flushViewerEncodedValues(viewer);
        if (viewer instanceof HttpActionProviderViewInterface) {
            this.flushEverythingForHttpActionProviderViewer((HttpActionProviderViewInterface)viewer);
        }
        if (!(viewer instanceof BaseCompositeTransformation)) {
            return;
        }
        Map componentsMap = ((BaseCompositeTransformation)viewer).getComponents();
        if (componentsMap == null) {
            return;
        }
        for (Object component : componentsMap.values()) {
            if (component == null || component == viewer) continue;
            this.flush(component);
        }
    }

    private void flushEverythingForHttpActionProviderViewer(HttpActionProviderViewInterface viewer) {
        this.flushAdditionalViewerAttributes(viewer);
        if (viewer.getActionSupportType() != null) {
            this.flushViewerReferencesFromSupportClass(viewer);
        }
    }

    @SASScope
    public void unregisterContentsChangedListeners(Object viewer) {
        if (viewer == null) {
            throw new IllegalArgumentException(RB.getStringResource((String)RB_KEY, (String)"nullViewer.txt"));
        }
        if (viewer instanceof ContentsChangedListener) {
            this.removeContentsChangedListener((ContentsChangedListener)viewer);
        }
        if (!(viewer instanceof BaseCompositeTransformation)) {
            return;
        }
        Map componentsMap = ((BaseCompositeTransformation)viewer).getComponents();
        if (componentsMap == null) {
            return;
        }
        for (Object component : componentsMap.values()) {
            if (component == null || component == viewer) continue;
            this.unregisterContentsChangedListeners(component);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SASScope
    public void flushViewerCommands(Object viewer) {
        if (viewer == null) {
            throw new IllegalArgumentException(RB.getStringResource((String)RB_KEY, (String)"nullViewer.txt"));
        }
        Object viewerId = null;
        viewerId = viewer instanceof Integer ? viewer : (viewer instanceof HttpActionProviderViewInterface ? ((HttpActionProviderViewInterface)viewer).getUniqueId() : new Integer(System.identityHashCode(viewer)));
        List commandEntries = (List)this.cmdLookUpMap.get(viewerId);
        if (commandEntries == null) {
            return;
        }
        List list = commandEntries;
        synchronized (list) {
            Iterator ceIterator = commandEntries.iterator();
            CommandEntry commandEntry = null;
            while (ceIterator.hasNext()) {
                commandEntry = (CommandEntry)ceIterator.next();
                DynamicAttributeCommandInterface ci = commandEntry.getCommand();
                if (this.pendingStoredCommandList.contains(commandEntry.getCommand())) continue;
                if (commandEntry.getViewerId() == viewerId) {
                    this.commandRetrievalMap.remove(commandEntry.getCmdId());
                }
                ceIterator.remove();
            }
        }
    }

    @SASScope
    public void flushViewerEncodedValues(Object viewer) {
        if (viewer == null) {
            throw new IllegalArgumentException(RB.getStringResource((String)RB_KEY, (String)"nullViewer.txt"));
        }
        Object viewerId = null;
        viewerId = viewer instanceof Integer ? viewer : (viewer instanceof HttpActionProviderViewInterface ? ((HttpActionProviderViewInterface)viewer).getUniqueId() : new Integer(System.identityHashCode(viewer)));
        if (this.encodedValueViewersMap.containsKey(viewerId)) {
            this.encodedValueViewersMap.remove(viewerId);
        }
    }

    @SASScope
    public void dumpCommandLookUpMap(Object viewerId) {
        System.out.println("Dumping commandLookUpMap");
        for (Object next : this.cmdLookUpMap.keySet()) {
            System.out.println("\tFor viewer = " + next);
            List commandEntries = (List)this.cmdLookUpMap.get(next);
            int numberOfEntries = commandEntries.size();
            for (int i = 0; i < numberOfEntries; ++i) {
                CommandEntry commandEntry = (CommandEntry)commandEntries.get(i);
                System.out.println("\t\tCMDID = " + commandEntry.getCmdId() + ", command = " + commandEntry.getCommand().getClass().getName() + ", viewer = " + commandEntry.getViewerId());
            }
        }
    }

    @SASScope
    public void dumpRetrievalMap(Object id) {
        System.out.println("**** Starting dump of commandRetrievalMap");
        for (String cmdId : this.commandRetrievalMap.keySet()) {
            CommandEntry entry = (CommandEntry)this.commandRetrievalMap.get(cmdId);
            System.out.println("\tKEY: cmdId = " + cmdId + " VALUE(CommandEntry values): command class = " + entry.getCommand().getClass().getName() + ": viewerId = " + entry.getViewerId());
        }
    }

    private long getUniqueID() {
        return com.sas.util.Util.getNumber();
    }

    public void executeCommand(DynamicAttributeCommandInterface command, HttpServletRequest request, HttpServletResponse response, Object obj) throws IOException {
        if (command == null) {
            throw new IllegalArgumentException(RB.getStringResource((String)RB_KEY, (String)"nullCMD.txt"));
        }
        DynamicAttributeCommandInterface storedCommand = this.getStoredCommand(request);
        if (storedCommand == null) {
            return;
        }
        PendingCommandInterface pendingExecutableCommand = null;
        PendingCommandInterface pendingStoredCommand = null;
        boolean shouldCancel = true;
        while (shouldCancel) {
            if (!this.pendingExecutableCommandList.isEmpty()) {
                pendingExecutableCommand = (PendingCommandInterface)this.pendingExecutableCommandList.get(this.pendingExecutableCommandList.size() - 1);
            }
            if (!this.pendingStoredCommandList.isEmpty()) {
                pendingStoredCommand = (PendingCommandInterface)this.pendingStoredCommandList.get(this.pendingStoredCommandList.size() - 1);
            }
            if (pendingExecutableCommand != null && pendingStoredCommand != null && pendingStoredCommand != storedCommand && command instanceof BaseSelectorCommand) {
                int selectorType;
                DataSelectorInterface selector = ((BaseSelectorCommand)command).getSelector();
                if (selector instanceof BaseDataSelector && 5 == (selectorType = ((BaseDataSelector)selector).getSelectorType())) {
                    shouldCancel = false;
                }
                if (!shouldCancel) continue;
                pendingExecutableCommand.cancel();
                pendingStoredCommand = null;
                pendingExecutableCommand = null;
                this.pendingExecutableCommandList.remove(this.pendingExecutableCommandList.size() - 1);
                this.pendingStoredCommandList.remove(this.pendingStoredCommandList.size() - 1);
                continue;
            }
            shouldCancel = false;
        }
        if (command instanceof PendingCommandInterface) {
            if (pendingStoredCommand != storedCommand) {
                if (!this.pendingExecutableCommandList.contains(command)) {
                    this.pendingExecutableCommandList.add(command);
                }
                if (!this.pendingStoredCommandList.contains(storedCommand)) {
                    this.pendingStoredCommandList.add(storedCommand);
                }
            }
            pendingStoredCommand = (PendingCommandInterface)storedCommand;
            pendingExecutableCommand = (PendingCommandInterface)command;
        }
        if (command.isExecutable()) {
            if (command instanceof ApplyInterface) {
                int rc = ((ApplyInterface)command).apply(obj);
                if (rc == 1) {
                    command.undo();
                }
            } else {
                command.execute(obj);
            }
        }
        if (command instanceof PendingCommandInterface && ((PendingCommandInterface)command).isComplete()) {
            this.pendingExecutableCommandList.remove(pendingExecutableCommand);
            this.pendingStoredCommandList.remove(pendingStoredCommand);
            pendingStoredCommand = null;
            pendingExecutableCommand = null;
        }
        if (command instanceof ContentsChangedInterface && ((ContentsChangedInterface)command).isContentsChanged()) {
            this.fireContentsChanged(new ActionProviderEvent(((ContentsChangedInterface)command).getEventSource(), (Map)((ContentsChangedInterface)command).getEventInfo()));
        }
    }

    public synchronized DynamicAttributeCommandInterface executeCommand(HttpServletRequest request, HttpServletResponse response, Object obj) throws IOException {
        DynamicAttributeCommandInterface command = null;
        command = this.getExecutableCommand(request);
        if (command != null) {
            try {
                if (command instanceof CompositeDynamicAttributeCommandInterface) {
                    ((CompositeDynamicAttributeCommandInterface)command).setCommonAttribute("request", (Object)request);
                    ((CompositeDynamicAttributeCommandInterface)command).setCommonAttribute("response", (Object)response);
                }
                command.setAttribute("request", (Object)request);
                command.setAttribute("response", (Object)response);
            }
            catch (AttributeSetException attributeSetException) {
                // empty catch block
            }
            this.executeCommand(command, request, response, obj);
        }
        return command;
    }

    @SASScope
    protected void validateAction(BaseAction action, Collection viewers, Area area) {
        super.validateAction(action, viewers, area);
        if (!((HttpAction)action).isExternal() && ((HttpAction)action).isLink() && action.getCommand() == null) {
            throw new IllegalArgumentException(RB.getStringResource((String)RB_KEY, (String)"nullCommand.txt"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SASScope
    public void processAction(BaseAction action, ActionSupportFilter filter, AttributeDescriptorInterface[] attributeDescriptors, boolean listType) {
        super.processAction(action, filter, attributeDescriptors, listType);
        ActionProviderViewInterface viewer = filter.getViewer();
        this.setFullImageNames(action, viewer != null ? ((HttpActionProviderViewInterface)viewer).getRequest() : null);
        if (!listType) {
            HttpAction httpAction;
            Map addParms;
            AttributeDescriptorInterface adi2;
            String referringURI;
            Object uniqueId = viewer.getUniqueId();
            if (this.useReferringURIParameter && (referringURI = Util.getChainedReferringURI(viewer)) != null) {
                try {
                    action.setAttribute(REFERRING_URI_PARAMETER, (Object)referringURI);
                    adi2 = action.getAttributeDescriptor(REFERRING_URI_PARAMETER);
                    adi2.setSupplementalProperty("EXTERNAL", (Object)Boolean.TRUE);
                }
                catch (AttributeSetException adi2) {
                    // empty catch block
                }
            }
            if (!this.externalParameters.isEmpty()) {
                AttributeDescriptorInterface keySet;
                adi2 = keySet = this.externalParameters.keySet();
                synchronized (adi2) {
                    for (String currentKey : keySet) {
                        try {
                            action.setAttribute(currentKey, this.externalParameters.get(currentKey));
                            AttributeDescriptorInterface adi3 = action.getAttributeDescriptor(currentKey);
                            adi3.setSupplementalProperty("EXTERNAL", (Object)Boolean.TRUE);
                            adi3.setSupplementalProperty("ENCODE", (Object)Boolean.FALSE);
                        }
                        catch (AttributeSetException adi3) {}
                    }
                }
            }
            if ((addParms = (Map)this.viewerExternalParameters.get(uniqueId)) != null && !addParms.isEmpty()) {
                Set keySet = addParms.keySet();
                Set iterator2 = keySet;
                synchronized (iterator2) {
                    for (String currentKey : keySet) {
                        try {
                            action.setAttribute(currentKey, addParms.get(currentKey));
                            AttributeDescriptorInterface adi4 = action.getAttributeDescriptor(currentKey);
                            adi4.setSupplementalProperty("EXTERNAL", (Object)Boolean.TRUE);
                            adi4.setSupplementalProperty("ENCODE", (Object)Boolean.FALSE);
                        }
                        catch (AttributeSetException adi4) {}
                    }
                }
            }
            if (!(httpAction = (HttpAction)action).isExternal() && action.getCommand() != null) {
                StoredProperties storedProperties = null;
                Object viewerMap = null;
                try {
                    if (attributeDescriptors != null) {
                        Object value = null;
                        int descriptorsLength = attributeDescriptors.length;
                        for (int j = 0; j < descriptorsLength; ++j) {
                            if (attributeDescriptors[j].isVisible() || attributeDescriptors[j].getSupplementalProperty(COMMAND) == Boolean.FALSE) continue;
                            String attributeName = attributeDescriptors[j].getName();
                            if (action.listActionKeys().contains(attributeName)) continue;
                            String attributeLabel = attributeDescriptors[j].getLabel(Locale.getDefault());
                            if (storedProperties == null) {
                                storedProperties = ActionProviderStoredPropertiesPool.getStoredProperties();
                            }
                            storedProperties.putValue(attributeLabel != null ? attributeLabel : attributeName, action.getAttribute(attributeName));
                        }
                    }
                }
                catch (NoSuchElementException value) {
                    // empty catch block
                }
                String sCmdId = this.storeCommand(action.getCommand(), viewer, storedProperties, action.getId());
                if (storedProperties != null) {
                    ActionProviderStoredPropertiesPool.returnStoredProperties(storedProperties);
                }
                httpAction.setCmdId(sCmdId);
            }
            if (action.getValue("URL") == null) {
                action.putValue("URL", (Object)Util.generateURL(httpAction, this.getEncodedValuesMap(viewer)));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SASScope
    public void setUpAction(BaseAction action, ActionSupportFilter filter, List attributeDescriptors, boolean listType) {
        super.setUpAction(action, filter, attributeDescriptors, listType);
        ActionProviderViewInterface viewer = filter.getViewer();
        this.setFullImageNames(action, viewer != null ? ((HttpActionProviderViewInterface)viewer).getRequest() : null);
        if (!listType) {
            HttpAction httpAction;
            Map addParms;
            AttributeDescriptorInterface adi2;
            String referringURI;
            Object uniqueId = viewer.getUniqueId();
            if (this.useReferringURIParameter && (referringURI = Util.getChainedReferringURI(viewer)) != null) {
                try {
                    action.setAttribute(REFERRING_URI_PARAMETER, (Object)referringURI);
                    adi2 = action.getAttributeDescriptor(REFERRING_URI_PARAMETER);
                    adi2.setSupplementalProperty("EXTERNAL", (Object)Boolean.TRUE);
                }
                catch (AttributeSetException adi2) {
                    // empty catch block
                }
            }
            if (!this.externalParameters.isEmpty()) {
                AttributeDescriptorInterface keySet;
                adi2 = keySet = this.externalParameters.keySet();
                synchronized (adi2) {
                    for (String currentKey : keySet) {
                        try {
                            action.setAttribute(currentKey, this.externalParameters.get(currentKey));
                            AttributeDescriptorInterface adi3 = action.getAttributeDescriptor(currentKey);
                            adi3.setSupplementalProperty("EXTERNAL", (Object)Boolean.TRUE);
                            adi3.setSupplementalProperty("ENCODE", (Object)Boolean.FALSE);
                        }
                        catch (AttributeSetException adi3) {}
                    }
                }
            }
            if ((addParms = (Map)this.viewerExternalParameters.get(uniqueId)) != null && !addParms.isEmpty()) {
                Set keySet = addParms.keySet();
                Set iterator2 = keySet;
                synchronized (iterator2) {
                    for (String currentKey : keySet) {
                        try {
                            action.setAttribute(currentKey, addParms.get(currentKey));
                            AttributeDescriptorInterface adi4 = action.getAttributeDescriptor(currentKey);
                            adi4.setSupplementalProperty("EXTERNAL", (Object)Boolean.TRUE);
                            adi4.setSupplementalProperty("ENCODE", (Object)Boolean.FALSE);
                        }
                        catch (AttributeSetException adi4) {}
                    }
                }
            }
            if (!(httpAction = (HttpAction)action).isExternal() && action.getCommand() != null) {
                StoredProperties storedProperties = null;
                Object viewerMap = null;
                try {
                    if (attributeDescriptors != null) {
                        Object value = null;
                        int size = attributeDescriptors.size();
                        for (int j = 0; j < size; ++j) {
                            AttributeDescriptorInterface adi5 = (AttributeDescriptorInterface)attributeDescriptors.get(j);
                            if (adi5.isVisible() || adi5.getSupplementalProperty(COMMAND) == Boolean.FALSE) continue;
                            String attributeName = adi5.getName();
                            if (action.listActionKeys().contains(attributeName)) continue;
                            String attributeLabel = adi5.getLabel(Locale.getDefault());
                            if (storedProperties == null) {
                                storedProperties = ActionProviderStoredPropertiesPool.getStoredProperties();
                            }
                            storedProperties.putValue(attributeLabel != null ? attributeLabel : attributeName, action.getAttribute(attributeName));
                        }
                    }
                }
                catch (NoSuchElementException value) {
                    // empty catch block
                }
                String sCmdId = this.storeCommand(action.getCommand(), viewer, storedProperties, action.getId());
                if (storedProperties != null) {
                    ActionProviderStoredPropertiesPool.returnStoredProperties(storedProperties);
                }
                httpAction.setCmdId(sCmdId);
            }
            if (action.getValue("URL") == null) {
                action.putValue("URL", (Object)Util.generateURL(httpAction, this.getEncodedValuesMap(viewer)));
            }
        }
    }

    @SASScope
    public Map getEncodedValuesMap(ActionProviderViewInterface viewer) {
        if (this.encodedValueViewersMap.size() > 30) {
            this.encodedValueViewersMap.clear();
        }
        Object viewerId = null;
        viewerId = viewer instanceof HttpActionProviderViewInterface ? ((HttpActionProviderViewInterface)viewer).getUniqueId() : new Integer(System.identityHashCode(viewer));
        Map encodedValuesMap = null;
        if (viewer != null) {
            encodedValuesMap = (Map)this.encodedValueViewersMap.get(viewerId);
            if (encodedValuesMap == null) {
                encodedValuesMap = Collections.synchronizedMap(new HashMap(255));
                this.encodedValueViewersMap.put(viewerId, encodedValuesMap);
            } else if (encodedValuesMap.size() > 127) {
                encodedValuesMap.clear();
            }
        }
        return encodedValuesMap;
    }

    private void setFullImageNames(BaseAction action, HttpServletRequest request) {
        ComponentPropertyManager cpm = ComponentPropertyManager.getInstance(request);
        String _imageLocation = this.imageLocation != null ? this.imageLocation : cpm.getImageLocation();
        this.setActionImage(action, "SmallIconName", "ImageKey", cpm, _imageLocation);
        this.setActionImage(action, "SmallDisabledIconName", "DisabledImageKey", cpm, _imageLocation);
        this.setActionImage(action, "RolloverIconName", "RolloverImageKey", cpm, _imageLocation);
    }

    private void setActionImage(BaseAction action, String imageAttributeName, String imageKeyAttributeName, ComponentPropertyManager cpm, String location2) {
        String imageName = (String)action.getValue(imageAttributeName);
        if (imageName != null) {
            action.putValue(imageAttributeName, (Object)(location2 + imageName));
            return;
        }
        String imageKey = (String)action.getValue(imageKeyAttributeName);
        if (imageKey != null) {
            action.putValue(imageAttributeName, (Object)cpm.getImageURI(imageKey, this.imageLocation));
        }
    }

    public String storeCommand(DynamicAttributeCommandInterface command, Object viewer, Map storedProperties) {
        this.getActionProviderReference(viewer);
        return this.storeCommand(command, viewer, new StoredProperties(storedProperties), null);
    }

    private String storeCommand(DynamicAttributeCommandInterface command, Object viewer, StoredProperties storedProperties, String defaultCmdId) {
        if (command == null) {
            throw new IllegalArgumentException(RB.getStringResource((String)RB_KEY, (String)"nullCMD.txt"));
        }
        if (viewer == null) {
            throw new IllegalArgumentException(RB.getStringResource((String)RB_KEY, (String)"nullViewer.txt"));
        }
        Object uniqueId = viewer instanceof HttpActionProviderViewInterface ? ((HttpActionProviderViewInterface)viewer).getUniqueId() : new Integer(System.identityHashCode(viewer));
        CommandEntry commandEntry = this.getCommandEntry(command, uniqueId, storedProperties, defaultCmdId);
        String cmdId = commandEntry.getCmdId();
        this.commandRetrievalMap.put(cmdId, commandEntry);
        return cmdId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private CommandEntry getCommandEntry(DynamicAttributeCommandInterface command, Object viewerId, StoredProperties newStoredProperties, String defaultCmdId) {
        commandEntries = (Vector<CommandEntry>)this.cmdLookUpMap.get(viewerId);
        if (commandEntries == null) {
            commandEntries = new Vector<CommandEntry>(30);
            this.cmdLookUpMap.put(viewerId, commandEntries);
            cmdId = defaultCmdId != null ? defaultCmdId : String.valueOf(this.getUniqueID());
            commandEntry = new CommandEntry(command, viewerId, this.getStoredPropertiesCopy(newStoredProperties), cmdId);
            commandEntries.add(commandEntry);
            return commandEntry;
        }
        numberOfEntries = commandEntries.size();
        i = 0;
        block2: while (true) {
            block16: {
                block15: {
                    if (i >= numberOfEntries) break block15;
                    currentEntry = (CommandEntry)commandEntries.get(i);
                    if (currentEntry.getCommand() != command) ** GOTO lbl49
                    storedProperties = currentEntry.getStoredPropertiesObject();
                    if (storedProperties == null && newStoredProperties == null) {
                        return currentEntry;
                    }
                    if (storedProperties == null || newStoredProperties == null || (size = storedProperties.size()) != newStoredProperties.size()) ** GOTO lbl49
                    break block16;
                }
                cmdId = defaultCmdId;
                if (viewerId == null || defaultCmdId == null) {
                    cmdId = String.valueOf(this.getUniqueID());
                } else {
                    numEntries = commandEntries.size();
                    for (i = 0; i < numEntries && cmdId == defaultCmdId; ++i) {
                        currentEntry = (CommandEntry)commandEntries.get(i);
                        if (!currentEntry.getCmdId().equals(defaultCmdId)) continue;
                        cmdId = String.valueOf(this.getUniqueID());
                    }
                }
                commandEntry = new CommandEntry(command, viewerId, this.getStoredPropertiesCopy(newStoredProperties), cmdId);
                commandEntries.add(commandEntry);
                return commandEntry;
            }
            match = true;
            var13_20 = _keys = storedProperties._keys;
            // MONITORENTER : _keys
            k = 0;
            while (true) {
                if (k < size && match) {
                    foundKey = false;
                } else {
                    // MONITOREXIT : var13_20
                    if (match) {
                        return currentEntry;
                    }
lbl49:
                    // 4 sources

                    ++i;
                    continue block2;
                }
                for (j = 0; j < size && match; ++j) {
                    if (!_keys[j].equals(newStoredProperties._keys[k])) continue;
                    foundKey = true;
                    value = storedProperties._values[j];
                    spValue = newStoredProperties._values[k];
                    if (value == spValue) continue;
                    if (value == null || spValue == null) {
                        match = false;
                        continue;
                    }
                    if (value.equals(spValue)) continue;
                    match = false;
                }
                if (!foundKey) {
                    match = false;
                }
                ++k;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isCurrentEntryMatch(CommandEntry entry, DynamicAttributeCommandInterface command, Object viewerId, StoredProperties newStoredProperties) {
        Object[] _keys;
        StoredProperties storedProperties = entry.getStoredPropertiesObject();
        if (storedProperties == null && newStoredProperties == null) {
            return true;
        }
        if (storedProperties == null || newStoredProperties == null) {
            return false;
        }
        int size = storedProperties.size();
        if (size != newStoredProperties.size()) {
            return false;
        }
        Object[] objectArray = _keys = storedProperties._keys;
        synchronized (_keys) {
            for (int k = 0; k < size; ++k) {
                boolean foundKey = false;
                for (int j = 0; j < size; ++j) {
                    if (!_keys[j].equals(newStoredProperties._keys[k])) continue;
                    foundKey = true;
                    Object value = storedProperties._values[j];
                    Object spValue = newStoredProperties._values[k];
                    if (value == spValue) continue;
                    if (value == null || spValue == null) {
                        // ** MonitorExit[var8_8] (shouldn't be in output)
                        return false;
                    }
                    if (value.equals(spValue)) continue;
                    // ** MonitorExit[var8_8] (shouldn't be in output)
                    return false;
                }
                if (foundKey) continue;
                // ** MonitorExit[var8_8] (shouldn't be in output)
                return false;
            }
            // ** MonitorExit[var8_8] (shouldn't be in output)
            return true;
        }
    }

    private StoredProperties getStoredPropertiesCopy(StoredProperties storedProperties) {
        if (storedProperties == null || storedProperties.size() == 0) {
            return null;
        }
        return new StoredProperties(storedProperties);
    }

    public void fireContentsChanged(ActionProviderEvent event) {
        if (this.allContentsChangedListeners != null) {
            this.allContentsChangedListeners.contentsChanged((ContentsChangedEvent)event);
        }
    }

    @SASScope
    public void returnAction(BaseAction action) {
        if (action == null) {
            return;
        }
        Class<?> actionClass = action.getClass();
        if (actionClass == SelectorAction.class) {
            ActionProviderSelectorActionPool.returnSelectorAction((SelectorAction)action);
        } else if (actionClass == HttpAction.class) {
            ActionProviderHttpActionPool.returnHttpAction((HttpAction)action);
        } else {
            ActionProviderViewInterface actionProviderViewInterface = action.getViewer();
        }
    }

    @SASScope
    public BaseAction getAction(BaseAction action, boolean fromPoolIfPossible) {
        BaseAction returnAction = null;
        if (fromPoolIfPossible) {
            if (action.getClass() == SelectorAction.class) {
                returnAction = ActionProviderSelectorActionPool.getSelectorAction();
                SelectorAction.moveAttributes((SelectorAction)action, (SelectorAction)returnAction);
            } else if (action.getClass() == HttpAction.class) {
                returnAction = ActionProviderHttpActionPool.getHttpAction();
                HttpAction.moveAttributes((HttpAction)action, (HttpAction)returnAction);
            } else {
                try {
                    returnAction = (BaseAction)action.clone();
                }
                catch (CloneNotSupportedException cnse) {
                    return null;
                }
            }
        } else {
            try {
                returnAction = (BaseAction)action.clone();
            }
            catch (CloneNotSupportedException cnse) {
                return null;
            }
        }
        return returnAction;
    }

    @SASScope
    public ActionList getActions(ActionSupportFilter filter) {
        ActionList actionList = super.getActions(filter);
        if (actionList != null) {
            this.getActionProviderReference(filter.getViewer());
        }
        this.clearActionProviderReferences();
        return actionList;
    }

    private void clearActionProviderReferences() {
        ActionProviderReference ref = null;
        while ((ref = (ActionProviderReference)this.referenceQueue.poll()) != null) {
            Object referentId = ref.getReferentId();
            if (referentId != null) {
                this.flushViewerCommands(referentId);
                this.flushViewerEncodedValues(referentId);
                this.viewerExternalParameters.remove(referentId);
                this.removeContentsChangedListenerById(referentId);
            }
            this.actionProviderReferencesList.remove(ref);
            ref.clear();
        }
    }

    @SASScope
    public BaseAction getAction(String actionType, ActionSupportFilter filter) {
        BaseAction action = super.getAction(actionType, filter);
        if (action != null) {
            this.getActionProviderReference(filter.getViewer());
        }
        this.clearActionProviderReferences();
        return action;
    }

    @SASScope
    public void addContentsChangedListener(ContentsChangedListener listener) {
        ActionProviderReference existingReferenceForListener;
        if (this.allContentsChangedListeners == null) {
            this.allContentsChangedListeners = new ContentsChangedListenerList();
        }
        if ((existingReferenceForListener = this.findExistingListenerReference(listener)) != null) {
            return;
        }
        this.allContentsChangedListeners.add((ContentsChangedListener)this.getActionProviderReference(listener));
    }

    @SASScope
    public void removeContentsChangedListener(ContentsChangedListener listener) {
        if (this.allContentsChangedListeners != null) {
            ActionProviderReference existingReferenceForListener = this.findExistingListenerReference(listener);
            if (existingReferenceForListener != null) {
                this.allContentsChangedListeners.remove((ContentsChangedListener)existingReferenceForListener);
            } else {
                this.allContentsChangedListeners.remove(listener);
            }
        }
    }

    private ActionProviderReference findExistingListenerReference(ContentsChangedListener listener) {
        ContentsChangedListener[] listeners = this.allContentsChangedListeners.getListeners();
        if (listeners == null) {
            return null;
        }
        for (int i = 0; i < listeners.length; ++i) {
            if (!(listeners[i] instanceof ActionProviderReference) || ((ActionProviderReference)listeners[i]).get() != listener) continue;
            return (ActionProviderReference)listeners[i];
        }
        return null;
    }

    private void removeContentsChangedListenerById(Object id) {
        ActionProviderReference viewerReference;
        if (this.allContentsChangedListeners != null && (viewerReference = this.getActionProviderReferenceFromList(id)) != null) {
            this.allContentsChangedListeners.remove((ContentsChangedListener)viewerReference);
        }
    }

    @SASScope
    public ActionProviderReference getActionProviderReference(Object o) {
        if (o == null) {
            return null;
        }
        if (!(o instanceof ActionProviderViewInterface)) {
            return new ActionProviderReference(o);
        }
        ActionProviderReference actionProviderReference = this.getActionProviderReferenceFromList(o);
        if (actionProviderReference != null) {
            return actionProviderReference;
        }
        actionProviderReference = new ActionProviderReference(o, this.referenceQueue);
        this.actionProviderReferencesList.add(actionProviderReference);
        return actionProviderReference;
    }

    private ActionProviderReference getActionProviderReferenceFromList(Object o) {
        if (o == null) {
            return null;
        }
        int num = this.actionProviderReferencesList.size();
        for (int i = 0; i < num; ++i) {
            ActionProviderReference viewerReference = (ActionProviderReference)this.actionProviderReferencesList.get(i);
            if (viewerReference.get() != o && viewerReference.getReferentId() != o) continue;
            return viewerReference;
        }
        return null;
    }

    private static CommonLoggerInterface getLog() {
        if (_log == null) {
            _log = LoggerRepository2.getLogger((String)HttpActionProvider.class.getPackage().getName(), null);
        }
        return _log;
    }
}

