/*
 * Decompiled with CFR 0.152.
 */
package com.sas.actionprovider;

import com.sas.actionprovider.ActionList;
import com.sas.actionprovider.BaseAction;
import com.sas.actionprovider.SelectorAction;
import com.sas.actionprovider.Util;
import com.sas.codepolicy.SASScope;
import com.sas.servlet.tbeans.menus.model.BaseMenuItemInterface;
import com.sas.servlet.tbeans.menus.model.PopupMenuItem;
import com.sas.swing.util.Action;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;

@SASScope
public class ActionListToPopupMenuModelAdapter
extends ArrayList {
    public ActionListToPopupMenuModelAdapter(ActionList actionList, HttpServletRequest request) {
        this.convertActionListToPopupMenuModel(actionList, request);
    }

    private void convertActionListToPopupMenuModel(ActionList actionList, HttpServletRequest request) {
        if (actionList == null || actionList.isEmpty()) {
            return;
        }
        List actions = actionList.getActions();
        for (int i = 0; i < actions.size(); ++i) {
            String url;
            SelectorAction action;
            PopupMenuItem menuItem;
            Object actionEntry = actions.get(i);
            if (actionEntry == null) continue;
            if (actionEntry == ActionList.SEPARATOR) {
                BaseMenuItemInterface lastItem;
                BaseMenuItemInterface baseMenuItemInterface = lastItem = this.size() < 1 ? null : (PopupMenuItem)this.get(this.size() - 1);
                if (lastItem != null && lastItem.isSeparator() || lastItem == null || i == actions.size() - 1 || i != actions.size() - 1 && actions.get(i + 1) == ActionList.SEPARATOR) continue;
                menuItem = new PopupMenuItem();
                menuItem.setSeparator(true);
                this.add(menuItem);
                continue;
            }
            if (actionEntry instanceof ActionList) {
                ActionList cascadingMenuActionList = (ActionList)actionEntry;
                menuItem = new PopupMenuItem();
                menuItem.setDisabled(!cascadingMenuActionList.isEnabled());
                menuItem.setText(Util.getLabel((Action)cascadingMenuActionList));
                menuItem.setImage(Util.getImage((Action)cascadingMenuActionList));
                menuItem.setAlternateText(Util.getAltText((Action)cascadingMenuActionList));
                menuItem.setCascadingMenu(new ActionListToPopupMenuModelAdapter(cascadingMenuActionList, request));
                this.add(menuItem);
                continue;
            }
            if (actionEntry instanceof SelectorAction) {
                action = (SelectorAction)actionEntry;
                menuItem = new PopupMenuItem();
                menuItem.setDisabled(!action.isEnabled());
                menuItem.setText(Util.getLabel(action));
                menuItem.setImage(Util.getImage(action));
                menuItem.setAlternateText(Util.getAltText(action));
                menuItem.setTitle(Util.getTitle(action));
                if (!menuItem.isDisabled()) {
                    if (action.isDefaultURLSuppressed()) {
                        url = (String)action.getValue("URL");
                        if (this.isJavascript(url)) {
                            menuItem.setJavascript(url);
                        } else {
                            menuItem.setUrl(url);
                        }
                    } else {
                        menuItem.setJavascript(this.getSelectorJavaScript(action, request));
                    }
                }
                this.add(menuItem);
                continue;
            }
            if (!(actionEntry instanceof Action)) continue;
            action = (Action)actionEntry;
            menuItem = new PopupMenuItem();
            menuItem.setDisabled(!action.isEnabled());
            menuItem.setText(Util.getLabel(action));
            menuItem.setImage(Util.getImage(action));
            menuItem.setAlternateText(Util.getAltText(action));
            menuItem.setTitle(Util.getTitle(action));
            if (!menuItem.isDisabled()) {
                url = (String)action.getValue("URL");
                if (this.isJavascript(url)) {
                    menuItem.setJavascript(url.replaceFirst("javascript:", ""));
                } else {
                    menuItem.setUrl(url);
                }
            }
            this.add(menuItem);
        }
    }

    private String getSelectorJavaScript(SelectorAction action, HttpServletRequest request) {
        StringBuffer js = new StringBuffer();
        js.append("SelectorMenuBar_openExternalSelector(\"");
        js.append((String)action.getValue("URL"));
        js.append("\",\"");
        js.append(action.getSelectorWidth() == 0 ? "450" : Integer.toString(action.getSelectorWidth()));
        js.append("\",\"");
        js.append(action.getSelectorHeight() == 0 ? "600" : Integer.toString(action.getSelectorHeight()));
        js.append("\",\"");
        if ((String)action.getValue("Target") == null) {
            js.append("opener");
            if (request != null) {
                js.append(request.getSession().getCreationTime());
            }
        } else {
            js.append((String)action.getValue("Target"));
        }
        js.append("\",\"");
        js.append(action.isModal());
        js.append("\",\"");
        js.append(this.getTagId(action));
        js.append("_dropper");
        js.append("\");");
        return js.toString();
    }

    private boolean isJavascript(String url) {
        return url == null ? false : url.startsWith("javascript:");
    }

    private String getTagId(Action action) {
        String tagId = null;
        if (action instanceof BaseAction) {
            tagId = ((BaseAction)action).getId();
            if (tagId == null) {
                tagId = com.sas.util.Util.getName((String)"a");
                ((BaseAction)action).setId(tagId);
            }
        } else if (action instanceof ActionList && (tagId = ((ActionList)action).getId()) == null) {
            tagId = com.sas.util.Util.getName((String)"al");
            ((ActionList)action).setId(tagId);
        }
        return tagId;
    }
}

