/*
 * Decompiled with CFR 0.152.
 */
package com.sas.actionprovider;

import com.sas.actionprovider.ActionList;
import com.sas.actionprovider.ActionOrderList;
import com.sas.actionprovider.BaseAction;
import com.sas.actionprovider.BaseActionProvider;
import com.sas.actionprovider.HttpActionProvider;
import com.sas.actionprovider.SwingActionProvider;
import com.sas.codepolicy.SASScope;
import com.sas.entities.AttributeDescriptorInterface;
import com.sas.swing.visuals.util.Util;
import com.sas.util.SimpleTemplate;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;

@SASScope
public class ActionDocumenter {
    static final String RB_KEY = "ActionDocumenter.";
    private static final boolean javadoc = true;
    private static final String LINE_BREAK_TAG = "<br>";
    private static final String DL_TAG_BEGIN = "<DL>";
    private static final String DL_TAG_END = "</DL>";
    private static final String DD_TAG_BEGIN = "<DD>";
    private static final String DD_TAG_END = "</DD>";
    private static final String TABLE_TAG_BEGIN = "<table>";
    private static final String TABLE_TAG_END = "</table>";
    private static final String TR_TAG_BEGIN = "   <tr>";
    private static final String TR_TAG_END = "   </tr>";
    private static final String TD_START_ALIGN = "<td align=\"center\">";
    private static final String TD_START_ROWSPAN = "<td align=\"center\" rowspan=\"";
    private static final String TD_TAG_END = " </td>";
    private static final String TABLE_START_TAG = "<table border=\"1\" cellpadding=\"3\" cellspacing=\"0\">";
    private static final String TR_FIRST_ROW_START = "   <tr bgcolor=\"#ccccff\">";
    private static final String TR_EVEN_START = "   <tr bgcolor=\"#eeeeff\">";
    private static final String QUOTE = "\"";
    private static final String END_TAG = ">";
    private static final String JAVADOC_CONSTANT = " * ";
    private static final String TAB_CONSTANT = "   ";
    private static final String TD_TAB_CONSTANT = "      ";
    private static final String HEADER_CELLS = "      <th> <b>actionType Key</b> </th><th> <b>Attribute Name</b> </th> <th> <b>Object Type</b> </th><th> <b>Default Value</b> </th>";
    private static final String START_LINK = " {@link ";
    private static final String END_LINK = "}";
    private static final String HTML_QUOTE = "&quot;";
    private static final String HTML_SPACE = "&#160;";
    private static Map interfaceKeysMap;
    private static List javaActionInterfaceKeys;
    private static List nonDocumentedAttributes;
    private static Collection primitiveTypes;
    private static Map returnStatusValues;
    private static int[] returnStatusValuesArray;
    private int apPackageDistance = 0;
    private int rootPackageDistance = 0;
    private String supportKey;
    private boolean swing;
    private String supportClassName;
    private String fqSupportClassName;
    private String filePrefix;

    public ActionDocumenter(String supportKey, boolean swing) {
        this.supportKey = supportKey;
        this.swing = swing;
        this.fqSupportClassName = (String)this.getActionProvider().getSupportClassNamesMap().get(supportKey);
        this.supportClassName = this.fqSupportClassName.substring(this.fqSupportClassName.lastIndexOf(".") + 1);
    }

    public void setFilePrefix(String prefix) {
        this.filePrefix = prefix;
    }

    public String getFilePrefix() {
        return this.filePrefix;
    }

    public void writeAll(String areaType, String path) {
        this.writeDescriptionFiles(areaType, path);
        this.writeAreaTOC(areaType, path);
        this.writeActionFiles(areaType, path);
        this.writeActionOrderListFiles(areaType, path);
        this.writeAreaScopeAttributeFiles(areaType, path);
        System.out.println("ActionDocumenter: writeAll(" + areaType + "): finish");
    }

    public void writeDescriptionFiles(String areaType, String path) {
        this.updateDistanceVariables(path);
        this.writeFrameSetFile(areaType, this.getFQFileName(path, this.getFileName(areaType, "-Frame")), "Description");
        this.writeAreaDescriptionFrame(areaType, path);
    }

    private void writeAreaDescriptionFrame(String areaType, String path) {
        this.updateDistanceVariables(path);
        PrintWriter pw = this.getPrintWriterFromFileName(this.getFQFileName(path, this.getFileName(areaType, "Description")));
        if (pw == null) {
            return;
        }
        this.writeFrameTop(pw, areaType, "Description");
        pw.println("<p class=\"descriptionText\"> The " + areaType + " is highlighted in the picture below.");
        pw.println("</p>");
        pw.println("<img src=\"" + this.getJPGName(areaType, null) + "\" border=\"1\" alt=\"\">");
        pw.println("");
        pw.println("<p class=\"descriptionText\">All of the default actionTypes that are registered to this area are listed to the left.</p>");
        pw.println("");
        pw.println("<p class=\"descriptionText\">See the \"Default ActionOrderList\" section for information related to the ordering and structure of these actionTypes. </p>");
        pw.println("");
        pw.println("</body>");
        pw.println("</html>");
        pw.flush();
        pw.close();
    }

    public void writeAreaTOC(String areaType, String path) {
        this.updateDistanceVariables(path);
        PrintWriter pw = this.getPrintWriterFromFileName(this.getFQFileName(path, this.getFileName(areaType, "TOC")));
        if (pw == null) {
            return;
        }
        String prefix = this.getFilePrefix();
        pw.println("<html>");
        pw.println("<head><title></title>");
        pw.println("<LINK REL=Stylesheet href=\"" + this.getPathPrefix(0, true) + "doc-files/actionProviderDoc.css\">");
        pw.println("</head>");
        pw.println("<body class=\"toc\">");
        pw.println("\n");
        pw.println("<p class=\"TOCText\"><b>General Information:</b>");
        pw.println("<br><a target=\"_top\" href=\"" + (prefix != null ? prefix + "_" : "") + areaType.replaceAll("_", "") + "-Frame" + this.getTypeSuffix() + ".html\">Area Description</a>");
        pw.println("<br><a target=\"_top\" href=\"" + (prefix != null ? prefix + "_" : "") + areaType.replaceAll("_", "") + "_ActionOrderList-Frame" + this.getTypeSuffix() + ".html\">Default ActionOrderList</a>");
        pw.println("<br><a target=\"_top\" href=\"" + (prefix != null ? prefix + "_" : "") + areaType.replaceAll("_", "") + "_AreaScopeAttributes-Frame" + this.getTypeSuffix() + ".html\">Area Scope Attributes</a>");
        pw.println("\n");
        pw.println(LINE_BREAK_TAG);
        pw.println("<p class=\"TOCText\"><b>Action Types:</b>");
        BaseActionProvider ap = this.getActionProvider();
        List orderedActionTypes = this.getOrderedActionTypes(ap.getActionOrderList(this.supportKey, null, areaType));
        if (orderedActionTypes != null) {
            for (String actionType : orderedActionTypes) {
                if (actionType == null) continue;
                pw.println("<br><a target=\"_top\" href=\"" + (prefix != null ? prefix + "_" : "") + areaType.replaceAll("_", "") + "_" + actionType.replaceAll("_", "") + "-Frame" + this.getTypeSuffix() + ".html\">" + actionType + "</a>");
            }
        }
        pw.println("</p>");
        pw.println("</body>");
        pw.println("</html>");
        pw.flush();
        pw.close();
    }

    public void writeActionFiles(String areaType, String path) {
        this.updateDistanceVariables(path);
        BaseActionProvider ap = this.getActionProvider();
        List orderedActionTypes = this.getOrderedActionTypes(ap.getActionOrderList(this.supportKey, null, areaType));
        if (orderedActionTypes != null) {
            for (String actionType : orderedActionTypes) {
                if (actionType == null) continue;
                String at = actionType.replaceAll("_", "");
                this.writeFrameSetFile(areaType, this.getFQFileName(path, this.getFileName(areaType, at + "-Frame")), at);
                this.writeActionFile(areaType, actionType, path);
            }
        }
    }

    private void writeActionFile(String areaType, String actionType, String path) {
        this.updateDistanceVariables(path);
        PrintWriter pw = this.getPrintWriterFromFileName(this.getFQFileName(path, this.getFileName(areaType, actionType.replaceAll("_", ""))));
        if (pw == null) {
            return;
        }
        BaseAction action = this.getActionProvider().getDefaultAction(this.supportKey, areaType, actionType);
        if (action == null) {
            return;
        }
        this.writeFrameTop(pw, areaType, actionType.replaceAll("_", ""));
        pw.println("<p class=\"actionTypeLabel\" ><b> " + actionType + " </b>");
        pw.println(LINE_BREAK_TAG);
        pw.println(LINE_BREAK_TAG);
        pw.println("<img src=\"" + this.getJPGName(areaType, actionType) + "\" border=\"1\" alt=\"\">");
        pw.println(LINE_BREAK_TAG);
        pw.println("<p class=\"actionAttributeTableLabel\"> Action Interface-Based Attributes </p>");
        pw.println("");
        pw.println("<p><table border=\"1\" cellpadding=\"3\" cellspacing=\"0\">");
        pw.println("  <tr>");
        pw.println("    <th class=\"defaultWithColor\"> <b>Name</b> </th> <th class=\"defaultWithColor\"> <b>Value</b> </th>");
        pw.println("  </tr>");
        this.writeInterfaceAttributesRows(pw, action);
        pw.println("</table></p>");
        pw.println(LINE_BREAK_TAG);
        pw.println("<p class=\"actionAttributeTableLabel\"> Class-Based Attributes </p>");
        pw.println("<p><table border=\"1\" cellpadding=\"3\" cellspacing=\"0\">");
        pw.println("  <tr>");
        String lastColumns = this.swing ? "<th class=\"defaultWithColor\"> <b> Dynamic </b> </th>" : "<th class=\"defaultWithColor\"> <a href=\"" + this.getPathPrefix(0, true) + "BaseAction.html#DYNAMIC\"> Dynamic </a> </th> <th class=\"defaultWithColor\"> <a href=\"" + this.getPathPrefix(0, true) + "BaseAction.html#COMMAND\"> Command </a> </th> <th class=\"defaultWithColor\"> <a href=\"" + this.getPathPrefix(-1, false) + "com/sas/entities/AttributeDescriptorInterface.html#setVisible(boolean)\"> Visible </a> </th>";
        pw.println("    <th class=\"defaultWithColor\"> <b>Name</b> </th> <th class=\"defaultWithColor\"> <b>Value</b> </th> " + lastColumns);
        pw.println("  </tr>");
        this.writeClassAttributesRows(pw, action);
        pw.println("</table></p>");
        pw.println(LINE_BREAK_TAG);
        pw.println("<p class=\"actionAttributeTableLabel\"> Instance-Based Attributes </p>");
        pw.println("<p><table border=\"1\" cellpadding=\"3\" cellspacing=\"0\">");
        pw.println("  <tr>");
        pw.println("    <th class=\"defaultWithColor\"> <b>Name</b> </th> <th class=\"defaultWithColor\"> <b>Object Type</b> </th> " + lastColumns);
        pw.println("  </tr>");
        this.writeInstanceAttributesRows(pw, action);
        pw.println("</table></p>");
        if (!this.swing) {
            pw.println("<p class=\"actionAttributesText\"> ** See the following <a href=\"" + this.getPathPrefix(0, true) + "BaseAction.html#ATTRIBUTE_PROPERTY_TYPES\"> documentation </a> on the BaseAction class for more information on the Dynamic, Command and Visible attribute properties. </p>");
        }
        pw.println("</body>");
        pw.println("</html>");
        pw.flush();
        pw.close();
    }

    private void writeInterfaceAttributesRows(PrintWriter pw, BaseAction action) {
        int rowCount = 1;
        Set interfaceKeys = interfaceKeysMap.keySet();
        for (String key : interfaceKeys) {
            Object value;
            if (nonDocumentedAttributes.contains((String)interfaceKeysMap.get(key)) || (value = action.getValue(key)) == null) continue;
            if (rowCount % 2 == 0) {
                pw.println("<tr class=\"defaultWithColor\">");
            } else {
                pw.println("<tr class=\"default\">");
            }
            ++rowCount;
            pw.print("  <td> " + this.getInterfaceAttributeLink((String)interfaceKeysMap.get(key)) + TD_TAG_END);
            pw.print(" <td> " + this.getDefaultValue(key, value) + TD_TAG_END);
            pw.println("</tr>");
        }
        if (rowCount == 1) {
            pw.println("<tr class=\"default\">");
            pw.print("  <td> &#160; </td>");
            pw.print(" <td> &#160; </td>");
            pw.println("</tr>");
        }
    }

    private String getInterfaceAttributeLink(String attrName) {
        if (javaActionInterfaceKeys.contains(attrName)) {
            return "<a href=\"" + this.getPathPrefix(-1, false) + "j2se/javax/swing/Action.html#" + attrName + "\"> " + attrName + " </a>";
        }
        return "<a href=\"" + this.getPathPrefix(-1, false) + "com/sas/swing/util/Action.html#" + attrName + "\"> " + attrName + " </a>";
    }

    private void writeClassAttributesRows(PrintWriter pw, BaseAction action) {
        int rowCount = 1;
        List classAttributes = this.getClassAttributesList(action);
        for (String key : classAttributes) {
            boolean isDynamic;
            Object value = action.getValue(key);
            if (value == null) continue;
            if (rowCount % 2 == 0) {
                pw.println("<tr class=\"defaultWithColor\">");
            } else {
                pw.println("<tr class=\"default\">");
            }
            ++rowCount;
            pw.print("  <td> " + this.getClassAttributeLink(key) + TD_TAG_END);
            pw.print(" <td> " + this.getDefaultValue(key, value) + TD_TAG_END);
            AttributeDescriptorInterface adi = action.getAttributeDescriptor(key);
            boolean bl = isDynamic = (Boolean)adi.getSupplementalProperty("DYNAMIC") == Boolean.TRUE;
            if (this.swing) {
                if (isDynamic) {
                    pw.print(" <td> true </td>");
                } else {
                    pw.print(" <td> false </td>");
                }
            } else {
                boolean isCommand = (Boolean)adi.getSupplementalProperty("COMMAND") == Boolean.TRUE;
                boolean isExternal = (Boolean)adi.getSupplementalProperty("EXTERNAL") == Boolean.TRUE;
                pw.print(" <td> " + isDynamic + "</td>");
                pw.print(" <td> " + isCommand + "</td>");
                pw.print(" <td> " + adi.isVisible() + "</td>");
            }
            pw.println("</tr>");
        }
    }

    private String getClassAttributeLink(String attrName) {
        String setter = null;
        String className = null;
        if (attrName.equals("actionType")) {
            setter = "setActionType(java.lang.String)";
            className = "BaseAction";
        } else if (attrName.equals("active")) {
            setter = "setActive(boolean)";
            className = "BaseAction";
        } else if (attrName.equals("external")) {
            setter = "setExternal(boolean)";
            className = "HttpAction";
        } else if (attrName.equals("link")) {
            setter = "setLink(boolean)";
            className = "HttpAction";
        } else if (attrName.equals("returnStatus")) {
            setter = "setReturnStatus(int)";
            className = "BaseAction";
        } else if (attrName.equals("command")) {
            setter = "setCommand(com.sas.commands.DynamicAttributeCommandInterface)";
            className = "BaseAction";
        } else if (attrName.equals("URLBase")) {
            setter = "setURLBase(java.lang.String)";
            className = "HttpAction";
        } else if (attrName.equals("URLTemplate")) {
            setter = "setURLTemplate(com.sas.util.SimpleTemplate)";
            className = "HttpAction";
        } else if (attrName.equals("defaultURLSuppressed")) {
            setter = "setDefaultURLSuppressed(boolean)";
            className = "SelectorAction";
        } else if (attrName.equals("selectorHeight")) {
            setter = "setSelectorHeight(int)";
            className = "SelectorAction";
        } else if (attrName.equals("selectorWidth")) {
            setter = "setSelectorWidth(int)";
            className = "SelectorAction";
        } else if (attrName.equals("selectorKey")) {
            setter = "setSelectorKey(java.lang.String)";
            className = "SelectorAction";
        } else if (attrName.equals("selectorType")) {
            setter = "setSelectorType(int)";
            className = "SelectorAction";
        }
        if (setter != null) {
            return "<a href=\"" + this.getPathPrefix(0, true) + className + ".html#" + setter + "\"> " + attrName + " </a>";
        }
        return "_TODO_: " + attrName;
    }

    private void writeInstanceAttributesRows(PrintWriter pw, BaseAction action) {
        int rowCount = 1;
        List instanceAttributes = this.getInstanceAttributesList(action);
        for (String key : instanceAttributes) {
            boolean isDynamic;
            if (rowCount % 2 == 0) {
                pw.println("<tr class=\"defaultWithColor\">");
            } else {
                pw.println("<tr class=\"default\">");
            }
            ++rowCount;
            pw.print("  <td> " + key + TD_TAG_END);
            pw.print(" <td> " + this.getObjectType(action, key) + TD_TAG_END);
            AttributeDescriptorInterface adi = action.getAttributeDescriptor(key);
            boolean bl = isDynamic = (Boolean)adi.getSupplementalProperty("DYNAMIC") == Boolean.TRUE;
            if (this.swing) {
                if (isDynamic) {
                    pw.print(" <td> Yes </td>");
                } else {
                    pw.print(" <td> No </td>");
                }
            } else {
                boolean isCommand = (Boolean)adi.getSupplementalProperty("COMMAND") == Boolean.TRUE;
                boolean isExternal = (Boolean)adi.getSupplementalProperty("EXTERNAL") == Boolean.TRUE;
                pw.print(" <td> " + isDynamic + "</td>");
                pw.print(" <td> " + isCommand + "</td>");
                pw.print(" <td> " + adi.isVisible() + "</td>");
            }
            pw.println("</tr>");
        }
        if (rowCount == 1) {
            pw.println("<tr class=\"default\">");
            pw.print("  <td> &#160; </td>");
            pw.print(" <td> &#160; </td>");
            pw.print(" <td> &#160; </td>");
            if (!this.swing) {
                pw.print(" <td> &#160; </td>");
                pw.print(" <td> &#160; </td>");
            }
            pw.println("</tr>");
        }
    }

    public void writeAreaScopeAttributeFiles(String areaType, String path) {
        this.updateDistanceVariables(path);
        this.writeFrameSetFile(areaType, this.getFQFileName(path, this.getFileName(areaType, "AreaScopeAttributes-Frame")), "AreaScopeAttributes");
        PrintWriter pw = this.getPrintWriterFromFileName(this.getFQFileName(path, this.getFileName(areaType, "AreaScopeAttributes")));
        if (pw == null) {
            return;
        }
        this.writeFrameTop(pw, areaType, "AreaScopeAttributes");
        pw.println("<p><span class=\"areaScopeText\">The table below details the dynamic values that are available to all Actions registered in the " + areaType + ".");
        pw.println("<UL>");
        pw.println("<LI>Action attribute names that match these value names will be set with the dynamic values during the Action acquisition phase.</LI>");
        pw.println("<LI>Action attributes also be given values that exploit the APF's substitution of String type values.  For example, ");
        pw.println("<p><code class=\"defaultCode\">action.putValue(\"attrName\", \"This is text using %nameOfSomeDynamicValue\");</code></p></LI>");
        pw.println("</UL>");
        pw.println("</span></p>");
        pw.println("");
        pw.println("<p><table border=\"1\" cellpadding=\"3\" cellspacing=\"0\">");
        pw.println("  <tr>");
        pw.println("    <th class=\"defaultWithColor\"> <b>Name</b> </th> <th class=\"defaultWithColor\"> <b>Type</b> </th> <th class=\"defaultWithColor\"> <b>Value</b> </th>");
        pw.println("  </tr>");
        pw.println("  <tr class=\"default\">");
        pw.println("    <td> model </td> <td> <a href=\"" + this.getPathPrefix(-1, false) + "com/sas/storage/olap/OLAPDataSetInterface.html\"> OLAPDataSetInterface </a> </td> <td> <em>filter attribute</em> </td>");
        pw.println("  </tr>");
        pw.println("  <tr class=\"defaultWithColor\">");
        pw.println("    <td> <a href=\"" + this.getPathPrefix(1, true) + "BaseActionProviderSupport.html#AREA_VALUE_ATTRKEY\">AREA_VALUE_ATTRKEY</a> </td> <td> <a href=\"" + this.getPathPrefix(-1, false) + "j2se/java/lang/String.html\"> String </a> </td> <td> Value </td>");
        pw.println("  </tr>");
        pw.println("  <tr class=\"default\">");
        pw.println("    <td> tupleElementIndex </td> <td> <a href=\"" + this.getPathPrefix(-1, false) + "j2se/java/lang/String.html\"> String </a> </td> <td> <a href=\"" + this.getPathPrefix(-1, false) + "com/sas/storage/olap/TupleElementInterface.html#getTupleElementIndex()\">getTupleElementIndex()</a> </td>");
        pw.println("  </tr>");
        pw.println("</table></p>");
        pw.println("</body>");
        pw.println("</html>");
        pw.flush();
        pw.close();
    }

    public void writeActionOrderListFiles(String areaType, String path) {
        this.updateDistanceVariables(path);
        this.writeFrameSetFile(areaType, this.getFQFileName(path, this.getFileName(areaType, "ActionOrderList-Frame")), "ActionOrderList");
        ActionOrderList aol = this.getActionProvider().getActionOrderList(this.supportKey, null, areaType);
        if (aol != null) {
            PrintWriter pw = this.getPrintWriterFromFileName(this.getFQFileName(path, this.getFileName(areaType, "ActionOrderList")));
            if (pw == null) {
                return;
            }
            this.writeFrameTop(pw, areaType, "ActionOrderList");
            pw.println("<p>");
            pw.println("<span class=\"aolText\">The order of Actions within areaTypes is controlled via ActionOrderLists.");
            pw.println("The table below details the structure of the default ActionOrderList for the TITLE_AREA.");
            pw.println("<UL>");
            pw.println("<LI> Items in the Root Level column are items that exist on the top level of the default ActionOrderList for this area. </LI>");
            pw.println("<LI> Items in subsequent columns belong to nested ActionOrderLists.</LI>");
            pw.println("<LI> Bracketed numbers represent the position of the item within its list. </LI>");
            pw.println("</UL>");
            pw.println("</span>");
            pw.println("</p>");
            pw.println(LINE_BREAK_TAG);
            this.writeAOLTable(pw, areaType, aol);
            pw.println("<br><br>");
            pw.println("<p>");
            pw.println("<span class=\"aolText\"> *** See the ActionProvider's <a href=\"" + this.getPathPrefix(0, true) + "BaseActionProvider.html#getActionOrderList(java.lang.String, com.sas.actionprovider.ActionProviderViewInterface, java.lang.String)\">getActionOrderList()</a> and <a href=\"" + this.getPathPrefix(0, true) + "BaseActionProvider.html#setActionOrderList(java.lang.String, com.sas.actionprovider.ActionOrderList, com.sas.actionprovider.ActionProviderViewInterface, java.lang.String)\">setActionOrderList()</a> methods to access this list or set a new list.");
            pw.println("</span>");
            pw.println("</p>");
            pw.println("</body>");
            pw.println("</html>");
            pw.println("");
            pw.flush();
            pw.close();
        }
    }

    private void writeAOLTable(PrintWriter pw, String areaType, ActionOrderList aol) {
        pw.println("<table cellpadding=\"4\" cellspacing=\"0\" border=\"0\">");
        int maxDepth = this.getMaxAOLDepth(aol);
        pw.println("  <tr>");
        pw.print("    <th class=\"aolColumnHeader\"> Root Level Items </th>");
        for (int i = 1; i < maxDepth; ++i) {
            pw.print("  <th class=\"aolColumnHeader\"> Level " + (i + 1) + " Items </th>");
        }
        pw.println("");
        this.writeAOLRows(pw, areaType, aol, 0, maxDepth);
        pw.println(TABLE_TAG_END);
    }

    private int getMaxAOLDepth(ActionOrderList aol) {
        int currentMax = 1;
        int size = aol.size();
        for (int i = 0; i < size; ++i) {
            int max;
            Object element = aol.get(i);
            if (!(element instanceof ActionOrderList) || (max = this.getMaxAOLDepth((ActionOrderList)element)) + 1 <= currentMax) continue;
            currentMax = max + 1;
        }
        return currentMax;
    }

    private void writeAOLRows(PrintWriter pw, String areaType, ActionOrderList aol, int level, int maxDepth) {
        String prefix = this.getFilePrefix();
        int size = aol.size();
        for (int i = 0; i < size; ++i) {
            pw.println("<tr>");
            this.writeBlankCells(pw, level);
            Object element = aol.get(i);
            if (element == ActionList.SEPARATOR) {
                pw.print("<td class=\"aolSeparatorCell\"> <a href=\"" + this.getPathPrefix(-1, false) + "com/sas/swing/util/ActionList.html#SEPARATOR\"><b>SEPARATOR</b></a> [" + i + "] </td>");
                this.writeBlankCells(pw, maxDepth - level - 1);
                pw.println("</tr>");
                continue;
            }
            if (element instanceof String) {
                pw.print("<td class=\"aolKeyCell\"> <a href=\"" + (prefix != null ? prefix + "_" : "") + areaType.replaceAll("_", "") + "_" + ((String)element).replaceAll("_", "") + this.getTypeSuffix() + ".html\"> " + element + HTML_SPACE + "</a>" + HTML_SPACE + "[" + i + "] </td>");
                this.writeBlankCells(pw, maxDepth - level - 1);
                pw.println("</tr>");
                continue;
            }
            if (!(element instanceof ActionOrderList)) continue;
            ActionOrderList list = (ActionOrderList)element;
            String label = list.getActionType();
            if (label == null) {
                label = list.getName();
            }
            if (list.getActionType() != null) {
                pw.print("<td class=\"aolListCell\"> <a href=\"" + (prefix != null ? prefix + "_" : "") + areaType.replaceAll("_", "") + "_" + list.getActionType().replaceAll("_", "") + this.getTypeSuffix() + ".html\"> " + label + HTML_SPACE + "</a>" + HTML_SPACE + "[" + i + "] </td>");
            } else {
                pw.print("<td class=\"aolListNameCell\"> " + label + HTML_SPACE + HTML_SPACE + "[" + i + "] </td>");
            }
            pw.print("<td class=\"aolListDescriptionCell\"> " + label + " List Items </td>");
            this.writeBlankCells(pw, maxDepth - level - 2);
            pw.println("");
            pw.println("</tr>");
            this.writeAOLRows(pw, areaType, list, level + 1, maxDepth);
        }
    }

    private void writeBlankCells(PrintWriter pw, int num) {
        for (int j = 0; j < num; ++j) {
            pw.print("<td class=\"aolEmptyCell\"> &#160; </td>");
        }
    }

    private String getDefaultValue(String attributeName, Object attributeValue) {
        if (attributeValue == null) {
            return "_TODO_";
        }
        if (attributeName.equals("returnStatus")) {
            return this.getReturnStatusLink(attributeValue);
        }
        if (attributeName.equals("command")) {
            String fqClassName = attributeValue.getClass().getName();
            return " <a href=\"" + this.getPathPrefix(-1, false) + fqClassName.replaceAll("\\W", "/") + ".html\">" + fqClassName.substring(fqClassName.lastIndexOf(".") + 1) + "</a>";
        }
        if (attributeName.equals("selectorKey")) {
            return this.getSelectorKeyLink(attributeValue);
        }
        if (attributeName.equals("selectorType")) {
            return this.getSelectorTypeLink(attributeValue);
        }
        if (attributeName.equals("MnemonicKey")) {
            return this.getMnemonicKeyLink(attributeValue);
        }
        if (attributeName.equals("URLTemplate")) {
            return this.getURLTemplateValue(attributeValue);
        }
        if (attributeValue instanceof String) {
            attributeValue = ((String)attributeValue).replaceAll("areaValue", " <a href=\"" + this.getPathPrefix(1, true) + "BaseActionProviderSupport.html#AREA_VALUE_ATTRKEY\"> AREA_VALUE_ATTRKEY </a>");
            attributeValue = ((String)attributeValue).replaceAll("SwingConstants.RIGHT", " <a href=\"" + this.getPathPrefix(-3, true) + "j2se/javax/swing/SwingConstants.html#RIGHT\"> SwingConstants.RIGHT </a>");
            attributeValue = ((String)attributeValue).replaceAll("SwingConstants.LEFT", " <a href=\"" + this.getPathPrefix(-3, true) + "j2se/javax/swing/SwingConstants.html#LEFT\"> SwingConstants.LEFT </a>");
            if (((String)(attributeValue = ((String)attributeValue).replaceAll("SwingConstants.CENTER", " <a href=\"" + this.getPathPrefix(-3, true) + "j2se/javax/swing/SwingConstants.html#CENTER\"> SwingConstants.CENTER </a>"))).indexOf("<a href") != -1) {
                return (String)attributeValue;
            }
            return HTML_QUOTE + (String)attributeValue + HTML_QUOTE;
        }
        if (attributeValue instanceof Boolean || attributeValue instanceof Integer || attributeValue instanceof Double || attributeValue instanceof Float || attributeValue instanceof Long || attributeValue instanceof Character || attributeValue instanceof Byte || attributeValue instanceof Short) {
            return attributeValue.toString();
        }
        return "_TODO_";
    }

    private String getGenericLink(Object attributeValue) {
        if (attributeValue == null) {
            return "_TODO_";
        }
        String fqClassName = attributeValue.getClass().getName();
        if (!fqClassName.startsWith("com")) {
            fqClassName = "j2se\\" + fqClassName;
        }
        return " <a href=\"" + this.getPathPrefix(-1, false) + fqClassName.replaceAll("\\W", "/") + ".html\">" + fqClassName.substring(fqClassName.lastIndexOf(".") + 1) + "</a>";
    }

    private String getURLTemplateValue(Object attributeValue) {
        if (attributeValue == null) {
            return "_TODO_";
        }
        String template = ((SimpleTemplate)attributeValue).getTemplate();
        if (template == null) {
            return "_TODO_";
        }
        return QUOTE + template + QUOTE;
    }

    private String getMnemonicKeyLink(Object attributeValue) {
        if (attributeValue instanceof Integer) {
            String key = Util.getStringMapping((int)((Integer)attributeValue));
            return "<a href=\"" + this.getPathPrefix(-1, false) + "j2se/java/awt/event/KeyEvent.html#" + key + "\"> " + key + " </a>";
        }
        return "<a href=\"" + this.getPathPrefix(-1, false) + "j2se/java/awt/event/KeyEvent.html#\"> _TODO_ </a>";
    }

    private String getSelectorKeyLink(Object attributeValue) {
        return "<a href=\"" + this.getPathPrefix(-1, false) + "com/sas/dataselectors/SelectorKeysInterface.html#" + attributeValue + "\"> " + attributeValue + " </a>";
    }

    private String getSelectorTypeLink(Object attributeValue) {
        if (attributeValue instanceof Integer) {
            int value = (Integer)attributeValue;
            if (value == 3) {
                return "<a href=\"" + this.getPathPrefix(0, true) + "SelectorAction.html#SELECTOR_EXPAND\"> SELECTOR_EXPAND </a>";
            }
            if (value == 4) {
                return "<a href=\"" + this.getPathPrefix(0, true) + "SelectorAction.html#SELECTOR_EXTERNAL\"> SELECTOR_EXTERNAL </a>";
            }
        }
        return "<a href=\"" + this.getPathPrefix(0, true) + "SelectorAction.html\"> _TODO_ </a>";
    }

    private String getReturnStatusLink(Object attributeValue) {
        String returnStatusKey = (String)returnStatusValues.get(attributeValue);
        if (returnStatusKey != null) {
            return " <a href=\"" + this.getPathPrefix(0, true) + "BaseAction.html#" + returnStatusKey + "\"> " + returnStatusKey + " </a>";
        }
        int intValue = (Integer)attributeValue;
        int size = returnStatusValuesArray.length;
        Vector keyList = new Vector();
        for (int i = 0; i < size; ++i) {
            if ((intValue & returnStatusValuesArray[i]) == 0) continue;
            keyList.add(returnStatusValues.get(new Integer(returnStatusValuesArray[i])));
        }
        int numKeys = keyList.size();
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < numKeys; ++i) {
            String key = (String)keyList.get(i);
            sb.append(" <a href=\"").append(this.getPathPrefix(0, true)).append("BaseAction.html#").append(key).append("\"> ").append(key).append(" </a>");
            if (i == numKeys - 1) continue;
            sb.append(" | ");
        }
        if (sb.length() > 0) {
            return sb.toString();
        }
        return "_TODO_";
    }

    private String getObjectType(BaseAction action, String attributeName) {
        AttributeDescriptorInterface adi = action.getAttributeDescriptor(attributeName);
        if (adi != null) {
            String type = null;
            if (type == null && (type = adi.getType().getObjectType()) == null) {
                type = adi.getType().getType();
            }
            if (type == null) {
                return "_TODO_";
            }
            if (primitiveTypes.contains(type)) {
                return type;
            }
            if (!type.startsWith("com")) {
                type = "j2se\\" + type;
            }
            return " <a href=\"" + this.getPathPrefix(-1, false) + type.replaceAll("\\W", "/") + ".html\">" + type.substring(type.lastIndexOf(".") + 1) + "</a>";
        }
        return "_TODO_";
    }

    private PrintWriter getPrintWriterFromFileName(String fileName) {
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(fileName);
        }
        catch (FileNotFoundException fnfe) {
            System.out.println("ActionDocumenter: writeActionTables(): Caught FileNotFoundException for " + fileName);
            return null;
        }
        PrintWriter pw = new PrintWriter(fileOutputStream);
        if (pw == null) {
            System.out.println("ActionDocumenter: writeActionTables(): PrintWriter could not be created");
            return null;
        }
        return pw;
    }

    private List getOrderedActionTypes(ActionOrderList aol) {
        Vector<Object> list = new Vector<Object>();
        if (aol == null) {
            return list;
        }
        Vector<Object> subLists = new Vector<Object>();
        int size = aol.size();
        for (int i = 0; i < size; ++i) {
            Object element = aol.get(i);
            if (element == com.sas.swing.util.ActionList.SEPARATOR) continue;
            if (element instanceof String && !list.contains(element)) {
                list.add(element);
            }
            if (!(element instanceof ActionOrderList)) continue;
            subLists.add(element);
            String aolActionType = ((ActionOrderList)element).getActionType();
            if (aolActionType == null || list.contains(aolActionType)) continue;
            list.add(aolActionType);
        }
        int subListsSize = subLists.size();
        for (int i = 0; i < subListsSize; ++i) {
            List subList = this.getOrderedActionTypes((ActionOrderList)subLists.get(i));
            int length = subList.size();
            for (int j = 0; j < length; ++j) {
                Object element = subList.get(j);
                if (list.contains(element)) continue;
                list.add(element);
            }
        }
        return list;
    }

    private BaseActionProvider getActionProvider() {
        Object ap = null;
        ap = this.swing ? new SwingActionProvider() : new HttpActionProvider();
        return ap;
    }

    private List getClassAttributesList(BaseAction action) {
        Vector<String> list = new Vector<String>();
        Class<?> actionClass = action.getClass();
        BeanInfo beanInfo = null;
        try {
            beanInfo = Introspector.getBeanInfo(actionClass);
        }
        catch (IntrospectionException introspectionException) {
            // empty catch block
        }
        PropertyDescriptor[] pd = null;
        if (beanInfo != null) {
            pd = beanInfo.getPropertyDescriptors();
        }
        if (pd != null) {
            int length = Array.getLength(pd);
            for (int i = 0; i < length; ++i) {
                String name = pd[i].getName();
                if (name == null || nonDocumentedAttributes.contains(name)) continue;
                list.add(pd[i].getName());
            }
        }
        return list;
    }

    private List getInstanceAttributesList(BaseAction action) {
        Vector<String> list = new Vector<String>();
        AttributeDescriptorInterface[] descriptors = action.getAttributeDescriptors();
        if (descriptors != null) {
            List classAttributesList = this.getClassAttributesList(action);
            int length = Array.getLength(descriptors);
            for (int i = 0; i < length; ++i) {
                String name = descriptors[i].getName();
                if (name == null || classAttributesList.contains(name) || nonDocumentedAttributes.contains(name) || interfaceKeysMap.containsKey(name)) continue;
                list.add(name);
            }
        }
        return list;
    }

    private int getLevelsFromActionProviderPackage(String path) {
        int count = 0;
        int actionProviderPosition = path.indexOf("actionprovider");
        String current = path.substring(actionProviderPosition);
        boolean done = false;
        while (!done) {
            int index = current.indexOf("\\");
            if (index != -1) {
                ++count;
                current = current.substring(index + 1, current.length());
            } else {
                done = true;
            }
            if (count != 8) continue;
            done = true;
        }
        return count - 1;
    }

    private int getLevelsFromRootPackage(String path) {
        int count = 0;
        int actionProviderPosition = path.indexOf("com");
        String current = path.substring(actionProviderPosition);
        boolean done = false;
        while (!done) {
            int index = current.indexOf("\\");
            if (index != -1) {
                ++count;
                current = current.substring(index + 1, current.length());
            } else {
                done = true;
            }
            if (count != 8) continue;
            done = true;
        }
        return count - 1;
    }

    private String getPathPrefix(int distanceBelowPackage, boolean apPackage) {
        int number = 0;
        number = apPackage ? this.apPackageDistance - distanceBelowPackage : this.rootPackageDistance - distanceBelowPackage;
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < number; ++i) {
            sb.append("../");
        }
        return sb.toString();
    }

    private String getJPGName(String areaType, String actionType) {
        String prefix = this.getFilePrefix();
        String jpgName = areaType.replaceAll("_", "");
        if (actionType != null) {
            jpgName = jpgName + "_" + actionType.replaceAll("_", "");
        }
        return (prefix != null ? prefix + "_" : "") + jpgName + this.getTypeSuffix() + ".jpg";
    }

    private void updateDistanceVariables(String path) {
        this.apPackageDistance = this.getLevelsFromActionProviderPackage(path);
        this.rootPackageDistance = this.getLevelsFromRootPackage(path);
    }

    private String getFileName(String areaType, String suffix) {
        String prefix = this.getFilePrefix();
        if (suffix.startsWith("-Frame")) {
            return (prefix != null ? prefix + "_" : "") + areaType.replaceAll("_", "") + suffix + this.getTypeSuffix() + ".html";
        }
        return (prefix != null ? prefix + "_" : "") + areaType.replaceAll("_", "") + "_" + suffix + this.getTypeSuffix() + ".html";
    }

    private String getFQFileName(String path, String fileName) {
        String fqFileName = null;
        fqFileName = path == null || path == "" ? fileName : path + fileName;
        return fqFileName;
    }

    private void writeFrameTop(PrintWriter pw, String areaType, String type) {
        pw.println("<html><head><title>" + areaType + " " + type + "</title>");
        pw.println("<LINK REL=Stylesheet href=\"" + this.getPathPrefix(0, true) + "doc-files/actionProviderDoc.css\">");
        pw.println("</head>");
        pw.println("");
        pw.println("<body class=\"panel\">");
        pw.println("");
        pw.println("<p class=\"headlineText\"><b> " + this.supportClassName + ": " + areaType + " </b>");
        pw.println(LINE_BREAK_TAG);
        pw.println(LINE_BREAK_TAG);
    }

    private String getTypeSuffix() {
        return this.swing ? "_s" : "_j";
    }

    private void writeFrameSetFile(String areaType, String fqFileName, String frameTypeName) {
        PrintWriter pw = this.getPrintWriterFromFileName(fqFileName);
        if (pw == null) {
            return;
        }
        String prefix = this.getFilePrefix();
        pw.println("<html><head><title>" + areaType + " " + frameTypeName + "</title></head>");
        pw.println("");
        pw.println("<frameset FRAMEBORDER=\"0\" FRAMESPACING=\"0\" ROWS=\"9%,*\">");
        pw.println("  <frame name=\"banner\" src=\"" + this.getPathPrefix(0, true) + "doc-files/bipActionProviderBanner.html\" noresize scrolling=\"no\">");
        pw.println("  <frameset FRAMESPACING=\"1\" cols=\"25%,*\">");
        pw.println("    <frame name=\"toc\" src=\"" + (prefix != null ? prefix + "_" : "") + areaType.replaceAll("_", "") + "_TOC" + this.getTypeSuffix() + ".html\" scrolling=\"auto\">");
        pw.println("    <frame name=\"action\" src=\"" + (prefix != null ? prefix + "_" : "") + areaType.replaceAll("_", "") + "_" + frameTypeName + this.getTypeSuffix() + ".html\" scrolling=\"auto\">");
        pw.println("  </frameset>");
        pw.println("<noframes>");
        pw.println("<body>");
        pw.println("<p>This page uses frames, but your browser doesn't support them.</p>");
        pw.println("</body>");
        pw.println("</noframes>");
        pw.println("");
        pw.println("</frameset>");
        pw.println("");
        pw.println("</html>");
        pw.flush();
        pw.close();
    }

    static {
        nonDocumentedAttributes = new Vector();
        nonDocumentedAttributes.add("entityKey");
        nonDocumentedAttributes.add("prototype");
        nonDocumentedAttributes.add("customizer");
        nonDocumentedAttributes.add("entityKey");
        nonDocumentedAttributes.add("entityKey");
        nonDocumentedAttributes.add("custom");
        nonDocumentedAttributes.add("actionProvider");
        nonDocumentedAttributes.add("viewer");
        nonDocumentedAttributes.add("enabled");
        nonDocumentedAttributes.add("cmdId");
        nonDocumentedAttributes.add("characterEncoding");
        nonDocumentedAttributes.add("STYLE_MAP");
        interfaceKeysMap = new LinkedHashMap(64, 1.0f);
        interfaceKeysMap.put("Name", "NAME");
        interfaceKeysMap.put("Label", "LABEL");
        interfaceKeysMap.put("SmallIcon", "SMALL_ICON");
        interfaceKeysMap.put("SmallIconName", "SMALL_ICON_NAME");
        interfaceKeysMap.put("ShortDescription", "SHORT_DESCRIPTION");
        interfaceKeysMap.put("SmallDisabledIcon", "SMALL_DISABLED_ICON");
        interfaceKeysMap.put("SmallDisabledIconName", "SMALL_DISABLED_ICON_NAME");
        interfaceKeysMap.put("ShortDisabledDescription", "SHORT_DISABLED_DESCRIPTION");
        interfaceKeysMap.put("RolloverIconName", "ROLLOVER_ICON_NAME");
        interfaceKeysMap.put("AlternateText", "ALTERNATE_TEXT");
        interfaceKeysMap.put("LargeIcon", "LARGE_ICON");
        interfaceKeysMap.put("LargeIconName", "LARGE_ICON_NAME");
        interfaceKeysMap.put("LargeDisabledIcon", "LARGE_DISABLED_ICON");
        interfaceKeysMap.put("LargeDisabledIconName", "LARGE_DISABLED_ICON_NAME");
        interfaceKeysMap.put("StyleMap", "STYLE_MAP");
        interfaceKeysMap.put("URL", "URL");
        interfaceKeysMap.put("Target", "TARGET");
        interfaceKeysMap.put("LongDescription", "LONG_DESCRIPTION");
        interfaceKeysMap.put("LongDisabledDescription", "LONG_DISABLED_DESCRIPTION");
        interfaceKeysMap.put("AcceleratorKey", "ACCELERATOR_KEY");
        interfaceKeysMap.put("ActionCommandKey", "ACTION_COMMAND_KEY");
        interfaceKeysMap.put("Default", "DEFAULT");
        interfaceKeysMap.put("MnemonicKey", "MNEMONIC_KEY");
        interfaceKeysMap.put("Type", "TYPE");
        interfaceKeysMap.put("TextAlignment", "TEXT_ALIGNMENT");
        interfaceKeysMap.put("GroupName", "GROUP_NAME");
        interfaceKeysMap.put("CommandClass", "COMMAND_CLASS");
        interfaceKeysMap.put("MnemonicIndex", "MNEMONIC_INDEX");
        javaActionInterfaceKeys = new Vector();
        javaActionInterfaceKeys.add("SHORT_DESCRIPTION");
        javaActionInterfaceKeys.add("LONG_DESCRIPTION");
        javaActionInterfaceKeys.add("NAME");
        javaActionInterfaceKeys.add("SMALL_ICON");
        javaActionInterfaceKeys.add("MNEMONIC_KEY");
        javaActionInterfaceKeys.add("ACTION_COMMAND_KEY");
        javaActionInterfaceKeys.add("ACCELERATOR_KEY");
        javaActionInterfaceKeys.add("DEFAULT");
        primitiveTypes = Collections.synchronizedSet(new HashSet(64, 1.0f));
        primitiveTypes.add("long");
        primitiveTypes.add("boolean");
        primitiveTypes.add("char");
        primitiveTypes.add("double");
        primitiveTypes.add("float");
        primitiveTypes.add("int");
        primitiveTypes.add("Object");
        primitiveTypes.add("short");
        primitiveTypes.add("byte");
        returnStatusValues = Collections.synchronizedMap(new HashMap(64, 1.0f));
        returnStatusValues.put(new Integer(0), "ENABLED");
        returnStatusValues.put(new Integer(1), "MODEL_TYPE_DISABLED");
        returnStatusValues.put(new Integer(2), "MODEL_STATE_DISABLED");
        returnStatusValues.put(new Integer(4), "MODEL_MEMBER_DISABLED");
        returnStatusValues.put(new Integer(8), "IS_CURRENT_STATE_DISABLED");
        returnStatusValues.put(new Integer(16), "DISABLED");
        returnStatusValues.put(new Integer(32), "VIEWER_DISABLED");
        returnStatusValues.put(new Integer(64), "AREA_DISABLED");
        returnStatusValues.put(new Integer(128), "UNSUPPORTED");
        returnStatusValuesArray = new int[9];
        ActionDocumenter.returnStatusValuesArray[0] = 0;
        ActionDocumenter.returnStatusValuesArray[1] = 1;
        ActionDocumenter.returnStatusValuesArray[2] = 2;
        ActionDocumenter.returnStatusValuesArray[3] = 4;
        ActionDocumenter.returnStatusValuesArray[4] = 8;
        ActionDocumenter.returnStatusValuesArray[5] = 16;
        ActionDocumenter.returnStatusValuesArray[6] = 32;
        ActionDocumenter.returnStatusValuesArray[7] = 64;
        ActionDocumenter.returnStatusValuesArray[8] = 128;
    }
}

