/*
 * Decompiled with CFR 0.152.
 */
package com.sas.tkts.util;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;

public class Reuse {
    private static final String INTERVAL_LENGTH_STR = "Interval length(seconds):";
    private static final String TOTAL_ENTRIES = "\n Total Entries:";
    private static final String SAVED_ENTRIES = "\n Saved Entries:";
    private static final String MEMORY_SAVED = "\n Memory saved(bytes):";
    private static final String EXECUTE_TIME = "\n Execute time(seconds):%7.2f";
    private static final int INITIAL_CAPACITY = 1000;
    private static final long INTERVAL_LENGTH = 900L;
    private transient AtomicLong totalEntries;
    private transient AtomicLong savedEntries;
    private transient AtomicLong memorySaved;
    private transient AtomicLong executeTime;
    private transient ConcurrentHashMap<Integer, ReuseEntry> mapInteger = new ConcurrentHashMap(1000);
    private transient ConcurrentHashMap<String, ReuseEntry> mapString = new ConcurrentHashMap(1000);

    public String logInfoAsString() {
        String out = "Interval length(seconds):900";
        out = out + TOTAL_ENTRIES + this.totalEntries.toString();
        out = out + SAVED_ENTRIES + this.savedEntries.toString();
        out = out + MEMORY_SAVED + this.memorySaved.toString();
        double seconds = this.executeTime.get();
        out = out + String.format(EXECUTE_TIME, seconds /= 1.0E9);
        return out;
    }

    public Reuse() {
        this.totalEntries = new AtomicLong();
        this.savedEntries = new AtomicLong();
        this.memorySaved = new AtomicLong();
        this.executeTime = new AtomicLong();
    }

    public void reset() {
        this.mapInteger.clear();
        this.mapString.clear();
    }

    public String addString(String inVal) {
        String out = inVal;
        long entryTime = System.nanoTime();
        if (inVal == null) {
            return null;
        }
        ReuseEntry entry = this.mapString.get(inVal);
        if (entry == null) {
            entry = new ReuseEntry(inVal);
            if ((entry = this.mapString.putIfAbsent(inVal, entry)) != null) {
                entry.count.incrementAndGet();
                out = (String)entry.value;
            } else {
                this.totalEntries.incrementAndGet();
            }
        } else {
            this.savedEntries.incrementAndGet();
            entry.count.incrementAndGet();
            this.memorySaved.addAndGet(inVal.length());
            out = (String)entry.value;
        }
        long delta = System.nanoTime() - entryTime;
        this.executeTime.addAndGet(delta);
        return out;
    }

    public static void main(String[] argv) {
        String tStr;
        int ti;
        int li;
        long stringBytes = 0L;
        long startTime = System.nanoTime();
        long rawTime = 0L;
        long reuseTime = 0L;
        int numberLoops = 100000;
        String[] data = new String[]{"abcd", "abcdefgh", "abcdefghijklmnop", "abcdefghijklmnoprstuvwxyzABCDEFG", "abcdefghijklmnoprstuvwxyzABCDEFGHIJKLMNOPRSTUVWXYZ01234567890!@#"};
        startTime = System.nanoTime();
        for (li = 0; li < numberLoops; ++li) {
            for (ti = 0; ti < data.length; ++ti) {
                tStr = new String(data[ti]);
                stringBytes += (long)tStr.length();
            }
        }
        rawTime = System.nanoTime() - startTime;
        Reuse myReuse = new Reuse();
        startTime = System.nanoTime();
        for (li = 0; li < numberLoops; ++li) {
            for (ti = 0; ti < data.length; ++ti) {
                tStr = myReuse.addString(data[ti]);
            }
        }
        reuseTime = System.nanoTime() - startTime;
        System.out.println("rawTime:" + Long.toString(rawTime));
        System.out.println("reuseTime:" + Long.toString(reuseTime));
        System.out.println("String Bytes:" + stringBytes);
        String info = myReuse.logInfoAsString();
        System.out.println(info);
    }

    public class ReuseEntry {
        public transient Object value;
        public transient AtomicLong count;

        public ReuseEntry(Object value) {
            this.value = value;
            this.count = new AtomicLong(1L);
        }
    }
}

