/*
 * Decompiled with CFR 0.152.
 */
package com.sas.tkts.types;

import com.sas.tkts.logging.AbstractLogger;
import com.sas.tkts.logging.LoggerFactory;
import com.sas.tkts.sql.Constants;
import com.sas.tkts.sql.LocalizedErrorHandler;
import com.sas.tkts.types.AbstractColumn;
import com.sas.tkts.util.DataTypeConversions;
import com.sas.tkts.util.ParameterInfoHelper;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;

public class StringColumn
extends AbstractColumn {
    private static String thisClassName = StringColumn.class.getName();
    private static AbstractLogger logger = LoggerFactory.getLogger(thisClassName);
    private transient String data;

    public StringColumn(String value) {
        this.data = value;
        this.setUpdated(true);
    }

    @Override
    public String getString() throws SQLException {
        return this.data;
    }

    @Override
    public String getString(String charSet) throws SQLException {
        if (this.data != null) {
            try {
                return new String(this.data.getBytes(), charSet);
            }
            catch (UnsupportedEncodingException e) {
                String ei = "Encoding.Unsupported.fmt";
                LocalizedErrorHandler.throwLocalizedException("Encoding.Unsupported.fmt", logger, charSet);
            }
        }
        return this.data;
    }

    public BigDecimal checkForDataTruncation(String inStr, BigDecimal bdMax, BigDecimal bdMin, String targetClass) throws SQLException {
        int dt = 0;
        BigDecimal bdVal = null;
        try {
            bdVal = new BigDecimal(inStr);
            int bdCmp = bdVal.compareTo(bdMax);
            if (bdCmp > 0) {
                dt = 1;
                bdVal = bdMax;
            } else {
                bdCmp = bdVal.compareTo(bdMin);
                if (bdCmp < 0) {
                    dt = -1;
                    bdVal = bdMin;
                }
            }
        }
        catch (NumberFormatException nfe) {
            DataTypeConversions.badTargetValueTypeException("String", targetClass, inStr);
        }
        this.setDataTruncation((byte)dt);
        return bdVal;
    }

    @Override
    public byte getByte() throws SQLException {
        byte rval = 0;
        if (this.data != null) {
            String trimStr = this.data.trim();
            try {
                rval = Byte.parseByte(trimStr);
            }
            catch (NumberFormatException nfe) {
                BigDecimal bd = this.checkForDataTruncation(trimStr, Constants.BD_MAX_VALUE_OF_BYTE, Constants.BD_MIN_VALUE_OF_BYTE, "Byte");
                rval = bd.byteValue();
            }
        }
        return rval;
    }

    @Override
    public short getShort() throws SQLException {
        short rval = 0;
        if (this.data != null) {
            String trimStr = this.data.trim();
            try {
                rval = Short.parseShort(trimStr);
            }
            catch (NumberFormatException nfe) {
                BigDecimal bd = this.checkForDataTruncation(trimStr, Constants.BD_MAX_VALUE_OF_SHORT, Constants.BD_MIN_VALUE_OF_SHORT, "Short");
                rval = bd.shortValue();
            }
        }
        return rval;
    }

    @Override
    public int getInt() throws SQLException {
        int rval = 0;
        if (this.data != null) {
            String trimStr = this.data.trim();
            try {
                rval = Integer.parseInt(trimStr);
            }
            catch (NumberFormatException nfe) {
                BigDecimal bd = this.checkForDataTruncation(trimStr, Constants.BD_MAX_VALUE_OF_INTEGER, Constants.BD_MIN_VALUE_OF_INTEGER, "Integer");
                rval = bd.intValue();
            }
        }
        return rval;
    }

    @Override
    public long getLong() throws SQLException {
        long rval = 0L;
        if (this.data != null) {
            String trimStr = this.data.trim();
            try {
                rval = Long.parseLong(trimStr);
            }
            catch (NumberFormatException nfe) {
                BigDecimal bd = this.checkForDataTruncation(trimStr, Constants.BD_MAX_VALUE_OF_LONG, Constants.BD_MIN_VALUE_OF_LONG, "Long");
                rval = bd.longValue();
            }
        }
        return rval;
    }

    @Override
    public float getFloat() throws SQLException {
        float rval = 0.0f;
        if (this.data != null) {
            String trimStr = this.data.trim();
            try {
                rval = Float.parseFloat(trimStr);
                if (rval == Float.POSITIVE_INFINITY) {
                    this.setDataTruncation((byte)1);
                } else if (rval == Float.NEGATIVE_INFINITY) {
                    this.setDataTruncation((byte)-1);
                } else {
                    this.setDataTruncation((byte)0);
                }
            }
            catch (NumberFormatException nfe) {
                DataTypeConversions.badTargetValueTypeException("String", "Float", trimStr);
            }
        }
        return rval;
    }

    @Override
    public double getDouble() throws SQLException {
        double rval = 0.0;
        if (this.data == null) {
            return rval;
        }
        String trimStr = this.data.trim();
        try {
            rval = Double.parseDouble(trimStr);
            if (rval == Double.POSITIVE_INFINITY) {
                this.setDataTruncation((byte)1);
            } else if (rval == Double.NEGATIVE_INFINITY) {
                this.setDataTruncation((byte)-1);
            } else {
                this.setDataTruncation((byte)0);
            }
        }
        catch (NumberFormatException nfe) {
            DataTypeConversions.badTargetValueTypeException("String", "Double", trimStr);
        }
        return rval;
    }

    @Override
    public BigDecimal getBigDecimal() throws SQLException {
        BigDecimal rval = null;
        if (this.data == null) {
            return rval;
        }
        String trimStr = this.data.trim();
        try {
            rval = new BigDecimal(trimStr);
        }
        catch (NumberFormatException nfe) {
            DataTypeConversions.badTargetValueTypeException("String", "BigDecimal", trimStr);
        }
        return rval;
    }

    @Override
    public boolean getBoolean() throws SQLException {
        boolean out = false;
        if (this.data == null) {
            return out;
        }
        Boolean oBoolean = DataTypeConversions.convertToBoolean(this.data);
        out = oBoolean;
        return out;
    }

    @Override
    public Timestamp getTimestamp() throws SQLException {
        if (this.data == null) {
            return null;
        }
        Timestamp timestamp = null;
        String trimStr = this.data.trim();
        try {
            timestamp = Timestamp.valueOf(trimStr);
            return timestamp;
        }
        catch (Exception exception) {
            DataTypeConversions.badTargetValueTypeException("String", "Timestamp", trimStr);
            return timestamp;
        }
    }

    @Override
    public Time getTime() throws SQLException {
        if (this.data == null) {
            return null;
        }
        Time time = null;
        String trimStr = this.data.trim();
        try {
            time = Time.valueOf(trimStr);
            return time;
        }
        catch (Exception exception) {
            DataTypeConversions.badTargetValueTypeException("String", "Time", trimStr);
            return time;
        }
    }

    @Override
    public Date getDate() throws SQLException {
        if (this.data == null) {
            return null;
        }
        Date date = null;
        String trimStr = this.data.trim();
        try {
            date = Date.valueOf(trimStr);
        }
        catch (Exception ex) {
            DataTypeConversions.badTargetValueTypeException("String", "Date", trimStr);
        }
        return date;
    }

    @Override
    public Object getObject() throws SQLException {
        return this.data;
    }

    @Override
    public boolean isNull() {
        return this.data == null;
    }

    @Override
    public void setNull() {
        this.data = null;
        this.setUpdated(true);
    }

    @Override
    public void setObject(Object value) {
        String newStr = null;
        if (value != null) {
            newStr = (String)ParameterInfoHelper.coerceObject(value, 12, false);
        }
        this.data = newStr;
        this.setUpdated(true);
    }

    @Override
    public void setString(String value) {
        this.data = value;
        this.setUpdated(true);
    }

    @Override
    public String toString() {
        String outStr = this.data == null ? "String: NULL isUpdated:" + this.isUpdated() : "String:'" + this.data + "' isUpdated:" + this.isUpdated();
        return outStr;
    }

    @Override
    public Object getRawData() {
        return this.data;
    }

    @Override
    public final StringColumn clone() {
        StringColumn out = new StringColumn(this.data);
        return out;
    }

    @Override
    public int getSQLType() {
        return 12;
    }

    @Override
    public Class getDataTypeClass() {
        return this.data.getClass();
    }

    @Override
    public void cleanup() {
        this.data = null;
    }
}

