/*
 * Decompiled with CFR 0.152.
 */
package com.sas.tkts.types;

import com.sas.tkts.types.NumberColumn;
import com.sas.tkts.util.ParameterInfoHelper;
import com.sas.tkts.util.UtilityFunctions;
import java.math.BigDecimal;
import java.sql.SQLException;

public class NumberColumnFloat
extends NumberColumn {
    private float data;

    public NumberColumnFloat(float value) {
        float f0 = 0.0f;
        Float f = new Float(f0);
        dataClass = f.getClass();
        this.data = value;
        this.setUpdated(true);
    }

    @Override
    public final NumberColumnFloat clone() {
        NumberColumnFloat out = new NumberColumnFloat(this.data);
        return out;
    }

    @Override
    public BigDecimal getBigDecimal() {
        return new BigDecimal(this.data);
    }

    @Override
    public boolean getBoolean() {
        return this.booleanDouble(this.data);
    }

    @Override
    public byte getByte() {
        return this.rangedDoubleToByte(this.data);
    }

    @Override
    public Class getDataTypeClass() {
        return dataClass;
    }

    @Override
    public double getDouble() throws SQLException {
        return this.data;
    }

    @Override
    public float getFloat() {
        return this.data;
    }

    @Override
    public int getInt() {
        return this.rangedDoubleToInt(this.data);
    }

    @Override
    public long getLong() {
        return this.rangedDoubleToLong(this.data);
    }

    @Override
    public Object getObject() throws SQLException {
        Float outObj = null;
        if (!this.isNull()) {
            outObj = new Float(this.data);
        }
        return outObj;
    }

    @Override
    public Object getRawData() throws SQLException {
        return this.getObject();
    }

    @Override
    public short getShort() {
        return this.rangedDoubleToShort(this.data);
    }

    @Override
    public int getSQLType() {
        return 6;
    }

    @Override
    public String getString() {
        if (this.isNull()) {
            return null;
        }
        return Float.toString(this.data);
    }

    @Override
    public void setBigDecimal(BigDecimal value) {
        if (value == null) {
            this.data = 0.0f;
            this.setUpdated(false);
        } else {
            this.data = value.floatValue();
            this.setUpdated(true);
        }
    }

    @Override
    public void setByte(byte value) {
        this.data = value;
        this.setUpdated(true);
    }

    @Override
    public void setDouble(double value) {
        this.data = this.rangedDoubleToFloat(value);
    }

    @Override
    public void setFloat(float value) {
        this.data = value;
        this.setUpdated(true);
    }

    @Override
    public void setInt(int value) {
        this.data = value;
        this.setUpdated(true);
    }

    @Override
    public void setLong(long value) {
        this.data = value;
        this.setUpdated(true);
    }

    @Override
    public void setNull() {
        this.data = 0.0f;
        this.setUpdated(false);
    }

    @Override
    public void setObject(Object value) {
        Number inNumber = null;
        if (value == null) {
            this.data = 0.0f;
            this.setUpdated(false);
        } else {
            int sqlType = UtilityFunctions.getObjectSQLType(value);
            inNumber = (Number)ParameterInfoHelper.coerceObject(value, sqlType, false);
            this.data = inNumber.floatValue();
            this.setUpdated(true);
        }
    }

    @Override
    public void setShort(short value) {
        this.data = value;
    }

    @Override
    public String toString() {
        String out = this.isNull() ? "NULL" : Float.toString(this.data);
        return out;
    }
}

