/*
 * Decompiled with CFR 0.152.
 */
package com.sas.tkts.types;

import com.sas.tkts.types.NumberColumn;
import com.sas.tkts.util.ParameterInfoHelper;
import com.sas.tkts.util.UtilityFunctions;
import java.math.BigDecimal;
import java.sql.SQLException;

public class NumberColumnByte
extends NumberColumn {
    private byte data;

    public NumberColumnByte(byte value) {
        byte b0 = 0;
        Byte b = new Byte(b0);
        dataClass = b.getClass();
        this.data = value;
        this.setUpdated(true);
    }

    @Override
    public final NumberColumnByte clone() {
        NumberColumnByte out = new NumberColumnByte(this.data);
        return out;
    }

    @Override
    public BigDecimal getBigDecimal() {
        return this.bigDecimalDouble(this.data);
    }

    @Override
    public boolean getBoolean() {
        return this.booleanLong(this.data);
    }

    @Override
    public byte getByte() {
        return this.data;
    }

    @Override
    public Class getDataTypeClass() {
        return dataClass;
    }

    @Override
    public double getDouble() {
        return this.data;
    }

    @Override
    public float getFloat() {
        return this.data;
    }

    @Override
    public int getInt() {
        return this.data;
    }

    @Override
    public long getLong() {
        return this.data;
    }

    @Override
    public Object getObject() throws SQLException {
        Byte outObj = null;
        if (!this.isNull()) {
            outObj = new Byte(this.data);
        }
        return outObj;
    }

    @Override
    public Object getRawData() throws SQLException {
        return this.getObject();
    }

    @Override
    public short getShort() {
        return this.data;
    }

    @Override
    public int getSQLType() {
        return -6;
    }

    @Override
    public String getString() {
        if (this.isNull()) {
            return null;
        }
        return Byte.toString(this.data);
    }

    @Override
    public void setBigDecimal(BigDecimal value) {
        if (value == null) {
            this.data = 0;
            this.setUpdated(false);
        } else {
            this.data = value.byteValue();
            this.setUpdated(true);
        }
    }

    @Override
    public void setByte(byte value) {
        this.data = value;
        this.setUpdated(true);
    }

    @Override
    public void setDouble(double value) {
        this.data = this.rangedDoubleToByte(value);
    }

    @Override
    public void setFloat(float value) {
        this.data = this.rangedDoubleToByte(value);
    }

    @Override
    public void setInt(int value) {
        this.data = this.rangedLongToByte(value);
    }

    @Override
    public void setLong(long value) {
        this.data = this.rangedLongToByte(value);
    }

    @Override
    public void setNull() {
        this.data = 0;
        this.setUpdated(false);
    }

    @Override
    public void setObject(Object value) {
        Number inNumber = null;
        if (value == null) {
            this.data = 0;
            this.setUpdated(false);
        } else {
            int sqlType = UtilityFunctions.getObjectSQLType(value);
            inNumber = (Number)ParameterInfoHelper.coerceObject(value, sqlType, false);
            this.data = inNumber.byteValue();
            this.setUpdated(true);
        }
    }

    @Override
    public void setShort(short value) {
        this.data = this.rangedLongToByte(value);
    }

    @Override
    public String toString() {
        String out = this.isNull() ? "NULL" : Byte.toString(this.data);
        return out;
    }
}

