/*
 * Decompiled with CFR 0.152.
 */
package com.sas.tkts.types;

import com.sas.tkts.types.AbstractColumn;
import com.sas.tkts.util.ParameterInfoHelper;
import com.sas.tkts.util.UtilityFunctions;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;

public class ByteArrayColumn
extends AbstractColumn {
    private transient byte[] data;

    public ByteArrayColumn(byte[] value) {
        this.data = (byte[])(value != null ? (byte[])value.clone() : null);
    }

    @Override
    public Object getObject() {
        Object outObj = this.data;
        if (outObj != null) {
            outObj = this.data.clone();
        }
        return outObj;
    }

    @Override
    public String getString() {
        if (this.data == null) {
            return null;
        }
        return new String(this.data);
    }

    @Override
    public byte[] getBytes() {
        byte[] out = null;
        if (this.data != null) {
            out = (byte[])this.data.clone();
        }
        return out;
    }

    @Override
    public InputStream getAsciiStream() {
        if (this.data == null) {
            return null;
        }
        return new ByteArrayInputStream(this.data);
    }

    @Override
    public InputStream getBinaryStream() {
        if (this.data == null) {
            return null;
        }
        return new ByteArrayInputStream(this.data);
    }

    @Override
    public Reader getCharacterStream() {
        if (this.data == null) {
            return null;
        }
        return new BufferedReader(new InputStreamReader(new ByteArrayInputStream(this.data)));
    }

    @Override
    public void setNull() {
        this.data = null;
        this.setUpdated(true);
    }

    @Override
    public boolean isNull() {
        return this.data == null;
    }

    @Override
    public void setBytes(byte[] value) {
        this.data = (byte[])(value == null ? null : (byte[])value.clone());
        this.setUpdated(true);
    }

    @Override
    public void setObject(Object value) {
        if (value != null) {
            byte[] inBytes = (byte[])ParameterInfoHelper.coerceObject(value, -3, false);
            if (inBytes == value) {
                inBytes = (byte[])inBytes.clone();
            }
            this.data = inBytes;
        } else {
            this.data = null;
        }
        this.setUpdated(true);
    }

    @Override
    public String toString() {
        String FORMAT = "ByteArray isUpdated[%s] TotalBytes[%d] ";
        if (this.data == null) {
            String outStr = String.format("ByteArray isUpdated[%s] TotalBytes[%d] ", this.isUpdated(), -1);
            return outStr;
        }
        int lobBytes = this.data.length;
        int bytesPerRow = UtilityFunctions.getFormatBytesRowSize();
        int bytesToLog = lobBytes < bytesPerRow ? lobBytes : bytesPerRow;
        String outStr = String.format("ByteArray isUpdated[%s] TotalBytes[%d] ", this.isUpdated(), lobBytes);
        outStr = outStr + UtilityFunctions.formatBytesHex(this.data, 0, bytesToLog);
        if (lobBytes > bytesPerRow) {
            outStr = outStr + " ... ";
            bytesToLog = bytesPerRow;
            outStr = outStr + UtilityFunctions.formatBytesHex(this.data, lobBytes -= bytesPerRow, bytesPerRow);
        }
        return outStr;
    }

    @Override
    public Object getRawData() {
        return this.data;
    }

    @Override
    public final ByteArrayColumn clone() {
        ByteArrayColumn out = new ByteArrayColumn(this.data);
        return out;
    }

    @Override
    public int getSQLType() {
        return 2003;
    }

    @Override
    public Class getDataTypeClass() {
        return this.data.getClass();
    }

    @Override
    public void cleanup() {
        this.data = null;
    }
}

