/*
 * Decompiled with CFR 0.152.
 */
package com.sas.tkts.types;

import com.sas.tkts.logging.AbstractLogger;
import com.sas.tkts.logging.CommonLogger;
import com.sas.tkts.logging.LoggerFactory;
import com.sas.tkts.sql.LocalizedErrorHandler;
import com.sas.tkts.types.BlobOutputStream;
import com.sas.tkts.util.UtilityFunctions;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.sql.Blob;
import java.sql.SQLException;
import java.util.Arrays;

public class BlobFedSrv
implements Blob {
    private static final int DEFAULT_CAPACITY = 102400;
    private static String thisClassName = BlobFedSrv.class.getName();
    private static AbstractLogger logger = LoggerFactory.getLogger(thisClassName);
    private transient ByteBuffer bb;
    private transient LobStates lobState;

    private void setup(int inCapacity, byte[] inData) {
        String method = "BlobFedSrv";
        if (AbstractLogger.isTrace) {
            if (inData == null) {
                logger.entry("BlobFedSrv", "defCap:" + inCapacity + "inData is NULL");
            } else {
                logger.entry("BlobFedSrv", "defCap:" + inCapacity + "inDataBytes[" + inData.length + "] ");
            }
        }
        this.bb = ByteBuffer.allocate(inCapacity);
        if (inData != null) {
            this.bb.put(inData);
        }
        this.bb.limit(inCapacity);
        this.lobState = LobStates.IN;
    }

    public BlobFedSrv(int inCapacity, byte[] inData) throws SQLException {
        this.setup(inCapacity, inData);
    }

    public BlobFedSrv(byte[] inData) throws SQLException {
        int inLen;
        int defCap = 102400;
        if (inData != null && defCap < (inLen = inData.length)) {
            defCap = inLen;
        }
        this.setup(defCap, inData);
    }

    private void checkState() throws SQLException {
        if (this.lobState == LobStates.FREED) {
            this.freedSQLException();
        }
    }

    private SQLException freedSQLException() throws SQLException {
        String ei = "TKTSBlob.freed.txt";
        String es = LocalizedErrorHandler.getLocalizedError("TKTSBlob.freed.txt", null);
        SQLException outSE = new SQLException(es);
        throw outSE;
    }

    public static SQLException invalidLengthSQLException(long len) {
        String ei = "TKTSBlob.invalidLength.fmt";
        Object[] args = new String[]{Long.toString(len)};
        String es = LocalizedErrorHandler.getLocalizedError("TKTSBlob.invalidLength.fmt", args);
        SQLException outSE = new SQLException(es);
        return outSE;
    }

    private SQLException invalidLenSQLException(int len) {
        String ei = "TKTSBlob.invalidLen.fmt";
        Object[] args = new String[]{Integer.toString(len)};
        String es = LocalizedErrorHandler.getLocalizedError("TKTSBlob.invalidLen.fmt", args);
        SQLException outSE = new SQLException(es);
        return outSE;
    }

    private SQLException invalidOffsetSQLException(int offset, int patternLen) {
        String ei = "TKTSBlob.invalidOffset.fmt";
        Object[] args = new String[]{Integer.toString(offset), Integer.toString(patternLen)};
        String es = LocalizedErrorHandler.getLocalizedError("TKTSBlob.invalidOffset.fmt", args);
        SQLException outSE = new SQLException(es);
        return outSE;
    }

    private SQLException invalidPatternSQLException() {
        String ei = "TKTSBlob.nullPatternParameter.txt";
        String es = LocalizedErrorHandler.getLocalizedError("TKTSBlob.nullPatternParameter.txt", null);
        SQLException outSE = new SQLException(es);
        return outSE;
    }

    private SQLException invalidPositionSQLException(long pos) {
        String ei = "TKTSBlob.invalidPosition.fmt";
        Object[] args = new String[]{Long.toString(pos), Long.toString(this.bb.position())};
        String es = LocalizedErrorHandler.getLocalizedError("TKTSBlob.invalidPosition.fmt", args);
        SQLException outSE = new SQLException(es);
        return outSE;
    }

    private SQLException invalidStartSQLException(long pos) {
        String ei = "TKTSBlob.invalidStart.fmt";
        Object[] args = new String[]{Long.toString(pos)};
        String es = LocalizedErrorHandler.getLocalizedError("TKTSBlob.invalidStart.fmt", args);
        SQLException outSE = new SQLException(es);
        return outSE;
    }

    private SQLException binaryStreamSQLException() {
        String ei = "TKTSBlob.getBinaryStreamError.txt";
        String es = LocalizedErrorHandler.getLocalizedError("TKTSBlob.getBinaryStreamError.txt", null);
        SQLException outSE = new SQLException(es);
        return outSE;
    }

    private SQLException binaryStreamParmsSQLException(long pos, long length) {
        String ei = "TKTSBlob.getBinaryStreamParms.fmt";
        Object[] args = new String[]{Long.toString(pos), Long.toString(length), Integer.toString(this.bb.position())};
        String es = LocalizedErrorHandler.getLocalizedError("TKTSBlob.getBinaryStreamParms.fmt", args);
        SQLException outSE = new SQLException(es);
        return outSE;
    }

    @Override
    public long length() throws SQLException {
        this.checkState();
        long outLen = this.bb.position();
        return outLen;
    }

    @Override
    public byte[] getBytes(long pos, int length) throws SQLException {
        byte[] out;
        String method = "getBytes";
        if (AbstractLogger.isTrace) {
            logger.entry("getBytes", "inPos[" + pos + "] inLength[" + length + "] ");
        }
        this.checkState();
        int dataLength = this.bb.position();
        if (pos <= 0L) {
            SQLException outSE = this.invalidPositionSQLException(pos);
            throw outSE;
        }
        if (length < 0) {
            SQLException outSE = BlobFedSrv.invalidLengthSQLException(length);
            throw outSE;
        }
        if (pos > (long)dataLength) {
            out = new byte[]{};
        } else {
            int z_pos = (int)pos - 1;
            byte[] tBytes = this.bb.array();
            int end = z_pos + length;
            if (end > dataLength) {
                end = dataLength;
            }
            out = Arrays.copyOfRange(tBytes, z_pos, end);
        }
        return out;
    }

    @Override
    public InputStream getBinaryStream() throws SQLException {
        ByteArrayInputStream out;
        this.checkState();
        try {
            byte[] tBytes = this.bb.array();
            int bytesInStream = this.bb.position();
            out = new ByteArrayInputStream(tBytes, 0, bytesInStream);
        }
        catch (Exception e) {
            SQLException outSE = this.binaryStreamSQLException();
            throw outSE;
        }
        return out;
    }

    @Override
    public InputStream getBinaryStream(long pos, long len) throws SQLException {
        ByteArrayInputStream out;
        byte[] outBytes;
        this.checkState();
        int dataLength = this.bb.position();
        if (pos <= 0L || len < 0L || len > Integer.MAX_VALUE) {
            SQLException outSE = this.binaryStreamParmsSQLException(pos, len);
            throw outSE;
        }
        if (pos > (long)dataLength) {
            outBytes = new byte[]{};
        } else {
            int z_pos = (int)pos - 1;
            int to = z_pos + (int)len;
            byte[] tBytes = this.bb.array();
            if (to > dataLength) {
                to = dataLength;
            }
            outBytes = Arrays.copyOfRange(tBytes, z_pos, to);
        }
        try {
            out = new ByteArrayInputStream(outBytes);
        }
        catch (Exception e) {
            SQLException outSE = this.binaryStreamSQLException();
            throw outSE;
        }
        return out;
    }

    @Override
    public long position(byte[] pattern, long longStart) throws SQLException {
        this.checkState();
        String method = "position(byte[]..)";
        if (AbstractLogger.isTrace) {
            logger.entry("position(byte[]..)", "pattern start[" + longStart + "] ");
            if (pattern == null) {
                logger.trace("pattern is null");
            } else {
                CommonLogger.logBytes(logger, pattern, 0, pattern.length, false);
            }
        }
        if (pattern == null) {
            SQLException outSE = this.invalidPatternSQLException();
            throw outSE;
        }
        if (longStart <= 0L) {
            SQLException outSE = this.invalidStartSQLException(longStart);
            throw outSE;
        }
        int patternLen = pattern.length;
        int start = (int)longStart;
        long end = longStart + (long)patternLen - 1L;
        int dataLength = this.bb.position();
        if (patternLen == 0 || end > (long)dataLength) {
            return -1L;
        }
        --start;
        long last = dataLength - patternLen;
        byte firstPatternByte = pattern[0];
        byte[] ba = this.bb.array();
        while ((long)start <= last) {
            if (firstPatternByte == ba[start]) {
                int cnt;
                int pi = 0;
                int di = start;
                for (cnt = patternLen; cnt > 0 && pattern[pi] == ba[di]; --cnt) {
                    ++pi;
                    ++di;
                }
                if (cnt == 0) {
                    return start + 1;
                }
            }
            ++start;
        }
        return -1L;
    }

    @Override
    public long position(Blob pattern, long start) throws SQLException {
        this.checkState();
        if (pattern == null) {
            SQLException outSE = this.invalidPatternSQLException();
            throw outSE;
        }
        byte[] b = pattern.getBytes(1L, (int)pattern.length());
        return this.position(b, start);
    }

    @Override
    public int setBytes(long pos, byte[] bytes) throws SQLException {
        this.checkState();
        if (bytes == null) {
            SQLException outSE = this.invalidPatternSQLException();
            throw outSE;
        }
        int setBytes = this.setBytes(pos, bytes, 0, bytes.length);
        return setBytes;
    }

    @Override
    public int setBytes(long pos, byte[] bytes, int offset, int len) throws SQLException {
        int tCapacity;
        this.checkState();
        if (pos <= 0L || pos > Integer.MAX_VALUE) {
            SQLException outSE = this.invalidPositionSQLException(pos);
            throw outSE;
        }
        if (bytes == null) {
            SQLException outSE = this.invalidPatternSQLException();
            throw outSE;
        }
        if (offset < 0 || offset > bytes.length) {
            SQLException outSE = this.invalidOffsetSQLException(offset, bytes.length);
            throw outSE;
        }
        if (len < 0 || len > bytes.length) {
            SQLException outSE = this.invalidLenSQLException(len);
            throw outSE;
        }
        int oldPosition = this.bb.position();
        int last = oldPosition + len;
        if (last > (tCapacity = this.bb.capacity())) {
            while (tCapacity < last) {
                tCapacity *= 2;
            }
            ByteBuffer newBB = ByteBuffer.allocate(tCapacity);
            byte[] oldBytes = this.bb.array();
            newBB.put(oldBytes);
            int oldPostion = this.bb.position();
            newBB.position(oldPostion);
            this.bb = newBB;
        }
        int intPos = (int)pos;
        int newPosition = intPos + len - 1;
        this.bb.position(intPos - 1);
        this.bb.put(bytes, offset, len);
        if (newPosition < oldPosition) {
            this.bb.position(oldPosition);
        }
        return len;
    }

    @Override
    public OutputStream setBinaryStream(long pos) throws SQLException {
        this.checkState();
        if (pos <= 0L || pos > Integer.MAX_VALUE) {
            SQLException outSE = this.invalidPositionSQLException(pos);
            throw outSE;
        }
        int intPos = (int)pos;
        return new BlobOutputStream(this, intPos);
    }

    @Override
    public void truncate(long len) throws SQLException {
        this.checkState();
        int dataLength = this.bb.position();
        if (len < 0L || len > Integer.MAX_VALUE || len > (long)dataLength) {
            SQLException outSE = BlobFedSrv.invalidLengthSQLException(len);
            throw outSE;
        }
        int intLen = (int)len;
        this.bb.position(intLen);
    }

    @Override
    public void free() throws SQLException {
        this.bb.clear();
        this.lobState = LobStates.FREED;
    }

    public void logData(boolean logSystem) {
        int blobBytes = this.bb.position();
        int bytesToLog = 2 * UtilityFunctions.getFormatBytesRowSize();
        String lobStr = this.lobState.toString();
        String format = "State[%s] Position[%s] Capacity[%s]";
        String formatedItem = String.format(format, lobStr, blobBytes, this.bb.capacity());
        if (logSystem) {
            System.out.println(formatedItem);
        }
        if (logger != null) {
            logger.trace(formatedItem);
        }
        byte[] logBytes = this.bb.array();
        if (blobBytes < bytesToLog) {
            bytesToLog = blobBytes;
        }
        try {
            CommonLogger.logBytes(logger, logBytes, 0, bytesToLog, logSystem);
            if (blobBytes > 20) {
                CommonLogger.logBytes(logger, logBytes, blobBytes - bytesToLog, bytesToLog, logSystem);
            }
        }
        catch (SQLException se) {
            logger.trace("Exception:" + se.getLocalizedMessage());
        }
    }

    static {
        if (AbstractLogger.isTrace) {
            logger.trace("BlobData:Initialization");
        }
    }

    public static enum LobStates {
        IN(0),
        OUT(1),
        FREED(2);

        public int value;

        private LobStates(int value) {
            this.value = value;
        }
    }
}

