/*
 * Decompiled with CFR 0.152.
 */
package com.sas.tkts.sql;

import com.sas.iom.SASIOMDefs.AnySeqHolder;
import com.sas.iom.SASIOMDefs.LongSeqHolder;
import com.sas.tkts.FedSrvJDBC;
import com.sas.tkts.caching.Row;
import com.sas.tkts.iom.AbstractIOMWrapper;
import com.sas.tkts.iom.StatementWrapper;
import com.sas.tkts.logging.AbstractLogger;
import com.sas.tkts.logging.LoggerFactory;
import com.sas.tkts.sql.Constants;
import com.sas.tkts.sql.FSConnection;
import com.sas.tkts.sql.FSResultSet;
import com.sas.tkts.sql.LocalizedErrorHandler;
import com.sas.tkts.types.ColumnFactory;
import com.sas.tkts.util.RegExp;
import com.sas.tkts.util.TypesHelper;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.RowIdLifetime;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLWarning;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.StringTokenizer;
import org.omg.CORBA.Any;
import org.omg.CORBA.IntHolder;

public class FSDatabaseMetaData
extends FedSrvJDBC
implements DatabaseMetaData {
    private static final int FORWARD_ONLY = 0;
    private static final int STATIC_CURSOR = 1;
    private static final int DYNAMIC_CURSOR = 2;
    private static final int KEYSET_CURSOR = 3;
    private static final int ATTR_GROUP_1 = 0;
    private static final int ATTR_GROUP_2 = 1;
    private static final int ATTR_GROUP_3 = 2;
    private static final int CURSOR_ATTRIBUTES_GROUP_ARRAY_SIZE = 3;
    private static final int CURSOR_RSET_ARRAY_SIZE = 4;
    private static final String CORBA_NULL = "*";
    private static final String SQL_WILD = "%";
    private static final String SQL_EMPTY = "";
    private static final String[] NULL_TABLE_TYPES = null;
    private static String thisClassName = FSDatabaseMetaData.class.getName();
    private static AbstractLogger logger = LoggerFactory.getLogger(thisClassName);
    private static int JDBC_DRIVER_MAJOR_VERSION = 4;
    private static int JDBC_DRIVER_MINOR_VERSION = 4;
    private static int JDBC_MAJOR_VERSION = 4;
    private static int JDBC_MINOR_VERSION = 0;
    private transient long tktsConnectionID;
    private transient FSConnection tktsConnection;
    protected transient LinkedList<FSResultSet> fsResultSetList;
    private transient boolean supportsSelectForUpdate;
    private transient int supportsAlterTable = -1;
    private transient int catalogAtStart = -1;
    private transient int catalogUsage = -1;
    private transient int supportsConvert = -1;
    private transient int supportsDifferentTableCorrelationNames = -1;
    private transient int[][] cursorAttributesGroupByRSetType;
    private transient int resultSetHoldability = -1;
    private transient int serverSideResultSetHoldability = -1;
    private transient int supportsOpenCursorsAcrossRollback = -1;
    private transient int databaseMajorVersion = 0;
    private transient int databaseMinorVersion = 0;
    private transient int defaultTransactionIsolation = -1;
    private transient int usesLocalFilePerTable = -1;
    private transient int supportsGroupBy = -1;
    private transient int storesCaseIdentifier = -1;
    private transient int maxBinaryLiteralLength = -1;
    private transient int maxCatalogNameLength = -1;
    private transient int maxCharLiteralLength = -1;
    private transient int maxColumnNameLength = -1;
    private transient int maxColumnsInGroupBy = -1;
    private transient int maxColumnsInIndex = -1;
    private transient int maxColumnsInOrderBy = -1;
    private transient int maxColumnsInSelect = -1;
    private transient int maxColumnsInTable = -1;
    private transient int maxConnections = -1;
    private transient int maxProcedureNameLength = -1;
    private transient int maxRowSize = -1;
    private transient int maxSchemaNameLength = -1;
    private transient int maxStatementLength = -1;
    private transient int maxStatements = -1;
    private transient int maxTableNameLength = -1;
    private transient int maxTablesInSelect = -1;
    private transient int maxUserNameLength = -1;
    private transient int nullsAreSortedAtEnd = -1;
    private transient int nullPlusNonNullIsNull = -1;
    private transient int supportsFullOuterJoins = -1;
    private transient int supportsOrderByUnrelated = -1;
    private transient int supportsPositionedDelete = -1;
    private transient int storesQuotedCaseIdentifier = -1;
    private transient int supportsSchemasInDataManipulation = -1;
    private transient int supportsResultSetType = -1;
    private transient int supportsCorrelatedSubqueries = -1;
    private transient int supportsNonNullableColumns = -1;
    private transient int supportsDataDefinitionAndDataManipulationTransactions = -1;
    private transient int supportsTransactionIsolationLevel = -1;
    private transient int supportsUnion = -1;
    private transient long maxIndexLength = -1L;
    private transient String allProceduresAreCallable;
    private transient String allTablesAreSelectable;
    private transient String catalogSeparator;
    private transient String catalogTerm;
    private transient String supportsColumnAliasing;
    private transient String databaseProductVersion;
    private transient String driverName;
    private transient String driverVersion;
    private transient String extraNameCharacters;
    private transient String identifierQuoteString;
    private transient String isReadOnly;
    private transient String doesMaxRowSizeIncludeBlobs;
    private transient String numericFunctions;
    private transient String supportsExpressionsInOrderBy;
    private transient String procedureTerm;
    private transient String databaseProductName;
    private transient String schemaTerm;
    private transient String searchStringEscape;
    private transient String sqlKeywords;
    private transient String stringFunctions;
    private transient String supportsIntegrityEnhancementFacility;
    private transient String supportsLikeEscapeClause;
    private transient String supportsMultipleResultSets;
    private transient String supportsMultipleTransactions;
    private transient String supportsStoredProcs;
    private transient String systemFunctions;
    private transient String timedateFunctions;
    private transient String userName;

    private static void logRowList(String title, ArrayList<Row> list) {
        int al_m = list.size();
        logger.trace(title + " Rows:" + al_m);
        for (int al_i = 0; al_i < al_m; ++al_i) {
            Row r = list.get(al_i);
            String s = r.logString();
            logger.trace("     " + s);
        }
    }

    public FSDatabaseMetaData(FSConnection connection) {
        this.tktsConnection = connection;
        this.tktsConnectionID = this.tktsConnection.getMyID();
        long entryTime = 0L;
        long exitTime = 0L;
        entryTime = System.nanoTime();
        this.fsResultSetList = new LinkedList();
        try {
            this.loadCursorAttributes();
            this.initializeAllValues();
            exitTime = System.nanoTime();
            long delta = exitTime - entryTime;
            double seconds = delta;
            seconds /= 1.0E9;
            if (AbstractLogger.isTrace) {
                logger.trace("FSDatabaseMetaData Seconds:" + seconds + " nanoSeconds:" + delta);
            }
        }
        catch (SQLException ex) {
            String exSQLState = ex.getSQLState();
            String exMessage = ex.getLocalizedMessage();
            SQLWarning sw = new SQLWarning(exMessage, exSQLState);
            connection.addWarning(sw);
        }
    }

    @Override
    public boolean allProceduresAreCallable() throws SQLException {
        return this.allProceduresAreCallable.equalsIgnoreCase("Y");
    }

    @Override
    public boolean allTablesAreSelectable() throws SQLException {
        return this.allTablesAreSelectable.equalsIgnoreCase("Y");
    }

    @Override
    public boolean autoCommitFailureClosesAllResultSets() throws SQLException {
        return false;
    }

    @Override
    public boolean dataDefinitionCausesTransactionCommit() throws SQLException {
        return this.supportsDataDefinitionAndDataManipulationTransactions == 3;
    }

    @Override
    public boolean dataDefinitionIgnoredInTransactions() throws SQLException {
        return this.supportsDataDefinitionAndDataManipulationTransactions == 4;
    }

    @Override
    public boolean deletesAreDetected(int rSetType) throws SQLException {
        return this.isCursorOperationDetected(rSetType, 32L);
    }

    @Override
    public boolean doesMaxRowSizeIncludeBlobs() throws SQLException {
        return this.doesMaxRowSizeIncludeBlobs.equalsIgnoreCase("Y");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addToFSResultSetList(FSResultSet resultSet) {
        if (resultSet == null || this.fsResultSetList == null) {
            return;
        }
        LinkedList<FSResultSet> linkedList = this.fsResultSetList;
        synchronized (linkedList) {
            this.fsResultSetList.add(resultSet);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int resultSetCount() {
        int outInt = 0;
        if (this.fsResultSetList != null) {
            LinkedList<FSResultSet> linkedList = this.fsResultSetList;
            synchronized (linkedList) {
                outInt = this.fsResultSetList.size();
            }
        }
        return outInt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void clearFSResultSetList() throws SQLException {
        boolean releaseRSIncResources = false;
        if (this.fsResultSetList == null) {
            return;
        }
        LinkedList<FSResultSet> linkedList = this.fsResultSetList;
        synchronized (linkedList) {
            ListIterator fsListIter = this.fsResultSetList.listIterator();
            if (!this.fsResultSetList.isEmpty()) {
                while (fsListIter.hasNext()) {
                    FSResultSet resultSet = (FSResultSet)fsListIter.next();
                    resultSet.close(releaseRSIncResources);
                    fsListIter.remove();
                }
            }
        }
        this.fsResultSetList = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeFromFSResultSetList(FSResultSet fsResultSet) {
        if (this.fsResultSetList == null) {
            return;
        }
        LinkedList<FSResultSet> linkedList = this.fsResultSetList;
        synchronized (linkedList) {
            if (!this.fsResultSetList.isEmpty() && this.fsResultSetList.contains(fsResultSet)) {
                this.fsResultSetList.remove(fsResultSet);
            }
        }
    }

    protected void releaseOutgoingResources() throws SQLException {
        this.clearFSResultSetList();
        if (this.tktsConnection != null) {
            this.tktsConnection = null;
        }
    }

    protected void checkIfConnectionClosed() throws SQLException {
        if (this.tktsConnection == null || this.tktsConnection.isClosed()) {
            String ei = "TKTSConnection.closedConnectionError.txt";
            LocalizedErrorHandler.throwLocalizedException("TKTSConnection.closedConnectionError.txt", logger);
        }
    }

    @Override
    public ResultSet getAttributes(String catalog, String schemaPattern, String typeNamePattern, String attributeNamePattern) throws SQLException {
        String method = "getAttributes";
        if (AbstractLogger.isInfo) {
            String ei = "FSDatabaseMetaData.getAttributes.fmt";
            this.logInfoMessage("getAttributes", "FSDatabaseMetaData.getAttributes.fmt", logger, catalog, schemaPattern, typeNamePattern, attributeNamePattern);
        }
        this.checkIfConnectionClosed();
        catalog = catalog == null ? CORBA_NULL : this.escapeAsteriskChar(catalog);
        schemaPattern = schemaPattern == null ? CORBA_NULL : this.escapeAsteriskChar(schemaPattern);
        typeNamePattern = typeNamePattern == null ? CORBA_NULL : this.escapeAsteriskChar(typeNamePattern);
        attributeNamePattern = attributeNamePattern == null ? CORBA_NULL : this.escapeAsteriskChar(attributeNamePattern);
        if (AbstractLogger.isTrace) {
            logger.exit("getAttributes", "Info: Not Supported - Always returns empty ResultSet!");
        }
        FSResultSet fsResultSet = new FSResultSet(Constants.mdTypes.UDT_ATTRIBUTES_TYPE, this);
        this.addToFSResultSetList(fsResultSet);
        return fsResultSet;
    }

    @Override
    public ResultSet getBestRowIdentifier(String catalog, String schema, String table, int scope, boolean nullable) throws SQLException {
        String ei;
        String method = "getBestRowIdentifier";
        IntHolder stat = new IntHolder();
        FSResultSet resultSet = null;
        int idType = 1;
        int nullFlag = 0;
        if (AbstractLogger.isInfo) {
            ei = "FSDatabaseMetaData.getBestRowIdentifier.fmt";
            this.logInfoMessage("getBestRowIdentifier", "FSDatabaseMetaData.getBestRowIdentifier.fmt", logger, catalog, schema, table, String.valueOf(scope), String.valueOf(nullable));
        }
        this.checkIfConnectionClosed();
        catalog = catalog == null ? CORBA_NULL : this.escapeAsteriskChar(catalog);
        schema = schema == null ? CORBA_NULL : this.escapeAsteriskChar(schema);
        if (table == null) {
            ei = "TKTSDatabaseMetaData.bestRowError1.fmt";
            this.throwException("TKTSDatabaseMetaData.bestRowError1.fmt", logger, "getBestRowIdentifier");
        }
        if (nullable) {
            nullFlag = 1;
        }
        StatementWrapper tSW = this.tktsConnection.getCatalogWrapper();
        try {
            tSW.SpecialColumns(idType, catalog, schema, table, scope, nullFlag, stat);
            resultSet = new FSResultSet(Constants.mdTypes.BESTROWIDENTIFIER, tSW, this);
        }
        catch (Exception exception) {
            SQLException outSE = FSDatabaseMetaData.createFunctionException("getBestRowIdentifier", exception, tSW, logger);
            this.closeStmtWrapper(tSW, "getBestRowIdentifier");
            throw outSE;
        }
        this.addToFSResultSetList(resultSet);
        return resultSet;
    }

    private void closeStmtWrapper(StatementWrapper sw, String method) {
        block3: {
            if (sw != null) {
                try {
                    sw.Close();
                }
                catch (Exception ex) {
                    if (!AbstractLogger.isError) break block3;
                    logger.trace(method, "Exception:" + ex);
                }
            }
        }
    }

    private FSConnection getCatalogConn(String exMethod) throws SQLException {
        FSConnection tConn = null;
        this.checkIfConnectionClosed();
        try {
            Properties connProps = this.tktsConnection.getConnectionProp();
            String connURL = this.tktsConnection.getConnectionURL();
            tConn = new FSConnection(connURL, connProps);
        }
        catch (Exception exception) {
            FSDatabaseMetaData.throwFunctionException(exMethod, exception, this.tktsConnection.getConnectionWrapper(), logger);
        }
        return tConn;
    }

    protected static String replaceUsingRegEx(String[][] regExInfo, String inStr) {
        String outStr = inStr;
        int rm = regExInfo.length;
        try {
            for (int ri = 0; ri < rm; ++ri) {
                String regEx = regExInfo[ri][0];
                String regRep = regExInfo[ri][1];
                outStr = outStr.replaceAll(regEx, regRep);
            }
        }
        catch (Exception ex) {
            if (AbstractLogger.isError) {
                logger.error("Exception in replaceUsingRegEx:");
                logger.error(ex);
            }
            outStr = inStr;
        }
        return outStr;
    }

    private String escapeAsteriskChar(String inStr) {
        String out = RegExp.escapeAsteriskChar(inStr);
        return out;
    }

    private ArrayList<String> getCatalogsList(FSConnection inConn, String inCatalog, boolean allCatalogs, boolean catalogCS) {
        String method = "getCatalogsList";
        StatementWrapper tStmtWrapper = null;
        DatabaseMetaData t_md = null;
        ResultSet t_rs = null;
        ArrayList<String> catalogs = new ArrayList<String>(0);
        ArrayList<String> outCatalogs = new ArrayList<String>(0);
        String oldInCatalog = inCatalog;
        int numFailures = 0;
        int numbNull = 0;
        int numWarning = 0;
        RegExp sqlPattern = null;
        if (AbstractLogger.isTrace) {
            logger.trace("getCatalogsList inCatalog:'" + inCatalog + "' allCatalogs:" + allCatalogs);
        }
        if (inCatalog == null) {
            inCatalog = SQL_WILD;
        } else {
            boolean pva = this.tktsConnection.getCatalogPVA();
            sqlPattern = new RegExp(pva, catalogCS, inCatalog);
        }
        try {
            String currentCatalog;
            boolean match;
            int i;
            String targetCatalog;
            int oldNumCatalogs = 1;
            if (allCatalogs) {
                t_md = inConn.getMetaData();
                tStmtWrapper = inConn.getCatalogWrapper();
                t_rs = t_md.getTables(SQL_WILD, SQL_EMPTY, SQL_EMPTY, NULL_TABLE_TYPES);
                while (t_rs.next()) {
                    targetCatalog = t_rs.getString(1);
                    catalogs.add(targetCatalog);
                }
                t_rs.close();
                oldNumCatalogs = catalogs.size();
                for (i = 0; i < oldNumCatalogs; ++i) {
                    targetCatalog = (String)catalogs.get(i);
                    if (targetCatalog == null) {
                        ++numbNull;
                        continue;
                    }
                    if (oldInCatalog != null && !(match = sqlPattern.matches(targetCatalog))) continue;
                    try {
                        inConn.clearWarnings();
                        inConn.setCatalog(targetCatalog);
                        currentCatalog = inConn.getCatalog();
                        match = catalogCS ? targetCatalog.equals(currentCatalog) : targetCatalog.equalsIgnoreCase(currentCatalog);
                        if (!match) continue;
                        outCatalogs.add(targetCatalog);
                        continue;
                    }
                    catch (SQLException ex) {
                        if (AbstractLogger.isTrace) {
                            logger.trace("SetCatalog: " + targetCatalog);
                            logger.trace(ex);
                        }
                        ++numFailures;
                    }
                }
            } else {
                currentCatalog = inConn.getCatalog();
                match = oldInCatalog == null ? true : sqlPattern.matches(currentCatalog);
                if (match) {
                    outCatalogs.add(currentCatalog);
                }
            }
            if (AbstractLogger.isTrace) {
                int numCatalogs = outCatalogs.size();
                logger.trace("Catalogs old[" + oldNumCatalogs + "] new[" + numCatalogs + "] Failures[" + numFailures + "] Nulls[" + numbNull + "] numWarning[" + numWarning + "] ");
                for (i = 0; i < numCatalogs; ++i) {
                    targetCatalog = (String)catalogs.get(i);
                    logger.trace("      '" + targetCatalog + "' ");
                }
            }
        }
        catch (Exception exception) {
            if (AbstractLogger.isTrace) {
                logger.trace(exception);
            }
            ++numFailures;
        }
        this.closeStmtWrapper(tStmtWrapper, "getCatalogsList");
        if (sqlPattern != null) {
            sqlPattern.reset();
            sqlPattern = null;
        }
        return outCatalogs;
    }

    @Override
    public ResultSet getCatalogs() throws SQLException {
        String method = "getCatalogs";
        if (AbstractLogger.isInfo) {
            String ei = "FSDatabaseMetaData.getCatalogs.txt";
            this.logInfoMessage("getCatalogs", "FSDatabaseMetaData.getCatalogs.txt", logger, new Object[0]);
        }
        FSResultSet resultSet = null;
        IntHolder status = new IntHolder();
        this.checkIfConnectionClosed();
        StatementWrapper tSW = this.tktsConnection.getCatalogWrapper();
        try {
            tSW.Tables(SQL_WILD, SQL_EMPTY, SQL_EMPTY, SQL_EMPTY, status);
            resultSet = new FSResultSet(Constants.mdTypes.CATALOGS, tSW, this);
        }
        catch (Exception exception) {
            SQLException outSE = FSDatabaseMetaData.createFunctionException("getCatalogs", exception, tSW, logger);
            this.closeStmtWrapper(tSW, "getCatalogs");
            throw outSE;
        }
        this.addToFSResultSetList(resultSet);
        return resultSet;
    }

    @Override
    public String getCatalogSeparator() throws SQLException {
        return this.catalogSeparator;
    }

    @Override
    public String getCatalogTerm() throws SQLException {
        return this.catalogTerm;
    }

    @Override
    public ResultSet getClientInfoProperties() throws SQLException {
        String method = "getClientInfoProperties";
        if (AbstractLogger.isInfo) {
            String ei = "FSDatabaseMetaData.getClientInfoProperties.txt";
            this.logInfoMessage("getClientInfoProperties", "FSDatabaseMetaData.getClientInfoProperties.txt", logger, new Object[0]);
        }
        this.checkIfConnectionClosed();
        if (AbstractLogger.isTrace) {
            logger.exit("getClientInfoProperties", "Info: Not Supported - Always returns empty ResultSet!");
        }
        FSResultSet resultSet = new FSResultSet(Constants.mdTypes.CLIENTINFOPROPERTIES, this);
        this.addToFSResultSetList(resultSet);
        return resultSet;
    }

    @Override
    public ResultSet getColumnPrivileges(String catalog, String schema, String table, String columnNamesPattern) throws SQLException {
        String ei;
        String method = "getColumnPrivileges";
        FSResultSet resultSet = null;
        IntHolder status = new IntHolder();
        if (AbstractLogger.isInfo) {
            ei = "FSDatabaseMetaData.getColumnPrivileges.fmt";
            this.logInfoMessage("getColumnPrivileges", "FSDatabaseMetaData.getColumnPrivileges.fmt", logger, catalog, schema, table, columnNamesPattern);
        }
        this.checkIfConnectionClosed();
        catalog = catalog == null ? CORBA_NULL : this.escapeAsteriskChar(catalog);
        schema = schema == null ? CORBA_NULL : this.escapeAsteriskChar(schema);
        columnNamesPattern = columnNamesPattern == null ? CORBA_NULL : this.escapeAsteriskChar(columnNamesPattern);
        if (table == null) {
            ei = "TKTSDatabaseMetaData.columnPrivilegesError1.fmt";
            this.throwException("TKTSDatabaseMetaData.columnPrivilegesError1.fmt", logger, "getColumnPrivileges");
        }
        StatementWrapper tSW = this.tktsConnection.getCatalogWrapper();
        try {
            tSW.ColumnPrivileges(catalog, schema, table, columnNamesPattern, status);
            resultSet = new FSResultSet(Constants.mdTypes.COLUMNPRIVILEGES, tSW, this);
        }
        catch (Exception exception) {
            FSDatabaseMetaData.timeOutError(exception, "'%s':'%s':'%s':'%s':'%s'", "getColumnPrivileges", catalog, schema, table, columnNamesPattern);
            SQLException outSE = FSDatabaseMetaData.createFunctionException("getColumnPrivileges", exception, tSW, logger);
            this.closeStmtWrapper(tSW, "getColumnPrivileges");
            throw outSE;
        }
        this.addToFSResultSetList(resultSet);
        return resultSet;
    }

    @Override
    public ResultSet getColumns(String catalog, String schemaPattern, String tableNamePattern, String columnNamePattern) throws SQLException {
        String method = "getColumns";
        FSResultSet resultSet = null;
        IntHolder status = new IntHolder();
        if (AbstractLogger.isInfo) {
            String ei = "FSDatabaseMetaData.getColumns.fmt";
            this.logInfoMessage("getColumns", "FSDatabaseMetaData.getColumns.fmt", logger, catalog, schemaPattern, tableNamePattern, columnNamePattern);
        }
        this.checkIfConnectionClosed();
        catalog = catalog == null ? CORBA_NULL : this.escapeAsteriskChar(catalog);
        schemaPattern = schemaPattern == null ? CORBA_NULL : this.escapeAsteriskChar(schemaPattern);
        tableNamePattern = tableNamePattern == null ? CORBA_NULL : this.escapeAsteriskChar(tableNamePattern);
        columnNamePattern = columnNamePattern == null ? CORBA_NULL : this.escapeAsteriskChar(columnNamePattern);
        StatementWrapper tSW = this.tktsConnection.getCatalogWrapper();
        try {
            tSW.Columns(catalog, schemaPattern, tableNamePattern, columnNamePattern, status);
            resultSet = new FSResultSet(Constants.mdTypes.COLUMNS, tSW, this);
        }
        catch (Exception exception) {
            SQLException outSE = FSDatabaseMetaData.createFunctionException("getColumns", exception, tSW, logger);
            this.closeStmtWrapper(tSW, "getColumns");
            throw outSE;
        }
        this.addToFSResultSetList(resultSet);
        return resultSet;
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.tktsConnection;
    }

    @Override
    public ResultSet getCrossReference(String primaryCatalog, String primarySchema, String primaryTable, String foreignCatalog, String foreignSchema, String foreignTable) throws SQLException {
        String ei;
        String method = "getCrossReference";
        FSResultSet resultSet = null;
        IntHolder status = new IntHolder();
        if (AbstractLogger.isInfo) {
            ei = "FSDatabaseMetaData.getCrossReference.fmt";
            this.logInfoMessage("getCrossReference", "FSDatabaseMetaData.getCrossReference.fmt", logger, primaryCatalog, primarySchema, primaryTable, foreignCatalog, foreignSchema, foreignTable);
        }
        this.checkIfConnectionClosed();
        primaryCatalog = primaryCatalog == null ? CORBA_NULL : this.escapeAsteriskChar(primaryCatalog);
        primarySchema = primarySchema == null ? CORBA_NULL : this.escapeAsteriskChar(primarySchema);
        foreignCatalog = foreignCatalog == null ? CORBA_NULL : this.escapeAsteriskChar(foreignCatalog);
        foreignSchema = foreignSchema == null ? CORBA_NULL : this.escapeAsteriskChar(foreignSchema);
        if (primaryTable == null || foreignTable == null) {
            ei = "TKTSDatabaseMetaData.crossReferenceError.fmt";
            this.throwException("TKTSDatabaseMetaData.crossReferenceError.fmt", logger, "getCrossReference");
        }
        StatementWrapper tSW = this.tktsConnection.getCatalogWrapper();
        try {
            tSW.ForeignKeys(primaryCatalog, primarySchema, primaryTable, foreignCatalog, foreignSchema, foreignTable, status);
            resultSet = new FSResultSet(Constants.mdTypes.CROSSREFERENCE, tSW, this);
        }
        catch (Exception exception) {
            SQLException outSE = FSDatabaseMetaData.createFunctionException("getCrossReference", exception, tSW, logger);
            this.closeStmtWrapper(tSW, "getCrossReference");
            throw outSE;
        }
        this.addToFSResultSetList(resultSet);
        return resultSet;
    }

    @Override
    public int getDatabaseMajorVersion() throws SQLException {
        return this.databaseMajorVersion;
    }

    @Override
    public int getDatabaseMinorVersion() throws SQLException {
        return this.databaseMinorVersion;
    }

    @Override
    public String getDatabaseProductName() throws SQLException {
        return this.databaseProductName;
    }

    private void getDatabaseProductVersionInit() {
        boolean formatError = false;
        if (this.databaseProductVersion != null && !this.databaseProductVersion.equals(SQL_EMPTY)) {
            StringTokenizer tokens = new StringTokenizer(this.databaseProductVersion, ".");
            if (tokens.hasMoreTokens()) {
                try {
                    this.databaseMajorVersion = Integer.parseInt(tokens.nextToken());
                }
                catch (NoSuchElementException nsee) {
                    if (AbstractLogger.isTrace) {
                        logger.trace("databaseMajorVersion: ");
                        logger.trace(nsee);
                    }
                    this.databaseMajorVersion = 0;
                    formatError = true;
                }
            } else {
                formatError = true;
            }
            if (tokens.hasMoreTokens()) {
                try {
                    this.databaseMinorVersion = Integer.parseInt(tokens.nextToken());
                }
                catch (NoSuchElementException nsee) {
                    if (AbstractLogger.isTrace) {
                        logger.trace("databaseMinorVersion: ");
                        logger.trace(nsee);
                    }
                    formatError = true;
                }
            }
            if (formatError) {
                String format = "Incorrect format for database product version string:'%s'";
                String out = String.format("Incorrect format for database product version string:'%s'", this.databaseProductVersion);
                logger.warn(out);
            }
        }
    }

    @Override
    public String getDatabaseProductVersion() throws SQLException {
        return this.databaseProductVersion;
    }

    @Override
    public int getDefaultTransactionIsolation() throws SQLException {
        return this.defaultTransactionIsolation;
    }

    @Override
    public int getDriverMajorVersion() {
        return JDBC_DRIVER_MAJOR_VERSION;
    }

    @Override
    public int getDriverMinorVersion() {
        return JDBC_DRIVER_MINOR_VERSION;
    }

    @Override
    public String getDriverName() throws SQLException {
        if (this.driverName == null) {
            this.driverName = LocalizedErrorHandler.getString("TKTSDatabaseMetaData.driverName.txt");
        }
        return this.driverName;
    }

    @Override
    public String getDriverVersion() throws SQLException {
        if (this.driverVersion == null) {
            String packageName = this.getClass().getPackage().getName();
            Package pakage = Package.getPackage(packageName);
            String driverBuildVersion = pakage.getImplementationVersion();
            this.driverVersion = driverBuildVersion == null ? JDBC_DRIVER_MAJOR_VERSION + "." + JDBC_DRIVER_MINOR_VERSION : JDBC_DRIVER_MAJOR_VERSION + "." + JDBC_DRIVER_MINOR_VERSION + "." + driverBuildVersion;
        }
        return this.driverVersion;
    }

    @Override
    public ResultSet getExportedKeys(String catalog, String schema, String table) throws SQLException {
        String ei;
        String method = "getExportedKeys";
        FSResultSet resultSet = null;
        IntHolder status = new IntHolder();
        if (AbstractLogger.isInfo) {
            ei = "FSDatabaseMetaData.getExportedKeys.fmt";
            this.logInfoMessage("getExportedKeys", "FSDatabaseMetaData.getExportedKeys.fmt", logger, catalog, schema, table);
        }
        this.checkIfConnectionClosed();
        catalog = catalog == null ? CORBA_NULL : this.escapeAsteriskChar(catalog);
        schema = schema == null ? CORBA_NULL : this.escapeAsteriskChar(schema);
        if (table == null) {
            ei = "TKTSDatabaseMetaData.exportedKeysError1.fmt";
            this.throwException("TKTSDatabaseMetaData.exportedKeysError1.fmt", logger, "getExportedKeys");
        }
        StatementWrapper tSW = this.tktsConnection.getCatalogWrapper();
        try {
            tSW.ForeignKeys(catalog, schema, table, CORBA_NULL, CORBA_NULL, CORBA_NULL, status);
            resultSet = new FSResultSet(Constants.mdTypes.EXPORTEDKEYS, tSW, this);
        }
        catch (Exception exception) {
            SQLException outSE = FSDatabaseMetaData.createFunctionException("getExportedKeys", exception, tSW, logger);
            this.closeStmtWrapper(tSW, "getExportedKeys");
            throw outSE;
        }
        this.addToFSResultSetList(resultSet);
        return resultSet;
    }

    @Override
    public ResultSet getFunctions(String catalog, String schemaPattern, String functionNamePattern) throws SQLException {
        String method = "getFunctions";
        FSResultSet resultSet = null;
        if (AbstractLogger.isInfo) {
            String ei = "FSDatabaseMetaData.getFunctions.fmt";
            this.logInfoMessage("getFunctions", "FSDatabaseMetaData.getFunctions.fmt", logger, catalog, schemaPattern, functionNamePattern);
        }
        this.checkIfConnectionClosed();
        catalog = catalog == null ? CORBA_NULL : this.escapeAsteriskChar(catalog);
        schemaPattern = schemaPattern == null ? CORBA_NULL : this.escapeAsteriskChar(schemaPattern);
        functionNamePattern = functionNamePattern == null ? CORBA_NULL : this.escapeAsteriskChar(functionNamePattern);
        if (AbstractLogger.isTrace) {
            logger.exit("getFunctions", "getFunctions: Not Supported - Always returns empty ResultSet!");
        }
        resultSet = new FSResultSet(Constants.mdTypes.FUNCTIONS, this);
        this.addToFSResultSetList(resultSet);
        return resultSet;
    }

    @Override
    public String getExtraNameCharacters() throws SQLException {
        return this.extraNameCharacters;
    }

    @Override
    public String getIdentifierQuoteString() throws SQLException {
        return this.identifierQuoteString;
    }

    @Override
    public ResultSet getImportedKeys(String catalog, String schema, String table) throws SQLException {
        String ei;
        String method = "getImportedKeys";
        IntHolder status = new IntHolder();
        FSResultSet resultSet = null;
        if (AbstractLogger.isInfo) {
            ei = "FSDatabaseMetaData.getImportedKeys.fmt";
            this.logInfoMessage("getImportedKeys", "FSDatabaseMetaData.getImportedKeys.fmt", logger, catalog, schema, table);
        }
        this.checkIfConnectionClosed();
        catalog = catalog == null ? CORBA_NULL : this.escapeAsteriskChar(catalog);
        schema = schema == null ? CORBA_NULL : this.escapeAsteriskChar(schema);
        if (table == null) {
            ei = "TKTSDatabaseMetaData.importedKeysError1.fmt";
            this.throwException("TKTSDatabaseMetaData.importedKeysError1.fmt", logger, "getImportedKeys");
        }
        StatementWrapper tSW = this.tktsConnection.getCatalogWrapper();
        try {
            tSW.ForeignKeys(CORBA_NULL, CORBA_NULL, CORBA_NULL, catalog, schema, table, status);
            resultSet = new FSResultSet(Constants.mdTypes.IMPORTEDKEYS, tSW, this);
        }
        catch (Exception exception) {
            SQLException outSE = FSDatabaseMetaData.createFunctionException("getImportedKeys", exception, tSW, logger);
            this.closeStmtWrapper(tSW, "getImportedKeys");
            throw outSE;
        }
        this.addToFSResultSetList(resultSet);
        return resultSet;
    }

    @Override
    public ResultSet getIndexInfo(String catalog, String schema, String table, boolean unique, boolean approximate) throws SQLException {
        String ei;
        String method = "getIndexInfo";
        int uniqueFlag = 0;
        int resFlag = 0;
        IntHolder status = new IntHolder();
        FSResultSet resultSet = null;
        if (AbstractLogger.isInfo) {
            ei = "FSDatabaseMetaData.getIndexInfo.fmt";
            this.logInfoMessage("getIndexInfo", "FSDatabaseMetaData.getIndexInfo.fmt", logger, catalog, schema, table, String.valueOf(unique), String.valueOf(approximate));
        }
        this.checkIfConnectionClosed();
        catalog = catalog == null ? CORBA_NULL : this.escapeAsteriskChar(catalog);
        schema = schema == null ? CORBA_NULL : this.escapeAsteriskChar(schema);
        if (table == null) {
            ei = "TKTSDatabaseMetaData.indexInfoError1.fmt";
            this.throwException("TKTSDatabaseMetaData.indexInfoError1.fmt", logger, "getIndexInfo");
        }
        uniqueFlag = unique ? 0 : 1;
        resFlag = approximate ? 0 : 1;
        resFlag = 0;
        StatementWrapper tSW = this.tktsConnection.getCatalogWrapper();
        try {
            tSW.Statistics(catalog, schema, table, uniqueFlag, resFlag, status);
            resultSet = new FSResultSet(Constants.mdTypes.INDEX_INFO, tSW, this);
        }
        catch (Exception exception) {
            SQLException outSE = FSDatabaseMetaData.createFunctionException("getIndexInfo", exception, tSW, logger);
            this.closeStmtWrapper(tSW, "getIndexInfo");
            throw outSE;
        }
        this.addToFSResultSetList(resultSet);
        return resultSet;
    }

    @Override
    public int getJDBCMajorVersion() throws SQLException {
        return JDBC_MAJOR_VERSION;
    }

    @Override
    public int getJDBCMinorVersion() throws SQLException {
        return JDBC_MINOR_VERSION;
    }

    @Override
    public int getMaxBinaryLiteralLength() throws SQLException {
        return this.maxBinaryLiteralLength;
    }

    @Override
    public int getMaxCatalogNameLength() throws SQLException {
        return this.maxCatalogNameLength;
    }

    @Override
    public int getMaxCharLiteralLength() throws SQLException {
        return this.maxCharLiteralLength;
    }

    @Override
    public int getMaxColumnNameLength() throws SQLException {
        return this.maxColumnNameLength;
    }

    @Override
    public int getMaxColumnsInGroupBy() throws SQLException {
        return this.maxColumnsInGroupBy;
    }

    @Override
    public int getMaxColumnsInIndex() throws SQLException {
        return this.maxColumnsInIndex;
    }

    @Override
    public int getMaxColumnsInOrderBy() throws SQLException {
        return this.maxColumnsInOrderBy;
    }

    @Override
    public int getMaxColumnsInSelect() throws SQLException {
        return this.maxColumnsInSelect;
    }

    @Override
    public int getMaxColumnsInTable() throws SQLException {
        return this.maxColumnsInTable;
    }

    @Override
    public int getMaxConnections() throws SQLException {
        return this.maxConnections;
    }

    @Override
    public int getMaxCursorNameLength() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxIndexLength() throws SQLException {
        return (int)this.maxIndexLength;
    }

    @Override
    public int getMaxProcedureNameLength() throws SQLException {
        return this.maxProcedureNameLength;
    }

    @Override
    public int getMaxRowSize() throws SQLException {
        return this.maxRowSize;
    }

    @Override
    public int getMaxSchemaNameLength() throws SQLException {
        return this.maxSchemaNameLength;
    }

    @Override
    public int getMaxStatementLength() throws SQLException {
        return this.maxStatementLength;
    }

    @Override
    public int getMaxStatements() throws SQLException {
        return this.maxStatements;
    }

    @Override
    public int getMaxTableNameLength() throws SQLException {
        return this.maxTableNameLength;
    }

    @Override
    public int getMaxTablesInSelect() throws SQLException {
        return this.maxTablesInSelect;
    }

    @Override
    public int getMaxUserNameLength() throws SQLException {
        return this.maxUserNameLength;
    }

    @Override
    public String getNumericFunctions() throws SQLException {
        return this.numericFunctions;
    }

    @Override
    public ResultSet getPrimaryKeys(String catalog, String schema, String table) throws SQLException {
        String ei;
        String method = "getPrimaryKeys";
        IntHolder stat = new IntHolder();
        FSResultSet resultSet = null;
        if (AbstractLogger.isInfo) {
            ei = "FSDatabaseMetaData.getPrimaryKeys.fmt";
            this.logInfoMessage("getPrimaryKeys", "FSDatabaseMetaData.getPrimaryKeys.fmt", logger, catalog, schema, table);
        }
        this.checkIfConnectionClosed();
        catalog = catalog == null ? CORBA_NULL : this.escapeAsteriskChar(catalog);
        schema = schema == null ? CORBA_NULL : this.escapeAsteriskChar(schema);
        if (table == null) {
            ei = "TKTSDatabaseMetaData.primaryKeysError.fmt";
            this.throwException("TKTSDatabaseMetaData.primaryKeysError.fmt", logger, "getPrimaryKeys");
        }
        StatementWrapper tSW = this.tktsConnection.getCatalogWrapper();
        try {
            tSW.PrimaryKeys(catalog, schema, table, stat);
            resultSet = new FSResultSet(Constants.mdTypes.PRIMARYKEYS, tSW, this);
        }
        catch (Exception exception) {
            SQLException outSE = FSDatabaseMetaData.createFunctionException("getPrimaryKeys", exception, tSW, logger);
            this.closeStmtWrapper(tSW, "getPrimaryKeys");
            throw outSE;
        }
        this.addToFSResultSetList(resultSet);
        return resultSet;
    }

    @Override
    public ResultSet getProcedureColumns(String catalog, String schemaPattern, String procedureNamePattern, String columnNamePattern) throws SQLException {
        String method = "getProcedureColumns";
        IntHolder status = new IntHolder();
        FSResultSet resultSet = null;
        if (AbstractLogger.isInfo) {
            String ei = "FSDatabaseMetaData.getProcedureColumns.fmt";
            this.logInfoMessage("getProcedureColumns", "FSDatabaseMetaData.getProcedureColumns.fmt", logger, catalog, schemaPattern, procedureNamePattern, columnNamePattern);
        }
        this.checkIfConnectionClosed();
        catalog = catalog == null ? CORBA_NULL : this.escapeAsteriskChar(catalog);
        schemaPattern = schemaPattern == null ? CORBA_NULL : this.escapeAsteriskChar(schemaPattern);
        procedureNamePattern = procedureNamePattern == null ? CORBA_NULL : this.escapeAsteriskChar(procedureNamePattern);
        columnNamePattern = columnNamePattern == null ? CORBA_NULL : this.escapeAsteriskChar(columnNamePattern);
        StatementWrapper tSW = this.tktsConnection.getCatalogWrapper();
        try {
            tSW.ProcedureColumns(catalog, schemaPattern, procedureNamePattern, columnNamePattern, status);
            resultSet = new FSResultSet(Constants.mdTypes.PROC_COLUMNS, tSW, this);
        }
        catch (Exception exception) {
            FSDatabaseMetaData.timeOutError(exception, "'%s':'%s':'%s':'%s':'%s'", "getProcedureColumns", catalog, schemaPattern, procedureNamePattern, columnNamePattern);
            SQLException outSE = FSDatabaseMetaData.createFunctionException("getProcedureColumns", exception, tSW, logger);
            this.closeStmtWrapper(tSW, "getProcedureColumns");
            throw outSE;
        }
        this.addToFSResultSetList(resultSet);
        return resultSet;
    }

    @Override
    public ResultSet getProcedures(String catalog, String schemaPattern, String procedureNamePattern) throws SQLException {
        String method = "getProcedures";
        FSResultSet resultSet = null;
        IntHolder status = new IntHolder();
        if (AbstractLogger.isInfo) {
            String ei = "FSDatabaseMetaData.getProcedures.fmt";
            this.logInfoMessage("getProcedures", "FSDatabaseMetaData.getProcedures.fmt", logger, catalog, schemaPattern, procedureNamePattern);
        }
        this.checkIfConnectionClosed();
        catalog = catalog == null ? CORBA_NULL : this.escapeAsteriskChar(catalog);
        schemaPattern = schemaPattern == null ? CORBA_NULL : this.escapeAsteriskChar(schemaPattern);
        if (procedureNamePattern == null) {
            procedureNamePattern = CORBA_NULL;
        }
        if (AbstractLogger.isTrace) {
            logger.entry("getProcedures", "Cat=[" + catalog + "] schema=[" + schemaPattern + "] procName=[" + procedureNamePattern + "]");
        }
        StatementWrapper tSW = this.tktsConnection.getCatalogWrapper();
        try {
            tSW.Procedures(catalog, schemaPattern, procedureNamePattern, status);
            resultSet = new FSResultSet(Constants.mdTypes.PROCEDURES, tSW, this);
        }
        catch (Exception exception) {
            FSDatabaseMetaData.timeOutError(exception, "'%s':'%s':'%s':'%s'", "getProcedures", catalog, schemaPattern, procedureNamePattern);
            SQLException outSE = FSDatabaseMetaData.createFunctionException("getProcedures", exception, tSW, logger);
            this.closeStmtWrapper(tSW, "getProcedures");
            throw outSE;
        }
        this.addToFSResultSetList(resultSet);
        return resultSet;
    }

    @Override
    public String getProcedureTerm() throws SQLException {
        return this.procedureTerm;
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        return this.resultSetHoldability == 2 ? 1 : 2;
    }

    private ArrayList<Row> getSchemasImpl(String inCatalog, String inSchemaPattern, String exMethod) throws SQLException {
        ArrayList<Row> outSchemas;
        block25: {
            String method = "getSchemasImpl";
            FSConnection tConn = null;
            String oldInSchemaPattern = inSchemaPattern;
            StatementWrapper tStmtWrapper = null;
            RegExp sqlPattern = null;
            outSchemas = new ArrayList<Row>(0);
            ArrayList<Object> catalogs = new ArrayList(0);
            boolean catalogCS = this.tktsConnection.getCatalogCaseSensitive();
            boolean schemaCS = this.tktsConnection.getSchemaCaseSensitive();
            boolean addSchema = false;
            boolean otp = this.tktsConnection.getOTP();
            boolean allCatalogs = this.tktsConnection.getCatalogAll();
            if (AbstractLogger.isTrace) {
                logger.trace("getSchemasImpl", "getSchemasImpl inCatalog:'" + inCatalog + "' inSchemaPattern:'" + inSchemaPattern + "' ");
            }
            if ((tConn = otp ? this.tktsConnection : this.getCatalogConn(exMethod)) == null) {
                return outSchemas;
            }
            String oldCatalog = tConn.getCatalog();
            if (inSchemaPattern == null) {
                inSchemaPattern = SQL_EMPTY;
            } else {
                boolean pva = this.tktsConnection.getCatalogPVA();
                sqlPattern = new RegExp(pva, schemaCS, inSchemaPattern);
            }
            try {
                DatabaseMetaData t_md = tConn.getMetaData();
                ResultSet t_rs = null;
                tStmtWrapper = tConn.getCatalogWrapper();
                catalogs = this.getCatalogsList(tConn, inCatalog, allCatalogs, catalogCS);
                int numCatalogs = catalogs.size();
                int numSchemas = 0;
                int numFailures = 0;
                int numbNull = 0;
                int numWarning = 0;
                int numNoMatch = 0;
                for (int al_i = 0; al_i < numCatalogs; ++al_i) {
                    String targetCatalog = (String)catalogs.get(al_i);
                    if (targetCatalog == null) {
                        ++numbNull;
                        continue;
                    }
                    try {
                        tConn.clearWarnings();
                        tConn.setCatalog(targetCatalog);
                        String currentCatalog = tConn.getCatalog();
                        SQLWarning sw = tConn.getWarnings();
                        if (AbstractLogger.isTrace) {
                            logger.trace("getSchemasImpl", "   target:current '" + targetCatalog + "':'" + currentCatalog + "' ");
                            if (sw != null) {
                                logger.trace("getSchemasImpl", "   'Warning:[" + sw + "] ");
                                ++numWarning;
                            }
                        }
                        t_rs = t_md.getTables(SQL_EMPTY, SQL_WILD, SQL_EMPTY, NULL_TABLE_TYPES);
                        while (t_rs.next()) {
                            addSchema = false;
                            ++numSchemas;
                            String targetSchema = t_rs.getString(2);
                            if (oldInSchemaPattern == null) {
                                addSchema = true;
                            } else {
                                boolean match = sqlPattern.matches(targetSchema);
                                if (match) {
                                    addSchema = true;
                                }
                            }
                            if (!addSchema) continue;
                            Row tRow = new Row(2);
                            tRow.setColumnData(0, ColumnFactory.createStringColunn(targetSchema));
                            tRow.setColumnData(1, ColumnFactory.createStringColunn(targetCatalog));
                            outSchemas.add(tRow);
                            if (!AbstractLogger.isTrace) continue;
                            logger.trace("getSchemasImpl", "       Schemas::'" + targetCatalog + "':'" + targetSchema + "' ");
                        }
                        t_rs.close();
                        continue;
                    }
                    catch (SQLException ex) {
                        ++numFailures;
                        if (!AbstractLogger.isTrace) continue;
                        logger.trace("getSchemasImpl", "   Exception setCatalog:'" + targetCatalog + "' ");
                    }
                }
                if (AbstractLogger.isTrace) {
                    numSchemas = outSchemas.size();
                    logger.trace("getSchemasImpl", "Catalogs[" + numCatalogs + "] Schemas[" + numSchemas + "] Failures[" + numFailures + "] Nulls[" + numbNull + "] numWarning[" + numWarning + "] numNoMatch[" + numNoMatch + "]");
                }
            }
            catch (Exception exception) {
                SQLException outSE = FSDatabaseMetaData.createFunctionException("getSchemasImpl", exception, tStmtWrapper, logger);
                this.closeStmtWrapper(tStmtWrapper, "getSchemasImpl");
                throw outSE;
            }
            this.closeStmtWrapper(tStmtWrapper, "getSchemasImpl");
            if (otp) {
                try {
                    tConn.setCatalog(oldCatalog);
                }
                catch (Exception exception) {
                    if (AbstractLogger.isError) {
                        logger.trace("getSchemasImpl", "Exception:" + exception);
                    }
                    break block25;
                }
            }
            try {
                if (tConn != null) {
                    tConn.close();
                }
            }
            catch (Exception exception) {
                if (!AbstractLogger.isError) break block25;
                logger.trace("getSchemasImpl", "Exception:" + exception);
            }
        }
        if (AbstractLogger.isTrace) {
            FSDatabaseMetaData.logRowList("Schema:Catalog", outSchemas);
        }
        return outSchemas;
    }

    @Override
    public ResultSet getSchemas() throws SQLException {
        ResultSet resultSet = this.getSchemas(null, null);
        return resultSet;
    }

    @Override
    public ResultSet getSchemas(String catalog, String schemaPattern) throws SQLException {
        String method = "getSchemas";
        if (AbstractLogger.isInfo) {
            String ei = "FSDatabaseMetaData.getSchemas.fmt";
            this.logInfoMessage("getSchemas", "FSDatabaseMetaData.getSchemas.fmt", logger, catalog, schemaPattern);
        }
        this.checkIfConnectionClosed();
        FSResultSet resultSet = null;
        ArrayList<Row> schemaList = this.getSchemasImpl(catalog, schemaPattern, "getSchemas");
        IntHolder status = new IntHolder();
        try {
            resultSet = new FSResultSet(Constants.mdTypes.SCHEMAS, this);
            if (AbstractLogger.isTrace) {
                logger.trace("getSchemas", "Tables status:" + status.value + " rows:" + resultSet.getRowsInCache());
            }
        }
        catch (Exception exception) {
            FSDatabaseMetaData.timeOutError(exception, "'%s':'%s':'%s'", "getSchemas", catalog, schemaPattern);
            StatementWrapper tSW = this.tktsConnection.getCatalogWrapper();
            SQLException outSE = FSDatabaseMetaData.createFunctionException("getSchemas", exception, tSW, logger);
            this.closeStmtWrapper(tSW, "getSchemas");
            throw outSE;
        }
        resultSet.populateCache(schemaList);
        schemaList = null;
        this.addToFSResultSetList(resultSet);
        return resultSet;
    }

    @Override
    public String getSchemaTerm() throws SQLException {
        String method = "getSchemaTerm";
        this.checkIfConnectionClosed();
        if (this.schemaTerm == null) {
            Any result = this.getServerConnectionInformation(39, 0, "getSchemaTerm");
            this.schemaTerm = result.extract_string();
        }
        return this.schemaTerm;
    }

    @Override
    public String getSearchStringEscape() throws SQLException {
        return this.searchStringEscape;
    }

    @Override
    public String getSQLKeywords() throws SQLException {
        return this.sqlKeywords;
    }

    @Override
    public int getSQLStateType() throws SQLException {
        return 1;
    }

    @Override
    public String getStringFunctions() throws SQLException {
        return this.stringFunctions;
    }

    @Override
    public ResultSet getSuperTables(String catalog, String schemaPattern, String tableNamePattern) throws SQLException {
        String method = "getSuperTables";
        if (AbstractLogger.isInfo) {
            String ei = "FSDatabaseMetaData.getSuperTables.fmt";
            this.logInfoMessage("getSuperTables", "FSDatabaseMetaData.getSuperTables.fmt", logger, catalog, schemaPattern, tableNamePattern);
        }
        this.checkIfConnectionClosed();
        catalog = catalog == null ? CORBA_NULL : this.escapeAsteriskChar(catalog);
        schemaPattern = schemaPattern == null ? CORBA_NULL : this.escapeAsteriskChar(schemaPattern);
        if (tableNamePattern == null) {
            tableNamePattern = CORBA_NULL;
        }
        if (AbstractLogger.isTrace) {
            logger.entry("getSuperTables", "Cat=[" + catalog + "] schema=[" + schemaPattern + "] tableNamePattern=[" + tableNamePattern + "] ");
        }
        FSResultSet resultSet = new FSResultSet(Constants.mdTypes.SUPERTABLE_TYPE, this);
        this.addToFSResultSetList(resultSet);
        return resultSet;
    }

    @Override
    public ResultSet getSuperTypes(String catalog, String schemaPattern, String typeNamePattern) throws SQLException {
        String method = "getSuperTypes";
        if (AbstractLogger.isInfo) {
            String ei = "FSDatabaseMetaData.getSuperTypes.fmt";
            this.logInfoMessage("getSuperTypes", "FSDatabaseMetaData.getSuperTypes.fmt", logger, catalog, schemaPattern, typeNamePattern);
        }
        this.checkIfConnectionClosed();
        catalog = catalog == null ? CORBA_NULL : this.escapeAsteriskChar(catalog);
        schemaPattern = schemaPattern == null ? CORBA_NULL : this.escapeAsteriskChar(schemaPattern);
        typeNamePattern = typeNamePattern == null ? CORBA_NULL : this.escapeAsteriskChar(typeNamePattern);
        FSResultSet resultSet = new FSResultSet(Constants.mdTypes.SUPERTYPE_TYPE, this);
        this.addToFSResultSetList(resultSet);
        return resultSet;
    }

    @Override
    public String getSystemFunctions() throws SQLException {
        return this.systemFunctions;
    }

    @Override
    public ResultSet getTablePrivileges(String catalog, String schemaPattern, String tableNamePattern) throws SQLException {
        String method = "getTablePrivileges";
        IntHolder status = new IntHolder();
        FSResultSet resultSet = null;
        if (AbstractLogger.isInfo) {
            String ei = "FSDatabaseMetaData.getTablePrivileges.fmt";
            this.logInfoMessage("getTablePrivileges", "FSDatabaseMetaData.getTablePrivileges.fmt", logger, catalog, schemaPattern, tableNamePattern);
        }
        this.checkIfConnectionClosed();
        catalog = catalog == null ? CORBA_NULL : this.escapeAsteriskChar(catalog);
        schemaPattern = schemaPattern == null ? CORBA_NULL : this.escapeAsteriskChar(schemaPattern);
        if (tableNamePattern == null) {
            tableNamePattern = CORBA_NULL;
        }
        StatementWrapper tSW = this.tktsConnection.getCatalogWrapper();
        try {
            tSW.TablePrivileges(catalog, schemaPattern, tableNamePattern, status);
            resultSet = new FSResultSet(Constants.mdTypes.TABLEPRIVILEGES, tSW, this);
        }
        catch (Exception exception) {
            FSDatabaseMetaData.timeOutError(exception, "'%s':'%s':'%s':'%s'", "getTablePrivileges", catalog, schemaPattern, tableNamePattern);
            SQLException outSE = FSDatabaseMetaData.createFunctionException("getTablePrivileges", exception, tSW, logger);
            this.closeStmtWrapper(tSW, "getTablePrivileges");
            throw outSE;
        }
        this.addToFSResultSetList(resultSet);
        return resultSet;
    }

    @Override
    public ResultSet getTables(String catalog, String schemaPattern, String tableNamePattern, String[] types) throws SQLException {
        String method = "getTables";
        if (AbstractLogger.isInfo) {
            String ei = "FSDatabaseMetaData.getTables.fmt";
            this.logInfoMessage("getTables", "FSDatabaseMetaData.getTables.fmt", logger, catalog, schemaPattern, tableNamePattern, String.valueOf(types));
        }
        this.checkIfConnectionClosed();
        catalog = catalog == null ? CORBA_NULL : this.escapeAsteriskChar(catalog);
        schemaPattern = schemaPattern == null ? CORBA_NULL : this.escapeAsteriskChar(schemaPattern);
        tableNamePattern = tableNamePattern == null ? CORBA_NULL : this.escapeAsteriskChar(tableNamePattern);
        IntHolder status = new IntHolder();
        FSResultSet resultSet = null;
        String tableTypes = CORBA_NULL;
        if (types != null) {
            StringBuffer tbuff = new StringBuffer();
            for (int i = 0; i < types.length; ++i) {
                tbuff.append(types[i]);
                if (i + 1 >= types.length) continue;
                tbuff.append(", ");
            }
            tableTypes = tbuff.toString();
        }
        StatementWrapper tSW = this.tktsConnection.getCatalogWrapper();
        try {
            tSW.Tables(catalog, schemaPattern, tableNamePattern, tableTypes, status);
            resultSet = new FSResultSet(Constants.mdTypes.TABLES, tSW, this);
        }
        catch (Exception ex) {
            String outTypes = types == null ? "null" : tableTypes;
            FSDatabaseMetaData.timeOutError(ex, "'%s':'%s':'%s':'%s':'%s'", "getTables", catalog, schemaPattern, tableNamePattern, outTypes);
            SQLException outSE = FSDatabaseMetaData.createFunctionException("getTables", ex, tSW, logger);
            this.closeStmtWrapper(tSW, "getTables");
            throw outSE;
        }
        this.addToFSResultSetList(resultSet);
        return resultSet;
    }

    @Override
    public ResultSet getTableTypes() throws SQLException {
        String method = "getTableTypes";
        if (AbstractLogger.isInfo) {
            String ei = "FSDatabaseMetaData.getTableTypes.txt";
            this.logInfoMessage("getTableTypes", "FSDatabaseMetaData.getTableTypes.txt", logger, new Object[0]);
        }
        this.checkIfConnectionClosed();
        IntHolder status = new IntHolder();
        FSResultSet resultSet = null;
        StatementWrapper tSW = this.tktsConnection.getCatalogWrapper();
        try {
            tSW.Tables(SQL_EMPTY, SQL_EMPTY, SQL_EMPTY, SQL_WILD, status);
            resultSet = new FSResultSet(Constants.mdTypes.TABLETYPES, tSW, this);
        }
        catch (Exception exception) {
            SQLException outSE = FSDatabaseMetaData.createFunctionException("getTableTypes", exception, tSW, logger);
            this.closeStmtWrapper(tSW, "getTableTypes");
            throw outSE;
        }
        this.addToFSResultSetList(resultSet);
        return resultSet;
    }

    @Override
    public String getTimeDateFunctions() throws SQLException {
        return this.timedateFunctions;
    }

    @Override
    public ResultSet getTypeInfo() throws SQLException {
        String method = "getTypeInfo";
        IntHolder status = new IntHolder();
        FSResultSet resultSet = null;
        if (AbstractLogger.isInfo) {
            String ei = "FSDatabaseMetaData.getTypeInfo.txt";
            this.logInfoMessage("getTypeInfo", "FSDatabaseMetaData.getTypeInfo.txt", logger, new Object[0]);
        }
        this.checkIfConnectionClosed();
        StatementWrapper tSW = this.tktsConnection.getCatalogWrapper();
        try {
            tSW.GetTypeInformation(0, status);
            resultSet = new FSResultSet(Constants.mdTypes.TYPEINFO, tSW, this);
        }
        catch (Exception exception) {
            SQLException outSE = FSDatabaseMetaData.createFunctionException("getTypeInfo", exception, tSW, logger);
            this.closeStmtWrapper(tSW, "getTypeInfo");
            throw outSE;
        }
        this.addToFSResultSetList(resultSet);
        return resultSet;
    }

    @Override
    public ResultSet getUDTs(String catalog, String schemaPattern, String typeNamePattern, int[] types) throws SQLException {
        String method = "getUDTs";
        if (AbstractLogger.isInfo) {
            String ei = "FSDatabaseMetaData.getUDTs.fmt";
            this.logInfoMessage("getUDTs", "FSDatabaseMetaData.getUDTs.fmt", logger, catalog, schemaPattern, typeNamePattern, String.valueOf(types));
        }
        this.checkIfConnectionClosed();
        catalog = catalog == null ? CORBA_NULL : this.escapeAsteriskChar(catalog);
        schemaPattern = schemaPattern == null ? CORBA_NULL : this.escapeAsteriskChar(schemaPattern);
        typeNamePattern = typeNamePattern == null ? CORBA_NULL : this.escapeAsteriskChar(typeNamePattern);
        if (AbstractLogger.isTrace) {
            logger.exit("getUDTs", "Info: Not Supported - Always returns empty ResultSet!");
        }
        FSResultSet resultSet = new FSResultSet(Constants.mdTypes.UDT, this);
        this.addToFSResultSetList(resultSet);
        return resultSet;
    }

    @Override
    public String getURL() throws SQLException {
        this.checkIfConnectionClosed();
        return this.tktsConnection.getConnectionURL();
    }

    @Override
    public String getUserName() throws SQLException {
        this.checkIfConnectionClosed();
        if (this.userName == null || this.userName.equals(SQL_EMPTY)) {
            this.userName = this.tktsConnection.getUserName();
        }
        return this.userName;
    }

    @Override
    public ResultSet getVersionColumns(String catalog, String schema, String table) throws SQLException {
        String method = "getVersionColumns";
        IntHolder stat = new IntHolder();
        FSResultSet resultSet = null;
        this.checkIfConnectionClosed();
        catalog = catalog == null ? CORBA_NULL : this.escapeAsteriskChar(catalog);
        schema = schema == null ? CORBA_NULL : this.escapeAsteriskChar(schema);
        if (table == null) {
            String ei = "TKTSDatabaseMetaData.VersionColumns.fmt";
            this.throwException("TKTSDatabaseMetaData.VersionColumns.fmt", logger, "getVersionColumns");
        }
        int idType = 2;
        StatementWrapper tSW = this.tktsConnection.getCatalogWrapper();
        try {
            tSW.SpecialColumns(idType, catalog, schema, table, 1, 0, stat);
            resultSet = new FSResultSet(Constants.mdTypes.VERSIONCOLUMNS, tSW, this);
        }
        catch (Exception exception) {
            SQLException outSE = FSDatabaseMetaData.createFunctionException("getVersionColumns", exception, tSW, logger);
            this.closeStmtWrapper(tSW, "getVersionColumns");
            throw outSE;
        }
        this.addToFSResultSetList(resultSet);
        return resultSet;
    }

    @Override
    public boolean insertsAreDetected(int rSetType) throws SQLException {
        return this.isCursorOperationDetected(rSetType, 16L);
    }

    @Override
    public boolean isCatalogAtStart() throws SQLException {
        return this.catalogAtStart == 1;
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        return this.isReadOnly.equalsIgnoreCase("Y");
    }

    @Override
    public boolean locatorsUpdateCopy() throws SQLException {
        return false;
    }

    @Override
    public boolean nullPlusNonNullIsNull() throws SQLException {
        return this.nullPlusNonNullIsNull == 0;
    }

    @Override
    public boolean nullsAreSortedAtEnd() throws SQLException {
        return this.nullsAreSortedAtEnd == 4;
    }

    @Override
    public boolean nullsAreSortedAtStart() throws SQLException {
        return this.nullsAreSortedAtEnd == 2;
    }

    @Override
    public boolean nullsAreSortedHigh() throws SQLException {
        return this.nullsAreSortedAtEnd == 0;
    }

    @Override
    public boolean nullsAreSortedLow() throws SQLException {
        return this.nullsAreSortedAtEnd == 1;
    }

    @Override
    public boolean othersDeletesAreVisible(int rSetType) throws SQLException {
        return this.deletesAreDetected(rSetType);
    }

    @Override
    public boolean othersInsertsAreVisible(int rSetType) throws SQLException {
        return this.insertsAreDetected(rSetType);
    }

    @Override
    public boolean othersUpdatesAreVisible(int rSetType) throws SQLException {
        return this.updatesAreDetected(rSetType);
    }

    @Override
    public boolean ownDeletesAreVisible(int rSetType) throws SQLException {
        return this.deletesAreDetected(rSetType);
    }

    @Override
    public boolean ownInsertsAreVisible(int rSetType) throws SQLException {
        return this.insertsAreDetected(rSetType);
    }

    @Override
    public boolean ownUpdatesAreVisible(int rSetType) throws SQLException {
        return this.updatesAreDetected(rSetType);
    }

    @Override
    public boolean storesLowerCaseIdentifiers() throws SQLException {
        return this.storesCaseIdentifier == 2;
    }

    @Override
    public boolean storesLowerCaseQuotedIdentifiers() throws SQLException {
        return this.storesQuotedCaseIdentifier == 2;
    }

    @Override
    public boolean storesMixedCaseIdentifiers() throws SQLException {
        return this.storesCaseIdentifier == 4;
    }

    @Override
    public boolean storesMixedCaseQuotedIdentifiers() throws SQLException {
        return this.storesQuotedCaseIdentifier == 4;
    }

    @Override
    public boolean storesUpperCaseIdentifiers() throws SQLException {
        return this.storesCaseIdentifier == 1;
    }

    @Override
    public boolean storesUpperCaseQuotedIdentifiers() throws SQLException {
        return this.storesQuotedCaseIdentifier == 1;
    }

    @Override
    public boolean supportsAlterTableWithAddColumn() throws SQLException {
        return (this.supportsAlterTable & 0x80) == 128 || (this.supportsAlterTable & 0x40) == 64 || (this.supportsAlterTable & 0x20) == 32 || (this.supportsAlterTable & 8) == 8;
    }

    @Override
    public boolean supportsAlterTableWithDropColumn() throws SQLException {
        return (this.supportsAlterTable & 0x400) == 1024 || (this.supportsAlterTable & 0x200) == 512 || (this.supportsAlterTable & 0x800) == 2048;
    }

    @Override
    public boolean supportsANSI92EntryLevelSQL() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsANSI92FullSQL() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsANSI92IntermediateSQL() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsBatchUpdates() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsCatalogsInDataManipulation() throws SQLException {
        return (this.catalogUsage & 1) == 1;
    }

    @Override
    public boolean supportsCatalogsInIndexDefinitions() throws SQLException {
        return (this.catalogUsage & 8) == 8;
    }

    @Override
    public boolean supportsCatalogsInPrivilegeDefinitions() throws SQLException {
        return (this.catalogUsage & 0x10) == 16;
    }

    @Override
    public boolean supportsCatalogsInProcedureCalls() throws SQLException {
        return (this.catalogUsage & 2) == 2;
    }

    @Override
    public boolean supportsCatalogsInTableDefinitions() throws SQLException {
        return (this.catalogUsage & 4) == 4;
    }

    @Override
    public boolean supportsColumnAliasing() throws SQLException {
        return this.supportsColumnAliasing.equalsIgnoreCase("Y");
    }

    @Override
    public boolean supportsConvert() throws SQLException {
        return ((long)this.supportsConvert & 1L) > 0L;
    }

    @Override
    public boolean supportsConvert(int fromType, int toType) throws SQLException {
        String method = "supportsConvert";
        this.checkIfConnectionClosed();
        int fromAttr = 0;
        switch (fromType) {
            case 3: {
                fromAttr = 58;
                break;
            }
            case 8: {
                fromAttr = 59;
                break;
            }
            case 6: {
                fromAttr = 60;
                break;
            }
            case 7: {
                fromAttr = 64;
                break;
            }
            case 93: {
                fromAttr = 67;
                break;
            }
            case -5: {
                fromAttr = 53;
                break;
            }
            case -2: {
                fromAttr = 54;
                break;
            }
            case -7: {
                fromAttr = 55;
                break;
            }
            case 1: {
                fromAttr = 56;
                break;
            }
            case 91: {
                fromAttr = 57;
                break;
            }
            case 4: {
                fromAttr = 61;
                break;
            }
            case -4: {
                fromAttr = 71;
                break;
            }
            case -1: {
                fromAttr = 62;
                break;
            }
            case 5: {
                fromAttr = 65;
                break;
            }
            case 92: {
                fromAttr = 66;
                break;
            }
            case -6: {
                fromAttr = 68;
                break;
            }
            case -3: {
                fromAttr = 69;
                break;
            }
            case 12: {
                fromAttr = 70;
                break;
            }
            case 2: {
                fromAttr = 63;
                break;
            }
            default: {
                return false;
            }
        }
        Any result = this.getServerConnectionInformation(fromAttr, -5, "supportsConvert");
        int value = result.extract_long();
        long mask = 0L;
        switch (toType) {
            case -5: {
                mask = (long)value & 0x4000L;
                break;
            }
            case -2: {
                mask = (long)value & 0x400L;
                break;
            }
            case -7: {
                mask = (long)value & 0x1000L;
                break;
            }
            case 1: {
                mask = (long)value & 1L;
                break;
            }
            case 91: {
                mask = (long)value & 0x8000L;
                break;
            }
            case 3: {
                mask = (long)value & 4L;
                break;
            }
            case 8: {
                mask = (long)value & 0x80L;
                break;
            }
            case 6: {
                mask = (long)value & 0x20L;
                break;
            }
            case 4: {
                mask = (long)value & 8L;
                break;
            }
            case -4: {
                mask = (long)value & 0x40000L;
                break;
            }
            case -1: {
                mask = (long)value & 0x200L;
                break;
            }
            case 2: {
                mask = (long)value & 2L;
                break;
            }
            case 7: {
                mask = (long)value & 0x40L;
                break;
            }
            case 5: {
                mask = (long)value & 0x10L;
                break;
            }
            case 92: {
                mask = (long)value & 0x10000L;
                break;
            }
            case 93: {
                mask = (long)value & 0x20000L;
                break;
            }
            case -6: {
                mask = (long)value & 0x2000L;
                break;
            }
            case -3: {
                mask = (long)value & 0x800L;
                break;
            }
            case 12: {
                mask = (long)value & 0x100L;
                break;
            }
            default: {
                return false;
            }
        }
        return mask > 0L;
    }

    @Override
    public boolean supportsCoreSQLGrammar() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsCorrelatedSubqueries() throws SQLException {
        return ((long)this.supportsCorrelatedSubqueries & 0x10L) > 0L;
    }

    @Override
    public boolean supportsDataDefinitionAndDataManipulationTransactions() throws SQLException {
        return this.supportsDataDefinitionAndDataManipulationTransactions == 2;
    }

    @Override
    public boolean supportsDataManipulationTransactionsOnly() throws SQLException {
        return this.supportsDataDefinitionAndDataManipulationTransactions == 1;
    }

    @Override
    public boolean supportsDifferentTableCorrelationNames() throws SQLException {
        return (this.supportsDifferentTableCorrelationNames & 1) > 0;
    }

    @Override
    public boolean supportsExpressionsInOrderBy() throws SQLException {
        return this.supportsExpressionsInOrderBy.equalsIgnoreCase("Y");
    }

    @Override
    public boolean supportsExtendedSQLGrammar() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsFullOuterJoins() throws SQLException {
        return ((long)this.supportsFullOuterJoins & 4L) > 0L;
    }

    @Override
    public boolean supportsGetGeneratedKeys() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsGroupBy() throws SQLException {
        return this.supportsGroupBy != 0;
    }

    @Override
    public boolean supportsGroupByBeyondSelect() throws SQLException {
        return this.supportsGroupBy == 2;
    }

    @Override
    public boolean supportsGroupByUnrelated() throws SQLException {
        return this.supportsGroupBy == 3;
    }

    @Override
    public boolean supportsIntegrityEnhancementFacility() throws SQLException {
        return this.supportsIntegrityEnhancementFacility.equalsIgnoreCase("Y");
    }

    @Override
    public boolean supportsLikeEscapeClause() throws SQLException {
        return this.supportsLikeEscapeClause.equalsIgnoreCase("Y");
    }

    @Override
    public boolean supportsLimitedOuterJoins() throws SQLException {
        return ((long)this.supportsFullOuterJoins & 0x7FL) > 0L;
    }

    @Override
    public boolean supportsMinimumSQLGrammar() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsMixedCaseIdentifiers() throws SQLException {
        return this.storesCaseIdentifier == 3;
    }

    @Override
    public boolean supportsMixedCaseQuotedIdentifiers() throws SQLException {
        return this.storesQuotedCaseIdentifier == 3;
    }

    @Override
    public boolean supportsMultipleOpenResults() throws SQLException {
        return this.supportsMultipleResultSets();
    }

    @Override
    public boolean supportsMultipleResultSets() throws SQLException {
        return this.supportsMultipleResultSets.equalsIgnoreCase("Y");
    }

    @Override
    public boolean supportsMultipleTransactions() throws SQLException {
        return this.supportsMultipleTransactions.equalsIgnoreCase("Y");
    }

    @Override
    public boolean supportsNamedParameters() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsNonNullableColumns() throws SQLException {
        return this.supportsNonNullableColumns == 1;
    }

    @Override
    public boolean supportsOpenCursorsAcrossCommit() throws SQLException {
        return this.resultSetHoldability == 2;
    }

    @Override
    public boolean supportsOpenCursorsAcrossRollback() throws SQLException {
        return this.supportsOpenCursorsAcrossRollback == 2;
    }

    @Override
    public boolean supportsOpenStatementsAcrossCommit() throws SQLException {
        return this.resultSetHoldability != 0;
    }

    @Override
    public boolean supportsOpenStatementsAcrossRollback() throws SQLException {
        return this.supportsOpenCursorsAcrossRollback != 0;
    }

    @Override
    public boolean supportsOrderByUnrelated() throws SQLException {
        return ((this.supportsOrderByUnrelated & 1) > 0 || (this.supportsOrderByUnrelated & 2) > 0) && (this.supportsOrderByUnrelated & 4) == 0;
    }

    @Override
    public boolean supportsOuterJoins() throws SQLException {
        return ((long)this.supportsFullOuterJoins & 0x7FL) > 0L;
    }

    @Override
    public boolean supportsPositionedDelete() throws SQLException {
        return ((long)this.supportsPositionedDelete & 0x4000L) > 0L;
    }

    @Override
    public boolean supportsPositionedUpdate() throws SQLException {
        return ((long)this.supportsPositionedDelete & 0x2000L) > 0L;
    }

    @Override
    public boolean supportsResultSetConcurrency(int rSetType, int concurrency) throws SQLException {
        return this.getSupportedConcurrency(rSetType, concurrency) > 0;
    }

    @Override
    public boolean supportsResultSetHoldability(int holdability) throws SQLException {
        int tServerSideResultSetHoldability = this.serverSideResultSetHoldability;
        if (tServerSideResultSetHoldability == 2) {
            tServerSideResultSetHoldability = 1;
        } else if (holdability == 1 || holdability == 0) {
            tServerSideResultSetHoldability = 2;
        }
        return holdability == tServerSideResultSetHoldability;
    }

    @Override
    public boolean supportsResultSetType(int type) throws SQLException {
        if (type == 1003) {
            return (this.supportsResultSetType & 1) > 0;
        }
        if (type == 1004) {
            return (this.supportsResultSetType & 0x10) > 0;
        }
        if (type == 1005) {
            return (this.supportsResultSetType & 4) > 0 || (this.supportsResultSetType & 8) > 0 || (this.supportsResultSetType & 2) > 0;
        }
        return false;
    }

    @Override
    public boolean supportsSavepoints() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsSchemasInDataManipulation() throws SQLException {
        return (this.supportsSchemasInDataManipulation & 1) > 0;
    }

    @Override
    public boolean supportsSchemasInIndexDefinitions() throws SQLException {
        return (this.supportsSchemasInDataManipulation & 8) > 0;
    }

    @Override
    public boolean supportsSchemasInPrivilegeDefinitions() throws SQLException {
        return (this.supportsSchemasInDataManipulation & 0x10) > 0;
    }

    @Override
    public boolean supportsSchemasInProcedureCalls() throws SQLException {
        return (this.supportsSchemasInDataManipulation & 2) > 0;
    }

    @Override
    public boolean supportsSchemasInTableDefinitions() throws SQLException {
        return (this.supportsSchemasInDataManipulation & 4) > 0;
    }

    @Override
    public boolean supportsSelectForUpdate() throws SQLException {
        return this.supportsSelectForUpdate;
    }

    @Override
    public boolean supportsStatementPooling() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsStoredProcedures() throws SQLException {
        return this.supportsStoredProcs.equals("Y");
    }

    @Override
    public boolean supportsSubqueriesInComparisons() throws SQLException {
        return ((long)this.supportsCorrelatedSubqueries & 1L) > 0L;
    }

    @Override
    public boolean supportsSubqueriesInExists() throws SQLException {
        return ((long)this.supportsCorrelatedSubqueries & 2L) > 0L;
    }

    @Override
    public boolean supportsSubqueriesInIns() throws SQLException {
        return ((long)this.supportsCorrelatedSubqueries & 4L) > 0L;
    }

    @Override
    public boolean supportsSubqueriesInQuantifieds() throws SQLException {
        return ((long)this.supportsCorrelatedSubqueries & 8L) > 0L;
    }

    @Override
    public boolean supportsTableCorrelationNames() throws SQLException {
        return (this.supportsDifferentTableCorrelationNames & 3) > 0;
    }

    @Override
    public boolean supportsTransactionIsolationLevel(int level) throws SQLException {
        switch (level) {
            case 1: {
                return (this.supportsTransactionIsolationLevel & 1) > 0;
            }
            case 2: {
                return (this.supportsTransactionIsolationLevel & 2) > 0;
            }
            case 4: {
                return (this.supportsTransactionIsolationLevel & 4) > 0;
            }
            case 8: {
                return (this.supportsTransactionIsolationLevel & 8) > 0;
            }
            case 0: {
                return !this.supportsTransactions();
            }
        }
        return false;
    }

    @Override
    public boolean supportsTransactions() throws SQLException {
        return this.supportsDataDefinitionAndDataManipulationTransactions != 0;
    }

    @Override
    public boolean supportsUnion() throws SQLException {
        return ((long)this.supportsUnion & 1L) > 0L;
    }

    @Override
    public boolean supportsUnionAll() throws SQLException {
        return ((long)this.supportsUnion & 2L) > 0L;
    }

    @Override
    public boolean updatesAreDetected(int rSetType) throws SQLException {
        return this.isCursorOperationDetected(rSetType, 64L);
    }

    @Override
    public boolean usesLocalFilePerTable() throws SQLException {
        return this.usesLocalFilePerTable == 1;
    }

    @Override
    public boolean usesLocalFiles() throws SQLException {
        return this.usesLocalFilePerTable != 0;
    }

    protected int getSupportedConcurrency(int rSetType, int concurrency) throws SQLException {
        String method = "getSupportedConcurrency";
        int concLevel = -99;
        int iVal = this.cursorAttributesGroupByRSetType[1][rSetType - 1003];
        switch (concurrency) {
            case 1008: {
                if ((iVal & 2) > 0) {
                    concLevel = 2;
                    break;
                }
                if ((iVal & 4) > 0) {
                    concLevel = 4;
                    break;
                }
                if ((iVal & 8) <= 0) break;
                concLevel = 8;
                break;
            }
            case 1007: {
                if ((iVal & 1) <= 0) break;
                concLevel = 1;
                break;
            }
            default: {
                String ei = "TKTSDatabaseMetaData.invalidConcurrency.fmt";
                this.throwException("TKTSDatabaseMetaData.invalidConcurrency.fmt", null, this.tktsConnection.connectionWrapper, logger, "getSupportedConcurrency");
            }
        }
        if (AbstractLogger.isTrace) {
            String rsc = TypesHelper.getResultSetConcurrencyB(concurrency);
            logger.trace("getSupportedConcurrency", "Result Set Type=[" + TypesHelper.getResultSetTypeU(rSetType) + "] Concurrency requested[" + rsc + "] concLevel[" + concLevel + "]");
        }
        return concLevel;
    }

    private Any getServerConnectionInformation(int attribute, int indicator, String method) throws SQLException {
        this.checkIfConnectionClosed();
        return AbstractIOMWrapper.getServerConnectionInformation(this.tktsConnection.connectionWrapper, attribute, indicator, method);
    }

    private void loadCursorAttributes() throws SQLException {
        int rSetType;
        int attGroup;
        String method = "loadCursorAttributes";
        Any result = null;
        this.cursorAttributesGroupByRSetType = new int[3][4];
        for (attGroup = 0; attGroup < 3; ++attGroup) {
            for (rSetType = 0; rSetType < 4; ++rSetType) {
                this.cursorAttributesGroupByRSetType[attGroup][rSetType] = -1;
            }
        }
        try {
            result = this.getServerConnectionInformation(146, -5, "loadCursorAttributes");
            this.cursorAttributesGroupByRSetType[0][0] = result.extract_long();
            result = this.getServerConnectionInformation(147, -5, "loadCursorAttributes");
            this.cursorAttributesGroupByRSetType[1][0] = result.extract_long();
            result = this.getServerConnectionInformation(20002, -5, "loadCursorAttributes");
            this.cursorAttributesGroupByRSetType[2][0] = result.extract_long();
            result = this.getServerConnectionInformation(167, -5, "loadCursorAttributes");
            this.cursorAttributesGroupByRSetType[0][1] = result.extract_long();
            result = this.getServerConnectionInformation(168, -5, "loadCursorAttributes");
            this.cursorAttributesGroupByRSetType[1][1] = result.extract_long();
            result = this.getServerConnectionInformation(20004, -5, "loadCursorAttributes");
            this.cursorAttributesGroupByRSetType[2][1] = result.extract_long();
            result = this.getServerConnectionInformation(144, -5, "loadCursorAttributes");
            this.cursorAttributesGroupByRSetType[0][2] = result.extract_long();
            result = this.getServerConnectionInformation(145, -5, "loadCursorAttributes");
            this.cursorAttributesGroupByRSetType[1][2] = result.extract_long();
            result = this.getServerConnectionInformation(20001, -5, "loadCursorAttributes");
            this.cursorAttributesGroupByRSetType[2][2] = result.extract_long();
            result = this.getServerConnectionInformation(150, -5, "loadCursorAttributes");
            this.cursorAttributesGroupByRSetType[0][3] = result.extract_long();
            result = this.getServerConnectionInformation(151, -5, "loadCursorAttributes");
            this.cursorAttributesGroupByRSetType[1][3] = result.extract_long();
            result = this.getServerConnectionInformation(20003, -5, "loadCursorAttributes");
            this.cursorAttributesGroupByRSetType[2][3] = result.extract_long();
        }
        catch (SQLException e) {
            SQLException outSE = FSDatabaseMetaData.createFunctionException("loadCursorAttributes", e, this.tktsConnection.connectionWrapper, logger);
            throw outSE;
        }
        if (AbstractLogger.isTrace) {
            for (attGroup = 0; attGroup < 3; ++attGroup) {
                for (rSetType = 0; rSetType < 4; ++rSetType) {
                    logger.trace("loadCursorAttributes", "cursorAttributesGroupByRSetType[" + attGroup + "][" + rSetType + "]=" + this.cursorAttributesGroupByRSetType[attGroup][rSetType]);
                }
            }
        }
    }

    private boolean isCursorOperationDetected(int rSetType, long operation) throws SQLException {
        String method = "isCursorOperationDetected";
        boolean result = false;
        if (rSetType < 1003 || rSetType > 1005) {
            String ei = "TKTSDatabaseMetaData.invalidCursorType.fmt";
            this.throwException("TKTSDatabaseMetaData.invalidCursorType.fmt", logger, "isCursorOperationDetected");
        } else {
            boolean bl = result = ((long)this.cursorAttributesGroupByRSetType[1][rSetType - 1003] & operation) > 0L;
            if (rSetType == 1005) {
                result = result || ((long)this.cursorAttributesGroupByRSetType[1][3] & operation) > 0L;
            }
        }
        return result;
    }

    @Override
    public ResultSet getFunctionColumns(String catalog, String schemaPattern, String functionNamePattern, String columnNamePattern) throws SQLException {
        String method = "getFunctionColumns";
        if (AbstractLogger.isInfo) {
            String ei = "FSDatabaseMetaData.getFunctionColumns.fmt";
            this.logInfoMessage("getFunctionColumns", "FSDatabaseMetaData.getFunctionColumns.fmt", logger, catalog, schemaPattern, functionNamePattern, columnNamePattern);
        }
        this.checkIfConnectionClosed();
        if (AbstractLogger.isTrace) {
            logger.exit("getFunctionColumns", "getFunctionColumns: Not Supported - Always returns empty ResultSet!");
        }
        FSResultSet resultSet = new FSResultSet(Constants.mdTypes.FUNCTIONCOLUMNS, this);
        this.addToFSResultSetList(resultSet);
        return resultSet;
    }

    @Override
    public RowIdLifetime getRowIdLifetime() throws SQLException {
        return RowIdLifetime.ROWID_UNSUPPORTED;
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        return null;
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return false;
    }

    @Override
    public boolean supportsStoredFunctionsUsingCallSyntax() throws SQLException {
        return false;
    }

    private void initNumericFunctions() throws SQLException {
        String method = "initNumericFunctions";
        StringBuffer functions = new StringBuffer();
        long functionMask = 0L;
        Any result = this.getServerConnectionInformation(49, -5, "initNumericFunctions");
        int fm = result.extract_long();
        functionMask = fm < 0 ? result.extract_longlong() : (long)fm;
        String[] sarray = new String[24];
        if ((functionMask & 1L) > 0L) {
            sarray[0] = "ABS";
        }
        if ((functionMask & 2L) > 0L) {
            sarray[1] = "ACOS";
        }
        if ((functionMask & 4L) > 0L) {
            sarray[2] = "ASIN";
        }
        if ((functionMask & 8L) > 0L) {
            sarray[3] = "ATAN";
        }
        if ((functionMask & 0x10L) > 0L) {
            sarray[4] = "ATAN2";
        }
        if ((functionMask & 0x20L) > 0L) {
            sarray[5] = "CEILING";
        }
        if ((functionMask & 0x40L) > 0L) {
            sarray[6] = "COS";
        }
        if ((functionMask & 0x80L) > 0L) {
            sarray[7] = "COT";
        }
        if ((functionMask & 0x100L) > 0L) {
            sarray[8] = "EXP";
        }
        if ((functionMask & 0x200L) > 0L) {
            sarray[9] = "FLOOR";
        }
        if ((functionMask & 0x400L) > 0L) {
            sarray[10] = "LOG";
        }
        if ((functionMask & 0x800L) > 0L) {
            sarray[11] = "MOD";
        }
        if ((functionMask & 0x1000L) > 0L) {
            sarray[12] = "SIGN";
        }
        if ((functionMask & 0x2000L) > 0L) {
            sarray[13] = "SIN";
        }
        if ((functionMask & 0x4000L) > 0L) {
            sarray[14] = "SQRT";
        }
        if ((functionMask & 0x8000L) > 0L) {
            sarray[15] = "TAN";
        }
        if ((functionMask & 0x10000L) > 0L) {
            sarray[16] = "PI";
        }
        if ((functionMask & 0x20000L) > 0L) {
            sarray[17] = "RAND";
        }
        if ((functionMask & 0x40000L) > 0L) {
            sarray[18] = "DEGREES";
        }
        if ((functionMask & 0x80000L) > 0L) {
            sarray[19] = "LOG10";
        }
        if ((functionMask & 0x100000L) > 0L) {
            sarray[20] = "POWER";
        }
        if ((functionMask & 0x200000L) > 0L) {
            sarray[21] = "RADIANS";
        }
        if ((functionMask & 0x400000L) > 0L) {
            sarray[22] = "ROUND";
        }
        if ((functionMask & 0x800000L) > 0L) {
            sarray[23] = "TRUNCATE";
        }
        boolean needSeperator = false;
        for (int i = 0; i < 24; ++i) {
            if (sarray[i] == null) continue;
            if (needSeperator) {
                functions.append(", ");
            } else {
                needSeperator = true;
            }
            functions.append(sarray[i]);
        }
        this.numericFunctions = functions.toString();
    }

    private void initStringFunctions() throws SQLException {
        String method = "initStringFunctions";
        StringBuffer functions = new StringBuffer();
        long functionMask = 0L;
        Any result = this.getServerConnectionInformation(50, -5, "initStringFunctions");
        int fm = result.extract_long();
        functionMask = fm < 0 ? result.extract_longlong() : (long)fm;
        String[] sarray = new String[24];
        if ((functionMask & 1L) > 0L) {
            sarray[0] = "CONCAT";
        }
        if ((functionMask & 2L) > 0L) {
            sarray[1] = "INSERT";
        }
        if ((functionMask & 4L) > 0L) {
            sarray[2] = "LEFT";
        }
        if ((functionMask & 8L) > 0L) {
            sarray[3] = "LTRIM";
        }
        if ((functionMask & 0x10L) > 0L) {
            sarray[4] = "LENGTH";
        }
        if ((functionMask & 0x20L) > 0L) {
            sarray[5] = "LOCATE";
        }
        if ((functionMask & 0x40L) > 0L) {
            sarray[6] = "LCASE";
        }
        if ((functionMask & 0x80L) > 0L) {
            sarray[7] = "REPEAT";
        }
        if ((functionMask & 0x100L) > 0L) {
            sarray[8] = "REPLACE";
        }
        if ((functionMask & 0x200L) > 0L) {
            sarray[9] = "RIGHT";
        }
        if ((functionMask & 0x400L) > 0L) {
            sarray[10] = "RTRIM";
        }
        if ((functionMask & 0x800L) > 0L) {
            sarray[11] = "SUBSTRING";
        }
        if ((functionMask & 0x1000L) > 0L) {
            sarray[12] = "UCASE";
        }
        if ((functionMask & 0x2000L) > 0L) {
            sarray[13] = "ASCII";
        }
        if ((functionMask & 0x4000L) > 0L) {
            sarray[14] = "CHAR";
        }
        if ((functionMask & 0x8000L) > 0L) {
            sarray[15] = "DIFFERENCE";
        }
        if ((functionMask & 0x10000L) > 0L) {
            sarray[16] = "LOCATE_2";
        }
        if ((functionMask & 0x20000L) > 0L) {
            sarray[17] = "SOUNDEX";
        }
        if ((functionMask & 0x40000L) > 0L) {
            sarray[18] = "SPACE";
        }
        if ((functionMask & 0x80000L) > 0L) {
            sarray[19] = "BIT_LENGTH";
        }
        if ((functionMask & 0x100000L) > 0L) {
            sarray[20] = "CHAR_LENGTH";
        }
        if ((functionMask & 0x200000L) > 0L) {
            sarray[21] = "CHARACTER_LENGTH";
        }
        if ((functionMask & 0x400000L) > 0L) {
            sarray[22] = "OCTET_LENGTH";
        }
        if ((functionMask & 0x800000L) > 0L) {
            sarray[23] = "POSITION";
        }
        boolean needSeperator = false;
        for (int i = 0; i < 24; ++i) {
            if (sarray[i] == null) continue;
            if (needSeperator) {
                functions.append(", ");
            } else {
                needSeperator = true;
            }
            functions.append(sarray[i]);
        }
        this.stringFunctions = functions.toString();
    }

    private void initSystemFunctions() throws SQLException {
        String method = "inittSystemFunctions";
        StringBuffer functions = new StringBuffer();
        long functionMask = 0L;
        Any result = this.getServerConnectionInformation(51, -5, "inittSystemFunctions");
        int fm = result.extract_long();
        functionMask = fm < 0 ? result.extract_longlong() : (long)fm;
        String[] sarray = new String[3];
        if ((functionMask & 1L) > 0L) {
            sarray[0] = "USERNAME";
        }
        if ((functionMask & 2L) > 0L) {
            sarray[1] = "DBNAME";
        }
        if ((functionMask & 4L) > 0L) {
            sarray[2] = "IFNULL";
        }
        boolean needSeperator = false;
        for (int i = 0; i < 3; ++i) {
            if (sarray[i] == null) continue;
            if (needSeperator) {
                functions.append(", ");
            } else {
                needSeperator = true;
            }
            functions.append(sarray[i]);
        }
        this.systemFunctions = functions.toString();
    }

    private String initTimeDateFunctions() throws SQLException {
        String method = "getTimeDateFunctions";
        StringBuffer functions = new StringBuffer();
        long functionMask = 0L;
        Any result = this.getServerConnectionInformation(52, -5, "getTimeDateFunctions");
        int fm = result.extract_long();
        functionMask = fm < 0 ? result.extract_longlong() : (long)fm;
        String[] sarray = new String[21];
        if ((functionMask & 1L) > 0L) {
            sarray[0] = "NOW";
        }
        if ((functionMask & 2L) > 0L) {
            sarray[1] = "CURDATE";
        }
        if ((functionMask & 4L) > 0L) {
            sarray[2] = "DAYOFMONTH";
        }
        if ((functionMask & 8L) > 0L) {
            sarray[3] = "DAYOFWEEK";
        }
        if ((functionMask & 0x10L) > 0L) {
            sarray[4] = "DAYOFYEAR";
        }
        if ((functionMask & 0x20L) > 0L) {
            sarray[5] = "MONTH";
        }
        if ((functionMask & 0x40L) > 0L) {
            sarray[6] = "QUARTER";
        }
        if ((functionMask & 0x80L) > 0L) {
            sarray[7] = "WEEK";
        }
        if ((functionMask & 0x100L) > 0L) {
            sarray[8] = "YEAR";
        }
        if ((functionMask & 0x200L) > 0L) {
            sarray[9] = "CURTIME";
        }
        if ((functionMask & 0x400L) > 0L) {
            sarray[10] = "HOUR";
        }
        if ((functionMask & 0x800L) > 0L) {
            sarray[11] = "MINUTE";
        }
        if ((functionMask & 0x1000L) > 0L) {
            sarray[12] = "SECOND";
        }
        if ((functionMask & 0x2000L) > 0L) {
            sarray[13] = "TIMESTAMPADD";
        }
        if ((functionMask & 0x4000L) > 0L) {
            sarray[14] = "TIMESTAMPDIFF";
        }
        if ((functionMask & 0x8000L) > 0L) {
            sarray[15] = "DAYNAME";
        }
        if ((functionMask & 0x10000L) > 0L) {
            sarray[16] = "MONTHNAME";
        }
        if ((functionMask & 0x20000L) > 0L) {
            sarray[17] = "CURRENT_DATE";
        }
        if ((functionMask & 0x40000L) > 0L) {
            sarray[18] = "CURRENT_TIME";
        }
        if ((functionMask & 0x80000L) > 0L) {
            sarray[19] = "CURRENT_TIMESTAMP";
        }
        if ((functionMask & 0x100000L) > 0L) {
            sarray[20] = "EXTRACT";
        }
        boolean needSeperator = false;
        for (int i = 0; i < 21; ++i) {
            if (sarray[i] == null) continue;
            if (needSeperator) {
                functions.append(", ");
            } else {
                needSeperator = true;
            }
            functions.append(sarray[i]);
        }
        this.timedateFunctions = functions.toString();
        return this.timedateFunctions;
    }

    private void initSupportsSelectForUpdate() throws SQLException {
        String method = "supportsSelectForUpdate";
        int[] infoTypes = new int[4];
        int[] indicator = new int[4];
        infoTypes[0] = 144;
        indicator[0] = -5;
        infoTypes[1] = 167;
        indicator[1] = -5;
        infoTypes[2] = 146;
        indicator[2] = -5;
        infoTypes[3] = 150;
        indicator[3] = -5;
        this.checkIfConnectionClosed();
        AnySeqHolder values = new AnySeqHolder();
        LongSeqHolder status = new LongSeqHolder();
        try {
            this.tktsConnection.connectionWrapper.GetInformation(infoTypes, indicator, values, status);
        }
        catch (Exception exception) {
            FSDatabaseMetaData.throwFunctionException("supportsSelectForUpdate", exception, null, logger);
        }
        long dynaAttr = values.value[0].extract_long();
        long statAttr = values.value[1].extract_long();
        long fwrdAttr = values.value[2].extract_long();
        long keysAttr = values.value[2].extract_long();
        this.supportsSelectForUpdate = (dynaAttr & 0x8000L) > 0L || (statAttr & 0x8000L) > 0L || (fwrdAttr & 0x8000L) > 0L || (keysAttr & 0x8000L) > 0L;
    }

    public void initializeAllValues() throws SQLException {
        String method = "initializeValues";
        this.driverName = LocalizedErrorHandler.getString("TKTSDatabaseMetaData.driverName.txt");
        String packageName = this.getClass().getPackage().getName();
        Package myPackage = Package.getPackage(packageName);
        String driverBuildVersion = myPackage.getImplementationVersion();
        this.driverVersion = driverBuildVersion == null ? JDBC_DRIVER_MAJOR_VERSION + "." + JDBC_DRIVER_MINOR_VERSION : JDBC_DRIVER_MAJOR_VERSION + "." + JDBC_DRIVER_MINOR_VERSION + "." + driverBuildVersion;
        Any result = this.getServerConnectionInformation(20, 0, "initializeValues");
        this.allProceduresAreCallable = result.extract_string();
        result = this.getServerConnectionInformation(19, 0, "initializeValues");
        this.allTablesAreSelectable = result.extract_string();
        result = this.getServerConnectionInformation(86, -5, "initializeValues");
        this.supportsAlterTable = result.extract_long();
        result = this.getServerConnectionInformation(121, -5, "initializeValues");
        result = this.getServerConnectionInformation(41, 0, "initializeValues");
        this.catalogSeparator = result.extract_string();
        result = this.getServerConnectionInformation(42, 0, "initializeValues");
        this.catalogTerm = result.extract_string();
        result = this.getServerConnectionInformation(114, -5, "initializeValues");
        this.catalogAtStart = result.extract_long();
        result = this.getServerConnectionInformation(92, -5, "initializeValues");
        this.catalogUsage = result.extract_long();
        result = this.getServerConnectionInformation(87, 0, "initializeValues");
        this.supportsColumnAliasing = result.extract_string();
        result = this.getServerConnectionInformation(22, -5, "initializeValues");
        this.nullPlusNonNullIsNull = result.extract_long();
        result = this.getServerConnectionInformation(48, -5, "initializeValues");
        this.supportsConvert = result.extract_long();
        result = this.getServerConnectionInformation(74, -5, "initializeValues");
        this.supportsDifferentTableCorrelationNames = result.extract_long();
        result = this.getServerConnectionInformation(23, -5, "initializeValues");
        this.resultSetHoldability = result.extract_long();
        this.serverSideResultSetHoldability = result.extract_long();
        result = this.getServerConnectionInformation(24, -5, "initializeValues");
        this.supportsOpenCursorsAcrossRollback = result.extract_long();
        result = this.getServerConnectionInformation(25, 0, "initializeValues");
        this.isReadOnly = result.extract_string();
        result = this.getServerConnectionInformation(17, 0, "initializeValues");
        this.databaseProductName = result.extract_string();
        result = this.getServerConnectionInformation(18, 0, "initializeValues");
        this.databaseProductVersion = result.extract_string();
        this.getDatabaseProductVersionInit();
        result = this.getServerConnectionInformation(26, -5, "initializeValues");
        this.defaultTransactionIsolation = result.extract_long();
        result = this.getServerConnectionInformation(27, 0, "initializeValues");
        this.supportsExpressionsInOrderBy = result.extract_string();
        result = this.getServerConnectionInformation(84, -5, "initializeValues");
        this.usesLocalFilePerTable = result.extract_long();
        result = this.getServerConnectionInformation(88, -5, "initializeValues");
        this.supportsGroupBy = result.extract_long();
        result = this.getServerConnectionInformation(28, -5, "initializeValues");
        this.storesCaseIdentifier = result.extract_long();
        result = this.getServerConnectionInformation(29, 0, "initializeValues");
        this.identifierQuoteString = result.extract_string();
        result = this.getServerConnectionInformation(89, 0, "initializeValues");
        this.sqlKeywords = result.extract_string();
        result = this.getServerConnectionInformation(113, 0, "initializeValues");
        this.supportsLikeEscapeClause = result.extract_string();
        result = this.getServerConnectionInformation(73, 0, "initializeValues");
        this.supportsIntegrityEnhancementFacility = result.extract_string();
        result = this.getServerConnectionInformation(112, -5, "initializeValues");
        this.maxBinaryLiteralLength = result.extract_long();
        result = this.getServerConnectionInformation(34, -5, "initializeValues");
        this.maxCatalogNameLength = result.extract_long();
        result = this.getServerConnectionInformation(108, -5, "initializeValues");
        this.maxCharLiteralLength = result.extract_long();
        result = this.getServerConnectionInformation(30, -5, "initializeValues");
        this.maxColumnNameLength = result.extract_long();
        result = this.getServerConnectionInformation(97, -5, "initializeValues");
        this.maxColumnsInGroupBy = result.extract_long();
        result = this.getServerConnectionInformation(98, -5, "initializeValues");
        this.maxColumnsInIndex = result.extract_long();
        result = this.getServerConnectionInformation(99, -5, "initializeValues");
        this.maxColumnsInOrderBy = result.extract_long();
        result = this.getServerConnectionInformation(100, -5, "initializeValues");
        this.maxColumnsInSelect = result.extract_long();
        result = this.getServerConnectionInformation(101, -5, "initializeValues");
        this.maxColumnsInTable = result.extract_long();
        result = this.getServerConnectionInformation(1, -5, "initializeValues");
        this.maxStatements = result.extract_long();
        result = this.getServerConnectionInformation(0, -5, "initializeValues");
        this.maxConnections = result.extract_long();
        result = this.getServerConnectionInformation(102, -9, "initializeValues");
        this.maxIndexLength = result.extract_longlong();
        result = this.getServerConnectionInformation(33, -5, "initializeValues");
        this.maxProcedureNameLength = result.extract_long();
        result = this.getServerConnectionInformation(104, -9, "initializeValues");
        this.maxRowSize = (int)result.extract_longlong();
        result = this.getServerConnectionInformation(103, 0, "initializeValues");
        this.doesMaxRowSizeIncludeBlobs = result.extract_string();
        result = this.getServerConnectionInformation(32, -5, "initializeValues");
        this.maxSchemaNameLength = result.extract_long();
        result = this.getServerConnectionInformation(105, -9, "initializeValues");
        this.maxStatementLength = (int)result.extract_longlong();
        result = this.getServerConnectionInformation(35, -5, "initializeValues");
        this.maxTableNameLength = result.extract_long();
        result = this.getServerConnectionInformation(106, -5, "initializeValues");
        this.maxTablesInSelect = result.extract_long();
        result = this.getServerConnectionInformation(107, -5, "initializeValues");
        this.maxUserNameLength = result.extract_long();
        result = this.getServerConnectionInformation(36, 0, "initializeValues");
        this.supportsMultipleResultSets = result.extract_string();
        result = this.getServerConnectionInformation(37, 0, "initializeValues");
        this.supportsMultipleTransactions = result.extract_string();
        result = this.getServerConnectionInformation(75, -5, "initializeValues");
        this.supportsNonNullableColumns = result.extract_long();
        result = this.getServerConnectionInformation(85, -5, "initializeValues");
        this.nullsAreSortedAtEnd = result.extract_long();
        this.initNumericFunctions();
        result = this.getServerConnectionInformation(115, -5, "initializeValues");
        this.supportsFullOuterJoins = result.extract_long();
        result = this.getServerConnectionInformation(20008, -5, "initializeValues");
        this.supportsOrderByUnrelated = result.extract_long();
        result = this.getServerConnectionInformation(79, -6, "initializeValues");
        this.supportsPositionedDelete = result.extract_long();
        result = this.getServerConnectionInformation(40, 0, "initializeValues");
        this.procedureTerm = result.extract_string();
        result = this.getServerConnectionInformation(21, 0, "initializeValues");
        this.supportsStoredProcs = result.extract_string();
        result = this.getServerConnectionInformation(93, -5, "initializeValues");
        this.storesQuotedCaseIdentifier = result.extract_long();
        result = this.getServerConnectionInformation(39, 0, "initializeValues");
        this.schemaTerm = result.extract_string();
        result = this.getServerConnectionInformation(91, -5, "initializeValues");
        this.supportsSchemasInDataManipulation = result.extract_long();
        result = this.getServerConnectionInformation(44, -5, "initializeValues");
        this.supportsResultSetType = result.extract_long();
        result = this.getServerConnectionInformation(14, 0, "initializeValues");
        this.searchStringEscape = result.extract_string();
        result = this.getServerConnectionInformation(94, 0, "initializeValues");
        this.extraNameCharacters = result.extract_string();
        this.initStringFunctions();
        result = this.getServerConnectionInformation(95, -5, "initializeValues");
        this.supportsCorrelatedSubqueries = result.extract_long();
        this.initSystemFunctions();
        this.initSupportsSelectForUpdate();
        this.initTimeDateFunctions();
        result = this.getServerConnectionInformation(46, -5, "initializeValues");
        this.supportsDataDefinitionAndDataManipulationTransactions = result.extract_long();
        result = this.getServerConnectionInformation(72, -5, "initializeValues");
        this.supportsTransactionIsolationLevel = result.extract_long();
        result = this.getServerConnectionInformation(96, -5, "initializeValues");
        this.supportsUnion = result.extract_long();
    }

    @Override
    public ResultSet getPseudoColumns(String catalog, String schemaPattern, String tableNamePattern, String columnNamePattern) throws SQLException {
        String method = "getPseudoColumns(catalog, schemaPattern)";
        SQLFeatureNotSupportedException ex = null;
        String lMsg = null;
        lMsg = LocalizedErrorHandler.getLocalizedError("General.methodNotImplemented.fmt", new String[]{"getPseudoColumns(catalog, schemaPattern)"});
        ex = new SQLFeatureNotSupportedException(lMsg);
        throw ex;
    }

    @Override
    public boolean generatedKeyAlwaysReturned() throws SQLException {
        String method = "generatedKeyAlwaysReturned";
        SQLFeatureNotSupportedException ex = null;
        String lMsg = null;
        lMsg = LocalizedErrorHandler.getLocalizedError("General.methodNotImplemented.fmt", new String[]{"generatedKeyAlwaysReturned"});
        ex = new SQLFeatureNotSupportedException(lMsg);
        throw ex;
    }

    public String toString() {
        String outStr = "DBMD ID:" + this.myID + " ConnID: " + this.tktsConnectionID;
        return outStr;
    }
}

