/*
 * Decompiled with CFR 0.152.
 */
package com.sas.tkts.sql;

import com.sas.iom.SASIOMDefs.OctetSeqHolder;
import com.sas.tkts.caching.UnpackInfo;
import com.sas.tkts.info.ParameterInfo;
import com.sas.tkts.iom.StatementWrapper;
import com.sas.tkts.logging.AbstractLogger;
import com.sas.tkts.logging.LoggerFactory;
import com.sas.tkts.sql.FSConnection;
import com.sas.tkts.sql.FSPreparedStatement;
import com.sas.tkts.sql.FSResultSet;
import com.sas.tkts.sql.LocalizedErrorHandler;
import com.sas.tkts.sql.LocalizedMessageHandler;
import com.sas.tkts.types.AbstractColumn;
import com.sas.tkts.types.BlobFedSrv;
import com.sas.tkts.util.ByteArrayConverter;
import com.sas.tkts.util.ByteExtractor;
import com.sas.tkts.util.DataTypeConversions;
import com.sas.tkts.util.UtilityFunctions;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.nio.charset.Charset;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Map;
import java.util.Vector;

public class FSCallableStatement
extends FSPreparedStatement
implements CallableStatement {
    private static String thisClassName = FSCallableStatement.class.getName();
    private static AbstractLogger logger = LoggerFactory.getLogger(thisClassName);
    private transient boolean wasNull;

    protected FSCallableStatement(FSConnection connection, String sqlStmt, int rsType, int rsConcurrency) throws SQLException {
        super(connection, sqlStmt, rsType, rsConcurrency);
        this.setFetchSize(1);
    }

    @Override
    public void registerOutParameter(int index, int sqlType) throws SQLException {
        this.registerOutParameter(index, sqlType, 0);
    }

    @Override
    public void registerOutParameter(String parameterName, int sqlType) throws SQLException {
        this.closedCheck();
        int parameterIndex = this.validateParameterName(parameterName);
        this.registerOutParameter(parameterIndex, sqlType);
    }

    @Override
    public void registerOutParameter(int index, int sqlType, int scale) throws SQLException {
        String method = "registerOutParameter";
        if (AbstractLogger.isInfo) {
            String[] args = new String[]{String.valueOf(index), String.valueOf(sqlType), String.valueOf(scale)};
            LocalizedMessageHandler.logInfoMessage("registerOutParameter", "FSCallableStatement.registerOutParameter.fmt", args, logger);
        }
        this.closedCheck();
        ParameterInfo pi = this.validateParameterIndex(index);
        int oldSqlType = pi.getSQLType();
        boolean isValueSet = pi.isValueSet();
        boolean requiresRebind = FSCallableStatement.typeRequiresRebind(oldSqlType, sqlType);
        if (isValueSet && requiresRebind) {
            String typeInSet = UtilityFunctions.getSQLTypeAsString(oldSqlType);
            String typeInReg = UtilityFunctions.getSQLTypeAsString(sqlType);
            String ei = "TKTSCallableStatement.typemismatch.fmt";
            this.throwException("TKTSCallableStatement.typemismatch.fmt", logger, typeInSet, typeInReg);
        }
        if (requiresRebind) {
            pi.resetValue();
            pi.validateParameterDataType(sqlType);
        }
        pi.setDecimalDigits(scale);
        int bindDirection = pi.getBindDirection();
        if (bindDirection != 2) {
            if (bindDirection == 1) {
                pi.setBindDirection(2);
                pi.setBindRequired(true);
            } else {
                pi.setBindDirection(4);
                pi.setBindRequired(true);
            }
        }
        if (AbstractLogger.isTrace) {
            logger.exit("registerOutParameter");
        }
    }

    @Override
    public void registerOutParameter(String parameterName, int sqlType, int scale) throws SQLException {
        int parameterIndex = this.validateParameterName(parameterName);
        this.registerOutParameter(parameterIndex, sqlType, scale);
    }

    @Override
    public void registerOutParameter(int parameterIndex, int sqlType, String typeName) throws SQLException {
        String method = "registerOutParameter";
        this.genFeatureNotSupportedException("registerOutParameter");
        throw this.nsEx;
    }

    @Override
    public void registerOutParameter(String parameterName, int sqlType, String typeName) throws SQLException {
        String method = "registerOutParameter";
        this.genFeatureNotSupportedException("registerOutParameter");
        throw this.nsEx;
    }

    @Override
    public boolean execute() throws SQLException {
        String method = "execute()";
        if (AbstractLogger.isInfo) {
            LocalizedMessageHandler.logInfoMessage("execute()", "FSCallableStatement.execute.txt", logger);
        }
        this.closedCheck();
        this.clearWarnings();
        this.globalRowCount = new Vector();
        boolean isQuery = false;
        boolean successPSS = this.setParameterSetSize(1);
        if (!successPSS) {
            this.recoverParameterSetFailure();
        }
        if (!this.parametersBound()) {
            this.bindParameters();
        }
        this.packParametersValues(true);
        this.execute2();
        if (this.isQueryStatement) {
            this.globalResultSet = new FSResultSet(this.statementWrapper, this, this.numberOfColumnsInResultSet, false);
            isQuery = true;
        }
        return isQuery;
    }

    @Override
    public boolean wasNull() throws SQLException {
        return this.wasNull;
    }

    private ParameterInfo checkIndexAndBindDirection(int index) throws SQLException {
        ParameterInfo pi = this.validateParameterIndex(index);
        int bindDirection = pi.getBindDirection();
        if (bindDirection != 4 && bindDirection != 2) {
            String ei = "TKTSCallableStatement.notAnOUT.fmt";
            String tStr = "" + index;
            this.throwException("TKTSCallableStatement.notAnOUT.fmt", logger, tStr);
        }
        return pi;
    }

    private void execute2() throws SQLException {
        String method = "execute2";
        if (AbstractLogger.isTrace) {
            logger.entry("execute2");
        }
        boolean returnValue = false;
        this.closeGlobalResultSet();
        OctetSeqHolder outParams = this.invokeExecute2(false, 1);
        if (outParams != null && outParams.value.length > 0) {
            long startTime = System.nanoTime();
            if (this.isPackType1) {
                this.unpackOutputData1(outParams.value);
            } else {
                this.unpackOutputData0(outParams.value);
            }
            long delta = System.nanoTime() - startTime;
            StatementWrapper.apiUnpackData(delta, 1L, outParams.value.length);
        }
        if (AbstractLogger.isTrace) {
            logger.exit("execute2", returnValue);
        }
    }

    private void unpackOutputData0(byte[] outputBuffer) throws IndexOutOfBoundsException, SQLException {
        String method = "unpackOutputData0";
        if (AbstractLogger.isTrace) {
            logger.entry("unpackOutputData0", "outputBufferLength[" + outputBuffer.length + "]");
        }
        int columnOrdinal = 0;
        ByteExtractor byteExtractor = new ByteExtractor(outputBuffer);
        int bufferSize = byteExtractor.getInt();
        while (byteExtractor.getCurrentPosition() < bufferSize) {
            columnOrdinal = byteExtractor.getInt();
            ParameterInfo parameterInfo = this._PIA[columnOrdinal - 1];
            int sqlType = parameterInfo.getSQLType();
            Charset nativeCharset = parameterInfo.getNativeCharset();
            if (AbstractLogger.isTrace) {
                logger.trace("Processing column=[" + parameterInfo.getName() + "] ordinal=[" + columnOrdinal + "] SQLType=[" + sqlType + "] CType=[" + parameterInfo.getCType() + "] Charset=[" + nativeCharset + "]");
            }
            Object o = null;
            long indicator = ByteArrayConverter.getIndicatorValue(byteExtractor);
            if (indicator != -41L) {
                AbstractColumn ac = ByteArrayConverter.extractOrdinalColumnData(byteExtractor, indicator, columnOrdinal, sqlType, -1, nativeCharset);
                o = ac.getObject();
                this._PIA[columnOrdinal - 1].setValue(o);
            } else {
                this._PIA[columnOrdinal - 1].setValid(false);
            }
            if (!AbstractLogger.isTrace) continue;
            logger.trace("Buffer Size=[" + bufferSize + "] Position=[" + byteExtractor.getCurrentPosition() + "]");
        }
        if (AbstractLogger.isTrace) {
            logger.exit("unpackOutputData0");
        }
    }

    private void unpackOutputData1(byte[] outputBuffer) throws IndexOutOfBoundsException, SQLException {
        int i;
        String method = "unpackOutputData1";
        if (AbstractLogger.isTrace) {
            logger.entry("unpackOutputData1", "outputBufferLength[" + outputBuffer.length + "]");
        }
        int columnOrdinal = 0;
        ByteExtractor byteExtractor = new ByteExtractor(outputBuffer);
        int bufferSize = byteExtractor.getInt();
        int unpackColumnNumber = byteExtractor.getInt();
        int[] unpackColumns = new int[unpackColumnNumber];
        for (i = 0; i < unpackColumnNumber; ++i) {
            int j;
            unpackColumns[i] = j = byteExtractor.getInt();
        }
        i = 0;
        while (byteExtractor.getCurrentPosition() != bufferSize) {
            columnOrdinal = unpackColumns[i];
            ParameterInfo parameterInfo = this._PIA[columnOrdinal - 1];
            UnpackInfo upi = new UnpackInfo(parameterInfo, false);
            int cType = parameterInfo.getCType();
            upi.setNativeCType(cType);
            if (AbstractLogger.isTrace) {
                logger.trace("Processing column=[" + parameterInfo.getName() + "] ordinal=[" + columnOrdinal + "] SQLType=[" + upi.cSqlType + "] CType=[" + parameterInfo.getCType() + "] Charset=[" + upi.getCharset() + "]");
            }
            Object o = null;
            long indicator = ByteArrayConverter.getIndicatorValue(byteExtractor);
            if (indicator != -41L) {
                AbstractColumn ac = ByteArrayConverter.extractOrdinalColumnDataV1(byteExtractor, indicator, columnOrdinal, upi);
                o = ac.getObject();
                this._PIA[columnOrdinal - 1].setValue(o);
            } else {
                this._PIA[columnOrdinal - 1].setValid(false);
            }
            if (AbstractLogger.isTrace) {
                logger.trace("Buffer Size=[" + bufferSize + "] Position=[" + byteExtractor.getCurrentPosition() + "]");
            }
            ++i;
        }
        if (AbstractLogger.isTrace) {
            logger.exit("unpackOutputData1");
        }
    }

    @Override
    public Array getArray(int parameterIndex) throws SQLException {
        String method = "getArray(parameterIndex)";
        this.genFeatureNotSupportedException("getArray(parameterIndex)");
        throw this.nsEx;
    }

    @Override
    public Array getArray(String parameterName) throws SQLException {
        String method = "getArray(parameterName)";
        this.genFeatureNotSupportedException("getArray(parameterName)");
        throw this.nsEx;
    }

    @Override
    public Blob getBlob(int parameterIndex) throws SQLException {
        String method = "getBlob(parameterIndex)";
        BlobFedSrv outBlob = null;
        this.wasNull = false;
        ParameterInfo pi = this.checkIndexAndBindDirection(parameterIndex);
        if (pi.getValue() == null) {
            this.wasNull = true;
            return outBlob;
        }
        int sqlType = pi.getSQLType();
        switch (sqlType) {
            case -4: 
            case -3: 
            case -2: {
                break;
            }
            default: {
                String si = "TKTSResultSet.UnableConvertToBLOBError.txt";
                throw new SQLException(LocalizedErrorHandler.getLocalizedError("TKTSResultSet.UnableConvertToBLOBError.txt", null));
            }
        }
        byte[] dataBytes = (byte[])pi.getValue();
        this.wasNull = false;
        outBlob = new BlobFedSrv(dataBytes);
        if (AbstractLogger.isTrace) {
            logger.exit("getBlob(parameterIndex)", "blob[" + outBlob + "]");
        }
        return outBlob;
    }

    @Override
    public Blob getBlob(String parameterName) throws SQLException {
        int parameterIndex = this.validateParameterName(parameterName);
        return this.getBlob(parameterIndex);
    }

    @Override
    public Reader getCharacterStream(int parameterIndex) throws SQLException {
        String method = "getCharacterStream(parameterIndex)";
        this.genFeatureNotSupportedException("getCharacterStream(parameterIndex)");
        throw this.nsEx;
    }

    @Override
    public Reader getCharacterStream(String parameterName) throws SQLException {
        String method = "getCharacterStream(parameterName)";
        this.genFeatureNotSupportedException("getCharacterStream(parameterName)");
        throw this.nsEx;
    }

    @Override
    public Clob getClob(int parameterIndex) throws SQLException {
        String method = "getClob(parameterIndex)";
        this.genFeatureNotSupportedException("getClob(parameterIndex)");
        throw this.nsEx;
    }

    @Override
    public Clob getClob(String parameterName) throws SQLException {
        String method = "getClob(parameterName)";
        this.genFeatureNotSupportedException("getClob(parameterName)");
        throw this.nsEx;
    }

    @Override
    public BigDecimal getBigDecimal(int index) throws SQLException {
        this.wasNull = false;
        ParameterInfo pi = this.checkIndexAndBindDirection(index);
        BigDecimal out = null;
        Object iObj = pi.getValue();
        if (iObj == null) {
            this.wasNull = true;
            return out;
        }
        if (iObj instanceof BigDecimal) {
            out = (BigDecimal)iObj;
        }
        if (iObj instanceof Number) {
            if (iObj instanceof Double) {
                Double value = (Double)iObj;
                String convString = value.toString();
                out = new BigDecimal(convString);
            } else if (iObj instanceof Float) {
                Float value = (Float)iObj;
                String convString = value.toString();
                out = new BigDecimal(convString);
            } else if (iObj instanceof Long) {
                Long value = (Long)iObj;
                out = new BigDecimal(value);
            } else if (iObj instanceof Integer) {
                Integer value = (Integer)iObj;
                out = new BigDecimal(value);
            } else if (iObj instanceof Short) {
                Short value = (Short)iObj;
                int tInt = value.intValue();
                out = new BigDecimal(tInt);
            } else if (iObj instanceof Byte) {
                Byte value = (Byte)iObj;
                int tInt = value.intValue();
                out = new BigDecimal(tInt);
            }
        } else if (iObj instanceof String) {
            String trimStr = ((String)iObj).trim();
            try {
                out = new BigDecimal(trimStr);
            }
            catch (NumberFormatException nfe) {
                String tClass = "BigDecimal";
                DataTypeConversions.badTargetClassException(iObj, tClass);
            }
        } else {
            String tClass = "BigDecimal";
            DataTypeConversions.badTargetClassException(iObj, tClass);
        }
        return out;
    }

    @Override
    public BigDecimal getBigDecimal(int index, int scale) throws SQLException {
        return this.getBigDecimal(index);
    }

    @Override
    public BigDecimal getBigDecimal(String parameterName) throws SQLException {
        int parameterIndex = this.validateParameterName(parameterName);
        return this.getBigDecimal(parameterIndex);
    }

    @Override
    public boolean getBoolean(int index) throws SQLException {
        this.wasNull = false;
        ParameterInfo pi = this.checkIndexAndBindDirection(index);
        boolean out = false;
        Object tValue = pi.getValue();
        if (tValue == null) {
            this.wasNull = true;
            return out;
        }
        out = DataTypeConversions.convertToBoolean(tValue);
        return out;
    }

    @Override
    public boolean getBoolean(String parameterName) throws SQLException {
        int parameterIndex = this.validateParameterName(parameterName);
        return this.getBoolean(parameterIndex);
    }

    @Override
    public byte getByte(int index) throws SQLException {
        ParameterInfo pi = this.checkIndexAndBindDirection(index);
        DataTypeConversions dtc = new DataTypeConversions(pi.getValue(), pi.getOrdinal(), pi.getName(), true);
        byte out = dtc.getByte(true);
        this.wasNull = dtc.getWasNull();
        this.createWarnings(dtc.getDataTruncation());
        return out;
    }

    @Override
    public byte getByte(String parameterName) throws SQLException {
        int parameterIndex = this.validateParameterName(parameterName);
        return this.getByte(parameterIndex);
    }

    @Override
    public byte[] getBytes(int index) throws SQLException {
        this.wasNull = false;
        ParameterInfo pi = this.checkIndexAndBindDirection(index);
        if (pi.getValue() == null) {
            this.wasNull = true;
            return null;
        }
        return (byte[])pi.getValue();
    }

    @Override
    public byte[] getBytes(String parameterName) throws SQLException {
        int parameterIndex = this.validateParameterName(parameterName);
        return this.getBytes(parameterIndex);
    }

    @Override
    public Date getDate(int index) throws SQLException {
        this.wasNull = false;
        ParameterInfo pi = this.checkIndexAndBindDirection(index);
        Object tValue = pi.getValue();
        if (tValue == null) {
            this.wasNull = true;
            return null;
        }
        Date out = DataTypeConversions.convertToDate(tValue);
        return out;
    }

    @Override
    public Date getDate(int index, Calendar cal) throws SQLException {
        this.wasNull = false;
        ParameterInfo pi = this.checkIndexAndBindDirection(index);
        if (pi.getValue() == null) {
            this.wasNull = true;
            return null;
        }
        Date date = (Date)pi.getValue();
        UtilityFunctions.applyCalendar(date, cal);
        return date;
    }

    @Override
    public Date getDate(String parameterName) throws SQLException {
        int parameterIndex = this.validateParameterName(parameterName);
        return this.getDate(parameterIndex);
    }

    @Override
    public Date getDate(String parameterName, Calendar cal) throws SQLException {
        int parameterIndex = this.validateParameterName(parameterName);
        return this.getDate(parameterIndex, cal);
    }

    @Override
    public double getDouble(int index) throws SQLException {
        ParameterInfo pi = this.checkIndexAndBindDirection(index);
        DataTypeConversions dtc = new DataTypeConversions(pi.getValue(), pi.getOrdinal(), pi.getName(), true);
        double out = dtc.getDouble(true);
        this.wasNull = dtc.getWasNull();
        this.createWarnings(dtc.getDataTruncation());
        return out;
    }

    @Override
    public double getDouble(String parameterName) throws SQLException {
        int parameterIndex = this.validateParameterName(parameterName);
        return this.getDouble(parameterIndex);
    }

    @Override
    public float getFloat(int index) throws SQLException {
        ParameterInfo pi = this.checkIndexAndBindDirection(index);
        DataTypeConversions dtc = new DataTypeConversions(pi.getValue(), pi.getOrdinal(), pi.getName(), true);
        float out = dtc.getFloat(true);
        this.wasNull = dtc.getWasNull();
        this.createWarnings(dtc.getDataTruncation());
        return out;
    }

    @Override
    public float getFloat(String parameterName) throws SQLException {
        int parameterIndex = this.validateParameterName(parameterName);
        return this.getFloat(parameterIndex);
    }

    @Override
    public int getInt(int index) throws SQLException {
        ParameterInfo pi = this.checkIndexAndBindDirection(index);
        DataTypeConversions dtc = new DataTypeConversions(pi.getValue(), pi.getOrdinal(), pi.getName(), true);
        int out = dtc.getInt(true);
        this.wasNull = dtc.getWasNull();
        this.createWarnings(dtc.getDataTruncation());
        return out;
    }

    @Override
    public int getInt(String parameterName) throws SQLException {
        int parameterIndex = this.validateParameterName(parameterName);
        return this.getInt(parameterIndex);
    }

    @Override
    public long getLong(int index) throws SQLException {
        ParameterInfo pi = this.checkIndexAndBindDirection(index);
        DataTypeConversions dtc = new DataTypeConversions(pi.getValue(), pi.getOrdinal(), pi.getName(), true);
        long out = dtc.getLong(true);
        this.wasNull = dtc.getWasNull();
        this.createWarnings(dtc.getDataTruncation());
        return out;
    }

    @Override
    public long getLong(String parameterName) throws SQLException {
        int parameterIndex = this.validateParameterName(parameterName);
        return this.getLong(parameterIndex);
    }

    @Override
    public Reader getNCharacterStream(int parameterIndex) throws SQLException {
        String method = "getNCharacterStream(parameterIndex)";
        this.genFeatureNotSupportedException("getNCharacterStream(parameterIndex)");
        throw this.nsEx;
    }

    @Override
    public Reader getNCharacterStream(String parameterName) throws SQLException {
        String method = "getNCharacterStream(parameterName)";
        this.genFeatureNotSupportedException("getNCharacterStream(parameterName)");
        throw this.nsEx;
    }

    @Override
    public NClob getNClob(int parameterIndex) throws SQLException {
        String method = "getNClob(parameterIndex)";
        this.genFeatureNotSupportedException("getNClob(parameterIndex)");
        throw this.nsEx;
    }

    @Override
    public NClob getNClob(String parameterName) throws SQLException {
        String method = "getNClob(parameterName)";
        this.genFeatureNotSupportedException("getNClob(parameterName)");
        throw this.nsEx;
    }

    @Override
    public String getNString(int parameterIndex) throws SQLException {
        String method = "getNString(parameterIndex)";
        this.genFeatureNotSupportedException("getNString(parameterIndex)");
        throw this.nsEx;
    }

    @Override
    public String getNString(String parameterName) throws SQLException {
        String method = "getNString(parameterName)";
        this.genFeatureNotSupportedException("getNString(parameterName)");
        throw this.nsEx;
    }

    @Override
    public Object getObject(int index) throws SQLException {
        this.wasNull = false;
        ParameterInfo pi = this.checkIndexAndBindDirection(index);
        Object value = pi.getValue();
        if (value == null) {
            this.wasNull = true;
            return null;
        }
        return value;
    }

    @Override
    public Object getObject(String parameterName) throws SQLException {
        int parameterIndex = this.validateParameterName(parameterName);
        return this.getObject(parameterIndex);
    }

    public Object getObject(int parameterIndex, Map map) throws SQLException {
        String method = "getObject(parameterIndex, map)";
        this.genFeatureNotSupportedException("getObject(parameterIndex, map)");
        throw this.nsEx;
    }

    public Object getObject(String parameterName, Map map) throws SQLException {
        String method = "getObject(parameterName, map)";
        this.genFeatureNotSupportedException("getObject(parameterName, map)");
        throw this.nsEx;
    }

    @Override
    public Ref getRef(int parameterIndex) throws SQLException {
        String method = "getRef(parameterIndex)";
        this.genFeatureNotSupportedException("getRef(parameterIndex)");
        throw this.nsEx;
    }

    @Override
    public Ref getRef(String parameterName) throws SQLException {
        String method = "getRef(parameterName)";
        this.genFeatureNotSupportedException("getRef(parameterName)");
        throw this.nsEx;
    }

    @Override
    public RowId getRowId(int parameterIndex) throws SQLException {
        String method = "getRowId(parameterIndex)";
        this.genFeatureNotSupportedException("getRowId(parameterIndex)");
        throw this.nsEx;
    }

    @Override
    public RowId getRowId(String parameterName) throws SQLException {
        String method = "getRowId(parameterName)";
        this.genFeatureNotSupportedException("getRowId(parameterName)");
        throw this.nsEx;
    }

    @Override
    public short getShort(int index) throws SQLException {
        ParameterInfo pi = this.checkIndexAndBindDirection(index);
        DataTypeConversions dtc = new DataTypeConversions(pi.getValue(), pi.getOrdinal(), pi.getName(), true);
        short out = dtc.getShort(true);
        this.wasNull = dtc.getWasNull();
        this.createWarnings(dtc.getDataTruncation());
        return out;
    }

    @Override
    public short getShort(String parameterName) throws SQLException {
        int parameterIndex = this.validateParameterName(parameterName);
        return this.getShort(parameterIndex);
    }

    @Override
    public SQLXML getSQLXML(int parameterIndex) throws SQLException {
        String method = "getSQLXML(parameterIndex)";
        this.genFeatureNotSupportedException("getSQLXML(parameterIndex)");
        throw this.nsEx;
    }

    @Override
    public SQLXML getSQLXML(String parameterName) throws SQLException {
        String method = "getSQLXML(parameterName)";
        this.genFeatureNotSupportedException("getSQLXML(parameterName)");
        throw this.nsEx;
    }

    @Override
    public String getString(int index) throws SQLException {
        this.wasNull = false;
        ParameterInfo pi = this.checkIndexAndBindDirection(index);
        String out = null;
        Object tValue = pi.getValue();
        if (tValue == null) {
            this.wasNull = true;
            return null;
        }
        out = DataTypeConversions.convertToString(tValue);
        return out;
    }

    @Override
    public String getString(String parameterName) throws SQLException {
        int parameterIndex = this.validateParameterName(parameterName);
        return this.getString(parameterIndex);
    }

    @Override
    public Time getTime(int index) throws SQLException {
        this.wasNull = false;
        ParameterInfo pi = this.checkIndexAndBindDirection(index);
        Object tValue = pi.getValue();
        if (tValue == null) {
            this.wasNull = true;
            return null;
        }
        Time out = DataTypeConversions.convertToTime(tValue);
        return out;
    }

    @Override
    public Time getTime(String parameterName) throws SQLException {
        int parameterIndex = this.validateParameterName(parameterName);
        return this.getTime(parameterIndex);
    }

    @Override
    public Time getTime(int index, Calendar cal) throws SQLException {
        this.wasNull = false;
        ParameterInfo pi = this.checkIndexAndBindDirection(index);
        Object tValue = pi.getValue();
        if (tValue == null) {
            this.wasNull = true;
            return null;
        }
        Time time = (Time)pi.getValue();
        UtilityFunctions.applyCalendar(time, cal);
        return time;
    }

    @Override
    public Time getTime(String parameterName, Calendar cal) throws SQLException {
        int parameterIndex = this.validateParameterName(parameterName);
        return this.getTime(parameterIndex, cal);
    }

    @Override
    public Timestamp getTimestamp(int index) throws SQLException {
        this.wasNull = false;
        ParameterInfo pi = this.checkIndexAndBindDirection(index);
        Object tValue = pi.getValue();
        if (tValue == null) {
            this.wasNull = true;
            return null;
        }
        Timestamp out = DataTypeConversions.convertToTimestamp(tValue);
        return out;
    }

    @Override
    public Timestamp getTimestamp(String parameterName) throws SQLException {
        int parameterIndex = this.validateParameterName(parameterName);
        return this.getTimestamp(parameterIndex);
    }

    @Override
    public Timestamp getTimestamp(int index, Calendar cal) throws SQLException {
        this.wasNull = false;
        ParameterInfo pi = this.checkIndexAndBindDirection(index);
        Object tValue = pi.getValue();
        if (tValue == null) {
            this.wasNull = true;
            return null;
        }
        Timestamp timestamp = (Timestamp)pi.getValue();
        UtilityFunctions.applyCalendar(timestamp, cal);
        return timestamp;
    }

    @Override
    public Timestamp getTimestamp(String parameterName, Calendar cal) throws SQLException {
        int parameterIndex = this.validateParameterName(parameterName);
        return this.getTimestamp(parameterIndex);
    }

    @Override
    public URL getURL(int parameterIndex) throws SQLException {
        String method = "getURL(parameterIndex)";
        this.genFeatureNotSupportedException("getURL(parameterIndex)");
        throw this.nsEx;
    }

    @Override
    public URL getURL(String parameterName) throws SQLException {
        String method = "getURL(parameterName)";
        this.genFeatureNotSupportedException("getURL(parameterName)");
        throw this.nsEx;
    }

    @Override
    public void setAsciiStream(String parameterName, InputStream x) throws SQLException {
        String method = "setAsciiStream(parameterName, InputStream)";
        this.genFeatureNotSupportedException("setAsciiStream(parameterName, InputStream)");
        throw this.nsEx;
    }

    @Override
    public void setAsciiStream(String parameterName, InputStream x, int length) throws SQLException {
        String method = "setAsciiStream(parameterName, InputStream, int length)";
        this.genFeatureNotSupportedException("setAsciiStream(parameterName, InputStream, int length)");
        throw this.nsEx;
    }

    @Override
    public void setAsciiStream(String parameterName, InputStream x, long length) throws SQLException {
        String method = "setAsciiStream(parameterName, InputStream, long length)";
        this.genFeatureNotSupportedException("setAsciiStream(parameterName, InputStream, long length)");
        throw this.nsEx;
    }

    @Override
    public void setBinaryStream(String parameterName, InputStream x) throws SQLException {
        String method = "setBinaryStream(parameterName, InputStream)";
        this.genFeatureNotSupportedException("setBinaryStream(parameterName, InputStream)");
        throw this.nsEx;
    }

    @Override
    public void setBinaryStream(String parameterName, InputStream x, int length) throws SQLException {
        String method = "setBinaryStream(parameterName, InputStream, int length)";
        this.genFeatureNotSupportedException("setBinaryStream(parameterName, InputStream, int length)");
        throw this.nsEx;
    }

    @Override
    public void setBinaryStream(String parameterName, InputStream x, long length) throws SQLException {
        String method = "setBinaryStream(parameterName, InputStream, long length)";
        this.genFeatureNotSupportedException("setBinaryStream(parameterName, InputStream, long length)");
        throw this.nsEx;
    }

    @Override
    public void setBlob(String parameterName, Blob x) throws SQLException {
        int parameterIndex = this.validateParameterName(parameterName);
        this.setBlob(parameterIndex, x);
    }

    @Override
    public void setBlob(String parameterName, InputStream inputStream) throws SQLException {
        String method = "setBlob(parameterName, inputStream)";
        this.genFeatureNotSupportedException("setBlob(parameterName, inputStream)");
        throw this.nsEx;
    }

    @Override
    public void setBlob(String parameterName, InputStream inputStream, long length) throws SQLException {
        String method = "setBlob(parameterName, inputStream, length)";
        this.genFeatureNotSupportedException("setBlob(parameterName, inputStream, length)");
        throw this.nsEx;
    }

    @Override
    public void setBigDecimal(String parameterName, BigDecimal x) throws SQLException {
        int parameterIndex = this.validateParameterName(parameterName);
        this.setBigDecimal(parameterIndex, x);
    }

    @Override
    public void setBoolean(String parameterName, boolean x) throws SQLException {
        int parameterIndex = this.validateParameterName(parameterName);
        this.setBoolean(parameterIndex, x);
    }

    @Override
    public void setByte(String parameterName, byte x) throws SQLException {
        int parameterIndex = this.validateParameterName(parameterName);
        this.setByte(parameterIndex, x);
    }

    @Override
    public void setBytes(String parameterName, byte[] x) throws SQLException {
        int parameterIndex = this.validateParameterName(parameterName);
        this.setBytes(parameterIndex, x);
    }

    @Override
    public void setCharacterStream(String parameterName, Reader reader) throws SQLException {
        String method = "setCharacterStream(parameterName, reader)";
        this.genFeatureNotSupportedException("setCharacterStream(parameterName, reader)");
        throw this.nsEx;
    }

    @Override
    public void setCharacterStream(String parameterName, Reader reader, int length) throws SQLException {
        int parameterIndex = this.validateParameterName(parameterName);
        this.setCharacterStream(parameterIndex, reader, length);
    }

    @Override
    public void setCharacterStream(String parameterName, Reader reader, long length) throws SQLException {
        int parameterIndex = this.validateParameterName(parameterName);
        this.setCharacterStream(parameterIndex, reader, length);
    }

    @Override
    public void setClob(String parameterName, Clob x) throws SQLException {
        String method = "setClob(parameterName, clob)";
        this.genFeatureNotSupportedException("setClob(parameterName, clob)");
        throw this.nsEx;
    }

    @Override
    public void setClob(String parameterName, Reader reader) throws SQLException {
        String method = "setClob(parameterName, reader)";
        this.genFeatureNotSupportedException("setClob(parameterName, reader)");
        throw this.nsEx;
    }

    @Override
    public void setClob(String parameterName, Reader reader, long length) throws SQLException {
        String method = "setClob(parameterName, reader, length)";
        this.genFeatureNotSupportedException("setClob(parameterName, reader, length)");
        throw this.nsEx;
    }

    @Override
    public void setDate(String parameterName, Date x) throws SQLException {
        int parameterIndex = this.validateParameterName(parameterName);
        this.setDate(parameterIndex, x);
    }

    @Override
    public void setDate(String parameterName, Date x, Calendar cal) throws SQLException {
        int parameterIndex = this.validateParameterName(parameterName);
        this.setDate(parameterIndex, x, cal);
    }

    @Override
    public void setDouble(String parameterName, double x) throws SQLException {
        int parameterIndex = this.validateParameterName(parameterName);
        this.setDouble(parameterIndex, x);
    }

    @Override
    public void setFloat(String parameterName, float x) throws SQLException {
        int parameterIndex = this.validateParameterName(parameterName);
        this.setFloat(parameterIndex, x);
    }

    @Override
    public void setInt(String parameterName, int x) throws SQLException {
        int parameterIndex = this.validateParameterName(parameterName);
        this.setInt(parameterIndex, x);
    }

    @Override
    public void setLong(String parameterName, long x) throws SQLException {
        int parameterIndex = this.validateParameterName(parameterName);
        this.setLong(parameterIndex, x);
    }

    @Override
    public void setNCharacterStream(String parameterName, Reader value) throws SQLException {
        String method = "setNCharacterStream(parameterName, reader)";
        this.genFeatureNotSupportedException("setNCharacterStream(parameterName, reader)");
        throw this.nsEx;
    }

    @Override
    public void setNCharacterStream(String parameterName, Reader value, long length) throws SQLException {
        String method = "setNCharacterStream(parameterName, reader, length)";
        this.genFeatureNotSupportedException("setNCharacterStream(parameterName, reader, length)");
        throw this.nsEx;
    }

    @Override
    public void setNClob(String parameterName, NClob value) throws SQLException {
        String method = "setNClob(parameterName, NClob)";
        this.genFeatureNotSupportedException("setNClob(parameterName, NClob)");
        throw this.nsEx;
    }

    @Override
    public void setNClob(String parameterName, Reader reader) throws SQLException {
        String method = "setNClob(parameterName, reader)";
        this.genFeatureNotSupportedException("setNClob(parameterName, reader)");
        throw this.nsEx;
    }

    @Override
    public void setNClob(String parameterName, Reader reader, long length) throws SQLException {
        String method = "setNClob(parameterName, reader, length)";
        this.genFeatureNotSupportedException("setNClob(parameterName, reader, length)");
        throw this.nsEx;
    }

    @Override
    public void setNString(String parameterName, String value) throws SQLException {
        String method = "setNString(parameterName, value)";
        this.genFeatureNotSupportedException("setNString(parameterName, value)");
        throw this.nsEx;
    }

    @Override
    public void setNull(String parameterName, int sqlType) throws SQLException {
        int parameterIndex = this.validateParameterName(parameterName);
        this.setNull(parameterIndex, sqlType);
    }

    @Override
    public void setNull(String parameterName, int sqlType, String typeName) throws SQLException {
        String method = "setNull(parameterName, sqlType, typeName)";
        this.genFeatureNotSupportedException("setNull(parameterName, sqlType, typeName)");
        throw this.nsEx;
    }

    @Override
    public void setObject(String parameterName, Object x) throws SQLException {
        int parameterIndex = this.validateParameterName(parameterName);
        this.setObject(parameterIndex, x);
    }

    @Override
    public void setObject(String parameterName, Object x, int targetSqlType) throws SQLException {
        int parameterIndex = this.validateParameterName(parameterName);
        this.setObject(parameterIndex, x, targetSqlType);
    }

    @Override
    public void setObject(String parameterName, Object x, int targetSqlType, int scale) throws SQLException {
        int parameterIndex = this.validateParameterName(parameterName);
        this.setObject(parameterIndex, x, targetSqlType, scale);
    }

    @Override
    public void setRowId(String parameterName, RowId x) throws SQLException {
        String method = "setRowId(parameterName, rowId)";
        this.genFeatureNotSupportedException("setRowId(parameterName, rowId)");
        throw this.nsEx;
    }

    @Override
    public void setShort(String parameterName, short x) throws SQLException {
        int parameterIndex = this.validateParameterName(parameterName);
        this.setShort(parameterIndex, x);
    }

    @Override
    public void setSQLXML(String parameterName, SQLXML xmlObject) throws SQLException {
        String method = "setSQLXML(parameterName, xmlObject)";
        this.genFeatureNotSupportedException("setSQLXML(parameterName, xmlObject)");
        throw this.nsEx;
    }

    @Override
    public void setString(String parameterName, String x) throws SQLException {
        int parameterIndex = this.validateParameterName(parameterName);
        this.setString(parameterIndex, x);
    }

    @Override
    public void setTime(String parameterName, Time x) throws SQLException {
        int parameterIndex = this.validateParameterName(parameterName);
        this.setTime(parameterIndex, x);
    }

    @Override
    public void setTime(String parameterName, Time x, Calendar cal) throws SQLException {
        int parameterIndex = this.validateParameterName(parameterName);
        this.setTime(parameterIndex, x, cal);
    }

    @Override
    public void setTimestamp(String parameterName, Timestamp x) throws SQLException {
        int parameterIndex = this.validateParameterName(parameterName);
        this.setTimestamp(parameterIndex, x);
    }

    @Override
    public void setTimestamp(String parameterName, Timestamp x, Calendar cal) throws SQLException {
        int parameterIndex = this.validateParameterName(parameterName);
        this.setTimestamp(parameterIndex, x, cal);
    }

    @Override
    public void setURL(String parameterName, URL val) throws SQLException {
        String method = "setURL(parameterName, url)";
        this.genFeatureNotSupportedException("setURL(parameterName, url)");
        throw this.nsEx;
    }

    @Override
    public <T> T getObject(int parameterIndex, Class<T> type) throws SQLException {
        String method = "getObject(parameterIndex, type)";
        this.genFeatureNotSupportedException("getObject(parameterIndex, type)");
        throw this.nsEx;
    }

    @Override
    public <T> T getObject(String parameterName, Class<T> type) throws SQLException {
        String method = "getObject(parameterName,type)";
        this.genFeatureNotSupportedException("getObject(parameterName,type)");
        throw this.nsEx;
    }
}

