/*
 * Decompiled with CFR 0.152.
 */
package com.sas.tkts.logging;

import com.sas.tkts.logging.AbstractLogger;
import com.sas.tkts.logging.ExceptionsLogger;
import com.sas.tkts.logging.LoggerFactory;
import com.sas.tkts.stats.StatisticItem;
import com.sas.tkts.stats.StatisticsBoard;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.ResourceBundle;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.Configurator;
import org.apache.logging.log4j.core.config.builder.api.AppenderComponentBuilder;
import org.apache.logging.log4j.core.config.builder.api.ComponentBuilder;
import org.apache.logging.log4j.core.config.builder.api.ConfigurationBuilder;
import org.apache.logging.log4j.core.config.builder.api.ConfigurationBuilderFactory;
import org.apache.logging.log4j.core.config.builder.api.LayoutComponentBuilder;
import org.apache.logging.log4j.core.config.builder.api.LoggerComponentBuilder;
import org.apache.logging.log4j.core.config.builder.api.RootLoggerComponentBuilder;

public class ConcreteLogger
extends AbstractLogger {
    private static final String FPERCENT = "%7.1f, ";
    private static final String FSECONDS = "%25.5f, ";
    private static final String FLONG = "%25d, ";
    private static final String FNAME = "%50s, ";
    private static final String EXECUTION_TIME = "execution time: ";
    private static final String DASH = " - ";
    private static final String SUMMATIVE = "summative: ";
    private static final String LOG_FILE_NAME_FMT = "${sys:java.io.tmpdir}/%s";
    private static final String DESCRIPTION = "description: ";
    private static final String OR = " | ";
    private static final String TOTAL_BYTES = " | ";
    private static final String TOTAL_ROWS = "total rows: ";
    private static final String DASH_LSQUARE = " - [";
    private static final String RSQUARE_DASH = " - [";
    private static final String OR_LSQUARE = " | [";
    private static final String RSQUARE_OR = "] | ";
    private static final String METHOD_FMT = "%s %s";
    private static final String METHOD_OBJ_FMT = "%s %s";
    private static final String OBJECT_FMT = "%s [%s]";
    private static final String ENTRY_FMT = "%s entry";
    private static final String ENTRY_MSG_FMT = "%s entry";
    private static final String EXIT_FMT = "%s exit";
    private static final String EXIT_MSG_FMT = "%s exit";
    private static final String STATS_FMT = "%s %s %s";
    private static final int DEF_MSG_BUF = 4000;
    private static boolean debugInit = AbstractLogger.getDebugInitialization();
    public transient Logger logger;
    public ResourceBundle resourceBundle;

    protected static void outputLoggerSetup(Logger log) {
        if (!debugInit) {
            return;
        }
        Level l = log.getLevel();
        String s = String.format("Name[%s] Logger initialization End level:%s ", log.getName(), l);
        System.out.println(s);
    }

    protected ConcreteLogger(String loggerName) {
        this.logger = LogManager.getLogger((String)loggerName);
    }

    @Override
    public void debug(String msg) {
        this.logger.debug(msg);
    }

    public void debug(String method, Object message) {
        boolean isEnabled = this.logger.isEnabled(Level.INFO);
        if (isEnabled && !isTraceToNull) {
            this.logger.debug(method + message);
        }
    }

    @Override
    public void error(Object msg) {
        boolean isEnabled = this.logger.isEnabled(Level.INFO);
        if (isEnabled && !isTraceToNull) {
            this.logger.error(msg);
        }
    }

    @Override
    public void error(Object msg, Throwable t) {
        boolean isEnabled = this.logger.isEnabled(Level.INFO);
        if (isEnabled && !isTraceToNull) {
            this.logger.error(msg);
            ExceptionsLogger.logThrowable(t);
        }
    }

    @Override
    public void errorMethod(String method, Object message) {
        boolean isEnabled = this.logger.isEnabled(Level.INFO);
        if (isEnabled && !isTraceToNull) {
            String msg = String.format("%s %s", method, message);
            this.logger.error(msg);
        }
    }

    @Override
    public void info(Object msg) {
        boolean isEnabled = this.logger.isEnabled(Level.INFO);
        if (isEnabled && !isTraceToNull) {
            this.logger.info(msg);
        }
    }

    @Override
    public void info(Object msg, Throwable t) {
        boolean isEnabled = this.logger.isEnabled(Level.INFO);
        if (isEnabled && !isTraceToNull) {
            this.logger.info(msg, t);
        }
    }

    @Override
    public void info(String method, Object message) {
        boolean isEnabled = this.logger.isEnabled(Level.INFO);
        if (isEnabled && !isTraceToNull) {
            String msg = String.format("%s %s", method, message);
            this.logger.info(msg);
        }
    }

    @Override
    public void warn(Object msg) {
        boolean isEnabled = this.logger.isEnabled(Level.WARN);
        if (isEnabled && !isTraceToNull) {
            this.logger.warn(msg);
        }
    }

    public void warn(Object msg, Throwable t) {
        boolean isEnabled = this.logger.isEnabled(Level.INFO);
        if (isEnabled && !isTraceToNull) {
            this.logger.warn(msg, t);
        }
    }

    @Override
    public void warn(String method, Object message) {
        boolean isEnabled = this.logger.isEnabled(Level.INFO);
        if (isEnabled && !isTraceToNull) {
            String msg = String.format("%s %s", method, message);
            this.logger.warn(msg);
        }
    }

    @Override
    public void fatal(Object msg) {
        boolean isEnabled = this.logger.isEnabled(Level.INFO);
        if (isEnabled && !isTraceToNull) {
            this.logger.fatal(msg);
        }
    }

    @Override
    public void fatal(Object msg, Throwable t) {
        boolean isEnabled = this.logger.isEnabled(Level.INFO);
        if (isEnabled && !isTraceToNull) {
            this.logger.fatal(msg, t);
        }
    }

    @Override
    public void trace(Object msg) {
        boolean isEnabled = this.logger.isEnabled(Level.INFO);
        if (isEnabled && !isTraceToNull) {
            this.logger.trace(msg);
        }
    }

    @Override
    public void trace(Object msg, Throwable t) {
        boolean isEnabled = this.logger.isEnabled(Level.INFO);
        if (isEnabled && !isTraceToNull) {
            String lmsg = String.format(OBJECT_FMT, msg, t);
            this.logger.trace(lmsg);
        }
    }

    @Override
    public void trace(String method, Object msg) {
        boolean isEnabled = this.logger.isEnabled(Level.INFO);
        if (isEnabled && !isTraceToNull) {
            String lmsg = String.format("%s %s", method, msg);
            this.logger.trace(lmsg);
        }
    }

    @Override
    public void entry(String method) {
        boolean isEnabled = this.logger.isEnabled(Level.INFO);
        if (isEnabled && !isTraceToNull) {
            String lmsg = String.format("%s entry", method);
            this.logger.trace(lmsg);
        }
    }

    @Override
    public void entry(String method, Object msg) {
        boolean isEnabled = this.logger.isEnabled(Level.INFO);
        if (isEnabled && !isTraceToNull) {
            String lmsg = String.format("%s entry", method, msg);
            this.logger.trace(lmsg);
        }
    }

    @Override
    public void exit(String method) {
        boolean isEnabled = this.logger.isEnabled(Level.INFO);
        if (isEnabled && !isTraceToNull) {
            String lmsg = String.format("%s exit", method);
            this.logger.trace(lmsg);
        }
    }

    @Override
    public void exit(String method, Object msg) {
        boolean isEnabled = this.logger.isEnabled(Level.INFO);
        if (isEnabled && !isTraceToNull) {
            String lmsg = String.format("%s exit", method, msg);
            this.logger.trace(lmsg);
        }
    }

    @Override
    public Object getResourceBundle() {
        return this.resourceBundle;
    }

    @Override
    public void setResourceBundle(ResourceBundle resourceBundle) {
        this.resourceBundle = resourceBundle;
    }

    public void logStatisticsCommon(StatisticItem item, StringBuffer messageBuffer) {
        int mu = ConcreteLogger.getMeasurementsUnit();
        switch (mu) {
            case 0: {
                messageBuffer.append(EXECUTION_TIME);
                messageBuffer.append(item.getExecutionTime(0));
                messageBuffer.append("ns");
                messageBuffer.append(DASH);
                messageBuffer.append(SUMMATIVE);
                messageBuffer.append(item.getSummative(0));
                messageBuffer.append("ns");
                break;
            }
            case 1: {
                messageBuffer.append(EXECUTION_TIME);
                messageBuffer.append(item.getExecutionTime(1));
                messageBuffer.append("ms");
                messageBuffer.append(DASH);
                messageBuffer.append(SUMMATIVE);
                messageBuffer.append(item.getSummative(1));
                messageBuffer.append("ms");
                break;
            }
            case 2: {
                messageBuffer.append(EXECUTION_TIME);
                messageBuffer.append(item.getExecutionTime(2));
                messageBuffer.append("s");
                messageBuffer.append(DASH);
                messageBuffer.append(SUMMATIVE);
                messageBuffer.append(item.getSummative(2));
                messageBuffer.append("s");
                break;
            }
            case 3: {
                messageBuffer.append(EXECUTION_TIME);
                messageBuffer.append(item.getExecutionTime(3));
                messageBuffer.append("min");
                messageBuffer.append(DASH);
                messageBuffer.append(SUMMATIVE);
                messageBuffer.append(item.getSummative(3));
                messageBuffer.append("min");
                break;
            }
            default: {
                messageBuffer.append(EXECUTION_TIME);
                messageBuffer.append(item.getExecutionTime(0));
                messageBuffer.append("ns");
                messageBuffer.append(DASH);
                messageBuffer.append(SUMMATIVE);
                messageBuffer.append(item.getSummative(0));
                messageBuffer.append("ns");
            }
        }
    }

    @Override
    public void logStatistics(String className, StatisticItem item) {
        StringBuffer messageBuffer = new StringBuffer(4000);
        messageBuffer.append(" - [");
        messageBuffer.append(item.getCounter());
        messageBuffer.append(" - [");
        if (item.getDescription() != null) {
            messageBuffer.append(DESCRIPTION + item.getDescription());
            messageBuffer.append(DASH);
        }
        this.logStatisticsCommon(item, messageBuffer);
        boolean isEnabled = this.logger.isEnabled(Level.INFO);
        if (isEnabled && !isTraceToNull) {
            String lmsg = String.format(STATS_FMT, className, item.getName(), messageBuffer);
            this.logger.debug(lmsg);
        }
    }

    @Override
    public void logStatistics(StatisticItem item) {
        StringBuffer messageBuffer = new StringBuffer(4000);
        messageBuffer.append(OR_LSQUARE);
        messageBuffer.append(item.getCounter());
        messageBuffer.append(RSQUARE_OR);
        if (item.getDescription() != null) {
            messageBuffer.append(item.getDescription());
            messageBuffer.append(" | ");
        }
        this.logStatisticsCommon(item, messageBuffer);
        if (item.getTotalBytes() != 0L) {
            messageBuffer.append(" | ");
            messageBuffer.append(" | ");
            messageBuffer.append(item.getTotalBytes());
        }
        if (item.getTotalRows() != 0L) {
            messageBuffer.append(" | ");
            messageBuffer.append(TOTAL_ROWS);
            messageBuffer.append(item.getTotalRows());
        }
        this.debug(item.getName(), messageBuffer);
    }

    private static void testLoggerLevels(Logger logger) {
        if (!debugInit) {
            return;
        }
        String logName = logger.getName();
        logger.trace(logName + " test trace!");
        logger.debug(logName + " test debug!");
        logger.info(logName + " test info!");
        logger.warn(logName + " test warn!");
        logger.error(logName + " test error!");
        logger.fatal(logName + " test fatal!");
    }

    public static void initializeLogger() {
        block13: {
            String l;
            if (debugInit) {
                l = String.format("ConcreteLogger: initializeLogger", new Object[0]);
                System.out.println(l);
            }
            Level logLevel = AbstractLogger.isTrace ? Level.TRACE : (AbstractLogger.isDebug ? Level.DEBUG : (AbstractLogger.isInfo ? Level.INFO : (AbstractLogger.isWarn ? Level.WARN : (AbstractLogger.isError ? Level.ERROR : (AbstractLogger.isFatal ? Level.FATAL : (AbstractLogger.isOff ? Level.OFF : Level.OFF))))));
            if (debugInit) {
                l = String.format("ConcreteLogger: logLevel[%s]", logLevel);
                System.out.println(l);
            }
            String pattern = "%d [%-5p] [%-48c]  %m%n";
            String fileName = String.format(LOG_FILE_NAME_FMT, JDBC_LOG);
            try {
                String logHeader = "----- Federation Server JDBC Driver Log Initialization: ----- ";
                String xmlHeader = "Federation Server JDBC Driver Generated XML:";
                ConfigurationBuilder builder = ConfigurationBuilderFactory.newConfigurationBuilder();
                String immediateFlushKey = "immediateFlush";
                boolean flush = AbstractLogger.getFlush();
                String immediateFlushValue = flush ? "true" : "false";
                String measurementAppendValue = AbstractLogger.getMeasurementsAppend() ? "true" : "false";
                if (debugInit) {
                    l = String.format("ConcreteLogger: fileName[%s]  ", fileName);
                    System.out.println(l);
                }
                builder.setStatusLevel(Level.INFO);
                builder.setConfigurationName("FedServerJDBCRollingFileLogger");
                LayoutComponentBuilder layoutBuilder = builder.newLayout("PatternLayout");
                layoutBuilder.addAttribute("pattern", pattern);
                ComponentBuilder triggeringPolicy = builder.newComponent("Policies");
                triggeringPolicy.addComponent(builder.newComponent("SizeBasedTriggeringPolicy").addAttribute("size", "20000KB"));
                String appenderRollingFile = "FedSrvJDBCRollingFile";
                AppenderComponentBuilder appenderBuilder = builder.newAppender(appenderRollingFile, "RollingFile");
                appenderBuilder.addAttribute("fileName", fileName);
                appenderBuilder.addAttribute("filePattern", fileName + "-%d{MM-dd-yy-HH-mm-ss}.log.");
                appenderBuilder.addAttribute("bufferedIo", "true");
                appenderBuilder.addAttribute(immediateFlushKey, immediateFlushValue);
                appenderBuilder.add(layoutBuilder);
                appenderBuilder.addComponent(triggeringPolicy);
                builder.add(appenderBuilder);
                RootLoggerComponentBuilder rootLogger = builder.newRootLogger(logLevel);
                rootLogger.add(builder.newAppenderRef(appenderRollingFile));
                builder.add(rootLogger);
                LoggerComponentBuilder tktsLogger = builder.newLogger("com.sas.tkts", logLevel);
                tktsLogger.add(builder.newAppenderRef(appenderRollingFile));
                tktsLogger.addAttribute("additivity", false);
                builder.add(tktsLogger);
                Level tLogLevel = Level.INFO;
                if (logLevel == Level.OFF) {
                    tLogLevel = Level.OFF;
                }
                LoggerComponentBuilder initLogger = builder.newLogger("com.sas.tkts.init", logLevel);
                initLogger.add(builder.newAppenderRef(appenderRollingFile));
                initLogger.addAttribute("additivity", false);
                builder.add(initLogger);
                tLogLevel = Level.ERROR;
                if (logLevel == Level.OFF) {
                    tLogLevel = Level.OFF;
                }
                LoggerComponentBuilder sasLogger = builder.newLogger("com.sas", tLogLevel);
                sasLogger.add(builder.newAppenderRef(appenderRollingFile));
                sasLogger.addAttribute("additivity", false);
                builder.add(sasLogger);
                tLogLevel = Level.TRACE;
                if (logLevel == Level.OFF) {
                    tLogLevel = Level.OFF;
                }
                LoggerComponentBuilder pefetchLogger = builder.newLogger("com.sas.tkts.prefetch", tLogLevel);
                pefetchLogger.add(builder.newAppenderRef(appenderRollingFile));
                pefetchLogger.addAttribute("additivity", false);
                builder.add(pefetchLogger);
                tLogLevel = Level.WARN;
                if (AbstractLogger.measurementThreshold == 0) {
                    tLogLevel = Level.OFF;
                }
                LoggerComponentBuilder thresLogger = builder.newLogger("com.sas.tkts.thresholds", tLogLevel);
                thresLogger.add(builder.newAppenderRef(appenderRollingFile));
                thresLogger.addAttribute("additivity", false);
                builder.add(thresLogger);
                fileName = String.format(LOG_FILE_NAME_FMT, JDBC_MEASUREMENTS_LOG);
                if (debugInit) {
                    l = String.format("ConcreteLogger: fileName[%s]  ", fileName);
                    System.out.println(l);
                }
                builder.setStatusLevel(Level.INFO);
                builder.setConfigurationName("FedServerJDBCMeasurementsFileLogger");
                String measPattern = "%d [%-5p]  %m%n";
                LayoutComponentBuilder measLayoutBuilder = builder.newLayout("PatternLayout");
                measLayoutBuilder.addAttribute("pattern", measPattern);
                String appenderFile = "FedSrvJDBCFile";
                AppenderComponentBuilder appenderBuilderFile = builder.newAppender(appenderFile, "File");
                appenderBuilderFile.addAttribute("fileName", fileName);
                appenderBuilderFile.addAttribute("bufferedIo", "true");
                appenderBuilder.addAttribute(immediateFlushKey, immediateFlushValue);
                appenderBuilderFile.addAttribute("append", measurementAppendValue);
                appenderBuilderFile.add(measLayoutBuilder);
                builder.add(appenderBuilderFile);
                tLogLevel = Level.OFF;
                if (AbstractLogger.isMeasurements) {
                    tLogLevel = Level.DEBUG;
                }
                LoggerComponentBuilder measLogger = builder.newLogger("com.sas.tkts.measurements", tLogLevel);
                measLogger.add(builder.newAppenderRef(appenderFile));
                measLogger.addAttribute("additivity", false);
                builder.add(measLogger);
                Configurator.reconfigure((Configuration)((Configuration)builder.build()));
                ByteArrayOutputStream outStream = new ByteArrayOutputStream(20000);
                builder.writeXmlConfiguration((OutputStream)outStream);
                String xmlStr = outStream.toString();
                Logger outLogger = LogManager.getLogger((String)"com.sas.tkts.init");
                outLogger.info("");
                outLogger.info(logHeader);
                outLogger.info(xmlHeader);
                outLogger.info(xmlStr);
                outLogger = LogManager.getLogger((String)"com.sas.tkts.measurements");
                outLogger.info("");
                outLogger.info(logHeader);
                if (debugInit) {
                    System.out.println(xmlHeader);
                    System.out.println(xmlStr);
                }
            }
            catch (Exception e) {
                if (!debugInit) break block13;
                System.out.println("");
                System.out.println("ConcreteLogger: initializeLogger Exception:");
                System.out.println(e);
                System.out.println("");
            }
        }
        if (debugInit) {
            LoggerFactory.displayCurrentLoggers();
            Logger outLogger = LogManager.getLogger((String)"com.sas.tkts");
            ConcreteLogger.outputLoggerSetup(outLogger);
            ConcreteLogger.testLoggerLevels(outLogger);
            outLogger = LogManager.getLogger((String)"com.sas.tkts.init");
            ConcreteLogger.outputLoggerSetup(outLogger);
            ConcreteLogger.testLoggerLevels(outLogger);
            outLogger = LogManager.getLogger((String)"com.sas");
            ConcreteLogger.outputLoggerSetup(outLogger);
            ConcreteLogger.testLoggerLevels(outLogger);
            outLogger = LogManager.getLogger((String)"com.sas.tkts.prefetch");
            ConcreteLogger.outputLoggerSetup(outLogger);
            ConcreteLogger.testLoggerLevels(outLogger);
            outLogger = LogManager.getLogger((String)"com.sas.tkts.measurements");
            ConcreteLogger.outputLoggerSetup(outLogger);
            ConcreteLogger.testLoggerLevels(outLogger);
            outLogger = LogManager.getLogger((String)"com.sas.tkts.thresholds");
            ConcreteLogger.outputLoggerSetup(outLogger);
            ConcreteLogger.testLoggerLevels(outLogger);
        }
    }

    @Override
    public void logOverallStatistics(StatisticItem item) {
        StringBuffer messageBuffer = new StringBuffer();
        String formatedItem = String.format(FLONG, item.getCounter());
        messageBuffer.append(formatedItem);
        formatedItem = String.format(FPERCENT, item.getPercent());
        messageBuffer.append(formatedItem);
        double tDbl = item.getSummattive();
        formatedItem = String.format(FSECONDS, tDbl /= 1.0E9);
        messageBuffer.append(formatedItem);
        tDbl = item.getAverage();
        formatedItem = String.format(FSECONDS, tDbl /= 1.0E9);
        messageBuffer.append(formatedItem);
        formatedItem = String.format(FLONG, item.getTotalBytes());
        messageBuffer.append(formatedItem);
        formatedItem = String.format(FLONG, item.getTotalRows());
        messageBuffer.append(formatedItem);
        formatedItem = String.format(FNAME, item.getName());
        if (item.getExcludeFromTotals()) {
            messageBuffer.append(StatisticsBoard.getOmit());
        }
        this.info(formatedItem, messageBuffer);
    }

    @Override
    public void logOverallStatisticsTotals(String name, long totalCount, double totalPercent, double totalTime, double totalAverage, long totalBytes, long totalRows) {
        StringBuffer messageBuffer = new StringBuffer();
        String formatedItem = String.format(FLONG, totalCount);
        messageBuffer.append(formatedItem);
        formatedItem = String.format(FPERCENT, totalPercent);
        messageBuffer.append(formatedItem);
        double tDbl = totalTime;
        formatedItem = String.format(FSECONDS, tDbl /= 1.0E9);
        messageBuffer.append(formatedItem);
        tDbl = totalAverage;
        formatedItem = String.format(FSECONDS, tDbl /= 1.0E9);
        messageBuffer.append(formatedItem);
        formatedItem = String.format(FLONG, totalBytes);
        messageBuffer.append(formatedItem);
        formatedItem = String.format(FLONG, totalRows);
        messageBuffer.append(formatedItem);
        formatedItem = String.format(FNAME, name);
        this.info(formatedItem, messageBuffer);
    }

    public String toString() {
        String outStr = this.logger.toString();
        return outStr;
    }

    static {
        if (debugInit) {
            System.out.println("ConcreteLogger initialization");
        }
    }
}

