/*
 * Decompiled with CFR 0.152.
 */
package com.sas.tkts.iom;

import com.sas.SASTableServer.IConnection;
import com.sas.SASTableServer.IStatement;
import com.sas.SASTableServer.IStatement_1_1;
import com.sas.SASTableServer.IStatement_1_1Helper;
import com.sas.SASTableServer.IStatement_1_2;
import com.sas.SASTableServer.IStatement_1_2Helper;
import com.sas.SASTableServer.TKTS_ERROR;
import com.sas.SASTableServer.TKTS_INVALID_HANDLE;
import com.sas.SASTableServer.TKTS_NEED_DATA;
import com.sas.SASTableServer.TKTS_NO_DATA;
import com.sas.SASTableServer.TKTS_STILL_EXECUTING;
import com.sas.iom.SASIOMDefs.AnySeqHolder;
import com.sas.iom.SASIOMDefs.GenericError;
import com.sas.iom.SASIOMDefs.LongLongSeqHolder;
import com.sas.iom.SASIOMDefs.LongSeqHolder;
import com.sas.iom.SASIOMDefs.OctetSeqHolder;
import com.sas.iom.SASIOMDefs.StringSeqHolder;
import com.sas.iom.SASIOMDefs.VariableArray2dOfLongHolder;
import com.sas.tkts.TrackResource;
import com.sas.tkts.iom.AbstractIOMWrapper;
import com.sas.tkts.iom.ConnectionWrapper;
import com.sas.tkts.logging.AbstractLogger;
import com.sas.tkts.logging.CommonLogger;
import com.sas.tkts.logging.LoggerFactory;
import com.sas.tkts.sql.FSConnection;
import com.sas.tkts.sql.FSStatement;
import com.sas.tkts.sql.LocalizedErrorHandler;
import com.sas.tkts.sql.LocalizedMessageHandler;
import com.sas.tkts.util.CharSetUtil;
import com.sas.tkts.util.TypesHelper;
import java.sql.SQLException;
import java.sql.SQLWarning;
import org.omg.CORBA.Any;
import org.omg.CORBA.AnyHolder;
import org.omg.CORBA.IntHolder;
import org.omg.CORBA.LongHolder;
import org.omg.CORBA.ORB;

public class StatementWrapper
extends AbstractIOMWrapper {
    private static String thisClassName = StatementWrapper.class.getName();
    private static AbstractLogger logger = LoggerFactory.getLogger(thisClassName);
    protected static boolean trackStatementWrapper = false;
    protected static TrackResource myResources;
    private static String OPEN1;
    private static String OPEN2;
    private static String CLOSED;
    private static String CREATE_ISTMT;
    private static String HANDLE_ERROR;
    private static String STATS_BINDCOLS;
    private static String STATS_BULKOPS;
    private static String STATS_CANCEL;
    private static String STATS_CLOSE;
    private static String STATS_CLOSECURSOR;
    private static String STATS_COLATTR;
    private static String STATS_COLATTRFLAT;
    private static String STATS_COLPRIV;
    private static String STATS_COLUMNS;
    private static String STATS_COLSTATS;
    private static final String COLUMN_QUALIFIERS = "catalogName=%s schemaName=%s tableName=%s columnName=%s";
    private transient FSStatement fsStatement;
    private transient FSConnection fsConnection;
    private transient IStatement iomStatementHandle;
    private transient IStatement_1_1 iomStatementHandle_1_1;
    private transient IStatement_1_2 iomStatementHandle_1_2;
    private transient ConnectionWrapper connectionWrapper;
    protected transient boolean isOpen = true;
    protected transient boolean lobPosition;
    public transient String debugStr;

    private String getStatus(int tktsStatus) {
        String format = "status[%s]";
        String out = String.format("status[%s]", TypesHelper.getTktsStatus(tktsStatus));
        return out;
    }

    private String getNumberColumns(int numberCols) {
        String format = "numberColumns[%d]";
        String out = String.format("numberColumns[%d]", numberCols);
        return out;
    }

    protected void logLongSeqWarnings(LongSeqHolder status, int numberEntries) {
        String method = "logLongSeqWarnings(status,numberEntries)";
        boolean foundWarnings = false;
        for (int i = 0; i < numberEntries; ++i) {
            int tktsStatus = status.value[i];
            if (tktsStatus == 0) continue;
            foundWarnings = true;
            if (!AbstractLogger.isWarn) continue;
            logger.warn("logLongSeqWarnings(status,numberEntries)", this.getStatus(tktsStatus));
        }
        if (foundWarnings) {
            SQLWarning sw = LocalizedErrorHandler.createLocalizedWarnnigs(this);
            CommonLogger.logSQLWarnings(logger, sw);
        }
    }

    protected void logIntHolderWarnings(IntHolder status) {
        if (status.value == -2130708479) {
            SQLWarning sw = LocalizedErrorHandler.createLocalizedWarnnigs(this);
            CommonLogger.logSQLWarnings(logger, sw);
        }
    }

    private String trackString() {
        String tFormat = "SW_ID:%d:STMT_ID:%d:CONN_ID:%d";
        long stmtID = this.fsStatement == null ? 0L : this.fsStatement.getMyID();
        long connID = this.fsConnection == null ? -1L : this.fsConnection.getMyID();
        String out = String.format("SW_ID:%d:STMT_ID:%d:CONN_ID:%d", this.getMyID(), stmtID, connID);
        return out;
    }

    public StatementWrapper(FSStatement stmtObj) throws SQLException {
        this.fsStatement = stmtObj;
        this.fsConnection = stmtObj.getFSConnection();
        this.connectionWrapper = ((FSConnection)this.fsStatement.getConnection()).getConnectionWrapper();
        this.debugStr = OPEN1;
        this.createIStatement();
        this.setEncoding();
        this.lobPosition = true;
        if (trackStatementWrapper) {
            myResources.track(this, this.trackString());
        }
    }

    public StatementWrapper(ConnectionWrapper connWrapper) throws SQLException {
        this.fsStatement = null;
        this.connectionWrapper = connWrapper;
        this.fsConnection = this.connectionWrapper.getFSConnection();
        this.debugStr = OPEN2;
        this.createIStatement();
        this.setEncoding();
        if (trackStatementWrapper) {
            myResources.track(this, this.trackString());
        }
    }

    private void createIStatement() throws SQLException {
        String method = "createIStatement()";
        if (AbstractLogger.isTrace) {
            logger.entry("createIStatement()", CREATE_ISTMT);
        }
        try {
            this.iomStatementHandle = this.connectionWrapper.CreateStatement(new IntHolder());
            this.iomStatementHandle_1_2 = IStatement_1_2Helper.narrow(this.iomStatementHandle);
            if (this.iomStatementHandle_1_2 != null) {
                this.iomStatementHandle_1_1 = IStatement_1_1Helper.narrow(this.iomStatementHandle);
            }
        }
        catch (Exception e) {
            LocalizedErrorHandler.throwLocalizedException(HANDLE_ERROR, null, e, this.connectionWrapper, logger);
        }
    }

    private void setEncoding() throws SQLException {
        int transportEncoding = CharSetUtil.getToServerEncoding();
        int status = AbstractIOMWrapper.setIntegerAttribute(this, 20012, transportEncoding, true);
        if (status != 0) {
            String ei = "TKTSStatement.charCeiUTFError.fmt";
            this.throwException("TKTSStatement.charCeiUTFError.fmt", logger, Integer.toString(status));
        }
    }

    @Override
    public ORB getORBHandle() {
        if (this.connectionWrapper == null) {
            return null;
        }
        return this.connectionWrapper.getORBHandle();
    }

    public ConnectionWrapper getConnectionWrapper() {
        return this.connectionWrapper;
    }

    @Override
    public void createWarning(SQLWarning warning) {
        if (this.fsStatement != null) {
            this.fsStatement.addWarning(warning);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long Id() {
        long i;
        IStatement iStatement = this.iomStatementHandle;
        synchronized (iStatement) {
            i = this.iomStatementHandle.Id();
        }
        return i;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IConnection Parent() {
        IStatement iStatement = this.iomStatementHandle;
        synchronized (iStatement) {
            return this.iomStatementHandle.Parent();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void BindCols(int[] columnNumbers, int[] targetTypes, String[] formatNames, int[] columnWidths, int[] bindTypes, LongSeqHolder status, IntHolder bmgrStatus) throws TKTS_ERROR, TKTS_INVALID_HANDLE, GenericError {
        String method = "BindCols";
        long entryTime = 0L;
        if (AbstractLogger.isMeasurements) {
            entryTime = System.nanoTime();
        }
        if (AbstractLogger.isTrace) {
            logger.entry("BindCols", this.getNumberColumns(columnNumbers.length));
        }
        if (this.fsStatement != null) {
            this.fsStatement.setColumnsBound(true);
        }
        IStatement iStatement = this.iomStatementHandle;
        synchronized (iStatement) {
            this.iomStatementHandle.BindCols(columnNumbers, targetTypes, formatNames, columnWidths, bindTypes, status, bmgrStatus);
        }
        if (AbstractLogger.isMeasurements) {
            long delta = System.nanoTime() - entryTime;
            LocalizedMessageHandler.logStatisticMessage(STATS_BINDCOLS, delta, logger);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void BulkOpsAdd(Any[] values, int[][] lenOrInd, AnySeqHolder bookmarks, LongSeqHolder bookmarksLenOrInd, OctetSeqHolder rowStatus, IntHolder rowsAffected, IntHolder status) throws TKTS_ERROR, TKTS_INVALID_HANDLE, TKTS_NEED_DATA, TKTS_STILL_EXECUTING, GenericError {
        String method = "BulkOpsAdd";
        long entryTime = 0L;
        if (AbstractLogger.isMeasurements) {
            entryTime = System.nanoTime();
        }
        if (AbstractLogger.isTrace) {
            logger.entry("BulkOpsAdd");
        }
        IStatement iStatement = this.iomStatementHandle;
        synchronized (iStatement) {
            this.iomStatementHandle.BulkOpsAdd(values, lenOrInd, bookmarks, bookmarksLenOrInd, rowStatus, rowsAffected, status);
        }
        if (AbstractLogger.isMeasurements) {
            long delta = System.nanoTime() - entryTime;
            LocalizedMessageHandler.logStatisticMessage(STATS_BULKOPS, delta, logger);
        }
    }

    public void Cancel(IntHolder status) throws TKTS_ERROR, TKTS_INVALID_HANDLE, GenericError {
        long entryTime = 0L;
        String method = "Cancel";
        if (AbstractLogger.isMeasurements) {
            entryTime = System.nanoTime();
        }
        if (AbstractLogger.isTrace) {
            logger.entry("Cancel");
        }
        this.iomStatementHandle.Cancel(status);
        if (AbstractLogger.isMeasurements) {
            long delta = System.nanoTime() - entryTime;
            LocalizedMessageHandler.logStatisticMessage(STATS_CANCEL, delta, logger);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void Close() throws TKTS_ERROR, TKTS_INVALID_HANDLE, GenericError {
        String method = "Close";
        long entryTime = 0L;
        if (AbstractLogger.isTrace) {
            logger.entry("Close");
        }
        if (this.isOpen) {
            this.debugStr = CLOSED;
            if (AbstractLogger.isMeasurements) {
                entryTime = System.nanoTime();
            }
            this.isOpen = false;
            IStatement iStatement = this.iomStatementHandle;
            synchronized (iStatement) {
                this.iomStatementHandle.Close();
            }
            if (AbstractLogger.isMeasurements) {
                long delta = System.nanoTime() - entryTime;
                LocalizedMessageHandler.logStatisticMessage(STATS_CLOSE, delta, logger);
            }
            if (trackStatementWrapper) {
                myResources.untrack(this);
            }
        }
        this.releaseOutgoingResources();
    }

    public void releaseOutgoingResources() {
        this.fsStatement = null;
        this.fsConnection = null;
        this.iomStatementHandle = null;
        this.iomStatementHandle_1_1 = null;
        this.iomStatementHandle_1_2 = null;
        this.connectionWrapper = null;
        this.debugStr = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void CloseCursor(IntHolder status) throws TKTS_ERROR, TKTS_INVALID_HANDLE, GenericError {
        String method = "CloseCursor";
        long entryTime = 0L;
        if (AbstractLogger.isTrace) {
            logger.entry("CloseCursor");
        }
        if (this.fsStatement != null) {
            this.fsStatement.setCursorOpen(false);
        }
        if (AbstractLogger.isMeasurements) {
            entryTime = System.nanoTime();
        }
        IStatement iStatement = this.iomStatementHandle;
        synchronized (iStatement) {
            this.iomStatementHandle.CloseCursor(status);
        }
        if (AbstractLogger.isMeasurements) {
            long delta = System.nanoTime() - entryTime;
            LocalizedMessageHandler.logStatisticMessage(STATS_CLOSECURSOR, delta, logger);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void ColAttributes(int[] columnNumbers, int[] fieldIdentifiers, int[] fieldIndicators, AnySeqHolder attrValues, VariableArray2dOfLongHolder attrStatus, IntHolder status) throws TKTS_ERROR, TKTS_INVALID_HANDLE, TKTS_STILL_EXECUTING, GenericError {
        String method = "ColAttributes)";
        long entryTime = 0L;
        if (AbstractLogger.isTrace) {
            logger.entry("ColAttributes)");
        }
        if (AbstractLogger.isMeasurements) {
            entryTime = System.nanoTime();
        }
        IStatement iStatement = this.iomStatementHandle;
        synchronized (iStatement) {
            this.iomStatementHandle.ColAttributes(columnNumbers, fieldIdentifiers, fieldIndicators, attrValues, attrStatus, status);
        }
        if (AbstractLogger.isMeasurements) {
            long delta = System.nanoTime() - entryTime;
            LocalizedMessageHandler.logStatisticMessage(STATS_COLATTR, delta, logger);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void ColAttributesFlat(int[] columnNumbers, int[] fieldIdentifiers, int[] fieldIndicators, AnySeqHolder attrValues, LongSeqHolder attrStatus, IntHolder status) throws TKTS_ERROR, TKTS_INVALID_HANDLE, TKTS_STILL_EXECUTING, GenericError {
        String method = "ColAttributesFlat";
        long entryTime = 0L;
        if (AbstractLogger.isTrace) {
            logger.trace("ColAttributesFlat");
        }
        if (AbstractLogger.isMeasurements) {
            entryTime = System.nanoTime();
        }
        IStatement iStatement = this.iomStatementHandle;
        synchronized (iStatement) {
            this.iomStatementHandle.ColAttributesFlat(columnNumbers, fieldIdentifiers, fieldIndicators, attrValues, attrStatus, status);
        }
        if (AbstractLogger.isMeasurements) {
            long delta = System.nanoTime() - entryTime;
            LocalizedMessageHandler.logStatisticMessage(STATS_COLATTRFLAT, delta, logger);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void ColumnPrivileges(String catalogName, String schemaName, String tableName, String columnName, IntHolder status) throws TKTS_ERROR, TKTS_INVALID_HANDLE, TKTS_STILL_EXECUTING, GenericError {
        String method = "ColumnPrivileges";
        long entryTime = 0L;
        if (AbstractLogger.isTrace) {
            String tStr = String.format(COLUMN_QUALIFIERS, catalogName, schemaName, tableName, columnName);
            logger.entry("ColumnPrivileges", tStr);
        }
        if (AbstractLogger.isMeasurements) {
            entryTime = System.nanoTime();
        }
        IStatement iStatement = this.iomStatementHandle;
        synchronized (iStatement) {
            this.iomStatementHandle.ColumnPrivileges(catalogName, schemaName, tableName, columnName, status);
        }
        if (AbstractLogger.isMeasurements) {
            long delta = System.nanoTime() - entryTime;
            LocalizedMessageHandler.logStatisticMessage(STATS_COLPRIV, delta, logger);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void Columns(String catalogName, String schemaName, String tableName, String columnName, IntHolder status) throws TKTS_ERROR, TKTS_INVALID_HANDLE, TKTS_STILL_EXECUTING, GenericError {
        long entryTime = 0L;
        String method = "Columns";
        if (AbstractLogger.isTrace) {
            String tStr = String.format(COLUMN_QUALIFIERS, catalogName, schemaName, tableName, columnName);
            logger.entry("Columns", tStr);
        }
        if (AbstractLogger.isMeasurements) {
            entryTime = System.nanoTime();
        }
        IStatement iStatement = this.iomStatementHandle;
        synchronized (iStatement) {
            this.iomStatementHandle.Columns(catalogName, schemaName, tableName, columnName, status);
        }
        if (AbstractLogger.isMeasurements) {
            long delta = System.nanoTime() - entryTime;
            LocalizedMessageHandler.logStatisticMessage(STATS_COLUMNS, delta, logger);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void ColumnStatistics(String catalogName, String schemaName, String tableName, String[] columns, int flags, int reserved, IntHolder status) throws TKTS_ERROR, TKTS_INVALID_HANDLE, TKTS_STILL_EXECUTING, GenericError {
        String method = "ColumnStatistics";
        long entryTime = 0L;
        if (AbstractLogger.isTrace) {
            String tStr = String.format(COLUMN_QUALIFIERS, catalogName, schemaName, tableName, "");
            logger.entry("ColumnStatistics", tStr);
        }
        if (AbstractLogger.isMeasurements) {
            entryTime = System.nanoTime();
        }
        IStatement iStatement = this.iomStatementHandle;
        synchronized (iStatement) {
            this.iomStatementHandle.ColumnStatistics(catalogName, schemaName, tableName, columns, flags, reserved, status);
        }
        if (AbstractLogger.isMeasurements) {
            long delta = System.nanoTime() - entryTime;
            LocalizedMessageHandler.logStatisticMessage(STATS_COLSTATS, delta, logger);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void DeleteByBookmark(Any[] bookmarks, int[] bookmarksLenOrInd, OctetSeqHolder rowStatus, IntHolder rowsAffected, IntHolder status) throws TKTS_ERROR, TKTS_INVALID_HANDLE, TKTS_NEED_DATA, TKTS_STILL_EXECUTING, GenericError {
        String method = "DeleteByBookmark";
        long entryTime = 0L;
        if (AbstractLogger.isTrace) {
            logger.trace("DeleteByBookmark", "Calling delete by bookmark.");
        }
        if (AbstractLogger.isMeasurements) {
            entryTime = System.nanoTime();
        }
        IStatement iStatement = this.iomStatementHandle;
        synchronized (iStatement) {
            this.iomStatementHandle.DeleteByBookmark(bookmarks, bookmarksLenOrInd, rowStatus, rowsAffected, status);
        }
        if (AbstractLogger.isMeasurements) {
            long delta = System.nanoTime() - entryTime;
            LocalizedMessageHandler.logStatisticMessage("StatementWrapper.apiDeleteByBookmark.txt", delta, logger);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void DescribeCols(int[] columnNumbers, StringSeqHolder columnNames, LongSeqHolder dataTypes, LongLongSeqHolder columnSizes, LongSeqHolder decimalDigits, LongSeqHolder nullables, LongSeqHolder status) throws TKTS_ERROR, TKTS_INVALID_HANDLE, TKTS_STILL_EXECUTING, GenericError {
        String method = "DescribeCols(columnNumbers,columnNames,dataTypes,columnSizes,decimalDigits,nullables,status)";
        long entryTime = 0L;
        if (AbstractLogger.isTrace) {
            logger.entry("DescribeCols(columnNumbers,columnNames,dataTypes,columnSizes,decimalDigits,nullables,status)", "Calling describe columns.");
        }
        if (AbstractLogger.isMeasurements) {
            entryTime = System.nanoTime();
        }
        IStatement iStatement = this.iomStatementHandle;
        synchronized (iStatement) {
            this.iomStatementHandle.DescribeCols(columnNumbers, columnNames, dataTypes, columnSizes, decimalDigits, nullables, status);
        }
        if (AbstractLogger.isTrace) {
            this.logLongSeqWarnings(status, columnNumbers.length);
        }
        if (AbstractLogger.isMeasurements) {
            long delta = System.nanoTime() - entryTime;
            LocalizedMessageHandler.logStatisticMessage("StatementWrapper.apiDescribeCols.txt", delta, logger);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void DescribeParam(int parameterNumber, IntHolder dataType, LongHolder parameterSize, IntHolder decimalDigits, IntHolder nullable, IntHolder status) throws TKTS_ERROR, TKTS_INVALID_HANDLE, TKTS_STILL_EXECUTING, GenericError {
        String method = "DescribeParam(parameterNumber,dataType,parameterSize,decimalDigits,nullable,status)";
        long entryTime = 0L;
        if (AbstractLogger.isTrace) {
            logger.entry("DescribeParam(parameterNumber,dataType,parameterSize,decimalDigits,nullable,status)", "parameterNumber=" + parameterNumber);
        }
        if (AbstractLogger.isMeasurements) {
            entryTime = System.nanoTime();
        }
        IStatement iStatement = this.iomStatementHandle;
        synchronized (iStatement) {
            this.iomStatementHandle.DescribeParam(parameterNumber, dataType, parameterSize, decimalDigits, nullable, status);
        }
        if (AbstractLogger.isMeasurements) {
            long delta = System.nanoTime() - entryTime;
            LocalizedMessageHandler.logStatisticMessage("StatementWrapper.apiDescribeParam.txt", delta, logger);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void DescribeParams(int[] parameterNumbers, LongSeqHolder dataTypes, LongLongSeqHolder parameterSizes, LongSeqHolder decimalDigits, LongSeqHolder nullables, LongSeqHolder status) throws TKTS_ERROR, TKTS_INVALID_HANDLE, GenericError {
        String method = "DescribeParams(parameterNumbers,dataTypes,parameterSizes,decimalDigits,nullables,status)";
        long entryTime = 0L;
        if (AbstractLogger.isTrace) {
            logger.entry("DescribeParams(parameterNumbers,dataTypes,parameterSizes,decimalDigits,nullables,status)", "parameterNumbers=" + parameterNumbers.length);
        }
        if (AbstractLogger.isMeasurements) {
            entryTime = System.nanoTime();
        }
        IStatement iStatement = this.iomStatementHandle;
        synchronized (iStatement) {
            this.iomStatementHandle.DescribeParams(parameterNumbers, dataTypes, parameterSizes, decimalDigits, nullables, status);
        }
        if (AbstractLogger.isTrace) {
            this.logLongSeqWarnings(status, parameterNumbers.length);
        }
        if (AbstractLogger.isMeasurements) {
            long delta = System.nanoTime() - entryTime;
            LocalizedMessageHandler.logStatisticMessage("StatementWrapper.apiDescribeParams.txt", delta, logger);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void ExecDirect(String statementText, Any[] inParameters, int[][] inLenOrInd, AnySeqHolder outParameters, VariableArray2dOfLongHolder outLenOrInd, IntHolder paramsProcessed, OctetSeqHolder paramStatus, IntHolder status) throws TKTS_ERROR, TKTS_INVALID_HANDLE, TKTS_NO_DATA, TKTS_STILL_EXECUTING, GenericError {
        String method = "ExecDirect(statementText,inParameters,inLenOrInd,outParameters,outLenOrInd,paramsProcessed,paramStatus,status)";
        long entryTime = 0L;
        if (AbstractLogger.isTrace) {
            logger.entry("ExecDirect(statementText,inParameters,inLenOrInd,outParameters,outLenOrInd,paramsProcessed,paramStatus,status)", "statementText=" + statementText);
        }
        if (AbstractLogger.isMeasurements) {
            entryTime = System.nanoTime();
        }
        IStatement iStatement = this.iomStatementHandle;
        synchronized (iStatement) {
            this.iomStatementHandle.ExecDirect(statementText, inParameters, inLenOrInd, new int[0], outParameters, outLenOrInd, paramsProcessed, paramStatus, status);
        }
        if (AbstractLogger.isMeasurements) {
            long delta = System.nanoTime() - entryTime;
            LocalizedMessageHandler.logStatisticMessage("StatementWrapper.apiExecDirect.txt", delta, logger);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void ExecuteWithRowCount(Any[] inParameters, int[][] inLenOrInd, AnySeqHolder outParameters, VariableArray2dOfLongHolder outLenOrInd, IntHolder paramsProcessed, OctetSeqHolder paramStatus, LongHolder rowCount) throws TKTS_ERROR, TKTS_INVALID_HANDLE, TKTS_NO_DATA, TKTS_STILL_EXECUTING, GenericError {
        String method = "ExecuteWithRowCount(inParameters,inLenOrInd,outParameters,outLenOrInd,paramsProcessed,paramStatus,rowCount)";
        long entryTime = 0L;
        if (AbstractLogger.isTrace) {
            logger.trace("ExecuteWithRowCount(inParameters,inLenOrInd,outParameters,outLenOrInd,paramsProcessed,paramStatus,rowCount)", "Execute with rowCount");
        }
        if (AbstractLogger.isMeasurements) {
            entryTime = System.nanoTime();
        }
        IStatement iStatement = this.iomStatementHandle;
        synchronized (iStatement) {
            this.iomStatementHandle.ExecuteWithRowCount(inParameters, inLenOrInd, new int[0], outParameters, outLenOrInd, paramsProcessed, paramStatus, rowCount);
        }
        if (AbstractLogger.isMeasurements) {
            long delta = System.nanoTime() - entryTime;
            LocalizedMessageHandler.logStatisticMessage("StatementWrapper.apiExecuteWithRowCount.txt", delta, logger);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void Fetch(AnySeqHolder values, VariableArray2dOfLongHolder lenOrInd, OctetSeqHolder rowStatus, IntHolder status) throws TKTS_ERROR, TKTS_INVALID_HANDLE, TKTS_NO_DATA, TKTS_STILL_EXECUTING, GenericError {
        String method = "Fetch(values,lenOrInd,rowStatus,status)";
        long entryTime = 0L;
        if (AbstractLogger.isTrace) {
            logger.entry("Fetch(values,lenOrInd,rowStatus,status)", "Calling fetch.");
        }
        if (AbstractLogger.isMeasurements) {
            entryTime = System.nanoTime();
        }
        IStatement iStatement = this.iomStatementHandle;
        synchronized (iStatement) {
            this.iomStatementHandle.Fetch(values, lenOrInd, rowStatus, status);
        }
        if (AbstractLogger.isMeasurements) {
            long delta = System.nanoTime() - entryTime;
            LocalizedMessageHandler.logStatisticMessage("StatementWrapper.apiFetch.txt", delta, logger);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void FetchByBookmark(Any[] bookmarks, int[] bookmarksLenOrInd, AnySeqHolder values, VariableArray2dOfLongHolder lenOrInd, OctetSeqHolder rowStatus, IntHolder status) throws TKTS_ERROR, TKTS_INVALID_HANDLE, TKTS_NEED_DATA, TKTS_STILL_EXECUTING, GenericError {
        String method = "FetchByBookmark(bookmarks,bookmarksLenOrInd,values,lenOrInd,rowStatus,status)";
        long entryTime = 0L;
        if (AbstractLogger.isTrace) {
            logger.entry("FetchByBookmark(bookmarks,bookmarksLenOrInd,values,lenOrInd,rowStatus,status)", "Calling fetch by bookmark.");
        }
        if (AbstractLogger.isMeasurements) {
            entryTime = System.nanoTime();
        }
        IStatement iStatement = this.iomStatementHandle;
        synchronized (iStatement) {
            this.iomStatementHandle.FetchByBookmark(bookmarks, bookmarksLenOrInd, values, lenOrInd, rowStatus, status);
        }
        if (AbstractLogger.isMeasurements) {
            long delta = System.nanoTime() - entryTime;
            LocalizedMessageHandler.logStatisticMessage("StatementWrapper.apiFetchByBookmark.txt", delta, logger);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void ForeignKeys(String pkCatalogName, String pkSchemaName, String pkTableName, String fkCatalogName, String fkSchemaName, String fkTableName, IntHolder status) throws TKTS_ERROR, TKTS_INVALID_HANDLE, TKTS_STILL_EXECUTING, GenericError {
        String method = "ForeignKeys(pkCatalogName,pkSchemaName,pkTableName,fkCatalogName,fkSchemaName,fkTableName,status)";
        long entryTime = 0L;
        if (AbstractLogger.isTrace) {
            logger.entry("ForeignKeys(pkCatalogName,pkSchemaName,pkTableName,fkCatalogName,fkSchemaName,fkTableName,status)", "pkCatalogName=" + pkCatalogName + " pkSchemaName=" + pkSchemaName + " pkTableName=" + pkTableName + " fkCatalogName=" + fkCatalogName + " fkSchemaName=" + fkSchemaName + " fkTableName=" + fkTableName);
        }
        if (AbstractLogger.isMeasurements) {
            entryTime = System.nanoTime();
        }
        IStatement iStatement = this.iomStatementHandle;
        synchronized (iStatement) {
            this.iomStatementHandle.ForeignKeys(pkCatalogName, pkSchemaName, pkTableName, fkCatalogName, fkSchemaName, fkTableName, status);
        }
        if (AbstractLogger.isMeasurements) {
            long delta = System.nanoTime() - entryTime;
            LocalizedMessageHandler.logStatisticMessage("StatementWrapper.apiForeignKeys.txt", delta, logger);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void FreeStmt(int option, IntHolder status) throws GenericError {
        String method = "FreeStmt(option,status)";
        long entryTime = 0L;
        if (AbstractLogger.isTrace) {
            logger.entry("FreeStmt(option,status)", "Calling free statement.");
        }
        if (AbstractLogger.isMeasurements) {
            entryTime = System.nanoTime();
        }
        IStatement iStatement = this.iomStatementHandle;
        synchronized (iStatement) {
            this.iomStatementHandle.FreeStmt(option, status);
        }
        this.fsStatement.updateStates(option, false);
        if (AbstractLogger.isMeasurements) {
            long delta = System.nanoTime() - entryTime;
            LocalizedMessageHandler.logStatisticMessage("StatementWrapper.apiFreeStmt.txt", delta, logger);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void GetAttr(int attr, int indicator, AnyHolder valueHolder, IntHolder status) throws TKTS_ERROR, TKTS_INVALID_HANDLE, GenericError {
        String method = "GetAttr(attr,indicator,value,status)";
        long entryTime = 0L;
        if (AbstractLogger.isTrace) {
            logger.entry("GetAttr(attr,indicator,value,status)", "Calling getAttr.");
        }
        if (AbstractLogger.isMeasurements) {
            entryTime = System.nanoTime();
        }
        IStatement iStatement = this.iomStatementHandle;
        synchronized (iStatement) {
            this.iomStatementHandle.GetAttr(attr, indicator, valueHolder, status);
        }
        if (AbstractLogger.isMeasurements) {
            long delta = System.nanoTime() - entryTime;
            LocalizedMessageHandler.logStatisticMessage("StatementWrapper.apiGetStmtAttr.txt", delta, logger);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void GetAttrs(int[] attrs, int[] indicators, AnySeqHolder values, LongSeqHolder status) throws GenericError {
        String method = "GetAttrs(attrs,indicators,values,status)";
        long entryTime = 0L;
        if (AbstractLogger.isTrace) {
            logger.entry("GetAttrs(attrs,indicators,values,status)", "Calling getAttrs.");
        }
        if (AbstractLogger.isMeasurements) {
            entryTime = System.nanoTime();
        }
        IStatement iStatement = this.iomStatementHandle;
        synchronized (iStatement) {
            this.iomStatementHandle.GetAttrs(attrs, indicators, values, status);
        }
        if (AbstractLogger.isTrace) {
            this.logLongSeqWarnings(status, attrs.length);
        }
        if (AbstractLogger.isMeasurements) {
            long delta = System.nanoTime() - entryTime;
            LocalizedMessageHandler.logStatisticMessage("StatementWrapper.apiGetStmtAttrs.txt", delta, logger);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void GetDiagFields(int[] recNumbers, int[] diagIdentifiers, int[] diagIndicators, AnySeqHolder values, VariableArray2dOfLongHolder status) throws TKTS_ERROR, TKTS_INVALID_HANDLE, TKTS_NO_DATA, GenericError {
        String method = "GetDiagFields(recNumbers,diagIdentifiers,diagIndicators,values,status)";
        long entryTime = 0L;
        if (AbstractLogger.isTrace) {
            logger.entry("GetDiagFields(recNumbers,diagIdentifiers,diagIndicators,values,status)", "Calling getDiagFields.");
        }
        if (AbstractLogger.isMeasurements) {
            entryTime = System.nanoTime();
        }
        IStatement iStatement = this.iomStatementHandle;
        synchronized (iStatement) {
            this.iomStatementHandle.GetDiagFields(recNumbers, diagIdentifiers, diagIndicators, values, status);
        }
        if (AbstractLogger.isMeasurements) {
            long delta = System.nanoTime() - entryTime;
            LocalizedMessageHandler.logStatisticMessage("StatementWrapper.apiGetDiagFields.txt", delta, logger);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void GetDiagRecs(int[] recNumbers, StringSeqHolder sqlStates, LongSeqHolder nativeErrors, StringSeqHolder messageTexts, LongSeqHolder status) throws TKTS_ERROR, TKTS_INVALID_HANDLE, TKTS_NO_DATA, GenericError {
        String method = "GetDiagRecs(recNumbers,sqlStates,nativeErrors,messageTexts,status)";
        long entryTime = 0L;
        if (AbstractLogger.isTrace) {
            logger.entry("GetDiagRecs(recNumbers,sqlStates,nativeErrors,messageTexts,status)", "Calling getDiagRecs");
        }
        if (AbstractLogger.isMeasurements) {
            entryTime = System.nanoTime();
        }
        IStatement iStatement = this.iomStatementHandle;
        synchronized (iStatement) {
            this.iomStatementHandle.GetDiagRecs(recNumbers, sqlStates, nativeErrors, messageTexts, status);
        }
        if (AbstractLogger.isMeasurements) {
            long delta = System.nanoTime() - entryTime;
            LocalizedMessageHandler.logStatisticMessage("StatementWrapper.apiGetDiagRecs.txt", delta, logger);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void GetTypeInformation(int dataType, IntHolder status) throws TKTS_ERROR, TKTS_INVALID_HANDLE, TKTS_STILL_EXECUTING, GenericError {
        String method = "GetTypeInformation(dataType,status)";
        long entryTime = 0L;
        if (AbstractLogger.isTrace) {
            logger.entry("GetTypeInformation(dataType,status)", "dataType=" + dataType);
        }
        if (AbstractLogger.isMeasurements) {
            entryTime = System.nanoTime();
        }
        IStatement iStatement = this.iomStatementHandle;
        synchronized (iStatement) {
            this.iomStatementHandle.GetTypeInformation(dataType, status);
        }
        if (AbstractLogger.isMeasurements) {
            long delta = System.nanoTime() - entryTime;
            LocalizedMessageHandler.logStatisticMessage("StatementWrapper.apiGetTypeInformation.txt", delta, logger);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void MoreResults(IntHolder status) throws TKTS_ERROR, TKTS_INVALID_HANDLE, TKTS_NO_DATA, TKTS_STILL_EXECUTING, GenericError {
        long entryTime = 0L;
        if (AbstractLogger.isMeasurements) {
            entryTime = System.nanoTime();
        }
        IStatement iStatement = this.iomStatementHandle;
        synchronized (iStatement) {
            this.iomStatementHandle.MoreResults(status);
        }
        if (AbstractLogger.isMeasurements) {
            long delta = System.nanoTime() - entryTime;
            LocalizedMessageHandler.logStatisticMessage("StatementWrapper.apiMoreResults.txt", delta, logger);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int NumParams(IntHolder status) throws TKTS_ERROR, TKTS_INVALID_HANDLE, TKTS_STILL_EXECUTING, GenericError {
        int x;
        long entryTime = 0L;
        if (AbstractLogger.isMeasurements) {
            entryTime = System.nanoTime();
        }
        IStatement iStatement = this.iomStatementHandle;
        synchronized (iStatement) {
            x = this.iomStatementHandle.NumParams(status);
        }
        if (AbstractLogger.isMeasurements) {
            long delta = System.nanoTime() - entryTime;
            LocalizedMessageHandler.logStatisticMessage("StatementWrapper.apiNumParams.txt", delta, logger);
        }
        return x;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int NumResultCols(IntHolder status) throws TKTS_ERROR, TKTS_INVALID_HANDLE, TKTS_STILL_EXECUTING, GenericError {
        int x;
        long entryTime = 0L;
        if (AbstractLogger.isMeasurements) {
            entryTime = System.nanoTime();
        }
        IStatement iStatement = this.iomStatementHandle;
        synchronized (iStatement) {
            x = this.iomStatementHandle.NumResultCols(status);
        }
        if (AbstractLogger.isMeasurements) {
            long delta = System.nanoTime() - entryTime;
            LocalizedMessageHandler.logStatisticMessage("StatementWrapper.apiNumResultCols.txt", delta, logger);
        }
        return x;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int ParamData(IntHolder status) throws TKTS_ERROR, TKTS_INVALID_HANDLE, TKTS_NO_DATA, TKTS_STILL_EXECUTING, GenericError {
        int x;
        long entryTime = 0L;
        if (AbstractLogger.isMeasurements) {
            entryTime = System.nanoTime();
        }
        IStatement iStatement = this.iomStatementHandle;
        synchronized (iStatement) {
            x = this.iomStatementHandle.ParamData(status);
        }
        if (AbstractLogger.isMeasurements) {
            long delta = System.nanoTime() - entryTime;
            LocalizedMessageHandler.logStatisticMessage("StatementWrapper.apiParamData.txt", delta, logger);
        }
        return x;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void Prepare(String statementText, IntHolder status) throws TKTS_ERROR, TKTS_INVALID_HANDLE, TKTS_STILL_EXECUTING, GenericError {
        long entryTime = 0L;
        if (AbstractLogger.isMeasurements) {
            entryTime = System.nanoTime();
        }
        IStatement iStatement = this.iomStatementHandle;
        synchronized (iStatement) {
            this.iomStatementHandle.Prepare(statementText, status);
        }
        if (AbstractLogger.isMeasurements) {
            long delta = System.nanoTime() - entryTime;
            LocalizedMessageHandler.logStatisticMessage("StatementWrapper.apiPrepare.txt", delta, logger);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void PrimaryKeys(String catalogName, String schemaName, String tableName, IntHolder status) throws TKTS_ERROR, TKTS_INVALID_HANDLE, TKTS_STILL_EXECUTING, GenericError {
        long entryTime = 0L;
        if (AbstractLogger.isMeasurements) {
            entryTime = System.nanoTime();
        }
        IStatement iStatement = this.iomStatementHandle;
        synchronized (iStatement) {
            this.iomStatementHandle.PrimaryKeys(catalogName, schemaName, tableName, status);
        }
        if (AbstractLogger.isMeasurements) {
            long delta = System.nanoTime() - entryTime;
            LocalizedMessageHandler.logStatisticMessage("StatementWrapper.apiPrimaryKeys.txt", delta, logger);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void ProcedureColumns(String catalogName, String schemaName, String procName, String columnName, IntHolder status) throws TKTS_ERROR, TKTS_INVALID_HANDLE, TKTS_STILL_EXECUTING, GenericError {
        long entryTime = 0L;
        if (AbstractLogger.isMeasurements) {
            entryTime = System.nanoTime();
        }
        IStatement iStatement = this.iomStatementHandle;
        synchronized (iStatement) {
            this.iomStatementHandle.ProcedureColumns(catalogName, schemaName, procName, columnName, status);
        }
        if (AbstractLogger.isMeasurements) {
            long delta = System.nanoTime() - entryTime;
            LocalizedMessageHandler.logStatisticMessage("StatementWrapper.apiProcedureColumns.txt", delta, logger);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void Procedures(String catalogName, String schemaName, String procName, IntHolder status) throws TKTS_ERROR, TKTS_INVALID_HANDLE, TKTS_STILL_EXECUTING, GenericError {
        long entryTime = 0L;
        if (AbstractLogger.isMeasurements) {
            entryTime = System.nanoTime();
        }
        IStatement iStatement = this.iomStatementHandle;
        synchronized (iStatement) {
            this.iomStatementHandle.Procedures(catalogName, schemaName, procName, status);
        }
        if (AbstractLogger.isMeasurements) {
            long delta = System.nanoTime() - entryTime;
            LocalizedMessageHandler.logStatisticMessage("StatementWrapper.apiProcedures.txt", delta, logger);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void PutData(Any data, int lenOrInd, IntHolder status) throws TKTS_ERROR, TKTS_INVALID_HANDLE, TKTS_STILL_EXECUTING, GenericError {
        long entryTime = 0L;
        if (AbstractLogger.isMeasurements) {
            entryTime = System.nanoTime();
        }
        IStatement iStatement = this.iomStatementHandle;
        synchronized (iStatement) {
            this.iomStatementHandle.PutData(data, lenOrInd, status);
        }
        if (AbstractLogger.isMeasurements) {
            long delta = System.nanoTime() - entryTime;
            LocalizedMessageHandler.logStatisticMessage("StatementWrapper.apiPutData.txt", delta, logger);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long RowCount(IntHolder status) throws TKTS_ERROR, TKTS_INVALID_HANDLE, GenericError {
        long x;
        long entryTime = 0L;
        if (AbstractLogger.isMeasurements) {
            entryTime = System.nanoTime();
        }
        IStatement iStatement = this.iomStatementHandle;
        synchronized (iStatement) {
            x = this.iomStatementHandle.RowCount(status);
        }
        if (AbstractLogger.isMeasurements) {
            long delta = System.nanoTime() - entryTime;
            LocalizedMessageHandler.logStatisticMessage("StatementWrapper.apiRowCount.txt", delta, logger);
        }
        return x;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void SetAttr(int attr, int indicator, Any value, IntHolder status) throws TKTS_ERROR, TKTS_INVALID_HANDLE, GenericError {
        long entryTime = 0L;
        if (AbstractLogger.isMeasurements) {
            entryTime = System.nanoTime();
        }
        IStatement iStatement = this.iomStatementHandle;
        synchronized (iStatement) {
            this.iomStatementHandle.SetAttr(attr, indicator, value, status);
        }
        if (AbstractLogger.isMeasurements) {
            long delta = System.nanoTime() - entryTime;
            LocalizedMessageHandler.logStatisticMessage("StatementWrapper.apiSetStmtAttr.txt", delta, logger);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void SetAttrs(int[] attr, int[] indicator, Any[] value, LongSeqHolder status) throws TKTS_ERROR, TKTS_INVALID_HANDLE, GenericError {
        long entryTime = 0L;
        if (AbstractLogger.isMeasurements) {
            entryTime = System.nanoTime();
        }
        IStatement iStatement = this.iomStatementHandle;
        synchronized (iStatement) {
            this.iomStatementHandle.SetAttrs(attr, indicator, value, status);
        }
        if (AbstractLogger.isMeasurements) {
            long delta = System.nanoTime() - entryTime;
            LocalizedMessageHandler.logStatisticMessage("StatementWrapper.apiSetStmtAttrs.txt", delta, logger);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void SpecialColumns(int identifierType, String catalogName, String schemaName, String tableName, int scope, int nullable, IntHolder status) throws TKTS_ERROR, TKTS_INVALID_HANDLE, TKTS_STILL_EXECUTING, GenericError {
        long entryTime = 0L;
        if (AbstractLogger.isMeasurements) {
            entryTime = System.nanoTime();
        }
        IStatement iStatement = this.iomStatementHandle;
        synchronized (iStatement) {
            this.iomStatementHandle.SpecialColumns(identifierType, catalogName, schemaName, tableName, scope, nullable, status);
        }
        if (AbstractLogger.isMeasurements) {
            long delta = System.nanoTime() - entryTime;
            LocalizedMessageHandler.logStatisticMessage("StatementWrapper.apiSpecialColumns.txt", delta, logger);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void Statistics(String catalogName, String schemaName, String tableName, int unique, int reserved, IntHolder status) throws TKTS_ERROR, TKTS_INVALID_HANDLE, TKTS_STILL_EXECUTING, GenericError {
        long entryTime = 0L;
        if (AbstractLogger.isMeasurements) {
            entryTime = System.nanoTime();
        }
        IStatement iStatement = this.iomStatementHandle;
        synchronized (iStatement) {
            this.iomStatementHandle.Statistics(catalogName, schemaName, tableName, unique, reserved, status);
        }
        if (AbstractLogger.isMeasurements) {
            long delta = System.nanoTime() - entryTime;
            LocalizedMessageHandler.logStatisticMessage("StatementWrapper.apiStatistics.txt", delta, logger);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void TablePrivileges(String catalogName, String schemaName, String tableName, IntHolder status) throws TKTS_ERROR, TKTS_INVALID_HANDLE, TKTS_STILL_EXECUTING, GenericError {
        long entryTime = 0L;
        if (AbstractLogger.isMeasurements) {
            entryTime = System.nanoTime();
        }
        IStatement iStatement = this.iomStatementHandle;
        synchronized (iStatement) {
            this.iomStatementHandle.TablePrivileges(catalogName, schemaName, tableName, status);
        }
        if (AbstractLogger.isMeasurements) {
            long delta = System.nanoTime() - entryTime;
            LocalizedMessageHandler.logStatisticMessage("StatementWrapper.apiTablePrivileges.txt", delta, logger);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void Tables(String catalogName, String schemaName, String tableName, String tableType, IntHolder status) throws TKTS_ERROR, TKTS_INVALID_HANDLE, TKTS_STILL_EXECUTING, GenericError {
        long entryTime = 0L;
        if (AbstractLogger.isMeasurements) {
            entryTime = System.nanoTime();
        }
        IStatement iStatement = this.iomStatementHandle;
        synchronized (iStatement) {
            this.iomStatementHandle.Tables(catalogName, schemaName, tableName, tableType, status);
        }
        if (AbstractLogger.isMeasurements) {
            long delta = System.nanoTime() - entryTime;
            LocalizedMessageHandler.logStatisticMessage("StatementWrapper.apiTables.txt", delta, logger);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void UpdateByBookmark(Any[] values, int[][] lenOrInd, OctetSeqHolder rowStatus, IntHolder rowsAffected, IntHolder status) throws TKTS_ERROR, TKTS_INVALID_HANDLE, TKTS_NEED_DATA, TKTS_STILL_EXECUTING, GenericError {
        long entryTime = 0L;
        if (AbstractLogger.isMeasurements) {
            entryTime = System.nanoTime();
        }
        IStatement iStatement = this.iomStatementHandle;
        synchronized (iStatement) {
            this.iomStatementHandle.UpdateByBookmark(values, lenOrInd, rowStatus, rowsAffected, status);
        }
        if (AbstractLogger.isMeasurements) {
            long delta = System.nanoTime() - entryTime;
            LocalizedMessageHandler.logStatisticMessage("StatementWrapper.apiUpdateByBookmark.txt", delta, logger);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int PrepareWithNumResultCols(String statementText) throws TKTS_ERROR, TKTS_INVALID_HANDLE, TKTS_STILL_EXECUTING, GenericError {
        int x;
        long entryTime = 0L;
        if (AbstractLogger.isMeasurements) {
            entryTime = System.nanoTime();
        }
        IStatement iStatement = this.iomStatementHandle;
        synchronized (iStatement) {
            x = this.iomStatementHandle.PrepareWithNumResultCols(statementText);
        }
        this.fsStatement.setPrepared(true);
        if (AbstractLogger.isMeasurements) {
            long delta = System.nanoTime() - entryTime;
            LocalizedMessageHandler.logStatisticMessage("StatementWrapper.apiPrepareWithNumResultCols.txt", delta, logger);
        }
        return x;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void FreeStmtArray(int[] options, LongSeqHolder status) throws GenericError {
        long entryTime = 0L;
        if (AbstractLogger.isMeasurements) {
            entryTime = System.nanoTime();
        }
        IStatement iStatement = this.iomStatementHandle;
        synchronized (iStatement) {
            this.iomStatementHandle.FreeStmtArray(options, status);
        }
        if (AbstractLogger.isMeasurements) {
            long delta = System.nanoTime() - entryTime;
            LocalizedMessageHandler.logStatisticMessage("StatementWrapper.apiFreeStmtArray.txt", delta, logger);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void BindParameters(int[] parameterNumbers, int[] valueTypes, int[] parameterTypes, int[] parameterSizes, int[] decimalDigits, int[] bindTypes, LongSeqHolder status, IntHolder bmgrStatus) throws TKTS_ERROR, TKTS_INVALID_HANDLE, GenericError {
        long entryTime = 0L;
        if (AbstractLogger.isMeasurements) {
            entryTime = System.nanoTime();
        }
        IStatement iStatement = this.iomStatementHandle;
        synchronized (iStatement) {
            this.iomStatementHandle.BindParameters(parameterNumbers, valueTypes, parameterTypes, parameterSizes, decimalDigits, bindTypes, status, bmgrStatus);
        }
        if (AbstractLogger.isMeasurements) {
            long delta = System.nanoTime() - entryTime;
            LocalizedMessageHandler.logStatisticMessage("StatementWrapper.apiBindParameters.txt", delta, logger);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void BindParameters2(int[] parameterNumbers, int[] valueTypes, int[] parameterTypes, int[] parameterSizes, int[] decimalDigits, int[] bindTypes, int[] encodings, int[] buffersLength, IntHolder bmgrStatus) throws TKTS_ERROR, TKTS_INVALID_HANDLE, GenericError {
        long entryTime = 0L;
        if (AbstractLogger.isMeasurements) {
            entryTime = System.nanoTime();
        }
        IStatement iStatement = this.iomStatementHandle;
        synchronized (iStatement) {
            this.iomStatementHandle_1_2.BindParameters2(parameterNumbers, valueTypes, parameterTypes, parameterSizes, decimalDigits, bindTypes, encodings, buffersLength, bmgrStatus);
        }
        if (AbstractLogger.isMeasurements) {
            long delta = System.nanoTime() - entryTime;
            LocalizedMessageHandler.logStatisticMessage("StatementWrapper.apiBindParameters2.txt", delta, logger);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void Execute(Any[] inParameters, int[][] inLenOrInd, AnySeqHolder outParameters, VariableArray2dOfLongHolder outLenOrInd, IntHolder paramsProcessed, OctetSeqHolder paramStatus, IntHolder status) throws TKTS_ERROR, TKTS_INVALID_HANDLE, TKTS_NO_DATA, TKTS_STILL_EXECUTING, GenericError {
        long entryTime = 0L;
        if (AbstractLogger.isMeasurements) {
            entryTime = System.nanoTime();
        }
        IStatement iStatement = this.iomStatementHandle;
        synchronized (iStatement) {
            this.iomStatementHandle.Execute(inParameters, inLenOrInd, new int[0], outParameters, outLenOrInd, paramsProcessed, paramStatus, status);
        }
        if (AbstractLogger.isMeasurements) {
            long delta = System.nanoTime() - entryTime;
            LocalizedMessageHandler.logStatisticMessage("StatementWrapper.apiExecute.txt", delta, logger);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void Execute2(byte[] packedInputBuffer, byte[] paramOperations, IntHolder paramsProcessed, OctetSeqHolder outputParams, OctetSeqHolder paramStatus, LongHolder rowCount, IntHolder status) throws TKTS_ERROR, TKTS_INVALID_HANDLE, TKTS_NO_DATA, TKTS_STILL_EXECUTING, GenericError {
        long entryTime = 0L;
        String method = "Execute2";
        if (AbstractLogger.isMeasurements) {
            entryTime = System.nanoTime();
        }
        IStatement iStatement = this.iomStatementHandle;
        synchronized (iStatement) {
            this.iomStatementHandle_1_2.Execute2(packedInputBuffer, paramOperations, paramsProcessed, outputParams, paramStatus, rowCount, status);
        }
        if (AbstractLogger.isTrace) {
            this.logIntHolderWarnings(status);
            logger.exit(method, " status[" + TypesHelper.getTktsStatus(status.value) + "]");
        }
        if (AbstractLogger.isMeasurements) {
            long delta = System.nanoTime() - entryTime;
            LocalizedMessageHandler.logStatisticMessage("StatementWrapper.apiExecute2.txt", delta, logger);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void FetchScroll2(int fetchOrientation, long fetchOffset, byte[] bookmark, IntHolder rowsFetched, OctetSeqHolder rowStatus, OctetSeqHolder rowBuffer, IntHolder status) throws TKTS_ERROR, TKTS_INVALID_HANDLE, TKTS_NO_DATA, TKTS_STILL_EXECUTING, GenericError {
        long entryTime = 0L;
        if (AbstractLogger.isMeasurements) {
            entryTime = System.nanoTime();
        }
        IStatement iStatement = this.iomStatementHandle;
        synchronized (iStatement) {
            this.iomStatementHandle_1_1.FetchScroll2(fetchOrientation, fetchOffset, bookmark, rowsFetched, rowStatus, rowBuffer, status);
        }
        if (AbstractLogger.isMeasurements) {
            long delta = System.nanoTime() - entryTime;
            LocalizedMessageHandler.logStatisticMessage("StatementWrapper.apiFetchScroll2.txt", delta, logger);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void Add(int rowNumber, Any[] values, int[][] lenOrInd, int[] rowOperations, int lockType, AnySeqHolder bookmarks, LongSeqHolder bookmarksLenOrInd, OctetSeqHolder rowStatus, IntHolder status) throws TKTS_ERROR, TKTS_INVALID_HANDLE, TKTS_NEED_DATA, TKTS_STILL_EXECUTING, GenericError {
        long entryTime = 0L;
        if (AbstractLogger.isMeasurements) {
            entryTime = System.nanoTime();
        }
        IStatement iStatement = this.iomStatementHandle;
        synchronized (iStatement) {
            this.iomStatementHandle.Add(rowNumber, values, lenOrInd, rowOperations, lockType, bookmarks, bookmarksLenOrInd, rowStatus, status);
        }
        if (AbstractLogger.isMeasurements) {
            long delta = System.nanoTime() - entryTime;
            LocalizedMessageHandler.logStatisticMessage("StatementWrapper.apiAdd.txt", delta, logger);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void Add2(int rowNumber, int lockType, int rowsFetched, byte[] rowOperation, byte[] rowBuffer, OctetSeqHolder bookmarks, OctetSeqHolder rowStatus, IntHolder status) throws TKTS_ERROR, TKTS_INVALID_HANDLE, TKTS_NEED_DATA, TKTS_STILL_EXECUTING, GenericError {
        long entryTime = 0L;
        if (AbstractLogger.isMeasurements) {
            entryTime = System.nanoTime();
        }
        IStatement iStatement = this.iomStatementHandle;
        synchronized (iStatement) {
            this.iomStatementHandle_1_2.SetPosAdd2(rowNumber, lockType, rowsFetched, rowOperation, rowBuffer, bookmarks, rowStatus, status);
        }
        if (AbstractLogger.isMeasurements) {
            long delta = System.nanoTime() - entryTime;
            LocalizedMessageHandler.logStatisticMessage("StatementWrapper.apiAdd2.txt", delta, logger);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void Delete2(int rowNumber, int lockType, int rowsFetched, byte[] rowOperation, OctetSeqHolder rowStatus, IntHolder status) throws TKTS_ERROR, TKTS_INVALID_HANDLE, TKTS_NEED_DATA, TKTS_STILL_EXECUTING, GenericError {
        long entryTime = 0L;
        if (AbstractLogger.isMeasurements) {
            entryTime = System.nanoTime();
        }
        IStatement iStatement = this.iomStatementHandle;
        synchronized (iStatement) {
            this.iomStatementHandle_1_2.SetPosDelete2(rowNumber, lockType, rowsFetched, rowOperation, rowStatus, status);
        }
        if (AbstractLogger.isMeasurements) {
            long delta = System.nanoTime() - entryTime;
            LocalizedMessageHandler.logStatisticMessage("StatementWrapper.apiDelete2.txt", delta, logger);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void Refresh(int rowNumber, int rowsToRefresh, int lockType, AnySeqHolder values, VariableArray2dOfLongHolder lenOrInd, OctetSeqHolder rowStatus, IntHolder status) throws TKTS_ERROR, TKTS_INVALID_HANDLE, TKTS_NEED_DATA, TKTS_STILL_EXECUTING, GenericError {
        long entryTime = 0L;
        if (AbstractLogger.isMeasurements) {
            entryTime = System.nanoTime();
        }
        IStatement iStatement = this.iomStatementHandle;
        synchronized (iStatement) {
            this.iomStatementHandle.Refresh(rowNumber, rowsToRefresh, lockType, values, lenOrInd, rowStatus, status);
        }
        if (AbstractLogger.isMeasurements) {
            long delta = System.nanoTime() - entryTime;
            LocalizedMessageHandler.logStatisticMessage("StatementWrapper.apiRefresh.txt", delta, logger);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void Refresh2(int rowNumber, int lockType, int rowsFetched, byte[] rowOperation, OctetSeqHolder rowData, OctetSeqHolder rowStatus, IntHolder status) throws TKTS_ERROR, TKTS_INVALID_HANDLE, TKTS_NEED_DATA, TKTS_STILL_EXECUTING, GenericError {
        long entryTime = 0L;
        if (AbstractLogger.isMeasurements) {
            entryTime = System.nanoTime();
        }
        IStatement iStatement = this.iomStatementHandle;
        synchronized (iStatement) {
            this.iomStatementHandle_1_2.SetPosRefresh2(rowNumber, lockType, rowsFetched, rowOperation, rowData, rowStatus, status);
        }
        if (AbstractLogger.isMeasurements) {
            long delta = System.nanoTime() - entryTime;
            LocalizedMessageHandler.logStatisticMessage("StatementWrapper.apiRefresh2.txt", delta, logger);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void Update(int rowNumber, Any[] values, int[][] lenOrInd, int[] rowOperations, int lockType, OctetSeqHolder rowStatus, IntHolder status) throws TKTS_ERROR, TKTS_INVALID_HANDLE, TKTS_NEED_DATA, TKTS_STILL_EXECUTING, GenericError {
        long entryTime = 0L;
        if (AbstractLogger.isMeasurements) {
            entryTime = System.nanoTime();
        }
        IStatement iStatement = this.iomStatementHandle;
        synchronized (iStatement) {
            this.iomStatementHandle.Update(rowNumber, values, lenOrInd, rowOperations, lockType, rowStatus, status);
        }
        if (AbstractLogger.isMeasurements) {
            long delta = System.nanoTime() - entryTime;
            LocalizedMessageHandler.logStatisticMessage("StatementWrapper.apiUpdate.txt", delta, logger);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void Update2(int rowNumber, int lockType, int rowsFetched, byte[] rowOperation, byte[] rowBuffer, OctetSeqHolder rowStatus, IntHolder status) throws TKTS_ERROR, TKTS_INVALID_HANDLE, TKTS_NEED_DATA, TKTS_STILL_EXECUTING, GenericError {
        long entryTime = 0L;
        if (AbstractLogger.isMeasurements) {
            entryTime = System.nanoTime();
        }
        IStatement iStatement = this.iomStatementHandle;
        synchronized (iStatement) {
            this.iomStatementHandle_1_2.SetPosUpdate2(rowNumber, lockType, rowsFetched, rowOperation, rowBuffer, rowStatus, status);
        }
        if (AbstractLogger.isMeasurements) {
            long delta = System.nanoTime() - entryTime;
            LocalizedMessageHandler.logStatisticMessage("StatementWrapper.apiUpdate2.txt", delta, logger);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void Position(int rowNumber, int lockType, IntHolder status) throws TKTS_ERROR, TKTS_INVALID_HANDLE, TKTS_NEED_DATA, TKTS_STILL_EXECUTING, GenericError {
        long entryTime = 0L;
        if (AbstractLogger.isMeasurements) {
            entryTime = System.nanoTime();
        }
        IStatement iStatement = this.iomStatementHandle;
        synchronized (iStatement) {
            this.iomStatementHandle.Position(rowNumber, lockType, status);
        }
        if (AbstractLogger.isMeasurements) {
            long delta = System.nanoTime() - entryTime;
            LocalizedMessageHandler.logStatisticMessage("StatementWrapper.apiPosition.txt", delta, logger);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void Position2(int rowNumber, int lockType, int rowsFetched, IntHolder status) throws TKTS_ERROR, TKTS_INVALID_HANDLE, TKTS_NEED_DATA, TKTS_STILL_EXECUTING, GenericError {
        long entryTime = 0L;
        if (AbstractLogger.isMeasurements) {
            entryTime = System.nanoTime();
        }
        IStatement iStatement = this.iomStatementHandle;
        synchronized (iStatement) {
            this.iomStatementHandle_1_2.SetPosPosition2(rowNumber, lockType, rowsFetched, status);
        }
        if (AbstractLogger.isMeasurements) {
            long delta = System.nanoTime() - entryTime;
            LocalizedMessageHandler.logStatisticMessage("StatementWrapper.apiPosition2.txt", delta, logger);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void PutQuery(IntHolder rowNumber, IntHolder ordinal, IntHolder bindType, IntHolder status) throws TKTS_ERROR, TKTS_INVALID_HANDLE, TKTS_NO_DATA, TKTS_NEED_DATA, TKTS_STILL_EXECUTING, GenericError {
        long entryTime = 0L;
        if (AbstractLogger.isMeasurements) {
            entryTime = System.nanoTime();
        }
        IStatement iStatement = this.iomStatementHandle;
        synchronized (iStatement) {
            this.iomStatementHandle_1_2.PutQuery(rowNumber, ordinal, bindType, status);
        }
        if (AbstractLogger.isMeasurements) {
            long delta = System.nanoTime() - entryTime;
            LocalizedMessageHandler.logStatisticMessage("StatementWrapper.apiPutQuery.txt", delta, logger);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void GetData(int columnNumber, int targetType, int offset, int length, AnyHolder data, IntHolder lenOrInd, IntHolder status) throws TKTS_ERROR, TKTS_INVALID_HANDLE, TKTS_NO_DATA, TKTS_STILL_EXECUTING, GenericError {
        long entryTime = 0L;
        if (AbstractLogger.isMeasurements) {
            entryTime = System.nanoTime();
        }
        IStatement iStatement = this.iomStatementHandle;
        synchronized (iStatement) {
            this.iomStatementHandle.GetData(columnNumber, targetType, offset, length, data, lenOrInd, status);
        }
        if (AbstractLogger.isMeasurements) {
            long delta = System.nanoTime() - entryTime;
            LocalizedMessageHandler.logStatisticMessage("StatementWrapper.apiGetData.txt", delta, logger);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void GetData2(int columnNumber, int targetType, long offset, int length, AnyHolder data, LongHolder lenOrInd, IntHolder status) throws TKTS_ERROR, TKTS_INVALID_HANDLE, TKTS_NO_DATA, TKTS_STILL_EXECUTING, GenericError {
        long entryTime = 0L;
        if (AbstractLogger.isMeasurements) {
            entryTime = System.nanoTime();
        }
        IStatement iStatement = this.iomStatementHandle;
        synchronized (iStatement) {
            this.iomStatementHandle_1_2.GetData2(columnNumber, targetType, offset, length, data, lenOrInd, status);
        }
        if (AbstractLogger.isMeasurements) {
            long delta = System.nanoTime() - entryTime;
            LocalizedMessageHandler.logStatisticMessage("StatementWrapper.apiGetData2.txt", delta, logger);
        }
    }

    public String describeParam(int attr, int value) {
        StringBuffer describeParam = new StringBuffer(100);
        describeParam.append("(attribute=" + attr + ", indicator=" + value + ")");
        return describeParam.toString();
    }

    public static void apiUnpackData(long delta, long rowCount, long bytes) {
        if (AbstractLogger.isMeasurements) {
            LocalizedMessageHandler.logStatisticMessage("StatementWrapper.apiUnpackData.txt", delta, rowCount, bytes, logger);
        }
    }

    public static void apiPackData(long delta, long rowCount, long bytes) {
        if (AbstractLogger.isMeasurements) {
            LocalizedMessageHandler.logStatisticMessage("StatementWrapper.apiPackData.txt", delta, rowCount, bytes, logger);
        }
    }

    public static void logOverallStatistics() {
        if (AbstractLogger.isMeasurements) {
            LocalizedMessageHandler.logOverallStatistics(logger);
        }
    }

    public FSConnection getFSConnection() {
        return this.fsConnection;
    }

    public FSStatement getFSStatement() {
        return this.fsStatement;
    }

    public boolean getPrefetch() {
        boolean out = false;
        if (this.fsStatement == null) {
            if (this.fsConnection != null) {
                out = this.fsConnection.getPrefetch();
            }
        } else {
            out = this.fsStatement.getPrefetch();
        }
        return out;
    }

    public boolean isOpen() {
        return this.isOpen;
    }

    public static void trackingDisplay() {
        myResources.display();
    }

    public static void trackingDisplaySummary() {
        myResources.displaySummary();
    }

    public static long trackingCount() {
        return myResources.count();
    }

    public static void trackingEnabled(boolean newValue, boolean details) {
        trackStatementWrapper = newValue;
        myResources.setLogDetails(details);
    }

    public boolean getLobPosition() {
        return this.lobPosition;
    }

    public void setLobPosition(boolean b) {
        this.lobPosition = b;
    }

    public String toString() {
        String outStr = "SW ID:" + this.myID;
        return outStr;
    }

    static {
        OPEN1 = "Open1";
        OPEN2 = "Open2";
        CLOSED = "Closed";
        CREATE_ISTMT = "Create IStatement";
        HANDLE_ERROR = "TKTSConnection.statementHandleError.txt";
        STATS_BINDCOLS = "StatementWrapper.apiBindCols.txt";
        STATS_BULKOPS = "StatementWrapper.apiBulkOpsAdd.txt";
        STATS_CANCEL = "StatementWrapper.apiCancel.txt";
        STATS_CLOSE = "StatementWrapper.apiClose.txt";
        STATS_CLOSECURSOR = "StatementWrapper.apiCloseCursor.txt";
        STATS_COLATTR = "StatementWrapper.apiColAttributes.txt";
        STATS_COLATTRFLAT = "StatementWrapper.apiColAttributesFlat.txt";
        STATS_COLPRIV = "StatementWrapper.apiColumnPrivileges.txt";
        STATS_COLUMNS = "StatementWrapper.apiColumns.txt";
        STATS_COLSTATS = "StatementWrapper.apiColumnStatistics.txt";
        myResources = new TrackResource("StatementWrapper");
    }
}

