/*
 * Decompiled with CFR 0.152.
 */
package com.sas.tkts.info;

import com.sas.tkts.info.PackedParameterSetBuffer;
import com.sas.tkts.info.ParameterInfo;
import com.sas.tkts.logging.AbstractLogger;
import com.sas.tkts.util.CharSetUtil;
import com.sas.tkts.util.ParameterInfoHelper;
import com.sas.tkts.util.TimeRepresentation;
import java.math.BigDecimal;
import java.nio.charset.Charset;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;

public class PackedParameterSetBufferPT1
extends PackedParameterSetBuffer {
    static final int TSPACK_IND_FLOAT = 4;
    static final int TSPACK_IND_DOUBLE = 8;
    static final int TSPACK_IND_ZERO = 32;
    static final int TSPACK_IND_UI8 = 33;
    static final int TSPACK_IND_UI16 = 34;
    static final int TSPACK_IND_UI32 = 35;
    static final int TSPACK_IND_I8 = 36;
    static final int TSPACK_IND_I16 = 37;
    static final int TSPACK_IND_I32 = 38;

    public PackedParameterSetBufferPT1() {
        this.isPackType1 = true;
    }

    public PackedParameterSetBufferPT1(int bytes) {
        super(bytes);
        this.isPackType1 = true;
    }

    @Override
    public void addColumnNumbers(ParameterInfo[] pia) {
        int numberColumns = pia.length;
        this.checkCapacity((numberColumns + 1) * 4);
        this.packedByteBuffer.putInt(numberColumns);
        for (int i = 0; i < numberColumns; ++i) {
            this.packedByteBuffer.putInt(pia[i].getOrdinal());
        }
    }

    public void insertIndicator(long indicatorValue) {
        if (indicatorValue <= 127L) {
            this.packedByteBuffer.put((byte)indicatorValue);
        } else if (indicatorValue <= 32767L) {
            this.packedByteBuffer.put((byte)-8);
            this.packedByteBuffer.putShort((short)indicatorValue);
        } else if (indicatorValue <= Integer.MAX_VALUE) {
            this.packedByteBuffer.put((byte)-6);
            this.packedByteBuffer.putInt((int)indicatorValue);
        } else {
            this.packedByteBuffer.put((byte)-9);
            this.packedByteBuffer.putLong(indicatorValue);
        }
    }

    protected void insertCompressedLength(int dataLength) {
        if (dataLength <= 127) {
            this.packedByteBuffer.put((byte)dataLength);
        } else if (dataLength <= 16383) {
            byte lbyte = (byte)(0x7F & dataLength);
            byte hbyte = (byte)(dataLength >> 7);
            hbyte = (byte)(hbyte | 0xFFFFFF80);
            this.packedByteBuffer.put(hbyte);
            this.packedByteBuffer.put(lbyte);
        } else {
            if (dataLength > 0x3FFFFFFF) {
                dataLength = 0x3FFFFFFF;
            }
            int unpackedBytes = dataLength & 0xFFFF;
            byte lbyte = (byte)(0x7F & (dataLength >>= 16));
            byte hbyte = (byte)(dataLength >> 7);
            lbyte = (byte)(lbyte | 0xFFFFFF80);
            hbyte = (byte)(hbyte | 0xFFFFFF80);
            this.packedByteBuffer.put(hbyte);
            this.packedByteBuffer.put(lbyte);
            lbyte = (byte)(0xFF & unpackedBytes);
            hbyte = (byte)(0xFF & (unpackedBytes >>= 8));
            this.packedByteBuffer.put(hbyte);
            this.packedByteBuffer.put(lbyte);
        }
    }

    public int insertStringData(String value, boolean isLong) {
        int dataLength = 0;
        if (value.equals("")) {
            this.checkCapacity(1L);
            this.insertIndicator(0L);
        } else {
            Charset insertCharSet = CharSetUtil.getToServerCharset();
            byte[] valueBytes = value.getBytes(insertCharSet);
            int strippedLength = dataLength = valueBytes.length;
            --strippedLength;
            while (strippedLength >= 0 && valueBytes[strippedLength] == 32) {
                --strippedLength;
            }
            long bytesNeeded = 9 + ++strippedLength;
            this.checkCapacity(bytesNeeded);
            this.insertIndicator(-4L);
            this.insertCompressedLength(strippedLength);
            this.packedByteBuffer.put(valueBytes, 0, strippedLength);
        }
        return dataLength;
    }

    public int insertByteData(byte[] value, boolean isLong) {
        int dataLength = 0;
        long totalBytes = 1L;
        if (value.length == 0) {
            this.checkCapacity(totalBytes);
            this.insertIndicator(0L);
        } else {
            int strippedLength = dataLength = value.length;
            --strippedLength;
            while (value[strippedLength] == 0) {
                --strippedLength;
            }
            this.checkCapacity(totalBytes += (long)(++strippedLength + 8));
            this.insertIndicator(dataLength);
            this.insertCompressedLength(strippedLength);
            this.packedByteBuffer.put(value, 0, strippedLength);
        }
        return dataLength;
    }

    @Override
    public int packParameterValue(int ordinal, Object theValue, Object ptype) {
        PackedParameterSetBuffer.ParameterType pt = (PackedParameterSetBuffer.ParameterType)ptype;
        int index = pt.getIndex();
        int out = 0;
        switch (index) {
            case 0: {
                this.checkCapacity(1L);
                this.insertIndicator(-1L);
                break;
            }
            case 1: 
            case 2: {
                long l;
                Number number = (Number)theValue;
                double d = number.doubleValue();
                if (Double.isNaN(d) && (l = ParameterInfoHelper.doubleToMissingValueIndicator(d)) != 0L) {
                    this.insertIndicator(l);
                    return out;
                }
                double fd = Math.floor(d);
                if (d == fd && fd <= 2.147483647E9 && fd >= -2.147483648E9) {
                    long l2 = (long)fd;
                    if (l2 == 0L) {
                        this.insertIndicator(32L);
                        break;
                    }
                    if (l2 > 0L) {
                        if (l2 <= 127L) {
                            this.insertIndicator(33L);
                            this.packedByteBuffer.put((byte)l2);
                            break;
                        }
                        if (l2 <= 32767L) {
                            this.insertIndicator(34L);
                            this.packedByteBuffer.putShort((short)l2);
                            break;
                        }
                        if (l2 > Integer.MAX_VALUE) break;
                        this.insertIndicator(35L);
                        this.packedByteBuffer.putInt((int)l2);
                        break;
                    }
                    if (l2 >= -128L) {
                        this.insertIndicator(36L);
                        this.packedByteBuffer.put((byte)l2);
                        break;
                    }
                    if (l2 >= -32768L) {
                        this.insertIndicator(37L);
                        this.packedByteBuffer.putShort((short)l2);
                        break;
                    }
                    if (l2 < Integer.MIN_VALUE) break;
                    this.insertIndicator(38L);
                    this.packedByteBuffer.putInt((int)l2);
                    break;
                }
                if (index == 1) {
                    this.insertIndicator(8L);
                    this.packedByteBuffer.putDouble(d);
                    break;
                }
                this.insertIndicator(4L);
                this.packedByteBuffer.putFloat((float)d);
                break;
            }
            case 3: {
                this.checkCapacity(2L);
                Number number = (Number)theValue;
                byte b = number.byteValue();
                if (b == 0) {
                    this.insertIndicator(32L);
                    break;
                }
                this.insertIndicator(1L);
                this.packedByteBuffer.put(b);
                break;
            }
            case 4: {
                this.checkCapacity(3L);
                Number number = (Number)theValue;
                short s = number.shortValue();
                if (s == 0) {
                    this.insertIndicator(32L);
                    break;
                }
                if (s > 0) {
                    if (s <= 127) {
                        this.insertIndicator(33L);
                        this.packedByteBuffer.put((byte)s);
                        break;
                    }
                    this.insertIndicator(2L);
                    this.packedByteBuffer.putShort(s);
                    break;
                }
                if (s >= -128) {
                    this.insertIndicator(36L);
                    this.packedByteBuffer.put((byte)s);
                    break;
                }
                this.insertIndicator(2L);
                this.packedByteBuffer.putShort(s);
                break;
            }
            case 5: {
                this.checkCapacity(5L);
                Number number = (Number)theValue;
                int i = number.intValue();
                if (i == 0) {
                    this.insertIndicator(32L);
                    break;
                }
                if (i > 0) {
                    if (i <= 127) {
                        this.insertIndicator(33L);
                        this.packedByteBuffer.put((byte)i);
                        break;
                    }
                    if (i <= Short.MAX_VALUE) {
                        this.insertIndicator(34L);
                        this.packedByteBuffer.putShort((short)i);
                        break;
                    }
                    this.insertIndicator(4L);
                    this.packedByteBuffer.putInt(i);
                    break;
                }
                if (i >= -128) {
                    this.insertIndicator(36L);
                    this.packedByteBuffer.put((byte)i);
                    break;
                }
                if (i >= Short.MIN_VALUE) {
                    this.insertIndicator(37L);
                    this.packedByteBuffer.putShort((short)i);
                    break;
                }
                this.insertIndicator(4L);
                this.packedByteBuffer.putInt(i);
                break;
            }
            case 6: {
                this.checkCapacity(9L);
                Number number = (Number)theValue;
                long l = number.longValue();
                if (l == 0L) {
                    this.insertIndicator(32L);
                    break;
                }
                if (l > 0L) {
                    if (l <= 127L) {
                        this.insertIndicator(33L);
                        this.packedByteBuffer.put((byte)l);
                        break;
                    }
                    if (l <= 32767L) {
                        this.insertIndicator(34L);
                        this.packedByteBuffer.putShort((short)l);
                        break;
                    }
                    if (l <= Integer.MAX_VALUE) {
                        this.insertIndicator(35L);
                        this.packedByteBuffer.putInt((int)l);
                        break;
                    }
                    this.insertIndicator(8L);
                    this.packedByteBuffer.putLong(l);
                    break;
                }
                if (l >= -128L) {
                    this.insertIndicator(36L);
                    this.packedByteBuffer.put((byte)l);
                    break;
                }
                if (l >= -32768L) {
                    this.insertIndicator(37L);
                    this.packedByteBuffer.putShort((short)l);
                    break;
                }
                if (l >= Integer.MIN_VALUE) {
                    this.insertIndicator(38L);
                    this.packedByteBuffer.putInt((int)l);
                    break;
                }
                this.insertIndicator(8L);
                this.packedByteBuffer.putLong(l);
                break;
            }
            case 7: {
                this.checkCapacity(5L);
                this.insertIndicator(6L);
                Object dateTimeValue = ((TimeRepresentation)theValue).getRawDateTimeValue();
                this.insertDateData((Date)dateTimeValue);
                break;
            }
            case 8: {
                this.checkCapacity(4L);
                this.insertIndicator(6L);
                Object dateTimeValue = ((TimeRepresentation)theValue).getRawDateTimeValue();
                this.insertTimeData((Time)dateTimeValue);
                break;
            }
            case 9: {
                this.checkCapacity(12L);
                this.insertIndicator(16L);
                Object dateTimeValue = ((TimeRepresentation)theValue).getRawDateTimeValue();
                this.insertTimestampData((Timestamp)dateTimeValue);
                break;
            }
            case 10: 
            case 11: {
                out = this.insertStringData((String)theValue, false);
                break;
            }
            case 12: 
            case 13: {
                byte[] tb = (byte[])theValue;
                out = this.insertByteData(tb, false);
                break;
            }
            case 14: 
            case 15: {
                this.checkCapacity(32L);
                this.insertIndicator(19L);
                this.InsertNumericData((BigDecimal)theValue);
                break;
            }
            case 16: {
                this.checkCapacity(1L);
                this.insertIndicator(-2L);
                break;
            }
            case 17: {
                this.checkCapacity(1L);
                this.insertIndicator(-2L);
                break;
            }
            default: {
                if (!AbstractLogger.isTrace) break;
                logger.trace("INVALID DATA TYPE DETECTED while precessing parameter=[" + ordinal + "] ");
            }
        }
        return out;
    }
}

