/*
 * Decompiled with CFR 0.152.
 */
package com.sas.tkts.info;

import com.sas.tkts.info.PackedParameterSetBuffer;
import com.sas.tkts.info.ParameterInfo;
import com.sas.tkts.util.CharSetUtil;
import com.sas.tkts.util.TimeRepresentation;
import java.math.BigDecimal;
import java.nio.charset.Charset;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;

public class PackedParameterSetBufferPT0
extends PackedParameterSetBuffer {
    public PackedParameterSetBufferPT0() {
    }

    public PackedParameterSetBufferPT0(int bytes) {
        super(bytes);
    }

    @Override
    public void addColumnNumbers(ParameterInfo[] pia) {
    }

    public void insertOrdinalAndIndicator(int ordinal, long indicatorValue) {
        this.packedByteBuffer.putInt(ordinal);
        if (indicatorValue <= 127L) {
            this.packedByteBuffer.put((byte)indicatorValue);
        } else if (indicatorValue <= 32767L) {
            this.packedByteBuffer.put((byte)-8);
            this.packedByteBuffer.putShort((short)indicatorValue);
        } else if (indicatorValue <= Integer.MAX_VALUE) {
            this.packedByteBuffer.put((byte)-6);
            this.packedByteBuffer.putInt((int)indicatorValue);
        } else {
            this.packedByteBuffer.put((byte)-9);
            this.packedByteBuffer.putLong(indicatorValue);
        }
    }

    public int insertStringData(int ordinal, String value) {
        int dataStartIndx = 0;
        int bytesNeeded = 5;
        if (value.equals("")) {
            this.checkCapacity(bytesNeeded);
            this.insertOrdinalAndIndicator(ordinal, 0L);
            bytesNeeded = 0;
        } else {
            Charset insertCharSet = CharSetUtil.getToServerCharset();
            byte[] valueBytes = value.getBytes(insertCharSet);
            int dataLength = valueBytes.length;
            short indicatorSizeInBytes = this.resolveIndicatorSizeInBytes(dataLength);
            dataStartIndx = this.getCurrentPosition() + 4 + indicatorSizeInBytes;
            bytesNeeded = 8 + indicatorSizeInBytes + dataLength;
            this.checkCapacity(bytesNeeded);
            this.insertOrdinalAndIndicator(ordinal, dataLength);
            this.setCurrentPosition(dataStartIndx);
            this.packedByteBuffer.putInt(dataLength);
            this.packedByteBuffer.put(valueBytes);
            bytesNeeded = valueBytes.length;
        }
        return bytesNeeded;
    }

    public int insertByteData(int ordinal, byte[] value) {
        int dataLength;
        int totalBytes = 5;
        if (value.length == 0) {
            this.checkCapacity(totalBytes);
            this.insertOrdinalAndIndicator(ordinal, 0L);
            dataLength = 0;
        } else {
            dataLength = value.length;
            short indicatorSizeInBytes = this.resolveIndicatorSizeInBytes(dataLength);
            totalBytes = 8 + indicatorSizeInBytes + dataLength;
            this.checkCapacity(totalBytes);
            this.insertOrdinalAndIndicator(ordinal, dataLength);
            this.packedByteBuffer.putInt(dataLength);
            this.packedByteBuffer.put(value);
        }
        return dataLength;
    }

    @Override
    public int packParameterValue(int ordinal, Object theValue, Object ptype) {
        int out = 0;
        PackedParameterSetBuffer.ParameterType pt = (PackedParameterSetBuffer.ParameterType)ptype;
        switch (pt.getIndex()) {
            case 0: {
                this.checkCapacity(5L);
                this.insertOrdinalAndIndicator(ordinal, -1L);
                break;
            }
            case 1: {
                this.checkCapacity(13L);
                this.insertOrdinalAndIndicator(ordinal, 8L);
                Number number = (Number)theValue;
                this.packedByteBuffer.putDouble(number.doubleValue());
                break;
            }
            case 2: {
                this.checkCapacity(9L);
                this.insertOrdinalAndIndicator(ordinal, 4L);
                Number number = (Number)theValue;
                this.packedByteBuffer.putFloat(number.floatValue());
                break;
            }
            case 3: {
                this.checkCapacity(6L);
                this.insertOrdinalAndIndicator(ordinal, 1L);
                Number number = (Number)theValue;
                this.packedByteBuffer.put(number.byteValue());
                break;
            }
            case 4: {
                this.checkCapacity(7L);
                this.insertOrdinalAndIndicator(ordinal, 2L);
                Number number = (Number)theValue;
                this.packedByteBuffer.putShort(number.shortValue());
                break;
            }
            case 5: {
                this.checkCapacity(9L);
                this.insertOrdinalAndIndicator(ordinal, 4L);
                Number number = (Number)theValue;
                this.packedByteBuffer.putInt(number.intValue());
                break;
            }
            case 6: {
                this.checkCapacity(13L);
                this.insertOrdinalAndIndicator(ordinal, 8L);
                Number number = (Number)theValue;
                this.packedByteBuffer.putLong(number.longValue());
                break;
            }
            case 7: {
                this.checkCapacity(9L);
                this.insertOrdinalAndIndicator(ordinal, 6L);
                Object dateTimeValue = ((TimeRepresentation)theValue).getRawDateTimeValue();
                this.insertDateData((Date)dateTimeValue);
                break;
            }
            case 8: {
                this.checkCapacity(8L);
                this.insertOrdinalAndIndicator(ordinal, 6L);
                Object dateTimeValue = ((TimeRepresentation)theValue).getRawDateTimeValue();
                this.insertTimeData((Time)dateTimeValue);
                break;
            }
            case 9: {
                this.checkCapacity(16L);
                this.insertOrdinalAndIndicator(ordinal, 16L);
                Object dateTimeValue = ((TimeRepresentation)theValue).getRawDateTimeValue();
                this.insertTimestampData((Timestamp)dateTimeValue);
                break;
            }
            case 10: 
            case 11: {
                out = this.insertStringData(ordinal, (String)theValue);
                break;
            }
            case 12: 
            case 13: {
                byte[] tb = (byte[])theValue;
                out = this.insertByteData(ordinal, tb);
                break;
            }
            case 14: {
                break;
            }
            case 15: {
                this.checkCapacity(32L);
                this.insertOrdinalAndIndicator(ordinal, 19L);
                this.InsertNumericData((BigDecimal)theValue);
                break;
            }
            case 16: 
            case 17: {
                this.checkCapacity(5L);
                this.insertOrdinalAndIndicator(ordinal, -2L);
                break;
            }
            default: {
                logger.trace("INVALID DATA TYPE DETECTED while precessing parameter=[" + ordinal + "]  ");
            }
        }
        return out;
    }
}

