/*
 * Decompiled with CFR 0.152.
 */
package com.sas.tkts.info;

import com.sas.iom.SASIOMDefs.AnySeqHolder;
import com.sas.iom.SASIOMDefs.LongSeqHelper;
import com.sas.iom.SASIOMDefs.StringSeqHelper;
import com.sas.iom.SASIOMDefs.VariableArray2dOfLongHolder;
import com.sas.tkts.iom.StatementWrapper;
import com.sas.tkts.logging.AbstractLogger;
import com.sas.tkts.logging.LoggerFactory;
import com.sas.tkts.sql.LocalizedErrorHandler;
import java.sql.SQLException;
import org.omg.CORBA.Any;
import org.omg.CORBA.IntHolder;

public class ColumnsAttributes {
    private static String thisClassName = ColumnsAttributes.class.getName();
    private static AbstractLogger logger = LoggerFactory.getLogger(thisClassName);
    private transient StatementWrapper statementWrapper;
    private transient int numberOfColumns;
    private transient int[] sqlTypes;
    private transient int[] conciseTypes;
    private transient int[] lengths;
    private transient int[] scales;
    private transient int[] nullables;
    private transient int[] encodings;
    private transient int[] nativeCType;
    private transient int[] precision;
    private transient String[] names;

    public ColumnsAttributes(StatementWrapper stmtIOMWrapper, int columnCount) throws SQLException {
        this.statementWrapper = stmtIOMWrapper;
        this.numberOfColumns = columnCount;
        this.getColumnAttributes();
    }

    private void getColumnAttributes() throws SQLException {
        String method = "getColumnAttributes()";
        if (AbstractLogger.isTrace) {
            logger.trace(method, "Get column attributes.");
        }
        int[] columnNumbers = new int[this.numberOfColumns];
        for (int i = 0; i < this.numberOfColumns; ++i) {
            columnNumbers[i] = i + 1;
        }
        AnySeqHolder attrValues = new AnySeqHolder();
        VariableArray2dOfLongHolder attrStatus = new VariableArray2dOfLongHolder();
        IntHolder colStatus = new IntHolder();
        int TKTS_DESC_PRECISION2 = 1005;
        int[] attributeIDs = new int[]{1002, 6, 1006, 1008, 10015, 10002, 1005, 2, 1011};
        int[] attributeDataTypes = new int[]{-5, -5, -5, -5, -5, -5, -5, -5, 0};
        try {
            this.statementWrapper.ColAttributes(columnNumbers, attributeIDs, attributeDataTypes, attrValues, attrStatus, colStatus);
        }
        catch (Exception te) {
            LocalizedErrorHandler.handleExceptionsInFunction(method, te, this.statementWrapper, logger);
        }
        int attrValuesToProcess = attrValues.value.length;
        if (AbstractLogger.isTrace) {
            logger.trace(method, " attrValuesToProcess[" + attrValuesToProcess + "]");
        }
        block16: for (int y = 0; y < attrValuesToProcess; ++y) {
            if (y < 8) {
                switch (y) {
                    case 0: {
                        this.sqlTypes = LongSeqHelper.extract((Any)attrValues.value[y]);
                        break;
                    }
                    case 1: {
                        this.lengths = LongSeqHelper.extract((Any)attrValues.value[y]);
                        break;
                    }
                    case 2: {
                        this.scales = LongSeqHelper.extract((Any)attrValues.value[y]);
                        break;
                    }
                    case 3: {
                        this.nullables = LongSeqHelper.extract((Any)attrValues.value[y]);
                        break;
                    }
                    case 4: {
                        this.encodings = LongSeqHelper.extract((Any)attrValues.value[y]);
                        break;
                    }
                    case 5: {
                        this.nativeCType = LongSeqHelper.extract((Any)attrValues.value[y]);
                        break;
                    }
                    case 6: {
                        this.precision = LongSeqHelper.extract((Any)attrValues.value[y]);
                        break;
                    }
                    case 7: {
                        this.conciseTypes = LongSeqHelper.extract((Any)attrValues.value[y]);
                        break;
                    }
                }
                continue;
            }
            switch (y) {
                case 8: {
                    this.names = StringSeqHelper.extract((Any)attrValues.value[y]);
                    continue block16;
                }
            }
        }
        attrValuesToProcess = 0;
        for (int i = 0; i < this.sqlTypes.length; ++i) {
            if (this.sqlTypes[i] != 9) continue;
            this.sqlTypes[i] = this.conciseTypes[i];
        }
    }

    public int getNativeCType(int attrIndx) {
        return this.nativeCType[attrIndx];
    }

    public int getNumberOfColumns() {
        return this.names.length;
    }

    public int getSQLType(int attrIndx) {
        return this.sqlTypes[attrIndx];
    }

    public int getLength(int attrIndx) {
        return this.lengths[attrIndx];
    }

    public int getScale(int attrIndx) {
        return this.scales[attrIndx];
    }

    public int getPrecision(int attrIndx) {
        return this.precision[attrIndx];
    }

    public int getNullable(int attrIndx) {
        return this.nullables[attrIndx];
    }

    public int getEncoding(int attrIndx) {
        return this.encodings[attrIndx];
    }

    public String getName(int attrIndx) {
        return this.names[attrIndx];
    }
}

