/*
 * Decompiled with CFR 0.152.
 */
package com.sas.tkts.caching;

import com.sas.tkts.TKTSDriver;
import com.sas.tkts.caching.AbstractRowCache;
import com.sas.tkts.caching.PrefetchData;
import com.sas.tkts.caching.Row;
import com.sas.tkts.iom.StatementWrapper;
import com.sas.tkts.logging.AbstractLogger;
import com.sas.tkts.logging.LoggerFactory;
import com.sas.tkts.sql.FSStatement;
import com.sas.tkts.sql.LocalizedErrorHandler;
import com.sas.tkts.util.Hits;
import com.sas.tkts.util.Timings;
import java.sql.SQLException;
import java.util.Comparator;
import java.util.PriorityQueue;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.locks.ReentrantLock;

public class PrefetchControl
extends Thread {
    private static String thisClassName = AbstractRowCache.class.getName();
    private static AbstractLogger logger = LoggerFactory.getLogger(thisClassName);
    private static AbstractLogger prefetchLogger = LoggerFactory.getLogger("com.sas.tkts.prefetch");
    private final int UNPACK_THREADS_MAX = 3;
    private final int UNPACK_THREADS_START = 1;
    private final int PREFETCH_ENTRIES_MAX = 6;
    private final int PREFETCH_ENTRIES = 4;
    protected static boolean debugThread = TKTSDriver.prefetchDebugEnabled();
    protected static boolean debugThreadTrace = TKTSDriver.prefetchTraceEnabled();
    protected static boolean debugSummary = TKTSDriver.prefetchSummaryEnabled();
    protected static boolean debugSamples = false;
    protected static boolean debugRows = false;
    protected transient String threadStr;
    protected transient Exception threadException;
    protected transient AbstractRowCache arc;
    protected transient StatementWrapper statementWrapper;
    protected transient int numberEntries;
    protected transient int unpackThreadsCurrent;
    protected transient int unpackThreadsMax;
    protected transient long logStartTime;
    protected transient PriorityQueue<PrefetchData> dataQueue;
    protected transient long dataQueuePostStart;
    protected transient LinkedBlockingDeque<PrefetchData> freeQueue;
    protected transient LinkedBlockingDeque<PrefetchData> unpackQueue;
    protected transient Timings applicationWaitTimings;
    protected transient Hits applicationHits;
    protected transient Hits unpackHits;
    protected transient long unpackThreshold;
    protected transient long lastUnpackHits;
    protected transient long lastUnpackMisses;
    protected transient long fetchNumberApplication;
    protected transient DataSourceThread dataSourceThread;
    protected transient UnpackThread[] unpackThreads;
    protected transient long fetchLastEnd;
    protected transient long fetchStartOfData;
    protected transient boolean fetchEndOfData;
    protected transient long fetchNumberDataSource;
    protected transient long fetchBytesDataSource;
    protected transient long fetchRowsDataSource;
    protected transient Timings fetchDelayTimings;
    protected transient Timings fetchDurationTimings;
    protected transient Timings unpackTimings;
    protected transient Timings postTimings;
    protected transient Hits freeQueueHits;
    protected transient String takeStatus;
    protected transient ReentrantLock logLock;

    public static long deltaMicroSeconds(long start) {
        return (System.nanoTime() - start) / 1000L;
    }

    public static double toSeconds(long microseconds) {
        double toSeconds = 1000000.0;
        double out = microseconds;
        return out /= toSeconds;
    }

    public static double toMilliSeconds(long microseconds) {
        double toSeconds = 1000.0;
        double out = microseconds;
        return out /= toSeconds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void debugThreadLife(String ... texts) {
        if (!debugThread) {
            return;
        }
        String o = "";
        for (int i = 0; i < texts.length; ++i) {
            o = o + texts[i];
        }
        try {
            this.logLock.lock();
            prefetchLogger.debug(o);
        }
        finally {
            this.logLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void debugThreadError(String ... texts) {
        if (!debugThread) {
            return;
        }
        String o = "";
        for (int i = 0; i < texts.length; ++i) {
            o = o + texts[i];
        }
        try {
            this.logLock.lock();
            prefetchLogger.error(o);
        }
        finally {
            this.logLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void debugThreadDebug(String ... texts) {
        String o = "";
        for (int i = 0; i < texts.length; ++i) {
            o = o + texts[i];
        }
        try {
            this.logLock.lock();
            prefetchLogger.debug(o);
        }
        finally {
            this.logLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void debugThreadTrace(String ... texts) {
        if (!debugThreadTrace) {
            return;
        }
        String o = "";
        for (int i = 0; i < texts.length; ++i) {
            o = o + texts[i];
        }
        try {
            this.logLock.lock();
            prefetchLogger.trace(o);
        }
        finally {
            this.logLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void debugThreadSummary(String ... texts) {
        if (!debugSummary) {
            return;
        }
        String o = "";
        for (int i = 0; i < texts.length; ++i) {
            o = o + texts[i];
        }
        try {
            this.logLock.lock();
            prefetchLogger.info(o);
        }
        finally {
            this.logLock.unlock();
        }
    }

    public PrefetchControl(AbstractRowCache abstractRowCache, StatementWrapper inStatementWrapper) {
        int i;
        String o;
        String fmt = "%sPrefetchControl: StatementHandle[%s] %s ";
        String afmt = "%sAbstractRowCache[%d] ";
        String exitDebug = "";
        String n = "A-" + this.getName();
        this.threadStr = String.format("[%12s] ", n);
        this.arc = abstractRowCache;
        this.statementWrapper = inStatementWrapper;
        this.dataQueue = new PriorityQueue<PrefetchData>(18, new PrefetchDataComparator());
        this.freeQueue = new LinkedBlockingDeque(12);
        this.unpackQueue = new LinkedBlockingDeque(12);
        this.applicationWaitTimings = new Timings(this.threadStr, "ApplicationWait", debugSummary, debugSamples, prefetchLogger);
        this.applicationHits = new Hits(this.threadStr, "ApplicationFetch", debugSummary, prefetchLogger);
        this.unpackHits = new Hits(this.threadStr, "unpack", debugSummary, prefetchLogger);
        this.unpackThreshold = 20L;
        this.fetchNumberDataSource = 0L;
        this.fetchNumberApplication = 0L;
        this.fetchEndOfData = false;
        this.logLock = new ReentrantLock();
        this.unpackThreadsMax = 3;
        this.unpackThreadsCurrent = 1;
        if (this.unpackThreadsMax > 0) {
            --this.unpackThreadsMax;
            if (this.unpackThreadsMax < 1) {
                this.unpackThreadsCurrent = this.unpackThreadsMax;
            }
            this.numberEntries = this.unpackThreadsCurrent + 3;
        } else {
            this.unpackThreadsMax = 3;
            this.numberEntries = 4;
        }
        this.logStartTime = System.nanoTime();
        this.logStartTime /= 1000L;
        if (debugThread) {
            String statementInfo = null;
            String statementSQL = null;
            o = String.format("%sAbstractRowCache[%d] ", this.threadStr, abstractRowCache.getMyID());
            this.debugThreadLife(o);
            if (inStatementWrapper == null) {
                o = String.format("%sPrefetchControl: StatementHandle[%s] %s ", this.threadStr, "null", "enter");
                exitDebug = String.format("%sPrefetchControl: StatementHandle[%s] %s ", this.threadStr, "null", "enter");
            } else {
                FSStatement fsStmt = inStatementWrapper.getFSStatement();
                statementInfo = "unknown";
                if (fsStmt != null) {
                    statementInfo = "STMT_ID:" + fsStmt.getMyID();
                    statementSQL = fsStmt.getLastSQL();
                }
                o = String.format("%sPrefetchControl: StatementHandle[%s] %s ", this.threadStr, statementInfo, "enter");
                exitDebug = String.format("%sPrefetchControl: StatementHandle[%s] %s ", this.threadStr, statementInfo, "exit");
            }
            this.debugThreadLife(o);
            if (statementSQL != null) {
                statementSQL = this.threadStr + statementSQL;
                this.debugThreadLife(statementSQL);
            }
        }
        for (i = 0; i < this.numberEntries; ++i) {
            PrefetchData pe = new PrefetchData(this);
            try {
                this.freeQueue.put(pe);
                continue;
            }
            catch (InterruptedException ie) {
                o = this.threadStr + "Exception: " + ie;
                this.debugThreadError(o);
            }
        }
        this.fetchDelayTimings = new Timings(this.threadStr, "FetchDelay", debugSummary, debugSamples, prefetchLogger);
        this.fetchDurationTimings = new Timings(this.threadStr, "FetchDuration", debugSummary, debugSamples, prefetchLogger);
        this.freeQueueHits = new Hits(this.threadStr, "FreeQueue", debugSummary, prefetchLogger);
        this.unpackTimings = new Timings(this.threadStr, "Unpack", debugSummary, debugSamples, prefetchLogger);
        this.postTimings = new Timings(this.threadStr, "Post", debugSummary, debugSamples, prefetchLogger);
        this.fetchStartOfData = System.nanoTime();
        this.dataSourceThread = new DataSourceThread(this);
        this.unpackThreads = new UnpackThread[3];
        for (i = 0; i < this.unpackThreadsCurrent; ++i) {
            this.unpackThreads[i] = new UnpackThread(this);
        }
        if (debugThread) {
            this.debugThreadLife(exitDebug);
        }
    }

    public String nowMicroseconds(long now) {
        now /= 1000L;
        String o = String.format("[%12d]:", now -= this.logStartTime);
        return o;
    }

    public void logRows(PrefetchData pe, String pStr) {
        if (pe == null || pe.rows_data_cache == null || pe.rows_data_cache.size() == 0) {
            return;
        }
        Row row = pe.rows_data_cache.get(0);
        int last = 0;
        String FMT = "%sfetchNumber:%12d %s Row[%12d]: Values: %s";
        String o = String.format("%sfetchNumber:%12d %s Row[%12d]: Values: %s", pStr, pe.fetchNumber, "first", last, row.toString());
        this.debugThreadTrace(o);
        last = pe.rows_data_cache.size();
        row = pe.rows_data_cache.get(--last);
        o = String.format("%sfetchNumber:%12d %s Row[%12d]: Values: %s", pStr, pe.fetchNumber, "last ", last, row.toString());
        this.debugThreadTrace(o);
    }

    protected void fetchFromDataSource(PrefetchData pe, PrefetchThread pThread) {
        boolean fetchOrientation = true;
        boolean fetchOffset = false;
        String pStr = pThread.threadStr;
        pThread.threadStatus = "fetchFromDataSource enter ";
        if (pThread.terminate) {
            return;
        }
        pe.reset();
        long start = System.nanoTime();
        try {
            String o;
            if (this.fetchLastEnd > 0L) {
                this.fetchDelayTimings.update(this.fetchLastEnd, start);
            }
            if (this.statementWrapper == null) {
                this.debugThreadError("statementWrapper == null");
            }
            this.statementWrapper.FetchScroll2(1, 0L, pe.bookmarkArray, pe.rowsFetched, pe.rowStatus, pe.packedRowsBuffer, pe.status);
            this.fetchLastEnd = this.fetchDurationTimings.update(start);
            pe.fetchNumber = this.fetchNumberDataSource++;
            if (pe.packedRowsBuffer.value != null) {
                this.fetchBytesDataSource += (long)pe.packedRowsBuffer.value.length;
            }
            if (pe.rowStatus.value != null) {
                this.fetchRowsDataSource += (long)pe.rowStatus.value.length;
            }
            if (pe.status.value == -2130708476 || pe.rowStatus.value.length == 0) {
                this.fetchEndOfData = true;
                if (debugThread) {
                    double d = PrefetchControl.toSeconds(PrefetchControl.deltaMicroSeconds(this.fetchStartOfData));
                    o = String.format(pStr + "fetchFromDataSource:EndOfDataReached duration(seconds): %10.4f", d);
                    this.debugThreadDebug(o);
                }
            }
            if (debugThreadTrace) {
                long delta = (this.fetchLastEnd - start) / 1000L;
                o = String.format(pStr + "fetchFromDataSource: fetchTime(us): %12d  %s", delta, pe.toString());
                this.debugThreadTrace(o);
            }
        }
        catch (Exception ex) {
            pe.fetchEx = LocalizedErrorHandler.createExceptionsInFunction("FetchScroll2", ex, this.statementWrapper, null);
            this.handleThreadException(pe.fetchEx);
        }
        pThread.threadStatus = "fetchFromDataSource exit ";
    }

    private void unpackResultSet(PrefetchData pe, PrefetchThread pThread) {
        String o;
        pThread.threadStatus = "unpackResultSet(pe) debugTrace";
        if (debugThreadTrace) {
            this.debugThreadTrace(pThread.threadStr, pe.toString());
        }
        pThread.threadStatus = "unpackResultSet(pe) before";
        String pStr = pThread.threadStr;
        long start = System.nanoTime();
        if (pe == null) {
            pThread.threadStatus = "null";
        }
        if (pe.status == null) {
            pThread.threadStatus = "pe.status == null";
        }
        if (pe.rowStatus == null || pe.rowStatus.value == null) {
            pThread.threadStatus = "pe.rowStatus == null";
        }
        if (pe.packedRowsBuffer == null || pe.packedRowsBuffer.value == null) {
            pThread.threadStatus = "pe.packedRowsBuffer == null";
        }
        pThread.threadStatus = "unpackResultSet(pe) pe.status.value";
        if (pe.status.value != -2130708476 && pe.rowStatus.value.length > 0) {
            int cacheOffset = 0;
            try {
                pThread.threadStatus = "unpackResultSet(pe) prepareToUnpackDataAndCache";
                pe.rows_data_cache = this.arc.prepareToUnpackDataAndCache(pe.packedRowsBuffer.value, pe.rowStatus.value, cacheOffset, pe.rows_data_cache);
                pThread.threadStatus = "unpackResultSet(pe) unpackTimings";
                this.unpackTimings.update(start);
            }
            catch (SQLException se) {
                o = pStr + "ERROR: unpackResultSet Exception: " + se;
                this.debugThreadError(o);
                pe.fetchEx = se;
            }
            if (debugRows) {
                this.logRows(pe, pStr);
            }
        }
        if (debugThreadTrace) {
            long delta = PrefetchControl.deltaMicroSeconds(start);
            o = pStr + "unpackResultSet:Duration(us): " + delta + " " + pe.toString();
            this.debugThreadTrace(o);
        }
        pThread.threadStatus = "unpackResultSet after";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PrefetchData getReadyEntry() {
        Object o;
        int entries = 0;
        PrefetchData out = null;
        long start = System.nanoTime();
        if (debugThreadTrace) {
            o = this.threadStr + "getReadyEntry: fetchNumberApplication: " + this.fetchNumberApplication;
            this.debugThreadTrace(new String[]{o});
        }
        try {
            this.takeStatus = "before dataQueue.take()";
            o = this.dataQueue;
            synchronized (o) {
                this.dataQueuePostStart = 0L;
                out = this.dataQueue.peek();
                if (out == null || this.fetchNumberApplication != out.fetchNumber) {
                    this.applicationHits.update(null);
                    this.dataQueue.wait();
                    if (this.dataQueuePostStart > 0L) {
                        this.postTimings.update(this.dataQueuePostStart);
                    }
                    this.dataQueuePostStart = 0L;
                } else {
                    this.applicationHits.update(out);
                }
                out = this.dataQueue.poll();
                entries = this.dataQueue.size();
                if (this.fetchNumberApplication != out.fetchNumber) {
                    this.debugThreadError("Expected: " + this.fetchNumberApplication + " Actual: " + out.toString());
                }
                ++this.fetchNumberApplication;
                out.fetchEx = this.threadException;
            }
            this.takeStatus = "after dataQueue.take()";
        }
        catch (InterruptedException ie) {
            String o2 = "getReadyEntry: " + ie;
            this.debugThreadError(o2);
        }
        if (out.fetchEx == null) {
            this.applicationWaitTimings.update(start);
            if (debugThreadTrace) {
                long delta = PrefetchControl.deltaMicroSeconds(start);
                o = this.threadStr + "getReadyEntry:Duration(us): " + delta + " entries: " + entries + " " + out.toString();
                this.debugThreadTrace(new String[]{o});
            }
            if (debugRows) {
                this.logRows(out, this.threadStr);
            }
        }
        return out;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void putReadyEntry(PrefetchData pe, PrefetchThread pThread) {
        Object o;
        long start = 0L;
        int entries = 0;
        String pStr = "";
        pStr = pThread.threadStr;
        if (pThread.terminate) {
            return;
        }
        pThread.threadStatus = "putReadyEntry before synchronized";
        if (debugThreadTrace) {
            start = System.nanoTime();
            o = pStr + "putReadyEntry: fetchNumberApplication: " + this.fetchNumberApplication + " " + pe.toString();
            this.debugThreadTrace(new String[]{o});
        }
        o = this.dataQueue;
        synchronized (o) {
            this.dataQueuePostStart = 0L;
            this.dataQueue.add(pe);
            entries = this.dataQueue.size();
            if (this.fetchNumberApplication == pe.fetchNumber) {
                this.dataQueuePostStart = System.nanoTime();
                this.dataQueue.notify();
            }
        }
        if (debugThreadTrace) {
            long delta = PrefetchControl.deltaMicroSeconds(start);
            o = pStr + "putReadyEntry Duration(us): " + delta + " dataQueueEntries: " + entries;
            this.debugThreadTrace(new String[]{o});
        }
        pThread.threadStatus = "putReadyEntry exiting ";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void adjustUnpackThreadPriorities() {
        long n0 = Long.MAX_VALUE;
        PrefetchThread pt0 = null;
        long n1 = Long.MAX_VALUE;
        PrefetchThread pt1 = null;
        UnpackThread[] unpackThreadArray = this.unpackThreads;
        synchronized (this.unpackThreads) {
            UnpackThread pt;
            int i;
            for (i = 0; i < this.unpackThreads.length; ++i) {
                pt = this.unpackThreads[i];
                if (pt == null || pt.unpackFetchNumber >= n0) continue;
                n0 = pt.unpackFetchNumber;
                pt0 = pt;
            }
            for (i = 0; i < this.unpackThreads.length; ++i) {
                pt = this.unpackThreads[i];
                if (pt == null || pt.unpackFetchNumber == n0 || pt.unpackFetchNumber >= n1) continue;
                n1 = pt.unpackFetchNumber;
                pt1 = pt;
            }
            if (pt0 != null) {
                pt0.increasePriority(true);
            }
            if (pt1 != null) {
                pt1.increasePriority(false);
            }
            // ** MonitorExit[var7_5] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void logMeasurements() {
        if (!debugSummary) {
            return;
        }
        if (this.arc == null) {
            this.debugThreadError("arc == null");
        }
        long rtt = this.arc.getRTT();
        String b = this.fetchDurationTimings.hasDataString();
        if (!this.fetchDurationTimings.hasData()) {
            String h = this.fetchDurationTimings.hasDataString();
            String m = String.format("logMeasurements: No Data:  %s", h);
            prefetchLogger.info(m);
            return;
        }
        if (debugSummary) {
            String o = rtt > 0L ? this.threadStr + " NumberEntries: " + this.numberEntries + " unpackThreadsCurrent: " + this.unpackThreadsCurrent + " ServerRTT(us): " + rtt : this.threadStr + " NumberEntries: " + this.numberEntries + " unpackThreadsCurrent: ";
            this.debugThreadSummary(o);
            try {
                this.logLock.lock();
                this.fetchDelayTimings.log();
                this.fetchDurationTimings.log();
                this.applicationWaitTimings.log();
                this.unpackTimings.log();
                this.postTimings.log();
                this.applicationHits.log();
                this.unpackHits.log();
                this.freeQueueHits.log();
            }
            finally {
                this.logLock.unlock();
            }
        }
    }

    private void signalTerminate(PrefetchThread pt) {
        if (pt != null) {
            this.debugThreadLife(this.threadStr, "Signal Thread to terminate", pt.threadStr, pt.threadStatus);
            pt.terminate();
        }
    }

    private void stopThread(PrefetchThread pt) {
        if (pt != null) {
            try {
                this.debugThreadLife(this.threadStr, "Join Before ", pt.threadStr, pt.threadStatus);
                pt.join();
                this.debugThreadLife(this.threadStr, "Join After ", pt.threadStr, pt.threadStatus);
            }
            catch (Exception ex) {
                String o = "prefetchThread.join() " + ex.toString();
                this.debugThreadError(o);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleThreadException(Exception ex) {
        this.debugThreadError("handleThreadException: ", ex.toString());
        this.threadException = ex;
        PrefetchData pe = new PrefetchData(this);
        pe.fetchNumber = Long.MAX_VALUE;
        pe.fetchEx = ex;
        UnpackThread[] unpackThreadArray = this.dataQueue;
        synchronized (this.dataQueue) {
            this.dataQueuePostStart = 0L;
            pe.fetchNumber = this.fetchNumberApplication;
            this.dataQueue.clear();
            this.dataQueue.add(pe);
            this.dataQueuePostStart = System.nanoTime();
            this.dataQueue.notify();
            // ** MonitorExit[var3_3] (shouldn't be in output)
            this.signalTerminate(this.dataSourceThread);
            unpackThreadArray = this.unpackThreads;
            synchronized (this.unpackThreads) {
                for (int i = 0; i < this.unpackThreads.length; ++i) {
                    UnpackThread pt = this.unpackThreads[i];
                    this.signalTerminate(pt);
                }
                // ** MonitorExit[var3_3] (shouldn't be in output)
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanup() {
        this.debugThreadLife(this.threadStr, "Cleanup start");
        this.signalTerminate(this.dataSourceThread);
        UnpackThread[] unpackThreadArray = this.unpackThreads;
        synchronized (this.unpackThreads) {
            UnpackThread pt;
            int i;
            for (i = 0; i < this.unpackThreads.length; ++i) {
                pt = this.unpackThreads[i];
                this.signalTerminate(pt);
            }
            PrefetchData pe = new PrefetchData(this);
            pe.fetchNumber = Long.MAX_VALUE;
            this.putFreeEntry(pe, this.threadStr);
            // ** MonitorExit[var2_1] (shouldn't be in output)
            this.debugThreadLife(this.threadStr, "Stopping DataSourceThread");
            pe = new PrefetchData(this);
            pe.fetchNumber = Long.MAX_VALUE;
            this.putFreeEntry(pe, this.threadStr);
            this.stopThread(this.dataSourceThread);
            this.dataSourceThread = null;
            this.debugThreadLife(this.threadStr, "Stopping all UnpackThreads");
            unpackThreadArray = this.unpackThreads;
            synchronized (this.unpackThreads) {
                for (i = 0; i < this.unpackThreads.length; ++i) {
                    pe = new PrefetchData(this);
                    pe.fetchNumber = Long.MAX_VALUE;
                    this.putUnpackQueue(pe, this.threadStr);
                }
                for (i = 0; i < this.unpackThreads.length; ++i) {
                    pt = this.unpackThreads[i];
                    this.stopThread(pt);
                    this.unpackThreads[i] = null;
                }
                // ** MonitorExit[var2_1] (shouldn't be in output)
                this.debugThreadLife(this.threadStr, "clearing Queues");
                while (this.dataQueue.size() > 0) {
                    pe = this.dataQueue.poll();
                    pe.cleanup();
                }
                this.dataQueue.clear();
                while (this.unpackQueue.size() > 0) {
                    try {
                        pe = this.unpackQueue.take();
                    }
                    catch (InterruptedException ie) {
                        this.debugThreadError(this.threadStr, " unpackQueue.take(): ", ie.toString());
                    }
                    pe.cleanup();
                }
                this.unpackQueue.clear();
                while (this.freeQueue.size() > 0) {
                    try {
                        pe = this.freeQueue.take();
                    }
                    catch (InterruptedException ie) {
                        this.debugThreadError(this.threadStr, " freeQueue.take();: ", ie.toString());
                    }
                    pe.cleanup();
                }
                this.freeQueue.clear();
                this.debugThreadLife(this.threadStr, "Cleanup end");
                this.arc = null;
                this.statementWrapper = null;
                this.fetchDelayTimings.cleanup();
                this.fetchDurationTimings.cleanup();
                this.unpackTimings.cleanup();
                this.postTimings.cleanup();
                this.dataQueue = null;
                this.freeQueue = null;
                this.unpackQueue = null;
                this.applicationWaitTimings.cleanup();
                return;
            }
        }
    }

    protected PrefetchData getFreeEntry(PrefetchThread pThread) {
        String o;
        long start = 0L;
        PrefetchData pe = null;
        int entries = 0;
        pThread.threadStatus = "getFreeEntry:enter";
        String pStr = pThread.threadStr;
        if (debugThreadTrace) {
            start = System.nanoTime();
            o = pStr + "getFreeEntry: enter";
            this.debugThreadTrace(o);
        }
        try {
            pe = this.freeQueue.peek();
            this.freeQueueHits.update(pe);
            pe = this.freeQueue.take();
            entries = this.freeQueue.size();
            pThread.threadStatus = "after freeQueue.take()";
        }
        catch (InterruptedException ie) {
            String o2 = pStr + "getFreeEntry: " + ie;
            this.debugThreadError(o2);
        }
        if (debugThreadTrace) {
            long delta = PrefetchControl.deltaMicroSeconds(start);
            o = pStr + "getFreeEntry:Duration(us): " + delta + " entries: " + entries;
            this.debugThreadTrace(o);
        }
        pThread.threadStatus = "getFreeEntry:exit";
        return pe;
    }

    protected void putFreeEntry(PrefetchData pe, String pStr) {
        long start = 0L;
        int entries = 0;
        if (pStr == null) {
            pStr = this.threadStr;
        }
        if (debugThreadTrace) {
            start = System.nanoTime();
            String o = pStr + "putFreeEntry: " + pe.toString();
            this.debugThreadTrace(o);
        }
        pe.reset();
        try {
            this.freeQueue.put(pe);
            entries = this.freeQueue.size();
        }
        catch (InterruptedException ie) {
            String o = pStr + "PrefetchControl.freePrefetchEntry(): " + ie;
            this.debugThreadError(o);
        }
        if (debugThreadTrace) {
            long delta = PrefetchControl.deltaMicroSeconds(start);
            String o = pStr + "putFreeEntry:Duration(us): " + delta + " entries: " + entries;
            this.debugThreadTrace(o);
        }
    }

    protected PrefetchData getUnpackQueue(PrefetchThread pThread) {
        String o;
        long start = 0L;
        PrefetchData pe = null;
        int entries = 0;
        pThread.threadStatus = "getUnpackQueue:before";
        String pStr = pThread.threadStr;
        if (debugThreadTrace) {
            start = System.nanoTime();
            o = pStr + "getUnpackQueue: ";
            this.debugThreadTrace(o);
        }
        try {
            PrefetchData pePeek = this.unpackQueue.peek();
            this.unpackHits.update(pePeek);
            pe = this.unpackQueue.take();
            entries = this.unpackQueue.size();
        }
        catch (InterruptedException ie) {
            String o2 = pStr + "getUnpackQueue: " + ie;
            this.debugThreadError(o2);
        }
        if (pe == null) {
            this.debugThreadError(this.threadStr + "ERROR: pe==null");
            return pe;
        }
        if (debugThreadTrace) {
            long delta = PrefetchControl.deltaMicroSeconds(start);
            o = pStr + "getUnpackQueue:Duration(us): " + delta + " entries: " + entries + " " + pe.toString();
            this.debugThreadTrace(o);
        }
        pThread.threadStatus = "getUnpackQueue:after";
        return pe;
    }

    protected void putUnpackQueue(PrefetchData pe, String pStr) {
        long start = 0L;
        int entries = 0;
        if (pStr == null) {
            pStr = this.threadStr;
        }
        if (debugThreadTrace) {
            start = System.nanoTime();
            String o = pStr + "putUnpackQueue: " + pe.toString();
            this.debugThreadTrace(o);
        }
        try {
            this.unpackQueue.put(pe);
            entries = this.unpackQueue.size();
        }
        catch (InterruptedException ie) {
            String o = this.threadStr + "PrefetchControl.putUnpackQueue(): " + ie;
            this.debugThreadTrace(o);
        }
        if (debugThreadTrace) {
            long delta = PrefetchControl.deltaMicroSeconds(start);
            String o = pStr + "putUnpackQueue:Duration(us): " + delta + " entries: " + entries;
            this.debugThreadTrace(o);
        }
    }

    protected synchronized void adjustUnpackThreads() {
        long currentHits;
        long deltaHits;
        if (this.unpackThreadsCurrent < 3 && (deltaHits = (currentHits = this.unpackHits.getHits()) - this.lastUnpackHits) > this.unpackThreshold) {
            this.lastUnpackHits = currentHits;
            long currentMisses = this.unpackHits.getMisses();
            long deltaMisses = currentMisses - this.lastUnpackMisses;
            this.lastUnpackMisses = currentMisses;
            if (deltaMisses == 0L) {
                deltaMisses = 1L;
            }
            if (deltaHits / deltaMisses > 5L) {
                try {
                    PrefetchData pe = new PrefetchData(this);
                    this.freeQueue.put(pe);
                    ++this.numberEntries;
                    pe = new PrefetchData(this);
                    this.freeQueue.put(pe);
                    ++this.numberEntries;
                }
                catch (InterruptedException ie) {
                    this.debugThreadError(this.threadStr, "Exception: ", ie.toString());
                }
                int i = this.unpackThreadsCurrent++;
                this.unpackThreshold *= 2L;
                if (debugThreadTrace) {
                    String o = "Creating Unpack Thread deltaHits: " + deltaHits + " deltaMisses: " + deltaMisses + " currentHits: " + currentHits;
                    this.debugThreadTrace(o);
                }
                this.unpackThreads[i] = new UnpackThread(this);
            }
        }
    }

    public class UnpackThread
    extends PrefetchThread {
        public UnpackThread(PrefetchControl pc) {
            super(pc, "UnpackThread", "U");
        }

        public boolean isTerminate(PrefetchData pe) {
            if (pe == null) {
                this.threadStatus = "terminate pe==null";
                this.terminate = true;
                return true;
            }
            if (this.terminate) {
                this.threadStatus = "terminate";
                return true;
            }
            return false;
        }

        @Override
        public void run() {
            PrefetchData pe = null;
            this.threadStatus = "start run()";
            PrefetchControl.this.debugThreadLife(this.threadStr, "Running");
            this.originalPriority = this.getPriority();
            this.increasePriority(false);
            try {
                while (!this.terminate) {
                    this.unpackFetchNumber = Long.MAX_VALUE;
                    pe = this.control.getUnpackQueue(this);
                    if (!this.isTerminate(pe)) {
                        this.unpackFetchNumber = pe.fetchNumber;
                        if (pe.fetchNumber == this.control.fetchNumberApplication) {
                            this.increasePriority(true);
                        } else if (pe.fetchNumber == this.control.fetchNumberApplication + 1L) {
                            this.increasePriority(false);
                        }
                        PrefetchControl.this.unpackResultSet(pe, this);
                        if (!this.isTerminate(pe)) {
                            this.control.putReadyEntry(pe, this);
                            this.unpackFetchNumber = Long.MAX_VALUE;
                            this.control.adjustUnpackThreads();
                            if (!this.terminate) continue;
                            this.threadStatus = "terminate";
                        }
                    }
                    break;
                }
            }
            catch (Exception jle) {
                this.threadException = jle;
                String o = this.threadStr + "UnpackThread Exception: " + jle;
                PrefetchControl.this.debugThreadError(o);
                o = this.threadStr + "status: " + this.threadStatus;
                PrefetchControl.this.debugThreadError(o);
                this.threadStatus = "exiting " + jle;
                PrefetchControl.this.handleThreadException(jle);
                return;
            }
            this.threadStatus = "exiting";
            PrefetchControl.this.debugThreadLife(this.threadStr, "Exiting");
        }
    }

    public class DataSourceThread
    extends PrefetchThread {
        public DataSourceThread(PrefetchControl pc) {
            super(pc, "DataSourceThread", "D");
        }

        @Override
        public void run() {
            this.threadStatus = "start run()";
            PrefetchControl.this.debugThreadLife(this.threadStr, "Running");
            this.increasePriority(true);
            try {
                while (!this.terminate) {
                    PrefetchData pe = this.control.getFreeEntry(this);
                    if (pe != null) {
                        if (this.terminate) {
                            this.threadStatus = "terminate";
                            break;
                        }
                        this.threadStatus = "fetchFromDataSource(pe) before";
                        PrefetchControl.this.fetchFromDataSource(pe, this);
                        this.threadStatus = "fetchFromDataSource(pe) after";
                        if (this.terminate) {
                            this.threadStatus = "terminate";
                            break;
                        }
                    } else {
                        PrefetchControl.this.debugThreadError(this.threadStr + "pe==null");
                        this.threadStatus = "terminate pe==null";
                        break;
                    }
                    this.threadStatus = "putUnpackQueue(pe) before";
                    PrefetchControl.this.putUnpackQueue(pe, this.threadStr);
                    this.threadStatus = "putUnpackQueue(pe) after";
                    if (!this.terminate) continue;
                    this.threadStatus = "terminate";
                    break;
                }
            }
            catch (Exception jle) {
                String o = this.threadStr + "DataSourceThread Exception: " + jle;
                PrefetchControl.this.debugThreadError(o);
                this.threadStatus = "exiting " + jle;
                PrefetchControl.this.handleThreadException(jle);
                return;
            }
            this.threadStatus = "exiting";
            String o = this.threadStr + "Exiting";
            PrefetchControl.this.debugThreadLife(o);
        }
    }

    public abstract class PrefetchThread
    extends Thread {
        protected transient boolean terminate = false;
        protected transient String threadStr;
        protected transient String threadName;
        protected transient String threadStatus;
        protected transient PrefetchControl control;
        protected transient int originalPriority;
        protected transient int maxPriority;
        protected transient long unpackFetchNumber;
        protected transient Exception threadException;

        public PrefetchThread(PrefetchControl pc, String threadName, String threadLetter) {
            String n = threadLetter + "-" + this.getName();
            this.threadStr = String.format("[%12s] ", n);
            this.control = pc;
            ThreadGroup tg = this.getThreadGroup();
            this.maxPriority = tg.getMaxPriority();
            this.originalPriority = this.getPriority();
            this.threadName = threadName;
            if (debugThread) {
                String o = String.format(pc.threadStr + "Constructor %s[%s] CurrentPriority: %d", threadName, this.getName(), this.originalPriority);
                PrefetchControl.this.debugThreadLife(o);
            }
            this.start();
        }

        public void terminate() {
            this.terminate = true;
        }

        public void increasePriority(boolean max) {
            if (max) {
                this.setPriority(this.maxPriority);
            } else {
                int newPriority = this.maxPriority - 1;
                this.setPriority(newPriority);
            }
        }

        public void resetPriority() {
            this.setPriority(this.originalPriority);
        }

        @Override
        public abstract void run();

        @Override
        public String toString() {
            String FMT = "%s:%s:[%s]:[%s]";
            String o = String.format("%s:%s:[%s]:[%s]", this.threadName, this.threadStr, this.threadStatus, this.threadException);
            return o;
        }
    }

    public class PrefetchDataComparator
    implements Comparator<PrefetchData> {
        @Override
        public int compare(PrefetchData p1, PrefetchData p2) {
            if (p1.fetchNumber > p2.fetchNumber) {
                return 1;
            }
            if (p1.fetchNumber < p2.fetchNumber) {
                return -1;
            }
            return 0;
        }
    }
}

