/*
 * Decompiled with CFR 0.152.
 */
package com.sas.tkts;

import java.math.RoundingMode;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;

public class FSEnums {

    public static enum FsSqlTypes {
        ARRAY(2003),
        BIGINT(-5),
        BINARY(-2),
        BIT(-7),
        BLOB(2004),
        BOOLEAN(16),
        CHAR(1),
        CLOB(2005),
        DATALINK(70),
        DATE(91),
        DECIMAL(3),
        DISTINCT(2001),
        DOUBLE(8),
        FLOAT(6),
        INTEGER(4),
        JAVA_OBJECT(2000),
        LONGNVARCHAR(-16),
        LONGVARBINARY(-4),
        LONGVARCHAR(-1),
        NCHAR(-15),
        NCLOB(2011),
        NULL(0),
        NUMERIC(2),
        NVARCHAR(-9),
        OTHER(1111),
        REAL(7),
        REF(2006),
        ROWID(-8),
        SMALLINT(5),
        SQLXML(2009),
        STRUCT(2002),
        TIME(92),
        TIMESTAMP(93),
        TINYINT(-6),
        VARBINARY(-3),
        VARCHAR(12);

        public int value;
        public int cType;
        public int decimalDigits;
        public int displaySize;
        public int numberBits;
        public int packLength;
        public boolean isBinary;
        public boolean isFixedLength;
        public boolean isNumber;
        public boolean isString;
        public boolean exactNumber;
        public boolean isChron;
        private static final Map<Integer, FsSqlTypes> mapByValue;
        private static final Map<Integer, FsSqlTypes> mapByCType;

        private FsSqlTypes(int inValue) {
            this.value = inValue;
            this.cType = 0;
            this.decimalDigits = 0;
            this.displaySize = Integer.MIN_VALUE;
            this.numberBits = 0;
            this.packLength = 0;
            this.isNumber = false;
            this.isString = false;
            this.isFixedLength = true;
            this.exactNumber = false;
            this.isChron = false;
        }

        public int getCType() {
            return this.cType;
        }

        public int getDisplaySize() {
            return this.displaySize;
        }

        public int getValue() {
            return this.value;
        }

        public int getNumberBits() {
            return this.numberBits;
        }

        public int getPackLength() {
            return this.numberBits;
        }

        public boolean isApproxNumber() {
            if (this.isNumber) {
                return !this.exactNumber;
            }
            return false;
        }

        public boolean isExactNumber() {
            return this.exactNumber;
        }

        public boolean isFixedLength() {
            return this.isFixedLength;
        }

        public boolean isNumber() {
            return this.isNumber;
        }

        public boolean isString() {
            return this.isString;
        }

        public boolean isChron() {
            return this.isChron;
        }

        public static FsSqlTypes getByValue(int inValue) {
            return mapByValue.get(inValue);
        }

        public static FsSqlTypes getByCType(int inCType) {
            return mapByCType.get(inCType);
        }

        public String getSQLTypeAsStringAndNumber() {
            String out = this.toString() + "(" + Integer.toString(this.value) + ")";
            return out;
        }

        static {
            mapByValue = new HashMap<Integer, FsSqlTypes>();
            mapByCType = new HashMap<Integer, FsSqlTypes>();
            for (FsSqlTypes e : EnumSet.allOf(FsSqlTypes.class)) {
                int intValue = e.getValue();
                mapByValue.put(intValue, e);
                switch (intValue) {
                    case -7: {
                        e.cType = 7;
                        e.displaySize = 1;
                        mapByCType.put(e.cType, e);
                        break;
                    }
                    case 16: {
                        e.cType = 7;
                        e.displaySize = 1;
                        mapByCType.put(e.cType, e);
                        break;
                    }
                    case -6: {
                        e.cType = 14;
                        e.displaySize = 4;
                        e.packLength = 1;
                        e.numberBits = 8;
                        e.isNumber = true;
                        e.exactNumber = true;
                        mapByCType.put(14, e);
                        mapByCType.put(15, e);
                        break;
                    }
                    case 5: {
                        e.cType = 12;
                        e.packLength = 2;
                        e.displaySize = 6;
                        e.numberBits = 16;
                        e.isNumber = true;
                        e.exactNumber = true;
                        mapByCType.put(12, e);
                        mapByCType.put(13, e);
                        break;
                    }
                    case 4: {
                        e.cType = 10;
                        e.displaySize = 11;
                        e.packLength = 4;
                        e.numberBits = 32;
                        e.isNumber = true;
                        e.exactNumber = true;
                        mapByCType.put(10, e);
                        mapByCType.put(11, e);
                        break;
                    }
                    case -5: {
                        e.cType = 8;
                        e.displaySize = 20;
                        e.packLength = 8;
                        e.numberBits = 64;
                        e.isNumber = true;
                        e.exactNumber = true;
                        mapByCType.put(8, e);
                        mapByCType.put(9, e);
                        break;
                    }
                    case 7: {
                        e.cType = 4;
                        e.displaySize = 16;
                        e.packLength = 8;
                        e.numberBits = 23;
                        e.decimalDigits = 9;
                        e.isNumber = true;
                        break;
                    }
                    case 6: {
                        e.cType = 4;
                        e.displaySize = 16;
                        e.packLength = 8;
                        e.numberBits = 23;
                        e.decimalDigits = 9;
                        e.isNumber = true;
                        mapByCType.put(4, e);
                        break;
                    }
                    case 8: {
                        e.cType = 6;
                        e.displaySize = 24;
                        e.packLength = 8;
                        e.decimalDigits = 17;
                        e.numberBits = 52;
                        e.isNumber = true;
                        mapByCType.put(6, e);
                        break;
                    }
                    case 2: 
                    case 3: {
                        e.cType = 5;
                        e.displaySize = 0;
                        e.packLength = Integer.MIN_VALUE;
                        e.numberBits = 52;
                        e.isNumber = true;
                        e.isFixedLength = false;
                        mapByCType.put(5, e);
                        break;
                    }
                    case -15: 
                    case 1: {
                        e.cType = 1;
                        e.displaySize = 0;
                        e.isString = true;
                        if (intValue != 1) break;
                        mapByCType.put(1, e);
                        mapByCType.put(3, e);
                        break;
                    }
                    case -9: 
                    case 12: {
                        e.cType = 1;
                        e.displaySize = 0;
                        e.isString = true;
                        e.isFixedLength = false;
                        break;
                    }
                    case -16: {
                        e.cType = 1;
                        e.displaySize = -2;
                        e.isString = true;
                        e.isFixedLength = false;
                        break;
                    }
                    case -1: {
                        e.cType = 1;
                        e.displaySize = 0;
                        e.isString = true;
                        e.isFixedLength = false;
                        break;
                    }
                    case -2: {
                        e.displaySize = -2;
                        e.cType = 2;
                        e.isBinary = true;
                        mapByCType.put(2, e);
                        break;
                    }
                    case -3: {
                        e.displaySize = 0;
                        e.cType = 2;
                        e.isBinary = true;
                        e.isFixedLength = false;
                        break;
                    }
                    case -4: {
                        e.displaySize = -2;
                        e.cType = 2;
                        e.isBinary = true;
                        e.isFixedLength = false;
                        break;
                    }
                    case 91: {
                        e.displaySize = 0;
                        e.cType = 17;
                        e.packLength = 6;
                        e.isChron = true;
                        mapByCType.put(17, e);
                        break;
                    }
                    case 92: {
                        e.displaySize = 0;
                        e.cType = 18;
                        e.packLength = 6;
                        e.isChron = true;
                        mapByCType.put(18, e);
                        break;
                    }
                    case 93: {
                        e.displaySize = 0;
                        e.cType = 19;
                        e.packLength = 16;
                        e.isChron = true;
                        mapByCType.put(19, e);
                        break;
                    }
                    case -8: {
                        e.cType = 1;
                        e.displaySize = 0;
                        e.isString = true;
                        e.isFixedLength = false;
                        mapByCType.put(-8, e);
                    }
                }
            }
        }
    }

    public static enum BdWriteTrunc {
        EXCEPTION(0),
        WARNING(1),
        IGNORE(2);

        public int value;
        private static final Map<Integer, BdWriteTrunc> mapByValue;
        private static final Map<String, BdWriteTrunc> mapByString;

        private BdWriteTrunc(int value) {
            this.value = value;
        }

        public static String getKeyName() {
            return "BIGDECIMAL_WRITE_TRUNCATION";
        }

        public int getValue() {
            return this.value;
        }

        public static BdWriteTrunc getByValue(int inValue) {
            return mapByValue.get(inValue);
        }

        public static BdWriteTrunc getByString(String inValue) {
            String inCapValues = inValue.toUpperCase();
            return mapByString.get(inCapValues);
        }

        public String getKeyValue() {
            return this.toString();
        }

        static {
            mapByValue = new HashMap<Integer, BdWriteTrunc>();
            mapByString = new HashMap<String, BdWriteTrunc>();
            for (BdWriteTrunc e : EnumSet.allOf(BdWriteTrunc.class)) {
                int intValue = e.getValue();
                String strValue = e.toString();
                mapByValue.put(intValue, e);
                mapByString.put(strValue, e);
            }
        }
    }

    public static enum BdTransportMode {
        DOUBLE(0),
        NUMERIC(1),
        SOURCE(2),
        STRING(3),
        TARGET(4);

        public int value;
        private static final Map<Integer, BdTransportMode> mapByValue;
        private static final Map<String, BdTransportMode> mapByString;

        private BdTransportMode(int value) {
            this.value = value;
        }

        public static String getKeyName() {
            return "BIGDECIMAL_TRANSPORT";
        }

        public static boolean isFixedDataType(BdTransportMode e) {
            return e == DOUBLE || e == NUMERIC || e == STRING;
        }

        public int getValue() {
            return this.value;
        }

        public static BdTransportMode getByValue(int inValue) {
            return mapByValue.get(inValue);
        }

        public static BdTransportMode getByString(String inValue) {
            String inCapValues = inValue.toUpperCase();
            return mapByString.get(inCapValues);
        }

        public String getKeyValue() {
            return this.toString();
        }

        static {
            mapByValue = new HashMap<Integer, BdTransportMode>();
            mapByString = new HashMap<String, BdTransportMode>();
            for (BdTransportMode e : EnumSet.allOf(BdTransportMode.class)) {
                int intValue = e.getValue();
                String strValue = e.toString();
                mapByValue.put(intValue, e);
                mapByString.put(strValue, e);
            }
        }
    }

    public static enum BdRoundingMode {
        CEILING(0),
        DOWN(1),
        FLOOR(2),
        HALF_DOWN(3),
        HALF_EVEN(4),
        UNNECESSARY(5),
        UP(6);

        public int value;
        private static final Map<Integer, BdRoundingMode> mapByValue;
        private static final Map<String, BdRoundingMode> mapByString;

        private BdRoundingMode(int value) {
            this.value = value;
        }

        public static String getKeyName() {
            return "BIGDECIMAL_ROUNDING_MODE";
        }

        public int getValue() {
            return this.value;
        }

        public static BdRoundingMode getByValue(int inValue) {
            return mapByValue.get(inValue);
        }

        public static BdRoundingMode getByString(String inValue) {
            String inCapValues = inValue.toUpperCase();
            return mapByString.get(inCapValues);
        }

        public String getKeyValue() {
            return this.toString();
        }

        public RoundingMode getMathRoundingMode() {
            if (this.value == BdRoundingMode.CEILING.value) {
                return RoundingMode.CEILING;
            }
            if (this.value == BdRoundingMode.DOWN.value) {
                return RoundingMode.DOWN;
            }
            if (this.value == BdRoundingMode.FLOOR.value) {
                return RoundingMode.FLOOR;
            }
            if (this.value == BdRoundingMode.HALF_DOWN.value) {
                return RoundingMode.HALF_DOWN;
            }
            if (this.value == BdRoundingMode.HALF_EVEN.value) {
                return RoundingMode.HALF_EVEN;
            }
            if (this.value == BdRoundingMode.UNNECESSARY.value) {
                return RoundingMode.UNNECESSARY;
            }
            if (this.value == BdRoundingMode.UP.value) {
                return RoundingMode.UP;
            }
            return null;
        }

        static {
            mapByValue = new HashMap<Integer, BdRoundingMode>();
            mapByString = new HashMap<String, BdRoundingMode>();
            for (BdRoundingMode e : EnumSet.allOf(BdRoundingMode.class)) {
                int intValue = e.getValue();
                String strValue = e.toString();
                mapByValue.put(intValue, e);
                mapByString.put(strValue, e);
            }
        }
    }
}

