/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.silk.xml.parsers;

import com.sas.graphics.silk.TreeviewComponent;
import com.sas.graphics.silk.interfaces.DataFilterReadInterface;
import com.sas.graphics.silk.treeview.TreeViewer;
import com.sas.graphics.silk.util.nld.DataFilterModel;
import com.sas.graphics.silk.xml.parsers.ChartParser;
import com.sas.graphics.silk.xml.parsers.ParserUtils;
import com.sas.graphics.util.nld.NLDModel;
import java.awt.Font;
import java.util.Hashtable;
import org.w3c.dom.Element;

public class TreeviewParser
extends ChartParser {
    private TreeviewComponent chart = null;

    public TreeviewParser() {
        this(null);
    }

    public TreeviewParser(TreeviewComponent instance) {
        this.chart = instance;
    }

    protected void loadFromStatgraph(Hashtable context, Element element) {
        NLDModel model;
        DataFilterReadInterface lFilter;
        DataFilterReadInterface nFilter;
        String nodeData;
        String treeSpan;
        String treeDir;
        String spreadStr;
        String lensStr;
        String cutoffStr;
        String fontSize;
        String fontName;
        if (this.chart == null) {
            this.chart = new TreeviewComponent();
        }
        if ((fontName = element.getAttribute("fontName")) != null && fontName.length() != 0) {
            this.chart.setFontName(fontName);
        }
        if ((fontName = element.getAttribute("fontFamily")) != null && fontName.length() != 0) {
            this.chart.setFontName(fontName);
        }
        if ((fontSize = element.getAttribute("fontSize")) != null && fontSize.length() != 0) {
            this.chart.setFontSize(ParserUtils.getIntValue((String)fontSize));
        }
        if ((cutoffStr = element.getAttribute("cutoff")) != null && cutoffStr.length() != 0) {
            try {
                double cutoff = Double.parseDouble(cutoffStr);
                if (cutoff >= 0.0 && cutoff <= 1.0) {
                    this.chart.setCutoffFactor(cutoff);
                }
            }
            catch (NumberFormatException cutoff) {
                // empty catch block
            }
        }
        if ((lensStr = element.getAttribute("lensFactor")) != null && lensStr.length() != 0) {
            try {
                double lensFactor = Double.parseDouble(lensStr);
                this.chart.setLensFactor(lensFactor);
            }
            catch (NumberFormatException lensFactor) {
                // empty catch block
            }
        }
        if ((spreadStr = element.getAttribute("spreadFactor")) != null && spreadStr.length() != 0) {
            try {
                double spreadFactor = Double.parseDouble(spreadStr);
                this.chart.setSpreadFactor(spreadFactor);
            }
            catch (NumberFormatException spreadFactor) {
                // empty catch block
            }
        }
        if ((treeDir = element.getAttribute("treeDirection")) != null) {
            this.chart.setTreeDirection(treeDir);
        }
        if ((treeSpan = element.getAttribute("treeSpan")) != null && treeSpan.length() != 0) {
            try {
                double treeSp = Double.parseDouble(treeSpan);
                this.chart.setTreeSpan(treeSp);
            }
            catch (NumberFormatException treeSp) {
                // empty catch block
            }
        }
        if ((nodeData = element.getAttribute("nodeData")) != null && nodeData.length() != 0) {
            this.chart.setDataSource(0, ParserUtils.getDataFromContext((Hashtable)context, (String)ParserUtils.getDataID((String)nodeData)));
        } else {
            String nid = element.getAttribute("nid");
            if (nid != null && nid.length() != 0) {
                this.chart.setDataSource(0, ParserUtils.getDataFromContext((Hashtable)context, (String)ParserUtils.getDataID((String)nid)));
            }
        }
        TreeviewParser.setRole(this.chart, 0, element, "nid", "ID");
        TreeviewParser.setRole(this.chart, 0, element, "ncolor", "Color");
        TreeviewParser.setRole(this.chart, 0, element, "nid", "Label");
        TreeviewParser.setRole(this.chart, 0, element, "nlabel", "Label");
        TreeviewParser.setRole(this.chart, 0, element, "ntip", "Info");
        TreeviewParser.setRole(this.chart, 0, element, "nurl", "Url");
        String nodeWhere = element.getAttribute("nwhere");
        String linkData = element.getAttribute("linkData");
        if (linkData != null && linkData.length() != 0) {
            this.chart.setDataSource(1, ParserUtils.getDataFromContext((Hashtable)context, (String)ParserUtils.getDataID((String)linkData)));
        } else {
            String lid = element.getAttribute("lid");
            if (lid != null && lid.length() != 0) {
                this.chart.setDataSource(1, ParserUtils.getDataFromContext((Hashtable)context, (String)ParserUtils.getDataID((String)lid)));
            }
        }
        TreeviewParser.setRole(this.chart, 1, element, "lid", "ID");
        TreeviewParser.setRole(this.chart, 1, element, "lfrom", "From");
        TreeviewParser.setRole(this.chart, 1, element, "lto", "To");
        TreeviewParser.setRole(this.chart, 1, element, "lcolor", "Color");
        TreeviewParser.setRole(this.chart, 1, element, "ltip", "Info");
        TreeviewParser.setRole(this.chart, 1, element, "lgroup", "Group");
        String linkWhere = element.getAttribute("lwhere");
        this.chart.load();
        if (nodeWhere != null && nodeWhere.length() > 0 && (nFilter = this.chart.getFilter(0)) != null) {
            nFilter.applyWhereClause(nodeWhere, true);
        }
        if (linkWhere != null && linkWhere.length() > 0 && (lFilter = this.chart.getFilter(1)) != null) {
            lFilter.applyWhereClause(linkWhere, true);
        }
        TreeViewer treeViewer = null;
        Object obj = this.chart.getChartObject(null);
        if (obj instanceof TreeViewer) {
            treeViewer = (TreeViewer)((Object)obj);
        }
        if (treeViewer != null && (model = treeViewer.getModel()) instanceof DataFilterModel) {
            ((DataFilterModel)model).dataChanged();
        }
    }

    protected static boolean setRole(TreeviewComponent chart, int type, Element context, String contextKey, Object role) {
        if (chart == null || context == null || contextKey == null || role == null) {
            return false;
        }
        if (context.getAttribute(contextKey).length() == 0) {
            return false;
        }
        String id = ParserUtils.getVariableID((String)context.getAttribute(contextKey));
        if (id == null) {
            return false;
        }
        return chart.setRole(type, id.toString(), role.toString());
    }

    protected void loadFromODS(Hashtable context, Element element) {
    }

    protected Element getODSXML(Hashtable context, Object object) {
        return null;
    }

    protected Element getStatgraphXML(Hashtable context, Object object) {
        Font f;
        String nWhere;
        Object ldata;
        TreeviewComponent tree = this.chart;
        if (object instanceof TreeviewComponent) {
            tree = (TreeviewComponent)object;
        }
        if (tree == null) {
            return null;
        }
        Element rc = ParserUtils.newElement((Hashtable)context, (String)"Treeview");
        Object ndata = tree.getDataSource(0);
        if (ndata != null) {
            rc.setAttribute("nodeData", ParserUtils.getNameForDataObject((Object)ndata, (Hashtable)context));
        }
        if ((ldata = tree.getDataSource(1)) != null) {
            rc.setAttribute("linkData", ParserUtils.getNameForDataObject((Object)ldata, (Hashtable)context));
        }
        if ((nWhere = tree.getWhereClause(0)) != null && nWhere.length() > 0) {
            rc.setAttribute("nwhere", nWhere);
        }
        if ((nWhere = tree.getWhereClause(1)) != null && nWhere.length() > 0) {
            rc.setAttribute("lwhere", nWhere);
        }
        if ((f = tree.getFont()) != null) {
            rc.setAttribute("fontFamily", f.getName());
            rc.setAttribute("fontSize", f.getSize() + "");
        }
        double lensFactor = tree.getLensFactor();
        rc.setAttribute("lensFactor", lensFactor + "");
        double spreadFactor = tree.getSpreadFactor();
        rc.setAttribute("spreadFactor", spreadFactor + "");
        double cutoff = tree.getCutoffFactor();
        rc.setAttribute("cutoff", cutoff + "");
        String treeDir = tree.getTreeDirection();
        if (treeDir != null && treeDir.length() > 0) {
            rc.setAttribute("treeDirection", treeDir);
        }
        double treeSpan = tree.getTreeSpan();
        rc.setAttribute("treeSpan", treeSpan + "");
        this.getVariable(tree, 0, rc, "nid", "ID");
        this.getVariable(tree, 0, rc, "ncolor", "Color");
        this.getVariable(tree, 0, rc, "nlabel", "Label");
        this.getVariable(tree, 0, rc, "ntip", "Info");
        this.getVariable(tree, 0, rc, "nurl", "Url");
        this.getVariable(tree, 1, rc, "lid", "ID");
        this.getVariable(tree, 1, rc, "lfrom", "From");
        this.getVariable(tree, 1, rc, "lto", "To");
        this.getVariable(tree, 1, rc, "lcolor", "Color");
        this.getVariable(tree, 1, rc, "ltip", "Info");
        this.getVariable(tree, 1, rc, "lgroup", "Group");
        return rc;
    }

    private void getVariable(TreeviewComponent tree, int type, Element element, String roleAttr, String role) {
        if (tree == null || element == null || role == null) {
            return;
        }
        Object var = tree.getVariable(type, role);
        if (var instanceof String && var.toString().length() > 0) {
            element.setAttribute(roleAttr, var.toString());
        }
    }

    public Object getObject() {
        if (this.chart == null) {
            this.chart = new TreeviewComponent();
        }
        return this.chart;
    }

    public boolean setObject(Object instance) {
        if (instance == null || !(instance instanceof TreeviewComponent)) {
            return false;
        }
        this.chart = (TreeviewComponent)instance;
        return true;
    }
}

