/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.silk.xml.parsers;

import com.sas.graphics.silk.data.TreeModel;
import com.sas.graphics.silk.interfaces.ElementParserInterface;
import com.sas.graphics.silk.interfaces.RoleInterface;
import com.sas.graphics.silk.interfaces.TreeModelInterface;
import com.sas.graphics.silk.util.FilterFactory;
import com.sas.graphics.silk.xml.parsers.ParserUtils;
import com.sas.graphics.util.Extract;
import java.util.Enumeration;
import java.util.Hashtable;
import org.w3c.dom.Element;

public class TreeModelParser
implements ElementParserInterface {
    private TreeModelInterface model = null;

    public TreeModelParser() {
        this(null);
    }

    public TreeModelParser(TreeModelInterface tree) {
        this.model = tree;
    }

    public Object getFromXML(Hashtable context, Element element, Object instance) {
        String chartData;
        this.model = instance instanceof TreeModelInterface ? (TreeModelInterface)instance : new TreeModel();
        String name = element.getAttribute("name");
        if (name != null) {
            context.put(name, this.model);
        }
        if ((chartData = element.getAttribute("chartData")) != null && chartData.length() > 0) {
            this.model.setDataSource(ParserUtils.getDataFromContext((Hashtable)context, (String)chartData));
        } else {
            String id = element.getAttribute("id");
            this.model.setDataSource(ParserUtils.getDataFromContext((Hashtable)context, (String)ParserUtils.getDataID((String)id)));
        }
        String barData = element.getAttribute("barData");
        if (barData != null && barData.length() > 0) {
            this.model.setGraphData(FilterFactory.getDataSourceFilter(context.get(barData)));
        }
        TreeModelParser.setRole(this.model, element, "id", RoleInterface.ROLE_ID);
        TreeModelParser.setRole(this.model, element, "parent", RoleInterface.ROLE_PARENT);
        TreeModelParser.setRole(this.model, element, "nodeText", RoleInterface.ROLE_NODE_TEXT);
        TreeModelParser.setRole(this.model, element, "nodeSize", RoleInterface.ROLE_NODE_SIZE);
        TreeModelParser.setRole(this.model, element, "nodeColor", RoleInterface.ROLE_NODE_COLOR);
        TreeModelParser.setRole(this.model, element, "linkWidth", RoleInterface.ROLE_LINK_WIDTH);
        TreeModelParser.setRole(this.model, element, "aboveText", RoleInterface.ROLE_ABOVE_TEXT);
        TreeModelParser.setRole(this.model, element, "belowText", RoleInterface.ROLE_BELOW_TEXT);
        TreeModelParser.setRole(this.model, element, "surrogate", RoleInterface.ROLE_SURROGATE);
        TreeModelParser.setRole(this.model, element, "tooltipText", RoleInterface.ROLE_TOOLTIP_TEXT);
        TreeModelParser.setRole(this.model, element, "graph0", RoleInterface.ROLE_GRAPH_VAR);
        TreeModelParser.setRole(this.model, element, "graph1", RoleInterface.ROLE_GRAPH_VAR);
        TreeModelParser.setRole(this.model, element, "graph2", RoleInterface.ROLE_GRAPH_VAR);
        TreeModelParser.setRole(this.model, element, "graph3", RoleInterface.ROLE_GRAPH_VAR);
        TreeModelParser.setRole(this.model, element, "graph4", RoleInterface.ROLE_GRAPH_VAR);
        TreeModelParser.setRole(this.model, element, "graph5", RoleInterface.ROLE_GRAPH_VAR);
        TreeModelParser.setRole(this.model, element, "graph6", RoleInterface.ROLE_GRAPH_VAR);
        TreeModelParser.setRole(this.model, element, "graph7", RoleInterface.ROLE_GRAPH_VAR);
        TreeModelParser.setRole(this.model, element, "graph8", RoleInterface.ROLE_GRAPH_VAR);
        TreeModelParser.setRole(this.model, element, "graph9", RoleInterface.ROLE_GRAPH_VAR);
        TreeModelParser.setRole(this.model, element, "graphID", RoleInterface.ROLE_GRAPH_ID);
        return this.getObject();
    }

    public static boolean setRole(RoleInterface chart, Element context, String contextKey, Object role) {
        if (chart == null || context == null || contextKey == null || role == null) {
            return false;
        }
        if (context.getAttribute(contextKey).length() == 0) {
            return false;
        }
        String id = ParserUtils.getVariableID((String)context.getAttribute(contextKey));
        if (id == null) {
            return false;
        }
        return chart.setRole((Object)id, role);
    }

    public Element putToXML(Hashtable context, Object instance) {
        TreeModelInterface tm = this.model;
        if (instance instanceof TreeModelInterface) {
            tm = (TreeModelInterface)instance;
        }
        if (tm == null) {
            return null;
        }
        Element rc = ParserUtils.newElement((Hashtable)context, (String)"TreeModel");
        rc.setAttribute("name", "treeModel" + tm.hashCode());
        String name = ParserUtils.getNameForDataObject((Object)tm.getFilter(), (Hashtable)context);
        if (name != null && !name.equalsIgnoreCase("NONE")) {
            rc.setAttribute("chartData", name);
        }
        if ((name = ParserUtils.getNameForDataObject((Object)tm.getGraphFilter(), (Hashtable)context)) != null && !name.equalsIgnoreCase("NONE")) {
            rc.setAttribute("barData", name);
        }
        this.putRole(tm, rc, "id", RoleInterface.ROLE_ID);
        this.putRole(tm, rc, "parent", RoleInterface.ROLE_PARENT);
        this.putRole(tm, rc, "nodeText", RoleInterface.ROLE_NODE_TEXT);
        this.putRole(tm, rc, "nodeSize", RoleInterface.ROLE_NODE_SIZE);
        this.putRole(tm, rc, "nodeColor", RoleInterface.ROLE_NODE_COLOR);
        this.putRole(tm, rc, "linkWidth", RoleInterface.ROLE_LINK_WIDTH);
        this.putRole(tm, rc, "aboveText", RoleInterface.ROLE_ABOVE_TEXT);
        this.putRole(tm, rc, "belowText", RoleInterface.ROLE_BELOW_TEXT);
        this.putRole(tm, rc, "surrogate", RoleInterface.ROLE_SURROGATE);
        this.putRole(tm, rc, "tooltipText", RoleInterface.ROLE_TOOLTIP_TEXT);
        this.putRole(tm, rc, "graph0", RoleInterface.ROLE_GRAPH_VAR);
        this.putRole(tm, rc, "graph1", RoleInterface.ROLE_GRAPH_VAR);
        this.putRole(tm, rc, "graph2", RoleInterface.ROLE_GRAPH_VAR);
        this.putRole(tm, rc, "graph3", RoleInterface.ROLE_GRAPH_VAR);
        this.putRole(tm, rc, "graph4", RoleInterface.ROLE_GRAPH_VAR);
        this.putRole(tm, rc, "graph5", RoleInterface.ROLE_GRAPH_VAR);
        this.putRole(tm, rc, "graph6", RoleInterface.ROLE_GRAPH_VAR);
        this.putRole(tm, rc, "graph7", RoleInterface.ROLE_GRAPH_VAR);
        this.putRole(tm, rc, "graph8", RoleInterface.ROLE_GRAPH_VAR);
        this.putRole(tm, rc, "graph9", RoleInterface.ROLE_GRAPH_VAR);
        this.putRole(tm, rc, "graphID", RoleInterface.ROLE_GRAPH_ID);
        return rc;
    }

    public void putRole(TreeModelInterface model, Element element, String attribute, Object role) {
        if (model == null || element == null || attribute == null || role == null) {
            return;
        }
        Object obj = model.getAllVariables(role);
        Enumeration e = Extract.elements((Object)obj);
        String s = "";
        while (e.hasMoreElements()) {
            if (s.length() > 0) {
                s = s + ",";
            }
            s = s + e.nextElement();
        }
        if (s.length() > 0) {
            element.setAttribute(attribute, s);
        }
    }

    public Object getObject() {
        return this.model;
    }
}

