/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.silk.xml.parsers;

import com.sas.graphics.silk.BaseMatrixComponent;
import com.sas.graphics.silk.xml.SILKParser;
import com.sas.graphics.silk.xml.parsers.ChartParser;
import com.sas.graphics.silk.xml.parsers.ParserUtils;
import com.sas.graphics.silk.xml.parsers.SILKElementInfoInterface;
import com.sas.graphics.silk.xml.parsers.SILKElementInfoReader;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JComponent;
import org.w3c.dom.Element;

public class PlotMatrixParser
extends ChartParser {
    SILKElementInfoReader matrixInfo = null;

    public PlotMatrixParser() {
        this(null);
    }

    public PlotMatrixParser(BaseMatrixComponent instance) {
        String configFile = "com/sas/graphics/silk/xml/parsers/config/matrix.config";
        this.matrixInfo = new SILKElementInfoReader(configFile);
        this.matrixInfo.setInstance((Object)instance);
    }

    protected void loadFromStatgraph(Hashtable context, Element element) {
        ParserUtils.parseElement((Hashtable)context, (Element)element, (SILKElementInfoInterface)this.matrixInfo);
    }

    protected void loadFromODS(Hashtable context, Element element) {
    }

    protected Element getODSXML(Hashtable context, Object object) {
        return null;
    }

    public Object getFromXML(Hashtable context, Element element, Object instance) {
        String diagonal;
        String data;
        Vector previous = (Vector)context.get("CHART_LIST");
        if (previous == null) {
            previous = new Vector();
        }
        Object[] prev = new String[previous.size()];
        previous.copyInto(prev);
        for (int i = 0; i < prev.length; ++i) {
            SILKParser.removeChart((Hashtable)context, (String)prev[i]);
        }
        BaseMatrixComponent matrix = null;
        matrix = instance instanceof BaseMatrixComponent ? (BaseMatrixComponent)instance : (BaseMatrixComponent)this.matrixInfo.getXmlTarget();
        String type = element.getAttribute("componentType");
        if (matrix != null) {
            if (type == null || type.trim().length() <= 0) {
                type = "Scatter";
            }
            if (type.equalsIgnoreCase("Scatter")) {
                matrix.setComponentType(1);
            } else if (type.equalsIgnoreCase("DensityPlot")) {
                matrix.setComponentType(2);
            }
        }
        if ((data = element.getAttribute("data")) != null && data.length() > 0) {
            matrix.setDataSource(context.get(data));
        }
        Object rc = super.getFromXML(context, element, instance);
        matrix.initChildrenFromXML(element, new Hashtable());
        if (matrix != null && element.hasAttribute("diagonal") && "histogram".equalsIgnoreCase(diagonal = element.getAttribute("diagonal"))) {
            matrix.setPropertyValue(21001, 2);
            matrix.applyPropertyChanges();
        }
        Object[] charts = SILKParser.getCharts((Hashtable)context);
        Vector vec = (Vector)context.get("CHART_LIST");
        if (vec != null) {
            Object[] chartNames = new String[vec.size()];
            vec.copyInto(chartNames);
            Vector<Object> components = new Vector<Object>();
            for (int i = 0; i < charts.length; ++i) {
                Object obj = charts[i];
                if (obj instanceof JComponent) {
                    components.addElement(obj);
                }
                if (obj instanceof BaseMatrixComponent) continue;
                SILKParser.removeChart((Hashtable)context, (String)chartNames[i]);
            }
        }
        for (int i = 0; i < prev.length; ++i) {
            SILKParser.addChart((Hashtable)context, (String)prev[i]);
        }
        return rc;
    }

    protected Element getStatgraphXML(Hashtable context, Object object) {
        Element compXML;
        Element rc;
        Element elem = rc = ParserUtils.toXML((String)"MatrixPlot", (Hashtable)context, (Object)object, (SILKElementInfoInterface)this.matrixInfo);
        BaseMatrixComponent component = null;
        component = object instanceof BaseMatrixComponent ? (BaseMatrixComponent)object : (BaseMatrixComponent)this.matrixInfo.getXmlTarget();
        int type = component.getComponentType();
        if (type == 1) {
            elem.setAttribute("componentType", "Scatter");
        } else if (type == 2) {
            elem.setAttribute("componentType", "DensityPlot");
        }
        if (component.getDiagonal() == 2) {
            elem.setAttribute("diagonal", "histogram");
        }
        if ((compXML = component.putChildXML(context, elem)) != null) {
            rc = compXML;
        }
        return rc;
    }

    public Object getObject() {
        return this.matrixInfo.getXmlTarget();
    }

    public boolean setObject(Object instance) {
        if (instance == null || !(instance instanceof BaseMatrixComponent)) {
            return false;
        }
        this.matrixInfo.setInstance(instance);
        return true;
    }
}

