/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.silk.xml.parsers;

import com.sas.graphics.silk.OrgChartComponent;
import com.sas.graphics.silk.interfaces.RoleInterface;
import com.sas.graphics.silk.interfaces.TextStyleInterface;
import com.sas.graphics.silk.orgchart.OrgViewer;
import com.sas.graphics.silk.util.Roles;
import com.sas.graphics.silk.xml.parsers.ChartParser;
import com.sas.graphics.silk.xml.parsers.ParserUtils;
import com.sas.graphics.silk.xml.parsers.TextParser;
import com.sas.graphics.util.ColorParse;
import java.awt.Color;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Stack;
import java.util.StringTokenizer;
import org.w3c.dom.Element;

public class OrgChartParser
extends ChartParser {
    private OrgChartComponent org = null;

    public OrgChartParser() {
        this(null);
    }

    public OrgChartParser(OrgChartComponent instance) {
        this.org = instance;
    }

    protected void loadFromStatgraph(Hashtable context, Element element) {
        String nodeData;
        Element footnote;
        Element subtitle;
        Element title;
        String drawBackground;
        String wallColor;
        String backgroundColor;
        if (this.org == null) {
            this.org = new OrgChartComponent();
        }
        if ((backgroundColor = element.getAttribute("background")) != null && backgroundColor.length() != 0) {
            this.org.setSolidBackground(backgroundColor);
        }
        if ((wallColor = element.getAttribute("wallColor")) != null && wallColor.length() != 0) {
            this.org.setWallColor(wallColor);
        }
        if ((drawBackground = element.getAttribute("drawBackground")) != null && drawBackground.length() != 0) {
            this.org.setDrawBackground(ParserUtils.getBooleanValue((String)drawBackground));
        }
        if ((title = ParserUtils.getChildWithTagName((String)"Title", (Element)element)) != null) {
            TextStyleInterface oldTitle = this.org.getTitle(0);
            TextStyleInterface tsi = TextParser.parseTextElement((Element)title, (TextStyleInterface)oldTitle);
            this.org.setTitle(0, tsi);
        }
        if ((subtitle = ParserUtils.getChildWithTagName((String)"Subtitle", (Element)element)) != null) {
            TextStyleInterface oldTitle = this.org.getTitle(1);
            TextStyleInterface tsi = TextParser.parseTextElement((Element)subtitle, (TextStyleInterface)oldTitle);
            this.org.setTitle(1, tsi);
        }
        if ((footnote = ParserUtils.getChildWithTagName((String)"Footnote", (Element)element)) != null) {
            TextStyleInterface oldFn = this.org.getFootnote(0);
            TextStyleInterface tsi = TextParser.parseTextElement((Element)footnote, (TextStyleInterface)oldFn);
            this.org.setFootnote(0, tsi);
        }
        if ((nodeData = element.getAttribute("nodeData")) != null && nodeData.length() != 0) {
            this.org.setDataSource(ParserUtils.getDataFromContext((Hashtable)context, (String)ParserUtils.getDataID((String)nodeData)), "Nodes");
        } else {
            String nid = element.getAttribute("nid");
            if (nid != null && nid.length() != 0) {
                this.org.setDataSource(ParserUtils.getDataFromContext((Hashtable)context, (String)ParserUtils.getDataID((String)nid)), "Nodes");
            }
        }
        OrgChartParser.setRole(this.org, element, "nid", RoleInterface.ROLE_NODE_ID);
        OrgChartParser.setRole(this.org, element, "nparentId", RoleInterface.ROLE_NODE_PARENT_ID);
        OrgChartParser.setRole(this.org, element, "nlabel", RoleInterface.ROLE_NODE_LABEL);
        OrgChartParser.setRole(this.org, element, "ntip", RoleInterface.ROLE_NODE_TIP);
        OrgChartParser.setRole(this.org, element, "nicon", RoleInterface.ROLE_NODE_ICON);
        OrgChartParser.setRole(this.org, element, "ncolor", RoleInterface.ROLE_NODE_COLOR);
        OrgChartParser.setRole(this.org, element, "nurl", RoleInterface.ROLE_NODE_URL);
        OrgChartParser.setRole(this.org, element, "ngroup", RoleInterface.ROLE_NODE_GROUP);
        OrgChartParser.setRole(this.org, element, "nhaschildren", RoleInterface.ROLE_NODE_HAS_CHILDREN);
        String linkData = element.getAttribute("linkData");
        if (linkData != null && linkData.length() != 0) {
            this.org.setDataSource(ParserUtils.getDataFromContext((Hashtable)context, (String)ParserUtils.getDataID((String)linkData)), "Links");
        } else {
            String lid = element.getAttribute("lid");
            if (lid != null && lid.length() != 0) {
                this.org.setDataSource(ParserUtils.getDataFromContext((Hashtable)context, (String)ParserUtils.getDataID((String)lid)), "Links");
            }
        }
        OrgChartParser.setRole(this.org, element, "lid", RoleInterface.ROLE_LINK_ID);
        OrgChartParser.setRole(this.org, element, "lfrom", RoleInterface.ROLE_LINK_FROM);
        OrgChartParser.setRole(this.org, element, "lto", RoleInterface.ROLE_LINK_TO);
        OrgChartParser.setRole(this.org, element, "ltip", RoleInterface.ROLE_LINK_TIP);
        OrgViewer orgViewer = null;
        Object obj = this.org.getChartObject(null);
        if (obj instanceof OrgViewer) {
            orgViewer = (OrgViewer)obj;
        }
        if (orgViewer != null) {
            String viewContextNodeID;
            Element treeModel;
            Element roots;
            String sizeNodesToFitText;
            String fitType;
            String zs;
            String layout;
            String drawRaisedNodes = element.getAttribute("drawRaisedNodes");
            if (drawRaisedNodes != null && drawRaisedNodes.length() != 0 && ("no".equalsIgnoreCase(drawRaisedNodes) || "false".equalsIgnoreCase(drawRaisedNodes))) {
                orgViewer.setDrawRaisedNodes(false);
            }
            if ((layout = element.getAttribute("layout")) != null && layout.length() != 0) {
                orgViewer.setTreeLayout(layout);
            }
            if ((zs = element.getAttribute("zoomScale")) != null && zs.length() != 0) {
                try {
                    double val = Double.valueOf(zs);
                    orgViewer.setZoomScale(val);
                }
                catch (NumberFormatException e) {
                    System.out.println("Not able to read zoomScale attribute");
                }
            }
            if ((fitType = element.getAttribute("zoomFitType")) != null && fitType.length() != 0) {
                if ("fittopage".equalsIgnoreCase(fitType)) {
                    orgViewer.setZoomFitType(0);
                } else if ("fittopagewidth".equalsIgnoreCase(fitType)) {
                    orgViewer.setZoomFitType(1);
                } else if ("fittopageheight".equalsIgnoreCase(fitType)) {
                    orgViewer.setZoomFitType(2);
                }
            }
            if ((sizeNodesToFitText = element.getAttribute("sizeNodesToFitText")) != null && sizeNodesToFitText.length() != 0) {
                orgViewer.setSizeNodesToFitText(ParserUtils.getBooleanValue((String)sizeNodesToFitText));
            }
            String expansionLevel = element.getAttribute("treeExpansionLevel");
            String drawIcon = element.getAttribute("drawIcon");
            if (drawIcon != null && drawIcon.length() != 0) {
                orgViewer.setDrawIcon(ParserUtils.getBooleanValue((String)drawIcon));
            }
            if ((roots = ParserUtils.getChildWithTagName((String)"Roots", (Element)element)) != null) {
                this.setRoots(orgViewer, roots);
            }
            if ((treeModel = ParserUtils.getChildWithTagName((String)"TreeModel", (Element)element)) != null) {
                Element viewState = ParserUtils.getChildWithTagName((String)"ViewProperties", (Element)treeModel);
                if (viewState != null) {
                    this.setTreeState(orgViewer, viewState);
                } else if (expansionLevel != null && expansionLevel.length() != 0) {
                    orgViewer.setTreeExpansionLevel(ParserUtils.getIntValue((String)expansionLevel));
                }
            } else if (expansionLevel != null && expansionLevel.length() != 0) {
                orgViewer.setTreeExpansionLevel(ParserUtils.getIntValue((String)expansionLevel));
            }
            String viewCenterX = element.getAttribute("viewCenterX");
            String viewCenterY = element.getAttribute("viewCenterY");
            if (viewCenterX != null && viewCenterX.length() != 0 && viewCenterY != null && viewCenterY.length() != 0) {
                int cx = ParserUtils.getIntValue((String)viewCenterX);
                int cy = ParserUtils.getIntValue((String)viewCenterY);
                orgViewer.setViewCenter(cx, cy);
            }
            if ((viewContextNodeID = element.getAttribute("viewContextNodeID")) != null && viewContextNodeID.length() != 0) {
                int xpos = ParserUtils.getIntValue((String)element.getAttribute("viewContextXPos"));
                int ypos = ParserUtils.getIntValue((String)element.getAttribute("viewContextYPos"));
                orgViewer.setViewContext(viewContextNodeID, xpos, ypos);
            }
        }
    }

    protected static boolean setRole(OrgChartComponent org, Element context, String contextKey, Object role) {
        if (org == null || context == null || contextKey == null || role == null) {
            return false;
        }
        if (context.getAttribute(contextKey).length() == 0) {
            return false;
        }
        String id = ParserUtils.getVariableID((String)context.getAttribute(contextKey));
        if (id == null) {
            return false;
        }
        return org.setRole(id, role);
    }

    protected void loadFromODS(Hashtable context, Element element) {
    }

    protected Element getODSXML(Hashtable context, Object object) {
        return null;
    }

    private void setRoots(OrgViewer orgViewer, Element roots) {
        if (orgViewer == null || roots == null) {
            return;
        }
        String stack = roots.getAttribute("stack");
        if (stack != null && stack.length() != 0) {
            StringTokenizer st = new StringTokenizer(stack, ", ");
            while (st.hasMoreTokens()) {
                String rootID = st.nextToken();
                if (rootID == null) continue;
                orgViewer.setRoot(rootID);
            }
        }
    }

    private void setTreeState(OrgViewer orgViewer, Element viewState) {
        if (orgViewer == null || viewState == null) {
            return;
        }
        Hashtable<String, Boolean> treeState = new Hashtable<String, Boolean>();
        Element node = null;
        int i = 1;
        while ((node = ParserUtils.getChildWithTagName((String)"Node", (Element)viewState, (int)i)) != null) {
            String id = node.getAttribute("id");
            String collapsed = node.getAttribute("collapsed");
            if (id != null && collapsed != null && collapsed.length() != 0 && ParserUtils.getBooleanValue((String)collapsed)) {
                treeState.put(id, Boolean.TRUE);
            }
            ++i;
        }
        orgViewer.setTreeState(treeState);
    }

    protected Element getStatgraphXML(Hashtable context, Object object) {
        TextParser textParser;
        Element e;
        Object ldata;
        Object ndata;
        String cname;
        Color c;
        OrgChartComponent chart = this.org;
        if (object instanceof OrgChartComponent) {
            chart = (OrgChartComponent)object;
        }
        if (chart == null) {
            return null;
        }
        OrgViewer orgViewer = null;
        Object o = chart.getChartObject(null);
        if (o instanceof OrgViewer) {
            orgViewer = (OrgViewer)o;
        }
        o = context.get("SAVE_VIEW_STATE");
        boolean saveViewState = false;
        if (o instanceof Boolean) {
            saveViewState = (Boolean)o;
        }
        Element rc = ParserUtils.newElement((Hashtable)context, (String)"OrgChart");
        boolean drawBackground = chart.isBackgroundDrawn();
        if (!drawBackground) {
            rc.setAttribute("drawBackground", "false");
        }
        if ((c = chart.getSolidBackground()) != null && chart.wasBackgroundSet() && (cname = ColorParse.getColorStrg((Color)c, (boolean)true)) != null) {
            rc.setAttribute("background", cname);
        }
        if ((c = chart.getWallColor()) != null && chart.wasWallColorSet() && (cname = ColorParse.getColorStrg((Color)c, (boolean)true)) != null) {
            rc.setAttribute("wallColor", cname);
        }
        if (orgViewer != null) {
            int treeExpansionLevel;
            boolean sizeNodesToFit;
            int[] viewCenter;
            int fitType;
            String zs;
            String layout;
            boolean areNodesDrawnRaised = orgViewer.areNodesDrawnRaised();
            if (!areNodesDrawnRaised) {
                rc.setAttribute("drawRaisedNodes", "false");
            }
            if ((layout = orgViewer.getTreeLayoutName()) != null) {
                rc.setAttribute("layout", layout);
            }
            if ((zs = new Double(orgViewer.getZoomScale()).toString()) != null && zs.length() != 0) {
                rc.setAttribute("zoomScale", zs);
            }
            if ((fitType = orgViewer.getZoomFitType()) > -1) {
                if (fitType == 0) {
                    rc.setAttribute("zoomFitType", "fittopage");
                } else if (fitType == 1) {
                    rc.setAttribute("zoomFitType", "fittopagewidth");
                } else if (fitType == 2) {
                    rc.setAttribute("zoomFitType", "fittopageheight");
                }
            }
            rc.setAttribute("drawIcon", Boolean.toString(orgViewer.isIconDrawn()));
            if (saveViewState && (viewCenter = orgViewer.getViewCenter()) != null) {
                rc.setAttribute("viewCenterX", Integer.toString(viewCenter[0]));
                rc.setAttribute("viewCenterY", Integer.toString(viewCenter[1]));
            }
            if (sizeNodesToFit = orgViewer.areNodesSizedToFitText()) {
                rc.setAttribute("sizeNodesToFitText", "true");
            }
            if ((treeExpansionLevel = orgViewer.getTreeExpansionLevel()) >= 0 && !saveViewState) {
                rc.setAttribute("treeExpansionLevel", Integer.toString(treeExpansionLevel));
            }
        }
        if ((ndata = chart.getDataSource("Nodes")) != null) {
            rc.setAttribute("nodeData", ParserUtils.getNameForDataObject((Object)ndata, (Hashtable)context));
        }
        if ((ldata = chart.getDataSource("Links")) != null) {
            rc.setAttribute("linkData", ParserUtils.getNameForDataObject((Object)ldata, (Hashtable)context));
        }
        Roles roles = Roles.getInstance(null);
        this.getVariable(chart, rc, "nid", roles.getRoleObject("ROLE_NODE_ID"));
        this.getVariable(chart, rc, "nparentId", roles.getRoleObject("ROLE_NODE_PARENT_ID"));
        this.getVariable(chart, rc, "nlabel", roles.getRoleObject("ROLE_NODE_LABEL"));
        this.getVariable(chart, rc, "ntip", roles.getRoleObject("ROLE_NODE_TIP"));
        this.getVariable(chart, rc, "nicon", roles.getRoleObject("ROLE_NODE_ICON"));
        this.getVariable(chart, rc, "ncolor", roles.getRoleObject("ROLE_NODE_COLOR"));
        this.getVariable(chart, rc, "ngroup", roles.getRoleObject("ROLE_NODE_GROUP"));
        this.getVariable(chart, rc, "nurl", roles.getRoleObject("ROLE_NODE_URL"));
        this.getVariable(chart, rc, "nhaschildren", roles.getRoleObject("ROLE_NODE_HAS_CHILDREN"));
        this.getVariable(chart, rc, "lid", roles.getRoleObject("ROLE_LINK_ID"));
        this.getVariable(chart, rc, "lfrom", roles.getRoleObject("ROLE_LINK_FROM"));
        this.getVariable(chart, rc, "lto", roles.getRoleObject("ROLE_LINK_TO"));
        this.getVariable(chart, rc, "ltip", roles.getRoleObject("ROLE_LINK_TIP"));
        if (saveViewState) {
            Element treeState;
            Element roots = this.putRootsToXML(chart, orgViewer, rc, context);
            if (roots != null) {
                rc.appendChild(roots);
            }
            if ((treeState = this.putTreeStateToXML(chart, orgViewer, rc, context)) != null) {
                rc.appendChild(treeState);
            }
        }
        if ((e = (textParser = new TextParser()).putToXML(context, (Object)chart.getTitle(0), "Title")) != null) {
            rc.appendChild(e);
        }
        if ((e = textParser.putToXML(context, (Object)chart.getTitle(1), "Subtitle")) != null) {
            rc.appendChild(e);
        }
        if ((e = textParser.putToXML(context, (Object)chart.getFootnote(0), "Footnote")) != null) {
            rc.appendChild(e);
        }
        return rc;
    }

    private Element putRootsToXML(OrgChartComponent chart, OrgViewer orgViewer, Element rc, Hashtable context) {
        if (chart == null || orgViewer == null || rc == null) {
            return null;
        }
        Stack roots = orgViewer.getRootsStack();
        if (roots == null || roots.size() == 0) {
            return null;
        }
        Object rootNode = orgViewer.getRootNodeId();
        if (rootNode == null) {
            return null;
        }
        Element elem = ParserUtils.newElement((Hashtable)context, (String)"Roots");
        StringBuffer rootList = new StringBuffer();
        for (int i = 0; i < roots.size(); ++i) {
            Object o = roots.elementAt(i);
            if (o == null) continue;
            if (rootList.length() > 0) {
                rootList.append(", ");
            }
            rootList.append(o.toString());
        }
        if (!roots.contains(rootNode)) {
            if (rootList.length() > 0) {
                rootList.append(", ");
            }
            rootList.append(rootNode.toString());
        }
        elem.setAttribute("stack", rootList.toString());
        return elem;
    }

    private Element putTreeStateToXML(OrgChartComponent chart, OrgViewer orgViewer, Element rc, Hashtable context) {
        if (chart == null || orgViewer == null || rc == null) {
            return null;
        }
        Hashtable treeState = orgViewer.getTreeState();
        if (treeState == null || treeState.size() == 0) {
            return null;
        }
        Enumeration e = treeState.keys();
        Element viewProperties = ParserUtils.newElement((Hashtable)context, (String)"ViewProperties");
        while (e != null && e.hasMoreElements()) {
            Object nid = e.nextElement();
            if (nid == null || !Boolean.TRUE.equals(treeState.get(nid))) continue;
            Element nodeState = ParserUtils.newElement((Hashtable)context, (String)"Node");
            nodeState.setAttribute("id", nid.toString());
            nodeState.setAttribute("collapsed", "true");
            viewProperties.appendChild(nodeState);
        }
        Element treeModel = ParserUtils.newElement((Hashtable)context, (String)"TreeModel");
        treeModel.appendChild(viewProperties);
        return treeModel;
    }

    private void getVariable(OrgChartComponent chart, Element element, String roleName, Object role) {
        if (chart == null || element == null || role == null || roleName == null) {
            return;
        }
        Object var = chart.getVariable(role);
        if (var instanceof String && var.toString().length() > 0) {
            element.setAttribute(roleName, var.toString());
        }
    }

    public Object getObject() {
        if (this.org == null) {
            this.org = new OrgChartComponent();
        }
        return this.org;
    }

    public boolean setObject(Object instance) {
        if (instance == null || !(instance instanceof OrgChartComponent)) {
            return false;
        }
        this.org = (OrgChartComponent)instance;
        return true;
    }
}

