/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.silk.xml.parsers;

import com.sas.graphics.silk.RegularGridComponent;
import com.sas.graphics.silk.interfaces.ElementParserInterface;
import com.sas.graphics.silk.interfaces.TextStyleInterface;
import com.sas.graphics.silk.util.AbstractGridTableModel;
import com.sas.graphics.silk.util.GridCell;
import com.sas.graphics.silk.util.Text;
import com.sas.graphics.silk.xml.SILKParser;
import com.sas.graphics.silk.xml.parsers.ChartParser;
import com.sas.graphics.silk.xml.parsers.ParserUtils;
import com.sas.graphics.xml.GraphParserFactory;
import java.awt.Dimension;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.table.DefaultTableModel;
import org.w3c.dom.Element;

public class LatticeLayoutParser
extends ChartParser {
    protected RegularGridComponent grid = null;

    public LatticeLayoutParser() {
        this(new RegularGridComponent());
    }

    public LatticeLayoutParser(RegularGridComponent gridIn) {
        this.grid = gridIn;
    }

    protected void loadFromStatgraph(Hashtable context, Element element) {
        Vector<Object> cells = new Vector<Object>();
        Vector previous = (Vector)context.get("CHART_LIST");
        if (previous == null) {
            previous = new Vector();
        }
        Object[] prev = new String[previous.size()];
        previous.copyInto(prev);
        for (int i = 0; i < prev.length; ++i) {
            SILKParser.removeChart((Hashtable)context, (String)prev[i]);
        }
        SILKParser.load((Hashtable)context, (Element)element);
        Object[] charts = SILKParser.getCharts((Hashtable)context);
        Vector vec = (Vector)context.get("CHART_LIST");
        if (vec == null) {
            return;
        }
        Object[] chartNames = new String[vec.size()];
        vec.copyInto(chartNames);
        for (int i = 0; i < charts.length; ++i) {
            Object obj = charts[i];
            cells.addElement(obj);
            SILKParser.removeChart((Hashtable)context, (String)chartNames[i]);
        }
        Object[] children = new Object[cells.size()];
        cells.copyInto(children);
        String rows = element.getAttribute("rows");
        String columns = element.getAttribute("columns");
        int r = -1;
        int c = -1;
        if (rows != null && rows.length() > 0) {
            r = ParserUtils.getIntValue((String)rows);
        }
        if (columns != null && columns.length() > 0) {
            c = ParserUtils.getIntValue((String)columns);
        }
        int[] res = this.computeGrid(r, c, children.length);
        DefaultTableModel model = new DefaultTableModel(res[0], res[1]);
        int current = 0;
        TextStyleInterface[][][] headers = new TextStyleInterface[res[0]][res[1]][];
        for (int i = 0; i < res[0]; ++i) {
            for (int j = 0; j < res[1]; ++j) {
                Object child;
                if (current >= children.length) {
                    model.setValueAt(new JPanel(), i, j);
                    continue;
                }
                if ((child = children[current++]) instanceof GridCell) {
                    model.setValueAt(((GridCell)child).getChart(), i, j);
                    TextStyleInterface[] header = ((GridCell)child).getCellHeaders();
                    if (header == null) continue;
                    headers[i][j] = header;
                    continue;
                }
                model.setValueAt(child, i, j);
            }
        }
        String cellSize = element.getAttribute("cellSize");
        Dimension cs = new Dimension(5, 5);
        if (cellSize != null && cellSize.length() > 0) {
            String width = cellSize.substring(cellSize.indexOf("(") + 1, cellSize.indexOf(","));
            String height = cellSize.substring(cellSize.indexOf(",") + 1, cellSize.lastIndexOf(")"));
            int w = 5;
            int h = 5;
            try {
                w = Integer.parseInt(width);
                h = Integer.parseInt(height);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            cs.setSize(w, h);
        }
        this.grid.setCellSize(cs.width, cs.height);
        this.grid.setModel(model);
        this.grid.setPropertyValue(19401, Boolean.TRUE);
        this.grid.applyPropertyChanges();
        for (int i = 0; i < headers.length; ++i) {
            for (int j = 0; j < headers[i].length; ++j) {
                if (headers[i][j] == null) continue;
                for (int k = 0; k < headers[i][j].length; ++k) {
                    this.grid.addCellHeader(i, j, headers[i][j][k].getTextString());
                }
            }
        }
    }

    private int[] computeGrid(int r, int c, int numComponents) {
        int[] rc = new int[2];
        if (r > 0 && c > 0) {
            rc[0] = r;
            rc[1] = c;
        } else if (r > 0) {
            rc[0] = r;
            rc[1] = (int)Math.ceil((double)numComponents / (double)r);
        } else if (c > 0) {
            rc[0] = (int)Math.ceil((double)numComponents / (double)c);
            rc[1] = c;
        } else {
            rc[0] = (int)Math.ceil(Math.sqrt(numComponents));
            rc[1] = rc[0];
        }
        return rc;
    }

    protected void loadFromODS(Hashtable context, Element element) {
    }

    protected Element getODSXML(Hashtable context, Object object) {
        return null;
    }

    protected Element getStatgraphXML(Hashtable context, Object object) {
        Element rc = ParserUtils.newElement((Hashtable)context, (String)"LayoutLattice");
        if (object instanceof RegularGridComponent) {
            RegularGridComponent grid = (RegularGridComponent)object;
            AbstractGridTableModel tm = null;
            if (grid.getModel() instanceof AbstractGridTableModel) {
                tm = (AbstractGridTableModel)grid.getModel();
            }
            rc.setAttribute("rows", Integer.toString(tm.getRowCount()));
            rc.setAttribute("columns", Integer.toString(tm.getColumnCount()));
            Dimension d = grid.getCellSize();
            String cs = "(" + Integer.toString(d.width) + "," + Integer.toString(d.height) + ")";
            rc.setAttribute("cellSize", cs);
            for (int i = 0; i < tm.getRowCount(); ++i) {
                for (int j = 0; j < tm.getColumnCount(); ++j) {
                    ElementParserInterface parser;
                    Vector cellHeaders;
                    GridCell gc = new GridCell();
                    Object o = tm.getValueAt(i, j);
                    if (o instanceof JComponent) {
                        gc.setChart((JComponent)o);
                    }
                    if ((cellHeaders = grid.getCellHeaders(i, j)) != null) {
                        for (int k = 0; k < cellHeaders.size(); ++k) {
                            Object ch = cellHeaders.elementAt(k);
                            if (ch instanceof TextStyleInterface) {
                                gc.addCellHeader((TextStyleInterface)ch);
                                continue;
                            }
                            if (!(ch instanceof String)) continue;
                            gc.addCellHeader((TextStyleInterface)new Text(ch.toString()));
                        }
                    }
                    if ((parser = GraphParserFactory.loadParser((Object)gc)) == null) continue;
                    Element cell = parser.putToXML(context, (Object)gc);
                    rc.appendChild(cell);
                }
            }
        }
        return rc;
    }

    public Object getObject() {
        return this.grid;
    }

    public boolean setObject(Object instance) {
        if (!(instance instanceof RegularGridComponent)) {
            return false;
        }
        this.grid = (RegularGridComponent)instance;
        return true;
    }
}

