/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.silk.xml.parsers;

import com.sas.graphics.silk.GridLayoutComponent;
import com.sas.graphics.silk.interfaces.ElementParserInterface;
import com.sas.graphics.silk.util.GraphLayout;
import com.sas.graphics.silk.util.LayoutNode;
import com.sas.graphics.silk.xml.SILKParser;
import com.sas.graphics.silk.xml.parsers.ChartParser;
import com.sas.graphics.silk.xml.parsers.ParserUtils;
import com.sas.graphics.xml.GraphParserFactory;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JComponent;
import org.w3c.dom.Element;

public class GridLayoutParser
extends ChartParser {
    private GridLayoutComponent glc = new GridLayoutComponent();

    public GridLayoutParser() {
        this.glc.setRoot(new LayoutNode());
    }

    protected void loadFromStatgraph(Hashtable context, Element element) {
        int i;
        Vector previous = (Vector)context.get("CHART_LIST");
        if (previous == null) {
            previous = new Vector();
        }
        Object[] prev = new String[previous.size()];
        previous.copyInto(prev);
        for (int i2 = 0; i2 < prev.length; ++i2) {
            SILKParser.removeChart((Hashtable)context, (String)prev[i2]);
        }
        SILKParser.load((Hashtable)context, (Element)element);
        Object[] charts = SILKParser.getCharts((Hashtable)context);
        Vector vec = (Vector)context.get("CHART_LIST");
        if (vec == null) {
            return;
        }
        Object[] chartNames = new String[vec.size()];
        vec.copyInto(chartNames);
        Vector<Object> components = new Vector<Object>();
        for (int i3 = 0; i3 < charts.length; ++i3) {
            Object obj = charts[i3];
            if (obj instanceof JComponent) {
                components.addElement(obj);
            }
            SILKParser.removeChart((Hashtable)context, (String)chartNames[i3]);
        }
        Object[] children = new JComponent[components.size()];
        components.copyInto(children);
        for (int i4 = 0; i4 < children.length; ++i4) {
            if (!(children[i4] instanceof GridLayoutComponent)) continue;
            GridLayoutComponent g = (GridLayoutComponent)children[i4];
            children[i4] = g.getRoot();
            g.removeMyMouseListeners();
        }
        int direction = 1;
        String dir = element.getAttribute("direction");
        if (dir != null && dir.equalsIgnoreCase("Vertical")) {
            direction = 0;
        }
        double[] spans = null;
        String str = null;
        str = direction == 1 ? element.getAttribute("columnSpan") : element.getAttribute("rowSpan");
        if (str != null && str.length() > 0) {
            String[] arr = ParserUtils.parseStringArray((String)str, (String)",");
            spans = new double[arr.length];
            for (i = 0; i < spans.length; ++i) {
                spans[i] = ParserUtils.getDoubleValue((String)arr[i]);
            }
        }
        LayoutNode node = this.glc.getRoot();
        node.setDirection(direction);
        node.setComponents((JComponent[])children);
        node.setSpacing(spans);
        this.glc.setRoot(node);
        for (i = 0; i < prev.length; ++i) {
            SILKParser.addChart((Hashtable)context, (String)prev[i]);
        }
    }

    protected void loadFromODS(Hashtable context, Element element) {
    }

    protected Element getODSXML(Hashtable context, Object object) {
        return null;
    }

    protected Element getStatgraphXML(Hashtable context, Object object) {
        Element rc = ParserUtils.newElement((Hashtable)context, (String)"LayoutGridded");
        LayoutNode node = null;
        if (object instanceof GridLayoutComponent) {
            GridLayoutComponent comp = (GridLayoutComponent)object;
            node = comp.getRoot();
        } else if (object instanceof GraphLayout) {
            node = ((GraphLayout)object).getRoot();
        } else if (object instanceof LayoutNode) {
            node = (LayoutNode)object;
        }
        if (node != null) {
            if (node.getDirection() == 0) {
                rc.setAttribute("direction", "Vertical");
            } else {
                rc.setAttribute("direction", "Horizontal");
            }
            JComponent[] arr = node.getChildren();
            if (arr != null) {
                for (int i = 0; i < arr.length; ++i) {
                    ElementParserInterface parser = GraphParserFactory.loadParser((Object)arr[i]);
                    if (parser == null) continue;
                    Element e = parser.putToXML(context, (Object)arr[i]);
                    rc.appendChild(e);
                }
            }
        }
        return rc;
    }

    public Object getObject() {
        return this.glc;
    }

    public boolean setObject(Object instance) {
        return false;
    }
}

