/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.silk.xml.parsers;

import com.sas.graphics.silk.GTableComponent;
import com.sas.graphics.silk.graphtable.GTable;
import com.sas.graphics.silk.interfaces.ColorInterface;
import com.sas.graphics.silk.interfaces.DataFilterReadInterface;
import com.sas.graphics.silk.util.table.TableSorter;
import com.sas.graphics.silk.xml.SILKParser;
import com.sas.graphics.silk.xml.parsers.ChartParser;
import com.sas.graphics.silk.xml.parsers.ColorRampParser;
import com.sas.graphics.silk.xml.parsers.ParserUtils;
import java.util.Hashtable;
import javax.swing.JApplet;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;

public class GTableParser
extends ChartParser {
    private GTableComponent gtable = null;
    private String sortColumn = null;
    private boolean sortDirection = true;

    public GTableParser() {
        this(null);
    }

    public GTableParser(GTableComponent instance) {
        this.gtable = instance;
    }

    protected void loadFromStatgraph(Hashtable context, Element element) {
        String target;
        String maxWidth;
        String headerWrap;
        String scrollToSelected;
        String sortEnabled;
        String obsCol;
        String rowHeader;
        Object applet;
        if (this.gtable == null) {
            this.gtable = new GTableComponent();
        }
        if ((applet = context.get("APPLET_CONTEXT")) != null && applet instanceof JApplet) {
            this.gtable.setAppletContext((JApplet)applet);
        }
        String showFilter = element.getAttribute("showFilter");
        boolean showFltr = false;
        if (showFilter != null && showFilter.length() > 0) {
            showFltr = ParserUtils.getBooleanValue((String)showFilter);
            this.gtable.setShowFilter(showFltr);
        }
        boolean rowHeaderOn = false;
        if (!showFltr && (rowHeader = element.getAttribute("rowHeader")) != null && rowHeader.length() > 0) {
            rowHeaderOn = ParserUtils.getBooleanValue((String)rowHeader);
            this.gtable.setRowHeader(rowHeaderOn);
        }
        if (!showFltr && !rowHeaderOn && (obsCol = element.getAttribute("showObsColumn")) != null && obsCol.length() > 0) {
            this.gtable.setObsNumberColumnVisible(ParserUtils.getBooleanValue((String)obsCol));
        }
        if ((sortEnabled = element.getAttribute("sortEnabled")) != null && sortEnabled.length() > 0) {
            this.gtable.setSortingEnabled(ParserUtils.getBooleanValue((String)sortEnabled));
        }
        if ((scrollToSelected = element.getAttribute("scrollToSelected")) != null && scrollToSelected.length() > 0) {
            this.gtable.setScrollTableToSelectedCell(ParserUtils.getBooleanValue((String)scrollToSelected));
        }
        if ((headerWrap = element.getAttribute("headerWrap")) != null && headerWrap.length() > 0) {
            this.gtable.setHeaderWrap(ParserUtils.getBooleanValue((String)headerWrap));
        }
        if ((maxWidth = element.getAttribute("maxComputedColumnWidth")) != null && maxWidth.length() > 0) {
            this.gtable.setMaxComputedCellWidth(ParserUtils.getIntValue((String)maxWidth));
        }
        if ((target = element.getAttribute("target")) != null) {
            this.gtable.setTarget(target);
        }
        int i = 1;
        Element column = null;
        while ((column = ParserUtils.getChildWithTagName((String)"Column", (Element)element, (int)i)) != null) {
            this.parseColumn(column, context);
            ++i;
        }
        if (this.sortColumn != null) {
            this.gtable.sortColumn(this.sortColumn, this.sortDirection);
        }
    }

    private void parseColumn(Element column, Hashtable context) {
        String target;
        String align;
        String cellWrap;
        String visible;
        String link;
        String imageColumn;
        String sort;
        String display;
        String name = column.getAttribute("name");
        if (name == null || name.length() == 0) {
            return;
        }
        String urlColumn = column.getAttribute("urlColumn");
        if (urlColumn != null && urlColumn.length() > 0) {
            this.gtable.linkColumn(name, urlColumn);
        }
        if ((display = column.getAttribute("display")) != null && display.length() > 0) {
            if (display.equalsIgnoreCase("Graphics")) {
                this.gtable.setDisplayMode(name, GTableComponent.RENDERMODE_GRAPHICS);
            } else if (display.equalsIgnoreCase("Funnel")) {
                this.gtable.setDisplayMode(name, GTableComponent.RENDERMODE_FUNNEL);
            } else {
                this.gtable.setDisplayMode(name, GTableComponent.RENDERMODE_TEXT);
            }
        }
        if ((sort = column.getAttribute("sort")) != null && sort.length() > 0) {
            this.sortColumn = name;
            if (sort.equalsIgnoreCase("Ascending")) {
                this.sortDirection = true;
            } else if (sort.equalsIgnoreCase("Descending")) {
                this.sortDirection = false;
            }
        }
        if ((imageColumn = column.getAttribute("imageColumn")) != null && imageColumn.length() > 0 && ParserUtils.getBooleanValue((String)imageColumn)) {
            this.gtable.setImageColumn(name);
        }
        if ((link = column.getAttribute("link")) != null && link.length() > 0) {
            this.gtable.setColumnLink(name, link);
        }
        String colorMapper = column.getAttribute("colorMapper");
        ColorInterface ramp = null;
        if (colorMapper != null && colorMapper.length() > 0) {
            ramp = SILKParser.getColorRamp((Hashtable)context, (String)colorMapper);
        }
        DataFilterReadInterface filter = this.gtable.getFilter();
        if (ramp != null && filter != null) {
            Object var;
            Object object = var = filter.getVariableIndex((Object)name) >= 0 ? name : null;
            if (filter.getVariableDescription((Object)name) != null) {
                var = filter.getVariableDescription((Object)name);
            }
            this.gtable.setColorRamp(var, ramp);
        }
        if ((visible = column.getAttribute("visible")) != null && visible.length() > 0 && (visible.equalsIgnoreCase("false") || visible.equalsIgnoreCase("no"))) {
            this.gtable.setColumnVisible(name, false);
        }
        if ((cellWrap = column.getAttribute("cellWrap")) != null && cellWrap.length() > 0 && (cellWrap.equalsIgnoreCase("true") || cellWrap.equalsIgnoreCase("yes"))) {
            this.gtable.setColumnWrap(name, true);
        }
        if ((align = column.getAttribute("align")) != null && align.length() > 0) {
            if (align.equalsIgnoreCase("left")) {
                this.gtable.getTable().setHorizontalAlignment(name, 2);
            } else if (align.equalsIgnoreCase("right")) {
                this.gtable.getTable().setHorizontalAlignment(name, 4);
            } else if (align.equalsIgnoreCase("center")) {
                this.gtable.getTable().setHorizontalAlignment(name, 0);
            }
        }
        if ((target = column.getAttribute("target")) != null && target.length() > 0) {
            this.gtable.setTarget(name, target);
        }
    }

    protected void loadFromODS(Hashtable context, Element element) {
    }

    protected Element getODSXML(Hashtable context, Object object) {
        return null;
    }

    protected Element getStatgraphXML(Hashtable context, Object object) {
        String colorScheme;
        String where;
        GTableComponent comp = this.gtable;
        GTable gt = null;
        if (object != null && object instanceof GTableComponent) {
            comp = (GTableComponent)object;
        }
        if (comp == null) {
            return null;
        }
        gt = comp.getTable();
        if (gt == null) {
            return null;
        }
        Element rc = ParserUtils.newElement((Hashtable)context, (String)"GTable");
        Object obj = comp.getDataSource();
        if (obj != null) {
            rc.setAttribute("data", ParserUtils.getNameForDataObject((Object)obj, (Hashtable)context));
        }
        if (comp.isFilterOn()) {
            rc.setAttribute("showFilter", comp.isFilterOn() + "");
        }
        if (comp.isRowHeaderOn()) {
            rc.setAttribute("rowHeader", comp.isRowHeaderOn() + "");
        }
        if (comp.isObsNumberColumnVisible()) {
            rc.setAttribute("showObsColumn", comp.isObsNumberColumnVisible() + "");
        }
        if (comp.isHeaderWrapped()) {
            rc.setAttribute("headerWrap", Boolean.toString(comp.isHeaderWrapped()));
        }
        if (!comp.isSortingEnabled()) {
            rc.setAttribute("sortEnabled", "false");
        }
        if (comp.isTableScrollingToSelectedCell()) {
            rc.setAttribute("scrollToSelected", "true");
        }
        if ((where = comp.getWhereClause()) != null && where.trim().length() > 0) {
            rc.setAttribute("where", ParserUtils.buildValidXMLString((String)where));
        }
        if ((colorScheme = comp.getColorSchemeName()) != null && !colorScheme.equalsIgnoreCase("Default")) {
            rc.setAttribute("colorScheme", colorScheme);
        }
        boolean useVarDesc = comp.isVariableDescriptionUsed();
        Hashtable<Object, String> colorMappers = new Hashtable<Object, String>();
        DataFilterReadInterface filter = comp.getFilter();
        if (filter != null) {
            Object name;
            int i;
            for (i = 0; i < filter.getNumberVariables(); ++i) {
                ColorRampParser crp;
                Element cm;
                ColorInterface ramp;
                Object var;
                name = filter.getVariableId(i);
                Object desc = filter.getVariableDescription(i);
                Object object2 = var = useVarDesc ? desc : name;
                if (!comp.isColumnVisible(var.toString()) || (ramp = comp.getColorRamp(var)) == null || (cm = (crp = new ColorRampParser(ramp)).putToXML(context, (Object)ramp)) == null) continue;
                colorMappers.put(var, cm.getAttribute("name"));
                rc.appendChild(cm);
            }
            for (i = 0; i < filter.getNumberVariables(); ++i) {
                NamedNodeMap nnm;
                Object rampName;
                boolean cellWrap;
                String target;
                Object urlColumn;
                int dMode;
                Element column = ParserUtils.newElement((Hashtable)context, (String)"Column");
                Object name2 = filter.getVariableId(i);
                Object desc = filter.getVariableDescription(i);
                Object var = useVarDesc ? desc : name2;
                column.setAttribute("name", name2.toString());
                boolean visible = comp.isColumnVisible(var.toString());
                if (!visible) {
                    column.setAttribute("visible", "false");
                }
                if ((dMode = comp.getDisplayMode(var)) == GTableComponent.RENDERMODE_GRAPHICS) {
                    column.setAttribute("display", "Graphics");
                } else if (dMode == GTableComponent.RENDERMODE_FUNNEL) {
                    column.setAttribute("display", "Funnel");
                }
                int ss = comp.getSortState(var);
                if (ss != 0) {
                    int order = comp.getSortState(var);
                    if (order == 1) {
                        column.setAttribute("sort", "Ascending");
                    } else if (order == 2) {
                        column.setAttribute("sort", "Descending");
                    }
                }
                if ((urlColumn = comp.getLinkColumn(var)) != null) {
                    column.setAttribute("urlColumn", urlColumn.toString());
                }
                int align = gt.getHorizontalAlignment(var.toString());
                String alignment = null;
                switch (align) {
                    case 2: {
                        alignment = "left";
                        break;
                    }
                    case 4: {
                        alignment = "right";
                        break;
                    }
                    case 0: {
                        alignment = "center";
                    }
                }
                if (alignment != null) {
                    column.setAttribute("align", alignment);
                }
                if ((target = gt.getTarget(var.toString())) != null && target.length() > 0 && !target.equalsIgnoreCase("_blank")) {
                    column.setAttribute("target", target);
                }
                if (cellWrap = comp.getColumnWrap(var.toString())) {
                    column.setAttribute("cellWrap", "true");
                }
                if ((rampName = colorMappers.get(var)) != null) {
                    column.setAttribute("colorMapper", rampName.toString());
                }
                if ((nnm = column.getAttributes()) == null || nnm.getLength() <= 1) continue;
                rc.appendChild(column);
            }
            if (comp.isObsNumberColumnVisible() && comp.getSortState(TableSorter.OBS_HEADER_KEY) != 0) {
                Element column = ParserUtils.newElement((Hashtable)context, (String)"Column");
                name = TableSorter.OBS_HEADER_KEY;
                column.setAttribute("name", name.toString());
                int order = comp.getSortState(TableSorter.OBS_HEADER_KEY);
                if (order == 1) {
                    column.setAttribute("sort", "Ascending");
                } else if (order == 2) {
                    column.setAttribute("sort", "Descending");
                }
                rc.appendChild(column);
            }
        }
        return rc;
    }

    public Object getObject() {
        if (this.gtable == null) {
            this.gtable = new GTableComponent();
        }
        return this.gtable;
    }

    public boolean setObject(Object instance) {
        if (instance == null || !(instance instanceof GTableComponent)) {
            return false;
        }
        this.gtable = (GTableComponent)instance;
        return true;
    }
}

