/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.silk.xml.parsers;

import com.sas.graphics.silk.FSTreeComponent;
import com.sas.graphics.silk.interfaces.RoleInterface;
import com.sas.graphics.silk.util.Roles;
import com.sas.graphics.silk.xml.parsers.ChartParser;
import com.sas.graphics.silk.xml.parsers.ParserUtils;
import java.util.Collection;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import org.w3c.dom.Element;

public class FSTreeParser
extends ChartParser {
    private FSTreeComponent fstree = null;

    public FSTreeParser() {
        this(new FSTreeComponent());
    }

    public FSTreeParser(FSTreeComponent instance) {
        this.fstree = instance;
    }

    protected void loadFromStatgraph(Hashtable context, Element element) {
        String nodeData = element.getAttribute("nodeData");
        if (nodeData != null && nodeData.length() != 0) {
            this.fstree.setDataSource(ParserUtils.getDataFromContext((Hashtable)context, (String)ParserUtils.getDataID((String)nodeData)), new Integer(0));
        } else {
            String nid = element.getAttribute("nid");
            if (nid != null && nid.length() != 0) {
                this.fstree.setDataSource(ParserUtils.getDataFromContext((Hashtable)context, (String)ParserUtils.getDataID((String)nid)), new Integer(0));
            }
        }
        FSTreeParser.setRole(this.fstree, element, "nid", RoleInterface.ROLE_NODE_ID);
        FSTreeParser.setRole(this.fstree, element, "nlabel", RoleInterface.ROLE_NODE_LABEL);
        FSTreeParser.setRole(this.fstree, element, "ntip", RoleInterface.ROLE_NODE_TIP);
        FSTreeParser.setRole(this.fstree, element, "ncolor", RoleInterface.ROLE_NODE_COLOR);
        FSTreeParser.setRole(this.fstree, element, "nurl", RoleInterface.ROLE_NODE_URL);
        String linkData = element.getAttribute("linkData");
        if (linkData != null && linkData.length() != 0) {
            this.fstree.setDataSource(ParserUtils.getDataFromContext((Hashtable)context, (String)ParserUtils.getDataID((String)linkData)), new Integer(1));
        } else {
            String lid = element.getAttribute("lid");
            if (lid != null && lid.length() != 0) {
                this.fstree.setDataSource(ParserUtils.getDataFromContext((Hashtable)context, (String)ParserUtils.getDataID((String)lid)), new Integer(1));
            }
        }
        FSTreeParser.setRole(this.fstree, element, "lid", RoleInterface.ROLE_LINK_ID);
        FSTreeParser.setRole(this.fstree, element, "lfrom", RoleInterface.ROLE_LINK_FROM);
        FSTreeParser.setRole(this.fstree, element, "lto", RoleInterface.ROLE_LINK_TO);
        FSTreeParser.setRole(this.fstree, element, "ltip", RoleInterface.ROLE_LINK_TIP);
        String reconLevel = element.getAttribute("reconciliationLevel");
        int level = -1;
        if (reconLevel != null && reconLevel.length() > 0) {
            try {
                level = Integer.parseInt(reconLevel);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (level >= 0) {
            this.fstree.setReconciliationLine(level);
        } else {
            Element rline = null;
            rline = ParserUtils.getChildWithTagName((String)"ReconciliationLine", (Element)element, (int)1);
            if (rline != null) {
                this.parseReconciliationLine(rline);
            }
        }
    }

    private void parseReconciliationLine(Element reconLine) {
        StringTokenizer st;
        if (this.fstree == null || reconLine == null) {
            return;
        }
        String nodeList = reconLine.getAttribute("nodeList");
        if (nodeList != null && nodeList.length() > 0 && (st = new StringTokenizer(nodeList, ",")) != null) {
            Vector<String> nodes = new Vector<String>();
            while (st.hasMoreTokens()) {
                nodes.add(st.nextToken().trim());
            }
            this.fstree.setReconciliationLine(nodes);
        }
    }

    protected static boolean setRole(FSTreeComponent fstree, Element context, String contextKey, Object role) {
        if (fstree == null || context == null || contextKey == null || role == null) {
            return false;
        }
        if (context.getAttribute(contextKey).length() == 0) {
            return false;
        }
        String id = ParserUtils.getVariableID((String)context.getAttribute(contextKey));
        if (id == null) {
            return false;
        }
        return fstree.setRole(id, role);
    }

    protected void loadFromODS(Hashtable context, Element element) {
    }

    protected Element getODSXML(Hashtable context, Object object) {
        return null;
    }

    protected Element getStatgraphXML(Hashtable context, Object object) {
        Object[] reconNodes;
        Object ldata;
        FSTreeComponent fst = this.fstree;
        if (object instanceof FSTreeComponent) {
            fst = (FSTreeComponent)((Object)object);
        }
        if (fst == null) {
            return null;
        }
        Element rc = ParserUtils.newElement((Hashtable)context, (String)"FSTree");
        Object ndata = fst.getDataSource(new Integer(0));
        if (ndata != null) {
            rc.setAttribute("nodeData", ParserUtils.getNameForDataObject((Object)ndata, (Hashtable)context));
        }
        if ((ldata = fst.getDataSource(new Integer(1))) != null) {
            rc.setAttribute("linkData", ParserUtils.getNameForDataObject((Object)ldata, (Hashtable)context));
        }
        Roles roles = Roles.getInstance(null);
        this.getVariable(fst, rc, "nid", roles.getRoleObject("ROLE_NODE_ID"));
        this.getVariable(fst, rc, "ncolor", roles.getRoleObject("ROLE_NODE_COLOR"));
        this.getVariable(fst, rc, "nlabel", roles.getRoleObject("ROLE_NODE_LABEL"));
        this.getVariable(fst, rc, "ntip", roles.getRoleObject("ROLE_NODE_TIP"));
        this.getVariable(fst, rc, "nurl", roles.getRoleObject("ROLE_NODE_URL"));
        this.getVariable(fst, rc, "lid", roles.getRoleObject("ROLE_LINK_ID"));
        this.getVariable(fst, rc, "lfrom", roles.getRoleObject("ROLE_LINK_FROM"));
        this.getVariable(fst, rc, "lto", roles.getRoleObject("ROLE_LINK_TO"));
        this.getVariable(fst, rc, "ltip", roles.getRoleObject("ROLE_LINK_TIP"));
        Collection reconLine = fst.getReconciliationLine();
        if (reconLine != null && reconLine.size() > 0 && (reconNodes = reconLine.toArray()) != null && reconNodes.length > 0) {
            Element reconLineList = ParserUtils.newElement((Hashtable)context, (String)"ReconciliationLine");
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < reconNodes.length; ++i) {
                String separator;
                String string = separator = i < reconNodes.length - 1 ? "," : "";
                if (reconNodes[i] == null) continue;
                sb.append(reconNodes[i] + separator);
            }
            reconLineList.setAttribute("nodeList", sb.toString());
            rc.appendChild(reconLineList);
        }
        return rc;
    }

    private void getVariable(FSTreeComponent fst, Element element, String roleName, Object role) {
        if (fst == null || element == null || role == null || roleName == null) {
            return;
        }
        Object var = fst.getVariable(role);
        if (var instanceof String && var.toString().length() > 0) {
            element.setAttribute(roleName, var.toString());
        }
    }

    public Object getObject() {
        return this.fstree;
    }

    public boolean setObject(Object instance) {
        if (instance == null || !(instance instanceof FSTreeComponent)) {
            return false;
        }
        this.fstree = (FSTreeComponent)((Object)instance);
        return true;
    }
}

