/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.silk.xml.parsers;

import com.sas.graphics.silk.DecisionTree;
import com.sas.graphics.silk.interfaces.ColorInterface;
import com.sas.graphics.silk.interfaces.TextStyleInterface;
import com.sas.graphics.silk.interfaces.TreeModelInterface;
import com.sas.graphics.silk.xml.SILKXMLParser;
import com.sas.graphics.silk.xml.parsers.ChartParser;
import com.sas.graphics.silk.xml.parsers.ColorRampParser;
import com.sas.graphics.silk.xml.parsers.ParserUtils;
import com.sas.graphics.silk.xml.parsers.TextParser;
import com.sas.graphics.silk.xml.parsers.TreeModelParser;
import com.sas.graphics.util.ColorParse;
import java.awt.Color;
import java.util.Hashtable;
import org.w3c.dom.Element;

public class DecisionTreeParser
extends ChartParser {
    private DecisionTree dtree = null;

    public DecisionTreeParser() {
        this(new DecisionTree());
    }

    public DecisionTreeParser(DecisionTree tree) {
        this.dtree = tree;
    }

    protected void loadFromStatgraph(Hashtable context, Element element) {
        double version = SILKXMLParser.getInstance().getCurrentVersion(context);
        if (version > SILKXMLParser.VERSION_9_2) {
            this.load_version_S2DVR(context, element);
        } else {
            this.load_version_920(context, element);
        }
    }

    protected void load_version_S2DVR(Hashtable context, Element element) {
        String legend;
        TreeModelParser tmp;
        Element tm = ParserUtils.getChildWithTagName((String)"TreeModel", (Element)element);
        if (tm != null) {
            tmp = new TreeModelParser();
            tmp.getFromXML(context, tm, this.dtree.getTreeModel());
            String treeModel = element.getAttribute("treeModel");
            if (treeModel != null) {
                this.dtree.setDataSource(context.get(treeModel));
            }
        } else {
            tmp = new TreeModelParser();
            tmp.getFromXML(context, element, this.dtree.getTreeModel());
            this.dtree.setDataSource((TreeModelInterface)tmp.getObject());
        }
        String orientation = null;
        if (element.hasAttribute("orient")) {
            orientation = element.getAttribute("orient");
        } else if (element.hasAttribute("orientation")) {
            orientation = element.getAttribute("orientation");
        }
        if (orientation != null) {
            if (orientation.equals("Vertical")) {
                this.dtree.setOrientation(1);
            } else if (orientation.equals("Horizontal")) {
                this.dtree.setOrientation(0);
            }
        }
        if ((legend = element.getAttribute("legendVisible")) != null) {
            this.dtree.setLegendVisible(ParserUtils.getBooleanValue((String)legend));
        }
        String depth = element.getAttribute("displayDepth");
        this.dtree.setInitialDisplayDepth(ParserUtils.getIntValue((String)depth));
        if (element.hasAttribute("fitToRegion")) {
            this.dtree.setFitToPageMode(ParserUtils.getBooleanValue((String)element.getAttribute("fitToRegion")));
        } else if (element.hasAttribute("fitToPageMode")) {
            this.dtree.setFitToPageMode(ParserUtils.getBooleanValue((String)element.getAttribute("fitToPageMode")));
        }
        if (element.hasAttribute("scale")) {
            this.dtree.setZoom(ParserUtils.getIntValue((String)element.getAttribute("scale")));
        } else if (element.hasAttribute("zoom")) {
            this.dtree.setZoom(ParserUtils.getIntValue((String)element.getAttribute("zoom")));
        }
        if (element.hasAttribute("linkStyle")) {
            String style = element.getAttribute("linkStyle");
            if (style.equalsIgnoreCase("strait")) {
                this.dtree.setLinkStyle(1);
            } else if (style.equalsIgnoreCase("triangle")) {
                this.dtree.setLinkStyle(2);
            }
        }
        this.loadNodeStyle(ParserUtils.getChildWithTagName((String)"NodeStyle", (Element)element), context);
        this.loadFlaggedNodeStyle(ParserUtils.getChildWithTagName((String)"FlaggedNodeStyle", (Element)element), context);
        Element linkText = ParserUtils.getChildWithTagName((String)"LinkText", (Element)element);
        if (linkText != null) {
            this.dtree.setLinkText(TextParser.parseTextElement((Element)linkText));
        }
    }

    protected void load_version_920(Hashtable context, Element element) {
        Element linkElement;
        String legend;
        String orientation;
        String treeModel;
        Element tm = ParserUtils.getChildWithTagName((String)"TreeModel", (Element)element);
        if (tm != null) {
            TreeModelParser tmp = new TreeModelParser();
            tmp.getFromXML(context, tm, this.dtree.getTreeModel());
        }
        if ((treeModel = element.getAttribute("treeModel")) != null) {
            this.dtree.setTreeModel((TreeModelInterface)context.get(treeModel));
        }
        if ((orientation = element.getAttribute("orientation")) != null) {
            if (orientation.equals("Vertical")) {
                this.dtree.setOrientation(1);
            } else if (orientation.equals("Horizontal")) {
                this.dtree.setOrientation(0);
            }
        }
        if ((legend = element.getAttribute("legendVisible")) != null) {
            this.dtree.setLegendVisible(ParserUtils.getBooleanValue((String)legend));
        }
        String depth = element.getAttribute("displayDepth");
        this.dtree.setInitialDisplayDepth(ParserUtils.getIntValue((String)depth));
        if (element.hasAttribute("fitToPageMode")) {
            this.dtree.setFitToPageMode(ParserUtils.getBooleanValue((String)element.getAttribute("fitToPageMode")));
        }
        if (element.hasAttribute("zoom")) {
            this.dtree.setZoom(ParserUtils.getIntValue((String)element.getAttribute("zoom")));
        }
        if (element.hasAttribute("linkStyle")) {
            String style = element.getAttribute("linkStyle");
            if (style.equalsIgnoreCase("strait")) {
                this.dtree.setLinkStyle(1);
            } else if (style.equalsIgnoreCase("triangle")) {
                this.dtree.setLinkStyle(2);
            }
        }
        if ((linkElement = ParserUtils.getChildWithTagName((String)"LinkStyle", (Element)element)) != null) {
            String useColorRamp = linkElement.getAttribute("useColorRamp");
            if (useColorRamp != null && useColorRamp.equalsIgnoreCase("TRUE")) {
                String colorMapper;
                Element e = ParserUtils.getChildWithTagName((String)"ColorRamp", (Element)linkElement);
                if (e != null) {
                    ColorRampParser parser = new ColorRampParser();
                    parser.getFromXML(context, e, null);
                }
                if ((colorMapper = linkElement.getAttribute("colorMapper")) != null && colorMapper.length() > 0) {
                    this.dtree.setLinkColorRamp((ColorInterface)context.get(colorMapper));
                }
                this.dtree.setPropertyValue(5007, true);
            } else {
                String linkBackgroundColor = linkElement.getAttribute("linkColor");
                if (linkBackgroundColor != null && linkBackgroundColor.trim().length() > 0) {
                    this.dtree.setLinkSolidColor(ColorParse.getColorFromString((String)linkBackgroundColor));
                    this.dtree.setPropertyValue(5007, false);
                }
            }
        }
        this.loadNodeStyle(ParserUtils.getChildWithTagName((String)"NodeStyle", (Element)element), context);
        this.loadFlaggedNodeStyle(ParserUtils.getChildWithTagName((String)"FlaggedNodeStyle", (Element)element), context);
        Element linkText = ParserUtils.getChildWithTagName((String)"LinkText", (Element)element);
        if (linkText != null) {
            this.dtree.setLinkText(TextParser.parseTextElement((Element)linkText));
        }
    }

    private void loadFlaggedNodeStyle(Element element, Hashtable context) {
        Element text;
        String outlineWidth;
        if (element == null) {
            return;
        }
        String color = element.getAttribute("color");
        if (color != null && color.length() > 0) {
            this.dtree.setFlaggedNodeColor(ColorParse.getColorFromString((String)color));
        }
        if ((outlineWidth = element.getAttribute("outlineWidth")) != null && outlineWidth.length() > 0) {
            this.dtree.setFlaggedNodeOutlineWidth(ParserUtils.getIntValue((String)outlineWidth));
        }
        if ((text = ParserUtils.getChildWithTagName((String)"FlaggedNodeText", (Element)element)) != null) {
            this.dtree.setFlaggedNodeText(TextParser.parseTextElement((Element)text));
        }
    }

    private void loadNodeStyle(Element element, Hashtable context) {
        Element nodeText;
        String nodeBackgroundColor;
        String colorMapper;
        ColorRampParser parser;
        Element e;
        String useColorRamp;
        if (element == null) {
            return;
        }
        String minnodesize = element.getAttribute("minNodeSize");
        String maxnodesize = element.getAttribute("maxNodeSize");
        if (minnodesize != null && maxnodesize != null && minnodesize.length() != 0 && maxnodesize.length() != 0) {
            this.dtree.setNodeSizeRange(ParserUtils.getDoubleValue((String)minnodesize), ParserUtils.getDoubleValue((String)maxnodesize));
        }
        if ((useColorRamp = element.getAttribute("useColorRamp")) == null || useColorRamp.trim().length() == 0) {
            e = ParserUtils.getChildWithTagName((String)"ColorRamp", (Element)element);
            if (e != null) {
                parser = new ColorRampParser();
                parser.getFromXML(context, e, null);
            }
            if ((colorMapper = element.getAttribute("colorMapper")) != null && colorMapper.length() > 0) {
                this.dtree.setNodeColorRamp((ColorInterface)context.get(colorMapper));
            }
        } else if (useColorRamp != null && useColorRamp.equalsIgnoreCase("TRUE")) {
            e = ParserUtils.getChildWithTagName((String)"ColorRamp", (Element)element);
            if (e != null) {
                parser = new ColorRampParser();
                parser.getFromXML(context, e, null);
            }
            if ((colorMapper = element.getAttribute("colorMapper")) != null && colorMapper.length() > 0) {
                this.dtree.setNodeColorRamp((ColorInterface)context.get(colorMapper));
            }
            this.dtree.setPropertyValue(5015, true);
        } else if (useColorRamp != null && useColorRamp.equalsIgnoreCase("FALSE") && (nodeBackgroundColor = element.getAttribute("nodeColor")) != null && nodeBackgroundColor.trim().length() > 0) {
            this.dtree.setNodeBackground(ColorParse.getColorFromString((String)nodeBackgroundColor));
            this.dtree.setPropertyValue(5015, false);
        }
        String outlineWidth = element.getAttribute("outlineWidth");
        if (outlineWidth != null && outlineWidth.length() > 0) {
            this.dtree.setNodeOutlineWidth(ParserUtils.getIntValue((String)outlineWidth));
        }
        if ((nodeText = ParserUtils.getChildWithTagName((String)"NodeText", (Element)element)) != null) {
            this.dtree.setNodeText(TextParser.parseTextElement((Element)nodeText));
        }
    }

    protected void loadFromODS(Hashtable context, Element element) {
    }

    protected Element getODSXML(Hashtable context, Object object) {
        return null;
    }

    protected Element getStatgraphXML(Hashtable context, Object object) {
        Element linkText;
        TextParser tp;
        Element nodeText;
        int orient;
        DecisionTree tree = null;
        if (!(object instanceof DecisionTree)) {
            return null;
        }
        tree = (DecisionTree)object;
        Element rc = ParserUtils.newElement((Hashtable)context, (String)"DecisionTree");
        TreeModelParser tmp = new TreeModelParser(tree.getTreeModel());
        Element treeModel = tmp.putToXML(context, null);
        if (treeModel != null) {
            rc.appendChild(treeModel);
            rc.setAttribute("treeModel", treeModel.getAttribute("name"));
        }
        if ((orient = tree.getOrientation()) == 0) {
            rc.setAttribute("orientation", "Horizontal");
        }
        if (tree.getLegendVisible()) {
            rc.setAttribute("legendVisible", "true");
        }
        if (!tree.isFitToPageMode()) {
            rc.setAttribute("fitToPageMode", "false");
            rc.setAttribute("zoom", tree.getZoom() + "");
        }
        if (tree.getLinkStyle() != 0) {
            if (tree.getLinkStyle() == 1) {
                rc.setAttribute("linkStyle", "strait");
            } else if (tree.getLinkStyle() == 2) {
                rc.setAttribute("linkStyle", "triangle");
            }
        }
        Element nodeStyle = ParserUtils.newElement((Hashtable)context, (String)"NodeStyle");
        Object value = tree.getPropertyValue(5015);
        if (value != null && ((Boolean)value).booleanValue()) {
            ColorRampParser crp = new ColorRampParser();
            Element colorRampElement = crp.putToXML(context, (Object)tree.getNodeColorRamp());
            nodeStyle.appendChild(colorRampElement);
            nodeStyle.setAttribute("colorMapper", colorRampElement.getAttribute("name"));
            nodeStyle.setAttribute("useColorRamp", "true");
        } else if (tree.getPropertyValue(5016) != null) {
            nodeStyle.setAttribute("useColorRamp", "false");
            nodeStyle.setAttribute("nodeColor", ColorParse.getColorStrg((Color)tree.getNodeBackground().getSolidBackground(), (boolean)false));
        }
        rc.appendChild(nodeStyle);
        nodeStyle.setAttribute("outlineWidth", tree.getNodeOutlineWidth() + "");
        Element linkStyle = ParserUtils.newElement((Hashtable)context, (String)"LinkStyle");
        Object val = tree.getPropertyValue(5007);
        if (val != null && ((Boolean)val).booleanValue()) {
            ColorRampParser crp = new ColorRampParser();
            Element colorRampElement = crp.putToXML(context, (Object)tree.getLinkColorRamp());
            linkStyle.appendChild(colorRampElement);
            linkStyle.setAttribute("colorMapper", colorRampElement.getAttribute("name"));
            linkStyle.setAttribute("useColorRamp", "true");
        } else if (tree.getPropertyValue(5005) != null) {
            linkStyle.setAttribute("useColorRamp", "false");
            linkStyle.setAttribute("linkColor", ColorParse.getColorStrg((Color)tree.getLinkSolidColor(), (boolean)false));
        }
        rc.appendChild(linkStyle);
        TextStyleInterface tsi = tree.getNodeText();
        if (tsi != null && (nodeText = (tp = new TextParser()).putToXML(context, (Object)tsi, "NodeText")) != null) {
            nodeStyle.appendChild(nodeText);
        }
        if ((tsi = tree.getLinkText()) != null && (linkText = (tp = new TextParser()).putToXML(context, (Object)tsi, "LinkText")) != null) {
            rc.appendChild(linkText);
        }
        if (rc.getAttributes().getLength() == 0 && rc.getChildNodes().getLength() == 0) {
            return null;
        }
        return rc;
    }

    public Object getObject() {
        return this.dtree;
    }

    public boolean setObject(Object instance) {
        if (instance == null || !(instance instanceof DecisionTree)) {
            return false;
        }
        this.dtree = (DecisionTree)instance;
        return true;
    }
}

