/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.silk.xml.parsers;

import com.sas.graphics.silk.ConstComponent;
import com.sas.graphics.silk.constchart.ConstViewer;
import com.sas.graphics.silk.interfaces.DataFilterReadInterface;
import com.sas.graphics.silk.util.nld.DataFilterModel;
import com.sas.graphics.silk.xml.parsers.ChartParser;
import com.sas.graphics.silk.xml.parsers.ParserUtils;
import com.sas.graphics.util.nld.NLDModel;
import com.sas.graphics.util.nld.NLDViewer;
import java.awt.Font;
import java.util.Hashtable;
import java.util.Vector;
import org.w3c.dom.Element;

public class ConstellationParser
extends ChartParser {
    private ConstComponent chart = null;

    public ConstellationParser() {
        this(null);
    }

    public ConstellationParser(ConstComponent instance) {
        this.chart = instance;
    }

    protected void loadFromStatgraph(Hashtable context, Element element) {
        NLDModel model;
        DataFilterReadInterface lFilter;
        DataFilterReadInterface nFilter;
        Element subSet;
        String lauoutStrategyStr;
        String showThresholdScrollbar;
        String linkWidth;
        String lsup;
        String linkData;
        String nodeData;
        String nodeSize;
        String fontSize;
        String fontName;
        String animateStr;
        if (this.chart == null) {
            this.chart = new ConstComponent();
        }
        if ((animateStr = element.getAttribute("animate")) != null && animateStr.length() != 0) {
            this.chart.doAnimate(ParserUtils.getBooleanValue((String)animateStr));
        } else {
            this.chart.doAnimate(false);
        }
        String dstype = element.getAttribute("dstype");
        if (dstype != null && dstype.length() != 0) {
            this.chart.setDatasetType(dstype);
        }
        String layout = element.getAttribute("layout");
        String nodeShape = element.getAttribute("nodeShape");
        if (nodeShape != null && nodeShape.length() > 0) {
            this.chart.setNodeShape(nodeShape);
        }
        if ((fontName = element.getAttribute("fontName")) != null && fontName.length() != 0) {
            this.chart.setFontName(fontName);
        }
        if ((fontName = element.getAttribute("fontFamily")) != null && fontName.length() != 0) {
            this.chart.setFontName(fontName);
        }
        if ((fontSize = element.getAttribute("fontSize")) != null && fontSize.length() != 0) {
            this.chart.setFontSize(ParserUtils.getIntValue((String)fontSize));
        }
        if ((nodeSize = element.getAttribute("nodeSize")) != null && nodeSize.length() != 0) {
            this.chart.setNodeSize(ParserUtils.getDoubleValue((String)nodeSize));
        }
        if ((nodeData = element.getAttribute("nodeData")) != null && nodeData.length() != 0) {
            this.chart.setDataSource(0, ParserUtils.getDataFromContext((Hashtable)context, (String)ParserUtils.getDataID((String)nodeData)));
        } else {
            String nid = element.getAttribute("nid");
            if (nid != null && nid.length() != 0) {
                this.chart.setDataSource(0, ParserUtils.getDataFromContext((Hashtable)context, (String)ParserUtils.getDataID((String)nid)));
            }
        }
        ConstellationParser.setRole(this.chart, 0, element, "nid", "ID");
        ConstellationParser.setRole(this.chart, 0, element, "nvalue", "Value");
        ConstellationParser.setRole(this.chart, 0, element, "nsize", "Size");
        ConstellationParser.setRole(this.chart, 0, element, "ncolor", "Color");
        ConstellationParser.setRole(this.chart, 0, element, "nlabel", "Label");
        ConstellationParser.setRole(this.chart, 0, element, "ntip", "Info");
        ConstellationParser.setRole(this.chart, 0, element, "nurl", "Url");
        if (!ConstellationParser.setRole(this.chart, 0, element, "nodeX", "X")) {
            ConstellationParser.setRole(this.chart, 0, element, "nodex", "X");
        }
        if (!ConstellationParser.setRole(this.chart, 0, element, "nodeY", "Y")) {
            ConstellationParser.setRole(this.chart, 0, element, "nodey", "Y");
        }
        if (layout != null && layout.length() != 0) {
            this.chart.setLayout(layout);
        }
        if ((linkData = element.getAttribute("linkData")) != null && linkData.length() != 0) {
            this.chart.setDataSource(1, ParserUtils.getDataFromContext((Hashtable)context, (String)ParserUtils.getDataID((String)linkData)));
        } else {
            String lid = element.getAttribute("lid");
            if (lid != null && lid.length() != 0) {
                this.chart.setDataSource(1, ParserUtils.getDataFromContext((Hashtable)context, (String)ParserUtils.getDataID((String)lid)));
            }
        }
        ConstellationParser.setRole(this.chart, 1, element, "lid", "ID");
        ConstellationParser.setRole(this.chart, 1, element, "lfrom", "From");
        ConstellationParser.setRole(this.chart, 1, element, "lto", "To");
        ConstellationParser.setRole(this.chart, 1, element, "lvalue", "Value");
        ConstellationParser.setRole(this.chart, 1, element, "lwidth", "Width");
        ConstellationParser.setRole(this.chart, 1, element, "lcolor", "Color");
        ConstellationParser.setRole(this.chart, 1, element, "ltip", "Info");
        String ldir = element.getAttribute("ldirected");
        if (ldir != null && ldir.length() != 0) {
            this.chart.showDirectionArrow(ParserUtils.getBooleanValue((String)ldir));
        }
        if ((lsup = element.getAttribute("lsupport")) != null && lsup.length() != 0) {
            this.chart.setSupport(ParserUtils.getDoubleValue((String)lsup));
        }
        if ((linkWidth = element.getAttribute("linkWidth")) != null && linkWidth.length() != 0) {
            this.chart.setLinkWidth(linkWidth);
        }
        String linkWhere = element.getAttribute("lwhere");
        if (dstype.equalsIgnoreCase("assoc") && (showThresholdScrollbar = element.getAttribute("showThresholdScrollbar")) != null && showThresholdScrollbar.length() != 0) {
            if (showThresholdScrollbar.equalsIgnoreCase("yes") || showThresholdScrollbar.equalsIgnoreCase("y") || showThresholdScrollbar.equalsIgnoreCase("true") || showThresholdScrollbar.equalsIgnoreCase("t")) {
                this.chart.showThresholdScrollbar(true);
            } else {
                this.chart.showThresholdScrollbar(false);
            }
        }
        if ((lauoutStrategyStr = element.getAttribute("layoutType")) != null && lauoutStrategyStr.length() != 0) {
            int type = ParserUtils.getIntValue((String)lauoutStrategyStr);
            if (type == 3 || type == 0 || type == 1 || type == 2) {
                this.chart.setLayoutStrategy(type);
            } else {
                this.chart.setLayoutStrategy(3);
            }
        } else {
            this.chart.setLayoutStrategy(3);
        }
        String nodeWhere = element.getAttribute("nwhere");
        ConstViewer constViewer = null;
        Object obj = this.chart.getChartObject(null);
        if (obj instanceof ConstViewer) {
            constViewer = (ConstViewer)((Object)obj);
        }
        if (constViewer != null && (subSet = ParserUtils.getChildWithTagName((String)"SubSet", (Element)element)) != null) {
            this.setNodeVisibleState(constViewer, subSet);
        }
        this.chart.load();
        if (nodeWhere != null && nodeWhere.length() > 0 && (nFilter = this.chart.getFilter(0)) != null) {
            nFilter.applyWhereClause(nodeWhere, true);
        }
        if (linkWhere != null && linkWhere.length() > 0 && (lFilter = this.chart.getFilter(1)) != null) {
            lFilter.applyWhereClause(linkWhere, true);
        }
        if (constViewer != null && (model = constViewer.getModel()) instanceof DataFilterModel) {
            model.setViewer((NLDViewer)constViewer);
            ((DataFilterModel)model).dataChanged();
        }
    }

    private void setNodeVisibleState(ConstViewer constViewer, Element subSet) {
        if (constViewer == null || subSet == null) {
            return;
        }
        Vector<String> subsetNodeIds = new Vector<String>();
        Element node = null;
        boolean areNodesVisible = false;
        int i = 1;
        while ((node = ParserUtils.getChildWithTagName((String)"Node", (Element)subSet, (int)i)) != null) {
            String id = node.getAttribute("id");
            if (id != null) {
                subsetNodeIds.addElement(id);
            }
            String visible = node.getAttribute("visible");
            if (id != null && visible != null && visible.length() != 0 && ParserUtils.getBooleanValue((String)visible)) {
                areNodesVisible = true;
            }
            ++i;
        }
        constViewer.setSubsetNodes(subsetNodeIds, areNodesVisible);
    }

    protected static boolean setRole(ConstComponent chart, int type, Element context, String contextKey, Object role) {
        if (chart == null || context == null || contextKey == null || role == null) {
            return false;
        }
        if (context.getAttribute(contextKey).length() == 0) {
            return false;
        }
        String id = ParserUtils.getVariableID((String)context.getAttribute(contextKey));
        if (id == null) {
            return false;
        }
        return chart.setRole(type, id.toString(), role.toString());
    }

    protected void loadFromODS(Hashtable context, Element element) {
    }

    protected Element getODSXML(Hashtable context, Object object) {
        return null;
    }

    protected Element getStatgraphXML(Hashtable context, Object object) {
        Double nodeSize;
        String nodeShape;
        String dstype;
        Object ldata;
        String nWhere;
        ConstComponent constComp = this.chart;
        if (object instanceof ConstComponent) {
            constComp = (ConstComponent)object;
        }
        if (constComp == null) {
            return null;
        }
        Element rc = ParserUtils.newElement((Hashtable)context, (String)"ConstChart");
        Object ndata = constComp.getDataSource(0);
        if (ndata != null) {
            rc.setAttribute("nodeData", ParserUtils.getNameForDataObject((Object)ndata, (Hashtable)context));
        }
        if ((nWhere = constComp.getWhereClause(0)) != null && nWhere.length() > 0) {
            rc.setAttribute("nwhere", nWhere);
        }
        if ((ldata = constComp.getDataSource(1)) != null) {
            rc.setAttribute("linkData", ParserUtils.getNameForDataObject((Object)ldata, (Hashtable)context));
        }
        if ((nWhere = constComp.getWhereClause(1)) != null && nWhere.length() > 0) {
            rc.setAttribute("lwhere", nWhere);
        }
        if ((dstype = constComp.getDatasetType()) != null && dstype.length() > 0) {
            rc.setAttribute("dstype", dstype);
            if (dstype.equalsIgnoreCase("assoc")) {
                rc.setAttribute("showThresholdScrollbar", constComp.isThresholdScrollbarShown() + "");
            }
        }
        int linkWidth = constComp.getLinkWidth();
        rc.setAttribute("linkWidth", linkWidth + "");
        double support = constComp.getSupport();
        rc.setAttribute("lsupport", support + "");
        String layout = constComp.getChartLayout();
        if (layout != null && layout.length() > 0) {
            rc.setAttribute("layout", layout);
        }
        if ((nodeShape = constComp.getNodeShape()) != null && nodeShape.length() > 0) {
            rc.setAttribute("nodeShape", nodeShape);
        }
        if ((nodeSize = Double.valueOf(constComp.getNodeSize())) != null && !Double.isNaN(nodeSize) && nodeSize > -1.0) {
            rc.setAttribute("nodeSize", String.valueOf(nodeSize));
        }
        boolean ldir = constComp.areDirectionArrowsShown();
        rc.setAttribute("ldirected", ldir + "");
        Font f = constComp.getFont();
        if (f != null) {
            rc.setAttribute("fontFamily", f.getName());
            rc.setAttribute("fontSize", f.getSize() + "");
        }
        this.getVariable(constComp, 0, rc, "nid", "ID");
        this.getVariable(constComp, 0, rc, "nvalue", "Value");
        this.getVariable(constComp, 0, rc, "nsize", "Size");
        this.getVariable(constComp, 0, rc, "ncolor", "Color");
        this.getVariable(constComp, 0, rc, "nlabel", "Label");
        this.getVariable(constComp, 0, rc, "ntip", "Info");
        this.getVariable(constComp, 0, rc, "nurl", "Url");
        this.getVariable(constComp, 0, rc, "nodeX", "X");
        this.getVariable(constComp, 0, rc, "nodeY", "Y");
        this.getVariable(constComp, 1, rc, "lid", "ID");
        this.getVariable(constComp, 1, rc, "lfrom", "From");
        this.getVariable(constComp, 1, rc, "lto", "To");
        this.getVariable(constComp, 1, rc, "lvalue", "Value");
        this.getVariable(constComp, 1, rc, "lwidth", "Width");
        this.getVariable(constComp, 1, rc, "lcolor", "Color");
        this.getVariable(constComp, 1, rc, "ltip", "Info");
        boolean animateFlag = constComp.isAnimationOn();
        rc.setAttribute("animate", animateFlag + "");
        int layoutType = constComp.getLayoutStrategy();
        if (layoutType == 3 || layoutType == 0 || layoutType == 1 || layoutType == 2) {
            rc.setAttribute("layoutType", layoutType + "");
        } else {
            rc.setAttribute("layoutType", "3");
        }
        Object o = context.get("SAVE_VIEW_STATE");
        boolean saveViewState = false;
        if (o instanceof Boolean) {
            saveViewState = (Boolean)o;
        }
        if (saveViewState) {
            Element nodeState;
            ConstViewer constViewer = null;
            Object ob = constComp.getChartObject(null);
            if (ob instanceof ConstViewer) {
                constViewer = (ConstViewer)((Object)ob);
            }
            if ((nodeState = this.putVisibleNodesToXML(constComp, constViewer, rc, context)) != null) {
                rc.appendChild(nodeState);
            }
        }
        return rc;
    }

    private Element putVisibleNodesToXML(ConstComponent chart, ConstViewer constViewer, Element rc, Hashtable context) {
        if (chart == null || constViewer == null || rc == null) {
            return null;
        }
        Vector subsetNodes = new Vector();
        Hashtable data = constViewer.getSubsetNodes();
        if (data == null) {
            return null;
        }
        boolean subsetNodesVisible = true;
        subsetNodes = (Vector)data.get(new Integer(1));
        if (subsetNodes == null) {
            subsetNodesVisible = false;
            subsetNodes = (Vector)data.get(new Integer(0));
        } else {
            subsetNodesVisible = true;
        }
        if (subsetNodes == null || subsetNodes.size() == 0) {
            return null;
        }
        int nSubsetNodes = subsetNodes.size();
        Element subSet = ParserUtils.newElement((Hashtable)context, (String)"SubSet");
        for (int i = 0; i < nSubsetNodes; ++i) {
            Object nid = subsetNodes.elementAt(i);
            if (nid == null) continue;
            Element nodeState = ParserUtils.newElement((Hashtable)context, (String)"Node");
            nodeState.setAttribute("id", nid.toString());
            if (subsetNodesVisible) {
                nodeState.setAttribute("visible", "true");
            } else {
                nodeState.setAttribute("visible", "false");
            }
            subSet.appendChild(nodeState);
        }
        return subSet;
    }

    private void getVariable(ConstComponent constComp, int type, Element element, String roleAttr, String role) {
        if (constComp == null || element == null || role == null) {
            return;
        }
        Object var = constComp.getVariable(type, role);
        if (var instanceof String && var.toString().length() > 0) {
            element.setAttribute(roleAttr, var.toString());
        }
    }

    public Object getObject() {
        if (this.chart == null) {
            this.chart = new ConstComponent();
        }
        return this.chart;
    }

    public boolean setObject(Object instance) {
        if (instance == null || !(instance instanceof ConstComponent)) {
            return false;
        }
        this.chart = (ConstComponent)instance;
        return true;
    }
}

