/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.silk.xml.parsers;

import com.sas.graphics.silk.MapComponent;
import com.sas.graphics.silk.map.Categorization;
import com.sas.graphics.silk.xml.parsers.ChartParser;
import com.sas.graphics.silk.xml.parsers.ParserUtils;
import com.sas.graphics.silk.xml.parsers.SILKElementInfoInterface;
import com.sas.graphics.silk.xml.parsers.SILKElementInfoReader;
import java.util.Hashtable;
import org.w3c.dom.Element;

public class ClassicMapParser
extends ChartParser {
    private MapComponent map = null;
    private SILKElementInfoReader mapInfo = null;

    public ClassicMapParser() {
        this(new MapComponent());
    }

    public ClassicMapParser(MapComponent instance) {
        this.map = instance;
        String configFile = "com/sas/graphics/silk/xml/parsers/config/map_classic.config";
        this.mapInfo = new SILKElementInfoReader(configFile);
        this.mapInfo.setInstance((Object)this.map);
    }

    protected void loadFromStatgraph(Hashtable context, Element element) {
        String snum;
        String markerData;
        String responseData;
        String mapData = element.getAttribute("mapData");
        if (mapData != null) {
            this.map.setSpatialDataSource(context.get(mapData));
        }
        if ((responseData = element.getAttribute("responseData")) != null && responseData.length() != 0) {
            this.map.setResponseDataSource(context.get(responseData));
        }
        if ((markerData = element.getAttribute("markerData")) != null && markerData.length() != 0) {
            this.map.setMarkerDataSource(context.get(markerData));
        }
        ParserUtils.parseElement((Hashtable)context, (Element)element, (SILKElementInfoInterface)this.mapInfo);
        String cat = element.getAttribute("categorization");
        if (cat != null) {
            if (cat.equalsIgnoreCase("Continuous")) {
                this.map.setMapColorCategorization(new Categorization(0));
            } else if (cat.equalsIgnoreCase("Discrete")) {
                this.map.setMapColorCategorization(new Categorization(1));
            } else if (cat.equalsIgnoreCase("EqualWidth")) {
                this.map.setMapColorCategorization(new Categorization(3));
            } else if (cat.equalsIgnoreCase("Quantile")) {
                this.map.setMapColorCategorization(new Categorization(2));
            } else if (cat.equalsIgnoreCase("CustomContinuous")) {
                this.map.setMapColorCategorization(new Categorization(5));
            } else if (cat.equalsIgnoreCase("CustomDiscrete")) {
                this.map.setMapColorCategorization(new Categorization(4));
            }
        }
        if ((snum = element.getAttribute("catSize")) != null && snum.length() > 0) {
            int num = Integer.valueOf(snum);
            Categorization cate = this.map.getMapCategorization();
            cate.setCategorySize(num);
            this.map.setMapColorCategorization(cate);
        }
        if ((cat = element.getAttribute("markerCategorization")) != null) {
            if (cat.equalsIgnoreCase("Continuous")) {
                this.map.setMarkerColorCategorization(new Categorization(0));
            } else if (cat.equalsIgnoreCase("Discrete")) {
                this.map.setMarkerColorCategorization(new Categorization(1));
            } else if (cat.equalsIgnoreCase("EqualWidth")) {
                this.map.setMarkerColorCategorization(new Categorization(3));
            } else if (cat.equalsIgnoreCase("Quantile")) {
                this.map.setMarkerColorCategorization(new Categorization(2));
            } else if (cat.equalsIgnoreCase("CustomContinuous")) {
                this.map.setMarkerColorCategorization(new Categorization(5));
            } else if (cat.equalsIgnoreCase("CustomDiscrete")) {
                this.map.setMarkerColorCategorization(new Categorization(4));
            }
        }
    }

    protected void loadFromODS(Hashtable context, Element element) {
    }

    protected Element getODSXML(Hashtable context, Object object) {
        return null;
    }

    protected Element getStatgraphXML(Hashtable context, Object object) {
        Element e = ParserUtils.toXML((String)"MapChartParm", (Hashtable)context, (Object)object, (SILKElementInfoInterface)this.mapInfo);
        String s1 = "MarkerCategorization";
        String s2 = this.map.getMarkerCategorization().getCategorizationName();
        e.setAttribute(s1, s2);
        s1 = "MapCategorization";
        s2 = this.map.getMapCategorization().getCategorizationName();
        e.setAttribute(s1, s2);
        return e;
    }

    public Object getObject() {
        return this.map;
    }

    public boolean setObject(Object instance) {
        if (instance == null || !(instance instanceof MapComponent)) {
            return false;
        }
        this.map = (MapComponent)instance;
        if (this.mapInfo != null) {
            this.mapInfo.setInstance((Object)this.map);
        }
        return true;
    }
}

