/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.silk.util;

import com.sas.graphics.silk.interfaces.ComponentInterface;
import com.sas.graphics.silk.interfaces.GraphInterface;
import com.sas.graphics.silk.util.GraphLayout;
import com.sas.graphics.silk.util.ResourceLoader;
import com.sas.graphics.silk.util.SILKChartFlavor;
import com.sas.graphics.tools.wizard.WizardEntry;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.IOException;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;

class Cell
extends JPanel
implements MouseListener,
ActionListener,
DropTargetListener {
    private static final long serialVersionUID = -7014897896136015643L;
    GraphLayout graphLayout = null;
    JButton hSplit = null;
    JButton vSplit = null;
    JButton graph = null;
    private Dimension oldSize = null;

    public Cell(GraphLayout layout) {
        this.graphLayout = layout;
        this.addMouseListener(this);
        BoxLayout box = new BoxLayout(this, 1);
        this.setLayout(box);
        this.hSplit = new JButton(new ImageIcon(ResourceLoader.getImage((Component)this, (String)"icons/SplitPaneHorizontal.gif")));
        this.hSplit.addActionListener(this);
        this.hSplit.setToolTipText(ResourceLoader.getResourceString((Object)this.graphLayout.rb, (String)"GraphLayout.Split_Horizontal.txt", (String)"New horizontal split"));
        this.vSplit = new JButton(new ImageIcon(ResourceLoader.getImage((Component)this, (String)"icons/SplitPaneVertical.gif")));
        this.vSplit.addActionListener(this);
        this.vSplit.setToolTipText(ResourceLoader.getResourceString((Object)this.graphLayout.rb, (String)"GraphLayout.Split_Vertical.txt", (String)"New vertical split"));
        this.graph = new JButton(new ImageIcon(ResourceLoader.getImage((Component)this, (String)"icons/SplitPaneGraph.gif")));
        this.graph.addActionListener(this);
        this.graph.setToolTipText(ResourceLoader.getResourceString((Object)this.graphLayout.rb, (String)"GraphLayout.New_Graph.txt", (String)"New graph"));
        JPanel panel = new JPanel(new FlowLayout(1));
        panel.add(this.hSplit);
        panel.add(this.vSplit);
        panel.add(this.graph);
        this.add(Box.createGlue());
        this.add(panel);
        this.add(Box.createGlue());
        new DropTarget(this, this);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        this.graphLayout.select(this);
        if (source == this.hSplit) {
            this.graphLayout.insertNode(0);
        } else if (source == this.vSplit) {
            this.graphLayout.insertNode(1);
        } else if (source == this.graph) {
            this.graphLayout.wiz.setVisible(true);
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent me) {
        Object source;
        int x = me.getX();
        int y = me.getY();
        this.graphLayout.mouseEventSource = source = me.getSource();
        int flags = me.getModifiers();
        if ((flags & 4) != 0) {
            this.graphLayout.buildMenu(me.getSource());
            this.graphLayout.menu.show((Component)me.getSource(), x, y);
        }
        if (source instanceof JPanel) {
            this.graphLayout.select((JComponent)source);
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void removeNotify() {
        this.oldSize = this.getSize();
        super.removeNotify();
    }

    @Override
    public void addNotify() {
        super.addNotify();
        if (this.oldSize != null) {
            this.setPreferredSize(this.oldSize);
        }
    }

    @Override
    public void dragEnter(DropTargetDragEvent dtde) {
    }

    @Override
    public void dragExit(DropTargetEvent dte) {
    }

    @Override
    public void dragOver(DropTargetDragEvent dtde) {
    }

    @Override
    public synchronized void drop(DropTargetDropEvent dropTargetDropEvent) {
        try {
            Transferable tr = dropTargetDropEvent.getTransferable();
            if (tr.isDataFlavorSupported(SILKChartFlavor.silkChartFlavor)) {
                dropTargetDropEvent.acceptDrop(3);
                WizardEntry entry = (WizardEntry)tr.getTransferData(SILKChartFlavor.silkChartFlavor);
                JComponent component = entry.getGraph();
                this.graphLayout.select(this);
                this.graphLayout.recursiveAddMouseListener(component);
                if (component instanceof ComponentInterface) {
                    ((ComponentInterface)component).enablePopup(false);
                }
                if (this.graphLayout.isInModalDialog && component instanceof GraphInterface) {
                    ((GraphInterface)component).setToolBar(null);
                }
                if (this.graphLayout.renderer != null) {
                    this.graphLayout.renderer.addNodeType(component.getClass(), entry.getName(), entry.getImage() == null ? null : new ImageIcon(entry.getImage()));
                }
                this.graphLayout.addNode(this, component);
            } else {
                dropTargetDropEvent.rejectDrop();
            }
        }
        catch (IOException io) {
            io.printStackTrace();
            dropTargetDropEvent.rejectDrop();
        }
        catch (UnsupportedFlavorException ufe) {
            ufe.printStackTrace();
            dropTargetDropEvent.rejectDrop();
        }
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent dtde) {
    }
}

