/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.silk.ui.graphwizard;

import com.sas.graphics.silk.BaseMatrixComponent;
import com.sas.graphics.silk.interfaces.DataFilterReadInterface;
import com.sas.graphics.silk.interfaces.RoleInterface;
import com.sas.graphics.silk.ui.MultipleVarsRolePanel;
import com.sas.graphics.silk.ui.graphwizard.SILKWizardUtil;
import com.sas.graphics.silk.util.FilterFactory;
import com.sas.graphics.silk.util.ResourceLoader;
import com.sas.graphics.silk.util.Roles;
import com.sas.graphics.silk.util.SILKNumber;
import com.sas.graphics.tools.wizard.WizardPage;
import java.awt.BorderLayout;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.JComponent;

public class MatrixRolePage
extends WizardPage
implements PropertyChangeListener {
    private MultipleVarsRolePanel rolePanel = null;
    private SILKNumber matrixRole = null;
    ResourceBundle rb = ResourceLoader.loadBundle((String)"com.sas.graphics.silk.ui.graphwizard.silk_graphwizard_NLS");

    public MatrixRolePage() {
        this.setLayout(new BorderLayout());
        this.matrixRole = Roles.getInstance(null).getRoleObject("ROLE_MATRIX_VAR");
    }

    protected void display() {
        this.initialize();
        super.display();
    }

    private void initialize() {
        if (this.getGraph() == null) {
            return;
        }
        if (this.rolePanel != null) {
            return;
        }
        BaseMatrixComponent ri = this.getGraph();
        DataFilterReadInterface filter = FilterFactory.getDataSourceFilter((Object)ri.getDataSource());
        this.rolePanel = new MultipleVarsRolePanel((RoleInterface)ri, this.matrixRole, filter, false);
        this.rolePanel.setControlButtonsVisible(false);
        this.rolePanel.addPropertyChangeListener((PropertyChangeListener)this);
        this.add((Component)this.rolePanel);
    }

    private BaseMatrixComponent getGraph() {
        JComponent graph = SILKWizardUtil.getInternalGraph(this.wizard);
        if (graph instanceof BaseMatrixComponent) {
            BaseMatrixComponent rc = (BaseMatrixComponent)((Object)graph);
            return rc;
        }
        return null;
    }

    public boolean canFinish() {
        return this.canAdvance();
    }

    public boolean canProceed() {
        return this.canAdvance();
    }

    private boolean canAdvance() {
        if (this.rolePanel == null) {
            return false;
        }
        Vector vars = this.rolePanel.getVars();
        return vars != null && vars.size() >= 2;
    }

    public boolean forward() {
        this.applyRoles();
        return super.forward();
    }

    public boolean finish() {
        this.applyRoles();
        return super.finish();
    }

    private void applyRoles() {
        if (this.rolePanel != null) {
            this.rolePanel.applyRoles();
        }
    }

    public void reset() {
        super.reset();
        if (this.rolePanel != null) {
            this.remove((Component)this.rolePanel);
            this.rolePanel.removePropertyChangeListener((PropertyChangeListener)this);
            this.rolePanel.dispose();
        }
        this.rolePanel = null;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        this.wizard.updateButtons();
    }

    public String getTitle() {
        return ResourceLoader.getResourceString((Object)this.rb, (String)"MatrixRolePage.Select_Matrix_RoleVars.txt", (String)"Select MatrixVar roles");
    }
}

