/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.silk.ui.graphwizard;

import com.sas.graphics.silk.interfaces.AxisInterface;
import com.sas.graphics.silk.interfaces.GraphInterface;
import com.sas.graphics.silk.interfaces.LegendInterface;
import com.sas.graphics.silk.interfaces.RenderInterface;
import com.sas.graphics.silk.ui.graphwizard.SILKWizardUtil;
import com.sas.graphics.silk.util.ResourceLoader;
import com.sas.graphics.tools.wizard.WizardPage;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ResourceBundle;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSplitPane;

public class LegendsPage
extends WizardPage
implements ActionListener {
    private static final long serialVersionUID = -1426117159526339598L;
    JRadioButton left;
    JRadioButton right;
    JRadioButton top;
    JRadioButton bottom;
    ResourceBundle rb = ResourceLoader.loadBundle((String)"com.sas.graphics.silk.ui.graphwizard.silk_graphwizard_NLS");

    public GraphInterface getGraph() {
        JComponent graph = SILKWizardUtil.getInternalGraph(this.wizard);
        if (graph instanceof GraphInterface) {
            return (GraphInterface)graph;
        }
        return null;
    }

    public void display() {
        this.removeAll();
        this.setLayout(new BorderLayout());
        JSplitPane split = new JSplitPane();
        JPanel axes = new JPanel(null);
        JLabel label = new JLabel(ResourceLoader.getResourceString((Object)this.rb, (String)"LegendsPage.Axes.txt", (String)"Axes"));
        label.setBounds(25, 25, 100, 25);
        label.setForeground(Color.black);
        axes.add(label);
        JCheckBox check = new JCheckBox(ResourceLoader.getResourceString((Object)this.rb, (String)"LegendsPage.Horizontal.txt", (String)"Horizontal"));
        check.setBounds(50, 50, 250, 25);
        axes.add(check);
        AxisInterface ai = this.getGraph().getAxis((Object)"X");
        if (ai == null) {
            check.setEnabled(false);
        } else {
            if (ai instanceof RenderInterface) {
                check.setSelected(((RenderInterface)ai).isVisible());
            }
            check.addActionListener(this);
            check.setActionCommand("X");
        }
        check = new JCheckBox(ResourceLoader.getResourceString((Object)this.rb, (String)"LegendsPage.Vertical.txt", (String)"Vertical"));
        check.setBounds(50, 75, 250, 25);
        axes.add(check);
        ai = this.getGraph().getAxis((Object)"Y");
        if (ai == null) {
            check.setEnabled(false);
        } else {
            if (ai instanceof RenderInterface) {
                check.setSelected(((RenderInterface)ai).isVisible());
            }
            check.addActionListener(this);
            check.setActionCommand("Y");
        }
        check = new JCheckBox(ResourceLoader.getResourceString((Object)this.rb, (String)"LegendsPage.Depth.txt", (String)"Depth"));
        check.setBounds(50, 100, 250, 25);
        axes.add(check);
        ai = this.getGraph().getAxis((Object)"Z");
        if (ai == null) {
            check.setEnabled(false);
        } else {
            if (ai instanceof RenderInterface) {
                check.setSelected(((RenderInterface)ai).isVisible());
            }
            check.addActionListener(this);
            check.setActionCommand("Z");
        }
        split.setRightComponent(axes);
        JPanel legend = new JPanel(null);
        check = new JCheckBox(ResourceLoader.getResourceString((Object)this.rb, (String)"LegendsPage.Legend.txt", (String)"Legend"));
        check.setBounds(25, 25, 250, 25);
        check.addActionListener(this);
        check.setActionCommand("Legend");
        legend.add(check);
        this.top = new JRadioButton(ResourceLoader.getResourceString((Object)this.rb, (String)"LegendsPage.Top.txt", (String)"Top"));
        this.top.setBounds(50, 50, 200, 25);
        legend.add(this.top);
        this.bottom = new JRadioButton(ResourceLoader.getResourceString((Object)this.rb, (String)"LegendsPage.Bottom.txt", (String)"Bottom"));
        this.bottom.setBounds(50, 75, 200, 25);
        legend.add(this.bottom);
        this.left = new JRadioButton(ResourceLoader.getResourceString((Object)this.rb, (String)"LegendsPage.Left.txt", (String)"Left"));
        this.left.setBounds(50, 100, 200, 25);
        legend.add(this.left);
        this.right = new JRadioButton(ResourceLoader.getResourceString((Object)this.rb, (String)"LegendsPage.Right.txt", (String)"Right"));
        this.right.setBounds(50, 125, 200, 25);
        legend.add(this.right);
        ButtonGroup bg = new ButtonGroup();
        bg.add(this.left);
        bg.add(this.right);
        bg.add(this.top);
        bg.add(this.bottom);
        this.left.addActionListener(this);
        this.right.addActionListener(this);
        this.top.addActionListener(this);
        this.bottom.addActionListener(this);
        LegendInterface li = this.getGraph().getLegend(null);
        if (li == null) {
            check.setEnabled(false);
            this.top.setEnabled(false);
            this.right.setEnabled(false);
            this.left.setEnabled(false);
            this.bottom.setEnabled(false);
        } else {
            Object o;
            if (li instanceof RenderInterface) {
                check.setSelected(((RenderInterface)li).isVisible());
            }
            if (!check.isSelected()) {
                this.top.setEnabled(false);
                this.right.setEnabled(false);
                this.bottom.setEnabled(false);
                this.left.setEnabled(false);
            }
            if ((o = this.getGraph().getLegendPosition(null)) instanceof String) {
                String s = o.toString();
                if (s.equalsIgnoreCase("North")) {
                    this.top.setSelected(true);
                } else if (s.equalsIgnoreCase("South")) {
                    this.bottom.setSelected(true);
                } else if (s.equalsIgnoreCase("East")) {
                    this.right.setSelected(true);
                } else {
                    this.left.setSelected(true);
                }
            } else if (o instanceof Number) {
                int i = ((Number)o).intValue();
                if (i == 3) {
                    this.right.setSelected(true);
                } else if (i == 4) {
                    this.left.setSelected(true);
                } else if (i == 1 || i == 6 || i == 7) {
                    this.top.setSelected(true);
                } else {
                    this.bottom.setSelected(true);
                }
            }
        }
        split.setLeftComponent(legend);
        split.setDividerLocation(250);
        split.setDividerSize(1);
        this.add("Center", split);
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        String command = ae.getActionCommand();
        GraphInterface graph = this.getGraph();
        Object source = ae.getSource();
        if (command.equalsIgnoreCase("X")) {
            AxisInterface ai = graph.getAxis((Object)"X");
            if (ai instanceof RenderInterface) {
                ((RenderInterface)ai).setVisible(((JCheckBox)source).isSelected());
            }
        } else if (command.equalsIgnoreCase("Y")) {
            AxisInterface ai = graph.getAxis((Object)"Y");
            if (ai instanceof RenderInterface) {
                ((RenderInterface)ai).setVisible(((JCheckBox)source).isSelected());
            }
        } else if (command.equalsIgnoreCase("Z")) {
            AxisInterface ai = graph.getAxis((Object)"Z");
            if (ai instanceof RenderInterface) {
                ((RenderInterface)ai).setVisible(((JCheckBox)source).isSelected());
            }
        } else if (command.equalsIgnoreCase("Legend")) {
            LegendInterface li = graph.getLegend(null);
            if (li instanceof RenderInterface) {
                ((RenderInterface)li).setVisible(((JCheckBox)source).isSelected());
            }
            boolean b = ((JCheckBox)source).isSelected();
            this.top.setEnabled(b);
            this.bottom.setEnabled(b);
            this.right.setEnabled(b);
            this.left.setEnabled(b);
        } else if (source == this.top) {
            graph.setLegendPosition(null, (Object)new Integer(1));
        } else if (source == this.bottom) {
            graph.setLegendPosition(null, (Object)new Integer(2));
        } else if (source == this.left) {
            graph.setLegendPosition(null, (Object)new Integer(4));
        } else if (source == this.right) {
            graph.setLegendPosition(null, (Object)new Integer(3));
        }
    }

    public String getTitle() {
        return ResourceLoader.getResourceString((Object)this.rb, (String)"LegendsPage.Chart_Legends.txt", (String)"Chart Legends");
    }

    public boolean hasNext() {
        return false;
    }
}

