/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.silk.ui.graphwizard;

import com.sas.graphics.silk.interfaces.ColorSchemeInterface;
import com.sas.graphics.silk.interfaces.ComponentInterface;
import com.sas.graphics.silk.ui.TabbedPropertiesDialog;
import com.sas.graphics.silk.ui.graphwizard.SILKWizardUtil;
import com.sas.graphics.silk.util.ColorScheme;
import com.sas.graphics.silk.util.ResourceLoader;
import com.sas.graphics.tools.wizard.WizardPage;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class ColorSchemePage
extends WizardPage
implements ListSelectionListener {
    private static final long serialVersionUID = -5971407179694107198L;
    JList list = null;
    SchemePreview preview = new SchemePreview();
    ResourceBundle rb = ResourceLoader.loadBundle((String)"com.sas.graphics.silk.ui.graphwizard.silk_graphwizard_NLS");

    public void display() {
        if (this.getGraph() != null && this.getGraph().getColorScheme() != null) {
            String name = this.getGraph().getColorScheme().getSchemeDisplayName();
            this.list.setSelectedValue(name, true);
        }
    }

    public void init() {
        this.removeAll();
        this.preview = new SchemePreview();
        this.setLayout(new BorderLayout());
        this.list = new JList();
        Properties props = ResourceLoader.loadProperties((String)"ColorSchemes.config");
        String[] strs = ResourceLoader.getResourceList((Object)props, (String)"Number_Color_Schemes", (String)"ColorScheme");
        Vector<ColorScheme> v = new Vector<ColorScheme>();
        if (strs != null) {
            for (int i = 0; i < strs.length; ++i) {
                ColorScheme cs = new ColorScheme(strs[i]);
                if (cs == null) continue;
                v.addElement(cs);
            }
        }
        this.list.setListData(v);
        JScrollPane p = new JScrollPane(this.list);
        p.setPreferredSize(new Dimension(100, 250));
        this.list.addListSelectionListener(this);
        this.list.setSelectedValue(this.preview.scheme.getSchemeName(), true);
        this.add("West", p);
        this.add("Center", this.preview);
        this.invalidate();
    }

    public ComponentInterface getGraph() {
        JComponent graph = SILKWizardUtil.getInternalGraph(this.wizard);
        if (graph instanceof ComponentInterface) {
            return (ComponentInterface)graph;
        }
        return null;
    }

    @Override
    public void valueChanged(ListSelectionEvent evt) {
        ComponentInterface graph = this.getGraph();
        if (graph == null) {
            return;
        }
        graph.setColorScheme(this.list.getSelectedValue());
        this.preview.scheme = graph.getColorScheme();
        this.repaint();
    }

    public String getTitle() {
        return ResourceLoader.getResourceString((Object)this.rb, (String)"ColorSchemePage.Pick_a_Color_Scheme.txt", (String)"Pick a Color Scheme");
    }

    public boolean canProceed() {
        return this.wizard.getCurrentEntry().getNextPage(this.getID()) != null;
    }

    public boolean hasNext() {
        return this.canProceed();
    }

    class SchemePreview
    extends JPanel {
        private static final long serialVersionUID = -821967428504401875L;
        ColorSchemeInterface scheme = new ColorScheme("Default");

        SchemePreview() {
        }

        public Color getColor(int color) {
            if (this.scheme == null) {
                return Color.white;
            }
            return this.scheme.getColorSchemeItemColor(color);
        }

        @Override
        public void paint(Graphics g) {
            Rectangle bounds = this.getBounds();
            if (this.scheme == null) {
                g.setColor(Color.white);
                g.fillRect(10, 0, bounds.width, bounds.height);
                return;
            }
            g.setColor(this.getColor(1));
            g.fillRect(10, 0, bounds.width, bounds.height);
            g.setColor(this.getColor(13));
            g.setFont(TabbedPropertiesDialog.dialogFont);
            g.drawString(ResourceLoader.getResourceString((Object)ColorSchemePage.this.rb, (String)"ColorSchemePage.Titles_Footnotes.txt", (String)"Titles / Footnotes"), 30, 30);
            g.setColor(this.getColor(11));
            g.setFont(TabbedPropertiesDialog.dialogFont);
            g.drawString(ResourceLoader.getResourceString((Object)ColorSchemePage.this.rb, (String)"ColorSchemePage.Labels.txt", (String)"Labels"), 30, 55);
            g.setColor(this.getColor(12));
            g.setFont(TabbedPropertiesDialog.dialogFont);
            g.drawString(ResourceLoader.getResourceString((Object)ColorSchemePage.this.rb, (String)"ColorSchemePage.Values.txt", (String)"Values"), 30, 80);
            g.setColor(this.getColor(15));
            g.fillRect(30, 110, bounds.width - 60, 90);
            g.setColor(this.getColor(6));
            g.drawRect(30, 110, bounds.width - 60, 90);
            int x = 40;
            int y = 120;
            Color[] clrs = this.scheme.getDataColors(false);
            int width = (bounds.width - 80) / clrs.length;
            int height = 30;
            for (int i = 0; i < clrs.length; ++i) {
                g.setColor(clrs[i]);
                g.fillRect(x, y, width, height);
                x += width;
            }
            Color[] rmp = this.scheme.getRampColors(false);
            ((Graphics2D)g).setPaint(new GradientPaint(40.0f, 160.0f, rmp[0], bounds.width - 80, 30.0f, rmp[1]));
            g.fillRect(40, 160, bounds.width - 80, 30);
        }
    }
}

