/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.silk.ui.desktop;

import com.sas.graphics.silk.interfaces.BaseComponentInterface;
import com.sas.graphics.silk.interfaces.SourceInterface;
import com.sas.graphics.silk.ui.desktop.MDIDesktopManager;
import com.sas.graphics.silk.ui.desktop.SILKInternalFrame;
import com.sas.graphics.silk.ui.desktop.WindowMenu;
import com.sas.graphics.silk.xml.parsers.ParserUtils;
import java.awt.Component;
import java.awt.Dimension;
import java.beans.PropertyVetoException;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JDesktopPane;
import javax.swing.JInternalFrame;
import javax.swing.JLayeredPane;
import javax.swing.JMenu;
import javax.swing.event.InternalFrameAdapter;
import javax.swing.event.InternalFrameEvent;

public class SILKDesktopPane
extends JDesktopPane
implements SourceInterface {
    private static final long serialVersionUID = -1708072829011749955L;
    private static int FRAME_OFFSET = 20;
    private MDIDesktopManager manager = new MDIDesktopManager(this);

    public SILKDesktopPane() {
        this.setDesktopManager(this.manager);
        this.setDragMode(1);
    }

    @Override
    public void setBounds(int x, int y, int w, int h) {
        super.setBounds(x, y, w, h);
        this.checkDesktopSize();
    }

    public Component add(JInternalFrame frame) {
        Component retval = super.add(frame);
        this.checkDesktopSize();
        frame.addInternalFrameListener(new InternalFrameAdapter(){

            @Override
            public void internalFrameClosing(InternalFrameEvent e) {
                JComponent c;
                super.internalFrameClosing(e);
                if (e.getInternalFrame() instanceof SILKInternalFrame && (c = ((SILKInternalFrame)e.getInternalFrame()).getChart()) instanceof BaseComponentInterface) {
                    ((BaseComponentInterface)c).dispose();
                }
            }
        });
        this.moveToFront(frame);
        frame.setVisible(true);
        try {
            frame.setSelected(true);
        }
        catch (PropertyVetoException e) {
            frame.toBack();
        }
        return retval;
    }

    @Override
    public void remove(Component c) {
        super.remove(c);
        this.checkDesktopSize();
    }

    public void cascadeFrames() {
        int x = 0;
        int y = 0;
        JInternalFrame[] allFrames = this.getAllFrames();
        this.manager.setNormalSize();
        int frameHeight = this.getBounds().height - 5 - allFrames.length * FRAME_OFFSET;
        int frameWidth = this.getBounds().width - 5 - allFrames.length * FRAME_OFFSET;
        for (int i = allFrames.length - 1; i >= 0; --i) {
            if (allFrames[i].getLayer() != JLayeredPane.DEFAULT_LAYER.intValue()) continue;
            allFrames[i].setSize(frameWidth, frameHeight);
            allFrames[i].setLocation(x, y);
            x += FRAME_OFFSET;
            y += FRAME_OFFSET;
        }
    }

    public void dispose() {
        JInternalFrame[] allFrames = this.getAllFrames();
        for (int i = allFrames.length - 1; i >= 0; --i) {
            if (!(allFrames[i] instanceof SILKInternalFrame)) continue;
            ((SILKInternalFrame)allFrames[i]).dispose();
        }
    }

    public void tileFrames() {
        JInternalFrame[] allFrames = this.getAllFrames();
        this.manager.setNormalSize();
        int numX = (int)Math.ceil(Math.sqrt(allFrames.length));
        int numY = (int)Math.ceil((double)allFrames.length / (double)numX);
        int frameHeight = this.getBounds().height / numY;
        int frameWidth = this.getBounds().width / numX;
        int y = 0;
        int x = 0;
        int counter = 1;
        for (int i = 0; i < allFrames.length; ++i) {
            if (allFrames[i].getLayer() != JLayeredPane.DEFAULT_LAYER.intValue()) continue;
            allFrames[i].setSize(frameWidth, frameHeight);
            allFrames[i].setLocation(x, y);
            x += frameWidth;
            if (counter >= numX) {
                x = 0;
                y += frameHeight;
                counter = 0;
            }
            ++counter;
        }
    }

    public void tileFramesVerticaly() {
        JInternalFrame[] allFrames = this.getAllFrames();
        this.manager.setNormalSize();
        int numY = allFrames.length;
        int frameHeight = this.getBounds().height / numY;
        int frameWidth = this.getBounds().width;
        int y = 0;
        int x = 0;
        for (int i = 0; i < allFrames.length; ++i) {
            if (allFrames[i].getLayer() != JLayeredPane.DEFAULT_LAYER.intValue()) continue;
            allFrames[i].setSize(frameWidth, frameHeight);
            allFrames[i].setLocation(x, y);
            y += frameHeight;
        }
    }

    public void tileFramesHorizontaly() {
        JInternalFrame[] allFrames = this.getAllFrames();
        this.manager.setNormalSize();
        int numX = allFrames.length;
        int frameHeight = this.getBounds().height;
        int frameWidth = this.getBounds().width / numX;
        int y = 0;
        int x = 0;
        for (int i = 0; i < allFrames.length; ++i) {
            if (allFrames[i].getLayer() != JLayeredPane.DEFAULT_LAYER.intValue()) continue;
            allFrames[i].setSize(frameWidth, frameHeight);
            allFrames[i].setLocation(x, y);
            x += frameWidth;
        }
    }

    public void closeAllFrames() {
        JInternalFrame[] frames = this.getAllFrames();
        for (int i = 0; i < frames.length; ++i) {
            this.manager.closeFrame(frames[i]);
        }
    }

    public void setAllSize(Dimension d) {
        this.setMinimumSize(d);
        this.setMaximumSize(d);
        this.setPreferredSize(d);
    }

    public void setAllSize(int width, int height) {
        this.setAllSize(new Dimension(width, height));
    }

    private void checkDesktopSize() {
        if (this.getParent() != null && this.isVisible()) {
            this.manager.resizeDesktop();
        }
    }

    public Object[] getDataIds() {
        JInternalFrame[] frames = this.getAllFrames();
        Object[] rc = null;
        Vector<Object> v = new Vector<Object>();
        for (int i = 0; i < frames.length; ++i) {
            JComponent component;
            if (!(frames[i] instanceof SILKInternalFrame) || !((component = ((SILKInternalFrame)frames[i]).getChart()) instanceof SourceInterface)) continue;
            Object[] ids = ((SourceInterface)component).getDataIds();
            if (ids != null) {
                for (int j = 0; j < ids.length; ++j) {
                    v.addElement(ids[j]);
                }
                continue;
            }
            Object source = ((SourceInterface)component).getDataSource();
            if (source == null || v.contains(ParserUtils.getNameForDataObject((Object)source, null))) continue;
            v.addElement(ParserUtils.getNameForDataObject((Object)source, null));
        }
        rc = new Object[v.size()];
        v.copyInto(rc);
        return rc;
    }

    public Object getDataSource() {
        return null;
    }

    public Object getDataSource(Object id) {
        JInternalFrame[] frames = this.getAllFrames();
        Object rc = null;
        for (int i = 0; i < frames.length; ++i) {
            JComponent component;
            if (!(frames[i] instanceof SILKInternalFrame) || !((component = ((SILKInternalFrame)frames[i]).getChart()) instanceof SourceInterface)) continue;
            Object[] ids = ((SourceInterface)component).getDataIds();
            if (ids != null) {
                for (int j = 0; j < ids.length; ++j) {
                    if (!id.equals(ids[j])) continue;
                    rc = ((SourceInterface)component).getDataSource(ids[j]);
                }
                continue;
            }
            Object source = ((SourceInterface)component).getDataSource();
            if (source == null) continue;
            rc = source;
        }
        return rc;
    }

    public boolean setDataSource(Object source, Object id) {
        return false;
    }

    public boolean setDataSource(Object source) {
        return false;
    }

    public JMenu getWindowMenu() {
        return new WindowMenu(this);
    }

    public SILKInternalFrame makeInternalFrame(String title) {
        SILKInternalFrame rc = new SILKInternalFrame(title, true, true, true, true);
        rc.setBounds(10, 10, 400, 300);
        return rc;
    }
}

