/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.silk.ui;

import com.sas.graphics.silk.interfaces.PropertyInterface;
import com.sas.graphics.silk.interfaces.SpectrumPlotPropertyInterface;
import com.sas.graphics.silk.ui.TabPanelInterface;
import com.sas.graphics.silk.ui.TabbedPropertiesDialog;
import com.sas.graphics.silk.util.ResourceLoader;
import com.sas.text.Message;
import java.awt.Color;
import java.awt.Component;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class SpectrumPlotPlotPanel
extends JPanel
implements TabPanelInterface,
SpectrumPlotPropertyInterface,
ChangeListener,
ItemListener {
    private static final long serialVersionUID = -547283045032609509L;
    private PropertyInterface chart;
    private static int BORDER = 8;
    private static int PANEL_WIDTH = 265;
    private static int PANEL_HEIGHT = 410;
    private static int ITEM_HEIGHT = 20;
    private JSlider width;
    private JSlider height;
    private JCheckBox equated;
    private JCheckBox outline;
    private JLabel widthValue;
    private JLabel heightValue;
    private static ResourceBundle rb = ResourceLoader.loadBundle((String)"com.sas.graphics.silk.spectrumplot.spectrumplot_NLS");

    public SpectrumPlotPlotPanel(PropertyInterface chart) {
        this.chart = chart;
        this.setLayout(null);
        this.setSize(PANEL_WIDTH, PANEL_HEIGHT);
        this.layoutPanel();
        this.updatePanelUI(this);
        this.setInitialValues();
        this.addListeners();
    }

    private void updatePanelUI(JComponent comp) {
        Border b = comp.getBorder();
        if (b != null && b instanceof TitledBorder) {
            ((TitledBorder)b).setTitleFont(TabbedPropertiesDialog.dialogFont);
            ((TitledBorder)b).setTitleColor(Color.black);
        } else if (b != null && b instanceof CompoundBorder) {
            ((TitledBorder)((CompoundBorder)b).getInsideBorder()).setTitleFont(TabbedPropertiesDialog.dialogFont);
            ((TitledBorder)((CompoundBorder)b).getInsideBorder()).setTitleColor(Color.black);
        }
        int count = comp.getComponentCount();
        for (int i = 0; i < count; ++i) {
            Component c = comp.getComponent(i);
            if (c instanceof JPanel) {
                this.updatePanelUI((JComponent)c);
                continue;
            }
            c.setForeground(Color.black);
            c.setFont(TabbedPropertiesDialog.dialogFont);
        }
    }

    private void layoutPanel() {
        this.setLayout(null);
        int h = ITEM_HEIGHT * 8 + BORDER;
        Insets margin = new Insets(BORDER, BORDER, PANEL_HEIGHT - h, BORDER);
        Border b1 = BorderFactory.createEmptyBorder(margin.top, margin.left, margin.bottom, margin.right);
        TitledBorder b2 = BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), ResourceLoader.getResourceString((Object)rb, (String)"SpectrumPlotPlotPanel.BlockPanel.txt", (String)"Blocks"));
        this.setBorder(BorderFactory.createCompoundBorder(b1, b2));
        JLabel equatedLabel = new JLabel(ResourceLoader.getResourceString((Object)rb, (String)"SpectrumPlotPlotPanel.Equated.txt", (String)"Equated"));
        this.equated = new JCheckBox();
        JLabel outlineLabel = new JLabel(ResourceLoader.getResourceString((Object)rb, (String)"SpectrumPlotPlotPanel.Outline.txt", (String)"Outline"));
        this.outline = new JCheckBox();
        JLabel widthLabel = new JLabel(ResourceLoader.getResourceString((Object)rb, (String)"SpectrumPlotPlotPanel.Width.txt", (String)"Width:"));
        JLabel heightLabel = new JLabel(ResourceLoader.getResourceString((Object)rb, (String)"SpectrumPlotPlotPanel.Height.txt", (String)"Height:"));
        this.widthValue = new JLabel();
        this.heightValue = new JLabel();
        this.width = new JSlider();
        this.width.setMinimum(1);
        this.width.setMaximum(100);
        this.height = new JSlider();
        this.height.setMinimum(1);
        this.height.setMaximum(100);
        int x = margin.left + BORDER * 2;
        int y = margin.top + ITEM_HEIGHT;
        int labelWidth = 50;
        int valueWidth = 50;
        int w = PANEL_WIDTH - margin.left - margin.right - BORDER * 2;
        this.equated.setBounds(x, y, labelWidth, ITEM_HEIGHT);
        equatedLabel.setBounds(x += labelWidth, y, w - labelWidth, ITEM_HEIGHT);
        x = margin.left + BORDER * 2;
        this.outline.setBounds(x, y += ITEM_HEIGHT + ITEM_HEIGHT, labelWidth, ITEM_HEIGHT);
        outlineLabel.setBounds(x += labelWidth, y, w - labelWidth, ITEM_HEIGHT);
        x = margin.left + BORDER * 2;
        widthLabel.setBounds(x, y += ITEM_HEIGHT + ITEM_HEIGHT, labelWidth, ITEM_HEIGHT);
        this.widthValue.setBounds(x += labelWidth, y, valueWidth, ITEM_HEIGHT);
        this.width.setBounds(x += valueWidth, y, w - labelWidth - valueWidth, ITEM_HEIGHT);
        x = margin.left + BORDER * 2;
        heightLabel.setBounds(x, y += ITEM_HEIGHT + ITEM_HEIGHT, labelWidth, ITEM_HEIGHT);
        this.heightValue.setBounds(x += labelWidth, y, valueWidth, ITEM_HEIGHT);
        this.height.setBounds(x += valueWidth, y, w - labelWidth - valueWidth, ITEM_HEIGHT);
        this.add(equatedLabel);
        this.add(this.equated);
        this.add(outlineLabel);
        this.add(this.outline);
        this.add(widthLabel);
        this.add(this.widthValue);
        this.add(this.width);
        this.add(heightLabel);
        this.add(this.heightValue);
        this.add(this.height);
    }

    private void addListeners() {
        this.width.addChangeListener(this);
        this.height.addChangeListener(this);
        this.equated.addItemListener(this);
        this.outline.addItemListener(this);
    }

    private void setInitialValues() {
        int w = (int)((Double)this.chart.getPropertyValue(809) * 100.0);
        int h = (int)((Double)this.chart.getPropertyValue(810) * 100.0);
        this.width.setValue(w);
        this.widthValue.setText(this.getValueLable(w));
        this.height.setValue(h);
        this.heightValue.setText(this.getValueLable(h));
        boolean eq = (Boolean)this.chart.getPropertyValue(811);
        this.equated.setSelected(eq);
        if (eq) {
            this.height.setEnabled(false);
        } else {
            this.height.setEnabled(true);
        }
        boolean on = (Boolean)this.chart.getPropertyValue(802);
        this.outline.setSelected(on);
    }

    private String getValueLable(int i) {
        Message message = new Message(ResourceLoader.getResourceString((Object)rb, (String)"SpectrumPlotPlotPanel.ValueLabel.fmt.txt", (String)"({0}%)"));
        String lab = Integer.toString(i);
        return message.toString((Object)lab);
    }

    public boolean cancelChanges() {
        this.chart.cancelPropertyChanges();
        return true;
    }

    public boolean applyChanges() {
        this.chart.applyPropertyChanges();
        return true;
    }

    @Override
    public void stateChanged(ChangeEvent evt) {
        Object source = evt.getSource();
        if (source == this.width) {
            int w = this.width.getValue();
            this.widthValue.setText(this.getValueLable(w));
            this.chart.setPropertyValue(809, (Object)new Double((double)w / 100.0));
            if (this.equated.isSelected()) {
                this.heightValue.setText(this.getValueLable(w));
            }
        } else if (source == this.height) {
            int h = this.height.getValue();
            this.heightValue.setText(this.getValueLable(h));
            this.chart.setPropertyValue(810, (Object)new Double((double)h / 100.0));
        }
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        boolean sel;
        Object source = e.getSource();
        boolean bl = sel = e.getStateChange() == 1;
        if (source == this.equated) {
            this.chart.setPropertyValue(811, (Object)new Boolean(sel));
            if (sel) {
                this.height.setEnabled(false);
            } else {
                this.height.setEnabled(true);
                int w = (int)((Double)this.chart.getPropertyValue(809) * 100.0);
                this.height.setValue(w);
            }
        } else if (source == this.outline) {
            this.chart.setPropertyValue(802, (Object)new Boolean(sel));
        }
    }

    public boolean addPropertyListener(PropertyInterface prop) {
        return false;
    }

    public boolean removePropertyListener(PropertyInterface prop) {
        return false;
    }
}

