/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.silk.ui;

import com.sas.graphics.silk.ConstComponent;
import com.sas.graphics.silk.interfaces.PropertyInterface;
import com.sas.graphics.silk.ui.BaseNodesPanel;
import com.sas.graphics.silk.ui.TabPanelInterface;
import com.sas.graphics.silk.ui.TabbedPropertiesDialog;
import com.sas.graphics.silk.util.ResourceLoader;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.text.MessageFormat;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSlider;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class NodesPanel
extends BaseNodesPanel
implements ActionListener,
ItemListener,
ChangeListener,
TabPanelInterface {
    private static final long serialVersionUID = -5833892604769655337L;
    private static final int SPRING_IDX = 1;
    private static final int GRIP_IDX = 0;
    private static final int TREE_IDX = 2;
    private static final int HYBRID_IDX = 3;
    JCheckBox NodeLabelCheckBox = new JCheckBox();
    JPanel NodeSizePanel = new JPanel();
    JRadioButton NodeSizeFixedButton = new JRadioButton();
    JRadioButton NodeSizeMappedButton = new JRadioButton();
    JSlider NodeSizeSlider = new JSlider();
    JLabel NodeSizeLabel = new JLabel();
    JComboBox NodeShapeCombo = new JComboBox();
    JPanel NodeShapePanel = new JPanel();
    JRadioButton NodeShapeFixedButton = new JRadioButton();
    JRadioButton NodeShapeMappedButton = new JRadioButton();
    JRadioButton NodeLayoutUserButton = new JRadioButton();
    JRadioButton NodeLayoutAutoButton = new JRadioButton();
    JComboBox NodeAutoLayoutCombo = new JComboBox();
    private EtchedBorder etchedBorder = new EtchedBorder();
    private TitledBorder NodeSizeBorder = new TitledBorder(this.etchedBorder);
    private TitledBorder NodeShapeBorder = new TitledBorder(this.etchedBorder);
    private TitledBorder NodeLayoutBorder = new TitledBorder(this.etchedBorder);
    private Object[] sliderArgs;
    private String nodeSizeFormat = null;
    private ButtonGroup sizeButtonGroup = null;
    private ButtonGroup shapeButtonGroup = null;
    private ButtonGroup layoutButtonGroup = null;
    private String[] shapes = new String[]{"Diamond", "Circle", "Triangle", "Square", "None"};
    private String[] NLSShapes = new String[this.shapes.length];
    private String[] layouts = new String[]{"GRIP", "Spring", "Hierarchy", "Hybrid"};
    private String[] NLSLayouts = new String[this.layouts.length];
    private String userNodeSizeDesc = "(in pixel)";
    private String mapped = "Mapped from Data Values";
    private final int NONE_SHAPE_INDEX = 4;
    private boolean nodeSizePanelEnabled = true;
    private boolean firstNodeSizeValQuery = true;

    public NodesPanel(PropertyInterface propInterface, JComponent component) {
        super(propInterface, component);
        int i;
        this.resourceBundle = ResourceLoader.loadBundle((String)"com.sas.graphics.silk.constchart.NodesPanel");
        this.setLayout(null);
        this.setSize(265, 410);
        this.NodeLabelCheckBox.setText("Show Node Labels");
        this.NodeLabelCheckBox.setActionCommand("show node labels");
        this.add(this.NodeLabelCheckBox);
        this.NodeLabelCheckBox.setFont(TabbedPropertiesDialog.dialogFont);
        this.NodeLabelCheckBox.setBounds(16, 332, 232, 24);
        this.NodeSizePanel.setLayout(null);
        this.add(this.NodeSizePanel);
        this.NodeSizePanel.setBounds(12, 90, 270, 96);
        this.NodeSizeFixedButton.setText("Fixed:");
        this.NodeSizeFixedButton.setActionCommand("SizeFixed");
        this.NodeSizePanel.add(this.NodeSizeFixedButton);
        this.NodeSizeFixedButton.setFont(TabbedPropertiesDialog.dialogFont);
        this.NodeSizeFixedButton.setBounds(4, 24, 100, 24);
        this.NodeSizeMappedButton.setText("Mapped from Data Values");
        this.NodeSizeMappedButton.setActionCommand("SizeMapped");
        this.NodeSizePanel.add(this.NodeSizeMappedButton);
        this.NodeSizeMappedButton.setFont(TabbedPropertiesDialog.dialogFont);
        this.NodeSizeMappedButton.setBounds(4, 60, 232, 24);
        this.NodeSizeSlider.setBounds(120, 24, 140, 24);
        this.NodeSizePanel.add(this.NodeSizeSlider);
        this.NodeSizePanel.add(this.NodeSizeLabel);
        this.NodeSizeLabel.setBounds(120, 40, 140, 24);
        this.propertyInterface.setPropertyValue(810, (Object)new Integer(1));
        this.propertyInterface.setPropertyValue(811, (Object)new Integer(100));
        int initMin = (int)this.getNumericProperty(810, 1.0);
        this.NodeShapePanel.setLayout(null);
        this.add(this.NodeShapePanel);
        this.NodeShapePanel.setBounds(12, 200, 270, 96);
        this.NodeShapeFixedButton.setText("Fixed:");
        this.NodeShapeFixedButton.setActionCommand("ShapeFixed");
        this.NodeShapePanel.add(this.NodeShapeFixedButton);
        this.NodeShapeFixedButton.setFont(TabbedPropertiesDialog.dialogFont);
        this.NodeShapeFixedButton.setBounds(4, 24, 100, 24);
        this.NodeShapeMappedButton.setText("Mapped from Data Values");
        this.NodeShapeMappedButton.setActionCommand("ShapeMapped");
        this.NodeShapePanel.add(this.NodeShapeMappedButton);
        this.NodeShapeMappedButton.setFont(TabbedPropertiesDialog.dialogFont);
        this.NodeShapeMappedButton.setBounds(4, 60, 232, 24);
        this.NodeShapePanel.add(this.NodeShapeCombo);
        this.NodeShapeCombo.setBackground(Color.white);
        this.NodeShapeCombo.setFont(TabbedPropertiesDialog.dialogFont);
        this.NodeShapeCombo.setBounds(120, 24, 140, 24);
        this.NodeLayoutUserButton.setText("User Layout");
        this.NodeLayoutUserButton.setActionCommand("LayoutUser");
        this.add(this.NodeLayoutUserButton);
        this.NodeLayoutUserButton.setFont(TabbedPropertiesDialog.dialogFont);
        this.NodeLayoutUserButton.setBounds(12, 48, 100, 24);
        this.NodeLayoutAutoButton.setText("Auto Layouts: ");
        this.NodeLayoutAutoButton.setActionCommand("LayoutAuto");
        this.add(this.NodeLayoutAutoButton);
        this.NodeLayoutAutoButton.setFont(TabbedPropertiesDialog.dialogFont);
        this.NodeLayoutAutoButton.setBounds(12, 12, 120, 24);
        this.add(this.NodeAutoLayoutCombo);
        this.NodeAutoLayoutCombo.setBackground(Color.white);
        this.NodeAutoLayoutCombo.setFont(TabbedPropertiesDialog.dialogFont);
        this.NodeAutoLayoutCombo.setBounds(140, 12, 140, 24);
        this.NodeColorMappedButton.setBounds(16, 300, 240, 24);
        this.NodeSizePanel.setBorder(this.NodeSizeBorder);
        this.NodeShapePanel.setBorder(this.NodeShapeBorder);
        this.NodeSizeBorder.setTitleColor(Color.black);
        this.NodeShapeBorder.setTitleColor(Color.black);
        this.NodeLayoutBorder.setTitleColor(Color.black);
        this.NodeSizeBorder.setTitleFont(TabbedPropertiesDialog.dialogFont);
        this.NodeShapeBorder.setTitleFont(TabbedPropertiesDialog.dialogFont);
        this.NodeLayoutBorder.setTitleFont(TabbedPropertiesDialog.dialogFont);
        String fixed = ResourceLoader.getResourceString((Object)this.resourceBundle, (String)"NodesPanel.Fixed.txt", (String)"Fixed:");
        this.mapped = ResourceLoader.getResourceString((Object)this.resourceBundle, (String)"NodesPanel.Mapped.txt", (String)"Mapped from Data Values");
        this.userNodeSizeDesc = ResourceLoader.getResourceString((Object)this.resourceBundle, (String)"NodesPanel.UserSize.Descrip.txt", (String)"(in pixel)");
        String mappedColor = ResourceLoader.getResourceString((Object)this.resourceBundle, (String)"NodesPanel.ColorMapped.txt", (String)"Map Color from Data Values");
        String layoutTitle = ResourceLoader.getResourceString((Object)this.resourceBundle, (String)"NodesPanel.layout.txt", (String)"Layout");
        String grip = ResourceLoader.getResourceString((Object)this.resourceBundle, (String)"NodesPanel.layoutCombo.Grip.txt", (String)"Multilevel Force");
        String spring = ResourceLoader.getResourceString((Object)this.resourceBundle, (String)"NodesPanel.layoutCombo.Spring.txt", (String)"Spring Force");
        String tree = ResourceLoader.getResourceString((Object)this.resourceBundle, (String)"NodesPanel.layoutCombo.Tree.txt", (String)"Hierarchy");
        String hybrid = ResourceLoader.getResourceString((Object)this.resourceBundle, (String)"NodesPanel.layoutCombo.Hybrid.txt", (String)"Hybrid");
        String autoTitle = ResourceLoader.getResourceString((Object)this.resourceBundle, (String)"NodesPanel.LayoutSepLabel.txt", (String)"Auto Layouts:");
        String user = ResourceLoader.getResourceString((Object)this.resourceBundle, (String)"NodesPanel.User.txt", (String)"User Layout");
        String sizeTitle = ResourceLoader.getResourceString((Object)this.resourceBundle, (String)"NodesPanel.Size.txt", (String)"Size");
        String shapeTitle = ResourceLoader.getResourceString((Object)this.resourceBundle, (String)"NodesPanel.Shape.txt", (String)"Shape");
        String nodeLabels = ResourceLoader.getResourceString((Object)this.resourceBundle, (String)"NodesPanel.Labels.txt", (String)"Show Node Labels");
        this.nodeSizeFormat = ResourceLoader.getResourceString((Object)this.resourceBundle, (String)"NodesPanel.Node_Size_Slider_Text.fmt.txt", (String)"Size: {0,number,integer}");
        this.NodeLabelCheckBox.setText(nodeLabels);
        this.NodeSizeSlider.setMinimum(1);
        this.NodeSizeSlider.setMaximum(100);
        this.sliderArgs = new Object[1];
        this.sliderArgs[0] = new Integer(initMin);
        this.NodeSizeLabel.setForeground(Color.black);
        this.NodeSizeLabel.setFont(TabbedPropertiesDialog.dialogFont);
        this.NodeSizeLabel.setText(MessageFormat.format(this.nodeSizeFormat, this.sliderArgs));
        this.NodeSizeBorder.setTitle(sizeTitle);
        this.NodeShapeBorder.setTitle(shapeTitle);
        this.NodeLayoutBorder.setTitle(layoutTitle);
        this.NodeColorMappedButton.setText(mappedColor);
        this.NodeSizeFixedButton.setText(fixed);
        this.NodeSizeMappedButton.setText(this.mapped);
        this.NodeShapeFixedButton.setText(fixed);
        this.NodeShapeMappedButton.setText(this.mapped);
        this.NodeLayoutUserButton.setText(user);
        this.NodeLayoutAutoButton.setText(autoTitle);
        this.NLSLayouts[1] = spring;
        this.NLSLayouts[2] = tree;
        this.NLSLayouts[3] = hybrid;
        this.NLSLayouts[0] = grip;
        this.NodeAutoLayoutCombo.removeAllItems();
        for (i = 0; i < this.NLSLayouts.length; ++i) {
            this.NodeAutoLayoutCombo.addItem(this.NLSLayouts[i]);
        }
        this.NLSShapes[0] = ResourceLoader.getResourceString((Object)this.resourceBundle, (String)"NodesPanel.ShapeCombo.Diamond.txt", (String)"Diamond");
        this.NLSShapes[1] = ResourceLoader.getResourceString((Object)this.resourceBundle, (String)"NodesPanel.ShapeCombo.Circle.txt", (String)"Circle");
        this.NLSShapes[2] = ResourceLoader.getResourceString((Object)this.resourceBundle, (String)"NodesPanel.ShapeCombo.Triangle.txt", (String)"Triangle");
        this.NLSShapes[3] = ResourceLoader.getResourceString((Object)this.resourceBundle, (String)"NodesPanel.ShapeCombo.Square.txt", (String)"Square");
        this.NLSShapes[4] = ResourceLoader.getResourceString((Object)this.resourceBundle, (String)"NodesPanel.ShapeCombo.None.txt", (String)"Only Labels");
        this.NodeShapeCombo.removeAllItems();
        for (i = 0; i < this.NLSShapes.length; ++i) {
            this.NodeShapeCombo.addItem(this.NLSShapes[i]);
        }
        this.sizeButtonGroup = new ButtonGroup();
        this.sizeButtonGroup.add(this.NodeSizeFixedButton);
        this.sizeButtonGroup.add(this.NodeSizeMappedButton);
        this.shapeButtonGroup = new ButtonGroup();
        this.shapeButtonGroup.add(this.NodeShapeFixedButton);
        this.shapeButtonGroup.add(this.NodeShapeMappedButton);
        this.layoutButtonGroup = new ButtonGroup();
        this.layoutButtonGroup.add(this.NodeLayoutUserButton);
        this.layoutButtonGroup.add(this.NodeLayoutAutoButton);
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        Object source = evt.getSource();
        if (source instanceof JRadioButton) {
            JRadioButton radio = (JRadioButton)source;
            if (radio == this.NodeSizeFixedButton) {
                this.NodeSizeSlider.setEnabled(true);
                this.NodeSizeLabel.setEnabled(true);
                this.propertyInterface.setPropertyValue(805, (Object)new Boolean(false));
                this.propertyInterface.setPropertyValue(801, (Object)new Double(this.NodeSizeSlider.getValue()));
                if (this.parent instanceof ConstComponent) {
                    ((ConstComponent)this.parent).setSizeMappingNodes(false);
                }
            } else if (radio == this.NodeSizeMappedButton) {
                this.NodeSizeSlider.setEnabled(false);
                this.NodeSizeLabel.setEnabled(false);
                this.propertyInterface.setPropertyValue(805, (Object)new Boolean(true));
                if (this.parent instanceof ConstComponent) {
                    ((ConstComponent)this.parent).setSizeMappingNodes(true);
                }
            } else if (radio == this.NodeShapeFixedButton) {
                this.NodeShapeCombo.setEnabled(true);
                int idx = this.NodeShapeCombo.getSelectedIndex();
                boolean enableSzePnl = true;
                if (idx == 4) {
                    enableSzePnl = false;
                }
                this.NodeSizeFixedButton.setEnabled(enableSzePnl);
                Object value = this.propertyInterface.getPropertyValue(808);
                boolean isSizeMappingAllowed = false;
                if (value != null && value instanceof Boolean) {
                    isSizeMappingAllowed = (Boolean)value;
                }
                this.NodeSizeMappedButton.setEnabled(isSizeMappingAllowed && enableSzePnl);
                if (this.NodeSizeFixedButton.isSelected()) {
                    this.NodeSizeSlider.setEnabled(enableSzePnl);
                    this.NodeSizeLabel.setEnabled(enableSzePnl);
                }
                this.nodeSizePanelEnabled = enableSzePnl;
                this.propertyInterface.setPropertyValue(806, (Object)new Boolean(false));
            } else if (radio == this.NodeShapeMappedButton) {
                this.NodeShapeCombo.setEnabled(false);
                this.NodeSizeFixedButton.setEnabled(true);
                Object value = this.propertyInterface.getPropertyValue(808);
                boolean isSizeMappingAllowed = false;
                if (value != null && value instanceof Boolean) {
                    isSizeMappingAllowed = (Boolean)value;
                }
                this.NodeSizeMappedButton.setEnabled(isSizeMappingAllowed);
                if (this.NodeSizeFixedButton.isSelected()) {
                    this.NodeSizeSlider.setEnabled(true);
                    this.NodeSizeLabel.setEnabled(true);
                }
                this.nodeSizePanelEnabled = true;
                this.propertyInterface.setPropertyValue(806, (Object)new Boolean(true));
            } else if (radio == this.NodeLayoutAutoButton) {
                this.NodeAutoLayoutCombo.setEnabled(true);
                int layOutType = this.findLayoutType(this.NodeAutoLayoutCombo.getSelectedIndex());
                this.propertyInterface.setPropertyValue(869, (Object)new Integer(layOutType));
                this.propertyInterface.setPropertyValue(870, (Object)new Boolean(false));
                this.NodeSizeMappedButton.setText(this.mapped);
            } else if (radio == this.NodeLayoutUserButton) {
                this.propertyInterface.setPropertyValue(870, (Object)new Boolean(true));
                this.NodeAutoLayoutCombo.setEnabled(false);
                this.NodeSizeMappedButton.setText(this.mapped + this.userNodeSizeDesc);
            }
        }
    }

    @Override
    public void itemStateChanged(ItemEvent evt) {
        JCheckBox check;
        super.itemStateChanged(evt);
        Object source = evt.getSource();
        if (source instanceof JComboBox) {
            JComboBox box = (JComboBox)source;
            int index = box.getSelectedIndex();
            if (box == this.NodeShapeCombo) {
                if (index >= 0) {
                    this.propertyInterface.setPropertyValue(802, (Object)this.shapes[index]);
                    this.nodeSizePanelEnabled = index != 4;
                    this.NodeSizeFixedButton.setEnabled(this.nodeSizePanelEnabled);
                    Object value = this.propertyInterface.getPropertyValue(808);
                    boolean isSizeMappingAllowed = false;
                    if (value != null && value instanceof Boolean) {
                        isSizeMappingAllowed = (Boolean)value;
                    }
                    this.NodeSizeMappedButton.setEnabled(isSizeMappingAllowed && this.nodeSizePanelEnabled);
                    this.shapeSelectionChanged(index);
                    if (this.NodeSizeFixedButton.isSelected()) {
                        this.NodeSizeSlider.setEnabled(this.nodeSizePanelEnabled);
                        this.NodeSizeLabel.setEnabled(this.nodeSizePanelEnabled);
                    }
                }
            } else if (box == this.NodeAutoLayoutCombo && index >= 0 && index <= 3) {
                int type = this.findLayoutType(index);
                this.propertyInterface.setPropertyValue(869, (Object)new Integer(type));
            }
        } else if (source instanceof JCheckBox && (check = (JCheckBox)source) == this.NodeLabelCheckBox) {
            this.propertyInterface.setPropertyValue(803, (Object)new Boolean(check.isSelected()));
            this.nodeLabelChanged(check.isSelected());
        }
    }

    @Override
    public void stateChanged(ChangeEvent evt) {
        super.stateChanged(evt);
        Object source = evt.getSource();
        if (source instanceof JSlider) {
            int silderValue = this.NodeSizeSlider.getValue();
            if (silderValue < 1) {
                silderValue = 1;
            }
            this.sliderArgs[0] = new Integer(silderValue);
            this.NodeSizeLabel.setText(MessageFormat.format(this.nodeSizeFormat, this.sliderArgs));
            if (!this.NodeSizeSlider.getValueIsAdjusting()) {
                this.propertyInterface.setPropertyValue(801, (Object)new Double(silderValue));
                this.propertyInterface.setPropertyValue(805, (Object)new Boolean(false));
            }
        }
    }

    public double getNodeSize() {
        return this.NodeSizeSlider.getValue();
    }

    private void nodeLabelChanged(boolean isSelected) {
        if (isSelected && this.NodeShapeCombo.getItemCount() <= 4) {
            this.NodeShapeCombo.addItem(this.NLSShapes[4]);
        } else if (!isSelected && this.NodeShapeCombo.getItemCount() > 4) {
            this.NodeShapeCombo.removeItemAt(4);
        }
    }

    private void shapeSelectionChanged(int shapeIndex) {
        if (shapeIndex == 4) {
            this.NodeLabelCheckBox.setEnabled(false);
        } else {
            this.NodeLabelCheckBox.setEnabled(true);
        }
    }

    @Override
    public void refreshComponents() {
        super.refreshComponents();
        this.NodeSizeFixedButton.removeActionListener(this);
        this.NodeSizeMappedButton.removeActionListener(this);
        this.NodeShapeFixedButton.removeActionListener(this);
        this.NodeShapeMappedButton.removeActionListener(this);
        this.NodeLayoutAutoButton.removeActionListener(this);
        this.NodeLayoutUserButton.removeActionListener(this);
        this.NodeShapeCombo.removeItemListener(this);
        this.NodeLabelCheckBox.removeItemListener(this);
        this.NodeAutoLayoutCombo.removeItemListener(this);
        this.NodeSizeSlider.removeChangeListener(this);
        if (this.firstNodeSizeValQuery) {
            this.NodeSizeSlider.setValue(0);
            this.firstNodeSizeValQuery = false;
        }
        Object value = this.propertyInterface.getPropertyValue(803);
        boolean showLabels = false;
        if (value != null && value instanceof Boolean) {
            showLabels = (Boolean)value;
        }
        value = this.propertyInterface.getPropertyValue(805);
        boolean sizeMapping = false;
        if (value != null && value instanceof Boolean) {
            sizeMapping = (Boolean)value;
        }
        value = this.propertyInterface.getPropertyValue(808);
        boolean isSizeMappingAllowed = false;
        if (value != null && value instanceof Boolean) {
            isSizeMappingAllowed = (Boolean)value;
        }
        if (isSizeMappingAllowed) {
            this.NodeSizeMappedButton.setEnabled(true);
            if (sizeMapping) {
                this.NodeSizeMappedButton.setSelected(true);
                this.NodeSizeSlider.setEnabled(false);
                this.NodeSizeLabel.setEnabled(false);
            } else {
                this.NodeSizeFixedButton.setSelected(true);
                this.NodeSizeFixedButton.setEnabled(true);
                this.NodeSizeSlider.setEnabled(true);
                this.NodeSizeLabel.setEnabled(true);
                this.updateNodeSize();
            }
        } else if (!this.nodeSizePanelEnabled) {
            this.NodeSizeFixedButton.setEnabled(false);
            this.NodeSizeMappedButton.setEnabled(false);
            this.NodeSizeSlider.setEnabled(false);
            this.NodeSizeLabel.setEnabled(false);
        } else {
            this.NodeSizeMappedButton.setEnabled(false);
            this.NodeSizeFixedButton.setSelected(true);
            this.NodeSizeFixedButton.setEnabled(true);
            this.NodeSizeSlider.setEnabled(true);
            this.NodeSizeLabel.setEnabled(true);
        }
        value = this.propertyInterface.getPropertyValue(806);
        boolean shapeMapping = false;
        if (value != null && value instanceof Boolean) {
            shapeMapping = (Boolean)value;
        }
        value = this.propertyInterface.getPropertyValue(809);
        boolean isShapeMappingAllowed = false;
        if (value != null && value instanceof Boolean) {
            isShapeMappingAllowed = (Boolean)value;
        }
        if (isShapeMappingAllowed) {
            this.NodeShapeMappedButton.setEnabled(true);
            if (shapeMapping) {
                this.NodeShapeMappedButton.setSelected(true);
                this.NodeShapeCombo.setEnabled(false);
            } else {
                this.NodeShapeFixedButton.setEnabled(true);
                this.NodeShapeFixedButton.setSelected(true);
                this.NodeShapeCombo.setEnabled(true);
            }
            this.NodeSizeFixedButton.setEnabled(shapeMapping);
            this.NodeSizeMappedButton.setEnabled(isSizeMappingAllowed && shapeMapping);
            if (this.NodeSizeFixedButton.isSelected()) {
                this.NodeSizeSlider.setEnabled(shapeMapping);
                this.NodeSizeLabel.setEnabled(shapeMapping);
            }
            this.nodeSizePanelEnabled = shapeMapping;
        } else {
            this.NodeShapeMappedButton.setEnabled(false);
            this.NodeShapeFixedButton.setEnabled(true);
            this.NodeShapeFixedButton.setSelected(true);
            this.NodeShapeCombo.setEnabled(true);
            this.NodeSizeFixedButton.setEnabled(false);
            this.NodeSizeMappedButton.setEnabled(false);
            if (this.NodeSizeFixedButton.isSelected()) {
                this.NodeSizeSlider.setEnabled(false);
                this.NodeSizeLabel.setEnabled(false);
            }
            this.nodeSizePanelEnabled = false;
        }
        String nodeShape = (String)this.propertyInterface.getPropertyValue(802);
        if (nodeShape != null) {
            this.NodeShapeCombo.removeItemListener(this);
            int index = this.findShape(nodeShape);
            this.nodeLabelChanged(showLabels);
            if (index >= 0) {
                if (index != 4) {
                    this.NodeSizeFixedButton.setEnabled(true);
                    this.NodeSizeMappedButton.setEnabled(isSizeMappingAllowed);
                    if (this.NodeSizeFixedButton.isSelected()) {
                        this.NodeSizeSlider.setEnabled(true);
                        this.NodeSizeLabel.setEnabled(true);
                    }
                    this.nodeSizePanelEnabled = true;
                } else {
                    this.NodeLabelCheckBox.setSelected(true);
                }
                this.shapeSelectionChanged(index);
                this.NodeShapeCombo.setSelectedIndex(index);
            }
            this.NodeShapeCombo.addItemListener(this);
        }
        this.NodeLabelCheckBox.setSelected(showLabels);
        this.NodeLayoutUserButton.setSelected(false);
        value = this.propertyInterface.getPropertyValue(869);
        int layoutStrategy = 3;
        if (value != null && value instanceof Integer) {
            layoutStrategy = (Integer)value;
        }
        if (layoutStrategy >= 0 && layoutStrategy <= 3) {
            int index = this.findLayoutIndex(layoutStrategy);
            this.NodeAutoLayoutCombo.setSelectedIndex(index);
        }
        Boolean isLayoutUserObj = (Boolean)this.propertyInterface.getPropertyValue(870);
        boolean isLayoutUser = false;
        if (isLayoutUserObj != null) {
            isLayoutUser = isLayoutUserObj;
        }
        value = this.propertyInterface.getPropertyValue(871);
        boolean allowUserLayout = true;
        if (value != null && value instanceof Boolean) {
            allowUserLayout = (Boolean)value;
        }
        this.NodeLayoutUserButton.setEnabled(allowUserLayout);
        if (isLayoutUser && allowUserLayout) {
            this.NodeLayoutUserButton.setSelected(true);
            this.NodeSizeMappedButton.setText(this.mapped + this.userNodeSizeDesc);
            this.NodeAutoLayoutCombo.setEnabled(false);
        } else {
            this.NodeLayoutAutoButton.setSelected(true);
            this.NodeSizeMappedButton.setText(this.mapped);
            this.NodeAutoLayoutCombo.setEnabled(true);
        }
        this.NodeSizeFixedButton.addActionListener(this);
        this.NodeSizeMappedButton.addActionListener(this);
        this.NodeShapeFixedButton.addActionListener(this);
        this.NodeShapeMappedButton.addActionListener(this);
        this.NodeLayoutAutoButton.addActionListener(this);
        this.NodeLayoutUserButton.addActionListener(this);
        this.NodeAutoLayoutCombo.addItemListener(this);
        this.NodeShapeCombo.addItemListener(this);
        this.NodeLabelCheckBox.addItemListener(this);
        this.NodeSizeSlider.addChangeListener(this);
    }

    private void updateNodeSize() {
        Object o = this.propertyInterface.getPropertyValue(801);
        double size = -1.0;
        boolean constantSize = false;
        constantSize = o == null ? true : o instanceof Number;
        if (constantSize && o != null) {
            size = ((Number)o).doubleValue();
        }
        if (!constantSize) {
            return;
        }
        if (size < 1.0) {
            size = 1.0;
        }
        this.NodeSizeSlider.setValue((int)size);
        this.sliderArgs[0] = new Integer((int)size);
        this.NodeSizeLabel.setText(MessageFormat.format(this.nodeSizeFormat, this.sliderArgs));
    }

    private int findShape(String shape) {
        for (int i = 0; i < this.shapes.length; ++i) {
            if (!this.shapes[i].equalsIgnoreCase(shape)) continue;
            return i;
        }
        return -1;
    }

    private int findLayoutIndex(int layoutType) {
        switch (layoutType) {
            case 0: {
                return 1;
            }
            default: {
                return 0;
            }
            case 1: {
                return 2;
            }
            case 2: 
        }
        return 3;
    }

    private int findLayoutType(int index) {
        switch (index) {
            case 1: {
                return 0;
            }
            default: {
                return 3;
            }
            case 2: {
                return 1;
            }
            case 3: 
        }
        return 2;
    }
}

