/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.silk.ui;

import com.sas.graphics.silk.interfaces.PropertyInterface;
import com.sas.graphics.silk.map.Categorization;
import com.sas.graphics.silk.ui.TabPanelInterface;
import com.sas.graphics.silk.ui.TabbedPropertiesDialog;
import com.sas.graphics.silk.ui.TextDialog;
import com.sas.graphics.silk.util.PropertyUtils;
import com.sas.graphics.silk.util.ResourceLoader;
import java.awt.Color;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class MapRegionPanel
extends JPanel
implements TabPanelInterface,
ActionListener,
ChangeListener {
    private static final long serialVersionUID = 2743744584579471761L;
    Vector maps = new Vector();
    PropertyInterface text;
    protected boolean update = true;
    TitledBorder outlineBorder = null;
    TitledBorder labelBorder = null;
    TitledBorder categorizationBorder = null;
    JPanel outlinePanel = null;
    JPanel labelPanel = null;
    JPanel categorizationPanel = null;
    JCheckBox showRegionOutlinesCheckbox = null;
    JCheckBox showLabelsCheckbox = null;
    JButton labelTextOptionsButton = null;
    JLabel regionOutlineColorLabel = null;
    JPanel regionOutlineColorPanel = null;
    JButton regionOutlineColorButton = null;
    JLabel regionOutlineThicknessLabel = null;
    JComboBox regionOutlineThicknessCombo = null;
    JLabel mapCategorizationLabel = null;
    JComboBox mapCategorizationCombo = null;
    JLabel mapCategorizationSizeLabel = null;
    JSpinner mapCategorizationSizeSpinner = null;
    JCheckBox mapCategorizationUseRampCheckbox = null;
    JCheckBox showShadowsCheckbox = null;
    JLabel defaultColorLabel = null;
    JPanel defaultColorPanel = null;
    JButton defaultColorButton = null;
    ResourceBundle rb = null;
    protected TextDialog textDialog;
    protected JColorChooser colorChooser;

    public MapRegionPanel(PropertyInterface map, PropertyInterface text) {
        this.maps.add(map);
        this.text = text;
        this.rb = ResourceLoader.loadBundle((String)"com.sas.graphics.silk.ui.silk_ui_NLS");
        this.textDialog = new TextDialog((Frame)null, null);
        this.initGUI();
        this.showRegionOutlinesCheckbox.addActionListener(this);
        this.regionOutlineThicknessCombo.addActionListener(this);
        this.regionOutlineColorButton.addActionListener(this);
        this.showLabelsCheckbox.addActionListener(this);
        this.labelTextOptionsButton.addActionListener(this);
        this.mapCategorizationCombo.addActionListener(this);
        this.mapCategorizationSizeSpinner.addChangeListener(this);
        this.mapCategorizationUseRampCheckbox.addActionListener(this);
        this.defaultColorButton.addActionListener(this);
        this.showShadowsCheckbox.addActionListener(this);
        this.initFromSource();
    }

    private void initGUI() {
        this.setLayout(null);
        this.outlineBorder = new TitledBorder(new EtchedBorder());
        this.outlineBorder.setTitleFont(TabbedPropertiesDialog.dialogFont);
        this.outlineBorder.setTitle(ResourceLoader.getResourceString((Object)this.rb, (String)"MapRegionPanel.Outlines.txt", (String)"Outlines"));
        this.outlineBorder.setTitleColor(Color.black);
        this.labelBorder = new TitledBorder(new EtchedBorder());
        this.labelBorder.setTitleFont(TabbedPropertiesDialog.dialogFont);
        this.labelBorder.setTitle(ResourceLoader.getResourceString((Object)this.rb, (String)"MapRegionPanel.Labels.txt", (String)"Labels"));
        this.labelBorder.setTitleColor(Color.black);
        this.categorizationBorder = new TitledBorder(new EtchedBorder());
        this.categorizationBorder.setTitleFont(TabbedPropertiesDialog.dialogFont);
        this.categorizationBorder.setTitle(ResourceLoader.getResourceString((Object)this.rb, (String)"MapRegionPanel.Categorization.txt", (String)"Categorization"));
        this.categorizationBorder.setTitleColor(Color.black);
        this.outlinePanel = new JPanel();
        this.outlinePanel.setLayout(null);
        this.labelPanel = new JPanel();
        this.labelPanel.setLayout(null);
        this.categorizationPanel = new JPanel();
        this.categorizationPanel.setLayout(null);
        this.outlinePanel.setBorder(this.outlineBorder);
        this.labelPanel.setBorder(this.labelBorder);
        this.categorizationPanel.setBorder(this.categorizationBorder);
        this.showRegionOutlinesCheckbox = new JCheckBox();
        this.showRegionOutlinesCheckbox.setFont(TabbedPropertiesDialog.dialogFont);
        this.showRegionOutlinesCheckbox.setText(ResourceLoader.getResourceString((Object)this.rb, (String)"MapRegionPanel.Show_outlines.txt", (String)"Show outlines"));
        this.regionOutlineThicknessLabel = new JLabel(ResourceLoader.getResourceString((Object)this.rb, (String)"MapRegionPanel.Thickness.txt", (String)"Thickness:"));
        this.regionOutlineThicknessLabel.setFont(TabbedPropertiesDialog.dialogFont);
        this.regionOutlineThicknessCombo = new JComboBox();
        this.regionOutlineThicknessCombo.setFont(TabbedPropertiesDialog.dialogFont);
        for (int i = 1; i <= 10; ++i) {
            this.regionOutlineThicknessCombo.addItem(i + " " + ResourceLoader.getResourceString((Object)this.rb, (String)"MapRegionPanel.pt.txt", (String)"pt"));
        }
        this.regionOutlineColorLabel = new JLabel(ResourceLoader.getResourceString((Object)this.rb, (String)"MapRegionPanel.Color.txt", (String)"Color:"));
        this.regionOutlineColorLabel.setFont(TabbedPropertiesDialog.dialogFont);
        this.regionOutlineColorPanel = new JPanel();
        this.regionOutlineColorPanel.setBackground(Color.black);
        this.regionOutlineColorButton = new JButton(ResourceLoader.getResourceString((Object)this.rb, (String)"MapRegionPanel.Etc.txt", (String)"..."));
        this.regionOutlineColorButton.setFont(TabbedPropertiesDialog.dialogFont);
        this.showLabelsCheckbox = new JCheckBox();
        this.showLabelsCheckbox.setFont(TabbedPropertiesDialog.dialogFont);
        this.showLabelsCheckbox.setText(ResourceLoader.getResourceString((Object)this.rb, (String)"MapRegionPanel.Show_labels.txt", (String)"Show labels"));
        this.labelTextOptionsButton = new JButton(ResourceLoader.getResourceString((Object)this.rb, (String)"MapRegionPanel.Label_options.txt", (String)"Label options..."));
        this.labelTextOptionsButton.setFont(TabbedPropertiesDialog.dialogFont);
        this.mapCategorizationLabel = new JLabel(ResourceLoader.getResourceString((Object)this.rb, (String)"MapRegionPanel.Type.txt", (String)"Type:"));
        this.mapCategorizationLabel.setFont(TabbedPropertiesDialog.dialogFont);
        this.mapCategorizationCombo = new JComboBox();
        this.mapCategorizationCombo.setFont(TabbedPropertiesDialog.dialogFont);
        this.mapCategorizationCombo.addItem(ResourceLoader.getResourceString((Object)this.rb, (String)"MapRegionPanel.Continuous.txt", (String)"Continuous"));
        this.mapCategorizationCombo.addItem(ResourceLoader.getResourceString((Object)this.rb, (String)"MapRegionPanel.Discrete.txt", (String)"Discrete"));
        this.mapCategorizationCombo.addItem(ResourceLoader.getResourceString((Object)this.rb, (String)"MapRegionPanel.Equal_Size.txt", (String)"Equal Size"));
        this.mapCategorizationCombo.addItem(ResourceLoader.getResourceString((Object)this.rb, (String)"MapRegionPanel.Equal_Width.txt", (String)"Equal Width"));
        this.mapCategorizationSizeLabel = new JLabel(ResourceLoader.getResourceString((Object)this.rb, (String)"MapRegionPanel.Size.txt", (String)"Size:"));
        this.mapCategorizationSizeLabel.setFont(TabbedPropertiesDialog.dialogFont);
        this.mapCategorizationSizeSpinner = new JSpinner();
        this.mapCategorizationSizeSpinner.setFont(TabbedPropertiesDialog.dialogFont);
        this.mapCategorizationUseRampCheckbox = new JCheckBox(ResourceLoader.getResourceString((Object)this.rb, (String)"MapRegionPanel.Use_color_ramp.txt", (String)"Use color ramp"));
        this.mapCategorizationUseRampCheckbox.setFont(TabbedPropertiesDialog.dialogFont);
        Integer value = new Integer(4);
        Integer min = new Integer(1);
        Integer max = new Integer(25);
        Integer step = new Integer(1);
        SpinnerNumberModel model = new SpinnerNumberModel(value, min, max, step);
        this.mapCategorizationSizeSpinner.setModel(model);
        this.defaultColorLabel = new JLabel(ResourceLoader.getResourceString((Object)this.rb, (String)"MapRegionPanel.Default_color.txt", (String)"Default color:"));
        this.defaultColorLabel.setFont(TabbedPropertiesDialog.dialogFont);
        this.defaultColorPanel = new JPanel();
        this.defaultColorPanel.setBackground(Color.gray);
        this.defaultColorButton = new JButton(ResourceLoader.getResourceString((Object)this.rb, (String)"MapRegionPanel.Etc.txt", (String)"..."));
        this.defaultColorButton.setFont(TabbedPropertiesDialog.dialogFont);
        this.showShadowsCheckbox = new JCheckBox(ResourceLoader.getResourceString((Object)this.rb, (String)"MapRegionPanel.Show_shadows.txt", (String)"Show shadows"));
        this.showShadowsCheckbox.setFont(TabbedPropertiesDialog.dialogFont);
        this.outlinePanel.add(this.showRegionOutlinesCheckbox);
        this.outlinePanel.add(this.regionOutlineColorLabel);
        this.outlinePanel.add(this.regionOutlineColorPanel);
        this.outlinePanel.add(this.regionOutlineColorButton);
        this.outlinePanel.add(this.regionOutlineThicknessLabel);
        this.outlinePanel.add(this.regionOutlineThicknessCombo);
        this.labelPanel.add(this.showLabelsCheckbox);
        this.labelPanel.add(this.labelTextOptionsButton);
        this.categorizationPanel.add(this.mapCategorizationLabel);
        this.categorizationPanel.add(this.mapCategorizationCombo);
        this.categorizationPanel.add(this.mapCategorizationSizeLabel);
        this.categorizationPanel.add(this.mapCategorizationSizeSpinner);
        this.categorizationPanel.add(this.mapCategorizationUseRampCheckbox);
        this.showRegionOutlinesCheckbox.setBounds(15, 20, 100, 18);
        this.regionOutlineColorLabel.setBounds(15, 45, 75, 18);
        this.regionOutlineColorPanel.setBounds(85, 45, 40, 20);
        this.regionOutlineColorButton.setBounds(130, 45, 20, 20);
        this.regionOutlineThicknessLabel.setBounds(15, 75, 75, 18);
        this.regionOutlineThicknessCombo.setBounds(85, 75, 50, 20);
        this.showLabelsCheckbox.setBounds(15, 20, 100, 18);
        this.labelTextOptionsButton.setBounds(15, 45, 140, 18);
        this.mapCategorizationLabel.setBounds(15, 20, 90, 18);
        this.mapCategorizationCombo.setBounds(110, 20, 120, 20);
        this.mapCategorizationSizeLabel.setBounds(15, 47, 60, 18);
        this.mapCategorizationSizeSpinner.setBounds(110, 48, 60, 22);
        this.mapCategorizationUseRampCheckbox.setBounds(12, 75, 120, 22);
        this.outlinePanel.setBounds(0, 10, 277, 110);
        this.labelPanel.setBounds(0, 125, 277, 80);
        this.categorizationPanel.setBounds(0, 220, 277, 110);
        this.defaultColorLabel.setBounds(10, 350, 75, 18);
        this.defaultColorPanel.setBounds(80, 350, 40, 20);
        this.defaultColorButton.setBounds(125, 350, 20, 20);
        this.showShadowsCheckbox.setBounds(10, 380, 160, 18);
        this.add(this.outlinePanel);
        this.add(this.labelPanel);
        this.add(this.categorizationPanel);
        this.add(this.defaultColorLabel);
        this.add(this.defaultColorPanel);
        this.add(this.defaultColorButton);
        this.add(this.showShadowsCheckbox);
    }

    public boolean applyChanges() {
        return false;
    }

    public boolean cancelChanges() {
        return false;
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        if (!this.update) {
            return;
        }
        Object source = ae.getSource();
        Color color = null;
        if (source == this.showRegionOutlinesCheckbox) {
            PropertyUtils.setPropertyValue((Vector)this.maps, (int)7001, (Object)new Boolean(this.showRegionOutlinesCheckbox.isSelected()));
        } else if (source == this.regionOutlineThicknessCombo) {
            PropertyUtils.setPropertyValue((Vector)this.maps, (int)7003, (Object)new Integer(this.regionOutlineThicknessCombo.getSelectedIndex() + 1));
        } else if (source == this.regionOutlineColorButton) {
            color = this.showColorChooserDialog(this.getColorProperty(this.maps, 7002, Color.black));
            if (color != null) {
                PropertyUtils.setPropertyValue((Vector)this.maps, (int)7002, (Object)color);
                this.regionOutlineColorPanel.setBackground(color);
            }
        } else if (source == this.defaultColorButton) {
            color = this.showColorChooserDialog(this.getColorProperty(this.maps, 7013, Color.gray));
            if (color != null) {
                PropertyUtils.setPropertyValue((Vector)this.maps, (int)7013, (Object)color);
                this.defaultColorPanel.setBackground(color);
            }
        } else if (source == this.showLabelsCheckbox) {
            PropertyUtils.setPropertyValue((Vector)this.maps, (int)7004, (Object)new Boolean(this.showLabelsCheckbox.isSelected()));
        } else if (source == this.labelTextOptionsButton) {
            this.textDialog.showDialog(this.text, ResourceLoader.getResourceString((Object)this.rb, (String)"MapRegionPanel.Text_options.txt", (String)"Text options"));
        } else if (source == this.mapCategorizationCombo) {
            PropertyUtils.setPropertyValue((Vector)this.maps, (int)7006, (Object)this.getCategorization((String)this.mapCategorizationCombo.getSelectedItem(), (Integer)this.mapCategorizationSizeSpinner.getValue()));
            this.mapCategorizationSizeSpinner.setEnabled(!this.mapCategorizationCombo.getSelectedItem().equals(ResourceLoader.getResourceString((Object)this.rb, (String)"MapRegionPanel.Discrete.txt", (String)"Discrete")));
            if (this.mapCategorizationCombo.getSelectedItem().equals(ResourceLoader.getResourceString((Object)this.rb, (String)"MapRegionPanel.Continuous.txt", (String)"Continuous"))) {
                Integer value = (Integer)this.mapCategorizationSizeSpinner.getValue();
                Integer min = new Integer(2);
                Integer max = new Integer(6);
                Integer step = new Integer(1);
                SpinnerNumberModel model = new SpinnerNumberModel(value, min, max, step);
                this.mapCategorizationSizeSpinner.setModel(model);
            } else {
                Integer value = (Integer)this.mapCategorizationSizeSpinner.getValue();
                Integer min = new Integer(1);
                Integer max = new Integer(25);
                Integer step = new Integer(1);
                SpinnerNumberModel model = new SpinnerNumberModel(value, min, max, step);
                this.mapCategorizationSizeSpinner.setModel(model);
            }
        } else if (source == this.showShadowsCheckbox) {
            PropertyUtils.setPropertyValue((Vector)this.maps, (int)7012, (Object)new Boolean(this.showShadowsCheckbox.isSelected()));
        } else if (source == this.mapCategorizationUseRampCheckbox) {
            PropertyUtils.setPropertyValue((Vector)this.maps, (int)7029, (Object)new Boolean(this.mapCategorizationUseRampCheckbox.isSelected()));
        }
    }

    public Categorization getCategorization(String s, int size) {
        Categorization cat = new Categorization();
        if (s == null) {
            return cat;
        }
        if (s.equals(ResourceLoader.getResourceString((Object)this.rb, (String)"MapRegionPanel.Continuous.txt", (String)"Continuous"))) {
            cat.setCategoryType(0);
        } else if (s.equals(ResourceLoader.getResourceString((Object)this.rb, (String)"MapRegionPanel.Equal_Width.txt", (String)"Equal Width"))) {
            cat.setCategoryType(3);
        } else if (s.equals(ResourceLoader.getResourceString((Object)this.rb, (String)"MapRegionPanel.Discrete.txt", (String)"Discrete"))) {
            cat.setCategoryType(1);
        } else if (s.equals(ResourceLoader.getResourceString((Object)this.rb, (String)"MapRegionPanel.Equal_Size.txt", (String)"Equal Size"))) {
            cat.setCategoryType(2);
        }
        cat.setCategorySize(size);
        return cat;
    }

    @Override
    public void setVisible(boolean show) {
        if (show) {
            this.initFromSource();
        }
        super.setVisible(show);
    }

    private void initFromSource() {
        this.update = false;
        Object o = PropertyUtils.getPropertyValue((Vector)this.maps, (int)7001);
        if (o != null && o instanceof Boolean) {
            this.showRegionOutlinesCheckbox.setEnabled(true);
            this.showRegionOutlinesCheckbox.setSelected((Boolean)o);
        } else {
            this.showRegionOutlinesCheckbox.setEnabled(false);
        }
        o = PropertyUtils.getPropertyValue((Vector)this.maps, (int)7003);
        if (o != null && o instanceof Number) {
            this.regionOutlineThicknessCombo.setEnabled(true);
            this.regionOutlineThicknessCombo.setSelectedIndex(((Number)o).intValue() - 1);
        } else {
            this.regionOutlineThicknessCombo.setEnabled(false);
        }
        o = PropertyUtils.getPropertyValue((Vector)this.maps, (int)7002);
        if (o != null && o instanceof Color) {
            this.regionOutlineColorPanel.setEnabled(true);
            this.regionOutlineColorPanel.setBackground((Color)o);
        } else {
            this.regionOutlineColorPanel.setEnabled(false);
        }
        o = PropertyUtils.getPropertyValue((Vector)this.maps, (int)7013);
        if (o != null && o instanceof Color) {
            this.defaultColorPanel.setEnabled(true);
            this.defaultColorPanel.setBackground((Color)o);
        } else {
            this.defaultColorPanel.setEnabled(false);
        }
        o = PropertyUtils.getPropertyValue((Vector)this.maps, (int)7004);
        if (o != null && o instanceof Boolean) {
            this.showLabelsCheckbox.setEnabled(true);
            this.showLabelsCheckbox.setSelected((Boolean)o);
        } else {
            this.showLabelsCheckbox.setEnabled(false);
        }
        o = PropertyUtils.getPropertyValue((Vector)this.maps, (int)7003);
        if (o != null && o instanceof Number) {
            this.regionOutlineThicknessCombo.setEnabled(true);
            this.regionOutlineThicknessCombo.setSelectedIndex(((Number)o).intValue() - 1);
        } else {
            this.regionOutlineThicknessCombo.setEnabled(false);
        }
        o = PropertyUtils.getPropertyValue((Vector)this.maps, (int)7006);
        if (o != null && o instanceof Categorization) {
            this.enableCategorization(true);
            this.mapCategorizationCombo.setSelectedItem(this.getCategorizationType((Categorization)o));
            this.mapCategorizationSizeSpinner.setValue(new Integer(((Categorization)o).getCategorySize()));
            this.mapCategorizationSizeSpinner.setEnabled(!this.mapCategorizationCombo.getSelectedItem().equals(ResourceLoader.getResourceString((Object)this.rb, (String)"MapRegionPanel.Discrete.txt", (String)"Discrete")));
            if (this.mapCategorizationCombo.getSelectedItem().equals(ResourceLoader.getResourceString((Object)this.rb, (String)"MapRegionPanel.Continuous.txt", (String)"Continuous"))) {
                Integer value = (Integer)this.mapCategorizationSizeSpinner.getValue();
                Integer min = new Integer(2);
                Integer max = new Integer(6);
                Integer step = new Integer(1);
                SpinnerNumberModel model = new SpinnerNumberModel(value, min, max, step);
                this.mapCategorizationSizeSpinner.setModel(model);
            } else {
                Integer value = (Integer)this.mapCategorizationSizeSpinner.getValue();
                Integer min = new Integer(1);
                Integer max = new Integer(25);
                Integer step = new Integer(1);
                SpinnerNumberModel model = new SpinnerNumberModel(value, min, max, step);
                this.mapCategorizationSizeSpinner.setModel(model);
            }
        } else {
            this.enableCategorization(false);
        }
        o = PropertyUtils.getPropertyValue((Vector)this.maps, (int)7012);
        if (o != null && o instanceof Boolean) {
            this.showShadowsCheckbox.setEnabled(true);
            this.showShadowsCheckbox.setSelected((Boolean)o);
        } else {
            this.showShadowsCheckbox.setEnabled(false);
        }
        o = PropertyUtils.getPropertyValue((Vector)this.maps, (int)7029);
        if (o != null && o instanceof Boolean) {
            this.mapCategorizationUseRampCheckbox.setEnabled(true);
            this.mapCategorizationUseRampCheckbox.setSelected((Boolean)o);
        } else {
            this.mapCategorizationUseRampCheckbox.setEnabled(false);
        }
        o = PropertyUtils.getPropertyValue((Vector)this.maps, (int)7015);
        this.enableLabelPanel(o != null && (Boolean)o != false);
        o = PropertyUtils.getPropertyValue((Vector)this.maps, (int)7032);
        if (o != null && o instanceof Boolean) {
            this.enableCategorization((Boolean)o);
        } else {
            this.enableCategorization(false);
        }
        this.update = true;
    }

    private void enableCategorization(boolean b) {
        this.mapCategorizationCombo.setEnabled(b);
        this.mapCategorizationSizeSpinner.setEnabled(b);
    }

    private String getCategorizationType(Categorization cat) {
        switch (cat.getCategoryType()) {
            case 0: {
                return ResourceLoader.getResourceString((Object)this.rb, (String)"MapRegionPanel.Continuous.txt", (String)"Continuous");
            }
            case 1: {
                return ResourceLoader.getResourceString((Object)this.rb, (String)"MapRegionPanel.Discrete.txt", (String)"Discrete");
            }
            case 2: {
                return ResourceLoader.getResourceString((Object)this.rb, (String)"MapRegionPanel.Equal_Size.txt", (String)"Equal Size");
            }
            case 3: {
                return ResourceLoader.getResourceString((Object)this.rb, (String)"MapRegionPanel.Equal_Width.txt", (String)"Equal Width");
            }
        }
        return null;
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        Object source = e.getSource();
        if (this.maps == null || this.maps.size() == 0 || !this.update) {
            return;
        }
        if (source == this.mapCategorizationSizeSpinner) {
            PropertyUtils.setPropertyValue((Vector)this.maps, (int)7006, (Object)this.getCategorization((String)this.mapCategorizationCombo.getSelectedItem(), (Integer)this.mapCategorizationSizeSpinner.getValue()));
        }
    }

    protected Color showColorChooserDialog(Color initialColor) {
        if (this.colorChooser == null && (this.colorChooser = new JColorChooser()) == null) {
            return null;
        }
        return JColorChooser.showDialog(this, ResourceLoader.getResourceString((Object)this.rb, (String)"MapRegionPanel.Choose_a_color.txt", (String)"Choose a color"), initialColor);
    }

    protected boolean getBooleanProperty(PropertyInterface prop, int id, boolean defaultValue) {
        if (prop == null) {
            return defaultValue;
        }
        Object o = prop.getPropertyValue(id);
        if (o == null || !(o instanceof Boolean)) {
            return defaultValue;
        }
        return (Boolean)o;
    }

    protected Color getColorProperty(Vector prop, int id, Color defaultValue) {
        if (prop == null) {
            return defaultValue;
        }
        Object o = PropertyUtils.getPropertyValue((Vector)prop, (int)id);
        if (o == null || !(o instanceof Color)) {
            return defaultValue;
        }
        return (Color)o;
    }

    protected double getNumericProperty(PropertyInterface prop, int id, double defaultValue) {
        if (prop == null) {
            return defaultValue;
        }
        Object o = prop.getPropertyValue(id);
        if (o == null || !(o instanceof Number)) {
            return defaultValue;
        }
        return ((Number)o).doubleValue();
    }

    protected void enableLabelPanel(boolean b) {
        this.showLabelsCheckbox.setEnabled(b);
        this.labelTextOptionsButton.setEnabled(b);
    }

    public boolean addPropertyListener(PropertyInterface prop) {
        return false;
    }

    public boolean removePropertyListener(PropertyInterface prop) {
        return false;
    }
}

