/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.silk.ui;

import com.sas.graphics.silk.interfaces.MapInterface;
import com.sas.graphics.silk.interfaces.PropertyInterface;
import com.sas.graphics.silk.map.Categorization;
import com.sas.graphics.silk.ui.TabPanelInterface;
import com.sas.graphics.silk.ui.TabbedPropertiesDialog;
import com.sas.graphics.silk.ui.TextDialog;
import com.sas.graphics.silk.util.PropertyUtils;
import com.sas.graphics.silk.util.ResourceLoader;
import java.awt.Color;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class MapMarkerPanel
extends JPanel
implements TabPanelInterface,
ActionListener,
ChangeListener {
    private static final long serialVersionUID = 8417923971022508046L;
    Vector maps = new Vector();
    PropertyInterface text;
    protected boolean update = true;
    ResourceBundle rb = null;
    TitledBorder categorizationBorder = null;
    TitledBorder sizeBorder = null;
    JPanel categorizationPanel = null;
    JPanel sizePanel = null;
    JCheckBox showMarkersCheckbox = null;
    JLabel markerShapeLabel = null;
    JComboBox markerShapeCombo = null;
    JLabel markerCategorizationLabel = null;
    JComboBox markerCategorizationCombo = null;
    JLabel markerCategorizationSizeLabel = null;
    JSpinner markerCategorizationSizeSpinner = null;
    JCheckBox markerCategorizationUseRampCheckbox = null;
    JLabel markerMinSizeLabel = null;
    JSlider markerMinSizeSlider = null;
    JLabel markerMaxSizeLabel = null;
    JSlider markerMaxSizeSlider = null;
    JLabel defaultColorLabel = null;
    JPanel defaultColorPanel = null;
    JButton defaultColorButton = null;
    JCheckBox showShadowsCheckbox = null;
    protected TextDialog textDialog;
    protected JColorChooser colorChooser;

    public MapMarkerPanel(PropertyInterface map, PropertyInterface text) {
        this.maps.add(map);
        this.text = text;
        this.rb = ResourceLoader.loadBundle((String)"com.sas.graphics.silk.ui.silk_ui_NLS");
        this.textDialog = new TextDialog((Frame)null, null);
        this.initGUI();
        this.showMarkersCheckbox.addActionListener(this);
        this.markerShapeCombo.addActionListener(this);
        this.markerCategorizationCombo.addActionListener(this);
        this.markerCategorizationSizeSpinner.addChangeListener(this);
        this.markerCategorizationUseRampCheckbox.addActionListener(this);
        this.markerMinSizeSlider.addChangeListener(this);
        this.markerMaxSizeSlider.addChangeListener(this);
        this.defaultColorButton.addActionListener(this);
        this.showShadowsCheckbox.addActionListener(this);
        this.initFromSource();
    }

    @Override
    public void setVisible(boolean show) {
        if (show) {
            this.initFromSource();
        }
        super.setVisible(show);
    }

    private void initGUI() {
        this.setLayout(null);
        this.sizeBorder = new TitledBorder(new EtchedBorder());
        this.sizeBorder.setTitleFont(TabbedPropertiesDialog.dialogFont);
        this.sizeBorder.setTitle(ResourceLoader.getResourceString((Object)this.rb, (String)"MapMarkerPanel.SizeLabel.txt", (String)"Size"));
        this.sizeBorder.setTitleColor(Color.black);
        this.categorizationBorder = new TitledBorder(new EtchedBorder());
        this.categorizationBorder.setTitleFont(TabbedPropertiesDialog.dialogFont);
        this.categorizationBorder.setTitle(ResourceLoader.getResourceString((Object)this.rb, (String)"MapMarkerPanel.Categorization.txt", (String)"Categorization"));
        this.categorizationBorder.setTitleColor(Color.black);
        this.sizePanel = new JPanel();
        this.sizePanel.setLayout(null);
        this.categorizationPanel = new JPanel();
        this.categorizationPanel.setLayout(null);
        this.sizePanel.setBorder(this.sizeBorder);
        this.categorizationPanel.setBorder(this.categorizationBorder);
        this.showMarkersCheckbox = new JCheckBox();
        this.showMarkersCheckbox.setFont(TabbedPropertiesDialog.dialogFont);
        this.showMarkersCheckbox.setText(ResourceLoader.getResourceString((Object)this.rb, (String)"MapMarkerPanel.Show_markers.txt", (String)"Show markers"));
        this.markerShapeCombo = new JComboBox();
        this.markerShapeCombo.setFont(TabbedPropertiesDialog.dialogFont);
        this.markerShapeLabel = new JLabel();
        this.markerShapeLabel.setFont(TabbedPropertiesDialog.dialogFont);
        this.markerShapeLabel.setText(ResourceLoader.getResourceString((Object)this.rb, (String)"MapMarkerPanel.Shape.txt", (String)"Shape:"));
        this.markerCategorizationLabel = new JLabel(ResourceLoader.getResourceString((Object)this.rb, (String)"MapMarkerPanel.Type.txt", (String)"Type:"));
        this.markerCategorizationLabel.setFont(TabbedPropertiesDialog.dialogFont);
        this.markerCategorizationCombo = new JComboBox();
        this.markerCategorizationCombo.setFont(TabbedPropertiesDialog.dialogFont);
        this.markerCategorizationCombo.addItem(ResourceLoader.getResourceString((Object)this.rb, (String)"MapMarkerPanel.Continuous.txt", (String)"Continuous"));
        this.markerCategorizationCombo.addItem(ResourceLoader.getResourceString((Object)this.rb, (String)"MapMarkerPanel.Discrete.txt", (String)"Discrete"));
        this.markerCategorizationCombo.addItem(ResourceLoader.getResourceString((Object)this.rb, (String)"MapMarkerPanel.Equal_Size.txt", (String)"Equal Size"));
        this.markerCategorizationCombo.addItem(ResourceLoader.getResourceString((Object)this.rb, (String)"MapMarkerPanel.Equal_Width.txt", (String)"Equal Width"));
        this.markerCategorizationSizeLabel = new JLabel(ResourceLoader.getResourceString((Object)this.rb, (String)"MapMarkerPanel.Size.txt", (String)"Size:"));
        this.markerCategorizationSizeLabel.setFont(TabbedPropertiesDialog.dialogFont);
        this.markerCategorizationSizeSpinner = new JSpinner();
        this.markerCategorizationSizeSpinner.setFont(TabbedPropertiesDialog.dialogFont);
        this.markerCategorizationUseRampCheckbox = new JCheckBox(ResourceLoader.getResourceString((Object)this.rb, (String)"MapMarkerPanel.Use_color_ramp.txt", (String)"Use color ramp"));
        this.markerCategorizationUseRampCheckbox.setFont(TabbedPropertiesDialog.dialogFont);
        Integer value = new Integer(4);
        Integer min = new Integer(1);
        Integer max = new Integer(25);
        Integer step = new Integer(1);
        SpinnerNumberModel model = new SpinnerNumberModel(value, min, max, step);
        this.markerCategorizationSizeSpinner.setModel(model);
        this.markerMinSizeLabel = new JLabel(ResourceLoader.getResourceString((Object)this.rb, (String)"MapMarkerPanel.Min.txt", (String)"Min:"));
        this.markerMinSizeLabel.setFont(TabbedPropertiesDialog.dialogFont);
        this.markerMinSizeSlider = new JSlider();
        this.markerMaxSizeLabel = new JLabel(ResourceLoader.getResourceString((Object)this.rb, (String)"MapMarkerPanel.Max.txt", (String)"Max:"));
        this.markerMaxSizeLabel.setFont(TabbedPropertiesDialog.dialogFont);
        this.markerMaxSizeSlider = new JSlider();
        this.defaultColorLabel = new JLabel(ResourceLoader.getResourceString((Object)this.rb, (String)"MapMarkerPanel.Default_color.txt", (String)"Default color:"));
        this.defaultColorLabel.setFont(TabbedPropertiesDialog.dialogFont);
        this.defaultColorPanel = new JPanel();
        this.defaultColorPanel.setBackground(Color.gray);
        this.defaultColorButton = new JButton(ResourceLoader.getResourceString((Object)this.rb, (String)"MapMarkerPanel.Etc.txt", (String)"..."));
        this.defaultColorButton.setFont(TabbedPropertiesDialog.dialogFont);
        this.showShadowsCheckbox = new JCheckBox(ResourceLoader.getResourceString((Object)this.rb, (String)"MapMarkerPanel.Show_shadows.txt", (String)"Show shadows"));
        this.showShadowsCheckbox.setFont(TabbedPropertiesDialog.dialogFont);
        this.categorizationPanel.add(this.markerCategorizationLabel);
        this.categorizationPanel.add(this.markerCategorizationCombo);
        this.categorizationPanel.add(this.markerCategorizationSizeLabel);
        this.categorizationPanel.add(this.markerCategorizationSizeSpinner);
        this.categorizationPanel.add(this.markerCategorizationUseRampCheckbox);
        this.sizePanel.add(this.markerMinSizeLabel);
        this.sizePanel.add(this.markerMinSizeSlider);
        this.sizePanel.add(this.markerMaxSizeLabel);
        this.sizePanel.add(this.markerMaxSizeSlider);
        this.add(this.showMarkersCheckbox);
        this.add(this.markerShapeLabel);
        this.add(this.markerShapeCombo);
        this.add(this.categorizationPanel);
        this.add(this.sizePanel);
        this.add(this.defaultColorLabel);
        this.add(this.defaultColorPanel);
        this.add(this.defaultColorButton);
        this.add(this.showShadowsCheckbox);
        this.showMarkersCheckbox.setBounds(15, 10, 100, 18);
        this.markerShapeLabel.setBounds(15, 35, 80, 18);
        this.markerShapeCombo.setBounds(115, 35, 120, 22);
        this.markerCategorizationLabel.setBounds(15, 20, 90, 18);
        this.markerCategorizationCombo.setBounds(115, 20, 120, 22);
        this.markerCategorizationSizeLabel.setBounds(15, 49, 60, 18);
        this.markerCategorizationSizeSpinner.setBounds(115, 49, 60, 22);
        this.markerCategorizationUseRampCheckbox.setBounds(12, 75, 120, 22);
        this.markerMinSizeLabel.setBounds(15, 20, 100, 18);
        this.markerMinSizeSlider.setBounds(110, 22, 120, 18);
        this.markerMaxSizeLabel.setBounds(15, 45, 100, 18);
        this.markerMaxSizeSlider.setBounds(110, 47, 120, 18);
        this.categorizationPanel.setBounds(0, 70, 277, 110);
        this.sizePanel.setBounds(0, 190, 277, 90);
        this.defaultColorLabel.setBounds(10, 300, 75, 18);
        this.defaultColorPanel.setBounds(80, 300, 40, 20);
        this.defaultColorButton.setBounds(125, 300, 20, 20);
        this.showShadowsCheckbox.setBounds(10, 340, 160, 18);
        int n = MapInterface.shapeList.length;
        if (PropertyUtils.getPropertyValue((Vector)this.maps, (int)7008) == null) {
            --n;
        }
        for (int i = 0; i < n; ++i) {
            this.markerShapeCombo.addItem(MapInterface.shapeList[i]);
        }
    }

    public boolean applyChanges() {
        return false;
    }

    public boolean cancelChanges() {
        return false;
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        if (!this.update) {
            return;
        }
        Object source = ae.getSource();
        Color color = null;
        if (source == this.markerShapeCombo) {
            PropertyUtils.setPropertyValue((Vector)this.maps, (int)7008, (Object)this.markerShapeCombo.getSelectedItem());
        } else if (source == this.showMarkersCheckbox) {
            PropertyUtils.setPropertyValue((Vector)this.maps, (int)7007, (Object)new Boolean(this.showMarkersCheckbox.isSelected()));
        } else if (source == this.markerCategorizationCombo) {
            PropertyUtils.setPropertyValue((Vector)this.maps, (int)7009, (Object)this.getCategorization((String)this.markerCategorizationCombo.getSelectedItem(), (Integer)this.markerCategorizationSizeSpinner.getValue()));
            this.markerCategorizationSizeSpinner.setEnabled(!this.markerCategorizationCombo.getSelectedItem().equals(ResourceLoader.getResourceString((Object)this.rb, (String)"MapMarkerPanel.Discrete.txt", (String)"Discrete")));
        } else if (source == this.showShadowsCheckbox) {
            PropertyUtils.setPropertyValue((Vector)this.maps, (int)7012, (Object)new Boolean(this.showShadowsCheckbox.isSelected()));
        } else if (source == this.defaultColorButton) {
            color = this.showColorChooserDialog(this.getColorProperty(this.maps, 7014, Color.gray));
            if (color != null) {
                PropertyUtils.setPropertyValue((Vector)this.maps, (int)7014, (Object)color);
                this.defaultColorPanel.setBackground(color);
            }
        } else if (source == this.markerCategorizationUseRampCheckbox) {
            PropertyUtils.setPropertyValue((Vector)this.maps, (int)7030, (Object)new Boolean(this.markerCategorizationUseRampCheckbox.isSelected()));
        }
    }

    public Categorization getCategorization(String s, int size) {
        Categorization cat = new Categorization();
        if (s == null) {
            return cat;
        }
        if (s.equals(ResourceLoader.getResourceString((Object)this.rb, (String)"MapMarkerPanel.Continuous.txt", (String)"Continuous"))) {
            cat.setCategoryType(0);
        } else if (s.equals(ResourceLoader.getResourceString((Object)this.rb, (String)"MapMarkerPanel.Equal_Width.txt", (String)"Equal Width"))) {
            cat.setCategoryType(3);
        } else if (s.equals(ResourceLoader.getResourceString((Object)this.rb, (String)"MapMarkerPanel.Discrete.txt", (String)"Discrete"))) {
            cat.setCategoryType(1);
        } else if (s.equals(ResourceLoader.getResourceString((Object)this.rb, (String)"MapMarkerPanel.Equal_Size.txt", (String)"Equal Size"))) {
            cat.setCategoryType(2);
        }
        cat.setCategorySize(size);
        return cat;
    }

    private void initFromSource() {
        this.update = false;
        Object o = PropertyUtils.getPropertyValue((Vector)this.maps, (int)7008);
        if (o != null && o instanceof String) {
            this.markerShapeCombo.setEnabled(true);
            this.markerShapeCombo.setSelectedItem((String)o);
        } else {
            this.markerShapeCombo.setEnabled(false);
        }
        o = PropertyUtils.getPropertyValue((Vector)this.maps, (int)7007);
        if (o != null && o instanceof Boolean) {
            this.showMarkersCheckbox.setEnabled(true);
            this.showMarkersCheckbox.setSelected((Boolean)o);
        } else {
            this.showMarkersCheckbox.setEnabled(false);
        }
        o = PropertyUtils.getPropertyValue((Vector)this.maps, (int)7009);
        if (o != null && o instanceof Categorization) {
            this.markerCategorizationCombo.setEnabled(true);
            this.markerCategorizationSizeSpinner.setEnabled(true);
            this.markerCategorizationCombo.setSelectedItem(this.getCategorizationType((Categorization)o));
            this.markerCategorizationSizeSpinner.setValue(new Integer(((Categorization)o).getCategorySize()));
            this.markerCategorizationSizeSpinner.setEnabled(!this.markerCategorizationCombo.getSelectedItem().equals(ResourceLoader.getResourceString((Object)this.rb, (String)"MapMarkerPanel.Discrete.txt", (String)"Discrete")));
        } else {
            this.markerCategorizationCombo.setEnabled(false);
            this.markerCategorizationSizeSpinner.setEnabled(false);
        }
        o = PropertyUtils.getPropertyValue((Vector)this.maps, (int)7030);
        if (o != null && o instanceof Boolean) {
            this.markerCategorizationUseRampCheckbox.setEnabled(true);
            this.markerCategorizationUseRampCheckbox.setSelected((Boolean)o);
        } else {
            this.markerCategorizationUseRampCheckbox.setEnabled(false);
        }
        o = PropertyUtils.getPropertyValue((Vector)this.maps, (int)7010);
        if (o != null && o instanceof Number) {
            this.markerMinSizeSlider.setEnabled(true);
            this.markerMinSizeLabel.setEnabled(true);
            this.markerMinSizeSlider.setValue(((Number)o).intValue());
            this.setMarkerMinSizeLabel(((Number)o).intValue());
        } else {
            this.markerMinSizeSlider.setEnabled(false);
            this.markerMinSizeLabel.setEnabled(false);
        }
        o = PropertyUtils.getPropertyValue((Vector)this.maps, (int)7011);
        if (o != null && o instanceof Number) {
            this.markerMaxSizeSlider.setEnabled(true);
            this.markerMaxSizeLabel.setEnabled(true);
            this.markerMaxSizeSlider.setValue(((Number)o).intValue());
            this.setMarkerMaxSizeLabel(((Number)o).intValue());
        } else {
            this.markerMaxSizeSlider.setEnabled(false);
            this.markerMaxSizeLabel.setEnabled(false);
        }
        o = PropertyUtils.getPropertyValue((Vector)this.maps, (int)7012);
        if (o != null && o instanceof Boolean) {
            this.showShadowsCheckbox.setEnabled(true);
            this.showShadowsCheckbox.setSelected((Boolean)o);
        } else {
            this.showShadowsCheckbox.setEnabled(false);
        }
        o = PropertyUtils.getPropertyValue((Vector)this.maps, (int)7014);
        if (o != null && o instanceof Color) {
            this.defaultColorPanel.setEnabled(true);
            this.defaultColorPanel.setBackground((Color)o);
        } else {
            this.defaultColorPanel.setEnabled(false);
        }
        o = PropertyUtils.getPropertyValue((Vector)this.maps, (int)7016);
        this.enablePanel(o != null && (Boolean)o != false);
        o = PropertyUtils.getPropertyValue((Vector)this.maps, (int)7033);
        if (o != null && o instanceof Boolean) {
            this.enableCategorization((Boolean)o);
        } else {
            this.enableCategorization(false);
        }
        this.update = true;
    }

    private void enableCategorization(boolean b) {
        this.markerCategorizationCombo.setEnabled(b);
        this.markerCategorizationSizeSpinner.setEnabled(b);
    }

    private void setMarkerMinSizeLabel(int i) {
        String sliderPattern = ResourceLoader.getResourceString((Object)this.rb, (String)"MapMarkerPanel.Min_Size_Slider_Text.fmt", (String)"Min: {0,number,integer}");
        Object[] sliderArgs = new Object[]{new Integer(i)};
        this.markerMinSizeLabel.setText(MessageFormat.format(sliderPattern, sliderArgs));
    }

    private void setMarkerMaxSizeLabel(int i) {
        String sliderPattern = ResourceLoader.getResourceString((Object)this.rb, (String)"MapMarkerPanel.Max_Size_Slider_Text.fmt", (String)"Max: {0,number,integer}");
        Object[] sliderArgs = new Object[]{new Integer(i)};
        this.markerMaxSizeLabel.setText(MessageFormat.format(sliderPattern, sliderArgs));
    }

    private String getCategorizationType(Categorization cat) {
        switch (cat.getCategoryType()) {
            case 0: {
                return ResourceLoader.getResourceString((Object)this.rb, (String)"MapMarkerPanel.Continuous.txt", (String)"Continuous");
            }
            case 1: {
                return ResourceLoader.getResourceString((Object)this.rb, (String)"MapMarkerPanel.Discrete.txt", (String)"Discrete");
            }
            case 2: {
                return ResourceLoader.getResourceString((Object)this.rb, (String)"MapMarkerPanel.Equal_Size.txt", (String)"Equal Size");
            }
            case 3: {
                return ResourceLoader.getResourceString((Object)this.rb, (String)"MapMarkerPanel.Equal_Width.txt", (String)"Equal Width");
            }
        }
        return null;
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        Object source = e.getSource();
        if (this.maps == null || this.maps.size() == 0 || !this.update) {
            return;
        }
        if (source == this.markerMinSizeSlider) {
            int newSize = this.markerMinSizeSlider.getValue();
            PropertyUtils.setPropertyValue((Vector)this.maps, (int)7010, (Object)new Integer(newSize));
            this.setMarkerMinSizeLabel(newSize);
        } else if (source == this.markerMaxSizeSlider) {
            int newSize = this.markerMaxSizeSlider.getValue();
            PropertyUtils.setPropertyValue((Vector)this.maps, (int)7011, (Object)new Integer(newSize));
            this.setMarkerMaxSizeLabel(newSize);
        } else if (source == this.markerCategorizationSizeSpinner) {
            PropertyUtils.setPropertyValue((Vector)this.maps, (int)7009, (Object)this.getCategorization((String)this.markerCategorizationCombo.getSelectedItem(), (Integer)this.markerCategorizationSizeSpinner.getValue()));
        }
    }

    protected Color showColorChooserDialog(Color initialColor) {
        if (this.colorChooser == null && (this.colorChooser = new JColorChooser()) == null) {
            return null;
        }
        return JColorChooser.showDialog(this, ResourceLoader.getResourceString((Object)this.rb, (String)"MapMarkerPanel.Choose_a_color.txt", (String)"Choose a color"), initialColor);
    }

    protected boolean getBooleanProperty(PropertyInterface prop, int id, boolean defaultValue) {
        if (prop == null) {
            return defaultValue;
        }
        Object o = prop.getPropertyValue(id);
        if (o == null || !(o instanceof Boolean)) {
            return defaultValue;
        }
        return (Boolean)o;
    }

    protected Color getColorProperty(Vector props, int id, Color defaultValue) {
        if (props == null || props.size() == 0) {
            return defaultValue;
        }
        Object o = PropertyUtils.getPropertyValue((Vector)props, (int)id);
        if (o == null || !(o instanceof Color)) {
            return defaultValue;
        }
        return (Color)o;
    }

    protected double getNumericProperty(PropertyInterface prop, int id, double defaultValue) {
        if (prop == null) {
            return defaultValue;
        }
        Object o = prop.getPropertyValue(id);
        if (o == null || !(o instanceof Number)) {
            return defaultValue;
        }
        return ((Number)o).doubleValue();
    }

    protected void enablePanel(boolean b) {
        this.categorizationPanel.setEnabled(b);
        this.sizePanel.setEnabled(b);
        this.showMarkersCheckbox.setEnabled(b);
        this.markerShapeLabel.setEnabled(b);
        this.markerShapeCombo.setEnabled(b);
        this.markerCategorizationLabel.setEnabled(b);
        this.markerCategorizationCombo.setEnabled(b);
        this.markerCategorizationSizeLabel.setEnabled(b);
        this.markerCategorizationSizeSpinner.setEnabled(b);
        this.markerMinSizeLabel.setEnabled(b);
        this.markerMinSizeSlider.setEnabled(b);
        this.markerMaxSizeLabel.setEnabled(b);
        this.markerMaxSizeSlider.setEnabled(b);
        this.defaultColorLabel.setEnabled(b);
        this.defaultColorPanel.setEnabled(b);
        this.defaultColorButton.setEnabled(b);
        this.showShadowsCheckbox.setEnabled(b);
    }

    public boolean addPropertyListener(PropertyInterface prop) {
        return false;
    }

    public boolean removePropertyListener(PropertyInterface prop) {
        return false;
    }
}

