/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.silk.ui;

import com.sas.graphics.silk.ConstComponent;
import com.sas.graphics.silk.interfaces.PropertyInterface;
import com.sas.graphics.silk.ui.BaseLinksPanel;
import com.sas.graphics.silk.ui.TabPanelInterface;
import com.sas.graphics.silk.ui.TabbedPropertiesDialog;
import com.sas.graphics.silk.util.ResourceLoader;
import java.awt.Color;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;

public class LinksPanel
extends BaseLinksPanel
implements TabPanelInterface,
ItemListener {
    private static final long serialVersionUID = -3684700264817176041L;
    JPanel LinkThresholdPanel = new JPanel();
    JCheckBox LinkThresholdCheckBox = new JCheckBox();
    JPanel ShowLinksPanel = new JPanel();
    JCheckBox SelectLinksCheckBox = new JCheckBox();
    JCheckBox ShowAllLinksCheck = new JCheckBox();
    JCheckBox ShowLinksIntoCheck = new JCheckBox();
    JCheckBox ShowLinksAmongCheck = new JCheckBox();
    JCheckBox ShowLinksOutOfCheck = new JCheckBox();
    JCheckBox LinkValueScaledCheck = new JCheckBox();
    JCheckBox LinkArrowCheckBox = new JCheckBox();
    private TitledBorder LinkThresholdBorder = new TitledBorder(this.etchedBorder);
    private TitledBorder ShowLinksBorder = new TitledBorder(this.etchedBorder);
    private double minVal;
    private double maxVal;
    private double val;
    private int sliderValue;

    public LinksPanel(PropertyInterface propInterface, JComponent component) {
        super(propInterface, component);
        this.resourceBundle = ResourceLoader.loadBundle((String)"com.sas.graphics.silk.constchart.LinksPanel");
        this.setLayout(null);
        this.setSize(265, 410);
        this.LinkArrowCheckBox.setText("Show Directed Links");
        this.LinkArrowCheckBox.setActionCommand("ShowDirectedLinks");
        this.LinkArrowCheckBox.setFont(TabbedPropertiesDialog.dialogFont);
        this.LinkArrowCheckBox.setBounds(16, 390, 232, 24);
        this.add(this.LinkArrowCheckBox);
        this.LinkColorMappedButton.setBounds(16, 350, 240, 24);
        this.LinkWidthPanel.setBounds(12, 12, 270, 81);
        this.LinkWidthFixedButton.setBounds(4, 20, 100, 24);
        this.LinkWidthMappedButton.setBounds(4, 48, 232, 24);
        this.LinkWidthCombo.setBounds(120, 20, 140, 24);
        this.LinkThresholdPanel.setLayout(null);
        this.add(this.LinkThresholdPanel);
        this.LinkThresholdPanel.setBounds(12, 110, 270, 77);
        this.LinkValueScaledCheck.setText("Scale Link Values");
        this.LinkValueScaledCheck.setActionCommand("ScaleLinkValues");
        this.LinkValueScaledCheck.setFont(TabbedPropertiesDialog.dialogFont);
        this.LinkValueScaledCheck.setBounds(4, 43, 232, 24);
        this.LinkValueScaledCheck.setSelected(true);
        this.LinkThresholdPanel.add(this.LinkValueScaledCheck);
        this.LinkThresholdCheckBox.setText("Show Threshold Slider");
        this.LinkThresholdCheckBox.setActionCommand("ShowThresholdSlider");
        this.LinkThresholdCheckBox.setFont(TabbedPropertiesDialog.dialogFont);
        this.LinkThresholdCheckBox.setBounds(4, 16, 232, 24);
        this.LinkThresholdPanel.add(this.LinkThresholdCheckBox);
        this.ShowLinksPanel.setLayout(null);
        this.add(this.ShowLinksPanel);
        this.ShowLinksPanel.setBounds(12, 210, 270, 125);
        this.ShowAllLinksCheck.setText("Show all links");
        this.ShowAllLinksCheck.setActionCommand("allCB");
        this.ShowAllLinksCheck.setFont(TabbedPropertiesDialog.dialogFont);
        this.ShowAllLinksCheck.setBounds(4, 16, 232, 20);
        this.ShowAllLinksCheck.setSelected(true);
        this.ShowAllLinksCheck.setEnabled(true);
        this.ShowLinksPanel.add(this.ShowAllLinksCheck);
        this.ShowLinksIntoCheck.setText("Show links into selection");
        this.ShowLinksIntoCheck.setActionCommand("intoCB");
        this.ShowLinksIntoCheck.setFont(TabbedPropertiesDialog.dialogFont);
        this.ShowLinksIntoCheck.setBounds(12, 43, 234, 20);
        this.ShowLinksIntoCheck.setSelected(true);
        this.ShowLinksIntoCheck.setEnabled(false);
        this.ShowLinksPanel.add(this.ShowLinksIntoCheck);
        this.ShowLinksOutOfCheck.setText("Show links out of selection");
        this.ShowLinksOutOfCheck.setActionCommand("outofCB");
        this.ShowLinksOutOfCheck.setFont(TabbedPropertiesDialog.dialogFont);
        this.ShowLinksOutOfCheck.setBounds(12, 68, 234, 20);
        this.ShowLinksOutOfCheck.setSelected(true);
        this.ShowLinksOutOfCheck.setEnabled(false);
        this.ShowLinksPanel.add(this.ShowLinksOutOfCheck);
        this.ShowLinksAmongCheck.setText("Show links among selection");
        this.ShowLinksAmongCheck.setActionCommand("amongCB");
        this.ShowLinksAmongCheck.setFont(TabbedPropertiesDialog.dialogFont);
        this.ShowLinksAmongCheck.setBounds(12, 93, 234, 20);
        this.ShowLinksAmongCheck.setSelected(true);
        this.ShowLinksAmongCheck.setEnabled(false);
        this.ShowLinksPanel.add(this.ShowLinksAmongCheck);
        this.SelectLinksCheckBox.setText("Select Links");
        this.SelectLinksCheckBox.setActionCommand("SelectLinks");
        this.SelectLinksCheckBox.setFont(TabbedPropertiesDialog.dialogFont);
        this.SelectLinksCheckBox.setBounds(16, 370, 232, 24);
        this.add(this.SelectLinksCheckBox);
        this.LinkThresholdPanel.setBorder(this.LinkThresholdBorder);
        this.ShowLinksPanel.setBorder(this.ShowLinksBorder);
        this.LinkThresholdBorder.setTitleColor(Color.black);
        this.ShowLinksBorder.setTitleColor(Color.black);
        this.LinkThresholdBorder.setTitleFont(TabbedPropertiesDialog.dialogFont);
        this.ShowLinksBorder.setTitleFont(TabbedPropertiesDialog.dialogFont);
        String thresholdTitle = this.GRS(this.resourceBundle, "LinksPanel.Threshold.txt", "Threshold");
        String scaled = this.GRS(this.resourceBundle, "LinksPanel.Scaled.txt", "Scale Link Values");
        String linkThresholdCheckBoxLabels = this.GRS(this.resourceBundle, "LinksPanel.LinkThresholdCheckBox.txt", "Show Threshold Slider");
        this.LinkThresholdCheckBox.setText(linkThresholdCheckBoxLabels);
        String linkArrowLabel = this.GRS(this.resourceBundle, "LinksPanel.LinkArrowCheckBox.txt", "Show Directed Links");
        this.LinkArrowCheckBox.setText(linkArrowLabel);
        String selectLinksLabel = this.GRS(this.resourceBundle, "LinksPanel.SelectLinks.txt", "Select Links");
        this.SelectLinksCheckBox.setText(selectLinksLabel);
        this.LinkThresholdBorder.setTitle(thresholdTitle);
        this.LinkValueScaledCheck.setText(scaled);
        String showLinksTitle = this.GRS(this.resourceBundle, "LinksPanel.CS.ShowLinks.txt", "Link visibility");
        String showAllLinksLabel = this.GRS(this.resourceBundle, "LinksPanel.CS.all.txt", "Show all links");
        String showLinksIntoLabel = this.GRS(this.resourceBundle, "LinksPanel.CS.into.txt", "Show links into selection");
        String showLinksAmongLabel = this.GRS(this.resourceBundle, "LinksPanel.CS.among.txt", "Show links among selection");
        String showLinksOutOfLabel = this.GRS(this.resourceBundle, "LinksPanel.CS.outof.txt", "Show links out of selection");
        this.ShowLinksBorder.setTitle(showLinksTitle);
        this.ShowAllLinksCheck.setText(showAllLinksLabel);
        this.ShowLinksIntoCheck.setText(showLinksIntoLabel);
        this.ShowLinksAmongCheck.setText(showLinksAmongLabel);
        this.ShowLinksOutOfCheck.setText(showLinksOutOfLabel);
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        super.itemStateChanged(e);
        Object source = e.getSource();
        if (null == source) {
            return;
        }
        if (source instanceof JCheckBox) {
            JCheckBox check = (JCheckBox)source;
            String cmd = check.getActionCommand();
            if (cmd.equals("ScaleLinkValues")) {
                this.propertyInterface.setPropertyValue(857, (Object)new Boolean(check.isSelected()));
                this.propertyInterface.setPropertyValue(861, (Object)new Boolean(this.LinkThresholdCheckBox.isSelected()));
                this.setThreshold(false);
            } else if (cmd.equals("ShowThresholdSlider")) {
                this.propertyInterface.setPropertyValue(861, (Object)new Boolean(check.isSelected()));
                this.LinkValueScaledCheck.setEnabled(check.isSelected());
            } else if (cmd.equals("ShowDirectedLinks")) {
                this.propertyInterface.setPropertyValue(862, (Object)new Boolean(check.isSelected()));
            } else if (cmd.equals("allCB")) {
                boolean state = check.isSelected();
                this.propertyInterface.setPropertyValue(864, (Object)new Boolean(state));
                this.ShowAllLinksCheck.setEnabled(true);
                this.ShowLinksIntoCheck.setEnabled(!state);
                this.ShowLinksOutOfCheck.setEnabled(!state);
                this.ShowLinksAmongCheck.setEnabled(!state);
                this.SelectLinksCheckBox.setEnabled(state);
                if (state) {
                    this.LinkArrowCheckBox.setEnabled(true);
                    boolean flag = this.LinkArrowCheckBox.isSelected();
                    this.propertyInterface.setPropertyValue(862, (Object)new Boolean(flag));
                } else {
                    if (this.SelectLinksCheckBox.isSelected()) {
                        this.SelectLinksCheckBox.setSelected(false);
                        this.propertyInterface.setPropertyValue(868, (Object)new Boolean(false));
                    }
                    boolean flag = this.ShowLinksIntoCheck.isSelected();
                    this.propertyInterface.setPropertyValue(865, (Object)new Boolean(flag));
                    flag = this.ShowLinksOutOfCheck.isSelected();
                    this.propertyInterface.setPropertyValue(866, (Object)new Boolean(flag));
                    flag = this.ShowLinksAmongCheck.isSelected();
                    this.propertyInterface.setPropertyValue(867, (Object)new Boolean(flag));
                    if (!(this.ShowLinksIntoCheck.isSelected() || this.ShowLinksOutOfCheck.isSelected() || this.ShowLinksAmongCheck.isSelected())) {
                        this.LinkArrowCheckBox.setEnabled(false);
                    } else {
                        this.LinkArrowCheckBox.setEnabled(true);
                        this.propertyInterface.setPropertyValue(862, (Object)new Boolean(this.LinkArrowCheckBox.isSelected()));
                    }
                }
            } else if (cmd.equals("intoCB")) {
                this.propertyInterface.setPropertyValue(865, (Object)new Boolean(check.isSelected()));
                boolean flag = this.ShowLinksOutOfCheck.isSelected();
                this.propertyInterface.setPropertyValue(866, (Object)new Boolean(flag));
                flag = this.ShowLinksAmongCheck.isSelected();
                this.propertyInterface.setPropertyValue(867, (Object)new Boolean(flag));
                if (!(check.isSelected() || this.ShowLinksOutOfCheck.isSelected() || this.ShowLinksAmongCheck.isSelected())) {
                    this.LinkArrowCheckBox.setEnabled(false);
                } else {
                    this.LinkArrowCheckBox.setEnabled(true);
                    this.propertyInterface.setPropertyValue(862, (Object)new Boolean(this.LinkArrowCheckBox.isSelected()));
                }
            } else if (cmd.equals("outofCB")) {
                this.propertyInterface.setPropertyValue(866, (Object)new Boolean(check.isSelected()));
                boolean flag = this.ShowLinksIntoCheck.isSelected();
                this.propertyInterface.setPropertyValue(865, (Object)new Boolean(flag));
                flag = this.ShowLinksAmongCheck.isSelected();
                this.propertyInterface.setPropertyValue(867, (Object)new Boolean(flag));
                if (!(this.ShowLinksIntoCheck.isSelected() || check.isSelected() || this.ShowLinksAmongCheck.isSelected())) {
                    this.LinkArrowCheckBox.setEnabled(false);
                } else {
                    this.LinkArrowCheckBox.setEnabled(true);
                    this.propertyInterface.setPropertyValue(862, (Object)new Boolean(this.LinkArrowCheckBox.isSelected()));
                }
            } else if (cmd.equals("amongCB")) {
                this.propertyInterface.setPropertyValue(867, (Object)new Boolean(check.isSelected()));
                boolean flag = this.ShowLinksIntoCheck.isSelected();
                this.propertyInterface.setPropertyValue(865, (Object)new Boolean(flag));
                flag = this.ShowLinksOutOfCheck.isSelected();
                this.propertyInterface.setPropertyValue(866, (Object)new Boolean(flag));
                if (!(this.ShowLinksIntoCheck.isSelected() || this.ShowLinksOutOfCheck.isSelected() || check.isSelected())) {
                    this.LinkArrowCheckBox.setEnabled(false);
                } else {
                    this.LinkArrowCheckBox.setEnabled(true);
                    this.propertyInterface.setPropertyValue(862, (Object)new Boolean(this.LinkArrowCheckBox.isSelected()));
                }
            } else if (cmd.equals("SelectLinks")) {
                this.propertyInterface.setPropertyValue(868, (Object)new Boolean(check.isSelected()));
            }
        }
    }

    @Override
    public void refreshComponents() {
        super.refreshComponents();
        this.LinkThresholdCheckBox.removeItemListener(this);
        this.LinkValueScaledCheck.removeItemListener(this);
        this.LinkArrowCheckBox.removeItemListener(this);
        this.ShowAllLinksCheck.removeItemListener(this);
        this.ShowLinksIntoCheck.removeItemListener(this);
        this.ShowLinksOutOfCheck.removeItemListener(this);
        this.ShowLinksAmongCheck.removeItemListener(this);
        this.SelectLinksCheckBox.removeItemListener(this);
        this.updateThresholdPanel();
        this.updateShowLinksPanel();
        Object value = this.propertyInterface.getPropertyValue(868);
        boolean selectLinks = value == null ? false : (Boolean)value;
        this.SelectLinksCheckBox.setSelected(selectLinks);
        boolean isEnabled = true;
        if (this.parent instanceof ConstComponent) {
            isEnabled = !((ConstComponent)this.parent).getChart().getModel().isHideLinks();
        }
        this.SelectLinksCheckBox.setEnabled(isEnabled);
        value = this.propertyInterface.getPropertyValue(862);
        boolean showArrows = false;
        if (value != null && value instanceof Boolean) {
            showArrows = (Boolean)value;
        }
        this.LinkArrowCheckBox.setSelected(showArrows);
        this.LinkThresholdCheckBox.addItemListener(this);
        this.LinkValueScaledCheck.addItemListener(this);
        this.LinkArrowCheckBox.addItemListener(this);
        this.ShowAllLinksCheck.addItemListener(this);
        this.ShowLinksIntoCheck.addItemListener(this);
        this.ShowLinksOutOfCheck.addItemListener(this);
        this.ShowLinksAmongCheck.addItemListener(this);
        this.SelectLinksCheckBox.addItemListener(this);
    }

    private void updateShowLinksPanel() {
        Object value = this.propertyInterface.getPropertyValue(864);
        boolean showAllLinks = value == null ? false : (Boolean)value;
        this.ShowAllLinksCheck.setSelected(showAllLinks);
        this.ShowAllLinksCheck.setEnabled(true);
        this.ShowLinksIntoCheck.setEnabled(!showAllLinks);
        this.ShowLinksOutOfCheck.setEnabled(!showAllLinks);
        this.ShowLinksAmongCheck.setEnabled(!showAllLinks);
    }

    public void updateThresholdPanel() {
        Object value = this.propertyInterface.getPropertyValue(861);
        boolean showThreshold = false;
        boolean supportsShowThreshold = true;
        if (value != null && value instanceof Boolean) {
            showThreshold = (Boolean)value;
        }
        this.LinkThresholdCheckBox.setSelected(showThreshold);
        value = this.propertyInterface.getPropertyValue(854);
        boolean flag = false;
        if (value != null && value instanceof Boolean) {
            flag = (Boolean)value;
        }
        if ((value = this.propertyInterface.getPropertyValue(873)) != null && value instanceof Boolean) {
            supportsShowThreshold = (Boolean)value;
        }
        if (flag && supportsShowThreshold) {
            boolean scaleLinkValues = true;
            value = this.propertyInterface.getPropertyValue(857);
            if (value != null && value instanceof Boolean) {
                scaleLinkValues = (Boolean)value;
            }
            this.LinkValueScaledCheck.setSelected(scaleLinkValues);
            this.LinkValueScaledCheck.setEnabled(showThreshold);
            value = this.propertyInterface.getPropertyValue(855);
            if (value != null && value instanceof Number) {
                this.minVal = ((Number)value).doubleValue();
            }
            if ((value = this.propertyInterface.getPropertyValue(856)) != null && value instanceof Number) {
                this.maxVal = ((Number)value).doubleValue();
            }
            if (this.maxVal == this.minVal) {
                this.maxVal = Double.POSITIVE_INFINITY;
            } else if (!(this.maxVal - this.minVal < 1.0) || !scaleLinkValues) {
                // empty if block
            }
            value = this.propertyInterface.getPropertyValue(858);
            if (value != null && value instanceof Number) {
                this.val = ((Number)value).doubleValue();
            }
            if (scaleLinkValues) {
                if (this.val < 0.0) {
                    this.val = 0.0;
                }
                this.sliderValue = (int)this.val;
            } else {
                if (this.val < this.minVal) {
                    this.val = this.minVal;
                }
                this.sliderValue = (int)((this.val - this.minVal) * 100.0 / (this.maxVal - this.minVal) + 0.5);
            }
            this.LinkThresholdCheckBox.setEnabled(true);
        } else {
            this.LinkValueScaledCheck.setEnabled(false);
            this.LinkThresholdCheckBox.setEnabled(false);
        }
    }

    private void setThreshold(boolean actOnStep) {
        if (actOnStep) {
            return;
        }
        Double val = this.LinkValueScaledCheck.isSelected() ? new Double(this.sliderValue) : new Double(this.minVal + (double)this.sliderValue * (this.maxVal - this.minVal) / 100.0);
        this.propertyInterface.setPropertyValue(858, (Object)val);
    }
}

