/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.silk.ui;

import com.sas.graphics.silk.interfaces.HeatmapPropertyInterface;
import com.sas.graphics.silk.interfaces.PropertyInterface;
import com.sas.graphics.silk.ui.TabPanelInterface;
import com.sas.graphics.silk.ui.TabbedPropertiesDialog;
import com.sas.graphics.silk.util.ColorRamp;
import com.sas.graphics.silk.util.ResourceLoader;
import com.sas.graphics.silk.util.SILKGlobal;
import com.sas.graphics.styles.RampStyleElement;
import com.sas.graphics.styles.Style;
import com.sas.util.NumericRangeSegment;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.SpinnerListModel;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class HeatmapColorPanel
extends JPanel
implements TabPanelInterface,
HeatmapPropertyInterface {
    private static final long serialVersionUID = 2526233838308737589L;
    private PropertyInterface chart;
    private static int BORDER = 8;
    private static int PANEL_WIDTH = 265;
    private static int PANEL_HEIGHT = 410;
    private static int ITEM_HEIGHT = 20;
    private static int COLOR_SELECTION_PANEL_HEIGHT = 200;
    private ColorRangePanel colorRangePanel;
    private DataValuePanel dataValuePanel;
    private ArrayList discreteList;
    private DiscreteColorItemPanel[] discretePane;
    private boolean[] invalidMin;
    private boolean[] invalidMax;
    private ArrayList continuousList;
    private ContinuousColorItemPanel[] continuousPane;
    private boolean[] invalidValue;
    private int colorRangeType;
    private static ResourceBundle rb = ResourceLoader.loadBundle((String)"com.sas.graphics.silk.ui.silk_ui_NLS");

    public HeatmapColorPanel(PropertyInterface chart) {
        this.chart = chart;
        this.setLayout(null);
        this.setSize(PANEL_WIDTH, PANEL_HEIGHT);
        this.layoutPanel();
        this.updatePanelUI(this);
    }

    public void updateColorScheme(Style style) {
        this.colorRangePanel.updateColorScheme(style);
    }

    private void updatePanelUI(JComponent comp) {
        Border b = comp.getBorder();
        if (b != null && b instanceof TitledBorder) {
            ((TitledBorder)b).setTitleFont(TabbedPropertiesDialog.dialogFont);
            ((TitledBorder)b).setTitleColor(Color.black);
        }
        int count = comp.getComponentCount();
        for (int i = 0; i < count; ++i) {
            Component c = comp.getComponent(i);
            if (c instanceof JPanel) {
                this.updatePanelUI((JComponent)c);
                continue;
            }
            c.setForeground(Color.black);
            c.setFont(TabbedPropertiesDialog.dialogFont);
        }
    }

    private void layoutPanel() {
        this.colorRangePanel = new ColorRangePanel();
        int h = ITEM_HEIGHT * 2 + BORDER * 7 + COLOR_SELECTION_PANEL_HEIGHT;
        int y = BORDER;
        this.colorRangePanel.setBounds(BORDER, y, PANEL_WIDTH - 2 * BORDER, h);
        this.colorRangePanel.layoutPanel();
        this.add(this.colorRangePanel);
        this.dataValuePanel = new DataValuePanel();
        this.dataValuePanel.setBounds(BORDER, y += h + BORDER, PANEL_WIDTH - 2 * BORDER, PANEL_HEIGHT - h - 3 * BORDER);
        this.dataValuePanel.layoutPanel();
        this.add(this.dataValuePanel);
        this.colorRangePanel.setInitialValues();
        this.dataValuePanel.setInitialValues();
        this.colorRangePanel.addListeners();
        this.dataValuePanel.addListeners();
    }

    public boolean cancelChanges() {
        this.chart.cancelPropertyChanges();
        this.colorRangePanel.setInitialValues();
        this.dataValuePanel.setInitialValues();
        return true;
    }

    public boolean applyChanges() {
        ColorRamp cr = this.createColorRamp();
        if (cr != null) {
            if (this.colorRangeType == 1) {
                this.chart.setPropertyValue(804, (Object)cr);
            } else {
                this.chart.setPropertyValue(805, (Object)cr);
            }
        }
        this.chart.applyPropertyChanges();
        this.colorRangePanel.updateColors();
        return true;
    }

    private ColorRamp createColorRamp() {
        if (this.colorRangeType == 1) {
            int size = this.discreteList.size();
            double[] b = new double[size + 1];
            Color[] c = new Color[size];
            NumericRangeSegment nrs = null;
            for (int i = 0; i < size; ++i) {
                if (this.invalidMin[i] || this.invalidMax[i]) {
                    return null;
                }
                nrs = (NumericRangeSegment)this.discreteList.get(i);
                b[i] = nrs.getMin();
                c[i] = (Color)nrs.getValue(null);
            }
            b[size] = nrs.getMax();
            return new ColorRamp((Object)c, (Object)b, 0L);
        }
        int size = this.continuousList.size();
        double[] b = new double[size];
        Color[] c = new Color[size];
        for (int i = 0; i < size; ++i) {
            if (this.invalidValue[i]) {
                return null;
            }
            Object[] obj = (Object[])this.continuousList.get(i);
            c[i] = (Color)obj[0];
            b[i] = ((Number)obj[1]).doubleValue();
        }
        return new ColorRamp((Object)c, (Object)b, 0L);
    }

    public boolean addPropertyListener(PropertyInterface prop) {
        return false;
    }

    public boolean removePropertyListener(PropertyInterface prop) {
        return false;
    }

    static /* synthetic */ DiscreteColorItemPanel[] access$602(HeatmapColorPanel x0, DiscreteColorItemPanel[] x1) {
        x0.discretePane = x1;
        return x1;
    }

    static /* synthetic */ boolean[] access$802(HeatmapColorPanel x0, boolean[] x1) {
        x0.invalidMin = x1;
        return x1;
    }

    static /* synthetic */ boolean[] access$902(HeatmapColorPanel x0, boolean[] x1) {
        x0.invalidMax = x1;
        return x1;
    }

    static /* synthetic */ ContinuousColorItemPanel[] access$1102(HeatmapColorPanel x0, ContinuousColorItemPanel[] x1) {
        x0.continuousPane = x1;
        return x1;
    }

    static /* synthetic */ boolean[] access$1302(HeatmapColorPanel x0, boolean[] x1) {
        x0.invalidValue = x1;
        return x1;
    }

    class DataValuePanel
    extends JPanel
    implements ActionListener {
        private static final long serialVersionUID = 7691090220518957826L;
        JButton missing;
        JButton outRange;
        JButton overflow;
        JButton underflow;
        JLabel missingLabel;
        JLabel outRangeLabel;
        JLabel overflowLabel;
        JLabel underflowLabel;

        DataValuePanel() {
            this.setLayout(null);
        }

        void layoutPanel() {
            int w = this.getBounds().width;
            this.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), ResourceLoader.getResourceString((Object)rb, (String)"HeatmapColorPanel.DataValues.txt", (String)"Data Values")));
            this.missingLabel = new JLabel(ResourceLoader.getResourceString((Object)rb, (String)"HeatmapColorPanel.Missing.txt", (String)"Missing:"));
            this.outRangeLabel = new JLabel(ResourceLoader.getResourceString((Object)rb, (String)"HeatmapColorPanel.OutOfRange.txt", (String)"Out-of-range:"));
            this.overflowLabel = new JLabel(ResourceLoader.getResourceString((Object)rb, (String)"HeatmapColorPanel.Overflow.txt", (String)"Overflow:"));
            this.underflowLabel = new JLabel(ResourceLoader.getResourceString((Object)rb, (String)"HeatmapColorPanel.Underflow.txt", (String)"Underflow:"));
            this.missing = new JButton();
            this.outRange = new JButton();
            this.overflow = new JButton();
            this.underflow = new JButton();
            int xi = BORDER;
            int yi = BORDER * 3;
            int wi = (int)((double)w * 0.5 - (double)ITEM_HEIGHT - (double)(BORDER * 3));
            this.missingLabel.setBounds(xi, yi, wi, ITEM_HEIGHT);
            this.missing.setBounds(xi += wi + BORDER, yi, ITEM_HEIGHT, ITEM_HEIGHT);
            this.overflowLabel.setBounds(xi += ITEM_HEIGHT + BORDER, yi, wi, ITEM_HEIGHT);
            this.overflow.setBounds(xi += wi + BORDER, yi, ITEM_HEIGHT, ITEM_HEIGHT);
            xi = BORDER;
            this.outRangeLabel.setBounds(xi, yi += ITEM_HEIGHT + BORDER, wi, ITEM_HEIGHT);
            this.outRange.setBounds(xi += wi + BORDER, yi, ITEM_HEIGHT, ITEM_HEIGHT);
            this.underflowLabel.setBounds(xi += ITEM_HEIGHT + BORDER, yi, wi, ITEM_HEIGHT);
            this.underflow.setBounds(xi += wi + BORDER, yi, ITEM_HEIGHT, ITEM_HEIGHT);
            this.add(this.missingLabel);
            this.add(this.outRangeLabel);
            this.add(this.overflowLabel);
            this.add(this.underflowLabel);
            this.add(this.missing);
            this.add(this.outRange);
            this.add(this.overflow);
            this.add(this.underflow);
        }

        void setInitialValues() {
            Color c = (Color)HeatmapColorPanel.this.chart.getPropertyValue(806);
            this.outRange.setBackground(c);
            this.outRange.setContentAreaFilled(false);
            this.outRange.setOpaque(true);
            c = (Color)HeatmapColorPanel.this.chart.getPropertyValue(813);
            this.missing.setBackground(c);
            this.missing.setContentAreaFilled(false);
            this.missing.setOpaque(true);
            c = (Color)HeatmapColorPanel.this.chart.getPropertyValue(814);
            this.underflow.setBackground(c);
            this.underflow.setContentAreaFilled(false);
            this.underflow.setOpaque(true);
            c = (Color)HeatmapColorPanel.this.chart.getPropertyValue(815);
            this.overflow.setBackground(c);
            this.overflow.setContentAreaFilled(false);
            this.overflow.setOpaque(true);
        }

        void addListeners() {
            this.missing.addActionListener(this);
            this.outRange.addActionListener(this);
            this.overflow.addActionListener(this);
            this.underflow.addActionListener(this);
        }

        void removeListeners() {
            this.missing.removeActionListener(this);
            this.outRange.removeActionListener(this);
            this.overflow.removeActionListener(this);
            this.underflow.removeActionListener(this);
        }

        void setColorRangeType(int type) {
            if (HeatmapColorPanel.this.colorRangeType == 1) {
                this.missing.setEnabled(true);
                this.outRange.setEnabled(true);
                this.overflow.setEnabled(false);
                this.underflow.setEnabled(false);
                this.missingLabel.setEnabled(true);
                this.outRangeLabel.setEnabled(true);
                this.overflowLabel.setEnabled(false);
                this.underflowLabel.setEnabled(false);
            } else {
                this.missing.setEnabled(true);
                this.outRange.setEnabled(false);
                this.overflow.setEnabled(true);
                this.underflow.setEnabled(true);
                this.missingLabel.setEnabled(true);
                this.outRangeLabel.setEnabled(false);
                this.overflowLabel.setEnabled(true);
                this.underflowLabel.setEnabled(true);
            }
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Object source = e.getSource();
            Color initColor = ((JButton)source).getBackground();
            Color newColor = JColorChooser.showDialog(this, ResourceLoader.getResourceString((Object)rb, (String)"HeatmapColorPanel.ColorChooser.txt", (String)"Color"), initColor);
            if (newColor == null) {
                newColor = initColor;
            }
            if (source == this.missing) {
                this.missing.setBackground(newColor);
                HeatmapColorPanel.this.chart.setPropertyValue(813, (Object)newColor);
            } else if (source == this.outRange) {
                this.outRange.setBackground(newColor);
                HeatmapColorPanel.this.chart.setPropertyValue(806, (Object)newColor);
            } else if (source == this.overflow) {
                this.overflow.setBackground(newColor);
                HeatmapColorPanel.this.chart.setPropertyValue(815, (Object)newColor);
            } else if (source == this.underflow) {
                this.underflow.setBackground(newColor);
                HeatmapColorPanel.this.chart.setPropertyValue(814, (Object)newColor);
            }
        }
    }

    class ContinuousColorItemPanel
    extends JPanel
    implements ActionListener,
    PropertyChangeListener {
        private static final long serialVersionUID = -484727026474017845L;
        JButton color;
        JFormattedTextField value;
        int index;

        ContinuousColorItemPanel(int idx) {
            this.index = idx;
            this.setLayout(null);
            this.color = new JButton();
            this.value = new JFormattedTextField(new DecimalFormat("#.####"));
            int x = BORDER;
            int y = BORDER;
            int textWidth = 60;
            this.color.setBounds(x, y, ITEM_HEIGHT, ITEM_HEIGHT);
            this.value.setBounds(x += ITEM_HEIGHT + BORDER * 3, y, textWidth, ITEM_HEIGHT);
            int w = x + textWidth + BORDER;
            int h = ITEM_HEIGHT + BORDER;
            this.setPreferredSize(new Dimension(w, h));
            this.add(this.color);
            this.add(this.value);
            HeatmapColorPanel.this.updatePanelUI(this);
        }

        void setColor(Color c) {
            this.color.setBackground(c);
            this.color.setContentAreaFilled(false);
            this.color.setOpaque(true);
        }

        void setValue(Number v) {
            this.value.setValue(v);
        }

        void addListeners() {
            this.color.addActionListener(this);
            this.value.addPropertyChangeListener(this);
        }

        void removeListeners() {
            this.color.removeActionListener(this);
            this.value.removePropertyChangeListener(this);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Object source = e.getSource();
            if (source == this.color) {
                Color initColor = this.color.getBackground();
                Color newColor = JColorChooser.showDialog(this, ResourceLoader.getResourceString((Object)rb, (String)"HeatmapColorPanel.ColorChooser.txt", (String)"Color"), initColor);
                if (newColor == null) {
                    newColor = initColor;
                }
                this.color.setBackground(newColor);
                ((Object[])((HeatmapColorPanel)HeatmapColorPanel.this).continuousList.get((int)this.index))[0] = newColor;
            }
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            double v0;
            Object source = e.getSource();
            if (!(source instanceof JFormattedTextField)) {
                return;
            }
            double v = ((Number)((JFormattedTextField)source).getValue()).doubleValue();
            Object[] obj = (Object[])HeatmapColorPanel.this.continuousList.get(this.index);
            ((HeatmapColorPanel)HeatmapColorPanel.this).invalidValue[this.index] = false;
            if (v < 0.0 || v > 1.0) {
                ((HeatmapColorPanel)HeatmapColorPanel.this).invalidValue[this.index] = true;
            } else if (this.index > 0 && v < (v0 = ((Number)((Object[])HeatmapColorPanel.this.continuousList.get(this.index - 1))[1]).doubleValue())) {
                ((HeatmapColorPanel)HeatmapColorPanel.this).invalidValue[this.index] = true;
            }
            if (HeatmapColorPanel.this.invalidValue[this.index]) {
                this.value.setForeground(Color.red);
            } else {
                double v1;
                this.value.setForeground(Color.black);
                obj[1] = new Double(v);
                if (this.index < HeatmapColorPanel.this.continuousList.size() - 1 && v > (v1 = ((Number)((Object[])HeatmapColorPanel.this.continuousList.get(this.index + 1))[1]).doubleValue())) {
                    ((HeatmapColorPanel)HeatmapColorPanel.this).invalidValue[this.index + 1] = true;
                    ((HeatmapColorPanel)HeatmapColorPanel.this).continuousPane[this.index + 1].value.setForeground(Color.red);
                }
            }
        }
    }

    class ContinuousColorRangePanel
    extends JPanel {
        private static final long serialVersionUID = 5541668183264159341L;
        int size;

        ContinuousColorRangePanel() {
            this.setLayout(null);
        }

        void layoutPanel() {
            if (HeatmapColorPanel.this.continuousPane != null && this.size > 0) {
                for (int i = 0; i < this.size; ++i) {
                    if (HeatmapColorPanel.this.continuousPane[i] == null) continue;
                    HeatmapColorPanel.this.continuousPane[i].removeListeners();
                    this.remove(HeatmapColorPanel.this.continuousPane[i]);
                }
            }
            this.size = HeatmapColorPanel.this.continuousList.size();
            HeatmapColorPanel.access$1102(HeatmapColorPanel.this, new ContinuousColorItemPanel[this.size]);
            HeatmapColorPanel.access$1302(HeatmapColorPanel.this, new boolean[this.size]);
            int y = 0;
            int x = 0;
            Dimension d = null;
            for (int i = 0; i < this.size; ++i) {
                ((HeatmapColorPanel)HeatmapColorPanel.this).continuousPane[i] = new ContinuousColorItemPanel(i);
                d = HeatmapColorPanel.this.continuousPane[i].getPreferredSize();
                HeatmapColorPanel.this.continuousPane[i].setBounds(x, y, d.width, d.height);
                this.add(HeatmapColorPanel.this.continuousPane[i]);
                y += d.height;
                Object[] obj = (Object[])HeatmapColorPanel.this.continuousList.get(i);
                HeatmapColorPanel.this.continuousPane[i].setColor((Color)obj[0]);
                HeatmapColorPanel.this.continuousPane[i].setValue((Number)obj[1]);
                HeatmapColorPanel.this.continuousPane[i].addListeners();
            }
            int w = d.width;
            int h = y + d.height + BORDER;
            this.setPreferredSize(new Dimension(w, h));
            this.revalidate();
            this.repaint();
        }

        void updateList(ColorRamp cr) {
            HeatmapColorPanel.this.continuousList = new ArrayList();
            Object[] breaks = cr.getBreaks();
            Color[] colors = cr.getColors();
            int len = breaks.length;
            for (int i = 0; i < len; ++i) {
                Object[] obj = new Object[]{colors[i], breaks[i]};
                HeatmapColorPanel.this.continuousList.add(obj);
            }
        }

        void updateColors() {
            for (int i = 0; i < this.size; ++i) {
                Object[] obj = (Object[])HeatmapColorPanel.this.continuousList.get(i);
                HeatmapColorPanel.this.continuousPane[i].setColor((Color)obj[0]);
            }
        }
    }

    class DiscreteColorItemPanel
    extends JPanel
    implements ActionListener,
    ItemListener,
    PropertyChangeListener {
        private static final long serialVersionUID = -3733661815857694316L;
        JButton color;
        JFormattedTextField min;
        JFormattedTextField max;
        JCheckBox minEx;
        JCheckBox maxEx;
        int index;

        DiscreteColorItemPanel(int idx) {
            this.index = idx;
            this.setLayout(null);
            this.color = new JButton();
            this.min = new JFormattedTextField(new DecimalFormat("#.####"));
            this.minEx = new JCheckBox();
            this.max = new JFormattedTextField(new DecimalFormat("#.####"));
            this.maxEx = new JCheckBox();
            JLabel to = new JLabel(ResourceLoader.getResourceString((Object)rb, (String)"HeatmapColorPanel.To.txt", (String)"to"));
            int x = BORDER;
            int y = BORDER;
            int textWidth = 42;
            int toWidth = 30;
            this.color.setBounds(x, y, ITEM_HEIGHT, ITEM_HEIGHT);
            this.min.setBounds(x += ITEM_HEIGHT + BORDER, y, textWidth, ITEM_HEIGHT);
            this.minEx.setBounds(x += textWidth + BORDER, y, ITEM_HEIGHT, ITEM_HEIGHT);
            to.setBounds(x += ITEM_HEIGHT, y, toWidth, ITEM_HEIGHT);
            to.setHorizontalAlignment(0);
            this.max.setBounds(x += toWidth, y, textWidth, ITEM_HEIGHT);
            this.maxEx.setBounds(x += textWidth + BORDER, y, ITEM_HEIGHT, ITEM_HEIGHT);
            int w = x + ITEM_HEIGHT + BORDER;
            int h = ITEM_HEIGHT + BORDER;
            this.setPreferredSize(new Dimension(w, h));
            this.add(this.color);
            this.add(this.min);
            this.add(this.minEx);
            this.add(to);
            this.add(this.max);
            this.add(this.maxEx);
            HeatmapColorPanel.this.updatePanelUI(this);
        }

        void setColor(Color c) {
            this.color.setBackground(c);
            this.color.setContentAreaFilled(false);
            this.color.setOpaque(true);
        }

        void setMin(double v) {
            this.min.setValue(new Double(v));
        }

        void setMax(double v) {
            this.max.setValue(new Double(v));
        }

        void setMinExclude(boolean ex) {
            this.minEx.setSelected(ex);
        }

        void setMaxExclude(boolean ex) {
            this.maxEx.setSelected(ex);
        }

        void addListeners() {
            this.color.addActionListener(this);
            this.minEx.addItemListener(this);
            this.maxEx.addItemListener(this);
            this.min.addPropertyChangeListener(this);
            this.max.addPropertyChangeListener(this);
        }

        void removeListeners() {
            this.color.removeActionListener(this);
            this.minEx.removeItemListener(this);
            this.maxEx.removeItemListener(this);
            this.min.removePropertyChangeListener(this);
            this.max.removePropertyChangeListener(this);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Object source = e.getSource();
            if (source == this.color) {
                Color initColor = this.color.getBackground();
                Color newColor = JColorChooser.showDialog(this, ResourceLoader.getResourceString((Object)rb, (String)"HeatmapColorPanel.ColorChooser.txt", (String)"Color"), initColor);
                if (newColor == null) {
                    newColor = initColor;
                }
                this.color.setBackground(newColor);
                ((NumericRangeSegment)HeatmapColorPanel.this.discreteList.get(this.index)).setValue((Object)newColor);
            }
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            Object source = e.getSource();
            boolean on = e.getStateChange() == 1;
            NumericRangeSegment nrs = (NumericRangeSegment)HeatmapColorPanel.this.discreteList.get(this.index);
            if (source == this.minEx) {
                nrs.setMinExclude(!on);
            } else if (source == this.maxEx) {
                nrs.setMaxExclude(!on);
            }
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            Object source = e.getSource();
            if (!(source instanceof JFormattedTextField)) {
                return;
            }
            double v = ((Number)((JFormattedTextField)source).getValue()).doubleValue();
            NumericRangeSegment nrs = (NumericRangeSegment)HeatmapColorPanel.this.discreteList.get(this.index);
            if (source == this.min) {
                NumericRangeSegment nrs0;
                ((HeatmapColorPanel)HeatmapColorPanel.this).invalidMin[this.index] = false;
                if (v < 0.0 || v > 1.0) {
                    ((HeatmapColorPanel)HeatmapColorPanel.this).invalidMin[this.index] = true;
                } else if (this.index > 0 && v < (nrs0 = (NumericRangeSegment)HeatmapColorPanel.this.discreteList.get(this.index - 1)).getMax()) {
                    ((HeatmapColorPanel)HeatmapColorPanel.this).invalidMin[this.index] = true;
                }
                if (HeatmapColorPanel.this.invalidMin[this.index]) {
                    this.min.setForeground(Color.red);
                } else {
                    this.min.setForeground(Color.black);
                    nrs.setMin(v);
                    if (v > nrs.getMax()) {
                        ((HeatmapColorPanel)HeatmapColorPanel.this).invalidMax[this.index] = true;
                        this.max.setForeground(Color.red);
                    }
                }
            } else if (source == this.max) {
                ((HeatmapColorPanel)HeatmapColorPanel.this).invalidMax[this.index] = false;
                if (v < 0.0 || v > 1.0) {
                    ((HeatmapColorPanel)HeatmapColorPanel.this).invalidMax[this.index] = true;
                } else if (v < nrs.getMin()) {
                    ((HeatmapColorPanel)HeatmapColorPanel.this).invalidMax[this.index] = true;
                }
                if (HeatmapColorPanel.this.invalidMax[this.index]) {
                    this.max.setForeground(Color.red);
                } else {
                    NumericRangeSegment nrs1;
                    this.max.setForeground(Color.black);
                    nrs.setMax(v);
                    if (this.index < HeatmapColorPanel.this.discreteList.size() - 1 && v > (nrs1 = (NumericRangeSegment)HeatmapColorPanel.this.discreteList.get(this.index + 1)).getMin()) {
                        ((HeatmapColorPanel)HeatmapColorPanel.this).invalidMin[this.index + 1] = true;
                        ((HeatmapColorPanel)HeatmapColorPanel.this).discretePane[this.index + 1].min.setForeground(Color.red);
                    }
                }
            }
        }
    }

    class DiscreteColorRangePanel
    extends JPanel {
        private static final long serialVersionUID = -5164459121446271820L;
        int size;

        DiscreteColorRangePanel() {
            this.setLayout(null);
        }

        void layoutPanel() {
            if (HeatmapColorPanel.this.discretePane != null && this.size > 0) {
                for (int i = 0; i < this.size; ++i) {
                    if (HeatmapColorPanel.this.discretePane[i] == null) continue;
                    HeatmapColorPanel.this.discretePane[i].removeListeners();
                    this.remove(HeatmapColorPanel.this.discretePane[i]);
                }
            }
            this.size = HeatmapColorPanel.this.discreteList.size();
            HeatmapColorPanel.access$602(HeatmapColorPanel.this, new DiscreteColorItemPanel[this.size]);
            HeatmapColorPanel.access$802(HeatmapColorPanel.this, new boolean[this.size]);
            HeatmapColorPanel.access$902(HeatmapColorPanel.this, new boolean[this.size]);
            int y = 0;
            int x = 0;
            Dimension d = null;
            for (int i = 0; i < this.size; ++i) {
                ((HeatmapColorPanel)HeatmapColorPanel.this).discretePane[i] = new DiscreteColorItemPanel(i);
                d = HeatmapColorPanel.this.discretePane[i].getPreferredSize();
                HeatmapColorPanel.this.discretePane[i].setBounds(x, y, d.width, d.height);
                this.add(HeatmapColorPanel.this.discretePane[i]);
                y += d.height;
                NumericRangeSegment nrm = (NumericRangeSegment)HeatmapColorPanel.this.discreteList.get(i);
                HeatmapColorPanel.this.discretePane[i].setColor((Color)nrm.getValue(null));
                HeatmapColorPanel.this.discretePane[i].setMin(nrm.getMin());
                HeatmapColorPanel.this.discretePane[i].setMax(nrm.getMax());
                HeatmapColorPanel.this.discretePane[i].setMinExclude(nrm.getMinExclude());
                HeatmapColorPanel.this.discretePane[i].setMaxExclude(nrm.getMaxExclude());
                HeatmapColorPanel.this.discretePane[i].addListeners();
            }
            int w = d.width;
            int h = y + d.height + BORDER;
            this.setPreferredSize(new Dimension(w, h));
            this.revalidate();
            this.repaint();
        }

        void updateList(ColorRamp cr) {
            HeatmapColorPanel.this.discreteList = new ArrayList();
            Object[] breaks = cr.getBreaks();
            Color[] colors = cr.getColors();
            int len = breaks.length - 1;
            for (int i = 0; i < len; ++i) {
                double b1 = ((Number)breaks[i]).doubleValue();
                double b2 = ((Number)breaks[i + 1]).doubleValue();
                NumericRangeSegment nrs = new NumericRangeSegment(b1, b2, true, false, (Object)colors[i]);
                HeatmapColorPanel.this.discreteList.add(nrs);
            }
        }

        void updateColors() {
            for (int i = 0; i < this.size; ++i) {
                NumericRangeSegment nrm = (NumericRangeSegment)HeatmapColorPanel.this.discreteList.get(i);
                HeatmapColorPanel.this.discretePane[i].setColor((Color)nrm.getValue(null));
            }
        }
    }

    class ColorRangePanel
    extends JPanel
    implements ActionListener,
    ChangeListener {
        private static final long serialVersionUID = -9111569541818347852L;
        DiscreteColorRangePanel dcrp;
        ContinuousColorRangePanel ccrp;
        Style style;
        JScrollPane listScroller;
        SpinnerListModel dslm;
        SpinnerListModel cslm;
        JRadioButton discrete;
        JRadioButton continuous;
        JSpinner numberIntervals;

        ColorRangePanel() {
            this.setLayout(null);
        }

        void layoutPanel() {
            int height = this.getBounds().height;
            int width = this.getBounds().width;
            this.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), ResourceLoader.getResourceString((Object)rb, (String)"HeatmapColorPanel.ColorRangePanel.txt", (String)"Color Range")));
            this.discrete = new JRadioButton(ResourceLoader.getResourceString((Object)rb, (String)"HeatmapColorPanel.Discrete.txt", (String)"Discrete"));
            this.discrete.setMnemonic(68);
            this.discrete.setSelected(true);
            this.continuous = new JRadioButton(ResourceLoader.getResourceString((Object)rb, (String)"HeatmapColorPanel.Continuous.txt", (String)"Continuous"));
            this.continuous.setMnemonic(67);
            this.continuous.setSelected(false);
            ButtonGroup group = new ButtonGroup();
            group.add(this.discrete);
            group.add(this.continuous);
            int x = BORDER;
            int y = BORDER * 3;
            int w = (int)((double)width * 0.5 - (double)(2 * BORDER));
            this.discrete.setBounds(x, y, w, ITEM_HEIGHT);
            this.continuous.setBounds(x += w + BORDER, y, w, ITEM_HEIGHT);
            this.add(this.discrete);
            this.add(this.continuous);
            JLabel intervalText = new JLabel(ResourceLoader.getResourceString((Object)rb, (String)"HeatmapColorPanel.NumberOfIntervals.txt", (String)"Number of Intervals:"));
            this.numberIntervals = new JSpinner();
            this.dslm = this.createSpinnerListModel(1);
            this.cslm = this.createSpinnerListModel(2);
            x = BORDER;
            w = (int)((double)width * 0.5 - (double)(2 * BORDER));
            intervalText.setBounds(x, y += ITEM_HEIGHT + BORDER, w, ITEM_HEIGHT);
            this.numberIntervals.setBounds(x += w + BORDER, y, (int)((double)w * 0.5), ITEM_HEIGHT);
            this.add(intervalText);
            this.add(this.numberIntervals);
            this.dcrp = new DiscreteColorRangePanel();
            this.ccrp = new ContinuousColorRangePanel();
            this.listScroller = new JScrollPane();
            this.listScroller.setBounds(BORDER, y += ITEM_HEIGHT + BORDER * 2, width - 2 * BORDER, height - y - BORDER);
            this.add(this.listScroller);
        }

        SpinnerListModel createSpinnerListModel(int type) {
            int min = type == 1 ? 1 : 2;
            int max = type == 1 ? 20 : 20;
            ArrayList<Integer> al = new ArrayList<Integer>();
            for (int i = min; i <= max; ++i) {
                al.add(new Integer(i));
            }
            return new SpinnerListModel(al);
        }

        void updateColorScheme(Style sci) {
            Object[] objectArray;
            this.style = sci;
            ColorRamp cr = (ColorRamp)HeatmapColorPanel.this.chart.getPropertyValue(804);
            if (cr != null) {
                objectArray = cr.getBreaks();
            } else {
                Object[] objectArray2 = new Object[4];
                objectArray2[0] = new Double(0.0);
                objectArray2[1] = new Double(0.3333);
                objectArray2[2] = new Double(0.6666);
                objectArray = objectArray2;
                objectArray2[3] = new Double(1.0);
            }
            Object[] breaks = objectArray;
            Color[] c = new Color[breaks.length - 1];
            Color[] dc = this.style.getDataFillColors();
            for (int i = 0; i < c.length; ++i) {
                c[i] = dc[i % dc.length];
            }
            ColorRamp dcrNew = new ColorRamp((Object)c, (Object)breaks, 0L);
            HeatmapColorPanel.this.chart.setPropertyValue(804, (Object)dcrNew);
            RampStyleElement ramp = this.style.getRampStyleElement("ThreeColorRamp");
            ColorRamp ccrNew = new ColorRamp((Object)ramp.getColors(), 0.0, 1.0, 0L);
            HeatmapColorPanel.this.chart.setPropertyValue(805, (Object)ccrNew);
            if (HeatmapColorPanel.this.colorRangeType == 1) {
                this.dcrp.updateList(dcrNew);
                this.dcrp.updateColors();
            } else {
                this.ccrp.updateList(ccrNew);
                this.ccrp.updateColors();
            }
        }

        void updateColors() {
            if (HeatmapColorPanel.this.colorRangeType == 1) {
                this.dcrp.updateColors();
            } else {
                this.ccrp.updateColors();
            }
        }

        void setInitialValues() {
            this.style = (Style)SILKGlobal.getInstance().getPropertyValue(29);
            HeatmapColorPanel.this.colorRangeType = (Integer)HeatmapColorPanel.this.chart.getPropertyValue(803);
            if (HeatmapColorPanel.this.colorRangeType == 1) {
                this.discrete.setSelected(true);
                this.numberIntervals.setModel(this.dslm);
                ColorRamp cr = (ColorRamp)HeatmapColorPanel.this.chart.getPropertyValue(804);
                int intv = cr.getBreaks().length - 1;
                this.numberIntervals.setValue(new Integer(intv));
                this.dcrp.updateList(cr);
                this.dcrp.layoutPanel();
                this.listScroller.setViewportView(this.dcrp);
            } else {
                this.continuous.setSelected(true);
                this.numberIntervals.setModel(this.cslm);
                ColorRamp cr = (ColorRamp)HeatmapColorPanel.this.chart.getPropertyValue(805);
                int intv = cr.getBreaks().length;
                this.numberIntervals.setValue(new Integer(intv));
                this.ccrp.updateList(cr);
                this.ccrp.layoutPanel();
                this.listScroller.setViewportView(this.ccrp);
            }
            HeatmapColorPanel.this.dataValuePanel.setColorRangeType(HeatmapColorPanel.this.colorRangeType);
        }

        void addListeners() {
            this.discrete.addActionListener(this);
            this.continuous.addActionListener(this);
            this.numberIntervals.addChangeListener(this);
        }

        void removeListeners() {
            this.discrete.removeActionListener(this);
            this.continuous.removeActionListener(this);
            this.numberIntervals.removeChangeListener(this);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Object source = e.getSource();
            if (source == this.discrete) {
                HeatmapColorPanel.this.colorRangeType = 1;
                this.numberIntervals.setModel(this.dslm);
                ColorRamp cr = (ColorRamp)HeatmapColorPanel.this.chart.getPropertyValue(804);
                int intv = cr == null ? 3 : cr.getBreaks().length - 1;
                this.numberIntervals.setValue(new Integer(intv));
                if (cr != null) {
                    this.dcrp.updateList(cr);
                    this.dcrp.layoutPanel();
                }
                this.listScroller.setViewportView(this.dcrp);
            } else if (source == this.continuous) {
                HeatmapColorPanel.this.colorRangeType = 2;
                this.numberIntervals.setModel(this.cslm);
                ColorRamp cr = (ColorRamp)HeatmapColorPanel.this.chart.getPropertyValue(805);
                int intv = cr == null ? 3 : cr.getBreaks().length;
                this.numberIntervals.setValue(new Integer(intv));
                if (cr != null) {
                    this.ccrp.updateList(cr);
                    this.ccrp.layoutPanel();
                }
                this.listScroller.setViewportView(this.ccrp);
            }
            HeatmapColorPanel.this.dataValuePanel.setColorRangeType(HeatmapColorPanel.this.colorRangeType);
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            Object source = e.getSource();
            if (source == this.numberIntervals) {
                int intv = (Integer)this.numberIntervals.getValue();
                if (HeatmapColorPanel.this.colorRangeType == 1) {
                    Color[] dc = this.style.getDataFillColors();
                    Color[] c = new Color[intv];
                    double[] d = new double[intv + 1];
                    double delta = 1.0 / (double)intv;
                    for (int i = 0; i < intv; ++i) {
                        c[i] = dc[i % dc.length];
                        d[i] = 0.0 + (double)i * delta;
                    }
                    d[intv] = 1.0;
                    ColorRamp cr = new ColorRamp((Object)c, (Object)d, 0L);
                    this.dcrp.updateList(cr);
                    this.dcrp.layoutPanel();
                } else {
                    ColorRamp cr;
                    if (intv <= 2) {
                        RampStyleElement ramp = this.style.getRampStyleElement("TwoColorAltRamp");
                        cr = new ColorRamp((Object)ramp.getColors(), 0.0, 1.0, 0L);
                    } else if (intv == 3) {
                        RampStyleElement ramp = this.style.getRampStyleElement("ThreeColorRamp");
                        cr = new ColorRamp((Object)ramp.getColors(), 0.0, 1.0, 0L);
                    } else {
                        Color[] dc = this.style.getDataFillColors();
                        Color[] c = new Color[intv];
                        double[] d = new double[intv];
                        double delta = 1.0 / (double)(intv - 1);
                        for (int i = 0; i < intv; ++i) {
                            c[i] = dc[i % dc.length];
                            d[i] = 0.0 + (double)i * delta;
                        }
                        cr = new ColorRamp((Object)c, (Object)d, 0L);
                    }
                    this.ccrp.updateList(cr);
                    this.ccrp.layoutPanel();
                }
            }
        }
    }
}

