/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.silk.ui;

import com.sas.graphics.silk.interfaces.DendrogramPropertyInterface;
import com.sas.graphics.silk.interfaces.PropertyInterface;
import com.sas.graphics.silk.ui.TabPanelInterface;
import com.sas.graphics.silk.ui.TabbedPropertiesDialog;
import com.sas.graphics.silk.util.ResourceLoader;
import com.sas.text.Message;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class DendrogramPanel
extends JPanel
implements TabPanelInterface,
DendrogramPropertyInterface,
ChangeListener,
ItemListener,
ActionListener {
    private static final long serialVersionUID = 8577444752463803787L;
    private PropertyInterface chart;
    private static int BORDER = 8;
    private static int PANEL_WIDTH = 265;
    private static int PANEL_HEIGHT = 410;
    private static int ITEM_HEIGHT = 20;
    private JSlider width;
    private JLabel widthValue;
    private ColorPanel color;
    private JButton colorB;
    private JCheckBox fisheyeView;
    private Color GRAYOUT;
    private static ResourceBundle rb = ResourceLoader.loadBundle((String)"com.sas.graphics.silk.dendrogram.dendrogram_NLS");

    public DendrogramPanel(PropertyInterface chart) {
        this.chart = chart;
        this.setLayout(null);
        this.setSize(PANEL_WIDTH, PANEL_HEIGHT);
        this.layoutPanel();
        this.updatePanelUI(this);
        this.setInitialValues();
        this.addListeners();
        this.GRAYOUT = this.getBackground().darker();
    }

    private void updatePanelUI(JComponent comp) {
        Border b = comp.getBorder();
        if (b != null && b instanceof TitledBorder) {
            ((TitledBorder)b).setTitleFont(TabbedPropertiesDialog.dialogFont);
            ((TitledBorder)b).setTitleColor(Color.black);
        } else if (b != null && b instanceof CompoundBorder && ((CompoundBorder)b).getInsideBorder() instanceof TitledBorder) {
            ((TitledBorder)((CompoundBorder)b).getInsideBorder()).setTitleFont(TabbedPropertiesDialog.dialogFont);
            ((TitledBorder)((CompoundBorder)b).getInsideBorder()).setTitleColor(Color.black);
        }
        int count = comp.getComponentCount();
        for (int i = 0; i < count; ++i) {
            Component c = comp.getComponent(i);
            if (c instanceof JPanel) {
                this.updatePanelUI((JComponent)c);
                continue;
            }
            c.setForeground(Color.black);
            c.setFont(TabbedPropertiesDialog.dialogFont);
        }
    }

    private void layoutPanel() {
        this.setLayout(null);
        JPanel fisheyePanel = this.makeFisheyeViewPanel();
        JPanel nodePanel = this.makeNodePanel();
        fisheyePanel.setBounds(BORDER, BORDER, PANEL_WIDTH, ITEM_HEIGHT * 3 + BORDER);
        int h = ITEM_HEIGHT * 3 + BORDER;
        nodePanel.setBounds(BORDER, BORDER + h + BORDER, PANEL_WIDTH, ITEM_HEIGHT * 6 + BORDER);
        this.add(fisheyePanel);
        this.add(nodePanel);
    }

    private JPanel makeNodePanel() {
        JPanel pan = new JPanel();
        pan.setLayout(null);
        Insets margin = new Insets(BORDER, BORDER, BORDER, BORDER);
        Border b1 = BorderFactory.createEmptyBorder(margin.top, margin.left, margin.bottom, margin.right);
        TitledBorder b2 = BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), ResourceLoader.getResourceString((Object)rb, (String)"DendrogramPanel.Node.txt", (String)"Node"));
        pan.setBorder(BorderFactory.createCompoundBorder(b1, b2));
        JLabel widthLabel = new JLabel(ResourceLoader.getResourceString((Object)rb, (String)"DendrogramPanel.Width.txt", (String)"Width:"));
        this.widthValue = new JLabel();
        this.width = new JSlider();
        this.width.setMinimum(1);
        this.width.setMaximum(10);
        this.color = new ColorPanel(Color.black);
        this.colorB = new JButton(ResourceLoader.getResourceString((Object)rb, (String)"DendrogramPanel.Etc.txt", (String)"..."));
        JLabel colorLabel = new JLabel(ResourceLoader.getResourceString((Object)rb, (String)"DendrogramPanel.Color.txt", (String)"Color:"));
        int x = margin.left + BORDER;
        int y = margin.top + ITEM_HEIGHT;
        int labelWidth = 50;
        int valueWidth = 40;
        int buttonWidth = ITEM_HEIGHT;
        int w = PANEL_WIDTH - margin.left - margin.right - BORDER * 2;
        widthLabel.setBounds(x, y, labelWidth, ITEM_HEIGHT);
        this.widthValue.setBounds(x += labelWidth, y, valueWidth, ITEM_HEIGHT);
        this.width.setBounds(x += valueWidth, y, w - labelWidth - valueWidth, ITEM_HEIGHT);
        x = margin.left + BORDER;
        colorLabel.setBounds(x, y += ITEM_HEIGHT + ITEM_HEIGHT, labelWidth, ITEM_HEIGHT);
        this.color.setBounds(x += labelWidth + valueWidth, y, w - labelWidth - valueWidth - buttonWidth, ITEM_HEIGHT);
        this.colorB.setBounds(x += w - labelWidth - valueWidth - buttonWidth, y, buttonWidth, ITEM_HEIGHT);
        pan.add(widthLabel);
        pan.add(this.widthValue);
        pan.add(this.width);
        pan.add(colorLabel);
        pan.add(this.color);
        pan.add(this.colorB);
        return pan;
    }

    private JPanel makeFisheyeViewPanel() {
        JPanel pan = new JPanel();
        pan.setLayout(null);
        Insets margin = new Insets(BORDER, BORDER, BORDER, BORDER);
        JLabel fisheyeLabel = new JLabel(ResourceLoader.getResourceString((Object)rb, (String)"DendrogramPanel.FisheyeView.txt", (String)"Fisheye View"));
        this.fisheyeView = new JCheckBox();
        int x = margin.left + BORDER;
        int y = margin.top + ITEM_HEIGHT;
        int labelWidth = 50;
        int w = PANEL_WIDTH - margin.left - margin.right - BORDER * 2;
        this.fisheyeView.setBounds(x, y, labelWidth, ITEM_HEIGHT);
        fisheyeLabel.setBounds(x += labelWidth, y, w - labelWidth, ITEM_HEIGHT);
        pan.add(this.fisheyeView);
        pan.add(fisheyeLabel);
        return pan;
    }

    private void addListeners() {
        this.width.addChangeListener(this);
        this.fisheyeView.addItemListener(this);
        this.colorB.addActionListener(this);
    }

    private void setInitialValues() {
        boolean fisheye = (Boolean)this.chart.getPropertyValue(801);
        this.fisheyeView.setSelected(fisheye);
        int w = (Integer)this.chart.getPropertyValue(803);
        this.width.setValue(w);
        this.widthValue.setText(this.getValueLable(w, false));
        this.color.setColor((Color)this.chart.getPropertyValue(802));
    }

    private String getValueLable(int i, boolean percent) {
        Message message = percent ? new Message(ResourceLoader.getResourceString((Object)rb, (String)"DendrogramPanel.PercentValueLabel.fmt.txt", (String)"({0}%)")) : new Message(ResourceLoader.getResourceString((Object)rb, (String)"DendrogramPanel.ValueLabel.fmt.txt", (String)"({0})"));
        String lab = Integer.toString(i);
        return message.toString((Object)lab);
    }

    public boolean cancelChanges() {
        this.setInitialValues();
        this.chart.cancelPropertyChanges();
        return true;
    }

    public boolean applyChanges() {
        this.chart.applyPropertyChanges();
        return true;
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        Object source = evt.getSource();
        if (source == this.colorB) {
            Color initColor = this.color.getColor();
            Color newColor = JColorChooser.showDialog(this, ResourceLoader.getResourceString((Object)rb, (String)"DendrogramPanel.ColorChooser.txt", (String)"Color"), initColor);
            if (newColor == null) {
                newColor = initColor;
            }
            this.color.setColor(newColor);
            this.chart.setPropertyValue(802, (Object)newColor);
        }
    }

    @Override
    public void stateChanged(ChangeEvent evt) {
        Object source = evt.getSource();
        if (source == this.width) {
            int w = this.width.getValue();
            this.widthValue.setText(this.getValueLable(w, false));
            this.chart.setPropertyValue(803, (Object)new Integer(w));
        }
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        boolean sel;
        Object source = e.getSource();
        boolean bl = sel = e.getStateChange() == 1;
        if (source == this.fisheyeView) {
            this.chart.setPropertyValue(801, (Object)new Boolean(sel));
        }
    }

    public boolean addPropertyListener(PropertyInterface prop) {
        return false;
    }

    public boolean removePropertyListener(PropertyInterface prop) {
        return false;
    }

    class ColorPanel
    extends JPanel {
        private static final long serialVersionUID = 3273445470687429769L;
        Color color;
        boolean enabled = true;

        ColorPanel(Color c) {
            this.color = c;
            this.setBackground(Color.white);
            Border inBorder = BorderFactory.createLineBorder(new Color(128, 128, 128), 2);
            Border outBorder = BorderFactory.createEtchedBorder();
            this.setBorder(BorderFactory.createCompoundBorder(outBorder, inBorder));
        }

        Color getColor() {
            return this.color;
        }

        void setColor(Color c) {
            this.color = c;
            this.repaint();
        }

        @Override
        protected void paintComponent(Graphics g) {
            if (this.enabled) {
                g.setColor(this.color);
            } else {
                g.setColor(DendrogramPanel.this.GRAYOUT);
            }
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
        }

        @Override
        public void setEnabled(boolean on) {
            this.enabled = on;
        }
    }
}

