/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.silk.ui;

import com.sas.graphics.silk.ui.UIUtilities;
import com.sas.graphics.silk.util.SILKChartFlavor;
import com.sas.graphics.tools.wizard.ChartCategory;
import com.sas.graphics.tools.wizard.GraphWizard;
import com.sas.graphics.tools.wizard.WizardEntry;
import com.sas.graphics.util.FontManager;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.InputStream;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.border.Border;

public class ComponentPaletteToolbar
extends JTabbedPane
implements DragGestureListener {
    private static final long serialVersionUID = -346301505735123815L;
    Object dataSource = null;
    DragSource dragSource = DragSource.getDefaultDragSource();
    JPanel containerPanel = new JPanel();
    JPanel graphsPanel = new JPanel();
    JPanel tablesPanel = new JPanel();
    JPanel compositePanel = new JPanel();
    WizardEntry selectedEntry = null;
    static Border rolloverBorder = BorderFactory.createEtchedBorder();
    static Border flatBorder = BorderFactory.createEmptyBorder();

    public ComponentPaletteToolbar() {
        this.setTabPlacement(3);
        this.addTab("Containers", this.containerPanel);
        this.addTab("Graphs", this.graphsPanel);
        this.addTab("Tables", this.tablesPanel);
        this.addTab("Composite Charts", this.compositePanel);
        this.setFont(FontManager.getFont((String)"Tahoma", (int)0, (int)12));
        this.setSize(800, 60);
        this.setMaximumSize(new Dimension(600, 60));
        this.setMinimumSize(new Dimension(600, 60));
        this.setPreferredSize(new Dimension(600, 60));
    }

    @Override
    public void addNotify() {
        super.addNotify();
        Frame parent = UIUtilities.getParentFrame((Component)this);
        JFrame f = null;
        if (parent instanceof JFrame) {
            f = (JFrame)parent;
        }
        InputStream is = this.getClass().getResourceAsStream("/com/sas/graphics/silk/ui/graphwizard/PaletteCharts.xml");
        GraphWizard wizard = new GraphWizard(f, this.getCurrentData(), is);
        this.fillPanel(this.graphsPanel, wizard.getChartList());
        is = this.getClass().getResourceAsStream("/com/sas/graphics/silk/ui/graphwizard/Containers.xml");
        wizard = new GraphWizard(f, this.getCurrentData(), is);
        this.fillPanel(this.containerPanel, wizard.getChartList());
        is = this.getClass().getResourceAsStream("/com/sas/graphics/silk/ui/graphwizard/Tables.xml");
        wizard = new GraphWizard(f, this.getCurrentData(), is);
        this.fillPanel(this.tablesPanel, wizard.getChartList());
        is = this.getClass().getResourceAsStream("/com/sas/graphics/silk/ui/graphwizard/Composites.xml");
        wizard = new GraphWizard(f, this.getCurrentData(), is);
        this.fillPanel(this.compositePanel, wizard.getChartList());
    }

    private void fillPanel(JPanel panel, ChartCategory[] cc) {
        if (panel == null || cc == null) {
            return;
        }
        panel.removeAll();
        panel.setLayout(new BoxLayout(panel, 0));
        panel.setPreferredSize(new Dimension(300, 35));
        panel.add(Box.createHorizontalStrut(5));
        for (int i = 0; i < cc.length; ++i) {
            WizardEntry[] we = cc[i].getEntries();
            for (int j = 0; j < we.length; ++j) {
                WizardEntryButton b = new WizardEntryButton(we[j]);
                b.setToolTipText(we[j].getName());
                b.addMouseListener(new MouseAdapter(){

                    @Override
                    public void mousePressed(MouseEvent arg0) {
                        ComponentPaletteToolbar.this.selectedEntry = ((WizardEntryButton)arg0.getSource()).entry;
                    }
                });
                Icon img = we[j].getIcon();
                if (img == null) continue;
                b.setIcon(img);
                b.setMaximumSize(new Dimension(25, 25));
                b.setBorder(flatBorder);
                this.dragSource.createDefaultDragGestureRecognizer(b, 3, this);
                panel.add(b);
                panel.add(Box.createHorizontalStrut(5));
            }
        }
    }

    public Object getCurrentData() {
        return this.dataSource;
    }

    @Override
    public void dragGestureRecognized(DragGestureEvent dge) {
        if (this.selectedEntry == null) {
            return;
        }
        if (this.selectedEntry == null) {
            return;
        }
        this.selectedEntry.reset();
        this.selectedEntry.init(null, this.getCurrentData(), null);
        dge.startDrag(DragSource.DefaultCopyDrop, (Transferable)new SILKChartFlavor(this.selectedEntry));
    }

    public Object getDataSource() {
        return this.dataSource;
    }

    public void setDataSource(Object dataSource) {
        this.dataSource = dataSource;
    }

    public void actionPerformed(ActionEvent arg0) {
        if (arg0.getSource() instanceof WizardEntryButton) {
            this.selectedEntry = ((WizardEntryButton)arg0.getSource()).entry;
        }
    }

    class WizardEntryButton
    extends JButton {
        private static final long serialVersionUID = -8447617641751258577L;
        WizardEntry entry = null;

        public WizardEntryButton(WizardEntry w) {
            this.entry = w;
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseEntered(MouseEvent arg0) {
                    WizardEntryButton.this.setBorder(rolloverBorder);
                }

                @Override
                public void mouseExited(MouseEvent arg0) {
                    WizardEntryButton.this.setBorder(flatBorder);
                }
            });
        }
    }
}

